
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Tue Nov 30 10:19:22 2004
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version CRYS_ATP_TST_AES_Acceptance_test_vectors.c#1:csrc:1
   *  \author doronp
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */
/* disabling pc lint warning regarding to few initializers in braces :
   Too few initializers for aggregate 'unknown-name' */
/*lint --e{785} */   
   
/***************************
 * File Name:                                                           
 *  RYS_SYS_TST_AES_Acceptance_test_vectors.c       
 *
 * Description:                                                                 
 *  This file contatind the test vectors used for AES Acceptance tests                              
 *
 **************************/
 /***** Include Files ******/
#include "CRYS_ATP_TST_AES_Acceptance.h"
#if TST_USE_AES_DATA/*In case no test vectors are selected - code disabled*/
/******** Defines ********/
/******** Enums **********/
/******** Typedefs *********/
/******** Global Data ********/
/***** Private function prototype ******/
/****** **** Public Functions *****/
/******** Private Functions ******/
/*****************************/
/************** External Key Vectors  ********/
/*****************************/
TST_AES_TestDataStruct TST_AES_Acceptance_TestData[] =
{
        /************/
        /*        AES ECB vectors         */
        /************/
    #if TST_USE_AES_16BYTE_DATA
    { 
        {"Acceptance test - AES/ECB/128Key/16ByteData "},
        /*TST_Key*/
        {0x3c,0xe0,0xfe,0x74,0xcf,0xf4,0x98,0x68,0xf1,0xd6,0x59,0x24,0xf8,0x52,0x75,0x66},
        CRYS_AES_Key128BitSize,
        /*TST_IvCounter*/
        {0},
        /*TST_input_data*/
        {0xe2,0xb7,0xd6,0x90,0x4d,0xc3,0x0a,0x2d,0x11,0xf0,0x62,0xce,0x71,0x3e,0x6a,0x20},
        {0},
        /*TST_Expected_output_data for enc Input data for decrypt*/
        {0x84,0xb3,0xb3,0xc0,0xe3,0x5c,0x8f,0xaf,0x8d,0x80,0x79,0x91,0xf2,0x79,0x9b,0x47}, 
        /*TST_dataSize*/
        16*sizeof(DxUint8_t),       
        CRYS_AES_ECB_mode
    },
    #endif
    #if TST_USE_AES_64BYTE_DATA 
    { 
        {"Acceptance test - AES/ECB/128Key/64ByteData"},
        /*TST_Key*/     
        {0x2b,0x7e,0x15,0x16,0x28,0xae,0xd2,0xa6,0xab,0xf7,0x15,0x88,0x09,0xcf,0x4f,0x3c},
        CRYS_AES_Key128BitSize,
        /*TST_IvCounter*/       
        {0},
        /*TST_input_data*/
        {0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a,
         0xae,0x2d,0x8a,0x57,0x1e,0x03,0xac,0x9c,0x9e,0xb7,0x6f,0xac,0x45,0xaf,0x8e,0x51,
         0x30,0xc8,0x1c,0x46,0xa3,0x5c,0xe4,0x11,0xe5,0xfb,0xc1,0x19,0x1a,0x0a,0x52,0xef,
         0xf6,0x9f,0x24,0x45,0xdf,0x4f,0x9b,0x17,0xad,0x2b,0x41,0x7b,0xe6,0x6c,0x37,0x10},
        {0},
        /*TST_Expected_output_data for enc Input data for decrypt*/
        {0x3a,0xd7,0x7b,0xb4,0x0d,0x7a,0x36,0x60,0xa8,0x9e,0xca,0xf3,0x24,0x66,0xef,0x97,
         0xf5,0xd3,0xd5,0x85,0x03,0xb9,0x69,0x9d,0xe7,0x85,0x89,0x5a,0x96,0xfd,0xba,0xaf,
         0x43,0xb1,0xcd,0x7f,0x59,0x8e,0xce,0x23,0x88,0x1b,0x00,0xe3,0xed,0x03,0x06,0x88,
         0x7b,0x0c,0x78,0x5e,0x27,0xe8,0xad,0x3f,0x82,0x23,0x20,0x71,0x04,0x72,0x5d,0xd4}, 
        /*TST_dataSize*/
        64*sizeof(DxUint8_t),
        CRYS_AES_ECB_mode
    },  
    #endif
    #if TST_USE_AES_32BYTE_DATA
    { 
        {"Acceptance test - AES/ECB/128Key/32ByteData"},
        /*TST_Key*/     
        {0x43,0xb1,0xcd,0x7f,0x59,0x8e,0xce,0x23,0x88,0x1b,0x00,0xe3,0xed,0x03,0x06,0x88}, 
        CRYS_AES_Key128BitSize,
        /*TST_IvCounter*/       
        {0},
        /*TST_input_data*/
        {0x30,0xc8,0x1c,0x46,0xa3,0x5c,0xe4,0x11,0xe5,0xfb,0xc1,0x19,0x1a,0x0a,0x52,0xef,
         0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a},
        {0},
        /*TST_Expected_output_data for enc Input data for decrypt*/
        {0xb9,0xaf,0xfe,0xe2,0x98,0xcd,0x0f,0x4a,0x67,0x08,0x44,0xa6,0xd6,0xce,0xef,0x87,
         0xcf,0x41,0x2b,0x67,0xb3,0xad,0x95,0x18,0x94,0x4c,0x52,0x1e,0x91,0xb8,0x24,0xfc}, 
        /*TST_dataSize*/
        32*sizeof(DxUint8_t),
        CRYS_AES_ECB_mode
    },  
    #endif
    #if TST_USE_AES_512BYTE_DATA
    {
        {"Acceptance test - AES/ECB/128Key/512ByteData"},
        /*TST_Key*/     
        {0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a}, 
        CRYS_AES_Key128BitSize,
        /*TST_IvCounter*/       
        {0},
        /*TST_input_data*/
        {0x30,0xc8,0x1c,0x46,0xa3,0x5c,0xe4,0x11,0xe5,0xfb,0xc1,0x19,0x1a,0x0a,0x52,0xef,
         0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a,
         0x3a,0xd7,0x7b,0xb4,0x0d,0x7a,0x36,0x60,0xa8,0x9e,0xca,0xf3,0x24,0x66,0xef,0x97,
         0xf5,0xd3,0xd5,0x85,0x03,0xb9,0x69,0x9d,0xe7,0x85,0x89,0x5a,0x96,0xfd,0xba,0xaf,
         0x43,0xb1,0xcd,0x7f,0x59,0x8e,0xce,0x23,0x88,0x1b,0x00,0xe3,0xed,0x03,0x06,0x88,
         0x7b,0x0c,0x78,0x5e,0x27,0xe8,0xad,0x3f,0x82,0x23,0x20,0x71,0x04,0x72,0x5d,0xd4,
         0x3a,0xd7,0x7b,0xb4,0x0d,0x7a,0x36,0x60,0xa8,0x9e,0xca,0xf3,0x24,0x66,0xef,0x97,
         0xf5,0xd3,0xd5,0x85,0x03,0xb9,0x69,0x9d,0xe7,0x85,0x89,0x5a,0x96,0xfd,0xba,0xaf,
         0x30,0xc8,0x1c,0x46,0xa3,0x5c,0xe4,0x11,0xe5,0xfb,0xc1,0x19,0x1a,0x0a,0x52,0xef,
         0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a,
         0x3a,0xd7,0x7b,0xb4,0x0d,0x7a,0x36,0x60,0xa8,0x9e,0xca,0xf3,0x24,0x66,0xef,0x97,
         0xf5,0xd3,0xd5,0x85,0x03,0xb9,0x69,0x9d,0xe7,0x85,0x89,0x5a,0x96,0xfd,0xba,0xaf,
         0x43,0xb1,0xcd,0x7f,0x59,0x8e,0xce,0x23,0x88,0x1b,0x00,0xe3,0xed,0x03,0x06,0x88,
         0x7b,0x0c,0x78,0x5e,0x27,0xe8,0xad,0x3f,0x82,0x23,0x20,0x71,0x04,0x72,0x5d,0xd4,
         0x3a,0xd7,0x7b,0xb4,0x0d,0x7a,0x36,0x60,0xa8,0x9e,0xca,0xf3,0x24,0x66,0xef,0x97,
         0xf5,0xd3,0xd5,0x85,0x03,0xb9,0x69,0x9d,0xe7,0x85,0x89,0x5a,0x96,0xfd,0xba,0xaf,
         0x30,0xc8,0x1c,0x46,0xa3,0x5c,0xe4,0x11,0xe5,0xfb,0xc1,0x19,0x1a,0x0a,0x52,0xef,
         0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a,
         0x3a,0xd7,0x7b,0xb4,0x0d,0x7a,0x36,0x60,0xa8,0x9e,0xca,0xf3,0x24,0x66,0xef,0x97,
         0xf5,0xd3,0xd5,0x85,0x03,0xb9,0x69,0x9d,0xe7,0x85,0x89,0x5a,0x96,0xfd,0xba,0xaf,
         0x43,0xb1,0xcd,0x7f,0x59,0x8e,0xce,0x23,0x88,0x1b,0x00,0xe3,0xed,0x03,0x06,0x88,
         0x7b,0x0c,0x78,0x5e,0x27,0xe8,0xad,0x3f,0x82,0x23,0x20,0x71,0x04,0x72,0x5d,0xd4,
         0x3a,0xd7,0x7b,0xb4,0x0d,0x7a,0x36,0x60,0xa8,0x9e,0xca,0xf3,0x24,0x66,0xef,0x97,
         0xf5,0xd3,0xd5,0x85,0x03,0xb9,0x69,0x9d,0xe7,0x85,0x89,0x5a,0x96,0xfd,0xba,0xaf,
         0x30,0xc8,0x1c,0x46,0xa3,0x5c,0xe4,0x11,0xe5,0xfb,0xc1,0x19,0x1a,0x0a,0x52,0xef,
         0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a,
         0x3a,0xd7,0x7b,0xb4,0x0d,0x7a,0x36,0x60,0xa8,0x9e,0xca,0xf3,0x24,0x66,0xef,0x97,
         0xf5,0xd3,0xd5,0x85,0x03,0xb9,0x69,0x9d,0xe7,0x85,0x89,0x5a,0x96,0xfd,0xba,0xaf,
         0x43,0xb1,0xcd,0x7f,0x59,0x8e,0xce,0x23,0x88,0x1b,0x00,0xe3,0xed,0x03,0x06,0x88,
         0x7b,0x0c,0x78,0x5e,0x27,0xe8,0xad,0x3f,0x82,0x23,0x20,0x71,0x04,0x72,0x5d,0xd4,
         0x3a,0xd7,0x7b,0xb4,0x0d,0x7a,0x36,0x60,0xa8,0x9e,0xca,0xf3,0x24,0x66,0xef,0x97,
         0xf5,0xd3,0xd5,0x85,0x03,0xb9,0x69,0x9d,0xe7,0x85,0x89,0x5a,0x96,0xfd,0xba,0xaf},
        {0},
        /*TST_Expected_output_data for enc Input data for decrypt*/
        {0x0d,0x24,0x18,0xf6,0xd4,0x56,0xdb,0xcd,0x12,0xa6,0x50,0x54,0x3f,0xce,0x10,0xe8,
         0xe8,0x4b,0x68,0x22,0xd7,0x21,0xfd,0xa5,0xdb,0xf8,0x02,0x07,0x9b,0x89,0xe3,0x97,
         0x53,0xb5,0xf8,0xc0,0xa6,0x9c,0xc4,0xac,0xf5,0xcf,0xfd,0x7f,0x74,0x5b,0x15,0xcf,
         0x1d,0x28,0x3a,0x8f,0x43,0xcf,0x5b,0xc3,0x21,0x98,0xee,0x88,0xd4,0x46,0xca,0xab,
         0x12,0x8c,0x00,0xae,0x07,0x83,0x59,0xf0,0x77,0x89,0x2c,0x22,0xc3,0x41,0x4a,0xa8,
         0xbc,0x6a,0xfe,0x5d,0x42,0x90,0x6e,0x39,0x1b,0x78,0x45,0xb5,0x51,0xe0,0xb7,0x45,
         0x53,0xb5,0xf8,0xc0,0xa6,0x9c,0xc4,0xac,0xf5,0xcf,0xfd,0x7f,0x74,0x5b,0x15,0xcf,
         0x1d,0x28,0x3a,0x8f,0x43,0xcf,0x5b,0xc3,0x21,0x98,0xee,0x88,0xd4,0x46,0xca,0xab,
         0x0d,0x24,0x18,0xf6,0xd4,0x56,0xdb,0xcd,0x12,0xa6,0x50,0x54,0x3f,0xce,0x10,0xe8,
         0xe8,0x4b,0x68,0x22,0xd7,0x21,0xfd,0xa5,0xdb,0xf8,0x02,0x07,0x9b,0x89,0xe3,0x97,
         0x53,0xb5,0xf8,0xc0,0xa6,0x9c,0xc4,0xac,0xf5,0xcf,0xfd,0x7f,0x74,0x5b,0x15,0xcf,
         0x1d,0x28,0x3a,0x8f,0x43,0xcf,0x5b,0xc3,0x21,0x98,0xee,0x88,0xd4,0x46,0xca,0xab,
         0x12,0x8c,0x00,0xae,0x07,0x83,0x59,0xf0,0x77,0x89,0x2c,0x22,0xc3,0x41,0x4a,0xa8,
         0xbc,0x6a,0xfe,0x5d,0x42,0x90,0x6e,0x39,0x1b,0x78,0x45,0xb5,0x51,0xe0,0xb7,0x45,
         0x53,0xb5,0xf8,0xc0,0xa6,0x9c,0xc4,0xac,0xf5,0xcf,0xfd,0x7f,0x74,0x5b,0x15,0xcf,
         0x1d,0x28,0x3a,0x8f,0x43,0xcf,0x5b,0xc3,0x21,0x98,0xee,0x88,0xd4,0x46,0xca,0xab,
         0x0d,0x24,0x18,0xf6,0xd4,0x56,0xdb,0xcd,0x12,0xa6,0x50,0x54,0x3f,0xce,0x10,0xe8,
         0xe8,0x4b,0x68,0x22,0xd7,0x21,0xfd,0xa5,0xdb,0xf8,0x02,0x07,0x9b,0x89,0xe3,0x97,
         0x53,0xb5,0xf8,0xc0,0xa6,0x9c,0xc4,0xac,0xf5,0xcf,0xfd,0x7f,0x74,0x5b,0x15,0xcf,
         0x1d,0x28,0x3a,0x8f,0x43,0xcf,0x5b,0xc3,0x21,0x98,0xee,0x88,0xd4,0x46,0xca,0xab,
         0x12,0x8c,0x00,0xae,0x07,0x83,0x59,0xf0,0x77,0x89,0x2c,0x22,0xc3,0x41,0x4a,0xa8,
         0xbc,0x6a,0xfe,0x5d,0x42,0x90,0x6e,0x39,0x1b,0x78,0x45,0xb5,0x51,0xe0,0xb7,0x45,
         0x53,0xb5,0xf8,0xc0,0xa6,0x9c,0xc4,0xac,0xf5,0xcf,0xfd,0x7f,0x74,0x5b,0x15,0xcf,
         0x1d,0x28,0x3a,0x8f,0x43,0xcf,0x5b,0xc3,0x21,0x98,0xee,0x88,0xd4,0x46,0xca,0xab,
         0x0d,0x24,0x18,0xf6,0xd4,0x56,0xdb,0xcd,0x12,0xa6,0x50,0x54,0x3f,0xce,0x10,0xe8,
         0xe8,0x4b,0x68,0x22,0xd7,0x21,0xfd,0xa5,0xdb,0xf8,0x02,0x07,0x9b,0x89,0xe3,0x97,
         0x53,0xb5,0xf8,0xc0,0xa6,0x9c,0xc4,0xac,0xf5,0xcf,0xfd,0x7f,0x74,0x5b,0x15,0xcf,
         0x1d,0x28,0x3a,0x8f,0x43,0xcf,0x5b,0xc3,0x21,0x98,0xee,0x88,0xd4,0x46,0xca,0xab,
         0x12,0x8c,0x00,0xae,0x07,0x83,0x59,0xf0,0x77,0x89,0x2c,0x22,0xc3,0x41,0x4a,0xa8,
         0xbc,0x6a,0xfe,0x5d,0x42,0x90,0x6e,0x39,0x1b,0x78,0x45,0xb5,0x51,0xe0,0xb7,0x45,
         0x53,0xb5,0xf8,0xc0,0xa6,0x9c,0xc4,0xac,0xf5,0xcf,0xfd,0x7f,0x74,0x5b,0x15,0xcf,
         0x1d,0x28,0x3a,0x8f,0x43,0xcf,0x5b,0xc3,0x21,0x98,0xee,0x88,0xd4,0x46,0xca,0xab}, 
        /*TST_dataSize*/
        512*sizeof(DxUint8_t),
        CRYS_AES_ECB_mode
    },
    #endif
    #if TST_USE_AES_1536BYTE_DATA
    {
        {"Acceptance test - AES/ECB/128Key/1536ByteData"},
        /*TST_Key*/     
        {0xda,0xd8,0x8c,0x9a,0x60,0xed,0x9d,0xb5,0x68,0x0e,0xcc,0xb1,0x12,0x6f,0xcb,0x8c}, 
        CRYS_AES_Key128BitSize,
        /*TST_IvCounter*/       
        {0},
        /*TST_input_data*/
        {0x12,0xa8,0xb2,0x61,0x5d,0x01,0x3b,0x47,0x65,0xf6,0x72,0xa3,0x97,0xd5,0xbc,0x50,
         0x2c,0x7e,0xc9,0x50,0xf2,0x17,0x77,0x1b,0x50,0x01,0xf4,0x37,0x84,0x0a,0x23,0x09,
         0x30,0xe4,0x42,0xeb,0x15,0xd6,0xc9,0x7f,0x1e,0xb1,0x95,0x42,0xa0,0x06,0x45,0x64,
         0xe0,0x96,0xe5,0xd7,0xd6,0x0a,0xca,0xa6,0x30,0xe4,0xbc,0x88,0x9a,0xb6,0x5b,0xb5,
         0x3d,0x91,0xbb,0xf8,0x85,0xc1,0x52,0x05,0x28,0xb7,0x14,0x0e,0x64,0x47,0xdc,0x91,
         0x88,0x14,0x0e,0x74,0xb5,0x48,0x7a,0x53,0xe6,0x88,0x84,0x19,0x2e,0x27,0x82,0xcd,
         0x41,0x99,0x66,0xaf,0x36,0x2b,0x9d,0x84,0x8b,0xf2,0x37,0x2e,0x6a,0x01,0x47,0x7f,
         0x2a,0xdf,0x8d,0x4f,0x19,0x39,0x52,0xcc,0x79,0xd3,0x94,0x12,0xc8,0xc4,0x63,0xfc,
         0x45,0xe3,0x8b,0x39,0xaf,0x7d,0x73,0xa2,0x50,0x49,0x45,0xca,0x3a,0x9d,0x4f,0xd7,
         0xd1,0xe1,0xaa,0x91,0x89,0x45,0x19,0xb9,0xf1,0xaf,0x33,0x9c,0xf1,0xf7,0xc5,0xe8,
         0x4f,0x57,0x72,0xbd,0x78,0x1d,0x9c,0x07,0x7e,0xa3,0x88,0x0c,0x5d,0x81,0xbc,0x41,
         0x82,0x01,0xac,0x62,0x8e,0xd4,0x96,0xc1,0x57,0x03,0xab,0xdf,0x2f,0x28,0x6f,0x39,
         0x6a,0xdd,0x62,0x64,0x1a,0x75,0xe0,0x5c,0x1d,0xea,0x46,0x1a,0x5a,0x17,0x56,0x64,
         0x47,0x27,0xdd,0xe9,0xaf,0x4e,0x92,0x8d,0xb2,0xb7,0x42,0x02,0x0d,0xbd,0x2a,0x98,
         0x9b,0x5d,0xa5,0x56,0x1c,0xeb,0x07,0x49,0x36,0x05,0xc8,0x1c,0xb9,0xc6,0xe5,0xe9,
         0x27,0x3b,0x83,0x4f,0x74,0x1b,0xd5,0xc5,0x0a,0xb2,0x41,0x2d,0x10,0x1f,0xbe,0xad,
         0xec,0xbf,0x81,0xba,0x06,0xe9,0xd8,0x75,0xcf,0xdc,0x56,0x3b,0x03,0xf5,0x30,0x77,
         0x2b,0x26,0xe7,0xbb,0x65,0xa3,0x27,0x10,0x67,0xde,0xf0,0x8a,0xc2,0xb6,0xf3,0x1f,
         0x64,0xeb,0x3f,0xb8,0x61,0xd6,0x1c,0x89,0xf3,0x57,0x37,0x9e,0xbf,0x0e,0x00,0xb7,
         0x59,0xce,0x51,0x56,0x0b,0x4e,0x50,0x16,0xd2,0x22,0x96,0x3e,0xaa,0xea,0x91,0x96,
         0x0b,0xca,0x26,0x7a,0xb4,0x1a,0x9b,0x2c,0xa7,0x5e,0xb5,0x6f,0x75,0x78,0x1d,0x51,
         0xbb,0x1c,0x08,0x48,0xed,0x85,0x17,0x80,0x52,0x66,0x7c,0x74,0x50,0x24,0x5f,0xbc,
         0xea,0x42,0x80,0x25,0x87,0x1d,0x1d,0x07,0xf5,0xd9,0x16,0xd3,0xad,0x9b,0x4f,0xec,
         0x59,0xf8,0x56,0xb8,0x93,0xae,0x46,0xf6,0xf0,0x92,0xeb,0x52,0x3d,0xca,0x26,0x36,
         0x08,0x3c,0x93,0xe4,0x63,0x46,0x6a,0xc2,0xe4,0xb0,0xa3,0xf4,0xf0,0xdf,0x5e,0x30,
         0x39,0x4b,0x81,0xce,0x86,0x33,0xa3,0x1f,0xb3,0x8f,0x29,0x00,0xf8,0x46,0xae,0xaf,
         0x6e,0xa1,0xa9,0xdd,0xce,0xff,0x49,0x04,0x7c,0xcb,0xa4,0xfa,0xc5,0xac,0x11,0xc7,
         0x65,0xfb,0xd2,0xb4,0x4d,0x7a,0xf7,0xa4,0xa3,0x43,0x7e,0xa7,0x09,0xfe,0xbf,0xcd,
         0x22,0x57,0x08,0x38,0x52,0xb0,0x84,0x75,0xc6,0x12,0x61,0x0d,0xb5,0x6a,0x31,0x56,
         0xe5,0xf2,0x91,0x8f,0x70,0xed,0x09,0x2c,0xc8,0x97,0x34,0x6f,0xf9,0x5c,0x21,0x38,
         0x2e,0x48,0xf8,0x1e,0x77,0xbf,0xe1,0xbe,0xc9,0x6e,0x21,0x53,0x47,0x81,0x86,0x88,
         0xbf,0x16,0x06,0x8a,0x78,0xf2,0xa3,0x60,0x2b,0x73,0x92,0x7f,0x4f,0xc6,0x9b,0x99,
         0x99,0x5a,0xc3,0xb7,0xc4,0x95,0x29,0x87,0x8e,0xc5,0x2e,0xf7,0x03,0x59,0xd8,0x02,
         0xfd,0x51,0x79,0xca,0xec,0xf3,0x8b,0xe8,0xd3,0xc0,0xdf,0x00,0x93,0xa6,0xf7,0x98,
         0x6c,0x77,0xb0,0x2a,0xc1,0x9a,0x23,0x77,0x1b,0x01,0xce,0x1f,0x71,0x5a,0xef,0x6f,
         0xa7,0x8a,0x31,0x7a,0x54,0x57,0x8a,0x6b,0xc8,0x64,0x64,0x19,0x4e,0x63,0xfb,0xdc,
         0xae,0x86,0x06,0xa0,0xf6,0x36,0x99,0x37,0x7a,0x08,0x4a,0xf4,0x1a,0xed,0x93,0x75,
         0xc3,0xa9,0x77,0xc0,0x39,0x86,0x68,0x92,0x13,0x49,0x69,0xf3,0x07,0x65,0x70,0x0e,
         0x67,0x6f,0x0e,0x40,0xec,0xd2,0x51,0x6f,0xb3,0xc4,0xea,0x9d,0x85,0x78,0x8b,0xbc,
         0x5b,0x95,0x93,0xc4,0x21,0xe8,0xed,0x04,0xbb,0x55,0x35,0xb5,0x46,0x14,0x1d,0xd5,
         0xa0,0x1a,0x10,0x33,0x2a,0xd4,0x15,0xc6,0xcc,0x1b,0xf5,0x42,0x3a,0x65,0xa0,0xed,
         0x76,0x38,0xcd,0xaf,0x97,0xe5,0xe1,0x69,0xc8,0x72,0x12,0x88,0x93,0xd8,0xcc,0xda,
         0x60,0x6f,0x53,0xa0,0x38,0xa6,0xab,0xe4,0xcf,0xf7,0xb5,0x0d,0xc2,0x1a,0x9a,0xb0,
         0x1d,0x79,0x6c,0xa9,0x20,0xe5,0x0b,0x6b,0x43,0x87,0x46,0x94,0x77,0x19,0x43,0xc5,
         0xaf,0x56,0x21,0xb0,0x9f,0xae,0xdb,0x72,0xc3,0x3f,0x70,0x24,0xa4,0x01,0x41,0xac,
         0x57,0x40,0xba,0xd9,0x46,0x50,0x34,0xb0,0x33,0x7c,0x1a,0x00,0x79,0x3f,0x4b,0x3d,
         0x95,0xb7,0xc0,0x8a,0xe6,0x56,0x6f,0x18,0xb1,0xdb,0x6f,0xaf,0x68,0x80,0x5c,0x8a,
         0x2c,0x75,0xfd,0x68,0x90,0x8e,0x24,0xe0,0xa0,0x39,0xd6,0xf5,0x22,0xb2,0xac,0xea,
         0x1b,0x7a,0x79,0x58,0x95,0x05,0x2d,0x7d,0xa0,0xb2,0xfa,0xd7,0x97,0x01,0xb5,0xf1,
         0xa4,0x01,0x7e,0x7e,0x86,0x07,0xa3,0xa4,0x92,0xa5,0xc2,0x9a,0xf8,0xda,0x2e,0x75,
         0x48,0x87,0x94,0x3f,0x35,0x22,0xdf,0x4a,0x98,0xae,0x58,0xc3,0xb8,0xeb,0x12,0x8a,
         0xc8,0xca,0x85,0x41,0xb1,0x23,0x79,0xa4,0x12,0xaa,0x26,0x18,0x85,0x20,0x99,0x86,
         0x25,0xc6,0x59,0x69,0x4d,0x17,0x4b,0x26,0xa2,0xb6,0xd3,0x9d,0x53,0xa6,0x3c,0xfd,
         0x9f,0xb9,0x5a,0xdc,0x98,0x4b,0x6d,0x87,0x27,0x2f,0x49,0x96,0x51,0xea,0xb4,0xc4,
         0xb8,0x1f,0x10,0xfe,0x65,0x4b,0x3a,0xba,0xc4,0xb3,0xb1,0x8a,0xf0,0x9a,0xfb,0xf1,
         0x31,0xb6,0x44,0x75,0xc4,0xe5,0x49,0xf5,0xda,0x1d,0x74,0x3d,0xe2,0xa1,0x48,0xd8,
         0x0b,0x7b,0x00,0x25,0x05,0x26,0x73,0xae,0x08,0x8b,0x3b,0xb4,0x18,0x2f,0x16,0x0f,
         0x87,0xaa,0x8c,0x35,0xbb,0x5b,0xd3,0x98,0x32,0x5a,0xef,0x35,0xc2,0xae,0x1d,0x69,
         0x26,0xc0,0x72,0x07,0xb6,0x10,0xc0,0xa9,0x76,0x27,0xb9,0x43,0x52,0xcd,0x57,0xfe,
         0xa8,0x7b,0x7b,0x43,0x07,0x13,0xd4,0x15,0x37,0xcf,0x02,0xa5,0x79,0x77,0xfb,0x20,
         0x0f,0xd8,0xae,0xcc,0xff,0x71,0xe7,0x53,0x15,0x6f,0x73,0x5f,0x27,0xdc,0x84,0x66,
         0x9c,0x13,0x57,0xc8,0x2f,0x77,0x13,0x17,0xf1,0x64,0xf5,0xb5,0x8d,0x66,0xaa,0xa5,
         0xd0,0xa9,0xfc,0x9b,0x69,0xb1,0xb1,0x55,0xed,0x4b,0xb0,0x2e,0x1e,0xc4,0x66,0xf1,
         0x6c,0x58,0x68,0xeb,0xbc,0xed,0x5a,0x44,0x69,0x02,0x0f,0x8f,0x88,0xe2,0xf1,0x9f,
         0x71,0x1d,0xa4,0x9c,0x7b,0x38,0xe6,0x57,0x06,0xa4,0xba,0xdb,0xbf,0xed,0xc5,0x45,
         0x1f,0x34,0xf8,0xd5,0x35,0xdf,0x6f,0x44,0xa6,0x8f,0x99,0x58,0xf2,0x52,0x9a,0xb7,
         0xf8,0x1b,0xed,0xf9,0xbd,0x6f,0x4e,0x00,0x69,0x60,0xd7,0x8c,0x92,0xbf,0x69,0x0a,
         0xbd,0x8e,0x4d,0xad,0x22,0xb4,0x1b,0xc0,0xb0,0xf4,0xdb,0x3b,0x51,0x20,0x6b,0x94,
         0x6f,0x8a,0x21,0xd7,0xb7,0xbc,0xb0,0xf9,0x1d,0x69,0x50,0x6a,0x20,0xa3,0x19,0xe9,
         0x4f,0x4d,0xb0,0x9c,0x0c,0xd4,0x26,0x60,0x90,0x1a,0x1d,0x5e,0x2f,0xb3,0x2d,0xdf,
         0xdd,0x54,0x86,0x61,0xf2,0x88,0xd6,0xe9,0x2a,0xa5,0x6d,0x9c,0xf0,0xff,0x9f,0x89,
         0xdc,0x5b,0x69,0xca,0x7a,0xa7,0x58,0xcb,0x4d,0xe8,0xa7,0xe9,0x13,0x73,0xa7,0x3f,
         0x4b,0x60,0x64,0xbc,0xf5,0x3c,0x86,0x79,0x99,0xfe,0x75,0x4a,0x8a,0x3c,0xc1,0x94,
         0x6c,0x9f,0xc0,0x5e,0xf4,0x95,0x79,0xaa,0xef,0x45,0xc0,0x05,0x86,0xc8,0xa3,0x5d,
         0xc0,0x96,0x05,0x13,0x48,0x3e,0x89,0x51,0x71,0x5b,0xb2,0x9e,0x77,0xc3,0x48,0xaf,
         0x08,0x01,0xfd,0x80,0x02,0x06,0x50,0xa4,0x7f,0x1b,0xb2,0xda,0x0f,0x1a,0xe7,0xe0,
         0x44,0xde,0xb0,0x8c,0x74,0xf8,0xa7,0x18,0xba,0xa3,0x6a,0xbe,0x3e,0xfb,0xfb,0x84,
         0xb6,0x69,0x67,0x5a,0x2d,0x62,0xa6,0x62,0x03,0x51,0xc3,0x8f,0x36,0xd1,0x3d,0x71,
         0xdf,0x20,0xac,0x4f,0x00,0xd0,0xa7,0x77,0x7c,0xc0,0xe6,0xd2,0x67,0x4b,0xa4,0xbb,
         0x80,0xbf,0x47,0x11,0xfc,0x11,0x43,0x8b,0x86,0xcf,0x3c,0x4c,0x83,0x55,0x6b,0xb8,
         0x9a,0x44,0x42,0x85,0x74,0x30,0x53,0x15,0xc0,0x99,0x6e,0x03,0x7b,0x1d,0x09,0xfc,
         0x6e,0xeb,0xe5,0xd0,0xf8,0x7b,0xef,0xc8,0x0d,0x7d,0x65,0x3b,0x7f,0x0f,0x39,0x5c,
         0x7c,0x32,0xba,0x56,0x59,0x7f,0x71,0x9b,0x8d,0x16,0x49,0x78,0x01,0xd8,0xf4,0xee,
         0x87,0xd6,0x89,0xbd,0xa7,0x08,0x72,0xc1,0xa2,0x43,0x85,0x81,0xb1,0x65,0x71,0x06,
         0x8e,0xd3,0x5c,0xe9,0x35,0x25,0xca,0xb0,0xec,0x1f,0xc1,0x5b,0x81,0xe3,0x2b,0x39,
         0xd3,0x66,0x7b,0x00,0x93,0x21,0x93,0x1d,0x4c,0x09,0xe5,0x49,0xa1,0xc0,0xd9,0x5d,
         0xd7,0x0d,0x6f,0x67,0x93,0x8a,0x26,0xfd,0xe4,0x9c,0x1c,0xd1,0x83,0xa8,0x76,0x86,
         0x5a,0x84,0x02,0xc2,0x44,0x2c,0x1b,0x85,0x14,0xb7,0xce,0xb9,0xd8,0x89,0x3b,0x0a,
         0x5f,0xc9,0x3d,0xf7,0xf8,0x16,0x4d,0x29,0x7d,0x75,0xa3,0x04,0x90,0x8e,0x9f,0x7d,
         0x25,0x19,0x68,0x2b,0x41,0x93,0xd3,0xa0,0x00,0x35,0x86,0xf9,0xdd,0x26,0x5d,0xb4,
         0x2e,0xf0,0x0c,0xc2,0xee,0x31,0x06,0xdd,0xbf,0x93,0x9e,0x1c,0x2f,0xfd,0x6c,0xc5,
         0x3b,0x0b,0xf3,0x62,0x12,0xbc,0x80,0x17,0x1b,0x6b,0x55,0x32,0x38,0x01,0x07,0x04,
         0x4d,0x68,0x25,0xf0,0xfc,0x43,0x1a,0xc1,0xb3,0xdc,0x55,0x40,0xe9,0x5d,0xa7,0x07,
         0xa4,0x44,0xec,0x90,0x3f,0x11,0xed,0x91,0x6a,0x41,0x85,0x8c,0x72,0x80,0x03,0xa1,
         0xc3,0x1b,0xd0,0xa8,0xab,0xb4,0x52,0x7c,0x60,0x39,0x0f,0x99,0x45,0x17,0x16,0xea,
         0x69,0xaa,0x9b,0xdc,0x50,0xf8,0xe1,0xb7,0xf7,0xa0,0x5d,0x2e,0x12,0x0d,0x18,0x35},
        {0},
        /*TST_Expected_output_data for enc Input data for decrypt*/
        {0xb6,0xf2,0x14,0x70,0x1d,0x05,0xa0,0xad,0xf5,0xb8,0xfb,0x5d,0xf2,0xf4,0x9c,0x0a,
         0xe7,0xc1,0xc3,0x70,0xab,0x1a,0x1c,0x26,0x5e,0x54,0xb2,0xd7,0x30,0x2d,0x68,0x71,
         0x93,0x1b,0x13,0x64,0xfc,0x3f,0xb3,0x95,0x2b,0x6e,0x3b,0xb1,0xc5,0x70,0x2e,0xaf,
         0xf3,0xf8,0x48,0xe8,0x91,0xfe,0x52,0xbb,0xec,0xd4,0x8e,0xb4,0x43,0xa5,0x1d,0x80,
         0x73,0xd2,0x29,0x98,0x02,0x96,0x1b,0xe7,0xf5,0xe2,0xf2,0x10,0xa2,0x77,0x65,0x82,
         0x79,0x73,0x36,0x12,0x62,0x51,0x0c,0xa1,0x76,0xa3,0x29,0xc1,0xba,0x90,0x1e,0x41,
         0xe6,0x60,0x6b,0xd4,0xd3,0xe9,0x45,0x19,0x0b,0xe4,0x2b,0xd2,0x33,0xb0,0x9b,0xa2,
         0xa1,0x6c,0x8d,0x08,0xeb,0xda,0xf3,0x7a,0xe2,0x1a,0x90,0x44,0xa2,0x50,0x5a,0xd7,
         0x12,0x27,0xd8,0x4f,0x00,0x69,0xb8,0xdc,0xd8,0x35,0xc8,0xcd,0x7d,0xa9,0x24,0xd7,
         0xeb,0x96,0xf9,0xcf,0xe6,0x54,0xf4,0x6f,0x73,0xe7,0x60,0x9f,0x5d,0xa5,0x6d,0x0b,
         0xbe,0x5b,0x0f,0xf7,0xd5,0x0e,0xd0,0xbd,0x4a,0xea,0x21,0xc7,0xe2,0x43,0xa7,0x40,
         0x77,0x54,0xce,0x12,0xd8,0xf5,0x43,0x6e,0xdc,0x77,0xa7,0xd3,0x06,0xfa,0xd2,0x1e,
         0xd8,0x52,0x5a,0x18,0x74,0xbf,0xd9,0x39,0xaa,0xc6,0x51,0x77,0xb4,0x77,0xb5,0x18,
         0x37,0xf2,0x25,0x10,0xe1,0xc0,0xfc,0xd2,0xc7,0x16,0xfe,0x46,0x91,0xbb,0x88,0x00,
         0xc9,0x29,0x3d,0x8b,0x0d,0xab,0x7d,0x83,0x28,0x2e,0xe2,0xc4,0xe1,0xf6,0x78,0xcc,
         0x6e,0xc7,0xff,0x11,0xc3,0x23,0xba,0x03,0x4e,0x32,0xa7,0xa1,0xec,0x2f,0x07,0xce,
         0xd5,0xa4,0x9b,0x26,0x13,0xb2,0xa0,0x15,0xb6,0x83,0x55,0x6b,0x73,0x2d,0x2c,0x02,
         0x08,0xd1,0x0c,0xfa,0xaa,0xa5,0x0e,0x0b,0x1d,0x59,0x59,0xee,0x9b,0x53,0xf2,0x20,
         0x6a,0x28,0xa1,0x98,0x11,0xf7,0xc4,0x43,0x2f,0x51,0xb2,0xcc,0x81,0x35,0x8e,0x9e,
         0x9a,0x30,0x12,0x02,0x70,0x14,0x19,0x14,0x2b,0xec,0x96,0x37,0xc8,0x6d,0xd1,0x7f,
         0x64,0x5f,0xbb,0xdf,0xfb,0x44,0x23,0xbc,0xbb,0x4d,0x05,0xaa,0x78,0x80,0x88,0x96,
         0x6e,0x13,0x8f,0x97,0x04,0xdd,0x57,0x5c,0xf4,0x4b,0xa3,0x46,0x26,0xb5,0x47,0x38,
         0xaf,0x7c,0xaa,0x41,0xb7,0xc6,0x46,0x89,0x14,0xa9,0xc7,0x7a,0x61,0x89,0x47,0xd0,
         0xb8,0x7a,0x92,0x5e,0xd1,0xc5,0x7b,0xc2,0x12,0x2f,0x3c,0x85,0x00,0xc3,0x6b,0x38,
         0x7d,0xe6,0x43,0x97,0x2e,0x75,0x2c,0xff,0x6e,0xbd,0x50,0x15,0xef,0x94,0x44,0x1f,
         0x45,0x35,0xed,0x48,0x0e,0xca,0xb8,0x4f,0xe0,0xed,0x23,0x6a,0xac,0x34,0x96,0x24,
         0x64,0x90,0x21,0x53,0xf0,0x68,0x8a,0x36,0x80,0xa3,0xd5,0x6f,0x45,0x87,0x81,0x39,
         0x9b,0x73,0xff,0xc9,0xec,0xce,0xa6,0x4f,0xc3,0x7c,0x09,0x6b,0xbf,0xf2,0xbb,0x01,
         0x71,0x10,0x8e,0x08,0xff,0x73,0x82,0x06,0x98,0x1f,0xec,0x80,0x4d,0x7c,0x87,0xb3,
         0xec,0xb7,0x18,0xbe,0xf8,0x72,0x46,0x91,0x54,0x26,0x63,0x73,0x00,0x84,0x86,0x32,
         0xd5,0x19,0xf7,0x1a,0xa9,0x41,0x51,0x2f,0x58,0xa8,0xe0,0x0a,0x55,0x4a,0x19,0xaa,
         0x3f,0xbe,0xfa,0x3f,0x08,0x33,0x11,0x69,0x3e,0x4b,0xc6,0x87,0x55,0x8c,0x1f,0x09,
         0x0a,0x0b,0x8e,0xe1,0xf2,0x38,0x2b,0x15,0x53,0xb8,0x23,0xe4,0x6e,0xf4,0x32,0xf2,
         0xa9,0xd5,0x1b,0xb3,0xe5,0x84,0xe6,0xcd,0x2c,0xd2,0xaa,0x6f,0xb9,0x26,0x88,0x0c,
         0xf0,0x04,0x09,0xf1,0xe9,0x39,0x8d,0xf7,0x9e,0x89,0x0c,0x9f,0x43,0x55,0x86,0x64,
         0x1e,0x70,0x22,0xdc,0x03,0x75,0x3d,0x86,0x6d,0x3d,0xa6,0x4c,0xb7,0x49,0x03,0x5c,
         0xe3,0xe3,0x0a,0xb0,0x08,0xe8,0x2f,0xf0,0x84,0x0d,0x62,0x92,0xce,0x09,0x06,0x37,
         0xba,0x87,0x8a,0xa0,0x26,0x9a,0x27,0x5e,0x80,0xb3,0xac,0x99,0xf9,0x2c,0xfd,0x6c,
         0xad,0x18,0xba,0x47,0x8f,0x1b,0xaa,0x18,0xd2,0x25,0xa9,0xea,0x4f,0x64,0x72,0xee,
         0xcf,0x4a,0xf3,0x45,0xc6,0x77,0x36,0x08,0x1b,0x0e,0xcc,0xf0,0x37,0x5c,0x13,0x23,
         0x89,0x8a,0x4d,0x21,0x4e,0x02,0x28,0x81,0x96,0x1f,0xb2,0x19,0x39,0x21,0x5e,0x8e,
         0x58,0x2a,0x6d,0x4e,0x44,0xa8,0x38,0x84,0x6a,0xdb,0x2b,0x84,0x57,0x50,0xcb,0x08,
         0xbf,0xba,0xec,0x7f,0xfa,0xd7,0xe3,0xbb,0xe4,0x0b,0xcd,0x37,0x9b,0x9a,0x1f,0x0e,
         0x44,0x96,0xf5,0x5e,0x1a,0xd3,0x17,0x70,0xac,0x25,0xbb,0x1f,0xf3,0xc2,0x63,0x33,
         0x34,0x39,0x7b,0xee,0xf6,0x34,0x67,0xc5,0x60,0x93,0x44,0x58,0x81,0xfe,0x77,0x3f,
         0xef,0xdf,0x82,0x3e,0x2f,0xf3,0x07,0x3c,0xd2,0x5e,0x56,0x85,0x0a,0x1f,0x70,0xfa,
         0x33,0xd5,0x73,0x95,0xa0,0x1d,0xdf,0xb5,0xe4,0xec,0x46,0x1b,0x12,0x7f,0xff,0x2c,
         0x72,0xb4,0x10,0x37,0xdb,0xd6,0xad,0xe7,0x95,0x99,0x3f,0x41,0xe8,0x6b,0xe8,0xde,
         0x80,0x54,0xd1,0xf2,0x5d,0x0b,0x4a,0xbd,0x12,0x5e,0x07,0x95,0x57,0xb3,0x75,0x4b,
         0x79,0x64,0x37,0x85,0x3d,0x58,0x85,0xdf,0x5b,0x17,0x39,0xfd,0x90,0x83,0x5e,0xc3,
         0x97,0xe8,0x18,0x0c,0x38,0xec,0x43,0x89,0xb4,0xfc,0x42,0xa2,0x84,0x1e,0x06,0x3d,
         0xc0,0xf4,0xc5,0x8a,0x81,0x04,0x7c,0xc9,0x25,0xa0,0xe8,0x45,0xb6,0xc2,0xbc,0x48,
         0x75,0x6a,0x9d,0x24,0x75,0xcc,0x7d,0x17,0xad,0x14,0xda,0x83,0xa7,0xa6,0x8a,0x79,
         0xc1,0x4d,0x29,0x1a,0x95,0xe1,0xa9,0x9d,0xb5,0x9f,0x99,0x6d,0x69,0x35,0xac,0x2a,
         0x21,0x2a,0x0e,0x60,0x32,0xf8,0x82,0xea,0x10,0x83,0xe0,0x82,0x56,0xa3,0x02,0x5d,
         0xdd,0x3e,0x58,0x6e,0x12,0x04,0x55,0xe9,0x2e,0x0b,0xca,0x60,0x92,0x05,0xbe,0xa5,
         0x81,0x20,0x40,0xb3,0x64,0x28,0x76,0xcc,0x12,0x90,0x3c,0x02,0x42,0xdd,0xa9,0xf9,
         0x47,0x24,0x29,0x79,0x99,0xdd,0x64,0xae,0x0d,0x41,0xc7,0xe8,0xfc,0xe3,0x99,0x1a,
         0xc6,0x3c,0x38,0xe7,0xbc,0xd2,0x7c,0xc7,0xeb,0x38,0xc4,0x16,0x18,0x9c,0x10,0xb7,
         0xee,0xe7,0x37,0x16,0xcd,0x13,0x98,0x39,0x81,0x75,0xae,0x9f,0x95,0xc2,0x2b,0x57,
         0xff,0x37,0x65,0x2c,0x87,0x34,0x81,0x90,0xab,0xfa,0x4c,0xb3,0x14,0x9d,0x2f,0x03,
         0x38,0x1b,0xb4,0x6c,0xcf,0x2d,0x56,0x1b,0x3a,0xfb,0x4a,0x8e,0xd5,0xf3,0x72,0xe2,
         0xe7,0xe9,0x50,0x57,0xaf,0x02,0xe6,0xa1,0x13,0x77,0x81,0x48,0x6d,0xa5,0x0c,0x29,
         0x4b,0x0f,0xb6,0xca,0x03,0x62,0xce,0x94,0x56,0x2b,0x32,0xf0,0xb6,0x05,0x03,0x9e,
         0x9c,0xac,0x21,0x5a,0x33,0xc2,0xa5,0x1e,0xf5,0xb7,0x54,0x96,0x36,0x74,0xa4,0x84,
         0x67,0x1c,0x1a,0x8b,0xf9,0x30,0xc4,0x17,0x56,0x04,0xe9,0xbf,0x5a,0xda,0x80,0xac,
         0x02,0xf7,0x30,0x74,0x20,0x43,0xca,0x65,0x66,0xbe,0x49,0xdf,0xc3,0xca,0x9c,0xbf,
         0x5e,0x37,0x7e,0xe2,0xdf,0xb5,0x3e,0x4b,0x4b,0xd9,0xcd,0x34,0xae,0x18,0x49,0xc8,
         0xdc,0x43,0xbb,0xfb,0x1c,0x53,0x83,0xef,0xce,0xf8,0xc1,0x1e,0xc9,0x8d,0x5a,0x39,
         0x13,0xab,0x7c,0xc1,0x1c,0x78,0xb8,0x77,0x18,0x61,0xd0,0x29,0xfe,0xde,0x2c,0x7c,
         0xb3,0x7d,0xa0,0x85,0x67,0x9f,0x27,0x8a,0xae,0x3e,0xe0,0x4a,0x89,0xb0,0x6f,0xc8,
         0x6a,0xe8,0xbe,0x73,0x25,0x79,0x8a,0xbc,0x2d,0x93,0x6c,0x5c,0x0c,0x93,0xc9,0xb5,
         0xda,0x68,0x90,0xbb,0xa2,0x3d,0xa1,0x53,0x0c,0x21,0xd8,0x8e,0xea,0x99,0x84,0xf8,
         0x23,0xe5,0x39,0xd5,0xdc,0x94,0x8e,0x8f,0xd4,0xd3,0x34,0x04,0xa0,0x66,0x4f,0x6f,
         0xc7,0x3a,0xec,0xd3,0x5d,0x5f,0x29,0x4e,0xd2,0x87,0x16,0x48,0x39,0xf7,0x90,0x8d,
         0xe5,0xc0,0x96,0xae,0x7d,0xb8,0x31,0x5a,0xe6,0xf5,0x7d,0x11,0xb7,0x55,0xe7,0x12,
         0x7a,0xcc,0xde,0x88,0xc0,0x8b,0x4f,0x99,0x3f,0x0a,0x2e,0xff,0x4f,0x01,0xd2,0xef,
         0x17,0xad,0x1f,0x63,0xf2,0x07,0xd5,0x30,0x22,0x37,0xa5,0x8e,0x9d,0x5d,0x75,0xb5,
         0x02,0x7c,0x45,0xbf,0xf1,0x9d,0xb4,0x87,0x73,0xef,0x74,0x05,0xcc,0xc5,0x49,0x33,
         0x85,0xf8,0x73,0x94,0x68,0x1a,0x09,0x49,0x59,0x52,0x45,0x07,0xd2,0x91,0x67,0x75,
         0xc7,0x07,0x38,0x35,0x1c,0x73,0xfa,0xd2,0x76,0x21,0x99,0xa0,0x9c,0x59,0x37,0x57,
         0x6d,0xcc,0xfd,0x80,0x5d,0xd5,0x4a,0xb9,0xd8,0x86,0x0d,0x19,0x06,0xe5,0xd2,0xf5,
         0xb0,0x8a,0x70,0xa2,0x7f,0xb6,0xba,0xd3,0x1b,0x9e,0x95,0x01,0x34,0x35,0x44,0x8e,
         0x46,0x43,0xc3,0x62,0xa0,0x28,0xed,0xda,0x69,0x3d,0x00,0x64,0xc0,0xe1,0x73,0x3a,
         0x38,0x26,0x76,0xd0,0x7d,0xe8,0xbc,0x64,0x41,0x0c,0x2f,0xd4,0x52,0x99,0xfb,0xc7,
         0xff,0xdc,0xb6,0x2a,0x98,0x5f,0xa8,0xd8,0xac,0x26,0x04,0x38,0x3c,0x44,0x1d,0x96,
         0xd0,0x0b,0x05,0xd4,0xc6,0x8c,0x00,0x2b,0x9e,0x85,0x14,0xf4,0x1f,0x95,0x90,0xdf,
         0xe8,0x7b,0xd8,0xb1,0xe0,0x58,0x80,0xae,0x68,0xc2,0x91,0x8a,0xac,0x4e,0xc9,0x35,
         0xcf,0x0f,0x72,0xc4,0x19,0x33,0xa5,0xb7,0x23,0xfb,0xab,0xa9,0x8b,0x51,0x05,0x40,
         0x2e,0xc8,0xf3,0x36,0x06,0x93,0x64,0x0c,0x89,0x1f,0x57,0xe9,0xc1,0x2e,0x29,0x70,
         0xf3,0xac,0x6c,0x3a,0xfc,0xc6,0x14,0x9c,0x95,0xfc,0xa6,0xa5,0x3b,0x4e,0x5f,0x1d,
         0xa3,0x27,0xc5,0x24,0x70,0x40,0x14,0x63,0x2d,0xce,0x98,0x29,0xbd,0x1a,0x26,0xe5,
         0x6a,0x3b,0x0d,0x98,0x34,0x56,0xa5,0x0e,0x0e,0x7f,0xcc,0x43,0x96,0x83,0x47,0xd5,
         0xa6,0xab,0xac,0xf0,0x5a,0xdb,0x00,0xe4,0x59,0x18,0x7c,0xeb,0xee,0x33,0xbe,0x65,
         0x9f,0xf0,0x69,0xd5,0xa9,0x4a,0x75,0xf9,0xc1,0xc0,0x93,0x49,0xfb,0x27,0xb5,0x13,
         0xb2,0xcd,0xa9,0xb3,0xfd,0xb6,0xf2,0xf1,0xda,0xc1,0x5d,0xe6,0x46,0xda,0x52,0xc6}, 
        /*TST_dataSize*/
        1536*sizeof(DxUint8_t),
        CRYS_AES_ECB_mode
    },
    #endif
    #if TST_USE_AES_192_KEY 
    #if TST_USE_AES_16BYTE_DATA
    {
        {"Acceptance test - AES/ECB/192Key/16ByteData"},
        /*TST_Key*/     
        {0x8e,0x73,0xb0,0xf7,0xda,0x0e,0x64,0x52,0xc8,0x10,0xf3,0x2b,0x80,0x90,0x79,0xe5,
         0x62,0xf8,0xea,0xd2,0x52,0x2c,0x6b,0x7b}, 
        CRYS_AES_Key192BitSize,
        /*TST_IvCounter*/       
        {0},
        /*TST_input_data*/
        {0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a},
        {0},
        /*TST_Expected_output_data for enc Input data for decrypt*/
        {0xbd,0x33,0x4f,0x1d,0x6e,0x45,0xf2,0x5f,0xf7,0x12,0xa2,0x14,0x57,0x1f,0xa5,0xcc}, 
        /*TST_dataSize*/
        16*sizeof(DxUint8_t),
        CRYS_AES_ECB_mode
    },
    #endif
    #if TST_USE_AES_32BYTE_DATA
    {
        {"Acceptance test - AES/ECB/192Key/32ByteData"},
        /*TST_Key*/     
        {0x8f,0x73,0x44,0xf7,0xda,0x0e,0x64,0x52,0xc8,0x10,0xc3,0x2b,0x80,0x90,0x79,0x56,
         0x62,0xf8,0xea,0xd2,0x52,0x2c,0x66,0x7b},
        CRYS_AES_Key192BitSize,
        /*TST_IvCounter*/       
        {0},
        /*TST_input_data*/
        {0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a,
         0xbd,0x33,0x4f,0x1d,0x6e,0x45,0xf2,0x5f,0xf7,0x12,0xa2,0x14,0x57,0x1f,0xa5,0xcc},
        {0},
        /*TST_Expected_output_data for enc Input data for decrypt*/
        {0x19,0x44,0xae,0xde,0xc2,0x95,0x8d,0x4b,0x57,0xb8,0x4f,0x52,0x28,0x84,0x10,0xda,
         0xa9,0xfd,0x63,0x28,0x0d,0x3a,0x07,0x3c,0x43,0x36,0x23,0x21,0x5c,0x03,0xcf,0x31}, 
        /*TST_dataSize*/
        32*sizeof(DxUint8_t),
        CRYS_AES_ECB_mode
    },
    #endif
    #if TST_USE_AES_512BYTE_DATA
    {
        {"Acceptance test - AES/ECB/192Key/512ByteData"},
        /*TST_Key*/     
        {0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a,
         0xbd,0x33,0x4f,0x1d,0x6e,0x45,0xf2,0x5f}, 
        CRYS_AES_Key192BitSize,
        /*TST_IvCounter*/       
        {0},
        /*TST_input_data*/
        {0x30,0xc8,0x1c,0x46,0xa3,0x5c,0xe4,0x11,0xe5,0xfb,0xc1,0x19,0x1a,0x0a,0x52,0xef,
         0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a,
         0x3a,0xd7,0x7b,0xb4,0x0d,0x7a,0x36,0x60,0xa8,0x9e,0xca,0xf3,0x24,0x66,0xef,0x97,
         0xf5,0xd3,0xd5,0x85,0x03,0xb9,0x69,0x9d,0xe7,0x85,0x89,0x5a,0x96,0xfd,0xba,0xaf,
         0x43,0xb1,0xcd,0x7f,0x59,0x8e,0xce,0x23,0x88,0x1b,0x00,0xe3,0xed,0x03,0x06,0x88,
         0x7b,0x0c,0x78,0x5e,0x27,0xe8,0xad,0x3f,0x82,0x23,0x20,0x71,0x04,0x72,0x5d,0xd4,
         0x3a,0xd7,0x7b,0xb4,0x0d,0x7a,0x36,0x60,0xa8,0x9e,0xca,0xf3,0x24,0x66,0xef,0x97,
         0xf5,0xd3,0xd5,0x85,0x03,0xb9,0x69,0x9d,0xe7,0x85,0x89,0x5a,0x96,0xfd,0xba,0xaf,
         0x30,0xc8,0x1c,0x46,0xa3,0x5c,0xe4,0x11,0xe5,0xfb,0xc1,0x19,0x1a,0x0a,0x52,0xef,
         0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a,
         0x3a,0xd7,0x7b,0xb4,0x0d,0x7a,0x36,0x60,0xa8,0x9e,0xca,0xf3,0x24,0x66,0xef,0x97,
         0xf5,0xd3,0xd5,0x85,0x03,0xb9,0x69,0x9d,0xe7,0x85,0x89,0x5a,0x96,0xfd,0xba,0xaf,
         0x43,0xb1,0xcd,0x7f,0x59,0x8e,0xce,0x23,0x88,0x1b,0x00,0xe3,0xed,0x03,0x06,0x88,
         0x7b,0x0c,0x78,0x5e,0x27,0xe8,0xad,0x3f,0x82,0x23,0x20,0x71,0x04,0x72,0x5d,0xd4,
         0x3a,0xd7,0x7b,0xb4,0x0d,0x7a,0x36,0x60,0xa8,0x9e,0xca,0xf3,0x24,0x66,0xef,0x97,
         0xf5,0xd3,0xd5,0x85,0x03,0xb9,0x69,0x9d,0xe7,0x85,0x89,0x5a,0x96,0xfd,0xba,0xaf,
         0x30,0xc8,0x1c,0x46,0xa3,0x5c,0xe4,0x11,0xe5,0xfb,0xc1,0x19,0x1a,0x0a,0x52,0xef,
         0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a,
         0x3a,0xd7,0x7b,0xb4,0x0d,0x7a,0x36,0x60,0xa8,0x9e,0xca,0xf3,0x24,0x66,0xef,0x97,
         0xf5,0xd3,0xd5,0x85,0x03,0xb9,0x69,0x9d,0xe7,0x85,0x89,0x5a,0x96,0xfd,0xba,0xaf,
         0x43,0xb1,0xcd,0x7f,0x59,0x8e,0xce,0x23,0x88,0x1b,0x00,0xe3,0xed,0x03,0x06,0x88,
         0x7b,0x0c,0x78,0x5e,0x27,0xe8,0xad,0x3f,0x82,0x23,0x20,0x71,0x04,0x72,0x5d,0xd4,
         0x3a,0xd7,0x7b,0xb4,0x0d,0x7a,0x36,0x60,0xa8,0x9e,0xca,0xf3,0x24,0x66,0xef,0x97,
         0xf5,0xd3,0xd5,0x85,0x03,0xb9,0x69,0x9d,0xe7,0x85,0x89,0x5a,0x96,0xfd,0xba,0xaf,
         0x30,0xc8,0x1c,0x46,0xa3,0x5c,0xe4,0x11,0xe5,0xfb,0xc1,0x19,0x1a,0x0a,0x52,0xef,
         0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a,
         0x3a,0xd7,0x7b,0xb4,0x0d,0x7a,0x36,0x60,0xa8,0x9e,0xca,0xf3,0x24,0x66,0xef,0x97,
         0xf5,0xd3,0xd5,0x85,0x03,0xb9,0x69,0x9d,0xe7,0x85,0x89,0x5a,0x96,0xfd,0xba,0xaf,
         0x43,0xb1,0xcd,0x7f,0x59,0x8e,0xce,0x23,0x88,0x1b,0x00,0xe3,0xed,0x03,0x06,0x88,
         0x7b,0x0c,0x78,0x5e,0x27,0xe8,0xad,0x3f,0x82,0x23,0x20,0x71,0x04,0x72,0x5d,0xd4,
         0x3a,0xd7,0x7b,0xb4,0x0d,0x7a,0x36,0x60,0xa8,0x9e,0xca,0xf3,0x24,0x66,0xef,0x97,
         0xf5,0xd3,0xd5,0x85,0x03,0xb9,0x69,0x9d,0xe7,0x85,0x89,0x5a,0x96,0xfd,0xba,0xaf},
        {0},
        /*TST_Expected_output_data for enc Input data for decrypt*/
        {0x32,0x56,0x91,0x99,0x53,0x67,0xa8,0xb3,0x7b,0x0c,0x47,0x06,0xa2,0x3f,0x35,0xf6,
         0xab,0xdb,0x6b,0x26,0x69,0x8b,0x43,0xdd,0xe4,0xd8,0x20,0x7c,0xe5,0x65,0x00,0xbc,
         0x60,0xbe,0x0b,0x8e,0xee,0xb0,0xa0,0x1b,0xad,0xee,0xd3,0x7d,0xeb,0xbf,0xc8,0x71,
         0xf5,0x01,0x37,0xfb,0x8b,0x38,0xe2,0x22,0x24,0x44,0xf3,0x27,0xc6,0x8a,0x06,0xc8,
         0xbc,0xc1,0x16,0xe0,0xa6,0x90,0xef,0xaa,0xde,0x00,0x91,0xf6,0x92,0x5e,0xff,0x07,
         0x88,0x03,0xf1,0xf6,0xbf,0xc0,0xbc,0x0a,0x19,0x03,0xf0,0x94,0x42,0x23,0x75,0x03,
         0x60,0xbe,0x0b,0x8e,0xee,0xb0,0xa0,0x1b,0xad,0xee,0xd3,0x7d,0xeb,0xbf,0xc8,0x71,
         0xf5,0x01,0x37,0xfb,0x8b,0x38,0xe2,0x22,0x24,0x44,0xf3,0x27,0xc6,0x8a,0x06,0xc8,
         0x32,0x56,0x91,0x99,0x53,0x67,0xa8,0xb3,0x7b,0x0c,0x47,0x06,0xa2,0x3f,0x35,0xf6,
         0xab,0xdb,0x6b,0x26,0x69,0x8b,0x43,0xdd,0xe4,0xd8,0x20,0x7c,0xe5,0x65,0x00,0xbc,
         0x60,0xbe,0x0b,0x8e,0xee,0xb0,0xa0,0x1b,0xad,0xee,0xd3,0x7d,0xeb,0xbf,0xc8,0x71,
         0xf5,0x01,0x37,0xfb,0x8b,0x38,0xe2,0x22,0x24,0x44,0xf3,0x27,0xc6,0x8a,0x06,0xc8,
         0xbc,0xc1,0x16,0xe0,0xa6,0x90,0xef,0xaa,0xde,0x00,0x91,0xf6,0x92,0x5e,0xff,0x07,
         0x88,0x03,0xf1,0xf6,0xbf,0xc0,0xbc,0x0a,0x19,0x03,0xf0,0x94,0x42,0x23,0x75,0x03,
         0x60,0xbe,0x0b,0x8e,0xee,0xb0,0xa0,0x1b,0xad,0xee,0xd3,0x7d,0xeb,0xbf,0xc8,0x71,
         0xf5,0x01,0x37,0xfb,0x8b,0x38,0xe2,0x22,0x24,0x44,0xf3,0x27,0xc6,0x8a,0x06,0xc8,
         0x32,0x56,0x91,0x99,0x53,0x67,0xa8,0xb3,0x7b,0x0c,0x47,0x06,0xa2,0x3f,0x35,0xf6,
         0xab,0xdb,0x6b,0x26,0x69,0x8b,0x43,0xdd,0xe4,0xd8,0x20,0x7c,0xe5,0x65,0x00,0xbc,
         0x60,0xbe,0x0b,0x8e,0xee,0xb0,0xa0,0x1b,0xad,0xee,0xd3,0x7d,0xeb,0xbf,0xc8,0x71,
         0xf5,0x01,0x37,0xfb,0x8b,0x38,0xe2,0x22,0x24,0x44,0xf3,0x27,0xc6,0x8a,0x06,0xc8,
         0xbc,0xc1,0x16,0xe0,0xa6,0x90,0xef,0xaa,0xde,0x00,0x91,0xf6,0x92,0x5e,0xff,0x07,
         0x88,0x03,0xf1,0xf6,0xbf,0xc0,0xbc,0x0a,0x19,0x03,0xf0,0x94,0x42,0x23,0x75,0x03,
         0x60,0xbe,0x0b,0x8e,0xee,0xb0,0xa0,0x1b,0xad,0xee,0xd3,0x7d,0xeb,0xbf,0xc8,0x71,
         0xf5,0x01,0x37,0xfb,0x8b,0x38,0xe2,0x22,0x24,0x44,0xf3,0x27,0xc6,0x8a,0x06,0xc8,
         0x32,0x56,0x91,0x99,0x53,0x67,0xa8,0xb3,0x7b,0x0c,0x47,0x06,0xa2,0x3f,0x35,0xf6,
         0xab,0xdb,0x6b,0x26,0x69,0x8b,0x43,0xdd,0xe4,0xd8,0x20,0x7c,0xe5,0x65,0x00,0xbc,
         0x60,0xbe,0x0b,0x8e,0xee,0xb0,0xa0,0x1b,0xad,0xee,0xd3,0x7d,0xeb,0xbf,0xc8,0x71,
         0xf5,0x01,0x37,0xfb,0x8b,0x38,0xe2,0x22,0x24,0x44,0xf3,0x27,0xc6,0x8a,0x06,0xc8,
         0xbc,0xc1,0x16,0xe0,0xa6,0x90,0xef,0xaa,0xde,0x00,0x91,0xf6,0x92,0x5e,0xff,0x07,
         0x88,0x03,0xf1,0xf6,0xbf,0xc0,0xbc,0x0a,0x19,0x03,0xf0,0x94,0x42,0x23,0x75,0x03,
         0x60,0xbe,0x0b,0x8e,0xee,0xb0,0xa0,0x1b,0xad,0xee,0xd3,0x7d,0xeb,0xbf,0xc8,0x71,
         0xf5,0x01,0x37,0xfb,0x8b,0x38,0xe2,0x22,0x24,0x44,0xf3,0x27,0xc6,0x8a,0x06,0xc8}, 
        /*TST_dataSize*/
        512*sizeof(DxUint8_t),
        CRYS_AES_ECB_mode
    },
    #endif
    #if TST_USE_AES_1536BYTE_DATA
    {
        {"Acceptance test - AES/ECB/192Key/1536ByteData"},
            /*TST_Key*/     
        {0xba,0xce,0x9c,0x82,0x90,0x12,0xbc,0x9e,0x06,0x98,0xb1,0x66,0xf9,0x17,0x6a,0xd9,
        0x03,0x14,0x66,0x4f,0xa9,0x4b,0x81,0xfe}, 
        CRYS_AES_Key192BitSize,
        /*TST_IvCounter*/       
        {0},
        /*TST_input_data*/
        {0x76,0x29,0x98,0x22,0xae,0x7f,0xde,0xbe,0xd4,0x5c,0x9a,0xcf,0x12,0x92,0x68,0x54,
        0xf8,0xc1,0x7a,0x85,0x71,0x78,0x30,0x13,0xf6,0x9c,0xe9,0xb0,0x01,0x0e,0x1a,0xd2,
        0xc5,0x88,0x9d,0xb4,0x1c,0xc8,0x4b,0x9e,0xc1,0xf1,0xcc,0x67,0xbf,0x2e,0xae,0x38,
        0x29,0x98,0xb5,0x92,0x0c,0x5a,0x72,0x93,0xa2,0x12,0x17,0x75,0xc8,0x7b,0x8a,0x57,
        0xb2,0x4a,0xb8,0x40,0xde,0x55,0x2c,0x61,0x46,0xfa,0xe0,0x9a,0xda,0xbf,0x53,0x40,
        0x2d,0x36,0xdb,0x1e,0x6f,0x24,0x3d,0xb9,0x9b,0xe1,0x7b,0xd9,0xf1,0x02,0xed,0x44,
        0xa7,0x36,0x93,0xcd,0xdc,0x6e,0xaa,0x8d,0xcd,0x41,0x7d,0x71,0x4b,0x8e,0x7e,0xf5,
        0x6d,0x63,0x95,0x2e,0x82,0x1d,0xb8,0x0e,0x49,0xd1,0xbc,0xe4,0x65,0xeb,0x6b,0x22,
        0x0b,0x15,0xd6,0x63,0xfe,0x5b,0xed,0xac,0xbd,0x8c,0x4c,0xf2,0xfa,0xe3,0x58,0xdd,
        0x4f,0xe6,0x8b,0xcc,0x2d,0x8f,0x0c,0x19,0x15,0xaa,0x83,0x9e,0x0a,0x7e,0x2b,0x78,
        0x46,0xaf,0x29,0x0a,0x2c,0x63,0x1c,0x45,0x7e,0xa4,0xf5,0x27,0xd0,0x06,0x09,0x82,
        0x3c,0x89,0x64,0xff,0x58,0xc0,0x60,0x62,0x65,0x33,0x77,0x10,0xc9,0x03,0x56,0xce,
        0xc0,0xcc,0x32,0xcb,0x4e,0xcf,0x5f,0xe1,0x78,0x51,0x1f,0x18,0xb3,0x3e,0xb8,0x6c,
        0x9d,0x12,0xc9,0xd0,0xeb,0xf9,0xdd,0x72,0xa2,0x35,0x41,0x41,0x8b,0xc1,0x13,0xad,
        0xe0,0x34,0x9c,0xad,0x4c,0xe7,0xe0,0x07,0x13,0x5a,0x72,0xcc,0x8c,0xd4,0x8d,0x21,
        0xd8,0x4a,0x61,0x45,0xce,0x82,0xab,0xd0,0x35,0x79,0x88,0x39,0x36,0x01,0x8b,0x9b,
        0x10,0xae,0x0d,0xb9,0x0e,0xf3,0xc4,0x3f,0xb7,0x89,0x98,0x4b,0x44,0x10,0xb1,0x2b,
        0x57,0xf9,0xd5,0x69,0xe9,0xa3,0xf1,0x04,0x84,0xc4,0xf5,0x01,0xb3,0x0b,0xe5,0x22,
        0xb8,0x04,0x2d,0xf6,0x7c,0x3b,0x36,0x12,0xcc,0xa4,0x36,0x9d,0xc1,0x3a,0x4c,0x12,
        0x80,0xe7,0xcc,0x41,0x24,0xa4,0xd8,0x97,0xf9,0xe1,0x30,0xa0,0xeb,0x27,0x4a,0xca,
        0x3e,0xfc,0xa6,0x6c,0x7f,0x07,0x5c,0x06,0xba,0x74,0xf7,0xcb,0xed,0x9a,0x85,0x5c,
        0xbd,0xdb,0xef,0xd7,0x68,0xcc,0x87,0x10,0xfb,0x96,0xe0,0x1e,0xc5,0x9d,0xe2,0x1a,
        0x0b,0x5f,0x1d,0x23,0xfd,0x9e,0x5e,0xa5,0xe9,0xc1,0x80,0xdb,0xaf,0x78,0x85,0x93,
        0x75,0x9f,0xe6,0x32,0x9b,0x65,0x26,0xf7,0xf1,0xad,0xad,0x84,0x28,0xb4,0xd4,0x9a,
        0x87,0xf4,0x3d,0x24,0xdf,0x49,0x65,0x77,0xc1,0x53,0x7c,0xd8,0xee,0x1b,0x74,0x3e,
        0x0f,0xf9,0x58,0x5a,0xa7,0xb5,0xdf,0xd5,0x45,0xec,0x41,0xd9,0xfe,0xb5,0x49,0xd2,
        0x1a,0x85,0xab,0x76,0x0e,0x50,0x99,0x03,0xab,0xf1,0x91,0xc7,0x94,0xcc,0x79,0xe6,
        0xf5,0xb2,0xed,0x58,0x72,0x05,0xd8,0x31,0x5e,0x1c,0x41,0x25,0x2e,0xe8,0x68,0x4b,
        0x2d,0xd8,0x12,0x21,0x71,0xfb,0x21,0xd1,0x0d,0x65,0x67,0xb2,0x88,0xd3,0xbc,0x12,
        0x8e,0x92,0x4e,0x33,0xe6,0x9c,0x39,0x93,0xa4,0x05,0x58,0x70,0xa0,0x95,0x5a,0x8c,
        0x26,0xb7,0x18,0x2e,0xef,0x91,0x25,0x69,0x50,0x75,0xa7,0xa0,0xb2,0x78,0x66,0x4a,
        0x42,0x60,0x23,0xf3,0xea,0xc4,0x2b,0x83,0x7f,0x6e,0x2c,0xc3,0x3c,0x04,0x46,0x1d,
        0x6f,0xe8,0x65,0xa4,0x72,0x5c,0xcf,0x54,0xdd,0xea,0xf9,0x9a,0xfa,0x03,0x9f,0x17,
        0x79,0xe6,0x13,0xa1,0x65,0xc3,0xd6,0x8a,0x57,0x20,0x65,0x25,0xea,0x7d,0x55,0x87,
        0x6e,0x33,0xa2,0x8b,0xe1,0xa2,0x45,0x19,0x1b,0x8b,0x04,0xa7,0x48,0xbb,0x8e,0xff,
        0x9b,0xea,0xc7,0x43,0x41,0xe2,0x61,0x2f,0x94,0xe4,0xac,0x9f,0x92,0x47,0xaf,0x51,
        0x8d,0x62,0x77,0xeb,0x23,0xac,0xaf,0x40,0x71,0x22,0x71,0xcf,0x84,0xe9,0x5c,0x8c,
        0x10,0x35,0xe7,0xe4,0x65,0x69,0xf4,0xfb,0x9e,0x80,0xa9,0x38,0x1c,0xab,0x7b,0x03,
        0x33,0x3b,0x8b,0xcd,0x22,0xc2,0x36,0x51,0x49,0x75,0xe7,0x1a,0x96,0xd5,0x30,0x46,
        0x41,0x8f,0x1a,0x89,0xb9,0xa0,0xb9,0x75,0xde,0xbc,0x03,0xf8,0x70,0xf1,0xe2,0x26,
        0xc7,0x88,0x87,0x38,0xc5,0x2c,0x02,0xd5,0x0a,0x4e,0x0f,0x91,0x66,0xc7,0x33,0xb4,
        0x94,0xbf,0x08,0x3c,0x25,0xce,0xd5,0x25,0xba,0x62,0x62,0xe7,0x76,0x61,0x0b,0x41,
        0xb3,0x0f,0x12,0x35,0xf4,0x31,0x3a,0x54,0x1b,0x73,0x91,0x3b,0xdd,0x07,0x8d,0x5e,
        0x72,0x8f,0x5a,0x04,0x91,0x3d,0x73,0x93,0x9b,0x38,0x70,0x0e,0x17,0x42,0x1e,0xdc,
        0x5e,0x99,0xd5,0xcb,0x97,0x1a,0x06,0x54,0xe6,0xac,0x14,0x21,0xe1,0xdc,0x65,0xcc,
        0x44,0xc5,0xb8,0xea,0xe5,0x33,0xb9,0x48,0xea,0x08,0xd2,0x74,0x39,0xde,0x45,0x7f,
        0x30,0xed,0x78,0x02,0x97,0x2f,0x8f,0x5f,0xd2,0xc3,0x40,0x49,0x5b,0x90,0xe3,0x87,
        0x70,0x2a,0xc9,0xf4,0x09,0xf9,0xcf,0xcb,0x0d,0x98,0x33,0x21,0xc5,0x7b,0xa6,0xb3,
        0x91,0xd5,0xa2,0xe2,0xda,0xb8,0xfd,0xfc,0x47,0x7e,0xbf,0xbd,0x34,0x69,0x31,0x16,
        0x60,0x86,0x36,0x2c,0xe5,0xd7,0xde,0xa4,0x6e,0xb0,0x39,0x1e,0xa4,0x62,0x69,0xff,
        0xe9,0x17,0xfb,0x74,0x49,0xfd,0x78,0xb4,0xad,0xa7,0x36,0x85,0x52,0xb0,0x74,0x01,
        0x7a,0xa1,0xa6,0x9a,0x62,0x14,0x0e,0x5c,0x73,0x1a,0x8c,0x72,0xbc,0xdb,0xb7,0xec,
        0xa0,0x7c,0x2c,0xbf,0xcc,0x46,0x27,0x0d,0x6d,0x04,0x50,0xa7,0x9f,0xac,0xd7,0xd1,
        0x28,0x42,0xc2,0x45,0x66,0xfa,0x86,0x7a,0x86,0x9d,0xd5,0x25,0xf7,0x2d,0xb8,0x01,
        0x1e,0xcc,0xdd,0xcb,0x4c,0xda,0x32,0x91,0xed,0x5e,0xb3,0x2d,0x02,0xa7,0x7f,0x0d,
        0xd1,0x33,0x32,0x35,0xda,0xcf,0x6f,0x86,0x0e,0x00,0xbc,0x40,0x3c,0xa2,0x93,0xc6,
        0xcc,0xcf,0xb5,0xa1,0xaf,0x02,0xc2,0xc8,0x96,0x7c,0x07,0x1e,0x62,0xe7,0x97,0x3d,
        0xdc,0x3a,0x9d,0x72,0xa7,0xdc,0xf0,0x08,0x73,0x0c,0xe8,0xca,0x72,0x80,0x71,0xc3,
        0x10,0x4c,0x5d,0x48,0xdf,0x06,0xff,0x39,0xd0,0x28,0xf5,0x83,0xa9,0xb5,0x45,0xe9,
        0xb3,0x20,0xac,0x05,0xb3,0x69,0x32,0x89,0x1c,0x89,0x02,0xcb,0x83,0x10,0x79,0x81,
        0x53,0x0d,0x7d,0xc8,0xc2,0x2e,0x10,0x6c,0x04,0x28,0x24,0x63,0xbe,0x59,0xb1,0x9a,
        0xbd,0xac,0x06,0xf5,0xe8,0xbe,0x5d,0x91,0x73,0x3f,0xb1,0x4c,0x56,0x9a,0xd4,0x87,
        0xfe,0xd8,0xbc,0x2a,0x42,0xc1,0x1d,0xe9,0x98,0x45,0x3e,0xc6,0x89,0x1b,0x05,0xd7,
        0x62,0xa8,0x53,0x4a,0x2d,0x22,0x98,0xa6,0xdf,0xf5,0x9e,0x53,0xd3,0x66,0xa9,0x5d,
        0x77,0x76,0xc2,0x75,0x46,0x09,0x50,0x39,0xf6,0x47,0xe8,0xb5,0xf2,0x43,0x66,0x29,
        0x0a,0xda,0x3d,0x0c,0x69,0xdf,0x0b,0x52,0xc8,0x75,0x71,0xeb,0xe2,0xbb,0x21,0x8c,
        0x28,0xaf,0x38,0xb1,0xb5,0x4c,0xcf,0xe3,0x84,0xf6,0xcc,0x36,0xe1,0x18,0xfe,0x17,
        0x1d,0x0c,0x6a,0x44,0x86,0x3b,0xdf,0x1c,0x96,0x85,0xd1,0x19,0x6b,0xe3,0x64,0x9b,
        0x77,0x4a,0xc6,0xe7,0x79,0xd3,0xc2,0x6f,0xac,0x1a,0x92,0x54,0x3e,0xe3,0xf5,0x29,
        0x03,0x04,0x82,0xfa,0x6b,0x7f,0x3c,0x8c,0xb2,0xee,0x66,0xe7,0x56,0x24,0x99,0x12,
        0xce,0x11,0x13,0x1e,0x79,0xe6,0x52,0x65,0xd5,0x7a,0xe2,0x14,0xf1,0xec,0x73,0xe7,
        0x25,0x8b,0x2e,0x34,0x00,0xf2,0x49,0x2b,0x82,0x77,0xd9,0x5c,0x8b,0xc7,0xe8,0x7a,
        0x94,0xca,0xc8,0x5e,0x9d,0xcd,0xa6,0x4e,0x66,0xdf,0x62,0x80,0xe2,0x7b,0x9f,0xda,
        0xe9,0x68,0x16,0xfc,0x2d,0xde,0x2f,0x80,0x6f,0xea,0xd2,0x80,0xf3,0x13,0x7a,0x59,
        0x31,0x3e,0x8c,0xaf,0xcd,0xcf,0xe8,0xb2,0xc9,0x11,0xbd,0x9f,0xfa,0xd8,0xa1,0x89,
        0xb8,0x65,0xe1,0x59,0xda,0x89,0x15,0x14,0xe2,0x0e,0xf8,0x5c,0x74,0x52,0x77,0x3a,
        0x0d,0x35,0x08,0x1a,0xf1,0x35,0x3d,0x17,0x65,0xd8,0x99,0x79,0x1f,0x4b,0xa2,0x7c,
        0xfb,0x48,0x37,0x54,0xef,0x3c,0x24,0x6d,0x41,0xaa,0xf4,0xf7,0xf7,0xca,0x07,0xa2,
        0x90,0x77,0xe4,0xa6,0xf1,0x48,0xcf,0x07,0xa2,0xfc,0x9f,0x17,0x3a,0x1b,0xca,0x3c,
        0x18,0xda,0xc2,0xf3,0x54,0x3f,0x84,0x15,0xf5,0x87,0x6d,0x5a,0x65,0xc5,0x50,0x1b,
        0x22,0xcb,0xc7,0x5c,0xb5,0x4d,0xc6,0x09,0xe8,0x44,0x76,0x80,0x34,0x91,0x40,0x50,
        0x79,0xe3,0x27,0x40,0xf2,0xda,0x5c,0x94,0x67,0x6d,0x0c,0x8b,0xa4,0x89,0x7d,0x2c,
        0x2b,0xfa,0x59,0x42,0x26,0x8f,0x4a,0xa6,0x9f,0x79,0xc6,0xbc,0xf3,0xf5,0x2d,0x40,
        0x84,0x2b,0x11,0x43,0xaf,0x55,0xd4,0x70,0xfe,0x23,0x79,0x94,0x9e,0x5e,0xb4,0x5e,
        0x13,0xcd,0x43,0x63,0x2a,0x55,0x81,0x64,0x2f,0x63,0x39,0xd4,0x61,0x8f,0xb8,0x95,
        0xa3,0x79,0x26,0x03,0x74,0xf7,0x16,0x33,0x21,0x73,0x5b,0x7c,0x39,0x8e,0x1d,0x37,
        0x42,0x09,0x2d,0xc4,0xaa,0xe6,0x96,0xce,0x01,0xca,0x75,0xcf,0x65,0xa6,0x0a,0xd6,
        0x3d,0x96,0x0e,0x88,0x2a,0x0a,0x47,0x64,0x3a,0x23,0x5b,0x4c,0x5f,0x60,0xe2,0x41,
        0x20,0x79,0xbe,0x6f,0x8f,0x8b,0xaf,0x69,0x7b,0x76,0x22,0xb5,0xe6,0x83,0x4a,0x8b,
        0xb9,0x4b,0x72,0xda,0xb7,0xd4,0x92,0x8c,0xb0,0xfc,0x20,0x0b,0xf7,0x1b,0x28,0x04,
        0x16,0xe4,0x9f,0x6b,0xbf,0x8c,0xf5,0xbf,0x06,0x2f,0xe9,0x8f,0xce,0x6f,0xa1,0x3d,
        0x81,0x5e,0xfa,0x02,0x05,0x9e,0x1d,0x32,0xeb,0xc6,0x53,0xc1,0xe9,0x08,0x1a,0x07,
        0x8a,0x11,0x78,0xc0,0x24,0x31,0x8f,0x57,0x0b,0xbc,0x72,0x64,0x04,0xb0,0x37,0x73,
        0xfc,0x97,0x4d,0x07,0xfa,0xaf,0x10,0xde,0x53,0x49,0x9b,0x77,0x1d,0x6f,0xdd,0xd2,
        0xe5,0xc9,0xf0,0x77,0xa5,0xc2,0xa5,0xb9,0xf0,0xe6,0x64,0x3c,0x70,0x8e,0x33,0xb5,
        0x92,0xc0,0x14,0xf1,0x80,0x51,0x94,0x19,0x50,0x4c,0xa1,0x34,0x7a,0x98,0x9c,0xed},
        {0},
        /*TST_Expected_output_data for enc Input data for decrypt*/
        {0xbd,0xa1,0x9f,0xcf,0x47,0x49,0x4d,0x5a,0x49,0x4b,0xc7,0x2b,0x0b,0xbd,0x32,0x2a,
        0xd3,0xf4,0xa4,0x1d,0x3f,0x3b,0xf4,0x31,0xec,0x2a,0x74,0x73,0x69,0x28,0x20,0x46,
        0xa2,0x95,0xd5,0x63,0x44,0x23,0x9e,0x5c,0x86,0xf5,0x3d,0x41,0xfe,0x54,0x2f,0x76,
        0x31,0x06,0x46,0x2e,0x66,0x43,0xc5,0xf7,0x23,0x97,0x09,0xd8,0xd3,0x56,0xa0,0xd8,
        0xc1,0xc9,0xdb,0x3b,0xcc,0x48,0x21,0xbe,0x03,0x01,0xd7,0xb2,0xcf,0x3a,0x9b,0x0e,
        0x40,0xe9,0xc0,0x59,0x9e,0xdb,0x94,0xcb,0x32,0x3a,0x07,0xfb,0x8b,0x95,0x67,0xee,
        0xff,0xb5,0xf3,0xb1,0xe8,0x74,0xa9,0x90,0x96,0xf1,0x4d,0x16,0xa0,0x87,0xd1,0xfb,
        0x57,0x9f,0x6a,0xc8,0xea,0xd9,0x5e,0xac,0xfe,0x3f,0xad,0x98,0x19,0xb3,0x9c,0x0d,
        0xbf,0xa3,0x83,0xd1,0x7e,0x00,0xf0,0x91,0xc6,0x9e,0x1d,0x74,0x3d,0x8f,0xd5,0xfe,
        0xba,0x76,0x80,0xda,0xb7,0x1e,0xd1,0x0d,0xa3,0x46,0x15,0x05,0x10,0x9b,0x7f,0x52,
        0xdb,0x00,0x51,0x08,0x92,0x46,0x83,0xfe,0xba,0x2f,0x6b,0xfa,0xab,0x0b,0xfe,0x3a,
        0xb8,0x54,0x9d,0x1a,0x2f,0x1c,0x7b,0x0c,0xc5,0x88,0x23,0xd4,0x3f,0x77,0x0e,0xbb,
        0xc1,0x02,0x20,0x8a,0x9c,0xfb,0x22,0xa8,0x51,0xaf,0x16,0xb7,0x67,0xb0,0x7a,0x8a,
        0xda,0xfa,0x69,0x44,0x55,0xd5,0xa2,0x00,0xf1,0x48,0x27,0x64,0xda,0xb7,0x6c,0x76,
        0x3a,0x5d,0x7d,0x92,0xc2,0x2f,0x79,0x75,0xab,0x9a,0xc4,0x57,0x9b,0x3b,0xc2,0xb4,
        0x4b,0x61,0x81,0x3c,0xae,0x94,0x8f,0x30,0xb8,0x31,0x46,0xd9,0xa7,0x9a,0x44,0x99,
        0xf0,0x12,0xc3,0x1d,0xe7,0xa7,0x13,0x5e,0x7d,0x7a,0xdf,0x16,0x3a,0xb0,0x94,0xaf,
        0x0c,0x6a,0x1d,0x23,0xc4,0xf5,0xf3,0x67,0xa7,0x3c,0xa0,0x58,0xc8,0x96,0xad,0xb7,
        0x7c,0xbb,0x05,0x1e,0xca,0xb7,0x42,0xb9,0x97,0xa7,0x59,0xda,0x5a,0x7a,0xe7,0xdd,
        0xd6,0x4b,0x46,0x2f,0xa7,0x86,0xb9,0x01,0xfd,0xab,0x48,0x4f,0xc5,0xf7,0x5c,0x8d,
        0x4b,0x07,0x72,0x01,0xf1,0x17,0x8e,0x8a,0x89,0x95,0xab,0xe8,0x6e,0xcb,0xfe,0x37,
        0x27,0xdd,0xcd,0x3a,0xeb,0x2e,0x79,0xbf,0x2b,0xf8,0xa2,0x99,0xff,0x08,0x75,0xd1,
        0x52,0xc8,0xa6,0xcf,0x04,0x18,0x00,0xb9,0x6e,0xa1,0x5a,0x03,0xb9,0xf8,0x04,0x80,
        0x21,0xcb,0x2e,0xac,0xd7,0x12,0x25,0x3f,0x45,0x82,0x83,0x74,0x64,0x8f,0x09,0xbe,
        0x0f,0xa5,0xaf,0xab,0x47,0xb9,0x0c,0xac,0xc1,0xb9,0x81,0x0f,0x15,0x12,0x00,0x90,
        0x8a,0xce,0x9d,0x9f,0xc8,0xfa,0x54,0xca,0xdb,0xf3,0x0a,0x41,0xcb,0x2d,0x44,0xc1,
        0x86,0x0f,0x07,0xf1,0x35,0x93,0x12,0x45,0x39,0x30,0x9c,0xad,0xc1,0xdb,0xd6,0xee,
        0x3b,0xeb,0xc5,0x78,0x07,0xe9,0x6c,0xb3,0x58,0x90,0x11,0x43,0xdc,0x53,0x96,0xea,
        0x99,0x63,0x5d,0x54,0xf4,0x0b,0x88,0xa9,0x7d,0x57,0x92,0x67,0x96,0xb9,0xd0,0xcf,
        0x87,0x07,0xd3,0x1c,0xb8,0x26,0x68,0x93,0xfa,0xc6,0x9f,0xc7,0x5d,0xdd,0xeb,0xd5,
        0xb9,0xca,0x7c,0xbc,0x90,0xb6,0x49,0x08,0x08,0x3d,0xd1,0x1f,0xee,0xa5,0x5f,0x90,
        0xab,0x7f,0x78,0x31,0xf9,0x6e,0x47,0x44,0x84,0x6a,0x0e,0x41,0x7a,0xab,0xf2,0x16,
        0x50,0xfd,0xd1,0xb9,0x4b,0x0a,0x65,0x47,0x43,0xc9,0xf9,0x55,0x35,0xe7,0x30,0x5a,
        0x9c,0x90,0xbb,0x85,0xd9,0x0f,0xc9,0x76,0x4b,0xef,0x5e,0x64,0xb7,0x8f,0x34,0x65,
        0x47,0xe8,0xd8,0x2f,0x7b,0x86,0xf4,0x21,0x05,0x65,0x2f,0x57,0xc1,0x18,0x67,0xd6,
        0xb5,0x9d,0xb5,0x91,0x46,0x47,0x55,0x06,0x7f,0x4c,0x81,0x41,0x3b,0x52,0xbc,0x22,
        0x75,0xd1,0xf6,0x1a,0xff,0x90,0x02,0x58,0xee,0x31,0x96,0xa6,0x78,0xb0,0xd6,0xc7,
        0x6a,0xb8,0xfa,0x03,0x21,0xb9,0xfb,0xc9,0x4e,0x59,0xdd,0x7b,0xe5,0xa6,0x01,0x59,
        0x21,0xd3,0x38,0x17,0x79,0x5e,0xfc,0x67,0xf2,0xeb,0x55,0xed,0x1b,0xa6,0xbc,0x7b,
        0xbd,0x05,0x09,0x7d,0xd6,0x75,0x3f,0x83,0xa4,0xf2,0x15,0x29,0xda,0xe7,0x11,0xd8,
        0x47,0xa4,0x0e,0xef,0xc7,0xd3,0x28,0x6f,0x64,0x4b,0x3b,0x9d,0x55,0x1e,0x2f,0x74,
        0x07,0x74,0x5f,0xc2,0x4c,0xc5,0xc0,0xa0,0xef,0xdc,0xdf,0x68,0xad,0xbe,0xd3,0x73,
        0x77,0x82,0x6c,0xa6,0xa6,0x6b,0xec,0x56,0x2e,0x85,0x24,0x10,0x9d,0xe9,0x05,0x0a,
        0x9a,0x20,0x44,0x73,0x2a,0x7a,0xd8,0x1d,0x43,0x0d,0x2a,0x55,0x92,0xdb,0x19,0x01,
        0xa7,0x01,0x9a,0x91,0x92,0xf8,0x06,0x2d,0xa7,0x2b,0x96,0x14,0xae,0x18,0x8e,0x90,
        0x05,0x81,0x1e,0x4f,0xc8,0xcc,0x7e,0x17,0xd3,0xd2,0x56,0x80,0x06,0x75,0x25,0xf5,
        0x6d,0x3c,0x3b,0x99,0xa0,0x62,0xba,0x41,0x43,0x6c,0x2f,0x6d,0x6c,0x84,0xc0,0x4d,
        0x47,0x9d,0xef,0xb3,0x10,0x0a,0x6c,0xd8,0x54,0xdc,0xa0,0x7e,0xe3,0x03,0x20,0x42,
        0x51,0x3e,0x0a,0x1c,0x94,0x1a,0xa3,0xcf,0x28,0x87,0xac,0x7e,0x73,0xd2,0xed,0x2b,
        0x9e,0x0e,0x4d,0xc4,0x3e,0xb8,0xc7,0x18,0x24,0x51,0x78,0x22,0xd6,0x08,0x31,0xbb,
        0x8f,0xf8,0x6e,0xab,0x06,0x8e,0x90,0xf0,0x13,0x2a,0xff,0xe7,0x6d,0xbd,0x0b,0x9b,
        0x16,0x0c,0x62,0xaf,0x9b,0x17,0x0a,0x85,0xd8,0x8a,0x1f,0x5e,0x5a,0xf8,0x41,0x3d,
        0xc7,0x3b,0xe2,0x26,0x31,0x6e,0x37,0x23,0xe1,0xee,0xfe,0x59,0x19,0xc1,0x25,0xd0,
        0x0b,0x7d,0x34,0x4f,0xb8,0x23,0xf3,0x24,0x1e,0xc1,0x7a,0x23,0x78,0xeb,0xc2,0x6c,
        0x7c,0xfb,0xe7,0x27,0x81,0xa9,0x6f,0xfc,0x4b,0xe7,0xf0,0x6c,0xc4,0x26,0xd4,0x9f,
        0x88,0xbd,0x6c,0xa1,0xd9,0x62,0x43,0x4d,0xb0,0xe6,0xc5,0xc6,0x4e,0x95,0x88,0x11,
        0x6e,0x97,0x14,0xb6,0x8e,0x30,0xeb,0xac,0x77,0x4d,0x82,0xc5,0x9a,0xf5,0xd2,0xc0,
        0xdd,0x15,0xd1,0x4d,0xa1,0x47,0xe5,0xda,0xbd,0x2e,0xbd,0x7c,0xad,0xe1,0xc9,0x8f,
        0xef,0xa3,0x03,0x61,0xb0,0x30,0xbd,0xe0,0x02,0xb9,0x66,0xaa,0x4d,0xee,0x17,0x99,
        0xa6,0x7f,0xb5,0xa1,0x3f,0xe7,0x41,0xaf,0x71,0x6e,0xec,0xb3,0x50,0x0e,0xa9,0x43,
        0xcc,0xf7,0x05,0x19,0x6a,0x09,0x33,0x4f,0x9d,0x78,0x04,0x87,0xfa,0xc5,0xb9,0x47,
        0x00,0x55,0xd4,0x59,0x7a,0x9d,0x07,0x35,0x62,0xeb,0xb9,0x94,0xdb,0x24,0xc3,0xc9,
        0x30,0x4d,0x11,0xdc,0x6c,0x62,0x0d,0xa4,0xf2,0x44,0x40,0x09,0x7e,0xea,0x52,0xc1,
        0x78,0x77,0x07,0xca,0xd8,0xf8,0xd8,0x45,0x0b,0x54,0x94,0x06,0x09,0x3e,0xcb,0x23,
        0x2e,0x3e,0x82,0x8c,0x04,0x4f,0x35,0x10,0xa1,0xab,0x08,0x45,0xa5,0x69,0xcb,0x6d,
        0x82,0xba,0xbc,0x72,0xb3,0xb7,0xa4,0x03,0x95,0x11,0x7d,0x7a,0xb9,0x8a,0x32,0x7b,
        0x45,0x28,0xe6,0x7e,0xc4,0x29,0x51,0xd1,0x81,0x92,0x32,0xde,0x68,0xe3,0xb4,0x71,
        0xe7,0xf1,0x16,0xf2,0x39,0xc6,0xa0,0xe4,0x1f,0xca,0x6b,0xd3,0x27,0x28,0x44,0x41,
        0xce,0x36,0x2b,0x59,0x71,0xac,0xf5,0x12,0x90,0x27,0xa5,0xee,0x2c,0xba,0xa1,0x5f,
        0x80,0xcb,0x61,0x9a,0xd4,0xb6,0xe0,0xd6,0xa8,0xb8,0xba,0x1c,0x53,0x21,0x12,0xb0,
        0x2f,0x14,0x41,0x2b,0x8d,0x75,0x3b,0xb4,0x94,0x60,0x33,0x2a,0x27,0x20,0xb9,0xa3,
        0x49,0x47,0x19,0xbd,0x85,0x81,0x47,0xf2,0x11,0xa1,0xc3,0xf3,0x12,0xd6,0x88,0x57,
        0x48,0xd0,0x9d,0xba,0xe4,0xf1,0xdd,0xdd,0x84,0xc6,0x7d,0xbc,0xc4,0x08,0x78,0x89,
        0x5a,0x72,0xa2,0xd2,0x83,0xe5,0xd1,0xdf,0x0f,0xa7,0x98,0x5a,0xa8,0x68,0x5d,0xcf,
        0x51,0x5f,0x7f,0x07,0x0e,0xc2,0x73,0xc9,0xf5,0x92,0xd7,0xc1,0x5e,0x8f,0x2e,0x78,
        0x4e,0x8e,0xb1,0x3b,0xfb,0x9d,0xd5,0xd0,0x78,0xb5,0xb8,0x0b,0x8d,0xf1,0x27,0x87,
        0xb5,0x6a,0xf0,0x4e,0xf6,0xd7,0xd6,0x22,0x87,0xd6,0xfa,0x11,0x3e,0x0a,0x81,0xe8,
        0x10,0x15,0xc9,0xc0,0x77,0xbf,0x92,0xa3,0xef,0xc6,0xe6,0x6d,0x0f,0xbe,0xd9,0xbe,
        0x4e,0x5d,0x92,0x18,0x8d,0xb9,0xc5,0x6e,0x50,0x70,0xaa,0xcd,0xfc,0x84,0xce,0x4d,
        0x6c,0x82,0xe4,0xb8,0xc6,0xeb,0x20,0x45,0x88,0xa1,0x2f,0xfe,0x85,0x2c,0xcd,0xec,
        0x70,0x67,0xd2,0x6e,0xbd,0xde,0x0e,0x7c,0x0d,0xfa,0x65,0x9f,0x1f,0x6f,0x2b,0xef,
        0xcc,0xc6,0x2e,0xfd,0xa5,0xb4,0xc2,0x55,0x4b,0xa8,0x12,0x2f,0x3d,0x0b,0x4b,0x8b,
        0xc7,0x0e,0xec,0x91,0xd3,0x47,0xec,0x8f,0x46,0x70,0xa4,0xf7,0x12,0x0f,0xc5,0x61,
        0xfb,0xe5,0x2e,0xc1,0x57,0x1b,0x3f,0xe5,0xed,0x72,0xd7,0x5f,0xde,0xa4,0x2b,0x8a,
        0x60,0x65,0xba,0x53,0x74,0x6f,0xde,0xd2,0x23,0x16,0x6b,0xd8,0x74,0x49,0x7c,0x7e,
        0x71,0xb6,0xdf,0x7b,0xcb,0x22,0xa7,0x5a,0xf5,0xca,0x9a,0xe4,0x21,0xb8,0xbd,0x46,
        0x35,0xb9,0xe4,0x76,0x9c,0x39,0x58,0x6a,0xa0,0xb0,0x6a,0xc9,0x35,0xaa,0x51,0xc7,
        0x76,0x97,0xef,0x7c,0xef,0x2e,0x19,0x1b,0xf1,0x91,0x90,0x09,0xa7,0x62,0xe7,0x3f,
        0x67,0x76,0x07,0x25,0x6b,0x22,0x6c,0x7e,0x72,0xd1,0x4e,0xeb,0x43,0x63,0x92,0x10,
        0x22,0xea,0x3f,0x28,0xf4,0xe1,0xf0,0x09,0xd7,0xb3,0x6a,0x24,0xed,0x82,0x98,0x61,
        0xe9,0x80,0xfc,0x1c,0xc3,0x6b,0x71,0x60,0x75,0x36,0x5b,0xcf,0x19,0xd5,0x20,0xd0,
        0x6d,0x50,0xce,0x58,0x50,0x70,0xad,0x9b,0x4e,0x2a,0x92,0x50,0x04,0x9f,0xbb,0x84,
        0x0b,0x2d,0xd4,0xac,0x6c,0xb6,0x69,0xd8,0xf7,0x64,0x78,0xa9,0x51,0x13,0x5f,0x08,
        0xb6,0x3b,0x63,0x91,0xe7,0xed,0x8a,0xb9,0xe5,0xab,0x0b,0x61,0xe4,0x38,0x1a,0xe9,
        0x54,0x60,0xf3,0x99,0x15,0x24,0x9d,0x97,0xdc,0xe8,0x6f,0x23,0x63,0x9b,0xb7,0xdd,
        0x7f,0x5b,0xa5,0xae,0x18,0x62,0xbc,0x75,0xb4,0xb6,0x66,0xc6,0x60,0xf5,0x44,0x14}, 
        /*TST_dataSize*/
        1536*sizeof(DxUint8_t),
        CRYS_AES_ECB_mode
    },
    #endif
    #endif
    #if TST_USE_AES_256_KEY
    #if TST_USE_AES_16BYTE_DATA
    { 
        {"Acceptance test - AES/ECB/256Key/16ByteData "},
        /*TST_Key*/     
        {0x60,0x3d,0xeb,0x10,0x15,0xca,0x71,0xbe,0x2b,0x73,0xae,0xf0,0x85,0x7d,0x77,0x81, 
         0x1f,0x35,0x2c,0x07,0x3b,0x61,0x08,0xd7,0x2d,0x98,0x10,0xa3,0x09,0x14,0xdf,0xf4},
        CRYS_AES_Key256BitSize,
        /*TST_IvCounter*/       
        {0},
        /*TST_input_data*/
        {0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a},
        {0},
        /*TST_Expected_output_data for enc Input data for decrypt*/
        {0xf3,0xee,0xd1,0xbd,0xb5,0xd2,0xa0,0x3c,0x06,0x4b,0x5a,0x7e,0x3d,0xb1,0x81,0xf8}, 
        /*TST_dataSize*/
        16*sizeof(DxUint8_t),       
        CRYS_AES_ECB_mode
    },
    #endif
    #if TST_USE_AES_32BYTE_DATA
    { 
        {"Acceptance test - AES/ECB/256Key/32ByteData "},
        /*TST_Key*/     
        {0x60,0x3d,0xeb,0x10,0x15,0xca,0x71,0xbe,0x2b,0x73,0xae,0xf0,0x85,0x7d,0x77,0x81,
         0x1f,0x35,0x2c,0x07,0x3b,0x61,0x08,0xd7,0x2d,0x98,0x10,0xa3,0x09,0x14,0xdf,0xf4},
        CRYS_AES_Key256BitSize,
        /*TST_IvCounter*/       
        {0},
        /*TST_input_data*/
        {0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a,
         0xf3,0xee,0xd1,0xbd,0xb5,0xd2,0xa0,0x3c,0x06,0x4b,0x5a,0x7e,0x3d,0xb1,0x81,0xf8},
        {0},
        /*TST_Expected_output_data for enc Input data for decrypt*/
        {0xf3,0xee,0xd1,0xbd,0xb5,0xd2,0xa0,0x3c,0x06,0x4b,0x5a,0x7e,0x3d,0xb1,0x81,0xf8,
         0xef,0x15,0xad,0x58,0x95,0xe4,0x02,0x50,0x06,0xd2,0x8f,0xb1,0x3f,0x2a,0xfe,0x1b}, 
        /*TST_dataSize*/
        32*sizeof(DxUint8_t),     
        CRYS_AES_ECB_mode
    },
    #endif
    #if TST_USE_AES_512BYTE_DATA
    {
        {"Acceptance test - AES/ECB/256Key/512ByteData"},
        /*TST_Key*/     
        {0x60,0x3d,0xeb,0x10,0x15,0xca,0x71,0xbe,0x2b,0x73,0xae,0xf0,0x85,0x7d,0x77,0x81,
         0x1f,0x35,0x2c,0x07,0x3b,0x61,0x08,0xd7,0x2d,0x98,0x10,0xa3,0x09,0x14,0xdf,0xf4},                                                                                          
        CRYS_AES_Key256BitSize,
        /*TST_IvCounter*/       
        {0},
        /*TST_input_data*/
        {0x30,0xc8,0x1c,0x46,0xa3,0x5c,0xe4,0x11,0xe5,0xfb,0xc1,0x19,0x1a,0x0a,0x52,0xef,
         0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a,
         0x3a,0xd7,0x7b,0xb4,0x0d,0x7a,0x36,0x60,0xa8,0x9e,0xca,0xf3,0x24,0x66,0xef,0x97,
         0xf5,0xd3,0xd5,0x85,0x03,0xb9,0x69,0x9d,0xe7,0x85,0x89,0x5a,0x96,0xfd,0xba,0xaf,
         0x43,0xb1,0xcd,0x7f,0x59,0x8e,0xce,0x23,0x88,0x1b,0x00,0xe3,0xed,0x03,0x06,0x88,
         0x7b,0x0c,0x78,0x5e,0x27,0xe8,0xad,0x3f,0x82,0x23,0x20,0x71,0x04,0x72,0x5d,0xd4,
         0x3a,0xd7,0x7b,0xb4,0x0d,0x7a,0x36,0x60,0xa8,0x9e,0xca,0xf3,0x24,0x66,0xef,0x97,
         0xf5,0xd3,0xd5,0x85,0x03,0xb9,0x69,0x9d,0xe7,0x85,0x89,0x5a,0x96,0xfd,0xba,0xaf,
         0x30,0xc8,0x1c,0x46,0xa3,0x5c,0xe4,0x11,0xe5,0xfb,0xc1,0x19,0x1a,0x0a,0x52,0xef,
         0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a,
         0x3a,0xd7,0x7b,0xb4,0x0d,0x7a,0x36,0x60,0xa8,0x9e,0xca,0xf3,0x24,0x66,0xef,0x97,
         0xf5,0xd3,0xd5,0x85,0x03,0xb9,0x69,0x9d,0xe7,0x85,0x89,0x5a,0x96,0xfd,0xba,0xaf,
         0x43,0xb1,0xcd,0x7f,0x59,0x8e,0xce,0x23,0x88,0x1b,0x00,0xe3,0xed,0x03,0x06,0x88,
         0x7b,0x0c,0x78,0x5e,0x27,0xe8,0xad,0x3f,0x82,0x23,0x20,0x71,0x04,0x72,0x5d,0xd4,
         0x3a,0xd7,0x7b,0xb4,0x0d,0x7a,0x36,0x60,0xa8,0x9e,0xca,0xf3,0x24,0x66,0xef,0x97,
         0xf5,0xd3,0xd5,0x85,0x03,0xb9,0x69,0x9d,0xe7,0x85,0x89,0x5a,0x96,0xfd,0xba,0xaf,
         0x30,0xc8,0x1c,0x46,0xa3,0x5c,0xe4,0x11,0xe5,0xfb,0xc1,0x19,0x1a,0x0a,0x52,0xef,
         0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a,
         0x3a,0xd7,0x7b,0xb4,0x0d,0x7a,0x36,0x60,0xa8,0x9e,0xca,0xf3,0x24,0x66,0xef,0x97,
         0xf5,0xd3,0xd5,0x85,0x03,0xb9,0x69,0x9d,0xe7,0x85,0x89,0x5a,0x96,0xfd,0xba,0xaf,
         0x43,0xb1,0xcd,0x7f,0x59,0x8e,0xce,0x23,0x88,0x1b,0x00,0xe3,0xed,0x03,0x06,0x88,
         0x7b,0x0c,0x78,0x5e,0x27,0xe8,0xad,0x3f,0x82,0x23,0x20,0x71,0x04,0x72,0x5d,0xd4,
         0x3a,0xd7,0x7b,0xb4,0x0d,0x7a,0x36,0x60,0xa8,0x9e,0xca,0xf3,0x24,0x66,0xef,0x97,
         0xf5,0xd3,0xd5,0x85,0x03,0xb9,0x69,0x9d,0xe7,0x85,0x89,0x5a,0x96,0xfd,0xba,0xaf,
         0x30,0xc8,0x1c,0x46,0xa3,0x5c,0xe4,0x11,0xe5,0xfb,0xc1,0x19,0x1a,0x0a,0x52,0xef,
         0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a,
         0x3a,0xd7,0x7b,0xb4,0x0d,0x7a,0x36,0x60,0xa8,0x9e,0xca,0xf3,0x24,0x66,0xef,0x97,
         0xf5,0xd3,0xd5,0x85,0x03,0xb9,0x69,0x9d,0xe7,0x85,0x89,0x5a,0x96,0xfd,0xba,0xaf,
         0x43,0xb1,0xcd,0x7f,0x59,0x8e,0xce,0x23,0x88,0x1b,0x00,0xe3,0xed,0x03,0x06,0x88,
         0x7b,0x0c,0x78,0x5e,0x27,0xe8,0xad,0x3f,0x82,0x23,0x20,0x71,0x04,0x72,0x5d,0xd4,
         0x3a,0xd7,0x7b,0xb4,0x0d,0x7a,0x36,0x60,0xa8,0x9e,0xca,0xf3,0x24,0x66,0xef,0x97,
         0xf5,0xd3,0xd5,0x85,0x03,0xb9,0x69,0x9d,0xe7,0x85,0x89,0x5a,0x96,0xfd,0xba,0xaf},
        {0},
        /*TST_Expected_output_data for enc Input data for decrypt*/
        {0xb6,0xed,0x21,0xb9,0x9c,0xa6,0xf4,0xf9,0xf1,0x53,0xe7,0xb1,0xbe,0xaf,0xed,0x1d,
         0xf3,0xee,0xd1,0xbd,0xb5,0xd2,0xa0,0x3c,0x06,0x4b,0x5a,0x7e,0x3d,0xb1,0x81,0xf8,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0x62,0xf8,0xa7,0x23,0x7b,0xbd,0xf8,0x4d,0x4e,0x1d,0xff,0xe8,0xb5,0x2a,0x02,0xc1,
         0x52,0xdb,0x14,0x2f,0xeb,0x21,0xf9,0x58,0xb8,0x80,0x28,0x68,0xe4,0x99,0x06,0x18,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0xb6,0xed,0x21,0xb9,0x9c,0xa6,0xf4,0xf9,0xf1,0x53,0xe7,0xb1,0xbe,0xaf,0xed,0x1d,
         0xf3,0xee,0xd1,0xbd,0xb5,0xd2,0xa0,0x3c,0x06,0x4b,0x5a,0x7e,0x3d,0xb1,0x81,0xf8,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0x62,0xf8,0xa7,0x23,0x7b,0xbd,0xf8,0x4d,0x4e,0x1d,0xff,0xe8,0xb5,0x2a,0x02,0xc1,
         0x52,0xdb,0x14,0x2f,0xeb,0x21,0xf9,0x58,0xb8,0x80,0x28,0x68,0xe4,0x99,0x06,0x18,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0xb6,0xed,0x21,0xb9,0x9c,0xa6,0xf4,0xf9,0xf1,0x53,0xe7,0xb1,0xbe,0xaf,0xed,0x1d,
         0xf3,0xee,0xd1,0xbd,0xb5,0xd2,0xa0,0x3c,0x06,0x4b,0x5a,0x7e,0x3d,0xb1,0x81,0xf8,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0x62,0xf8,0xa7,0x23,0x7b,0xbd,0xf8,0x4d,0x4e,0x1d,0xff,0xe8,0xb5,0x2a,0x02,0xc1,
         0x52,0xdb,0x14,0x2f,0xeb,0x21,0xf9,0x58,0xb8,0x80,0x28,0x68,0xe4,0x99,0x06,0x18,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0xb6,0xed,0x21,0xb9,0x9c,0xa6,0xf4,0xf9,0xf1,0x53,0xe7,0xb1,0xbe,0xaf,0xed,0x1d,
         0xf3,0xee,0xd1,0xbd,0xb5,0xd2,0xa0,0x3c,0x06,0x4b,0x5a,0x7e,0x3d,0xb1,0x81,0xf8,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0x62,0xf8,0xa7,0x23,0x7b,0xbd,0xf8,0x4d,0x4e,0x1d,0xff,0xe8,0xb5,0x2a,0x02,0xc1,
         0x52,0xdb,0x14,0x2f,0xeb,0x21,0xf9,0x58,0xb8,0x80,0x28,0x68,0xe4,0x99,0x06,0x18,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9}, 
        /*TST_dataSize*/
        512*sizeof(DxUint8_t),
        CRYS_AES_ECB_mode
    },
    #endif
    #if TST_USE_AES_1536BYTE_DATA
    { 
        {"Acceptance test - AES/ECB/256Key/1536ByteData "},
            /*TST_Key*/     
        {0xc0,0xd1,0x93,0xe2,0xe4,0xfc,0x89,0xd5,0xc8,0x5a,0x94,0x83,0x8f,0xcd,0x1d,0x81,
        0x0e,0x2d,0xad,0x02,0x38,0xea,0x02,0x9c,0xd9,0xf3,0x63,0x4f,0x88,0xd6,0x30,0xc3},
        CRYS_AES_Key256BitSize,
        /*TST_IvCounter*/       
        {0},
        /*TST_input_data*/
        {0x47,0x16,0xe6,0x72,0xc8,0x03,0x08,0x89,0x4a,0x6e,0x3c,0xcf,0x0d,0x9e,0x79,0xf1,
        0x5f,0xc1,0x08,0xa1,0x79,0x3a,0x8b,0x8b,0xa4,0x3c,0x3d,0x8b,0xa0,0x98,0x7b,0x1d,
        0x45,0xd3,0x84,0x15,0x6b,0x7c,0x7d,0x90,0x08,0xbc,0xb8,0x2a,0x98,0x2f,0x35,0x71,
        0xc2,0xf2,0x69,0x9a,0x38,0xfe,0x3f,0x73,0xdf,0xb4,0x5d,0x99,0x30,0xb8,0xa8,0xeb,
        0xde,0x03,0x0a,0x3e,0xb8,0x34,0x73,0x53,0xd2,0x27,0x1d,0x06,0xdf,0xc9,0x15,0xc7,
        0xe2,0x2b,0xf7,0x4e,0x06,0xd5,0xf8,0x8b,0xc9,0x5c,0x2a,0xdc,0x60,0x37,0xfc,0x83,
        0x57,0xce,0x00,0x57,0x79,0xd4,0xf2,0xb9,0xef,0xd7,0xf5,0xca,0xac,0x15,0x1f,0xdc,
        0x08,0x92,0x38,0x26,0xaa,0x67,0xbf,0xbb,0xac,0x5d,0x2e,0xbd,0xfa,0xba,0x80,0xcd,
        0xfb,0x5b,0xef,0xc7,0x74,0x03,0x02,0xac,0xa9,0xf3,0xc7,0xe0,0xc5,0xbb,0x5d,0x96,
        0x7b,0x4f,0xb6,0x88,0xee,0x5d,0x9b,0xeb,0xce,0xde,0xf1,0xa2,0xc4,0xec,0x3a,0xb2,
        0x11,0xd3,0x5f,0xf6,0x72,0x6a,0xac,0x14,0x46,0xa4,0x1c,0xaf,0xf2,0x62,0xd7,0xde,
        0x85,0x8b,0xf9,0xdd,0x98,0x5f,0x95,0x03,0x79,0x08,0xfa,0xf4,0x88,0x72,0x34,0x18,
        0xe0,0x5d,0xd6,0x4c,0x3a,0xb1,0xf7,0xd7,0x0f,0x11,0x7b,0x9f,0xfd,0xb2,0x94,0x9d,
        0x6c,0x6e,0x87,0x8e,0x71,0x14,0xb4,0xeb,0xf3,0x03,0xd1,0x1c,0x0c,0xf7,0x76,0xe9,
        0xb1,0x22,0xde,0x31,0x96,0x7f,0xec,0xde,0x4c,0x63,0x6c,0x18,0xac,0x55,0x9c,0xb9,
        0x79,0x1f,0xea,0x01,0x41,0x25,0x00,0x8c,0x84,0xf6,0xfe,0x80,0x19,0x21,0x06,0x0b,
        0xcc,0x4a,0xfe,0x0d,0x4c,0x7c,0x91,0x11,0x45,0xc1,0x77,0x82,0xc9,0xf0,0xf7,0x1c,
        0xf4,0xc7,0xaa,0xa0,0xd0,0x39,0x81,0xcc,0x76,0x09,0x09,0x8a,0x76,0x98,0xee,0x68,
        0x79,0xfc,0xbf,0x48,0x25,0x51,0xf0,0x58,0x41,0x54,0x25,0x45,0x1a,0x2e,0xae,0xac,
        0x25,0x8d,0x4d,0xd2,0xe5,0xf9,0x40,0x94,0x0f,0x66,0x7b,0xa1,0xed,0x05,0x36,0xe6,
        0x00,0x60,0xa7,0x4a,0xe9,0xa6,0x11,0x9c,0x8a,0x43,0xfd,0xc9,0x68,0xb4,0xc7,0x53,
        0x53,0x9a,0x5d,0xfe,0x4a,0x0d,0x44,0xcd,0x99,0x32,0xdc,0x2c,0x44,0x10,0xe4,0x6f,
        0xa8,0x9f,0x40,0x7b,0x60,0x22,0xfa,0xc3,0x66,0xb7,0x88,0x77,0x7a,0x2d,0x4d,0xf7,
        0xc8,0x15,0x62,0x8e,0xc5,0x1c,0x95,0x5d,0x5a,0x98,0xb2,0x95,0x44,0x60,0x02,0xea,
        0xbb,0xe1,0x12,0x44,0x51,0x6e,0xb5,0xb7,0x1e,0xd8,0x4c,0xb5,0x1a,0x3f,0x45,0x82,
        0xca,0x27,0xe2,0xe9,0x1f,0xce,0x3c,0x2e,0x9b,0xbe,0x87,0x43,0xb5,0x9e,0x97,0x3e,
        0x7f,0x4d,0xa3,0x0b,0x86,0x32,0x4a,0x5e,0xf9,0xcd,0xd3,0xec,0x0e,0x92,0xb9,0xdb,
        0xa2,0xf8,0x67,0x77,0x20,0xcd,0x40,0x26,0xa3,0xcc,0xe2,0x9e,0x5f,0x71,0xac,0x55,
        0x3d,0x0c,0x7e,0x39,0xc5,0x15,0xbf,0xa2,0x41,0xbf,0xa5,0x85,0x1f,0xcf,0xb0,0xea,
        0x98,0xaf,0x78,0xa0,0x8f,0xbe,0xa9,0x2f,0xbc,0xeb,0x4c,0x0e,0x09,0x82,0x48,0x16,
        0x3c,0x45,0x28,0x37,0xd7,0xbf,0x1e,0x6a,0x3c,0xd5,0x48,0xe6,0x15,0x9e,0x33,0x97,
        0xf3,0x75,0x9e,0xcc,0x35,0x4c,0x80,0x30,0x2c,0x43,0x4c,0xfb,0x7d,0x79,0x73,0x69,
        0xc6,0x21,0x2a,0x6c,0x84,0xd9,0x6f,0x9d,0x34,0x38,0x46,0x79,0xb8,0xa6,0x49,0xca,
        0xfd,0x71,0x5f,0x63,0xdb,0x1d,0xcc,0x10,0x3c,0xfb,0x6a,0xcd,0x81,0xfd,0x35,0x36,
        0x21,0xc8,0x0d,0x3f,0x93,0x0b,0xb8,0x25,0x6f,0x0f,0x27,0xa5,0xd0,0x90,0xfa,0x6b,
        0xfc,0xcc,0x46,0xcd,0x47,0xd9,0x95,0xb9,0x34,0x3b,0x2e,0xec,0xde,0xb6,0x97,0x65,
        0x96,0x61,0x59,0x1a,0xce,0xfc,0x03,0xe9,0x36,0x83,0x71,0xd1,0x24,0x03,0x4e,0x62,
        0x39,0xad,0xd8,0x72,0x42,0x29,0xe3,0x12,0x5c,0x2d,0x21,0xc1,0x5c,0x4d,0xa0,0xdf,
        0x6d,0x15,0x94,0x64,0xfb,0x55,0x57,0xd1,0xd0,0xbc,0xae,0x67,0x7d,0xa8,0x4e,0x97,
        0xfc,0x3d,0x9f,0xbb,0x93,0xb5,0xbf,0x03,0xfb,0xf6,0xca,0xb2,0xc2,0x6a,0x59,0x8a,
        0xee,0x0b,0x48,0x84,0xe3,0xbd,0xbd,0xc5,0x87,0xe1,0x65,0xce,0xa3,0x27,0x01,0xf3,
        0x8d,0xa3,0x22,0x0e,0x04,0x24,0x30,0x74,0x5b,0xc1,0xb1,0x28,0xda,0xb4,0xc8,0x4f,
        0x61,0x6c,0xfc,0xe4,0x4e,0xdd,0x3b,0xad,0xa1,0x1b,0x1f,0x6e,0x5e,0x27,0x70,0x5c,
        0x33,0x08,0xe9,0xd4,0x5b,0x1e,0x3f,0x4d,0xc2,0xb4,0x5f,0x8c,0x6a,0xd4,0xf7,0x17,
        0x0d,0x5f,0x39,0xeb,0x04,0x5d,0xdc,0x71,0x67,0x91,0x63,0xaf,0x76,0x50,0xa1,0xbb,
        0x37,0x94,0x7d,0x76,0x61,0x4d,0xf3,0x76,0x79,0xf7,0x5b,0x44,0x3b,0x71,0xee,0xc8,
        0x3b,0x0d,0x86,0x01,0xcc,0xe4,0xa5,0xfa,0x21,0x6c,0xb9,0xf9,0xb2,0x4c,0x9e,0xf9,
        0xe1,0x6e,0x65,0x5a,0xde,0x56,0x54,0xd8,0xc8,0xb3,0x2d,0xba,0x15,0x34,0xb4,0x4b,
        0x33,0x9d,0x6b,0x8e,0x6f,0x1a,0xa0,0x2e,0x17,0xd3,0xa9,0xb4,0xdb,0xc0,0x6f,0xfc,
        0x79,0xbf,0x29,0xea,0x9a,0xe4,0x6a,0x59,0xf6,0x10,0x5e,0x54,0xbf,0xc5,0x50,0x89,
        0x3d,0x38,0x70,0xfa,0xb6,0xa8,0xd4,0xf6,0x90,0xef,0xbc,0x48,0xb9,0x57,0x1a,0xae,
        0x47,0xae,0x52,0x8d,0x5c,0x9d,0x3e,0xe2,0x4d,0x35,0x75,0x7c,0x03,0xcb,0xcd,0x69,
        0xa1,0x06,0x1e,0xae,0x66,0x36,0x49,0x3b,0xd6,0xe7,0x79,0x1d,0x14,0xb7,0xa9,0xf6,
        0x93,0x64,0x67,0xaa,0xed,0x29,0xd7,0x5c,0x13,0x4b,0xfa,0x99,0xa7,0xef,0x30,0xd2,
        0xa6,0x2e,0xfc,0x10,0x4a,0x6b,0x08,0xe3,0x2f,0xe4,0x69,0x9b,0xb4,0x88,0x23,0xbb,
        0xa4,0x09,0xf0,0xab,0x16,0x31,0x3d,0xad,0x91,0x79,0x76,0x12,0x74,0xd8,0x83,0xae,
        0x95,0xd9,0x93,0x89,0x29,0xf0,0x18,0xd7,0xe4,0x0e,0x12,0x2b,0x61,0x73,0x91,0xe7,
        0xc3,0xc4,0x75,0xf7,0x9d,0x5d,0x79,0xbf,0x0f,0xe8,0x70,0x51,0x32,0x2e,0xce,0xe4,
        0xb6,0x2e,0x69,0x82,0xca,0x6c,0x81,0x00,0x3c,0x8c,0xfe,0x33,0xe2,0x1f,0xfa,0x61,
        0x38,0xbd,0x7f,0xf6,0x4a,0x54,0x92,0x78,0xd5,0xbf,0x70,0xbd,0xa9,0x9b,0x17,0x5c,
        0x51,0x56,0x08,0x61,0xf6,0x88,0x4c,0x45,0x81,0x87,0xb5,0x1d,0x00,0x36,0x66,0x11,
        0x4b,0x1d,0x95,0x10,0xe7,0xbf,0x90,0xc2,0x2a,0x27,0xfe,0xbe,0xa0,0xc5,0x68,0xfe,
        0xae,0x78,0xf8,0x8f,0x75,0xec,0x80,0x8d,0xf9,0x26,0xbd,0x4f,0x83,0x5d,0xde,0xdf,
        0x44,0x0c,0x40,0xad,0x3a,0x45,0x7c,0x84,0x58,0x48,0xa3,0xbc,0xe1,0x54,0xc8,0xb2,
        0x15,0xbd,0xbf,0x75,0x0f,0x3f,0x25,0xc2,0xee,0x92,0xa0,0x33,0x33,0x3e,0x68,0xb3,
        0x6a,0xb1,0x07,0x35,0x0d,0x8f,0x5d,0xa6,0xa5,0x49,0xe6,0x1f,0x32,0xf1,0x40,0x60,
        0xcd,0x4d,0xe7,0x7a,0x8c,0x2a,0x44,0xcb,0xa6,0xf2,0xe6,0x2f,0xd7,0x81,0x0f,0x75,
        0x06,0x35,0x72,0x10,0x26,0x44,0x3b,0x0f,0x5a,0x53,0x50,0x50,0x5c,0x44,0xd6,0xf0,
        0x1f,0x4f,0xf8,0x05,0xb3,0x54,0xe3,0x90,0x6a,0x6f,0x15,0xad,0x39,0xce,0xd8,0x0d,
        0x60,0xbf,0x09,0xa6,0x4d,0x0d,0x1e,0xa9,0xbe,0x8d,0x68,0xb5,0x27,0xf4,0x94,0x4a,
        0x53,0xeb,0x78,0x80,0x4d,0x66,0x0d,0xf9,0x81,0x31,0xb7,0x14,0x1f,0xcb,0xcd,0x63,
        0xc0,0x78,0x55,0x60,0x4c,0x92,0x0f,0x5b,0x1b,0x20,0xb6,0xb7,0x5a,0xaa,0x82,0x56,
        0xb1,0x4b,0xf1,0x52,0x22,0x07,0xc7,0xee,0x35,0x5f,0x53,0xcc,0x52,0x23,0xf5,0x60,
        0x6e,0x88,0xdd,0xa4,0xea,0x7a,0x15,0x0d,0xb7,0x33,0xc2,0xbe,0xbf,0x0d,0xa7,0xfd,
        0x80,0x94,0xea,0xe3,0xfa,0xe0,0x1b,0x57,0xcc,0x22,0x72,0x3d,0x9a,0x7c,0x58,0xea,
        0xb1,0x16,0x29,0xdb,0xee,0x6e,0x39,0xa7,0xdc,0xef,0x15,0x33,0x1c,0xc6,0x0b,0x25,
        0x0a,0xf1,0xec,0x9b,0x9d,0x98,0x10,0x1c,0x8f,0xa1,0x9b,0xcf,0xbe,0x7f,0xff,0xea,
        0xd3,0x4a,0xc2,0x6e,0x21,0x15,0x82,0x12,0xd0,0x7c,0x36,0x7c,0x3a,0x7c,0xb6,0xb7,
        0x95,0x88,0x7e,0xe2,0xd3,0xd8,0xae,0x25,0xc6,0x05,0x56,0xea,0x88,0xd3,0xf1,0x49,
        0x1a,0x4d,0x2f,0xc3,0x4b,0x18,0xf8,0x34,0xdb,0x01,0xad,0x03,0xe1,0xd8,0xb1,0x9c,
        0x6a,0x81,0x28,0x20,0x63,0x48,0xfe,0x5a,0xb9,0x75,0x2b,0xf6,0xbe,0x20,0x36,0xed,
        0xcf,0x47,0xf8,0x44,0x34,0x1e,0xa3,0xf6,0x47,0xa6,0x03,0x2f,0xd8,0x81,0x03,0xba,
        0xd1,0x05,0x72,0xbd,0x16,0x8f,0x07,0xa4,0xaf,0x1a,0xa3,0x5b,0x29,0x10,0xd7,0xc0,
        0x39,0x5f,0xa6,0x58,0xa3,0xd0,0x8c,0x40,0x5a,0x95,0xbf,0x67,0xe9,0x20,0xb4,0xfb,
        0x11,0x3c,0xe5,0x21,0xb4,0x56,0xd2,0xe9,0xf2,0x1b,0x45,0x81,0x91,0x49,0xdb,0xa9,
        0xa2,0xbe,0xc0,0x66,0x61,0xd6,0xba,0xfb,0x5e,0xf3,0x69,0x15,0xda,0x5d,0xcd,0x46,
        0x74,0x4d,0x08,0xb4,0x05,0x44,0x65,0x13,0xc8,0xa1,0x9a,0xd0,0xbe,0x73,0x4a,0x8f,
        0x50,0x8c,0xce,0xd8,0x37,0xd7,0x35,0x0d,0x99,0xeb,0x89,0xa0,0x74,0xdf,0x54,0x82,
        0x40,0x60,0x63,0xdf,0xd0,0x02,0xca,0x08,0x7a,0xd4,0x29,0xb1,0x77,0x37,0x2d,0x5c,
        0x8c,0xf0,0x59,0x15,0xea,0x7b,0x06,0x60,0x54,0xa2,0xa8,0x70,0x7f,0x4f,0x54,0x99,
        0xbe,0x9f,0x7f,0x08,0xdf,0x37,0x09,0xb2,0x4f,0xdb,0x7a,0x8a,0x85,0x3d,0x8b,0xf7,
        0x9e,0x12,0xe8,0x85,0x45,0x6b,0x34,0xdb,0xd6,0x43,0x4d,0xed,0xc3,0x54,0xd2,0x72,
        0x36,0x30,0xe3,0x99,0xf8,0x8c,0x28,0xf7,0x91,0xdf,0x15,0xc4,0xb1,0x2c,0x6c,0x48,
        0xce,0x1b,0x03,0x90,0x0f,0x4f,0xc7,0x65,0x69,0xf4,0x01,0x7f,0x08,0x97,0xd8,0xf5,
        0xf0,0x3b,0x17,0xf8,0xe4,0xa9,0x31,0xc1,0x86,0x07,0x83,0xc8,0xc1,0xac,0xd8,0x37,
        0x64,0x33,0x32,0x9e,0x0f,0xce,0xc8,0xe8,0x53,0xdd,0x4b,0x8e,0x15,0xc0,0x6d,0x0a},
        {0},
        /*TST_Expected_output_data for enc Input data for decrypt*/
        {0x79,0xe4,0x75,0xc9,0x1c,0xb5,0x58,0x50,0xa7,0x99,0xfa,0x88,0x6f,0xa5,0x41,0x97,
        0x1b,0xe7,0x10,0x97,0x49,0x40,0x47,0xf4,0x8a,0x52,0xcd,0x20,0xe8,0x09,0xeb,0xbc,
        0x8b,0xf8,0x96,0x27,0x1c,0x68,0x33,0x17,0xc2,0x65,0x20,0xca,0x0a,0x8e,0x8e,0x5b,
        0x28,0x3c,0x78,0xe0,0xb9,0x07,0x3b,0x3f,0xe3,0xce,0xfd,0xde,0xaa,0x3b,0x51,0x6b,
        0x9b,0x57,0xfd,0xb4,0xff,0xaa,0x67,0x80,0x49,0xa3,0xf3,0xb6,0x41,0x00,0xc9,0x60,
        0x48,0xdd,0x59,0xc6,0x1b,0x88,0xeb,0xd2,0x01,0x1d,0xf3,0x4d,0x2e,0x36,0xb5,0xd1,
        0x26,0x08,0xf9,0xb0,0x28,0x80,0x81,0xd8,0x51,0xd2,0xe6,0xc0,0xf6,0x15,0xe8,0x5d,
        0xe3,0x91,0xe4,0xd5,0xfa,0xf4,0x51,0x1b,0x7d,0xa2,0x1b,0x09,0xe4,0x74,0x88,0x01,
        0xf2,0xdf,0x68,0x9a,0xfa,0xdd,0x90,0x4b,0xfa,0xd5,0x67,0xd4,0xa5,0xaf,0xb1,0x91,
        0x15,0x45,0x36,0xfb,0xf6,0x24,0x57,0xa8,0x92,0x9f,0xea,0x5c,0x45,0xb9,0x9c,0x53,
        0xe1,0x1c,0x80,0x15,0xed,0x84,0x3b,0xb5,0x5a,0x58,0xfc,0x76,0xde,0xff,0x8a,0x03,
        0x45,0x76,0x2a,0x71,0xee,0x91,0x3e,0x17,0xd5,0xc0,0x62,0xde,0x5b,0xec,0x16,0x3e,
        0x10,0xd2,0x82,0x0a,0x4c,0xa3,0x09,0xcf,0x91,0x1e,0x12,0x2b,0x95,0x90,0xb8,0x1b,
        0x6b,0x83,0xa8,0xa4,0xf3,0xb3,0x50,0x36,0x8e,0xe9,0x5b,0xfe,0x29,0xe2,0xb3,0x32,
        0x73,0x9b,0x02,0x53,0x3e,0x19,0xda,0x29,0x64,0x3b,0x70,0x12,0x34,0x89,0x49,0x17,
        0x30,0x67,0xf0,0x14,0xa5,0x9a,0x56,0x65,0x8e,0xda,0xfe,0x82,0x6c,0xb3,0x64,0x17,
        0xa1,0x48,0x17,0x88,0x58,0x94,0xfe,0xdd,0x2b,0xa2,0x90,0xcd,0x61,0xf8,0xc1,0x45,
        0xcd,0xae,0x76,0x13,0xbe,0x7d,0x19,0x03,0x80,0x5a,0x62,0x32,0xb6,0x43,0x85,0xb2,
        0xb6,0xa1,0xad,0xfc,0x97,0x18,0x99,0x06,0x68,0x8b,0x32,0x1e,0xb0,0xca,0x61,0xa7,
        0xd1,0xb5,0x78,0x1d,0xf3,0x4a,0x2d,0xde,0xc5,0xf8,0xdc,0xc8,0x29,0x84,0xcd,0x08,
        0x61,0xbb,0xf7,0xea,0x4a,0x05,0x19,0xad,0x68,0x47,0x5d,0x78,0xbb,0x80,0xa9,0x53,
        0xad,0xf2,0xeb,0x7c,0x65,0xdb,0x98,0x31,0x12,0x87,0x92,0xb0,0x3f,0x33,0x79,0xfb,
        0xce,0x82,0x64,0xb7,0x41,0xc6,0x1b,0x9c,0x4e,0x98,0x9e,0xc6,0x67,0x63,0xcb,0x69,
        0xc4,0x36,0xa5,0x9a,0x2b,0x29,0x3a,0x6d,0xc5,0x3b,0xf8,0xce,0x8f,0xa6,0x44,0x76,
        0x01,0x36,0xfc,0x30,0x9d,0x1f,0x01,0x95,0x6d,0x43,0xf2,0x21,0xd8,0x69,0x7e,0xa2,
        0xa0,0x22,0x5c,0x12,0x2d,0x30,0x02,0xe8,0xc7,0x9d,0x4d,0x8c,0x76,0xa8,0xa5,0x25,
        0xe5,0x8b,0x00,0x6b,0x12,0x55,0xa8,0x17,0x52,0xfd,0xb4,0x88,0x06,0xb9,0x06,0x49,
        0x95,0xe0,0x93,0x9e,0xa2,0xb2,0xe7,0x67,0xc6,0x7a,0x69,0x40,0xa5,0x36,0xa0,0x86,
        0x1b,0xad,0x56,0xd4,0xf1,0x1d,0xfd,0x8e,0x97,0x09,0xa6,0xec,0x14,0x47,0xad,0x94,
        0x6e,0xd5,0x39,0x65,0x0b,0x88,0xd8,0x79,0x26,0xda,0x90,0x01,0x33,0xea,0xb2,0xb4,
        0x80,0x06,0xc9,0xc5,0x27,0x57,0x3b,0xb4,0xd6,0x29,0xb1,0xb7,0x2d,0xa0,0x54,0xa2,
        0x9e,0xab,0x33,0xe4,0x4e,0x4d,0x17,0xb6,0x94,0x04,0x40,0x86,0xe0,0x14,0xcc,0xd8,
        0x13,0xf8,0x5e,0x27,0x93,0xa4,0xb3,0xa2,0x0b,0x8d,0xbc,0xd7,0xc6,0x75,0x4c,0x52,
        0x76,0x2c,0x97,0xfa,0xf3,0x1f,0xf1,0x3e,0xd0,0x45,0xfe,0x64,0x7d,0xcb,0x55,0xe9,
        0x6a,0xee,0x26,0x01,0xa2,0xaf,0x23,0xf1,0x26,0x02,0x11,0x55,0xd4,0xf5,0xda,0x00,
        0x2e,0x7e,0xd4,0x8e,0x13,0xa6,0x01,0x61,0x55,0x0d,0x80,0xf6,0x7b,0xd2,0x61,0x79,
        0x08,0x86,0x66,0xcf,0x79,0xbd,0x59,0x17,0xf1,0xf7,0xfd,0x54,0x25,0x29,0xcd,0x47,
        0x53,0x5d,0xb7,0x3a,0xc1,0xf7,0xf1,0x3a,0x27,0x33,0x4c,0xc3,0x1b,0x4d,0xc9,0xf3,
        0xcc,0x21,0x7d,0x07,0x38,0xdd,0x81,0xe9,0x43,0xe4,0x6d,0x2d,0xcc,0x4a,0x43,0x2f,
        0x94,0xb7,0x17,0x81,0xed,0x4d,0x68,0x4b,0x64,0x72,0xd3,0xc9,0x2f,0x5a,0xe6,0x4a,
        0xdb,0xe2,0xe5,0xd9,0xfe,0xb5,0xcc,0x2d,0x98,0x28,0xcc,0x9e,0xd9,0x26,0x2b,0x4f,
        0xae,0x75,0xa7,0x94,0x27,0x48,0xf3,0x4c,0x60,0xab,0x43,0x27,0x11,0x91,0xf2,0x52,
        0x71,0xe6,0xce,0x42,0x4e,0x2f,0x3a,0x87,0x9c,0xc0,0x8b,0xcb,0xdf,0xd2,0xb9,0x68,
        0x76,0x2d,0x6a,0xf9,0x22,0x7c,0xdb,0x0e,0xf1,0x1c,0xec,0xd0,0xda,0x88,0xac,0xed,
        0x46,0x7b,0x03,0x54,0x16,0xe1,0x75,0xf7,0xa9,0x39,0xed,0xef,0xb6,0x8c,0xeb,0x69,
        0xe9,0xc7,0x6c,0x43,0x1c,0xc1,0x97,0x45,0xc0,0xbf,0x89,0xde,0x7f,0x5d,0xd4,0x80,
        0xdc,0xcc,0x01,0x6c,0xe0,0x84,0xe2,0x2c,0xef,0xa3,0xbf,0xab,0x56,0x69,0x8a,0xba,
        0x4d,0xf1,0x86,0x13,0xe1,0x92,0x09,0x31,0xe8,0x78,0x59,0x85,0x47,0xfd,0xe2,0x0f,
        0x1a,0x15,0x51,0x6a,0x97,0xb3,0x43,0x70,0x38,0xcc,0x88,0xb4,0xa7,0xf3,0x21,0x8e,
        0xbc,0x72,0x86,0xa8,0x4f,0x54,0x9f,0x24,0xb7,0x0a,0x45,0xee,0x37,0x9a,0x72,0xc7,
        0x86,0x73,0x35,0x38,0x50,0xc4,0xca,0xa1,0xb9,0x6c,0x76,0xf8,0xea,0xd4,0xcd,0x55,
        0xc9,0x1d,0x4f,0x40,0xd7,0x1b,0xd9,0x28,0xec,0x71,0x78,0x70,0xde,0x79,0x6b,0x62,
        0xdb,0x8b,0x7f,0x81,0xf0,0x85,0xf6,0xa1,0x56,0x7b,0x56,0xe7,0x42,0x98,0x30,0xb6,
        0x3b,0x6a,0x9b,0x43,0xa5,0x67,0x3c,0x3f,0x01,0x84,0x5d,0x66,0xca,0xcd,0x9a,0xc6,
        0xd9,0x09,0xc2,0x84,0x49,0xb0,0x74,0x5f,0xd0,0xef,0xed,0x5c,0x52,0xc4,0xc4,0xd1,
        0xac,0x9f,0x1b,0xe1,0x68,0x18,0x76,0x13,0x1a,0xa5,0xc5,0xc0,0xc3,0x1d,0x3a,0x3c,
        0xb2,0xf4,0x82,0x8e,0xb6,0x99,0xc7,0x2a,0xab,0x4a,0x4c,0x1a,0x4b,0xdd,0x28,0xed,
        0x44,0x10,0x06,0xfb,0x0e,0xe2,0x1c,0x61,0xca,0xc8,0x88,0x30,0x9a,0x31,0x23,0x6f,
        0x71,0xe4,0xd0,0x4e,0x15,0xa1,0x2a,0xfd,0xfc,0x18,0x5a,0x84,0x62,0xf8,0xbf,0x16,
        0x01,0x26,0x06,0x38,0x51,0x4b,0xc1,0xb6,0x90,0xd2,0x13,0xc2,0x8f,0xb9,0xd0,0x69,
        0x71,0xf7,0xc9,0x9b,0xd7,0x46,0x8a,0xca,0x09,0xac,0xdc,0xc7,0x51,0x0f,0x36,0x2e,
        0xb5,0xf5,0x55,0xf1,0x69,0x18,0x7a,0x12,0xd8,0x3b,0x34,0x31,0xac,0x1c,0x18,0xfd,
        0xc5,0x23,0x4f,0x8c,0x98,0x39,0xa8,0xdf,0xab,0x52,0xee,0x3a,0x64,0xfc,0x44,0xbc,
        0x24,0xc5,0x4d,0x1f,0x1e,0x4c,0x3b,0xae,0xf5,0x64,0x33,0xf4,0xbd,0xa7,0x0b,0xc2,
        0xb8,0xe3,0xe4,0xaa,0x22,0xfc,0x91,0x67,0xdf,0xdf,0xfe,0x0e,0x34,0xa7,0xce,0x4a,
        0xd5,0xc8,0x33,0x61,0xdd,0x40,0x8f,0x3e,0xf9,0x93,0x66,0xb7,0x0d,0xdb,0x43,0x29,
        0x8f,0x61,0x91,0xe5,0xe3,0x80,0x6b,0xa0,0x07,0x4e,0x84,0xc1,0xf9,0x36,0x1e,0x1f,
        0x3a,0x91,0xa7,0xc4,0xa3,0x27,0x50,0xaf,0xb8,0xde,0x97,0x31,0xf5,0x7a,0x37,0xc8,
        0xa5,0x17,0x2f,0xe2,0xdf,0x3d,0x35,0x4a,0x3f,0xc0,0xbb,0xa3,0x81,0x29,0x74,0x95,
        0x0b,0x18,0x2d,0x70,0x66,0x8b,0x96,0x40,0xd1,0x90,0xb9,0xa1,0x29,0x6d,0xef,0xa9,
        0x80,0xda,0x9e,0x77,0xbe,0xb8,0xb2,0x2a,0x26,0x1d,0x04,0x02,0x57,0x5d,0x36,0x8e,
        0xe5,0x83,0xb3,0xdc,0xcb,0xdc,0x8c,0xda,0x5e,0x17,0x3a,0x0d,0x94,0x5e,0x9e,0x83,
        0xaf,0xf2,0x52,0x8d,0xdd,0x0d,0x62,0x66,0x13,0xa0,0x67,0xb6,0x96,0x5e,0xc5,0xc5,
        0x6f,0x4c,0xc8,0xda,0x0e,0xb6,0x22,0x04,0xdf,0xe2,0xd2,0x1e,0xa3,0xdd,0xf1,0x33,
        0xfa,0x9d,0x80,0x8f,0xeb,0xee,0x1d,0xd3,0x2a,0x26,0x33,0x2e,0x21,0xcb,0xf1,0x37,
        0x05,0x11,0xd4,0x84,0xac,0x4a,0xf3,0x40,0x27,0x8b,0x4d,0xc8,0xb6,0x66,0x31,0x50,
        0x65,0x89,0xf2,0xb6,0x2d,0x02,0x36,0xa6,0x36,0xd1,0x50,0x99,0x2a,0x7c,0x38,0xd4,
        0x58,0x84,0x8a,0x1a,0xa1,0x67,0x6c,0x2a,0xe2,0x45,0xdf,0x9d,0xb8,0x5b,0xf3,0x75,
        0x08,0x5a,0x64,0x93,0x74,0xb6,0xd9,0xe7,0x19,0xe6,0x75,0x56,0x0e,0x16,0x7c,0x93,
        0x30,0xa8,0xb4,0x97,0x64,0x7c,0x3d,0xe8,0x8f,0x9c,0xc1,0xcc,0xf8,0xe7,0x49,0x16,
        0xae,0x8f,0x81,0x70,0x4c,0x62,0x7c,0x35,0x67,0x09,0x4f,0x1e,0x16,0x4e,0x6e,0x14,
        0x8f,0xb4,0x8f,0x1a,0xb5,0x07,0x8d,0xa0,0x7f,0x29,0x47,0xc6,0x2b,0x8b,0x45,0x58,
        0x4f,0x05,0x34,0xd7,0x32,0xc6,0x38,0x05,0x22,0x88,0xe1,0x7d,0x2d,0x6d,0xa6,0x16,
        0x18,0x68,0xe1,0x2c,0x68,0x11,0x5c,0xc9,0x3c,0xd2,0x6e,0xc3,0xf8,0x59,0xba,0x5d,
        0x65,0x69,0xfd,0xee,0xf5,0xc4,0x54,0x6a,0x42,0xd2,0xae,0x06,0x34,0x7a,0x89,0x6a,
        0xa1,0x77,0xd2,0x4a,0xbb,0xd9,0x93,0x88,0x95,0x46,0x30,0xec,0x67,0x0f,0xda,0x82,
        0x52,0xb0,0x09,0x69,0xc4,0xc2,0x90,0x59,0xcc,0xac,0xb5,0xe2,0x91,0xce,0x9a,0x58,
        0xdc,0xb4,0x1c,0xd0,0x01,0xd0,0xbe,0x0c,0x7a,0xa4,0x0f,0x26,0xa3,0xd2,0xac,0x67,
        0x19,0xcc,0xbc,0xfc,0x3a,0xa4,0x98,0x5f,0xef,0x0e,0x8e,0x52,0x72,0xf9,0x89,0xea,
        0xe2,0x5d,0x16,0x71,0xf3,0xb5,0x53,0xae,0x37,0x76,0x35,0x3d,0xcf,0x77,0x3c,0x03,
        0x5d,0x96,0x04,0xea,0x25,0x51,0x7e,0x33,0x56,0x4e,0x86,0xcf,0x44,0x50,0x9b,0x7c,
        0x0e,0xe7,0x16,0x57,0xe8,0x5e,0x7a,0xcf,0x49,0x99,0x7b,0x38,0x81,0x0d,0x62,0x0e,
        0xed,0xc9,0x2b,0x79,0x74,0xfe,0xbe,0xcc,0xf1,0xe4,0x40,0xe2,0x96,0x4f,0x84,0xe9,
        0x5a,0x00,0x33,0x01,0x9a,0x38,0x9c,0x96,0x0c,0x39,0xfa,0x1f,0x89,0x88,0xb0,0x32,
        0x43,0x94,0xa7,0x87,0x7d,0x48,0x24,0xab,0x62,0x75,0x79,0x33,0x67,0x76,0x05,0x53,
        0x35,0xbd,0x1f,0xbe,0xa1,0x85,0x35,0x5f,0x50,0xd3,0x4d,0xfc,0xfb,0x20,0x08,0x10}, 
        /*TST_dataSize*/
        1536*sizeof(DxUint8_t),       
        CRYS_AES_ECB_mode
    },
    #endif
    #endif
        /************/
        /*        AES CBC vectors         */
        /************/
    #if TST_USE_AES_16BYTE_DATA
    { 
        {"Acceptance test - AES/CBC/128Key/16ByteData "},
        /*TST_Key*/     
        {0x2b,0x7e,0x15,0x16,0x28,0xae,0xd2,0xa6,0xab,0xf7,0x15,0x88,0x09,0xcf,0x4f,0x3c},
        CRYS_AES_Key128BitSize,
        /*TST_IvCounter*/
        {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f},
        /*TST_input_data*/
        {0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a},
        {0},
        /*TST_Expected_output_data for enc Input data for decrypt*/
        {0x76,0x49,0xab,0xac,0x81,0x19,0xb2,0x46,0xce,0xe9,0x8e,0x9b,0x12,0xe9,0x19,0x7d}, 
        /*TST_dataSize*/
        16*sizeof(DxUint8_t),       
        CRYS_AES_CBC_mode
    },
    #endif
    #if TST_USE_AES_32BYTE_DATA
    { 
        {"Acceptance test - AES/CBC/128Key/32ByteData "},
        /*TST_Key*/     
        {0x2b,0x7e,0x15,0x16,0x28,0xae,0xd2,0xa6,0xab,0xf7,0x15,0x88,0x09,0xcf,0x4f,0x3c},
        CRYS_AES_Key128BitSize,
        /*TST_IvCounter*/
        {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f},
        /*TST_input_data*/
        {0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a,
         0x65,0xa2,0x32,0xd6,0xbc,0xd0,0xf9,0x39,0xed,0x1f,0xe1,0x28,0xc1,0x3b,0x0e,0x1b},
        {0},
        /*TST_Expected_output_data for enc Input data for decrypt*/
        {0x76,0x49,0xab,0xac,0x81,0x19,0xb2,0x46,0xce,0xe9,0x8e,0x9b,0x12,0xe9,0x19,0x7d,
         0xe9,0x32,0x2e,0x95,0x30,0x6b,0x9d,0x25,0x83,0x24,0x2f,0x12,0x1a,0x57,0xb7,0xb6}, 
        /*TST_dataSize*/
        32*sizeof(DxUint8_t),     
        CRYS_AES_CBC_mode
    },
    #endif
    #if TST_USE_AES_512BYTE_DATA
    { 
        {"Acceptance test - AES/CBC/128Key/512ByteData "},
        /*TST_Key*/     
        {0x2b,0x7e,0x15,0x16,0x28,0xae,0xd2,0xa6,0xab,0xf7,0x15,0x88,0x09,0xcf,0x4f,0x3c},
        CRYS_AES_Key128BitSize,
        /*TST_IvCounter*/
        {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f}, 
        /*TST_input_data*/
        {0xb6,0xed,0x21,0xb9,0x9c,0xa6,0xf4,0xf9,0xf1,0x53,0xe7,0xb1,0xbe,0xaf,0xed,0x1d,
         0xf3,0xee,0xd1,0xbd,0xb5,0xd2,0xa0,0x3c,0x06,0x4b,0x5a,0x7e,0x3d,0xb1,0x81,0xf8,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0x62,0xf8,0xa7,0x23,0x7b,0xbd,0xf8,0x4d,0x4e,0x1d,0xff,0xe8,0xb5,0x2a,0x02,0xc1,
         0x52,0xdb,0x14,0x2f,0xeb,0x21,0xf9,0x58,0xb8,0x80,0x28,0x68,0xe4,0x99,0x06,0x18,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0xb6,0xed,0x21,0xb9,0x9c,0xa6,0xf4,0xf9,0xf1,0x53,0xe7,0xb1,0xbe,0xaf,0xed,0x1d,
         0xf3,0xee,0xd1,0xbd,0xb5,0xd2,0xa0,0x3c,0x06,0x4b,0x5a,0x7e,0x3d,0xb1,0x81,0xf8,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0x62,0xf8,0xa7,0x23,0x7b,0xbd,0xf8,0x4d,0x4e,0x1d,0xff,0xe8,0xb5,0x2a,0x02,0xc1,
         0x52,0xdb,0x14,0x2f,0xeb,0x21,0xf9,0x58,0xb8,0x80,0x28,0x68,0xe4,0x99,0x06,0x18,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0xb6,0xed,0x21,0xb9,0x9c,0xa6,0xf4,0xf9,0xf1,0x53,0xe7,0xb1,0xbe,0xaf,0xed,0x1d,
         0xf3,0xee,0xd1,0xbd,0xb5,0xd2,0xa0,0x3c,0x06,0x4b,0x5a,0x7e,0x3d,0xb1,0x81,0xf8,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0x62,0xf8,0xa7,0x23,0x7b,0xbd,0xf8,0x4d,0x4e,0x1d,0xff,0xe8,0xb5,0x2a,0x02,0xc1,
         0x52,0xdb,0x14,0x2f,0xeb,0x21,0xf9,0x58,0xb8,0x80,0x28,0x68,0xe4,0x99,0x06,0x18,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0xb6,0xed,0x21,0xb9,0x9c,0xa6,0xf4,0xf9,0xf1,0x53,0xe7,0xb1,0xbe,0xaf,0xed,0x1d,
         0xf3,0xee,0xd1,0xbd,0xb5,0xd2,0xa0,0x3c,0x06,0x4b,0x5a,0x7e,0x3d,0xb1,0x81,0xf8,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0x62,0xf8,0xa7,0x23,0x7b,0xbd,0xf8,0x4d,0x4e,0x1d,0xff,0xe8,0xb5,0x2a,0x02,0xc1,
         0x52,0xdb,0x14,0x2f,0xeb,0x21,0xf9,0x58,0xb8,0x80,0x28,0x68,0xe4,0x99,0x06,0x18,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9},
        {0},
        /*TST_Expected_output_data for enc Input data for decrypt*/
        {0x5e,0xad,0x05,0x44,0x74,0xb8,0x94,0x78,0x5a,0x54,0x8c,0x6c,0x4d,0x92,0x82,0xb3,
         0xe4,0x07,0xd6,0x3c,0x25,0xb4,0x5e,0xc1,0xce,0x30,0x46,0x54,0x84,0xef,0x31,0x87,
         0x1e,0x12,0xca,0x47,0x43,0x58,0x0e,0x16,0x80,0x6b,0x20,0x10,0x80,0x8e,0x69,0xb0,
         0x02,0x13,0x3e,0x62,0x52,0xa8,0x32,0x0a,0x8f,0x6a,0xd0,0xd9,0x39,0xd3,0x87,0x7e,
         0xae,0x51,0x37,0xd9,0xd8,0x8a,0x65,0x2b,0x77,0x4d,0x40,0x1d,0xaa,0xb0,0x56,0xa4,
         0x18,0x56,0x52,0x58,0xd4,0xa8,0x37,0x77,0x0c,0xf2,0xbf,0x00,0x2b,0x97,0xa3,0x4a,
         0x2f,0x48,0x3d,0x13,0x00,0x95,0xb8,0x4b,0xbb,0x77,0x29,0x0b,0x7c,0xb6,0x78,0x9b,
         0xf7,0x9f,0x26,0x65,0xc9,0x99,0x78,0x0c,0x03,0x49,0x0c,0x22,0x49,0x55,0x24,0x43,
         0x26,0xcd,0x8b,0x6f,0x25,0x6c,0xaa,0xff,0xf4,0x5a,0xa2,0x2d,0x01,0x14,0x5e,0x5b,
         0x1d,0x5b,0x54,0x6c,0x27,0x2d,0xa9,0xbe,0x1b,0x2f,0x90,0x25,0x60,0x26,0x8e,0xa2,
         0x7f,0x44,0x69,0x70,0xb7,0x87,0x21,0x45,0x11,0x79,0xfd,0xa7,0x61,0x8c,0x27,0xdd,
         0xfa,0x84,0x3b,0x05,0x46,0x07,0x73,0x2a,0x4c,0xfd,0xc0,0xae,0xc9,0x87,0x2f,0xd1,
         0xe9,0x72,0xf3,0x9e,0x1c,0x0d,0x99,0xdf,0x92,0x83,0x58,0x40,0xd7,0xc1,0x06,0x2f,
         0x73,0xa3,0x26,0xfd,0x4e,0x4b,0xb4,0xb9,0x96,0xb4,0x82,0xb5,0xcc,0xb8,0x0a,0x88,
         0x11,0xe7,0x70,0x8a,0xaa,0x96,0xaf,0x09,0x12,0x05,0x11,0xa7,0x9b,0x78,0xb7,0x30,
         0xd7,0x72,0x22,0x02,0xa8,0x57,0xd9,0x49,0x0b,0x4c,0x59,0x20,0xb8,0xe6,0xe9,0x34,
         0x49,0x81,0x4a,0x3e,0x27,0xec,0xee,0x5b,0xca,0xed,0x3b,0x64,0xd4,0xdb,0x9f,0xd3,
         0x96,0x3a,0x9e,0xb2,0x34,0xbe,0x4c,0x2f,0xad,0x36,0x3c,0x5f,0x32,0xae,0xab,0x7b,
         0xc2,0x93,0xd2,0x5b,0x6f,0xf9,0x88,0xa6,0xad,0x2a,0x6b,0xd9,0x3f,0x29,0x04,0xf6,
         0x9d,0x92,0x8a,0xf0,0x9a,0x5e,0xc1,0xf3,0x65,0xe0,0x1c,0xa1,0xf7,0x88,0x58,0x94,
         0x67,0x57,0xe2,0x16,0x6b,0xcd,0xe0,0x01,0x8b,0xe2,0x58,0x5f,0x6a,0x77,0x0f,0x13,
         0xf1,0xa1,0xad,0x11,0xe7,0x3d,0xad,0x02,0x77,0x7c,0xb9,0xce,0xe0,0xf6,0x9a,0xd6,
         0x50,0xb8,0xf6,0x17,0xa5,0x43,0x3d,0x43,0x7e,0x7e,0xf9,0x57,0xf2,0xd5,0x7c,0xbc,
         0x33,0x0d,0x87,0x15,0x6c,0x03,0x73,0xcc,0x77,0x44,0x5d,0x92,0x72,0x64,0xf0,0xcd,
         0xd9,0x0e,0xf8,0x6b,0x80,0x38,0x84,0xd7,0x97,0xe1,0x4e,0x9e,0xdd,0xd5,0xc4,0xcc,
         0xad,0x3e,0x62,0xf6,0x76,0x07,0xa8,0x8f,0xb0,0x39,0xbc,0xc1,0xe8,0x64,0xfe,0x42,
         0x7d,0x91,0x23,0xae,0x8d,0x13,0xf2,0x02,0x8f,0xef,0xec,0xf0,0x59,0xfa,0xe4,0x83,
         0x5d,0x3d,0xdc,0xf5,0x25,0xee,0x92,0x51,0x49,0xd2,0x64,0xb5,0x00,0xe7,0x35,0x97,
         0xd8,0xf8,0x33,0x42,0xbb,0x37,0xe2,0x94,0xf7,0xcf,0xe8,0xe2,0xb9,0xf2,0xb0,0x4c,
         0x71,0xc9,0x74,0xc4,0xc9,0xa3,0x62,0xb5,0x83,0x36,0xd0,0x02,0x49,0x94,0x45,0x05,
         0xd2,0x12,0x0e,0x54,0x0d,0x44,0xf9,0xf0,0x29,0xa4,0xb9,0x4f,0x39,0x9e,0x34,0x80,
         0x36,0xec,0x30,0xb4,0x31,0x63,0xe7,0x16,0x1c,0x11,0x19,0x7a,0x2a,0xa6,0xff,0x8c}, 
        /*TST_dataSize*/
        512*sizeof(DxUint8_t),        
        CRYS_AES_CBC_mode
    },
    #endif
    #if TST_USE_AES_1536BYTE_DATA
    { 
        {"Acceptance test - AES/CBC/128Key/1536ByteData "},
        /*TST_Key*/     
        {0xa1,0x4c,0x5b,0x2b,0x35,0x5b,0x0d,0xb7,0xe5,0x89,0x03,0x96,0x47,0xaa,0x0f,0x5f},
        CRYS_AES_Key128BitSize,
        /*TST_IvCounter*/
        {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f},
        /*TST_input_data*/
        {0x16,0xcb,0x7b,0x32,0x29,0x9e,0x1d,0x38,0x92,0x36,0x22,0x02,0xe6,0x60,0x71,0xeb,
        0xe7,0x69,0x77,0xbe,0x05,0x8d,0xc9,0xc8,0x25,0xb2,0x0b,0x31,0xa2,0x57,0x10,0x8c,
        0x91,0xc7,0x42,0xac,0x4a,0x92,0x45,0xb9,0x24,0x3d,0xd7,0x84,0x7f,0x39,0xfb,0x18,
        0x08,0x12,0x56,0x92,0x38,0xe9,0xd9,0x32,0x1e,0x24,0xa0,0xb1,0x5f,0x64,0x1a,0xd5,
        0x7b,0xb7,0x6b,0x44,0x51,0x10,0x0e,0x96,0xe6,0xf4,0xbf,0xad,0x62,0x75,0x98,0x49,
        0x5b,0x64,0x7a,0xd7,0x56,0xc3,0xae,0x8a,0x8b,0x79,0xcc,0xad,0xe9,0x49,0xdc,0x38,
        0x5a,0x05,0xbc,0xa1,0x48,0xff,0xc2,0xf4,0x60,0xc1,0xa1,0x26,0x96,0xfe,0x91,0xa7,
        0x69,0xc8,0xaa,0x36,0x68,0x02,0x91,0xf9,0xf5,0x19,0x57,0xcd,0x49,0xef,0x9e,0xdb,
        0xb8,0x18,0xfe,0x6c,0x36,0x49,0xa7,0xfe,0x1b,0x0d,0x47,0x96,0x23,0xba,0x2e,0x59,
        0xb9,0xa4,0xb0,0x56,0x75,0x90,0xca,0xa7,0xe3,0x6c,0x09,0xb8,0x86,0x3d,0xa8,0xe6,
        0x1c,0x58,0xf8,0x4c,0x24,0xd5,0x05,0xd9,0x9e,0x41,0x77,0xa6,0x12,0x93,0xb6,0x87,
        0xd3,0x61,0x52,0xe1,0x85,0x54,0xa1,0xbb,0xdd,0xda,0xaa,0x17,0xa8,0x1a,0x41,0x82,
        0x0f,0x2d,0x74,0xea,0x19,0x8b,0x26,0xb0,0x71,0xc3,0xfa,0xfe,0x6a,0x70,0x73,0x5b,
        0x40,0x68,0x59,0x7c,0xa1,0x36,0x5e,0x5d,0x6b,0xcb,0x01,0x91,0xb8,0x70,0xb3,0xd7,
        0x18,0xff,0x38,0xed,0x1d,0x53,0x51,0xa9,0x1d,0xfd,0x98,0x45,0x33,0x38,0xab,0xfb,
        0x87,0x20,0x8c,0xd1,0xcf,0x1e,0x48,0xb7,0x16,0xa7,0xd7,0xcf,0xbc,0x26,0x44,0x0c,
        0xbf,0x36,0x0e,0xfe,0x38,0x15,0xcd,0xec,0x29,0x55,0x18,0x24,0x75,0xd5,0xa7,0x8f,
        0x30,0xf0,0xb5,0x88,0x19,0xf4,0xa8,0xee,0x65,0xd6,0xf4,0x78,0xbf,0x24,0x3d,0x49,
        0x8c,0x3a,0xbc,0xc5,0x73,0xb9,0xe3,0xa2,0x1d,0x35,0x44,0x42,0x39,0x2e,0xaf,0x40,
        0xc4,0x42,0x9a,0x49,0x87,0xa0,0xc6,0x2d,0xe1,0xc0,0x20,0x35,0xc6,0x52,0xe6,0xb8,
        0x08,0x74,0x0a,0xe9,0xd5,0x27,0xdb,0xf3,0x82,0x04,0xe2,0x48,0x86,0x2b,0x0a,0x35,
        0xca,0x7d,0x05,0xbb,0x20,0x0b,0xea,0x9a,0x10,0xcd,0x23,0xae,0xdb,0x98,0x86,0x7e,
        0xba,0x4a,0xc2,0x13,0x67,0x48,0xfd,0x06,0xde,0x2a,0xbb,0xdd,0x65,0xb4,0x02,0x98,
        0xca,0x08,0xbc,0x86,0xec,0x1b,0x5c,0x5d,0x7c,0x66,0xc4,0x8a,0x05,0xde,0x66,0xc6,
        0x2a,0x25,0xaa,0xea,0x30,0x02,0x90,0x04,0xbc,0x0f,0x97,0xaa,0xdd,0xb1,0xdd,0x8e,
        0x4c,0x4d,0x87,0x53,0xf3,0xb9,0x63,0x9f,0xad,0xf1,0xcc,0x72,0x4d,0x0c,0xcf,0xb6,
        0xe1,0x6e,0x8c,0x17,0x38,0x3e,0xde,0x14,0xa1,0x1b,0x3e,0x56,0xf6,0x0a,0xe4,0x41,
        0xd9,0xb3,0x30,0xca,0x3e,0xce,0x49,0x88,0x2a,0xd8,0x04,0x0d,0xb9,0x0a,0x07,0x76,
        0x66,0x8b,0x2e,0x41,0x87,0xe5,0x2d,0x5f,0x17,0xb6,0x77,0x8a,0xb8,0xa8,0x5f,0xd9,
        0xf8,0xa2,0x7d,0x92,0xd4,0x40,0x54,0x3f,0x7b,0x81,0x31,0x04,0x54,0xc0,0x56,0x2f,
        0x41,0xe6,0x58,0x11,0x26,0xdd,0xc6,0x0d,0xa5,0x48,0x0b,0xee,0x2c,0x71,0x96,0x7d,
        0x32,0x82,0x38,0x54,0xbd,0xf9,0xcd,0xed,0x28,0x56,0x1e,0xfe,0x23,0x16,0x06,0x09,
        0xfb,0xe5,0xd4,0x2e,0x1c,0x10,0xf1,0x45,0xd4,0x39,0xc3,0x29,0x59,0x4e,0xd0,0x56,
        0x0e,0xbc,0x27,0xb7,0x02,0xdf,0xfc,0xb9,0xb9,0xbd,0x92,0xa4,0x30,0xf5,0x5e,0x2b,
        0x1b,0xf2,0x69,0x42,0x71,0x64,0xf6,0x2f,0x2a,0xf1,0x65,0xe4,0x48,0x27,0x57,0x8c,
        0x14,0xb6,0x13,0x64,0xaa,0xdc,0x28,0xcc,0xb7,0x20,0x54,0x9e,0x82,0x43,0xa5,0xbe,
        0x29,0x74,0xde,0xf2,0x2d,0xc3,0x1c,0xf4,0x31,0xd8,0xb9,0xc6,0xff,0xe5,0x71,0x46,
        0xcc,0xd9,0xc3,0x02,0xbd,0xd7,0x9a,0x4d,0xaa,0xe6,0x2d,0x93,0x21,0xea,0x24,0xe9,
        0xae,0xd3,0xfc,0xe8,0x59,0x14,0xac,0xbc,0x71,0x56,0x89,0x78,0x88,0x6e,0x67,0xac,
        0xbf,0x8d,0x01,0x3a,0x44,0xb7,0x9b,0x65,0x18,0x77,0xe5,0x2b,0x16,0xd0,0x23,0xd5,
        0x31,0x76,0x8b,0xcc,0xfd,0x3f,0xee,0xae,0x71,0xd4,0x9b,0xa1,0xeb,0xac,0x81,0xe8,
        0x74,0x3b,0x93,0xb4,0x45,0x66,0x71,0x3c,0x8b,0x3b,0x44,0x0f,0x68,0xdf,0xe9,0xa9,
        0x3a,0xc7,0x53,0x45,0x1f,0x2b,0x2a,0xf3,0xb9,0xb8,0xb8,0xea,0x2e,0x86,0x06,0x1f,
        0x73,0x49,0x42,0x17,0xcb,0xcb,0x64,0xf9,0x8a,0x9a,0x12,0xe7,0x1f,0xfd,0xc0,0x8e,
        0x51,0x2d,0x1b,0xfc,0xc9,0xc2,0xa8,0xb2,0xd1,0x6c,0xa8,0xfb,0x5b,0xe3,0x40,0x7c,
        0x45,0x21,0xd6,0x0b,0xdb,0xce,0xbe,0xc5,0x9e,0xfc,0x16,0x5a,0x44,0x14,0xee,0xac,
        0xff,0x10,0xad,0x99,0x02,0xeb,0xaf,0x14,0x42,0x56,0x33,0x7b,0x79,0xad,0x75,0x24,
        0x71,0x29,0x17,0x3a,0x7f,0x57,0xc5,0xc7,0x4d,0xc9,0x19,0x11,0xdd,0x0b,0xbc,0x2a,
        0xcb,0xd8,0xcf,0xc3,0xd3,0x8e,0x89,0x41,0x92,0xe0,0x21,0x13,0x91,0xcb,0xee,0x42,
        0x7f,0xcb,0xcd,0x49,0xbe,0x4e,0xc3,0x28,0x22,0x69,0xe3,0xb4,0xf5,0xca,0x72,0x31,
        0x3e,0xee,0x4a,0x22,0x42,0x94,0x7c,0x60,0x4c,0x71,0x39,0x6a,0xaa,0x25,0xf3,0xfc,
        0xf8,0x6e,0xbf,0xe3,0xa1,0x9b,0xfe,0x0f,0xa2,0x44,0x3c,0xea,0x91,0x39,0x58,0xe8,
        0xde,0xb8,0xe5,0x5f,0x5a,0xe3,0xd1,0x9a,0xf5,0x70,0x44,0x29,0xcc,0xa3,0xcb,0x7a,
        0x63,0x79,0xb6,0xae,0x2e,0x27,0xbf,0xa5,0x57,0xc2,0xec,0x5b,0xbb,0x40,0xb6,0x78,
        0x36,0x9f,0x6a,0x22,0x20,0x64,0xd0,0x16,0x17,0x47,0x0b,0xf7,0xff,0x2d,0xc0,0xe5,
        0x48,0x56,0x7a,0x52,0x6f,0xd8,0x4d,0x11,0xc8,0x4c,0xba,0xb0,0x7a,0xc7,0xd3,0x08,
        0xcb,0x0c,0x9f,0x12,0x9e,0xff,0xc0,0xfd,0x39,0x5d,0x53,0x7d,0x4c,0xab,0x18,0x65,
        0x2f,0x6c,0xd3,0x78,0x6c,0x97,0xf2,0x7c,0x7d,0x48,0x6f,0x91,0xd7,0xb6,0xf8,0xc1,
        0x27,0x65,0x4e,0xd8,0xdb,0x9d,0xeb,0x76,0xe4,0x1a,0xe7,0x62,0xba,0x05,0x1c,0x21,
        0xa1,0x23,0x89,0xc8,0x2c,0x4d,0xf4,0x0e,0xff,0x20,0xd3,0xa5,0xd8,0xf5,0x6d,0xcb,
        0xd1,0x13,0x3d,0x1c,0xdf,0x24,0x97,0xaa,0x9f,0xe6,0x8e,0x4f,0x52,0x23,0x14,0x42,
        0x25,0xe3,0x63,0xe9,0xb7,0xe0,0x9c,0xee,0xd5,0x3a,0xae,0x95,0x88,0x6c,0x7a,0x4d,
        0x51,0x7f,0x35,0x85,0xb3,0x7e,0x0d,0xc0,0xf2,0x29,0x0f,0xec,0x1b,0xed,0x48,0xef,
        0x44,0x14,0x2a,0x84,0x15,0x3a,0x32,0x45,0x87,0x00,0xc8,0x08,0xec,0x04,0x67,0x6f,
        0x30,0x10,0xfd,0xbb,0x5e,0x91,0x95,0xe1,0x65,0x4b,0x33,0xe0,0x1d,0x4c,0xff,0x51,
        0x85,0x1e,0xa6,0x40,0x4f,0x41,0xfe,0x3a,0x9e,0xd8,0xe9,0xa7,0x0e,0xa3,0x7b,0x5b,
        0xf5,0x2d,0x5f,0x67,0xe8,0x47,0x76,0x35,0x81,0xb4,0xc2,0xd4,0x60,0x26,0x83,0x90,
        0x70,0x6a,0x9f,0xc6,0x6b,0xdf,0x47,0xf6,0xa1,0x2c,0xd8,0x1a,0xf5,0x32,0xff,0x36,
        0x28,0x40,0x21,0x31,0x5a,0x86,0xfa,0xe3,0xcd,0xcd,0x84,0x6f,0xed,0x65,0x1a,0xd3,
        0x8d,0x5e,0xdd,0xbd,0x74,0xfb,0x57,0xa1,0x18,0x63,0x5e,0x08,0xa9,0x9a,0x3b,0x2b,
        0x51,0xb0,0x0c,0xc0,0xbb,0x38,0x67,0x14,0xd2,0xfc,0x40,0x5a,0xcb,0xef,0x0d,0x42,
        0x65,0x63,0x27,0xce,0x6f,0x7c,0x74,0x62,0x8b,0xe5,0x43,0x1a,0x33,0xc1,0x77,0x5f,
        0xf9,0xe5,0xe8,0xbd,0x13,0x44,0x06,0xef,0x16,0xaa,0xc0,0x3c,0x02,0xae,0xa4,0x07,
        0x7f,0xe2,0x47,0xa1,0x66,0x4c,0xe7,0x61,0x83,0x1a,0x4f,0xf7,0x9a,0x91,0xfb,0xfd,
        0xa7,0x47,0x7d,0xcf,0x6a,0x92,0x1f,0x9d,0x23,0x40,0xca,0xbe,0x9b,0x88,0x26,0x47,
        0x63,0x41,0x03,0xdd,0x60,0x52,0xf8,0xc7,0x88,0x6a,0x49,0x47,0xe6,0xf1,0x0e,0x2b,
        0xe4,0x3e,0x92,0x9f,0xc9,0x0a,0xfa,0x45,0x81,0x24,0x27,0x88,0x9d,0x67,0xdd,0x2d,
        0x9a,0xea,0x24,0x2a,0x66,0x76,0xee,0xbc,0x20,0x3d,0xfb,0xb4,0x1f,0xc8,0xfa,0x11,
        0x37,0x32,0xf1,0xd4,0x37,0x94,0xde,0x10,0xb6,0xc0,0x9f,0x41,0x10,0x32,0x0f,0xde,
        0xab,0x43,0x72,0x32,0x7f,0xa0,0x13,0x67,0xd5,0xfb,0x2b,0xe4,0x4e,0x00,0x05,0xd9,
        0x28,0x8b,0x60,0x17,0xbd,0x18,0x15,0x26,0x4c,0x7b,0xf9,0x91,0xfc,0xd1,0x05,0x85,
        0x1e,0xb6,0xb4,0x9a,0xb3,0xb8,0xad,0xf1,0x2e,0x0c,0xa2,0x7f,0x7b,0x80,0x78,0xa8,
        0x3f,0xb1,0xa8,0x10,0x62,0x7e,0xe5,0xae,0xcb,0xbc,0xff,0x22,0x6a,0x2b,0x07,0x48,
        0x7c,0xa9,0xb4,0x0d,0x0a,0xa6,0x05,0x81,0xb3,0xd8,0x28,0x2e,0xac,0x30,0x9b,0xa9,
        0x05,0x0c,0x91,0x66,0x2e,0xae,0x97,0xd0,0xb9,0xed,0x77,0x99,0x61,0x2a,0x5c,0x4f,
        0x4c,0x86,0x38,0x31,0x8d,0x52,0x63,0x40,0xed,0xc8,0x85,0x99,0xeb,0xf8,0xb5,0x01,
        0x01,0x04,0xe2,0xc2,0x29,0x90,0x72,0xb6,0xa0,0x75,0x2a,0xa1,0xea,0xb5,0x4e,0xc3,
        0x16,0xb4,0x09,0xae,0x43,0xa5,0x0e,0x56,0x63,0x42,0x80,0x67,0x3f,0xc0,0x10,0xdb,
        0xbc,0x02,0x65,0xcb,0x5c,0x0d,0xc0,0x85,0x07,0xbc,0xe0,0xe0,0x0c,0xb4,0x23,0xcc,
        0x63,0x9b,0xef,0x2d,0x35,0x85,0x50,0xea,0x9d,0xaf,0xe2,0x40,0xb1,0x70,0xf2,0x5d,
        0xbc,0x6c,0xe0,0x2a,0xce,0x0b,0xc7,0x68,0x77,0x2a,0x60,0xfe,0xcf,0x10,0x24,0x91,
        0xb9,0xa3,0xb1,0x56,0x69,0xdb,0x6f,0x24,0x24,0x78,0x73,0xce,0x47,0xf0,0xa4,0xaf,
        0x8b,0xac,0x1c,0x86,0x87,0x73,0xd1,0x85,0x77,0x27,0x74,0xa4,0x3b,0xaf,0x99,0x3b,
        0xa3,0x34,0x19,0xd0,0xe9,0x90,0xb4,0x2d,0x7f,0x03,0xfb,0xb6,0x0b,0x28,0x6e,0xfa,
        0xb1,0x28,0xe1,0x88,0x90,0x2e,0x24,0x04,0x8f,0x1b,0xe2,0x7a,0x59,0x7a,0xca,0xf1,
        0xa6,0xb6,0xed,0x44,0xbd,0x8a,0x67,0x2d,0x36,0xba,0x42,0xa3,0x05,0x01,0x97,0x66},
        {0},
        /*TST_Expected_output_data for enc Input data for decrypt*/
        {0xdd,0x40,0x7b,0xdf,0x86,0x0c,0x10,0x7d,0x66,0x01,0x82,0x46,0x1c,0x47,0xb9,0x12,
        0x52,0x75,0xac,0xee,0x4d,0x88,0x45,0xf3,0x74,0xe5,0x3a,0xaf,0xc1,0xa4,0xb9,0xfc,
        0x3d,0x46,0xd5,0x90,0xc4,0x8e,0x7a,0x20,0x9e,0x46,0x1a,0x75,0x2b,0x17,0xce,0x68,
        0xaa,0x8c,0x5f,0xfc,0x62,0xb4,0x9f,0xad,0x8c,0x49,0x49,0x72,0x60,0x57,0xce,0xe5,
        0x92,0xfa,0x71,0x6d,0x68,0xdb,0xf4,0xd6,0xb4,0xdf,0xd9,0x98,0x82,0xc2,0xd7,0x34,
        0x66,0x42,0x9d,0x37,0x2f,0xad,0xfb,0x89,0xbd,0x57,0xea,0x7e,0x84,0xd2,0xcf,0x03,
        0x5b,0xfa,0xa3,0x69,0x0e,0xf0,0xf5,0x12,0x50,0x94,0x43,0x66,0x9b,0x64,0xd4,0xe6,
        0xa6,0x73,0x69,0xb7,0xe6,0x98,0x80,0x50,0x9d,0x30,0x92,0x28,0xf8,0x1e,0x03,0xd1,
        0x29,0xe8,0xb8,0xb1,0x41,0x03,0x52,0x63,0x5d,0xcb,0x45,0x36,0xb2,0x22,0x6e,0x01,
        0xcd,0x35,0x20,0xf9,0x6f,0xc8,0xbb,0xf7,0xc6,0xfd,0x2b,0x83,0xd4,0x02,0x9e,0x86,
        0x4c,0x10,0x20,0x20,0x47,0x16,0xdc,0x74,0x41,0x56,0x63,0xe5,0x13,0x52,0x08,0x0d,
        0xdd,0xc0,0xd3,0x30,0x35,0x54,0x7c,0x41,0xc1,0xda,0x3e,0xfc,0x3b,0xc5,0xc8,0xbc,
        0xa2,0x20,0x5f,0x28,0xc7,0xd8,0xb5,0xdf,0xda,0x38,0xbc,0x59,0x76,0xf5,0x04,0x79,
        0x54,0x19,0x8e,0xb2,0x64,0xfd,0x9e,0x7f,0x99,0x6c,0xb4,0x5f,0x5c,0x27,0x9b,0x69,
        0x5f,0x61,0x48,0x82,0x79,0x27,0xae,0x08,0x9c,0x2c,0x85,0x3d,0x1c,0x05,0x41,0xd2,
        0x24,0x08,0x0a,0xb8,0xf3,0x53,0x10,0x96,0x3f,0xc6,0x68,0x72,0x33,0xf0,0x9e,0x91,
        0x91,0x30,0x9b,0x98,0x4d,0x90,0x59,0xd4,0x59,0xd7,0x1f,0xd2,0x92,0x71,0x92,0x9d,
        0x4d,0x01,0x60,0xc6,0xdc,0xd0,0x91,0xfe,0x93,0x11,0x07,0x30,0xc3,0x35,0x1d,0x9a,
        0x05,0xb0,0x12,0xb5,0x1b,0xc8,0x8f,0x63,0x58,0x29,0x30,0xdb,0x07,0xc9,0xf8,0x22,
        0xad,0x1a,0x1d,0x98,0x9c,0xbd,0xdc,0x7e,0xba,0x9a,0x01,0x68,0x54,0x2e,0xb7,0x18,
        0x11,0x2b,0x63,0xa6,0xf9,0x7e,0x9c,0x5c,0x54,0x69,0x96,0x94,0x4a,0x7a,0x95,0x05,
        0x6a,0x83,0x4f,0x71,0xb2,0xb8,0x55,0xab,0x39,0xba,0xb7,0x60,0x02,0x84,0x03,0x99,
        0xc2,0x0f,0x2f,0xaf,0x64,0x04,0x74,0xaf,0x7c,0x6a,0xfa,0x8b,0xf4,0x73,0x12,0xe0,
        0x7a,0x68,0xc8,0xdb,0xf3,0xbc,0xbb,0x50,0xe2,0xe8,0x53,0x6c,0x02,0x58,0xdc,0xd3,
        0x3a,0x8d,0xc6,0x08,0x74,0x55,0xc6,0x76,0xe4,0x3c,0xf6,0xbf,0x4d,0xe3,0x8a,0xc4,
        0xbb,0x88,0x0a,0x8c,0xda,0xdd,0xda,0x87,0xd5,0x8e,0x6c,0xf6,0x88,0xa5,0xd4,0x34,
        0xd2,0x3e,0xb7,0x32,0xa0,0x12,0xbc,0xf4,0xd9,0xf7,0x3d,0xe3,0xd9,0xd8,0xba,0x32,
        0xd9,0x29,0x65,0x80,0x33,0x51,0xfc,0xca,0x85,0xed,0x7d,0xf2,0x35,0xcb,0x63,0x62,
        0x7c,0x87,0x1c,0xfb,0x43,0xc8,0x17,0xc4,0x4e,0x13,0x06,0xe4,0x5f,0x99,0x64,0x28,
        0xe9,0x58,0x6f,0x82,0xab,0x70,0x6e,0x49,0xc9,0x8c,0xaa,0x89,0x05,0x53,0x41,0x4f,
        0x4b,0x1e,0xc3,0x54,0x20,0x34,0x0c,0x22,0xbd,0x1a,0x65,0xb9,0x83,0x6e,0x62,0xdd,
        0x16,0xaa,0xd1,0x5f,0x62,0xa9,0x7f,0xd4,0x4f,0xd6,0xe8,0x1b,0x26,0xa3,0x13,0xa7,
        0xae,0xc2,0x85,0xb8,0x76,0xb2,0x5f,0x4a,0x68,0x06,0xeb,0xc3,0x97,0xee,0xca,0xa5,
        0x82,0x29,0x98,0xbc,0xa9,0x4c,0xba,0x29,0xd1,0x33,0xd1,0x39,0x7d,0x50,0x5e,0xd2,
        0x94,0x49,0x45,0x7c,0xa4,0xcc,0xf4,0x9b,0x3a,0x32,0x74,0x8e,0x8a,0xd5,0xc9,0x6a,
        0x0b,0x22,0xb5,0x71,0x37,0x8e,0xc7,0x88,0x53,0xbf,0x71,0x9d,0x43,0x06,0x5d,0xe6,
        0x6c,0x3a,0xd0,0xa7,0xaa,0x69,0xc1,0xa1,0xd2,0x36,0x26,0xfb,0x3e,0x6c,0xd0,0xd3,
        0x83,0x94,0x6b,0xf6,0x1b,0xdd,0x13,0xdc,0x04,0xea,0x79,0x9b,0x3c,0x5a,0x38,0x8e,
        0x85,0xbd,0xf2,0x66,0x34,0x98,0x76,0xad,0xc2,0xc2,0xd2,0xf6,0xfc,0x9c,0x61,0x8f,
        0xbe,0x8b,0xde,0x4b,0x1f,0x19,0xd9,0x8c,0xe0,0xc0,0x56,0x49,0xd4,0xbb,0xf4,0x61,
        0xed,0xdd,0x9f,0xeb,0x52,0x9b,0xb6,0x23,0x5f,0x3a,0x3f,0xf0,0x45,0x51,0x2a,0x11,
        0x77,0x96,0x4a,0x17,0xc3,0xac,0x34,0xc3,0xa6,0x8a,0xe6,0x8f,0x72,0x6f,0x27,0xf7,
        0x6f,0x94,0xd1,0x48,0xb9,0xe1,0x39,0x12,0x7d,0x4a,0x63,0x48,0x28,0x5a,0x77,0x7f,
        0x57,0xc8,0xb4,0xa1,0x7f,0x45,0xa9,0x45,0xa2,0xc7,0xba,0x4c,0x16,0x58,0x89,0xe7,
        0x09,0xba,0xa5,0x38,0x76,0x32,0x42,0xfe,0x73,0x10,0xdb,0x34,0x9e,0x5b,0x1f,0x3a,
        0xcc,0xe8,0x9d,0x9b,0x61,0xe5,0x7c,0x7f,0xff,0xdf,0x78,0xd6,0x96,0xca,0xfe,0x1f,
        0xf7,0x8b,0xa4,0xd4,0x0b,0x53,0xfb,0x1e,0x5a,0x8e,0x5f,0xdf,0x44,0xdb,0x66,0x99,
        0x76,0xe5,0x58,0x40,0xd8,0xbc,0xd9,0xb7,0xc0,0x21,0x2a,0xd8,0xa7,0x23,0x4e,0x5f,
        0x05,0xdc,0xde,0x46,0x9d,0x13,0xe8,0x3e,0xb9,0xed,0x46,0x7d,0x09,0xba,0xdd,0x09,
        0x6f,0xf7,0xa2,0x17,0xcc,0x57,0x4b,0x39,0x45,0xce,0x24,0x23,0x7b,0x64,0x7d,0x3b,
        0x4b,0xcd,0x91,0xf8,0xbf,0x50,0xfd,0xc7,0x65,0x8b,0xb3,0x15,0xc1,0xa8,0x44,0xdb,
        0x71,0xef,0x8c,0xf0,0x73,0xcd,0xf7,0x84,0xc9,0x25,0x4d,0x0f,0x06,0x64,0xb7,0x48,
        0x4d,0x30,0xcf,0x0f,0xc1,0x49,0xa2,0x42,0x25,0xa1,0x67,0x27,0xf7,0x24,0x0e,0x15,
        0x59,0xbd,0x41,0xdf,0xc8,0x40,0xfc,0x6a,0x20,0xae,0x92,0xa4,0xe6,0x54,0x74,0xe3,
        0xcd,0x12,0xcf,0x6d,0x4d,0x10,0x5b,0xdd,0x4b,0xfa,0xb3,0x66,0x66,0x07,0xea,0xc0,
        0x6c,0x66,0x91,0xd7,0x8f,0xf3,0xa3,0x39,0xe2,0x98,0xcd,0xb2,0x46,0xe8,0x94,0xca,
        0xb8,0x2f,0xc5,0xc5,0xa1,0x08,0x93,0x6a,0x21,0xa7,0x1b,0x0f,0x8e,0x96,0xd8,0xae,
        0x1b,0x8e,0xe6,0xeb,0x70,0x1f,0xea,0x62,0x73,0xd0,0xa3,0x4d,0x82,0x56,0xde,0x4a,
        0x3f,0xc7,0x02,0xc2,0xb8,0xa8,0x51,0xcd,0xb6,0x8d,0xc9,0x69,0x1b,0x7f,0x81,0x0c,
        0x0d,0xf0,0x0f,0x3f,0x3d,0x45,0xf7,0xf4,0x18,0xe8,0x04,0xcc,0xa1,0xf7,0xa0,0x8b,
        0xcb,0xf3,0x85,0xbc,0xf5,0x25,0x3e,0xb2,0xfa,0x89,0x5f,0xc4,0x47,0x5e,0xc7,0x0d,
        0xd8,0xcd,0x40,0x22,0x42,0x4a,0x33,0x88,0x68,0x73,0x06,0xe4,0x87,0x80,0xcd,0x5e,
        0x59,0x8f,0x96,0xf1,0xc2,0x00,0x24,0x44,0xa4,0x41,0x64,0x62,0x64,0x94,0x92,0x4a,
        0x8c,0x29,0xf4,0x71,0x5e,0x2d,0xb6,0x36,0xb9,0x64,0x45,0xa3,0x39,0xad,0x17,0x21,
        0xf5,0x76,0xff,0x21,0xaf,0x48,0x13,0x4e,0x9b,0x7a,0x32,0x29,0x06,0xc3,0xb8,0xf4,
        0x0d,0x4b,0xba,0x42,0x6a,0x29,0x08,0x74,0xea,0x91,0x16,0xa7,0xf7,0x8b,0x62,0x0b,
        0x2e,0x72,0x00,0xdb,0xd3,0x10,0xd9,0xec,0x36,0x46,0x25,0x72,0x06,0xe7,0x79,0x8b,
        0xb9,0x94,0x3d,0xbf,0xb5,0x46,0x8f,0x35,0xa7,0xdd,0x1a,0x7f,0x81,0x60,0x51,0xf7,
        0xcd,0xd6,0xe0,0xe4,0xe2,0x1a,0x9d,0x0d,0xa4,0xd6,0x6b,0xe2,0x25,0x72,0x53,0xf9,
        0x4c,0x9d,0x89,0x8a,0x0e,0x03,0x1e,0xb0,0x97,0x1c,0x75,0x60,0xb1,0x8e,0x92,0xa7,
        0x93,0xb0,0xea,0xfa,0x6b,0xf1,0x73,0xd7,0x31,0x9e,0xd0,0xce,0x72,0x48,0xce,0x73,
        0x91,0x0d,0x0b,0x80,0x83,0x5f,0x4b,0x6c,0xd0,0xa3,0xfa,0xbe,0xf2,0xa9,0x3e,0x2b,
        0x17,0xf4,0x30,0x97,0xf3,0x91,0xbf,0x1f,0xfc,0xab,0x0f,0xcf,0x6c,0xdf,0x6d,0xca,
        0x32,0x01,0x20,0xbc,0x2d,0x61,0x1c,0x72,0x5c,0x42,0xf4,0xa2,0xde,0x8a,0xf4,0xdb,
        0x64,0xb2,0xf5,0x26,0xfd,0x5e,0x76,0x62,0x54,0xc7,0x6a,0x97,0x97,0x54,0x6b,0x11,
        0xc7,0x09,0x64,0x8a,0xde,0xd4,0xf0,0xde,0xe0,0xdb,0x9c,0xea,0xc5,0x94,0x66,0xb2,
        0x3e,0xb2,0x59,0xb3,0xad,0x75,0x03,0x97,0xed,0x34,0x5d,0x56,0x72,0x19,0x4a,0x5f,
        0x1d,0x2f,0x05,0xc8,0x99,0xe4,0xad,0x3f,0x12,0x39,0x09,0x94,0x46,0x09,0xde,0x4d,
        0x06,0x41,0x66,0xa5,0xc6,0x26,0xa6,0xbb,0x8f,0x0a,0x71,0x28,0x6f,0x05,0x98,0x32,
        0x1a,0x8a,0xee,0xa2,0x5b,0x73,0x39,0x63,0xce,0x98,0x66,0xeb,0x20,0x1b,0x8c,0x28,
        0xc5,0x92,0xe5,0x53,0xb4,0xe1,0x00,0xed,0x70,0x21,0xd9,0x83,0xda,0x35,0xe6,0x80,
        0xd5,0xf8,0x75,0x6a,0x15,0xd1,0xc0,0x4a,0x5f,0xaa,0x66,0x5b,0x4e,0xbb,0x75,0xc2,
        0x3d,0xfe,0x4c,0x7a,0x00,0x76,0x2d,0xc0,0xa0,0x48,0xab,0xb5,0xfa,0x11,0x68,0x28,
        0xa5,0xff,0xb0,0x2e,0x44,0x4d,0xdb,0x35,0x6e,0x52,0xa9,0xc8,0x92,0xb8,0x1c,0xe9,
        0x67,0x90,0x26,0x6a,0x9d,0x6a,0xea,0x91,0x1c,0x2a,0x41,0x80,0xd8,0x3b,0xfa,0xb4,
        0xb3,0x05,0x3b,0xcf,0xf5,0x40,0xc8,0x26,0xbe,0xb8,0xce,0x1b,0x81,0xde,0xd3,0x46,
        0x63,0x4e,0x9a,0xe9,0x92,0xb2,0x39,0xbe,0xbb,0x9a,0x71,0x7a,0xc3,0xfd,0x9d,0x98,
        0x34,0xdd,0x20,0x5b,0x5f,0x87,0xaf,0x98,0x76,0x63,0xc0,0x05,0x28,0xc7,0x8a,0xce,
        0xff,0x87,0xc5,0xfc,0x50,0x11,0x00,0x57,0x84,0x25,0x1f,0xe1,0xa0,0x6f,0xba,0x8b,
        0x9c,0x71,0x66,0x7e,0x72,0x61,0xad,0x8b,0x3f,0x72,0x27,0xeb,0x03,0x03,0xb1,0xc2,
        0x78,0x79,0x11,0xb6,0x49,0x50,0xcc,0xa1,0x63,0x26,0x04,0xb2,0x8e,0x7c,0x64,0x83,
        0x2f,0xe5,0x57,0x04,0x5f,0x1b,0xa1,0x05,0x87,0x9f,0x32,0x60,0x82,0x53,0x7d,0x1f,
        0xbc,0x5b,0xec,0xc1,0x99,0xab,0x8b,0x4e,0x73,0x68,0xca,0xc6,0xcc,0x5a,0x55,0xc4,
        0x80,0xa8,0x90,0x93,0x1c,0xd4,0xf6,0xa3,0x53,0x2f,0xe2,0xd8,0x87,0xde,0xa4,0x03,
        0x20,0xe1,0x60,0xd3,0x9d,0x56,0x12,0x8d,0xbb,0x8a,0x40,0x24,0x78,0x7c,0xc2,0xae,
        0x75,0x62,0x9f,0x10,0xcd,0x5f,0xfb,0x16,0x1e,0x5c,0x33,0xda,0xdf,0x60,0x30,0xe0}, 
        /*TST_dataSize*/
        1536*sizeof(DxUint8_t),       
        CRYS_AES_CBC_mode
    },
    #endif
    #if TST_USE_AES_192_KEY
    #if TST_USE_AES_16BYTE_DATA
    { 
        {"Acceptance test - AES/CBC/192Key/16ByteData "},
        /*TST_Key*/     
        {0x8e,0x73,0xb0,0xf7,0xda,0x0e,0x64,0x52,0xc8,0x10,0xf3,0x2b,0x80,0x90,0x79,0xe5,
         0x62,0xf8,0xea,0xd2,0x52,0x2c,0x6b,0x7b},
        CRYS_AES_Key192BitSize,
        /*TST_IvCounter*/
        {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f}, 
        /*TST_input_data*/
        {0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a},
        {0},
        /*TST_Expected_output_data for enc Input data for decrypt*/
        {0x4f,0x02,0x1d,0xb2,0x43,0xbc,0x63,0x3d,0x71,0x78,0x18,0x3a,0x9f,0xa0,0x71,0xe8}, 
        /*TST_dataSize*/
        16*sizeof(DxUint8_t),       
        CRYS_AES_CBC_mode
    },
    #endif
    #if TST_USE_AES_32BYTE_DATA
    { 
        {"Acceptance test - AES/CBC/192Key/32ByteData "},
        /*TST_Key*/     
        {0x8e,0x73,0xb0,0xf7,0xda,0x0e,0x64,0x52,0xc8,0x10,0xf3,0x2b,0x80,0x90,0x79,0xe5,
         0x62,0xf8,0xea,0xd2,0x52,0x2c,0x6b,0x7b},
        CRYS_AES_Key192BitSize,
        /*TST_IvCounter*/
        {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f},
        /*TST_input_data*/
        {0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a,
         0x65,0xa2,0x32,0xd6,0xbc,0xd0,0xf9,0x39,0xed,0x1f,0xe1,0x28,0xc1,0x3b,0x0e,0x1b},
        {0},
        /*TST_Expected_output_data for enc Input data for decrypt*/
        {0x4f,0x02,0x1d,0xb2,0x43,0xbc,0x63,0x3d,0x71,0x78,0x18,0x3a,0x9f,0xa0,0x71,0xe8,
         0xc5,0x1b,0x8e,0x34,0x07,0x3a,0x94,0x2e,0x27,0x5f,0xb8,0xcd,0x75,0x96,0x6b,0x7f}, 
        /*TST_dataSize*/
        32*sizeof(DxUint8_t),     
        CRYS_AES_CBC_mode
    },
    #endif
    #if TST_USE_AES_512BYTE_DATA
    { 
        {"Acceptance test - AES/CBC/192Key/512ByteData "},
        /*TST_Key*/     
        {0x8e,0x73,0xb0,0xf7,0xda,0x0e,0x64,0x52,0xc8,0x10,0xf3,0x2b,0x80,0x90,0x79,0xe5,
         0x62,0xf8,0xea,0xd2,0x52,0x2c,0x6b,0x7b},
        CRYS_AES_Key192BitSize,
        /*TST_IvCounter*/
        {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f},
        /*TST_input_data*/
        {0xb6,0xed,0x21,0xb9,0x9c,0xa6,0xf4,0xf9,0xf1,0x53,0xe7,0xb1,0xbe,0xaf,0xed,0x1d,
         0xf3,0xee,0xd1,0xbd,0xb5,0xd2,0xa0,0x3c,0x06,0x4b,0x5a,0x7e,0x3d,0xb1,0x81,0xf8,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0x62,0xf8,0xa7,0x23,0x7b,0xbd,0xf8,0x4d,0x4e,0x1d,0xff,0xe8,0xb5,0x2a,0x02,0xc1,
         0x52,0xdb,0x14,0x2f,0xeb,0x21,0xf9,0x58,0xb8,0x80,0x28,0x68,0xe4,0x99,0x06,0x18,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0xb6,0xed,0x21,0xb9,0x9c,0xa6,0xf4,0xf9,0xf1,0x53,0xe7,0xb1,0xbe,0xaf,0xed,0x1d,
         0xf3,0xee,0xd1,0xbd,0xb5,0xd2,0xa0,0x3c,0x06,0x4b,0x5a,0x7e,0x3d,0xb1,0x81,0xf8,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0x62,0xf8,0xa7,0x23,0x7b,0xbd,0xf8,0x4d,0x4e,0x1d,0xff,0xe8,0xb5,0x2a,0x02,0xc1,
         0x52,0xdb,0x14,0x2f,0xeb,0x21,0xf9,0x58,0xb8,0x80,0x28,0x68,0xe4,0x99,0x06,0x18,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0xb6,0xed,0x21,0xb9,0x9c,0xa6,0xf4,0xf9,0xf1,0x53,0xe7,0xb1,0xbe,0xaf,0xed,0x1d,
         0xf3,0xee,0xd1,0xbd,0xb5,0xd2,0xa0,0x3c,0x06,0x4b,0x5a,0x7e,0x3d,0xb1,0x81,0xf8,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0x62,0xf8,0xa7,0x23,0x7b,0xbd,0xf8,0x4d,0x4e,0x1d,0xff,0xe8,0xb5,0x2a,0x02,0xc1,
         0x52,0xdb,0x14,0x2f,0xeb,0x21,0xf9,0x58,0xb8,0x80,0x28,0x68,0xe4,0x99,0x06,0x18,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0xb6,0xed,0x21,0xb9,0x9c,0xa6,0xf4,0xf9,0xf1,0x53,0xe7,0xb1,0xbe,0xaf,0xed,0x1d,
         0xf3,0xee,0xd1,0xbd,0xb5,0xd2,0xa0,0x3c,0x06,0x4b,0x5a,0x7e,0x3d,0xb1,0x81,0xf8,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0x62,0xf8,0xa7,0x23,0x7b,0xbd,0xf8,0x4d,0x4e,0x1d,0xff,0xe8,0xb5,0x2a,0x02,0xc1,
         0x52,0xdb,0x14,0x2f,0xeb,0x21,0xf9,0x58,0xb8,0x80,0x28,0x68,0xe4,0x99,0x06,0x18,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9},
        {0},
        /*TST_Expected_output_data for enc Input data for decrypt*/
        {0x0d,0xcc,0x71,0xa5,0xa2,0x82,0x01,0x65,0x94,0x76,0xc7,0x6b,0x13,0x6c,0xa3,0x0c,
         0x1d,0x48,0xb3,0x01,0x71,0xa9,0x92,0xbf,0x25,0x7d,0x1c,0x7d,0x75,0x68,0x84,0x11,
         0x5f,0xad,0x1e,0x1c,0xf7,0xb2,0x4a,0x62,0x2b,0x77,0x9f,0xe7,0x2a,0xd7,0xd2,0x7c,
         0x57,0x8e,0x50,0xb1,0xc2,0xe4,0x85,0xe9,0x48,0xd1,0xe8,0x99,0xa7,0xd9,0x46,0xd5,
         0xe5,0x60,0x2a,0xe0,0xf4,0x61,0xc5,0x44,0xe9,0x43,0x4e,0xce,0x9b,0xc9,0x30,0x71,
         0x23,0x0e,0xba,0x23,0x14,0x14,0xca,0xc0,0x58,0x9c,0xb3,0xb3,0x12,0x5d,0x49,0xf5,
         0xd2,0x34,0x32,0xcc,0x58,0xa9,0xa8,0xdf,0xdf,0x36,0xa7,0xe2,0x2c,0x6a,0x97,0x89,
         0x16,0x1f,0xeb,0x0a,0x5a,0xf0,0x0f,0x17,0x7b,0x53,0xfb,0xee,0x27,0xf7,0xb9,0xbd,
         0xf3,0x44,0xef,0x78,0xe2,0xcc,0x19,0x20,0x95,0x6b,0x49,0x48,0xc5,0xcf,0x5c,0x6a,
         0xa0,0x26,0xdf,0xd2,0x24,0x49,0x26,0xd5,0xc3,0xbd,0x47,0x38,0xf3,0x2f,0x32,0x2d,
         0xb7,0x4e,0x82,0x81,0xa1,0x86,0x1a,0x8f,0xfc,0x9d,0xe3,0xab,0xb7,0xe1,0x25,0xfc,
         0x11,0xb2,0x87,0xa1,0xf0,0x82,0x4f,0x0c,0xe9,0x28,0x11,0xa2,0xeb,0x8d,0x89,0x1f,
         0x9a,0x26,0xbc,0xf7,0x6e,0x01,0x29,0xe0,0x4f,0x75,0x31,0x5d,0xf4,0x7d,0xda,0xfa,
         0xcf,0xed,0x90,0xb8,0xf4,0xe7,0x6d,0xea,0x13,0x22,0x09,0x68,0x83,0xbb,0x39,0xdd,
         0x42,0xbf,0xc5,0xb2,0x9e,0xb9,0x5f,0xee,0x88,0x92,0x13,0xd2,0x4c,0xc8,0xc6,0xdd,
         0x41,0xe1,0xe6,0xfe,0x9f,0xe5,0xe7,0x54,0x77,0xe1,0xdc,0x75,0xb8,0x74,0x67,0x61,
         0x9a,0x66,0x6a,0x9a,0xd5,0xaf,0xd6,0x02,0xf7,0x99,0x45,0xec,0x23,0x40,0x58,0x0b,
         0xab,0x3d,0x96,0x71,0x0e,0xaf,0xa8,0x08,0x24,0x85,0x09,0x5f,0x56,0x92,0x93,0xc5,
         0x8c,0xcb,0xb1,0xff,0xe3,0xa6,0x7f,0x42,0x24,0xa9,0x30,0xe2,0xa3,0xcc,0x9e,0xa5,
         0x12,0x7e,0xf6,0x4d,0x63,0x57,0x90,0x42,0x05,0x2c,0x41,0xda,0x94,0x30,0x1c,0x60,
         0x97,0x4b,0x94,0x9c,0x0a,0xb5,0xfc,0x30,0x7e,0xe6,0x31,0x40,0xeb,0xa3,0x1a,0x2a,
         0xe4,0xdd,0xfd,0x7c,0x90,0x91,0x5a,0xbd,0x00,0x5b,0xb1,0xda,0x4f,0x7c,0x66,0xfe,
         0xd1,0xac,0x11,0xd0,0x69,0x15,0xc6,0xdc,0xec,0x0a,0x80,0xf2,0x22,0x48,0xc8,0xcd,
         0x2b,0x2e,0xce,0x09,0x85,0x88,0xd5,0x7e,0x15,0xb9,0xd6,0x7b,0xe5,0xc7,0x3f,0x42,
         0x89,0x5e,0xce,0xa1,0xbc,0x2a,0xbc,0xac,0xc8,0x52,0x7f,0x20,0xee,0xf7,0xa5,0x3d,
         0xf0,0x64,0xda,0xbc,0x14,0xef,0x25,0x21,0x85,0x55,0x36,0xdd,0x4e,0x34,0x4d,0x94,
         0x77,0xb2,0xb3,0x99,0x1c,0x15,0x3b,0x60,0xee,0x73,0x6d,0x76,0x31,0x04,0xe2,0xed,
         0xe9,0x81,0xb9,0x2a,0x03,0x41,0x1e,0x80,0xd9,0xce,0xad,0xa8,0x5f,0x32,0xda,0x09,
         0x38,0xca,0x6b,0x05,0xb6,0xcc,0x72,0x7e,0x42,0x07,0xbd,0x39,0x04,0xd6,0x59,0x67,
         0x50,0xd0,0xec,0x2e,0x69,0x7a,0x78,0x4c,0x15,0xd7,0x4c,0x1c,0x4e,0x64,0xad,0x25,
         0x49,0x51,0x1c,0x24,0x0a,0x95,0xef,0x2c,0x49,0xbb,0x1e,0xb6,0xc9,0x4f,0x67,0xe5,
         0x5d,0x6b,0x13,0x08,0x77,0x29,0x26,0x84,0xe5,0x67,0xcd,0x12,0x33,0xce,0x65,0x9f}, 
        /*TST_dataSize*/
        512*sizeof(DxUint8_t),        
        CRYS_AES_CBC_mode
    },
    #endif
    #if TST_USE_AES_1536BYTE_DATA
    { 
        {"Acceptance test - AES/CBC/192Key/1536ByteData "},
        /*TST_Key*/     
        {0xfa,0xca,0x2f,0xf1,0x88,0x19,0x95,0x07,0xad,0xb5,0xe0,0x07,0x4a,0x4b,0x1a,0xa4,
        0xd5,0xc6,0x95,0xb7,0x51,0x6f,0x7e,0x87},
        CRYS_AES_Key192BitSize,
        /*TST_IvCounter*/
        {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f}, 
        /*TST_input_data*/
        {0xab,0xc4,0xbd,0xf5,0x16,0xc9,0x1a,0xd6,0xc6,0xf8,0x12,0xa9,0x61,0x2f,0x93,0xf0,
        0x6c,0xaf,0x6f,0x88,0x61,0xda,0x0d,0x8b,0x02,0x3c,0x5f,0x74,0xec,0xc9,0x13,0x84,
        0x6f,0x65,0x0e,0x65,0x9d,0xaa,0x16,0x0e,0xa1,0xe5,0xce,0xe6,0x53,0x61,0xe8,0x2c,
        0x09,0xe9,0x96,0x96,0xaf,0x88,0x41,0x38,0x1a,0x93,0x7e,0xa8,0x99,0xe9,0x3e,0x60,
        0xcd,0x7a,0x44,0x63,0xbb,0x06,0xdd,0x24,0x20,0x27,0xcb,0xa3,0x04,0x92,0x82,0xd9,
        0x92,0x9a,0x97,0x56,0x27,0xf6,0x75,0x29,0xa9,0xc3,0x52,0x00,0x1a,0xcd,0x61,0x90,
        0x6d,0x0a,0x49,0x37,0x98,0x67,0xd7,0xe0,0xea,0xc7,0xef,0x28,0x9f,0x49,0xc9,0xbf,
        0xb2,0xca,0x5a,0x10,0xf2,0xac,0x0f,0x24,0x58,0xd5,0xc1,0xc3,0x98,0xfa,0xe6,0xdd,
        0xf6,0x1d,0x04,0x29,0x5b,0x54,0x6c,0x0c,0xa8,0xcd,0x24,0xbc,0x4a,0x0f,0x25,0xa5,
        0x0f,0x82,0xc6,0x0c,0x37,0x32,0x79,0xf2,0xcf,0xd0,0xb5,0x3b,0x3a,0xfa,0x33,0x0f,
        0x11,0xbb,0x5d,0x81,0x2d,0x56,0x04,0x6e,0x01,0x3f,0x51,0xa8,0x2d,0x6b,0xfe,0x54,
        0x51,0xc9,0xc5,0x91,0x1f,0x11,0x19,0x5b,0xb5,0xbc,0x15,0xae,0x29,0x53,0xb2,0xee,
        0x65,0xed,0x3c,0x86,0x35,0xf4,0x07,0xd0,0x9e,0x27,0x5e,0x35,0x72,0xe5,0xbc,0x95,
        0x21,0xa8,0x3f,0xe8,0xd2,0xd0,0x59,0x26,0xb2,0xa2,0xc9,0x65,0x8c,0x90,0xc9,0x41,
        0x9b,0xba,0x89,0x81,0x9c,0xb6,0xdd,0xf8,0x26,0x8c,0x32,0xa8,0x3e,0x05,0xc7,0x2e,
        0x27,0x26,0x1a,0x5a,0x77,0xf7,0xa0,0x1d,0x70,0x89,0xb8,0xa8,0x8c,0x36,0xe2,0xd2,
        0x5a,0x2b,0x2c,0xba,0x89,0x24,0xee,0xae,0x42,0x77,0xb7,0x4c,0xbc,0x54,0x87,0xe7,
        0x0a,0x4b,0x3f,0x2d,0x37,0x0e,0x55,0x06,0x94,0x79,0xcc,0xbf,0x51,0xcf,0x64,0x67,
        0x4b,0x47,0x0e,0x79,0x25,0xc7,0xa2,0xbc,0x9a,0xef,0xd4,0x68,0x11,0x59,0x65,0x8a,
        0x72,0x1f,0x96,0xa9,0x39,0x9e,0xe2,0xaa,0xc9,0x7a,0xec,0xf1,0x02,0xe3,0xb7,0xc9,
        0x15,0x16,0x15,0x06,0x97,0x26,0x62,0xe9,0xd5,0xfc,0x71,0x43,0x68,0x9c,0xc7,0xdd,
        0x09,0xab,0x07,0x18,0xa6,0x2e,0xae,0xd1,0xb5,0x95,0x00,0x87,0xc8,0xf8,0x43,0xc0,
        0x61,0xa0,0x2a,0xa8,0x08,0xc9,0x94,0xfc,0x9c,0xa6,0x77,0x26,0xe7,0xa6,0x16,0xaa,
        0x74,0xf6,0x7b,0xc0,0xa5,0x47,0x21,0x42,0x00,0xd1,0xf1,0xc9,0xca,0x98,0x6f,0x14,
        0xd7,0xee,0x36,0xa9,0xa0,0x39,0xa2,0xbe,0x96,0xf6,0xcc,0x59,0xb6,0xfe,0xbb,0xb7,
        0x5e,0x08,0xd8,0xeb,0x5f,0x70,0xa3,0xc7,0x53,0x37,0xa5,0xff,0x31,0x4a,0xa5,0x8c,
        0x1e,0x07,0x1f,0x4f,0x86,0xfd,0xf2,0xf7,0x6c,0xf3,0x59,0x24,0xfe,0x2c,0x1c,0xcc,
        0x6d,0xea,0x08,0xdf,0xfb,0x31,0x9c,0x26,0x56,0xcd,0x05,0x71,0x24,0x97,0x4d,0xf1,
        0xdf,0xf3,0xcf,0xe3,0xe3,0x9d,0xee,0x6e,0xc5,0xa6,0x06,0xcf,0xe7,0xb9,0xa3,0xb3,
        0x49,0xa3,0xf1,0xe4,0xa2,0x12,0x74,0x28,0xb0,0x9d,0xf9,0x67,0xcc,0x05,0xcd,0x0b,
        0xc1,0xbb,0x2c,0xac,0xde,0xa2,0xfc,0xed,0x4a,0x15,0xbc,0xa1,0x98,0x2c,0xb7,0x33,
        0x9b,0x3b,0x7d,0x44,0x7c,0x9c,0x93,0x95,0x09,0xaf,0x6a,0x28,0x50,0x1e,0x8e,0xa2,
        0x6d,0x66,0x20,0xf4,0xa0,0x93,0x86,0x3a,0xa3,0x4a,0x61,0xe3,0x3a,0x0d,0xbf,0x13,
        0x0b,0xbb,0x93,0x45,0xb0,0x56,0x62,0x35,0x0b,0x09,0x3e,0xfd,0xd9,0x6a,0xf8,0x7e,
        0x8a,0xfc,0x92,0x01,0x51,0xf8,0xf3,0x1e,0x77,0x4d,0xde,0xde,0xf4,0xe5,0x25,0x1c,
        0x40,0x2a,0x1a,0x31,0x67,0xc9,0x47,0xd0,0x5c,0xb5,0x5f,0x2e,0x8f,0x70,0x74,0x66,
        0xc1,0x86,0x69,0x1d,0x17,0x5a,0xab,0x61,0x6e,0x24,0x1c,0xd7,0xef,0x3b,0x50,0x16,
        0xe3,0x90,0xfc,0x4e,0xc8,0x7b,0xab,0x2d,0xa4,0xbb,0xb3,0x03,0x99,0xb8,0x68,0x24,
        0xba,0x0a,0x8f,0x8e,0x1d,0x3f,0x16,0xcb,0x31,0xd9,0x02,0x19,0x52,0x97,0xa8,0xc9,
        0x9b,0xf6,0x20,0xe5,0xfc,0xf6,0xf7,0x15,0x8c,0x21,0x24,0xc3,0x20,0xca,0x3d,0x7e,
        0x1c,0x93,0xeb,0x9c,0x89,0x32,0x9c,0x24,0x68,0x74,0x77,0xeb,0x46,0x81,0x95,0xfc,
        0x11,0x63,0x6e,0x3d,0x2a,0xc2,0x91,0x50,0xbb,0xf1,0x99,0xb8,0x4b,0x2f,0x5c,0x3d,
        0x90,0x26,0x65,0x91,0x84,0xb8,0xa5,0x33,0xbb,0xfb,0x65,0x94,0xf3,0x82,0x7f,0x79,
        0xed,0xdf,0xce,0xa0,0x7b,0x65,0xe3,0xa6,0xdb,0x33,0xf9,0x28,0x43,0x6e,0x2b,0x29,
        0xbd,0xcd,0xe5,0xb3,0x35,0x5b,0x99,0xc1,0xd0,0x78,0xb3,0x5d,0x80,0x21,0xce,0x06,
        0xd6,0x72,0x28,0x54,0x17,0x69,0x53,0xdf,0x91,0xed,0x2e,0x5c,0x2f,0x0f,0x14,0x09,
        0x4c,0x8f,0x53,0x4c,0xc5,0xa2,0xe0,0x96,0x52,0xf2,0x49,0x8e,0x16,0xe7,0xea,0x6c,
        0x74,0x25,0x64,0xa2,0x25,0x56,0x4b,0xc2,0x87,0x29,0x1f,0x9c,0x38,0x9a,0x7e,0xa6,
        0xe4,0x75,0x97,0xa2,0x5b,0x15,0xe2,0x7a,0xe7,0x72,0x0f,0x6f,0xdc,0x5b,0x3c,0x72,
        0x70,0xff,0x6a,0xd2,0xcd,0xb2,0x32,0x18,0x65,0xee,0xb4,0x30,0x86,0x98,0xd1,0xc9,
        0x2e,0x85,0x9a,0xfd,0x20,0x3d,0x07,0x35,0x37,0xff,0xed,0x47,0xfb,0x05,0x2a,0xe2,
        0x72,0x08,0x22,0x2c,0x39,0x07,0x70,0xa9,0xd2,0x45,0xd5,0x5f,0x40,0x91,0x74,0x38,
        0xd1,0xc9,0x42,0xa7,0x3c,0xa1,0xb8,0x8e,0xeb,0xa1,0xcb,0x60,0x9a,0x6d,0x1d,0x83,
        0x21,0x49,0x75,0xf8,0x8e,0xdc,0x6d,0x3d,0x77,0x34,0x6a,0x72,0x8f,0x0b,0xd1,0xbc,
        0x76,0x49,0x78,0xe7,0xd6,0xca,0x5b,0x4f,0xab,0x60,0x91,0x00,0xe2,0x1c,0x7e,0x1c,
        0x26,0xc9,0x49,0x7d,0xf7,0xba,0x90,0x9c,0xfc,0xc6,0x5b,0xb1,0x9a,0x90,0x4f,0x1c,
        0xc5,0x0c,0x25,0x04,0x16,0x3e,0x5a,0x3e,0x1e,0x45,0x27,0x70,0xfb,0x99,0xb3,0x76,
        0x28,0x91,0x88,0x04,0x9a,0x28,0x43,0x8d,0x08,0x00,0x90,0x64,0x8a,0xa7,0x56,0x22,
        0x65,0x1a,0x2f,0x47,0x25,0x87,0x1b,0x24,0xed,0x57,0x75,0xf8,0x0c,0x6c,0x26,0x59,
        0xd0,0xa7,0x18,0xd5,0x9f,0xae,0xee,0xda,0x43,0xec,0xf2,0xd3,0x86,0xd9,0x4e,0x94,
        0xff,0x7b,0x80,0xf8,0x2b,0x2d,0x08,0xc8,0xc0,0x9f,0x63,0xdf,0x3d,0x1e,0x3d,0x8c,
        0xc6,0x15,0xe3,0x38,0x2f,0xd4,0xf7,0x49,0x57,0x91,0x67,0x46,0xb7,0xac,0x9f,0x3b,
        0x3a,0x38,0xfe,0x5f,0x4f,0xb6,0x87,0xf4,0x3d,0x23,0xda,0x6f,0xb8,0x36,0x62,0xd9,
        0xb1,0xe3,0xcf,0x75,0x72,0x23,0xc7,0xa3,0xe9,0xf7,0xd8,0x04,0x44,0xaa,0xb2,0xdf,
        0xbf,0x57,0x93,0xc3,0xba,0xac,0x02,0x6e,0x0f,0xed,0xc0,0xee,0xa2,0x3c,0xfc,0x06,
        0x3a,0x17,0xc6,0xd3,0x8f,0x22,0xc6,0xaf,0xa4,0x27,0x2e,0x56,0x56,0x5b,0xed,0x48,
        0x35,0xe3,0x26,0x6e,0x94,0x96,0xe0,0xff,0xdc,0x05,0xff,0xa5,0x26,0xb8,0x73,0xdc,
        0x08,0xbb,0xaf,0x9b,0xae,0x5a,0x5c,0x37,0x2d,0x28,0x4f,0x84,0x15,0x46,0xb9,0x3d,
        0x45,0xe1,0x9e,0xa6,0x04,0xfd,0x89,0x6f,0x4d,0x71,0x7d,0xdc,0x69,0x33,0x2e,0x23,
        0xc4,0xd6,0x71,0x16,0xf9,0x51,0xf2,0x01,0x2f,0x02,0x25,0xd6,0xa8,0xf3,0x7f,0x87,
        0x97,0x5b,0xe5,0xb4,0x32,0x68,0x65,0x86,0x09,0x3b,0x24,0xdb,0x96,0x35,0x97,0xa3,
        0x15,0x71,0xf6,0x89,0x96,0x91,0xee,0xd7,0x50,0xbe,0x97,0x93,0x38,0xea,0xa5,0xee,
        0xd2,0x58,0xe2,0xe0,0x47,0x5f,0xdc,0x0c,0xb9,0x6b,0xda,0xe9,0xd3,0x44,0x15,0x23,
        0xa4,0x93,0x25,0x3f,0xad,0xa2,0xba,0x7f,0x38,0x63,0x8c,0x05,0xec,0xb4,0x95,0x3a,
        0x9f,0xe1,0x7d,0x71,0x6b,0x6a,0x56,0xc8,0x04,0x07,0x89,0x4f,0x48,0xea,0x10,0x6d,
        0x18,0x44,0xe6,0x7f,0x67,0x0a,0xbc,0xc1,0x90,0xf9,0xee,0x72,0xed,0xd8,0xb5,0x33,
        0xa5,0xfd,0x9e,0xb1,0xc5,0x12,0x3b,0x83,0x93,0x19,0x18,0x56,0x1f,0xae,0xf0,0x47,
        0x1a,0x8c,0x21,0x90,0xeb,0x53,0x5e,0x67,0x00,0x89,0xa4,0x23,0x62,0xde,0x6f,0xa1,
        0x8d,0xb4,0x2d,0xe6,0x7e,0xde,0xf3,0x05,0x0d,0xa8,0x6f,0x43,0x7d,0x18,0x1e,0x7a,
        0x52,0x74,0xbe,0xbb,0x62,0x04,0x07,0x37,0x2f,0x19,0x96,0x60,0x74,0x4f,0x2a,0x4b,
        0xfe,0x0e,0x12,0x59,0xbd,0x57,0xe6,0x16,0x1b,0xbd,0x76,0x61,0x8c,0xb1,0x00,0xce,
        0x67,0x03,0xa6,0x48,0xf4,0xa6,0x1e,0xfb,0xc6,0xb4,0xac,0x71,0x4b,0xb1,0x4d,0xfa,
        0xa1,0x14,0x35,0x52,0xab,0x03,0x7c,0x7e,0x65,0x5f,0x15,0xf7,0x74,0x00,0xff,0x0a,
        0x02,0x42,0xbf,0x7f,0xc8,0xc0,0x0d,0x79,0x6c,0x5f,0xce,0x9d,0x0e,0x8f,0x42,0x76,
        0x1e,0xcd,0x7f,0x18,0x70,0x6c,0x1e,0x04,0x92,0x96,0x34,0x4c,0x5d,0x8e,0x84,0xf8,
        0xca,0x37,0xf2,0xa7,0x07,0xda,0x3b,0x7a,0xca,0x24,0xe4,0x2d,0xe6,0x6e,0x70,0x87,
        0x1c,0x42,0xd6,0xf5,0x33,0x1a,0x32,0x72,0x4a,0x6a,0xbb,0xa9,0x6e,0xe1,0xf5,0x5e,
        0x68,0xec,0x28,0x0a,0xd8,0x7d,0x10,0xc5,0x88,0x0a,0xd6,0x69,0xfa,0xd8,0x3f,0xf5,
        0x43,0x79,0x24,0x2f,0x1c,0x94,0x22,0x8e,0x37,0xe4,0x92,0x56,0xcf,0x83,0xbb,0x05,
        0x83,0x69,0x47,0xee,0x64,0x2f,0xf4,0x24,0x4d,0x19,0x8c,0x99,0x73,0x54,0x17,0x87,
        0x3c,0x7c,0x4f,0x0f,0x55,0x62,0x54,0x21,0xff,0x0b,0xa1,0x9b,0xa9,0xfc,0x3f,0xb5,
        0xc4,0xb4,0x38,0x9c,0xd3,0x7b,0x4f,0x5d,0xc1,0x5a,0xee,0x05,0x78,0x6b,0x60,0x06,
        0xaf,0x53,0x40,0xdd,0x03,0x0c,0x32,0xf2,0x4a,0xe8,0xd1,0xc0,0x24,0xd2,0xe8,0x35,
        0xd2,0xd7,0xe4,0x5c,0x4c,0xe6,0x89,0x39,0x8d,0xd4,0xe5,0xf5,0x32,0xa3,0x82,0x3b,
        0x43,0x04,0xe0,0xe1,0x51,0x1a,0x22,0xcb,0xc1,0x81,0x08,0x0c,0x67,0x8f,0x1d,0x4f,
        0x57,0xda,0x32,0x76,0xf7,0xfa,0x0a,0x80,0x59,0x90,0x57,0xb0,0xc8,0x87,0xe5,0xeb},
        {0},
        /*TST_Expected_output_data for enc Input data for decrypt*/
        {0xaa,0x96,0x62,0xd7,0x58,0x3c,0xfb,0x9e,0x2a,0xcd,0x57,0x0e,0xb8,0x4c,0x39,0x6c,
        0x71,0x8e,0xf9,0x0e,0xe8,0xca,0xea,0xbb,0x3e,0xe1,0x48,0xce,0x19,0x65,0x97,0x9e,
        0xf2,0xe8,0x23,0x3c,0x69,0xe0,0x58,0xf4,0x98,0xce,0x9d,0x4b,0x0f,0x2a,0x43,0xa5,
        0xef,0x52,0xa7,0xf6,0xf5,0x5e,0x4e,0x59,0x15,0xc7,0x9f,0xdd,0x81,0x75,0x09,0x52,
        0xb2,0x3d,0xac,0xd7,0x59,0x54,0xbf,0xf1,0xeb,0x47,0x41,0x84,0xeb,0x5d,0xaa,0x97,
        0x30,0x8a,0xc8,0x22,0x4a,0x2f,0x2c,0x1f,0xaa,0xdf,0xec,0x20,0xff,0xcf,0xbf,0x47,
        0x33,0xf8,0x23,0x0f,0xff,0x61,0x50,0x2b,0x64,0x4f,0x37,0x8d,0xfc,0x8c,0x24,0x86,
        0x99,0xf5,0x67,0xdd,0xe8,0x40,0x4b,0x85,0xe6,0x3d,0x25,0x40,0x0e,0x3c,0x1a,0xce,
        0x7a,0xab,0x1f,0x2d,0xe0,0x22,0x79,0x6f,0x3e,0x4b,0x16,0x9d,0xe3,0xb5,0x42,0x2a,
        0xcb,0xff,0xd6,0x79,0xec,0xdf,0x44,0xb5,0xbe,0x23,0xbb,0x63,0x2c,0x13,0x81,0xc1,
        0x3f,0xbf,0x6f,0xa9,0xcf,0x9d,0x77,0x3a,0x33,0x62,0xde,0x85,0x64,0x62,0x6e,0x51,
        0xff,0xcb,0xc3,0xbe,0xba,0xed,0xc6,0x73,0xdf,0x5b,0x4f,0xf0,0xac,0x58,0x0b,0x2d,
        0xde,0x14,0xdf,0x00,0x8d,0x16,0x71,0xec,0x1d,0x93,0x1c,0x1d,0x92,0x8d,0xd8,0x6c,
        0xc7,0x9c,0x5a,0x06,0x6a,0x8b,0x2e,0x24,0x6c,0x66,0xa1,0x3d,0xbd,0x5f,0x2a,0x56,
        0x77,0x9f,0x58,0x96,0xef,0x34,0x7b,0xfd,0x45,0xa9,0xc0,0x24,0x24,0x09,0x25,0x23,
        0x91,0x58,0x8f,0xd2,0xef,0x3c,0x00,0x5b,0x52,0x3e,0x08,0xa9,0xb6,0xdd,0x0f,0xe8,
        0x9f,0xc7,0x4c,0xb1,0x07,0x1f,0xeb,0xa1,0x5e,0x59,0xa4,0x48,0x77,0x76,0xe5,0xfc,
        0x29,0x9f,0x5a,0xa6,0x36,0xf6,0x49,0x90,0xb7,0xbf,0xb0,0x76,0xe3,0xec,0x62,0xe4,
        0xb9,0x5f,0xb5,0xe7,0x51,0x94,0x8f,0xd3,0xa4,0x97,0xd7,0x89,0x32,0xe2,0x60,0xf9,
        0x9e,0xc3,0x1c,0xca,0x85,0x50,0x92,0xc2,0x50,0xb6,0x3f,0x63,0x9d,0x85,0xd4,0x26,
        0xb9,0x4d,0xd9,0x79,0x2a,0x8c,0xb2,0x37,0x51,0xd6,0xf1,0xc1,0xab,0xbe,0x46,0x3c,
        0x07,0x80,0x98,0x0c,0x5a,0x3e,0xcd,0x38,0xe8,0xe5,0x05,0x76,0x14,0xba,0x5c,0x9c,
        0x1f,0xf0,0xb9,0x12,0xc8,0x1a,0x9e,0x98,0x3e,0x52,0xea,0xb3,0x5d,0x94,0xf6,0x69,
        0x8b,0x78,0x1c,0x47,0x51,0x5e,0x45,0x31,0xa9,0xe6,0xcc,0xf7,0x01,0xe6,0x53,0xaa,
        0x42,0x46,0x98,0x7c,0xca,0xde,0x76,0x12,0xb7,0x1c,0xc2,0x6b,0xbf,0xfa,0x51,0x0f,
        0x25,0x24,0x7a,0x70,0x93,0x4a,0x36,0x2f,0xa0,0x1f,0x6e,0xb7,0xbd,0x36,0x80,0x02,
        0xb8,0xb7,0x0c,0xcb,0x17,0x95,0xfb,0x22,0x31,0x69,0x2c,0xd4,0x77,0x59,0xdc,0xa0,
        0x8d,0xff,0x2c,0xc4,0x79,0xe4,0x47,0xba,0xbe,0x38,0x5e,0x0c,0x4f,0xb0,0xdb,0x54,
        0x29,0xa4,0x95,0xde,0xe0,0xa2,0xea,0x12,0x41,0x82,0x31,0x36,0x68,0x2b,0x43,0xc9,
        0x29,0xe0,0x07,0xb9,0x15,0x42,0xea,0xca,0x0d,0xd3,0x79,0x87,0x51,0x77,0x86,0xef,
        0xd8,0xab,0x46,0xd7,0x2e,0x09,0x11,0x59,0xf7,0x0b,0x51,0x98,0x11,0x44,0x0b,0x93,
        0x09,0xf7,0x15,0xc6,0x34,0xb0,0x62,0x39,0x55,0xc4,0x6d,0xab,0x4e,0x59,0x9e,0x4f,
        0x8c,0xfb,0xa4,0x97,0x48,0x48,0xca,0x52,0xab,0x7c,0x47,0xc0,0xe2,0x08,0xb4,0xab,
        0x35,0xf8,0x7b,0x5e,0x38,0xc8,0x77,0xb5,0x16,0xca,0x40,0xdb,0x39,0x5f,0x3a,0xf4,
        0x2f,0x2e,0x4d,0x62,0x31,0x99,0xb4,0x6a,0xd1,0x3c,0x4f,0x4d,0x4a,0x17,0x41,0x38,
        0x7a,0x3e,0xb5,0xac,0xe6,0xd5,0x8b,0x9a,0xb2,0xaf,0x78,0x4b,0x73,0x0f,0x62,0xa4,
        0x91,0x8f,0x10,0xdb,0x58,0x59,0x70,0x1c,0x71,0x0d,0xf7,0x28,0x76,0xc6,0x07,0xe0,
        0x48,0xd5,0x94,0x51,0xc8,0x36,0x02,0x30,0xf7,0x06,0x80,0x54,0x56,0x2e,0xea,0x4d,
        0xb0,0xc6,0x05,0xe7,0x94,0x1f,0xd6,0x9c,0x3f,0xf3,0x26,0xe7,0xd9,0x3b,0xfc,0x12,
        0xae,0x3b,0x1a,0xd9,0x96,0x37,0x5c,0xa5,0x78,0xbd,0x74,0xa0,0x83,0x91,0xa2,0xfe,
        0xe3,0x19,0x7d,0x2a,0x9e,0x8c,0xc1,0x47,0xd5,0x1e,0x90,0x33,0x95,0x28,0xc1,0x67,
        0x9e,0xff,0xaf,0x37,0xc9,0xaf,0xec,0xd7,0x69,0x61,0x22,0xca,0x49,0x4e,0x56,0xe4,
        0xa0,0xd0,0x56,0xac,0xf7,0x58,0x03,0x72,0x68,0xda,0x1f,0xdf,0x97,0x9c,0x3a,0x15,
        0x27,0xe7,0x8d,0x0b,0xd7,0x2f,0x57,0xa3,0x41,0xe9,0xf3,0xf8,0x92,0xdb,0x15,0x7f,
        0x33,0x35,0xd5,0x9c,0x41,0xc6,0xab,0x5f,0xcc,0x40,0x66,0x77,0x00,0xc9,0xb6,0xd3,
        0xf9,0x50,0x22,0xce,0x6c,0x82,0x23,0x39,0x8c,0xdb,0xf6,0xe4,0xff,0x61,0x13,0x25,
        0x28,0xb6,0xc2,0x91,0xcd,0x4c,0x58,0xda,0x3a,0x2e,0x78,0xbe,0xb6,0x7d,0x04,0xff,
        0xfa,0x73,0xcd,0x61,0x4f,0x89,0x31,0xf3,0x2f,0x98,0x96,0xa1,0x52,0xc2,0x51,0x92,
        0x2c,0x47,0xa6,0x3f,0x17,0xdb,0x95,0x63,0x5f,0xe0,0xc3,0x06,0x87,0x33,0xb6,0x54,
        0x87,0xfe,0xc3,0x7e,0xe3,0x0d,0xde,0x6a,0x70,0x86,0xd8,0x1a,0xb8,0x47,0x3c,0x83,
        0xf3,0xeb,0xe5,0xa3,0x9c,0x22,0x3e,0xd2,0x86,0x80,0x5f,0x5d,0xa7,0x74,0x95,0x00,
        0x46,0x18,0xa0,0x20,0xf5,0x34,0x63,0x3a,0x32,0x5a,0x35,0x6a,0xac,0xe2,0x69,0x02,
        0xb0,0xbd,0x97,0x5a,0x6c,0xd2,0x55,0x9b,0xb9,0x42,0x3a,0xaa,0xa6,0xc4,0xdd,0x13,
        0x32,0x00,0xf3,0xb6,0x18,0x56,0xd5,0x2e,0xcd,0x37,0x33,0x6f,0x62,0x85,0x2b,0xe5,
        0xc7,0x17,0x0a,0xbd,0x2e,0xb4,0x7b,0x3d,0xbf,0xf1,0xa6,0xaf,0x1c,0x1b,0x41,0xbc,
        0x6e,0xcd,0x76,0x42,0xa4,0xe1,0xf8,0xf0,0x02,0xac,0x13,0x85,0xeb,0x3d,0xeb,0x20,
        0x4b,0xb4,0xaa,0x7c,0xd2,0x7a,0x0f,0x1d,0x11,0x73,0x18,0x2f,0xa3,0x9d,0x0a,0xf4,
        0x23,0xe2,0x8a,0xa3,0xab,0xaf,0x33,0x3c,0x09,0x46,0xa6,0x08,0x9f,0x41,0x66,0x8d,
        0x6f,0x03,0x5a,0xc2,0x4d,0xad,0x17,0x05,0xf9,0xb1,0xa1,0x99,0xbc,0xd4,0xf7,0x39,
        0xcb,0x48,0x00,0xe1,0x68,0x51,0xa2,0x5d,0x40,0xfc,0x80,0x08,0xf6,0x1a,0xd0,0xaf,
        0xa1,0x3e,0xe8,0xdd,0x77,0xe3,0x78,0x41,0x3c,0x7f,0x14,0xbe,0xb4,0xe8,0x86,0xa7,
        0x2c,0xdb,0xa9,0x92,0x21,0xc3,0xbf,0xc6,0xf3,0x55,0xb2,0x14,0x85,0x5c,0x0b,0x50,
        0x9e,0xb2,0xa9,0xba,0xee,0xcd,0x15,0x7a,0x5f,0xbe,0xa0,0xce,0x2b,0xe9,0x27,0x96,
        0xa2,0xe1,0x4e,0x87,0xe8,0x7d,0x6a,0x66,0x46,0xc6,0x8c,0x8f,0xbf,0x4d,0x8d,0xee,
        0x0a,0x62,0x99,0xb7,0x07,0x91,0x2b,0xfd,0xe6,0x0c,0x0a,0x4a,0x2a,0x6c,0x2d,0x2e,
        0x21,0xd5,0x3e,0xc4,0x92,0x2e,0xb7,0x06,0xfb,0x44,0x66,0xde,0xf7,0x2b,0x46,0x54,
        0x43,0xd8,0xaa,0x99,0x49,0xce,0xf9,0x67,0x55,0x8d,0xaf,0x59,0x58,0xc9,0x8e,0x92,
        0x24,0x03,0xdb,0xf2,0xe6,0x70,0xc6,0xff,0xce,0xf9,0x32,0x5f,0x42,0xbe,0x2f,0x0d,
        0x7e,0x0d,0xec,0x53,0x6b,0xf7,0x74,0x67,0x35,0x62,0x15,0xa8,0x95,0xba,0xa9,0xc7,
        0x21,0x19,0xda,0x25,0x67,0xa6,0xd6,0x79,0x54,0xf2,0x92,0x40,0xd5,0x1a,0x18,0xf5,
        0x2b,0xd8,0x31,0xe4,0xf3,0x76,0xcc,0x95,0xec,0x63,0xed,0x3f,0xf6,0x70,0x5b,0xd8,
        0xc5,0xe7,0x3d,0x6e,0xd0,0xd8,0x99,0x70,0x80,0x65,0xa7,0xc9,0x8f,0x4b,0x4a,0x81,
        0x56,0x13,0x49,0xae,0xca,0x89,0x39,0x92,0x0e,0x8d,0x5e,0x32,0x61,0xaa,0x6d,0x45,
        0x08,0xad,0x2a,0x77,0xc9,0x5e,0x43,0x1a,0xae,0x71,0x5c,0x7f,0xd7,0x1d,0x8b,0xf6,
        0xf4,0xe5,0x25,0x19,0xf7,0x45,0x64,0x87,0x45,0x96,0x5e,0x4d,0x4a,0x13,0x93,0x4d,
        0x58,0xe4,0xcb,0xff,0x38,0xe4,0x85,0xf8,0xe5,0xa7,0x02,0xb1,0x5d,0x87,0xea,0x88,
        0x18,0xdd,0x98,0x04,0x57,0x63,0x51,0xfd,0x3b,0xc1,0x2e,0xa1,0xef,0x18,0x14,0x76,
        0xcb,0x3f,0x79,0x7e,0x2c,0x50,0x7a,0x8b,0xfa,0xce,0x14,0x89,0x85,0xdf,0x7b,0xf8,
        0xe1,0x97,0x97,0x82,0xb6,0xb3,0xdc,0xbb,0xe0,0x9e,0xdb,0x85,0x29,0xb4,0x5b,0xe9,
        0x77,0xce,0x45,0x33,0x6c,0x67,0x52,0xe9,0xe0,0x7d,0xfc,0xbe,0x10,0xb6,0x4d,0xb4,
        0x19,0x97,0x3c,0xd0,0xe8,0xdc,0x29,0xbb,0x26,0x3b,0x12,0x92,0xa6,0x92,0x30,0x03,
        0x24,0xce,0xff,0xb1,0x5d,0x34,0x63,0x6a,0x31,0xf9,0x0f,0xd6,0x23,0x66,0x3d,0xf6,
        0x89,0x65,0x16,0x65,0xec,0x3d,0x8b,0x79,0xe3,0x33,0x24,0xbb,0x6f,0xf0,0x7c,0x91,
        0xe3,0xe3,0x1a,0xe3,0xe6,0x24,0xbf,0xa9,0x93,0x02,0x84,0x3e,0x7c,0x2e,0x59,0x62,
        0x70,0xe7,0x32,0x07,0x5a,0xed,0xc2,0xc3,0x40,0xa7,0x13,0x21,0xae,0x46,0xce,0x3b,
        0xe1,0xf2,0x04,0x0a,0x67,0x59,0x45,0xff,0x60,0xc8,0x66,0x26,0xf3,0xf3,0xaf,0x0e,
        0x48,0x80,0x0c,0x90,0x97,0xf5,0xf8,0x1f,0xc9,0xd8,0x42,0x2b,0xb7,0xb4,0x52,0x85,
        0x35,0x10,0xd9,0x30,0x3d,0x1f,0xf2,0xa3,0x48,0xd8,0x61,0x7a,0x81,0xe1,0x0f,0xa3,
        0x9d,0x31,0xd7,0x18,0xa1,0x6d,0x3d,0xa6,0x00,0xdb,0x92,0x6c,0xce,0xff,0x4f,0x4a,
        0x66,0xf9,0x02,0x24,0x09,0xb4,0x81,0x2b,0x0f,0x67,0x83,0x73,0x23,0x56,0xbf,0x92,
        0x9a,0xaa,0xe0,0x8a,0x0c,0xb6,0x53,0xd5,0xdf,0x95,0xc6,0x00,0xeb,0x8e,0x6f,0x13,
        0xc6,0x40,0x31,0x96,0x46,0x9b,0x51,0x83,0x22,0xbb,0x96,0xdb,0xf4,0xd9,0xc5,0xa0,
        0xd5,0xfc,0x3a,0xa7,0x48,0x89,0x25,0x22,0x28,0x9e,0x97,0x3d,0xd8,0x2e,0x5c,0xa1,
        0x9e,0xe7,0x31,0xaf,0x72,0xc5,0xe8,0x9d,0x45,0x20,0x4b,0x72,0xd2,0xd5,0x66,0xc3,
        0x0e,0x6e,0x83,0x46,0x79,0xe9,0xe7,0x82,0xc0,0xcd,0xdb,0x61,0x8d,0x19,0x5d,0xa5,
        0x93,0x1b,0x50,0x9d,0xe1,0x77,0x8d,0x6f,0x9a,0x9f,0x53,0x24,0xc8,0xba,0xb9,0x42}, 
        /*TST_dataSize*/
        1536*sizeof(DxUint8_t),       
        CRYS_AES_CBC_mode
    },
    #endif
    #endif
    #if TST_USE_AES_256_KEY
    #if TST_USE_AES_16BYTE_DATA
    { 
        {"Acceptance test - AES/CBC/256Key/16ByteData "},
        /*TST_Key*/     
        {0x60,0x3d,0xeb,0x10,0x15,0xca,0x71,0xbe,0x2b,0x73,0xae,0xf0,0x85,0x7d,0x77,0x81,
         0x1f,0x35,0x2c,0x07,0x3b,0x61,0x08,0xd7,0x2d,0x98,0x10,0xa3,0x09,0x14,0xdf,0xf4},
        CRYS_AES_Key256BitSize,
        /*TST_IvCounter*/
        {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f},
        /*TST_input_data*/
        {0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a},
        {0},
        /*TST_Expected_output_data for enc Input data for decrypt*/
        {0xf5,0x8c,0x4c,0x04,0xd6,0xe5,0xf1,0xba,0x77,0x9e,0xab,0xfb,0x5f,0x7b,0xfb,0xd6}, 
        /*TST_dataSize*/
        16*sizeof(DxUint8_t),     
        CRYS_AES_CBC_mode
    },
    #endif
    #if TST_USE_AES_32BYTE_DATA
    { 
        {"Acceptance test - AES/CBC/256Key/32ByteData "},
        /*TST_Key*/     
        {0x60,0x3d,0xeb,0x10,0x15,0xca,0x71,0xbe,0x2b,0x73,0xae,0xf0,0x85,0x7d,0x77,0x81,
         0x1f,0x35,0x2c,0x07,0x3b,0x61,0x08,0xd7,0x2d,0x98,0x10,0xa3,0x09,0x14,0xdf,0xf4},
        CRYS_AES_Key256BitSize,
        /*TST_IvCounter*/
        {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f}, 
        /*TST_input_data*/
        {0x39,0xf2,0x33,0x69,0xa9,0xd9,0xba,0xcf,0xa5,0x30,0xe2,0x63,0x04,0x23,0x14,0x61,
         0xb2,0xeb,0x05,0xe2,0xc3,0x9b,0xe9,0xfc,0xda,0x6c,0x19,0x07,0x8c,0x6a,0x9d,0x1b},
        {0},
        /*TST_Expected_output_data for enc Input data for decrypt*/
        {0x3f,0x81,0xc4,0x41,0xd4,0x7f,0x75,0x0c,0x13,0xce,0x84,0x38,0xcf,0x7b,0xcb,0x12,
         0x95,0x63,0x15,0x97,0xf1,0xf5,0xc0,0xe8,0x72,0x21,0x82,0x82,0x23,0x44,0x76,0x9c}, 
        /*TST_dataSize*/
        32*sizeof(DxUint8_t),       
        CRYS_AES_CBC_mode
    },
    #endif
    #if TST_USE_AES_512BYTE_DATA
    { 
        {"Acceptance test - AES/CBC/256Key/512ByteData "},
        /*TST_Key*/     
        {0x60,0x3d,0xeb,0x10,0x15,0xca,0x71,0xbe,0x2b,0x73,0xae,0xf0,0x85,0x7d,0x77,0x81,
         0x1f,0x35,0x2c,0x07,0x3b,0x61,0x08,0xd7,0x2d,0x98,0x10,0xa3,0x09,0x14,0xdf,0xf4},
        CRYS_AES_Key256BitSize,
        /*TST_IvCounter*/
        {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f}, 
        /*TST_input_data*/
        {0xa8,0x42,0xb3,0x48,0x82,0xff,0xf0,0x2e,0xdd,0x17,0x03,0xad,0x9e,0xea,0xcf,0xb8,
         0x2a,0x71,0xf1,0x0d,0x78,0x56,0x0d,0x63,0x7a,0x53,0x40,0xbd,0xa4,0xde,0x46,0x3c,
         0x2a,0xc5,0x9a,0x97,0x52,0x9e,0x01,0x74,0x2a,0xa2,0x4e,0xed,0x36,0x2f,0x6b,0xa5,
         0x5b,0x64,0x6a,0x30,0x62,0xee,0x06,0x2b,0x85,0x36,0xeb,0xb8,0x9e,0xad,0xbe,0x4e,
         0xd0,0x6c,0xaf,0x03,0xcf,0xb6,0xb6,0x1d,0xfa,0x22,0x81,0x79,0x29,0x5e,0x7d,0xa8,
         0x09,0x62,0x85,0xb3,0x15,0x71,0xb3,0x9a,0xcd,0x2e,0xf7,0x95,0x65,0x72,0x3a,0x5c,
         0xf3,0x34,0x5b,0xc5,0x6d,0x73,0x91,0x19,0x54,0x63,0x64,0x92,0xfb,0x8a,0x1b,0xef,
         0x83,0xdb,0xfd,0x69,0x2e,0x36,0x5f,0x5f,0x51,0x6f,0x4e,0xdc,0xd8,0xbd,0x8c,0x1d,
         0xda,0xa3,0xa2,0x61,0x34,0xad,0xf4,0x5e,0x58,0x84,0x41,0x92,0x2b,0x24,0xb0,0x28,
         0x55,0xf0,0xbd,0xb6,0x05,0x63,0x6c,0xab,0x72,0x3a,0xec,0x8a,0x0d,0xd9,0xe1,0xbd,
         0x9e,0x34,0x3d,0x14,0x3f,0xed,0x43,0x86,0xdc,0xac,0x76,0x07,0xb2,0xad,0x65,0x7b,
         0xa4,0x4f,0xf9,0xcc,0x29,0xd6,0xff,0x1a,0x97,0x7d,0x80,0x5c,0xc3,0x40,0xae,0x0e,
         0xdc,0x8f,0x32,0x34,0xbd,0x20,0x79,0x6a,0xf0,0x67,0xf5,0x43,0x44,0x8a,0xbc,0x12,
         0xe3,0xc9,0x7c,0x3d,0x75,0x2d,0x17,0xbd,0x16,0xdc,0xe7,0x65,0x13,0x75,0xec,0x2c,
         0x32,0x68,0xbf,0x30,0x7a,0xd5,0x84,0x74,0xb4,0xc2,0xa8,0x73,0xf8,0x63,0x6e,0xaf,
         0x23,0xfd,0xae,0x1a,0x44,0xab,0xd6,0xd8,0xb8,0xbd,0xea,0x93,0xf1,0xc9,0x53,0x77,
         0x1b,0x18,0x0a,0x78,0x7d,0xa7,0xaa,0xcc,0x51,0x0b,0x98,0xab,0x07,0x70,0xf6,0x1b,
         0xc8,0xb1,0xea,0x47,0xe9,0xfd,0xa9,0x50,0x40,0x6d,0x51,0x7a,0x78,0x26,0xd6,0x96,
         0x6f,0xa8,0xbc,0x18,0xeb,0xd3,0xc7,0x96,0x26,0x1b,0x56,0xac,0x39,0xd2,0x6e,0xfa,
         0x04,0x7a,0x69,0xe2,0xfa,0xbb,0x2b,0x41,0x2c,0xc5,0x48,0x35,0xc5,0x4f,0x62,0xda,
         0x9c,0x13,0x34,0x27,0x5f,0xf6,0x22,0xe3,0x36,0xd9,0x01,0x92,0x3a,0x08,0x1e,0x21,
         0xc5,0xc9,0x18,0x90,0x5a,0xbe,0xa1,0x56,0x26,0xfe,0x0e,0x1d,0xff,0x64,0xe2,0x62,
         0xff,0x42,0x8a,0x18,0x83,0x64,0x5d,0x93,0xff,0x93,0xb5,0xa9,0x39,0x59,0xe6,0xdf,
         0xad,0x92,0xe9,0xfe,0x5a,0xd3,0xa4,0x8d,0xdb,0xb6,0x19,0xb3,0xd4,0x2e,0xc9,0x75,
         0xee,0x38,0x4e,0xdc,0x73,0x6d,0x4d,0x00,0x9c,0x0e,0x63,0xc1,0xf6,0x56,0xcd,0x3f,
         0xb7,0xc5,0xbb,0x65,0xf4,0x3e,0x72,0xe4,0x40,0x98,0x2c,0x92,0xf4,0x22,0x4b,0x29,
         0xd0,0x5d,0x7d,0x53,0x05,0xf0,0xf7,0xe7,0xfc,0xc7,0x47,0x5b,0x4d,0x6b,0x71,0x1d,
         0x86,0x63,0x45,0x48,0xfc,0xef,0x40,0xcd,0x29,0xac,0x77,0xe0,0x17,0xf8,0xe8,0x30,
         0x6a,0x8a,0x68,0x71,0x77,0xa2,0xd9,0x21,0x92,0xc1,0x8a,0x2b,0x26,0x4d,0xd2,0x89,
         0xc8,0xf8,0xb5,0x94,0x89,0x49,0x7d,0x43,0xc3,0x50,0xa6,0x92,0xf3,0x3b,0x7a,0xca,
         0x60,0xaa,0x4f,0xa7,0x8d,0x7e,0xd1,0x50,0x92,0xc5,0x0c,0x2a,0x14,0xcc,0x4d,0x3c,
         0xb7,0xb0,0x4b,0x72,0xd3,0xab,0xfa,0x8a,0xea,0xa8,0x9c,0xd6,0x39,0xfe,0xba,0x41},
        {0},
        /*TST_Expected_output_data for enc Input data for decrypt*/
        {0xb5,0xab,0xe5,0x67,0x7a,0xde,0xa7,0xb3,0xd9,0x65,0x58,0xf3,0x46,0x95,0x46,0x86,
         0x6a,0x5f,0xfe,0x00,0xd8,0x52,0xd6,0x7e,0xb0,0x80,0x8c,0xd7,0x5a,0x3a,0x11,0x01,
         0x8f,0x4d,0xd5,0x2f,0xc7,0x36,0xad,0x78,0x66,0x7e,0x9e,0xbc,0xb5,0x8d,0xd0,0xd7,
         0x7f,0x6e,0x27,0xbf,0xea,0x15,0xa7,0x7c,0x77,0xc2,0xbe,0x43,0xe3,0xd8,0x37,0x86,
         0xc2,0x46,0xf8,0x12,0x76,0x03,0xea,0xd9,0xf5,0x97,0xa3,0x2f,0xf2,0x9c,0x7d,0x50,
         0x6e,0x51,0xfe,0x84,0x0f,0xd1,0x96,0x90,0x3b,0x8c,0xfe,0x97,0x5b,0x38,0xc1,0xbf,
         0x0f,0x2d,0xa3,0xa8,0xc2,0x14,0xca,0xc0,0x6f,0x58,0x2c,0xc2,0x42,0xa2,0x3b,0xab,
         0x76,0x6f,0x08,0x75,0x15,0x8e,0x55,0x88,0x94,0xd4,0x27,0x4e,0x02,0xc6,0x10,0x4c,
         0x69,0xfd,0x36,0x0a,0x2e,0x8e,0x4e,0x78,0x00,0x2f,0x12,0x61,0x27,0x57,0x44,0x04,
         0x84,0xc2,0x57,0xad,0x5a,0x71,0x0c,0xd5,0x32,0x8e,0xef,0x6b,0x99,0x47,0xa6,0x83,
         0x31,0x6e,0xc9,0xee,0x91,0x8c,0x42,0xa1,0x4d,0x01,0x0a,0x4b,0x1a,0xc2,0x70,0xb2,
         0x7e,0x3f,0x85,0xe6,0x7c,0x7a,0xcb,0x3c,0x8c,0xa3,0xcd,0x68,0x79,0xa8,0xe2,0xfe,
         0x7c,0xf6,0x7c,0xf0,0xe8,0xb9,0x56,0xc6,0x06,0x3b,0xe7,0x65,0x00,0x2b,0xc5,0xf3,
         0xc2,0xbc,0xe0,0x7b,0x24,0x8c,0xa2,0x7c,0x7a,0x5e,0xaf,0x90,0xb4,0x5f,0x27,0x6c,
         0x93,0xe5,0xda,0xfb,0xfb,0x51,0xc4,0x0f,0x23,0xa8,0xed,0xd0,0x15,0x3c,0x08,0xee,
         0x56,0xbd,0xab,0xb4,0xae,0x48,0xaa,0x86,0xc4,0x50,0x35,0xc3,0x45,0x5b,0xf7,0x1c,
         0xbb,0x46,0x02,0x58,0x02,0x12,0xcf,0x28,0x85,0x0b,0xcf,0x01,0x62,0x87,0x02,0x73,
         0x8d,0x6a,0xe2,0x98,0xea,0xc7,0x16,0x99,0xf6,0x5e,0xf7,0xe0,0xa9,0x6e,0x33,0x9b,
         0x2a,0x93,0x74,0x8c,0xfa,0x86,0xbb,0xac,0x83,0x4e,0x0a,0x1f,0x9d,0xec,0x0e,0x95,
         0xec,0x37,0x76,0x23,0x35,0x55,0x78,0xa3,0x90,0xf7,0x00,0x92,0x78,0x7c,0xbf,0x1b,
         0xd2,0x02,0xf6,0x85,0x04,0xee,0xda,0x19,0x1a,0x91,0x5c,0xd9,0xdd,0x9a,0x53,0xb3,
         0x7a,0x5b,0x4d,0x53,0x14,0xe0,0xb5,0x14,0x29,0xbb,0xc6,0x5c,0xad,0xdd,0x71,0x66,
         0x11,0x9f,0xdc,0x56,0x0d,0x47,0xcf,0x89,0xc8,0x65,0xeb,0x03,0xcb,0x08,0x1f,0x3f,
         0x9d,0xa7,0x81,0xc3,0x19,0x7c,0x70,0x91,0xda,0xf4,0xda,0x02,0xb4,0x63,0x65,0x4b,
         0xf4,0x5d,0x4d,0x59,0x19,0x9d,0x54,0xd3,0x67,0xa0,0xcc,0x81,0x56,0x9a,0x29,0x5f,
         0xbc,0x56,0x98,0xea,0x27,0x78,0x9e,0x1a,0xe7,0x17,0xc0,0x6d,0x53,0x68,0xea,0xad,
         0x40,0x84,0xac,0x12,0xdd,0xc4,0x6f,0x6f,0xb4,0x6f,0xa3,0xc8,0xb8,0x0e,0x5e,0x95,
         0xa2,0xbc,0x00,0xd6,0x81,0x2f,0x1b,0x96,0xf3,0xb5,0xc3,0x54,0x61,0x0b,0x91,0xf0,
         0x06,0x28,0x71,0x88,0x1c,0xf7,0x98,0xc2,0x84,0xa9,0x41,0xca,0xc8,0x11,0x34,0x70,
         0xb6,0x0b,0x44,0x78,0x90,0x01,0x55,0x80,0xc2,0x50,0x51,0x29,0x34,0xd8,0x2d,0x02,
         0xb4,0x56,0xc7,0xc1,0xac,0x23,0x94,0x96,0xe6,0x53,0xae,0x86,0xaf,0x4f,0x58,0xb3,
         0xd7,0x96,0xd3,0xec,0x44,0x1d,0x40,0xfc,0xd2,0xa7,0x96,0xbd,0x1a,0x54,0x5b,0xb7}, 
        /*TST_dataSize*/
        512*sizeof(DxUint8_t),      
        CRYS_AES_CBC_mode
    }, 
    #endif
    #if TST_USE_AES_1536BYTE_DATA
    { 
        {"Acceptance test - AES/CBC/256Key/1536ByteData "},
        /*TST_Key*/     
        {0xd3,0xd3,0xc4,0xd0,0x01,0x9d,0xb1,0x70,0x2c,0x3b,0xb8,0xf8,0x02,0xb8,0x8b,0xde,
        0x6b,0x65,0x06,0x25,0xb4,0x72,0x6c,0x8d,0xec,0xbc,0xf4,0x07,0x8e,0xe6,0x84,0x6b},
        CRYS_AES_Key256BitSize,
        /*TST_IvCounter*/
        {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f}, 
        /*TST_input_data*/
        {0x96,0xb6,0x4e,0x88,0x05,0x81,0xe6,0x1c,0x7a,0xd4,0x18,0x43,0x11,0x28,0x0f,0xcb,
        0x72,0x59,0xc0,0x24,0x5e,0xf2,0x20,0xc2,0x87,0xab,0x95,0xc3,0xa5,0x30,0xab,0xd2,
        0xc6,0x24,0x09,0x4b,0xe5,0x66,0xa3,0x9f,0xbf,0x93,0x31,0xfb,0xe2,0xcc,0xdf,0x24,
        0x07,0xb9,0x46,0xa6,0xa1,0xcd,0x9b,0x2d,0xb6,0xcc,0x26,0x33,0xee,0x8b,0xf6,0xdb,
        0xea,0xf8,0xd4,0x1d,0xd6,0x59,0x75,0x24,0x42,0xd9,0xf4,0xf4,0x2d,0x40,0x7f,0x50,
        0x63,0x02,0x50,0xdb,0x0a,0x7b,0xde,0x7d,0x77,0x79,0x55,0x08,0x46,0xfb,0x44,0x1c,
        0xa9,0x38,0x96,0x48,0x00,0xe3,0xc4,0x71,0xaa,0xae,0x49,0x78,0x1b,0x0d,0x55,0x17,
        0x2f,0x3c,0xc5,0x0c,0xbe,0x83,0x53,0x7a,0x71,0xb9,0x0a,0x8c,0xd4,0x07,0xfe,0x5b,
        0xac,0xee,0x39,0x12,0x8a,0x8b,0xf8,0x50,0xa0,0x1a,0x18,0xcd,0xd4,0xba,0xcb,0x41,
        0x13,0x6f,0x8f,0x81,0xe8,0x6d,0x61,0xeb,0x4d,0x94,0x2d,0x05,0xc1,0x37,0x8a,0x61,
        0x9a,0x21,0xa4,0xc4,0x9d,0xda,0x79,0x86,0xcc,0x26,0x49,0x3c,0x7f,0xcf,0x47,0x95,
        0xb6,0xa4,0x95,0x82,0xae,0xc2,0x6f,0x9a,0xb2,0x12,0xa7,0xbc,0x34,0x13,0x51,0xf6,
        0x1c,0xda,0xbf,0xa5,0x60,0x57,0xb0,0xde,0xd5,0xd9,0xc4,0x0d,0x45,0xd4,0x33,0xdc,
        0xc1,0xe3,0xbf,0x57,0x38,0x09,0xe7,0x4d,0x49,0x3c,0x5e,0xf9,0x56,0x24,0xbb,0xe1,
        0xda,0x20,0x72,0xff,0xfc,0x8a,0x03,0x1f,0x64,0x3c,0x71,0x88,0x4d,0x52,0xf6,0xde,
        0xdb,0x32,0xf5,0x47,0xaf,0xca,0x30,0xcd,0xba,0x19,0x3b,0x04,0x4e,0xf1,0x31,0xec,
        0x7b,0xfb,0xa5,0x18,0x98,0xfb,0xdb,0x10,0x20,0x55,0x38,0xf5,0xc0,0xd1,0xf8,0x63,
        0xad,0x9b,0x1f,0x9b,0x3b,0x8e,0xb2,0xe2,0xac,0xb1,0x26,0x24,0x45,0x02,0x19,0xdd,
        0xa8,0x73,0x40,0x3a,0x5d,0x33,0xa1,0x7b,0xb2,0x2e,0x02,0x9b,0xc5,0xd7,0xa1,0x33,
        0xdf,0x25,0x25,0x9c,0x03,0xdb,0xd5,0x53,0xc7,0x0d,0x08,0xa2,0x63,0xe0,0xdc,0x7d,
        0x08,0x91,0x2b,0xab,0x73,0xb9,0xbb,0x26,0xc1,0xcf,0xb5,0xc3,0x85,0xee,0x59,0x15,
        0x18,0xd8,0xef,0x8f,0x30,0x3c,0x01,0xea,0xb4,0x34,0xc7,0xc6,0xcf,0x12,0xe3,0x94,
        0x44,0x5c,0x4f,0xb3,0x01,0x15,0x93,0xd9,0xf6,0x3e,0x3b,0xb5,0x27,0x9d,0x88,0xd3,
        0x00,0xbd,0x66,0xbf,0xe9,0x36,0x9e,0x6d,0x1b,0x2e,0x4d,0xd8,0xb2,0x20,0x95,0xea,
        0x03,0xdd,0x92,0x9c,0x2f,0xd0,0x8f,0x5e,0xf9,0x85,0x7a,0xb9,0xd4,0x6d,0x96,0x33,
        0x40,0xdb,0x70,0x73,0x57,0x53,0x14,0xa5,0xa3,0x04,0x80,0x20,0x33,0x93,0x59,0x46,
        0xee,0x1a,0xdd,0xac,0x27,0x71,0x19,0x7c,0x71,0xac,0x5c,0x17,0xb4,0xe4,0xeb,0xfe,
        0x80,0x3b,0xf6,0xf2,0xa2,0x1a,0xcb,0x5a,0xf5,0xbd,0x4a,0xe6,0x7b,0xf2,0x99,0x72,
        0xac,0x1d,0x19,0x2d,0x0e,0x80,0x98,0xfa,0x06,0xb9,0xc8,0x16,0xee,0x8c,0xef,0xfb,
        0x67,0xe3,0xe1,0x85,0xf1,0x13,0x2c,0x54,0xb9,0x61,0x92,0x71,0xb1,0xc5,0xbc,0x34,
        0xe6,0xee,0x2c,0x65,0x0f,0x85,0x74,0xa1,0x61,0xb6,0xa5,0xff,0xab,0xed,0x0b,0xf4,
        0x9e,0xdd,0x17,0x74,0x6c,0xc7,0x9d,0x5a,0x96,0xf9,0x40,0x0a,0xfe,0x95,0x2a,0x55,
        0x44,0x93,0x00,0x9d,0x4f,0x09,0x14,0x39,0x2a,0xaa,0xdd,0x1a,0x12,0x8d,0xa5,0xaf,
        0xcd,0x31,0x82,0x07,0x3d,0xbd,0x87,0x36,0x34,0x8c,0x3b,0xf9,0x8a,0xe8,0x4a,0x9d,
        0x6d,0x16,0x7b,0x1c,0xf9,0x94,0xe2,0x8a,0x08,0x9e,0x57,0xaf,0x4c,0xf6,0x27,0xf6,
        0x9b,0xe5,0x09,0x86,0x89,0x7d,0x53,0xae,0x3c,0x22,0x6d,0x86,0x7c,0x49,0x86,0xd3,
        0x0a,0x7e,0x87,0x2c,0x33,0xac,0x45,0x5b,0xa4,0x99,0xfb,0x06,0x80,0xb0,0xf7,0x8f,
        0xb0,0x03,0x93,0x38,0x7b,0x90,0x67,0x8b,0x56,0xc3,0xbd,0xf9,0xfd,0x3d,0x45,0xc1,
        0xc2,0xd4,0x0b,0x13,0x25,0xdb,0xa5,0x75,0xa6,0xa3,0xb1,0x67,0xd7,0x41,0x7f,0x42,
        0xb5,0x92,0x0a,0x66,0x38,0x7d,0x2d,0x94,0x29,0x78,0x13,0x99,0x34,0x4e,0xf0,0x2d,
        0x3e,0x1f,0xee,0x1a,0xf9,0xa8,0x6b,0xa1,0xb5,0xc4,0x61,0x19,0x79,0x33,0x25,0xd9,
        0x52,0x9b,0x55,0x58,0xeb,0xcc,0x0b,0x93,0x5e,0x48,0x57,0xaf,0x4a,0x03,0xed,0xe0,
        0x26,0x67,0x1a,0x89,0xd4,0x9b,0xfd,0xa5,0x79,0x05,0xf3,0x65,0x8d,0x0e,0x53,0x1a,
        0x2e,0x25,0x5c,0x56,0xba,0x06,0x6b,0x4e,0x9c,0x3c,0x71,0x83,0x66,0xe4,0xa5,0xa2,
        0x21,0xb5,0x76,0xa8,0xe0,0x3d,0xc4,0x49,0x9c,0x6d,0x4f,0x93,0x3b,0x58,0x70,0xcf,
        0xf2,0x38,0x07,0xa8,0xcd,0xb2,0xb4,0x8f,0x8c,0x5b,0x4a,0x5d,0xb1,0x7a,0x80,0x3a,
        0xd7,0x10,0xea,0xbe,0x45,0x15,0x28,0x57,0xc3,0x05,0x5e,0xeb,0xad,0x9b,0xe4,0xbe,
        0x45,0xdc,0x3e,0x95,0x4d,0x58,0x4e,0x1c,0xd6,0xad,0xc8,0x85,0x53,0x4c,0xe7,0x72,
        0xf1,0x80,0x5e,0x15,0x2b,0xac,0x92,0x95,0x98,0xd4,0x06,0xb4,0x08,0x5e,0x16,0xb0,
        0xd0,0x1a,0xe9,0x66,0x62,0x81,0xa1,0xbd,0x21,0x3a,0xd4,0x42,0x73,0xe3,0x40,0x10,
        0x17,0x0d,0xba,0xf3,0xb9,0x88,0x68,0xcd,0xc3,0xe2,0x30,0x38,0x77,0x2a,0x70,0x6c,
        0x3b,0xf9,0xf0,0x64,0x33,0xb4,0x15,0x3c,0x15,0x0b,0x57,0xde,0x39,0xc5,0xf4,0xdd,
        0xf0,0xc0,0xe6,0xa1,0x17,0x33,0x13,0xc5,0xec,0x37,0xc5,0xbd,0x20,0x86,0x59,0xbc,
        0x2d,0x82,0x3b,0xd4,0xe9,0x79,0x12,0x60,0x5b,0x27,0x37,0x9f,0xce,0x7c,0x6c,0xa1,
        0x25,0xa0,0xcb,0x67,0x6e,0x35,0xfc,0x46,0xba,0xdc,0xab,0x8c,0x2b,0xfa,0x39,0x66,
        0x4e,0xbc,0xb2,0x01,0xab,0x58,0x00,0xf0,0x9b,0x96,0x5e,0xce,0x5a,0x90,0x0f,0x24,
        0x5d,0xb5,0x4f,0x8c,0xe6,0x14,0x8a,0x17,0xd5,0xd8,0xcc,0xed,0xc1,0x0e,0x79,0x33,
        0x47,0xaf,0x3e,0x32,0xa2,0xda,0x47,0xb5,0x7c,0x61,0xb2,0xb2,0x04,0x87,0x44,0x2d,
        0x41,0x08,0x5b,0x5a,0xa6,0x5a,0x24,0x02,0xe6,0x33,0x0e,0x27,0x0a,0x4b,0x7f,0xeb,
        0xc0,0x63,0xc5,0xae,0xf6,0x86,0x4f,0x77,0xa7,0x8f,0x1d,0x95,0xf5,0xeb,0x75,0x86,
        0x79,0xa0,0xd8,0x17,0xd7,0x8e,0x34,0xcd,0x95,0xf5,0x5b,0x84,0x2d,0x38,0xb4,0x56,
        0x60,0xe1,0x30,0xbe,0xce,0xe4,0x80,0xfd,0xc4,0x28,0x86,0xbd,0x55,0x43,0x09,0xf5,
        0xac,0x86,0xac,0x0c,0xa0,0x39,0x21,0x41,0x89,0x27,0x9a,0x4a,0x52,0x5e,0x80,0x3b,
        0xd0,0x30,0x68,0xaa,0x52,0x7d,0x43,0x11,0x7a,0x35,0xd4,0x73,0x4b,0x18,0x68,0x43,
        0x82,0xc0,0xc1,0x81,0x2a,0xe2,0x53,0x26,0x6b,0xd1,0xb3,0xc2,0xa3,0x43,0x4c,0x64,
        0xb8,0x58,0x54,0xba,0xac,0xd8,0xfe,0x79,0x71,0xbc,0xf1,0xff,0xff,0xf1,0xfa,0x38,
        0xa5,0x58,0xfd,0xbe,0x9c,0x11,0x32,0x44,0xe2,0xf9,0x8d,0x34,0x45,0x71,0x7e,0x97,
        0xbe,0x62,0xdb,0x36,0x01,0x7e,0x1b,0xfe,0x52,0xc8,0xc4,0xa9,0x9a,0x56,0x26,0x9b,
        0xba,0x55,0x4a,0x0a,0x1f,0x4f,0x26,0x62,0x97,0xa9,0x12,0xe8,0x63,0x70,0x80,0x9d,
        0x8d,0x55,0xe7,0x65,0x7c,0xf5,0x00,0x68,0xc5,0x5e,0x35,0xb9,0x44,0xcf,0x57,0x36,
        0x6c,0xc0,0x8f,0xaf,0xdb,0x22,0x97,0x4a,0x31,0xe8,0x29,0x25,0x23,0xc6,0xb8,0x3e,
        0xcb,0x39,0x5f,0x90,0x42,0xc7,0x17,0x7f,0x71,0x88,0x2c,0x76,0x24,0xe5,0xf2,0xcf,
        0x60,0xa0,0xb4,0xf3,0xf7,0x15,0xed,0xc2,0x59,0xbf,0xba,0x35,0xad,0xfd,0x90,0x41,
        0x21,0x16,0x2a,0xff,0x7e,0x7b,0xc6,0x0b,0xff,0x4d,0x91,0x2a,0x63,0x1f,0x60,0x2f,
        0x41,0xfd,0xa0,0x1f,0x9c,0xad,0x90,0x93,0xb7,0x34,0xae,0x5e,0x2a,0x9d,0x6e,0x70,
        0x36,0xf5,0x32,0xfa,0x56,0x9a,0x77,0xd3,0x16,0xb6,0x4c,0x1b,0x28,0x06,0x09,0x1e,
        0xb5,0xe0,0x3d,0x7a,0xf1,0x74,0xe8,0x85,0xf2,0x52,0xeb,0xe9,0xc2,0x2c,0xbc,0x91,
        0xb3,0xdd,0x5e,0xc9,0xf2,0xab,0x91,0xa0,0x5f,0xc9,0x46,0x91,0x9c,0x20,0x55,0x63,
        0x64,0x50,0x72,0x4e,0x1f,0xf1,0x5e,0x5f,0xb3,0x1e,0x5a,0x1e,0x9c,0x34,0xe1,0x6d,
        0x3f,0xd7,0x96,0xb3,0x7b,0x36,0x7c,0x3a,0x82,0x90,0x65,0xd6,0xe7,0xf8,0xad,0xc8,
        0xf8,0x55,0x27,0xe1,0x4d,0xac,0x58,0xeb,0xa1,0xa2,0xe3,0x44,0xe1,0x3c,0x45,0xcc,
        0x83,0xea,0xc2,0x01,0x19,0xc4,0x9f,0x69,0x26,0x13,0x92,0x31,0x30,0x13,0x77,0x13,
        0x16,0xf7,0x44,0x7d,0xa4,0x2e,0x3f,0xef,0x65,0xe5,0x6f,0xa4,0xb8,0xcd,0x50,0x76,
        0x26,0x1e,0xcb,0xfc,0xf3,0xdc,0x64,0xf5,0xf3,0x59,0xb6,0xe9,0x9f,0xfb,0x1c,0x0d,
        0x68,0x3f,0xb2,0x68,0x4c,0xfe,0x7c,0x34,0xa6,0xef,0xe4,0x87,0x4a,0x6e,0x6a,0x32,
        0xd1,0x7b,0x97,0xe9,0x32,0x06,0x32,0xa5,0x93,0x6a,0xb7,0x47,0x5e,0x37,0x05,0x7e,
        0x96,0x34,0x57,0xea,0x6c,0xa4,0x75,0x82,0x0d,0xc9,0x2c,0x33,0xbf,0xa7,0xfb,0xc9,
        0x2c,0x0a,0x0f,0x13,0xfd,0xca,0x72,0x42,0xab,0x4e,0x7f,0x93,0x92,0x4f,0x99,0x2e,
        0x48,0xde,0x1c,0x4d,0x2c,0xa9,0x94,0xa0,0x42,0x7a,0x2d,0xf1,0x3e,0x00,0x6b,0x04,
        0xde,0xd2,0x1b,0xc1,0x7d,0xb1,0x8a,0x94,0xe6,0x0d,0xf4,0x15,0x66,0xcb,0x3f,0xe4,
        0x25,0x46,0xe9,0xd7,0xb5,0x94,0x40,0x58,0xec,0x0a,0xd1,0x08,0xef,0x02,0x22,0xa9,
        0x90,0xdb,0xa4,0x3a,0xda,0x42,0xe3,0x63,0xe9,0xb0,0x00,0x14,0x00,0x34,0x61,0x6a,
        0xd5,0x73,0xa7,0xd2,0x2f,0xed,0xe0,0x70,0xb3,0x82,0xfe,0xc2,0xfb,0x34,0x89,0x80,
        0xe9,0x2e,0x90,0xc7,0x3b,0x06,0xe5,0x77,0x5f,0x3f,0x8a,0xda,0x88,0x12,0x66,0x86,
        0x01,0x6d,0x3c,0x84,0xc2,0x3d,0xde,0xb1,0x41,0xe9,0x9e,0x65,0x8a,0x1e,0x06,0x53,
        0x92,0xd2,0xc9,0xb0,0xc8,0x83,0xf8,0x98,0xee,0xc0,0x79,0xad,0x27,0xeb,0xb6,0x01},
        {0},
        /*TST_Expected_output_data for enc Input data for decrypt*/
        {0x4d,0x8a,0x1b,0xc0,0x47,0x37,0x95,0x76,0xce,0xf8,0x67,0xf0,0xed,0x8f,0x54,0x9e,
        0xf8,0xa5,0x9b,0x92,0xd1,0x74,0x99,0x0c,0x55,0x29,0x2e,0x3d,0x98,0x83,0xe7,0x7f,
        0x34,0x95,0xcd,0xd8,0x08,0x47,0x30,0xd7,0x4c,0x5c,0x9b,0x92,0x43,0xda,0x43,0x32,
        0xfb,0xd3,0x18,0x08,0x32,0xe0,0xa1,0x45,0x0a,0x5a,0x33,0x4f,0xa3,0xc1,0xc0,0x23,
        0x5f,0x2b,0xe7,0xd1,0xdb,0xf6,0x60,0x9f,0x87,0x1e,0x87,0x6a,0x15,0x3e,0xeb,0xfe,
        0x60,0xf1,0x1c,0x00,0x7d,0xe4,0xb1,0x8f,0xe7,0x0d,0x42,0x23,0xc4,0xc3,0xd2,0x49,
        0x72,0xe9,0xd1,0xa3,0xd1,0x19,0xbd,0x51,0xa3,0xc5,0x8a,0xc8,0x32,0xa3,0x85,0x5f,
        0x8b,0xde,0xef,0xf2,0xfd,0x7a,0xe2,0x01,0x9e,0x14,0x66,0x90,0x62,0x4a,0xa4,0xed,
        0x26,0x20,0x04,0x36,0xdf,0xf4,0xb2,0x1a,0xaf,0x54,0xf4,0xc5,0xb0,0xcb,0xbb,0x76,
        0x21,0xf1,0xe2,0x50,0x14,0x25,0xc3,0x5f,0x76,0x6e,0xec,0xea,0xdb,0x86,0x6b,0x38,
        0x08,0x3a,0x2a,0x0c,0x55,0x89,0x80,0x6f,0x9f,0x99,0xd2,0x09,0xfd,0x6f,0x3d,0x26,
        0xe4,0x1a,0x73,0x0d,0x55,0x5d,0xd1,0x3e,0x24,0xe4,0x57,0x93,0x0f,0x15,0xf6,0xb4,
        0xd7,0x15,0x45,0xc1,0x8f,0xac,0x3b,0x6a,0x19,0xa0,0xee,0x5a,0xd7,0x9d,0x72,0x1b,
        0xcc,0xbd,0xe7,0x37,0x03,0xb5,0xe6,0x30,0x08,0xd2,0xde,0xf5,0xaa,0xca,0xe4,0x1f,
        0xda,0xc7,0x6b,0xe6,0x73,0x37,0x29,0x94,0xeb,0xa4,0xef,0x2a,0x3f,0x39,0x6b,0xdd,
        0xeb,0x12,0x24,0xeb,0x08,0x41,0x68,0xf3,0xe3,0xc4,0xab,0x53,0x09,0x10,0x69,0x53,
        0xc3,0x4c,0x02,0x5a,0x18,0xc7,0x79,0x1c,0x70,0x45,0xdf,0xbc,0x28,0xaa,0x8b,0x98,
        0x70,0x47,0x04,0x5c,0xe1,0xc8,0xc1,0xc3,0xde,0x5f,0xfa,0x6f,0x67,0x28,0x2d,0xec,
        0x78,0xcf,0x94,0x31,0xba,0xe5,0x63,0xf1,0x84,0xc5,0x80,0xeb,0xe2,0xd9,0x0f,0xbf,
        0x8d,0xd3,0x7f,0x9f,0xa7,0xa4,0xfb,0x2f,0x0f,0xfe,0x63,0x95,0x34,0x4f,0x80,0xcf,
        0xfa,0xf9,0x64,0x68,0xfd,0x12,0x44,0xb7,0x4f,0xcd,0x93,0xed,0xca,0xe6,0x4d,0x2f,
        0x17,0xd4,0x9e,0xe3,0xac,0x70,0x53,0x12,0xcc,0xec,0x57,0x1f,0x18,0x3e,0x1b,0x76,
        0x53,0x95,0x30,0xbd,0x9e,0x0a,0xbd,0x0e,0xcf,0xd7,0x57,0x95,0x5c,0x4c,0x32,0xb0,
        0x55,0xf5,0xf4,0xf5,0xca,0xcb,0x02,0x63,0x17,0xbc,0x39,0x13,0x0f,0x63,0x6c,0xf1,
        0x99,0xca,0xea,0x09,0x4e,0x21,0x68,0xa6,0xe3,0x74,0xf6,0x33,0xb0,0x9a,0x81,0x8f,
        0x27,0x25,0xd9,0x81,0x97,0x36,0x82,0x41,0x04,0xa7,0x74,0xad,0xa6,0xae,0x60,0xe5,
        0xe9,0x6c,0xdf,0x17,0x78,0x7f,0xaa,0x40,0xe5,0x19,0x23,0x6e,0x2b,0xdb,0xdb,0xd2,
        0x0a,0xe3,0x74,0x8a,0x01,0xa6,0xe2,0x63,0x7d,0xcd,0x19,0x7c,0x01,0xc6,0x8d,0xc3,
        0xbf,0x9b,0x4d,0x1b,0x21,0x32,0xe5,0xad,0xb4,0x7e,0x41,0xd1,0x69,0x66,0x5c,0xd4,
        0x78,0xfd,0x15,0x8d,0x60,0x55,0xaa,0x18,0xcc,0xb7,0x19,0x98,0x94,0x30,0x78,0x7e,
        0xef,0x8b,0x8e,0x4f,0xa3,0x1f,0x22,0xb7,0x83,0xd4,0x6a,0xb3,0xce,0x83,0x0c,0x6f,
        0xc6,0x3d,0xdf,0xc2,0x6c,0x72,0xcc,0xa6,0xd7,0x53,0xc6,0x89,0xf2,0xb3,0x8e,0xad,
        0xcc,0x35,0xcb,0xfd,0x91,0x99,0x6c,0x22,0x3e,0x99,0x1e,0x77,0xff,0x5f,0xd6,0x96,
        0x9b,0x0f,0xc9,0x77,0x94,0x4d,0x37,0x5f,0x8d,0x9d,0xc3,0x0e,0x05,0xad,0xb6,0x62,
        0xa4,0x35,0xfe,0xac,0xb9,0x46,0xb7,0x10,0xac,0x68,0x40,0xff,0xf9,0x49,0x9a,0x10,
        0xab,0xff,0xec,0xf1,0x05,0xcd,0x2b,0x1c,0xd7,0xec,0x71,0x66,0x31,0x0d,0xc1,0x66,
        0x0d,0x03,0x28,0x38,0x08,0x3d,0xe1,0xd3,0x30,0x03,0x4d,0x27,0xee,0x42,0x1e,0x9c,
        0x54,0x22,0xd7,0xb9,0x96,0xf2,0xf6,0x62,0xf0,0x10,0xa7,0xcd,0x6d,0x53,0x3c,0x59,
        0xc8,0x70,0x1b,0x1a,0x9c,0x90,0x72,0xb4,0xd0,0x49,0x86,0x7f,0x16,0x4b,0x69,0x01,
        0x23,0xb4,0xe1,0x7c,0x60,0xa3,0xaf,0x70,0x3b,0x59,0x42,0xdc,0x33,0x22,0x7f,0x62,
        0x80,0xc9,0x99,0x59,0x21,0x41,0xac,0x7a,0xde,0x6c,0xab,0xb4,0x9f,0x73,0xcd,0x50,
        0x92,0x1f,0x45,0xda,0xae,0x44,0xdd,0x25,0xe2,0x16,0xe5,0xa4,0xe3,0x0e,0x79,0xde,
        0x4e,0xe9,0xca,0xa3,0x3c,0x84,0x9d,0x6d,0x42,0x0d,0x52,0x3e,0xf6,0xee,0x54,0x91,
        0xa4,0xbf,0x10,0x03,0xe5,0x83,0x04,0xb2,0xfd,0x34,0x28,0xd1,0xb9,0x38,0x7c,0xe7,
        0x7e,0x6c,0x7b,0x09,0x9c,0x70,0x06,0x55,0x18,0x9e,0x2e,0x7d,0xa9,0x03,0xd9,0x2d,
        0x2b,0x80,0xbe,0x11,0xe2,0x3c,0x28,0x05,0xf0,0xdf,0x3d,0x27,0xda,0x1d,0x2c,0x47,
        0xb1,0x62,0x1f,0x74,0xc6,0x1b,0xaa,0x6b,0x1b,0xa1,0x93,0xda,0xbb,0x2d,0x3a,0x93,
        0xd5,0xbf,0x9d,0x18,0xb6,0xd9,0xc5,0xdc,0xac,0xb9,0xb8,0x8c,0xa2,0x4b,0x50,0x77,
        0x28,0xaa,0x0f,0xab,0xbf,0xf5,0xb7,0xa0,0x18,0x95,0xb2,0xc1,0xb7,0x1a,0xf8,0x8c,
        0x86,0xa1,0x32,0x2b,0xe3,0x31,0x2b,0xd6,0x24,0xbb,0x35,0x18,0x30,0xa7,0x03,0x34,
        0x77,0x51,0xe7,0x50,0x6c,0xe2,0x93,0xba,0xfa,0x48,0x18,0x5b,0x48,0xd9,0xe4,0x17,
        0x09,0xea,0x05,0x00,0x2a,0x0f,0x7d,0xcd,0xc3,0x4a,0x0d,0x75,0x98,0xa2,0xba,0x75,
        0x52,0xcf,0x4e,0xc0,0xbe,0x9e,0x91,0x9c,0xc5,0xbc,0x84,0xc4,0x7d,0x24,0x73,0x44,
        0xbe,0xd3,0xce,0x9f,0x2b,0x68,0x25,0x45,0x57,0x53,0x67,0x07,0xfd,0x67,0x34,0x8c,
        0x20,0x2e,0x74,0x13,0x29,0xb1,0xe4,0x80,0xdd,0xb7,0xdf,0xfd,0xda,0xbd,0xa0,0x5d,
        0x85,0x91,0xf6,0xa2,0x74,0x7a,0x9b,0x13,0x92,0x88,0xb9,0x5e,0xcf,0x86,0x08,0x92,
        0x93,0x0d,0x17,0x0d,0xfc,0x8b,0xbf,0x5b,0x41,0xea,0x86,0xbf,0x57,0x99,0x9f,0x96,
        0x55,0x54,0xd5,0x83,0x27,0x03,0x03,0x54,0xde,0xe1,0x26,0x46,0xc6,0x53,0x94,0x23,
        0x0d,0x52,0x3b,0x46,0xda,0x6b,0xc0,0x6c,0xbb,0x3c,0x24,0x7d,0x30,0x67,0x48,0xec,
        0xd3,0x18,0x7c,0xdd,0x4f,0xe9,0xd1,0x78,0x14,0x4e,0x58,0xf4,0x70,0x00,0x5c,0xbe,
        0xd2,0x0d,0x20,0xdd,0x66,0xd0,0xdf,0xb7,0x56,0xce,0x40,0x83,0xa0,0x7f,0x4d,0xb8,
        0xe0,0x0f,0xec,0x73,0x10,0xfd,0x3b,0xaa,0x74,0x0a,0x56,0xf2,0x2c,0x00,0x99,0x4f,
        0x68,0x01,0x5b,0x8a,0x5d,0x74,0x5a,0x25,0x23,0x2a,0x4f,0x2a,0x74,0x1f,0xb3,0xa4,
        0xd5,0xe1,0xdd,0x2a,0x61,0xa6,0xd8,0x2f,0xf0,0x89,0x93,0x43,0x93,0x14,0x88,0x12,
        0x3a,0x04,0x55,0x1a,0x4a,0x5d,0x3c,0x05,0xc4,0x42,0xaa,0x1d,0x1d,0xb4,0x75,0x73,
        0x93,0xdb,0xa9,0x84,0x92,0xe3,0x3c,0xd1,0x1a,0xe5,0x66,0x53,0x7d,0x0b,0x9a,0x9c,
        0x7a,0xfa,0xf6,0x83,0x05,0x6d,0xc5,0xe8,0xca,0xdd,0x7e,0x2c,0x96,0x37,0x37,0x07,
        0x66,0xfa,0x73,0x0c,0xf1,0xd9,0xfd,0x73,0x1d,0x57,0x3b,0x68,0xbf,0x4c,0xea,0x79,
        0xca,0xa5,0xad,0x0d,0x2d,0x3e,0xfe,0x0f,0x70,0xc4,0xee,0x0d,0x6d,0x61,0x00,0x2f,
        0x57,0xf3,0x4f,0x78,0xb0,0x32,0x47,0x6f,0x22,0xd8,0x56,0xaf,0xa6,0x9f,0xae,0xa3,
        0xa6,0x4d,0x09,0xae,0x00,0xa0,0x0f,0x17,0x32,0xaa,0x0b,0x3b,0x13,0xdb,0x1a,0xc5,
        0x1a,0x0f,0x34,0x70,0xa0,0x0b,0xe9,0x07,0x66,0x0b,0x2b,0x4a,0xb2,0x32,0xaa,0x8d,
        0x59,0x5f,0x90,0xa0,0x59,0x4a,0xf9,0xe1,0x34,0x5d,0x59,0x69,0x90,0xc0,0x8e,0xcc,
        0x60,0xe7,0x3d,0x41,0x22,0xc2,0x11,0x5c,0x53,0x52,0x78,0xe9,0x2a,0x36,0xb5,0xe9,
        0x8b,0xcd,0xc5,0xed,0xed,0x2b,0x3f,0x04,0x03,0xee,0x2b,0x10,0x5a,0x24,0x27,0xc3,
        0x5c,0x74,0xd6,0x6f,0x76,0xe9,0x6b,0x5e,0x22,0xd7,0x5f,0xda,0x6f,0x0f,0x5a,0x11,
        0x06,0xaf,0xf6,0x0e,0xce,0x1a,0x91,0xb0,0x95,0xfb,0xf0,0xb5,0x4f,0xde,0x57,0x47,
        0xb9,0x48,0x0f,0xf5,0x19,0x12,0x47,0xec,0x0e,0xa6,0xee,0x0e,0xa0,0x81,0xd7,0x07,
        0xb0,0xcf,0xd9,0x8e,0x61,0xc0,0x46,0x70,0xcc,0x18,0xe4,0x4a,0xff,0xb1,0x22,0x97,
        0x51,0x52,0xad,0xd3,0x52,0x8a,0x6f,0x84,0x25,0x6e,0xac,0xde,0xe7,0x0d,0xf5,0x9d,
        0xab,0x14,0xe2,0xfb,0xfb,0x4c,0x16,0x3f,0x15,0x9e,0xe7,0x54,0x2e,0xb0,0x88,0x65,
        0xbf,0x9c,0xdd,0x34,0xde,0x6f,0x53,0xd0,0x2b,0x21,0x88,0x69,0x3d,0xae,0xdb,0xf6,
        0xdb,0x10,0x1a,0x1c,0xaa,0x1e,0x94,0x00,0xa3,0xb2,0xc2,0x5f,0xe4,0x28,0xdd,0x55,
        0xfe,0x59,0xc2,0xdb,0xde,0x14,0x5d,0xa4,0x37,0xb1,0x9a,0xa2,0x2c,0xa3,0xa1,0x77,
        0xb6,0x0b,0x53,0x74,0x02,0x04,0x1d,0x96,0x31,0x2c,0x1b,0xf8,0x2c,0xef,0xed,0x5f,
        0xa1,0xf9,0xbe,0x66,0x56,0x12,0x7f,0xdd,0xb9,0x4d,0xdc,0x58,0xd5,0xf1,0xd8,0x9c,
        0xbb,0xbb,0xba,0x6f,0x71,0xc6,0x23,0x2b,0x1f,0x28,0xbc,0xfa,0x1e,0xcb,0xac,0x2c,
        0x01,0x08,0xeb,0x26,0xa3,0x4e,0x6f,0xa5,0xea,0x3f,0xcf,0xcb,0x08,0x64,0x45,0x2f,
        0xdb,0x79,0x5a,0x6d,0x69,0x54,0xab,0xad,0xdf,0x94,0x32,0x9e,0x81,0xbc,0x91,0x5b,
        0xdc,0xad,0x57,0x03,0x4c,0x0c,0x21,0xa4,0xf5,0xb9,0x6b,0xab,0x92,0x04,0xfb,0x5f,
        0xe9,0xd5,0xed,0x50,0x56,0x19,0x72,0x56,0xa4,0x22,0x7c,0x2d,0xbd,0x88,0xc9,0x3d,
        0x06,0xfb,0x9c,0x02,0x11,0xe7,0x14,0x8e,0xb7,0x46,0x6e,0x21,0x53,0xb9,0xbd,0x7e,
        0x36,0xb0,0x51,0xc2,0x52,0x0e,0xe7,0xf0,0x2f,0x02,0x6a,0xb6,0xcb,0xcc,0x7a,0xc9,
        0x39,0xcd,0xa1,0x9f,0x79,0x76,0xa4,0x76,0xbf,0x13,0xed,0xa8,0x7f,0x06,0x60,0xff,
        0xf3,0xe2,0x2e,0xa1,0xef,0xc8,0xe9,0x4d,0x70,0xd1,0x36,0x42,0x62,0xf9,0x79,0xca,
        0x28,0x97,0x22,0x86,0xb8,0x89,0x93,0xc2,0x08,0x42,0xdb,0xef,0xe3,0x73,0x5c,0x2f}, 
        /*TST_dataSize*/
        1536*sizeof(DxUint8_t),       
        CRYS_AES_CBC_mode
    },
    #endif
    #endif
        /************/
        /*        AES CTR vectors         */
        /************/
    #if TST_USE_AES_16BYTE_DATA
    { 
        {"Acceptance test - AES/CTR/128Key/16ByteData "},
        /*TST_Key*/     
        {0x2b,0x7e,0x15,0x16,0x28,0xae,0xd2,0xa6,0xab,0xf7,0x15,0x88,0x09,0xcf,0x4f,0x3c},
        CRYS_AES_Key128BitSize,
        /*Input Block-CTR*/
        {0xf0,0xf1,0xf2,0xf3,0xf4,0xf5,0xf6,0xf7,0xf8,0xf9,0xfa,0xfb,0xfc,0xfd,0xfe,0xff},
        /*TST_input_data*/
        {0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a},
        {0},
        /*TST_Expected_output_data for enc Input data for decrypt*/
        {0x87,0x4d,0x61,0x91,0xb6,0x20,0xe3,0x26,0x1b,0xef,0x68,0x64,0x99,0x0d,0xb6,0xce}, 
        /*TST_dataSize*/
        16*sizeof(DxUint8_t),       
        CRYS_AES_CTR_mode
    },
    #endif
    #if TST_USE_AES_32BYTE_DATA
    { 
        {"Acceptance test - AES/CTR/128Key/32ByteData "},
        /*TST_Key*/     
        {0xc4,0x87,0xbd,0xca,0x06,0xe0,0x94,0xde,0x42,0x00,0xf8,0xa7,0x49,0x04,0xe1,0x4d},
        CRYS_AES_Key128BitSize,
        /*Input Block-CTR*/
        {0x8c,0x72,0x4c,0xcc,0x10,0x2c,0x8c,0xfe,0xe3,0xb5,0x2a,0xbb,0x26,0xbe,0xe2,0x61},
        /*TST_input_data*/
        {0xff,0x82,0xa2,0xf8,0xc0,0x3e,0xb9,0x16,0x84,0xda,0x66,0xc4,0x97,0x86,0xf0,0xc2,
         0x0b,0x1f,0x8a,0x03,0x58,0x48,0x1d,0x5f,0x46,0xbc,0x48,0x88,0x0d,0xe3,0xa6,0x3f},
        {0},
        /*TST_Expected_output_data for enc Input data for decrypt*/
        {0x64,0x5c,0xd9,0x50,0xca,0xb1,0xa1,0x0a,0xb2,0x52,0x98,0x92,0xa5,0x67,0xd7,0xe5,
         0x36,0xdf,0x72,0xe1,0xf3,0x89,0xd7,0xac,0x87,0xe9,0xbb,0x8f,0x8b,0xc3,0x02,0x99}, 
        /*TST_dataSize*/
        32*sizeof(DxUint8_t),       
        CRYS_AES_CTR_mode
    },
    #endif
    #if TST_USE_AES_512BYTE_DATA
    { 
        {"Acceptance test - AES/CTR/128Key/512ByteData "},
        /*TST_Key*/     
        {0x08,0x82,0x94,0x8f,0xf5,0xf0,0xea,0xf1,0xe9,0x08,0x0a,0x98,0x1e,0x27,0xac,0xee},
        CRYS_AES_Key128BitSize,
        /*Input Block-CTR*/
        {0x25,0xc3,0x38,0xde,0x08,0xa8,0x20,0x9e,0xa0,0x97,0x71,0x95,0x42,0x60,0x47,0xbc},
        /*TST_input_data*/
        {0x5a,0xb6,0x19,0xc3,0xbb,0x9e,0x82,0x62,0x8d,0x56,0x0d,0xe8,0xc3,0x98,0xd8,0x0a,
         0x11,0xd7,0xe1,0xe2,0xf4,0x2e,0x23,0x89,0xf2,0x96,0x02,0xe8,0x23,0x5b,0xe9,0xcb,
         0xf0,0xd1,0x32,0x37,0x1b,0x43,0x46,0xfe,0x00,0x2c,0x05,0x90,0x1a,0xa9,0x68,0x14,
         0xc8,0x2f,0x64,0xb8,0x51,0x79,0x12,0x45,0x26,0xc5,0x0e,0xf6,0x68,0x40,0x1d,0x8a,
         0xaa,0xbf,0x12,0x98,0xf8,0xaf,0xf2,0x23,0x18,0x4f,0x56,0x6e,0x0f,0x1d,0x11,0x11,
         0xe8,0x8d,0x13,0x4d,0xb0,0x01,0x8d,0x9d,0xc5,0xf6,0x56,0x8d,0x51,0x7b,0x8e,0xcf,
         0x11,0xe8,0x81,0x8c,0x5b,0xcc,0xcd,0xf8,0x5f,0x27,0xc8,0x29,0xad,0xda,0x1c,0x29,
         0xf7,0x5b,0xb4,0x4a,0x18,0xad,0xdc,0xb9,0x56,0x90,0xa3,0x56,0xe4,0xf5,0x84,0xc3,
         0xab,0xb4,0x46,0xbb,0x4b,0x81,0x21,0xa6,0x5c,0x1d,0x22,0x6a,0xf9,0xc9,0xd1,0x83,
         0x7f,0x00,0x10,0x56,0x92,0x65,0x46,0xc2,0x61,0xfb,0xbd,0xf9,0x2b,0x94,0x49,0x8e,
         0x03,0x8c,0x2b,0xcf,0xd0,0xb6,0x34,0x54,0x97,0x97,0x2e,0xd8,0xfd,0xd2,0x77,0x48,
         0x07,0xe4,0xef,0x1a,0x25,0x11,0x14,0xe0,0x6f,0x9e,0x6c,0x1d,0x2e,0x41,0x24,0x57,
         0x9e,0xd6,0xf6,0x6d,0xf2,0x53,0x50,0x2b,0x99,0xfe,0xb2,0x1c,0xc0,0xde,0x57,0x9f,
         0x18,0x6f,0x19,0x3d,0xd9,0x9a,0x8f,0x3a,0x07,0xe3,0x78,0x6a,0xf4,0xe5,0x5c,0x46,
         0x06,0xfb,0x70,0x3f,0xba,0x41,0xbb,0x53,0xe9,0xbb,0x77,0xdd,0x4a,0xd3,0xba,0xb1,
         0x39,0x09,0x55,0x68,0xb6,0xe6,0xfc,0xf9,0xb1,0x31,0xa8,0x8a,0x85,0x66,0x3a,0x85,
         0xc2,0x64,0x61,0xed,0x2f,0x66,0xbd,0xf3,0x0f,0x34,0x45,0xc4,0xa4,0x9b,0xe6,0xa6,
         0xf2,0x1a,0x6c,0x43,0xc5,0xde,0xa6,0x44,0xf5,0xf1,0xc5,0x22,0xe9,0xae,0x06,0x39,
         0x5a,0x78,0x91,0x1f,0x59,0xab,0xa0,0x33,0x94,0xd3,0xe3,0x79,0xd5,0x1c,0x24,0xa5,
         0xcb,0x0a,0x27,0x75,0x0d,0x6a,0xd4,0x44,0x5c,0x89,0x97,0xdd,0x28,0xa3,0x08,0x8d,
         0x56,0x9e,0xc7,0x7c,0x41,0xf8,0xaa,0x3c,0xff,0xff,0x1b,0xa3,0xe5,0x40,0xbb,0xd6,
         0x4d,0x41,0x4c,0xa7,0x96,0x73,0xcd,0x21,0x6d,0x62,0xe6,0x60,0x4b,0x2f,0x87,0xa7,
         0x3f,0x40,0xcd,0xac,0xee,0x36,0x25,0x36,0xd8,0x1f,0xb3,0xea,0xdd,0xed,0xf5,0x62,
         0xff,0x28,0xa3,0x80,0x69,0xdf,0xda,0x02,0xb1,0xe4,0x7a,0x56,0x5a,0x39,0xcd,0xaf,
         0x9d,0xc5,0x69,0x58,0x68,0x4b,0x57,0x49,0xa8,0x9d,0x74,0xf8,0xc4,0x0d,0x18,0x71,
         0x69,0x25,0xf6,0xa9,0x8d,0x98,0x43,0x0f,0xae,0x77,0x1b,0x65,0x5b,0xa8,0x20,0xce,
         0xf6,0x95,0x64,0x28,0xb8,0x21,0x89,0x9b,0xf5,0xe0,0x26,0x72,0xa2,0x87,0x6d,0x2a,
         0x14,0xa1,0x0b,0xc9,0x0a,0x84,0x50,0x72,0xee,0x84,0x90,0x35,0x58,0x66,0xc9,0x2b,
         0xd4,0x18,0x85,0xc3,0xe5,0x9f,0x02,0x57,0x4a,0x50,0x91,0x03,0x7f,0x43,0x3c,0xb6,
         0x87,0x05,0xab,0x89,0xe9,0x8d,0x49,0x50,0xf9,0x71,0xa2,0x6f,0x58,0x5a,0x0f,0xf0,
         0xbe,0xb6,0x96,0xd2,0xf7,0xac,0x0c,0xa3,0x2c,0x55,0x7c,0x51,0x64,0x29,0xcd,0x3d,
         0x4a,0xb7,0x9e,0x91,0x31,0x9a,0x75,0xd4,0x55,0xa8,0x19,0xbb,0x64,0x6c,0x3c,0x43},
        {0},
        /*TST_Expected_output_data for enc Input data for decrypt*/
        {0x31,0xb5,0x74,0x50,0x2e,0x66,0x56,0xf7,0xb0,0x23,0x52,0xc2,0x9d,0xa2,0x7d,0xca,
         0xa6,0xcc,0xc8,0x7b,0xae,0xd1,0xa2,0x32,0x5e,0x92,0xa7,0xab,0xa4,0x11,0xce,0xbe,
         0x38,0x42,0x4e,0x53,0x7f,0xe0,0xda,0x17,0xba,0x19,0x4f,0xf1,0xe8,0x81,0xd4,0x05,
         0x1f,0x59,0xf1,0xe2,0x57,0x5d,0xf1,0x0f,0xab,0xb9,0xfd,0x7c,0x5c,0xff,0xf9,0xc7,
         0xf4,0xa4,0xff,0x40,0x6e,0x98,0xa6,0x5f,0x55,0x57,0x1f,0x92,0x8e,0xa4,0xf7,0xdf,
         0xf8,0x94,0xf2,0xc3,0x08,0xfb,0x7b,0xea,0x43,0x71,0x1e,0x64,0xd1,0xec,0xdc,0xa8,
         0x85,0x7c,0xd3,0x6c,0x8b,0x84,0x8d,0xe4,0x38,0x1e,0x12,0x20,0x8a,0x38,0x1f,0x19,
         0x41,0x14,0xfc,0x4d,0x24,0xe3,0x55,0x43,0xf5,0x15,0x35,0x54,0x9e,0xb4,0x69,0x72,
         0x94,0x76,0x73,0x52,0x13,0xfd,0xb2,0x64,0x2b,0x1d,0xd0,0x30,0xde,0xfa,0xe2,0x18,
         0xf8,0xfb,0x22,0xf9,0xe2,0xf9,0x4d,0x8b,0xd7,0x55,0xf4,0xd8,0xbd,0x4e,0x03,0xf3,
         0x34,0xc0,0x62,0x8d,0xe0,0x49,0xc0,0x07,0x34,0x47,0x73,0x6b,0xdf,0x8f,0x27,0x0f,
         0xa4,0xe2,0xa8,0xa3,0x90,0x2e,0xb4,0x20,0xc0,0x5f,0x47,0xd8,0x65,0x18,0x3c,0x6a,
         0x71,0x72,0xd7,0x41,0x34,0x65,0x5d,0x02,0x27,0x6b,0x73,0x68,0xd8,0x9e,0xfa,0x9c,
         0xe3,0xaf,0x97,0xc5,0x85,0x51,0xf1,0x2d,0xff,0x2c,0xc8,0x93,0x4a,0x23,0x19,0x5a,
         0xf2,0xaa,0x04,0x72,0x31,0x3e,0x66,0x60,0x8b,0x47,0x82,0x1d,0x81,0xcf,0xa7,0x3b,
         0xcb,0x1c,0xf0,0x2e,0x0f,0xc0,0x3d,0x90,0x38,0x0c,0x72,0x6e,0xf0,0x11,0x6c,0x42,
         0x21,0x62,0xaf,0xd1,0x44,0xcc,0x47,0xd9,0x6a,0xfe,0xa7,0x56,0x0b,0x7b,0x3a,0x24,
         0x10,0x7e,0x1c,0x01,0x1b,0x0f,0xf2,0x99,0xa1,0x90,0xf9,0x0b,0x5f,0x1f,0x4d,0xc2,
         0x61,0xbb,0xf5,0x3c,0x90,0xcd,0x88,0x66,0x91,0xf8,0x94,0xb2,0x30,0xc7,0x0b,0x92,
         0xa1,0x77,0x72,0x7a,0xb1,0x41,0x72,0x48,0x8b,0xb2,0xa1,0xf1,0x14,0xc0,0x0c,0xf5,
         0xd4,0x87,0xea,0x30,0x9c,0xec,0x90,0xc6,0xf1,0x9f,0x7b,0xac,0x3b,0x31,0xaa,0x3b,
         0xbc,0x5f,0xc3,0xfd,0x25,0x29,0x1a,0xf3,0x97,0x1b,0x0b,0x08,0x6b,0xa7,0xbe,0x72,
         0x94,0x7a,0xd3,0x73,0x54,0x03,0x80,0x80,0x55,0x51,0xbe,0x72,0xae,0xe2,0xdb,0x82,
         0x0d,0x74,0xdf,0xc1,0xcf,0x44,0x2f,0x92,0x3e,0x75,0x66,0x28,0x77,0x56,0x8b,0xec,
         0xe6,0x6c,0xf4,0x93,0x5c,0x1e,0xaf,0x06,0x09,0xc0,0x16,0xeb,0x46,0xdc,0xb2,0x5c,
         0x8a,0xc9,0xf3,0x88,0x00,0xfa,0x9d,0x16,0xa0,0x19,0x29,0x9f,0xa6,0x27,0x97,0x36,
         0xfe,0x9d,0x1c,0xf8,0x76,0xc9,0xd6,0x98,0xf6,0x5d,0x6f,0x36,0x8b,0x5a,0xdd,0x42,
         0xfb,0x12,0xee,0x34,0x0d,0x3c,0x5f,0x66,0x78,0x5e,0x1a,0x1d,0x78,0xad,0x05,0xd5,
         0x83,0xe2,0xc9,0xea,0x2a,0xb3,0xf7,0xaf,0xe0,0x06,0x13,0x22,0xd6,0x7a,0x8f,0x36,
         0xa2,0xa3,0x62,0xe8,0x95,0x10,0x9f,0x98,0x49,0x73,0xbc,0x14,0xee,0xbb,0x9a,0x4f,
         0x71,0xa0,0xa7,0x1a,0x5f,0x63,0x33,0x29,0xff,0x93,0xe7,0x55,0x0b,0x9b,0x50,0x91,
         0x2b,0xc5,0x2b,0x23,0xdd,0x2c,0x6f,0x65,0xe6,0x04,0x0d,0xc3,0xb3,0x91,0xa7,0x3c}, 
        /*TST_dataSize*/
        512*sizeof(DxUint8_t),      
        CRYS_AES_CTR_mode
    },
    #endif
    #if TST_USE_AES_1536BYTE_DATA
    { 
        {"Acceptance test - AES/CTR/128Key/1536ByteData "},
        /*TST_Key*/     
        {0x1d,0xc3,0x4a,0xfb,0x08,0xb0,0xbb,0x42,0xa5,0xc5,0xfd,0x3b,0xbd,0xb5,0xc6,0x55},
        CRYS_AES_Key128BitSize,
        /*Input Block-CTR*/
        {0x2a,0x1b,0xec,0xbc,0xf7,0xf4,0xe2,0x99,0x5d,0x08,0x17,0xe9,0xe6,0x46,0x0e,0x2d},
        /*TST_input_data*/
        {0x3b,0x64,0x8f,0x8b,0xcb,0x5e,0xdf,0x1e,0xcf,0x5e,0xfd,0xac,0xa7,0x93,0x66,0x97,
        0xbb,0x13,0xed,0x2d,0xb5,0x35,0x9a,0x2a,0xee,0x3b,0xb8,0x7e,0x25,0x35,0x2a,0x51,
        0x77,0x22,0xfe,0x45,0x8b,0x57,0x45,0xfb,0x0e,0x25,0x21,0xd8,0x5f,0xb6,0x1f,0x09,
        0x8b,0x38,0xc7,0xc4,0x7b,0x3d,0x72,0xd1,0x6c,0x62,0x5c,0x4a,0xa0,0x2f,0xfa,0x9f,
        0x53,0x3f,0x8e,0xdc,0xf1,0xa1,0xf8,0x2f,0x86,0x7d,0xcf,0xa5,0x76,0xfb,0xb0,0x34,
        0x6e,0x60,0xd6,0xfe,0x9a,0x7b,0xeb,0xd4,0x19,0x3f,0x1e,0xf9,0xae,0xb1,0x76,0x29,
        0xb8,0x05,0x66,0xda,0x64,0x03,0xa1,0xc2,0x21,0xb0,0x2f,0x99,0x54,0x2b,0xc1,0x20,
        0x4d,0xd5,0x42,0x62,0x7a,0xb4,0xae,0x3a,0xdb,0x1a,0x27,0x15,0xb6,0x81,0x46,0xf9,
        0x8c,0xba,0xaf,0xc7,0x4b,0x47,0xe8,0xbd,0xc5,0x05,0x6b,0x3e,0x61,0x0e,0xf9,0xd6,
        0x11,0xdd,0x32,0x79,0x84,0xb3,0x63,0x0b,0x9c,0x3a,0x9f,0x26,0x22,0x68,0x11,0x17,
        0xb9,0xa7,0x90,0x29,0x10,0x33,0x74,0x27,0x5c,0xc3,0xa8,0x1c,0x06,0x6b,0x01,0x5d,
        0xa0,0xc1,0xce,0xc9,0x1e,0x3f,0xb1,0x50,0x43,0xe8,0xad,0xb2,0x59,0x2e,0x7f,0x89,
        0x25,0x14,0x32,0x8a,0x1a,0x90,0xee,0x08,0xcd,0x33,0x11,0xb9,0xa9,0x0b,0x80,0xbd,
        0xe4,0xc9,0x40,0xdc,0xb1,0x1f,0x40,0x10,0xb8,0x6c,0x79,0x43,0xc3,0x9b,0x39,0x59,
        0xba,0x48,0xbc,0x71,0xd1,0x25,0xfd,0x68,0x00,0x9d,0xcb,0x9f,0xb4,0xb7,0x1f,0xff,
        0xc4,0x3c,0xad,0x3a,0xa6,0x1c,0xb9,0x53,0xe3,0x0e,0x2c,0x60,0xc8,0x77,0xe7,0x8f,
        0x5e,0x8d,0x57,0x67,0x9d,0xbc,0x4a,0x50,0xdd,0x49,0x01,0x56,0x8d,0x35,0x86,0x2a,
        0x27,0x64,0x40,0x69,0x63,0xfe,0xc4,0x21,0xac,0x16,0xee,0x92,0xd0,0x89,0x31,0x31,
        0xfb,0x29,0x2b,0xf3,0xe6,0x1b,0x7c,0xc7,0x4c,0x7e,0xd9,0x64,0x9e,0x4d,0x5c,0x46,
        0xf7,0x87,0x1e,0xf3,0x52,0x8d,0x08,0x83,0xfb,0xcb,0xe6,0x5f,0x43,0x9a,0xbd,0x49,
        0x78,0x65,0x5f,0x9d,0x14,0x0b,0x3c,0xd6,0x35,0x85,0x7b,0x53,0x4d,0xc9,0x4a,0x5c,
        0x1b,0xee,0x72,0x60,0xda,0x90,0x2e,0x80,0xb8,0x76,0x3d,0x52,0x89,0x72,0x36,0xde,
        0xbd,0x89,0x1c,0xed,0x8f,0x54,0x32,0x84,0x80,0xa6,0x10,0xab,0x04,0x70,0xf7,0x72,
        0x7b,0xe1,0x62,0x36,0x62,0xd1,0xdd,0x21,0xcb,0x5f,0x1a,0xf0,0x0a,0xd9,0x42,0xf9,
        0xb2,0xdd,0x89,0x6c,0xc0,0xbe,0x05,0xd9,0x15,0x29,0xc0,0xf2,0x2a,0x09,0x0c,0x93,
        0xff,0xa7,0x16,0xff,0x54,0x16,0xbe,0x6d,0x1c,0xce,0xa6,0xc3,0x2f,0x97,0x89,0xa1,
        0x3f,0xa9,0xcf,0xa1,0x0d,0x11,0x5e,0xdd,0xdc,0x56,0xb2,0xb2,0x26,0x5d,0x30,0xc4,
        0x8f,0x8a,0xb7,0x42,0x17,0x28,0x79,0x6c,0x93,0x0b,0x09,0x52,0x5e,0x73,0xb4,0xde,
        0x4c,0x34,0x15,0x14,0xdf,0x14,0xe4,0x99,0xbe,0x75,0x0f,0x72,0x62,0x34,0x0c,0x0f,
        0x13,0xd0,0x6d,0x88,0x13,0xcf,0xb5,0x26,0x19,0x5d,0x6a,0x25,0x00,0x37,0x6b,0xb8,
        0xc1,0xc7,0x84,0x4e,0x9f,0x90,0x40,0x14,0xa1,0xcd,0xfe,0xbb,0x45,0x55,0x47,0x7b,
        0x73,0xc2,0x5f,0x58,0xb0,0xd2,0x1a,0xa4,0x94,0x0e,0xf1,0xc5,0x7e,0xa9,0x55,0x38,
        0x86,0xaa,0x44,0xd6,0xb3,0x4e,0x19,0x56,0x6f,0xa7,0xa8,0x14,0x37,0x8a,0x8a,0x10,
        0x97,0xa8,0xb6,0x3a,0x56,0xfb,0x51,0xed,0xee,0x64,0xc8,0xb9,0x3e,0x92,0x1b,0x65,
        0x83,0x25,0x7c,0x34,0x85,0x13,0x18,0x68,0x0e,0x4b,0x35,0x05,0xa0,0x99,0x7d,0xd7,
        0x67,0xca,0x99,0xb6,0x6d,0x10,0x02,0x09,0x0d,0xa8,0x14,0x89,0xaa,0xb9,0x65,0x48,
        0xa1,0x80,0x54,0xf1,0x7b,0xaa,0xe5,0x51,0x68,0x01,0xcc,0x16,0xe9,0x4b,0xc7,0xd7,
        0xcc,0x6f,0x31,0x55,0x5d,0xda,0xd5,0x01,0xdb,0x21,0x00,0xbe,0x29,0xe8,0xda,0xe7,
        0xc6,0x02,0xf5,0x94,0xff,0xda,0x27,0x19,0x63,0x11,0x95,0xd0,0x78,0x68,0x11,0x19,
        0xac,0xe1,0xa6,0x9e,0x8e,0x21,0x70,0xdc,0x3e,0x19,0xb1,0xdf,0x22,0xe5,0x22,0x4c,
        0xdb,0xf4,0x87,0xa5,0x78,0x6a,0x86,0xc9,0xe9,0xc2,0xb9,0xba,0xb6,0xb8,0x02,0xa3,
        0xf1,0x66,0x1f,0x1a,0x69,0xad,0x7e,0xa2,0x20,0xd6,0x52,0x74,0xff,0x79,0xe6,0x7f,
        0xc9,0x9e,0x31,0xad,0x4e,0x23,0xac,0x68,0xe1,0x5e,0x60,0x5d,0x0b,0x02,0x43,0x7f,
        0x81,0x47,0xc4,0x4f,0x54,0x45,0xa5,0x5b,0x68,0xa1,0x09,0x05,0x27,0x6c,0xce,0x86,
        0x76,0x48,0x1c,0x33,0xe8,0xcd,0x3e,0xfe,0x32,0x2b,0xb1,0x3f,0xe0,0x10,0x7b,0xb5,
        0x46,0xcc,0xbe,0xc7,0xb8,0xb3,0x8d,0x10,0xfe,0xc2,0xfe,0x1b,0x02,0x86,0x81,0x6b,
        0xcc,0x3a,0x70,0xbf,0xb0,0x30,0xe7,0x94,0xc6,0x72,0xd5,0xea,0x9b,0xa8,0x53,0x4b,
        0x26,0x3c,0x35,0x0a,0xfe,0xbd,0xdf,0xc9,0xca,0x81,0x5b,0x3d,0xf8,0x8f,0xa8,0x36,
        0xb2,0xbb,0x54,0xd9,0x0d,0x13,0x4d,0x30,0x84,0x7a,0xf4,0xe6,0xa6,0x93,0x73,0x4b,
        0x0b,0xe1,0x50,0x9e,0x8c,0x2c,0x43,0x8c,0xb3,0x26,0x45,0xf4,0x71,0x4e,0xea,0xed,
        0x0f,0x15,0xf0,0x0a,0x67,0x3f,0x18,0xdd,0x54,0x8d,0x34,0xb9,0x67,0x99,0x82,0xbc,
        0xdc,0x01,0x38,0x0d,0xcc,0xc7,0x60,0x63,0xa4,0xf8,0xe6,0xc7,0xd5,0x8c,0xf0,0x9a,
        0xcd,0x8e,0x6d,0xd9,0x27,0x7d,0xf1,0xa0,0x1e,0xf1,0xc0,0xed,0x48,0x81,0x29,0xa7,
        0x81,0xe5,0x15,0xdf,0x24,0x58,0xdf,0x55,0x82,0x40,0x66,0x3e,0x8c,0x11,0x61,0x44,
        0xd3,0x6f,0xf3,0xcf,0xb3,0x93,0x80,0x83,0xca,0xef,0xbe,0x0a,0xaf,0x15,0x0f,0x13,
        0xe1,0xd5,0x0e,0x9a,0xfe,0xa5,0x67,0x6a,0x36,0x47,0xed,0xe1,0xfe,0xa5,0xe6,0xf4,
        0x09,0x00,0xa9,0x72,0x74,0x49,0x6c,0x8d,0x41,0xcf,0x57,0x96,0x06,0x1b,0xdd,0x08,
        0xe6,0x18,0x4b,0xc8,0xc1,0x78,0xa1,0xab,0xa8,0x52,0xa2,0x39,0x94,0x10,0x27,0xb1,
        0x57,0x88,0xb8,0x4d,0xd2,0x69,0x5d,0xc6,0x69,0xd9,0xb2,0x1b,0xb4,0x5c,0x3a,0x8f,
        0x77,0xf8,0xf5,0xf0,0xd5,0x97,0x35,0x1f,0xc0,0xac,0xad,0xcd,0xb4,0x19,0xcb,0x83,
        0xa5,0x51,0x48,0xe5,0x36,0xb9,0xfd,0x37,0x2b,0x55,0xf8,0x20,0x21,0xa0,0xcf,0xae,
        0x7c,0xbb,0x34,0x9b,0xa2,0xca,0xca,0xcf,0x67,0x9c,0x37,0x25,0xc7,0x8a,0x7b,0x72,
        0xdb,0xa1,0x80,0xc4,0x06,0x03,0xf1,0xe7,0x70,0x8a,0x50,0x2e,0xb5,0xaf,0x43,0x6f,
        0xde,0xaa,0x2f,0x50,0x90,0xdb,0x08,0xc1,0x83,0x69,0x68,0xca,0x36,0x29,0xde,0x87,
        0xe1,0xc1,0x88,0x71,0xac,0x0d,0xe4,0xde,0x1e,0xc1,0xe3,0xcc,0xd8,0x50,0x3f,0xda,
        0x83,0x0d,0x0f,0x97,0x07,0x90,0x99,0xff,0xfd,0x5c,0x67,0x43,0x68,0xbf,0x9d,0xc9,
        0x9f,0xf9,0x89,0x74,0x8e,0xa0,0x7c,0x25,0x1e,0x42,0xd8,0x82,0xf2,0x4d,0x6b,0xf6,
        0x54,0x2c,0xfb,0xf8,0x6f,0xb3,0x22,0x91,0xbe,0xbd,0x5d,0x18,0xc4,0x13,0x5f,0x41,
        0xfe,0x90,0xab,0x56,0x16,0x83,0x61,0xc3,0x59,0x55,0x58,0xd8,0x6b,0x6c,0x6e,0xcb,
        0x39,0x4e,0x1c,0xfc,0x30,0x0a,0x4e,0x7d,0xad,0xd4,0x71,0xd2,0xb4,0xef,0xcd,0xf5,
        0xe4,0xd0,0x15,0x9e,0xaa,0x80,0x3c,0xc0,0xb6,0x42,0x8b,0x57,0xab,0x76,0xf1,0x61,
        0x1b,0xbd,0x9a,0x2a,0xb2,0x5e,0xc2,0xcd,0xb1,0xe8,0xcc,0xf8,0x9e,0x19,0x8e,0xef,
        0x3a,0xff,0xf0,0xd4,0xb4,0x5d,0xb5,0x25,0x1c,0x50,0x98,0x86,0x1a,0x32,0x9b,0xc1,
        0xe0,0xbf,0x9c,0x0b,0x5d,0x76,0x29,0x89,0xb4,0x42,0x95,0x12,0xec,0x5a,0x4b,0x37,
        0xe9,0x66,0x63,0x80,0x9b,0xe3,0x73,0xf9,0x75,0xc8,0xa8,0xed,0x21,0x6a,0x15,0xf2,
        0x72,0x9d,0x4a,0x25,0x9a,0x1c,0x29,0xb7,0x9d,0x2b,0xf5,0xa9,0x05,0x7a,0xac,0xd3,
        0xd8,0x4d,0x97,0x2b,0xc7,0xda,0x1f,0x44,0xa8,0xf2,0xe2,0x15,0x26,0xe4,0x06,0xfc,
        0xb7,0x9f,0xcd,0x03,0xcf,0x16,0x6a,0x61,0x54,0xe9,0x14,0x44,0x51,0x41,0x58,0xcd,
        0xee,0xfb,0xb3,0x5c,0xa0,0x0a,0x60,0x0f,0x9d,0x16,0x6f,0x85,0x93,0x69,0x17,0xe8,
        0x99,0x0c,0x4d,0x2a,0x66,0x2d,0x95,0x8e,0xc0,0xc4,0x19,0x6b,0x38,0x77,0xf8,0x2d,
        0x15,0xba,0xe0,0x9c,0x8e,0x3a,0xdf,0x61,0x3c,0x7c,0x76,0xc5,0xce,0xc1,0xf0,0xbd,
        0xff,0x2e,0xf1,0x24,0xc5,0x29,0x52,0x47,0xcb,0x06,0x2c,0xa6,0x22,0xe3,0x33,0xf9,
        0x34,0xd0,0x46,0x72,0xf9,0x34,0x44,0x42,0x6d,0x6c,0x20,0x5e,0x41,0xb4,0x38,0x83,
        0xd0,0x4b,0xe2,0x77,0x56,0xd2,0x48,0x93,0x5c,0xf5,0x77,0x7e,0x77,0x4e,0xb2,0x3b,
        0x32,0x86,0x0c,0x66,0x49,0xbe,0x36,0xba,0x18,0x2d,0x95,0xd7,0x52,0x0a,0x97,0x42,
        0xf6,0xac,0x48,0xae,0x7f,0xf0,0x20,0x7a,0x5c,0xdb,0x1f,0x7a,0x9f,0x80,0x1d,0xfa,
        0xf9,0x24,0x5b,0x00,0xe6,0xa1,0x5d,0xd2,0x25,0x08,0xfc,0xb8,0x6b,0x8a,0xb7,0x03,
        0x58,0x99,0x4a,0x4e,0xaa,0x4a,0x82,0x04,0xb1,0xfe,0x4f,0x23,0x03,0x41,0x1b,0x3f,
        0x70,0xf2,0x5a,0xc9,0x38,0xa5,0x62,0x91,0x7c,0x45,0x7d,0x8a,0xf3,0xfe,0x3d,0xcd,
        0xde,0x59,0x10,0xe1,0x3e,0xa9,0x14,0x3a,0x44,0xa7,0x2d,0xff,0x09,0x59,0x54,0x11,
        0x7f,0x38,0x32,0x48,0xa8,0x91,0xed,0x00,0x05,0x2c,0x42,0xd4,0x52,0x2c,0xd4,0xa9,
        0x70,0x36,0xc3,0xef,0xa3,0xd5,0x81,0x23,0xfd,0x1d,0xe1,0x98,0x1a,0x8f,0x71,0x78,
        0x0e,0x3d,0x0a,0x05,0x9c,0x2f,0xa5,0x25,0xa9,0x04,0x70,0x1e,0xef,0xdc,0x22,0x9e,
        0xf6,0x76,0x8b,0xfe,0x40,0x96,0x6f,0xc7,0xc4,0xaa,0x94,0x76,0x9f,0xac,0x1a,0x7c,
        0x05,0x4a,0x0b,0x89,0x7d,0x45,0x33,0x0a,0x4e,0x17,0x32,0xf1,0x34,0xd8,0xcf,0xb4,
        0x58,0x62,0x8f,0x98,0x7f,0xb4,0x87,0x2f,0x82,0x94,0x6e,0x1f,0xfe,0x79,0xf6,0x26},
        {0},
        /*TST_Expected_output_data for enc Input data for decrypt*/
        {0x91,0x26,0x65,0x53,0x17,0xd9,0x86,0x42,0xf1,0x23,0x10,0xda,0x24,0x74,0x4f,0x2d,
        0x34,0x19,0xf8,0x87,0x1c,0x82,0x6a,0x40,0x1c,0xce,0x1f,0x66,0x5c,0xf2,0x94,0xba,
        0xce,0xcf,0x8c,0xab,0x3a,0xe4,0x88,0x66,0xa3,0x88,0x53,0xb8,0x41,0xb8,0x05,0x99,
        0xa6,0x8e,0x07,0xf8,0x86,0xfd,0xa1,0xcd,0xcd,0xb4,0xd2,0xef,0x6f,0x9d,0x01,0xd8,
        0xda,0x30,0xc3,0x79,0xc0,0x1d,0x93,0x04,0xe5,0xbc,0x0c,0x33,0x16,0xd6,0x11,0x51,
        0xba,0x4e,0x51,0x3a,0x68,0x85,0xf2,0xec,0x36,0x60,0x65,0xdd,0xdb,0x0a,0x77,0x48,
        0xe1,0x55,0x72,0x7f,0xda,0x3b,0x6d,0xfd,0x75,0x9b,0x69,0x7e,0xa8,0x59,0xc8,0x75,
        0xbb,0x9d,0x1e,0x3a,0x6e,0x89,0x4e,0x32,0x85,0x19,0x37,0x34,0x31,0x7a,0x2a,0x83,
        0x91,0xec,0xa8,0xb1,0x94,0xed,0x0d,0x6c,0x57,0x56,0x1c,0x6a,0xbe,0x49,0xa5,0x07,
        0xae,0x8a,0x20,0xd4,0x7c,0xc7,0x35,0x80,0x55,0x31,0x05,0x07,0xd6,0x5f,0x50,0xf9,
        0x86,0x3c,0x8b,0xd5,0xce,0xb5,0x19,0x61,0x3c,0x0e,0xf8,0x46,0x52,0x4b,0x26,0xf8,
        0x2a,0xfc,0x65,0xbd,0xa7,0x0d,0xf9,0x0b,0x1a,0x07,0xc7,0xb9,0x00,0x7b,0xe2,0xc1,
        0x37,0x42,0x9a,0x57,0xa3,0x7f,0x72,0x40,0x08,0xa9,0xbe,0x1d,0x7f,0x9a,0xef,0x33,
        0xac,0xdc,0x0c,0x96,0x20,0xe2,0xfb,0x80,0xb7,0xc6,0x90,0xae,0x4c,0x5d,0xcd,0xfe,
        0x88,0xb9,0x0d,0x8d,0x6e,0xd0,0xa4,0x16,0xb7,0xfe,0xc5,0x63,0x35,0x66,0xa4,0x32,
        0xa6,0x38,0x7e,0xe9,0x6d,0x9e,0x0e,0xb0,0x60,0xdf,0xeb,0xc9,0x69,0x8a,0x0d,0xc1,
        0xeb,0xd9,0xfd,0xae,0x2d,0x81,0x2b,0xfd,0x2d,0xf9,0x2d,0xa2,0xe5,0x05,0xa3,0x0a,
        0x42,0xe5,0x19,0xc2,0x91,0x39,0x37,0x0a,0xa8,0x23,0x9e,0xdb,0xff,0x58,0xd8,0x02,
        0x89,0xff,0x05,0x93,0x68,0x82,0xff,0x3b,0xc0,0x1b,0xf9,0x8d,0xa5,0x9a,0xcb,0x97,
        0xc8,0x99,0xa8,0x63,0xe9,0xda,0xad,0x1d,0x62,0x31,0x28,0x5c,0x3c,0x17,0xc7,0x56,
        0x67,0x19,0x56,0xfe,0x9f,0xed,0x22,0x72,0x64,0x76,0xf6,0x34,0x3e,0x2f,0x68,0x95,
        0xc5,0xc6,0x3c,0x89,0x25,0xaa,0xc0,0x16,0x5e,0x21,0xeb,0xce,0x1a,0x4f,0xef,0x42,
        0xf0,0x18,0x96,0xf7,0x2e,0xd5,0x1c,0x2c,0x1d,0x2d,0x22,0x77,0x8f,0x68,0xc7,0xfa,
        0x6a,0x37,0x09,0x52,0xcf,0xa9,0xa5,0xb9,0x72,0x9e,0xad,0x92,0x24,0x44,0x0c,0x53,
        0x1d,0xd7,0xe6,0x0e,0x7a,0xfa,0xe4,0x85,0x42,0x07,0x54,0x86,0xc5,0xe8,0x40,0xde,
        0x0b,0xa3,0x07,0x1d,0x03,0xc3,0x6d,0x9f,0xfd,0x87,0x0d,0x7a,0xb8,0x41,0xa9,0x75,
        0x6a,0xaa,0xeb,0x7e,0x92,0x07,0x71,0x4f,0x32,0xb5,0x69,0xc5,0xaf,0xbe,0x06,0x6b,
        0xa8,0x30,0x0b,0x37,0xaa,0xf3,0xcc,0x67,0xd8,0xb2,0xe4,0x33,0x38,0xb8,0x0a,0xba,
        0x0d,0x6d,0x53,0xa2,0xd4,0xc6,0xcd,0x31,0x81,0x99,0x05,0x00,0x4e,0x41,0x1b,0x74,
        0xe1,0x62,0xda,0xb6,0x7a,0x4a,0x1d,0x7e,0xa3,0xdb,0xd8,0x70,0x55,0x67,0x8c,0x95,
        0x7c,0xcf,0xc6,0x98,0x21,0x8a,0x8e,0xdf,0x96,0x29,0xb5,0x42,0xe4,0x0e,0x93,0x60,
        0xdf,0x82,0x57,0xa3,0x0a,0x7a,0xe6,0x7d,0x9a,0x4b,0xff,0xd5,0x0b,0x31,0x2b,0xa6,
        0xd7,0x29,0x3c,0x79,0x99,0xf1,0xbf,0xc7,0x38,0xdc,0x1b,0xb3,0x64,0x73,0x78,0xb3,
        0x7b,0x8a,0xda,0x10,0x73,0xe8,0xe6,0xfc,0x43,0x34,0x34,0xb3,0x79,0x86,0x28,0x28,
        0x4a,0x31,0x6a,0x8c,0x32,0x11,0x4f,0xc8,0xdb,0x40,0xf2,0xa7,0x14,0x66,0x0b,0xc5,
        0xf0,0xad,0xea,0x1f,0x21,0x08,0xdd,0xde,0x9b,0x8a,0xbf,0x3a,0x15,0xa3,0x6d,0xf7,
        0xfb,0x1f,0x97,0xa2,0x39,0x0d,0xb0,0x0e,0x27,0x0f,0x29,0x01,0xea,0x7c,0xc2,0x7a,
        0xb0,0x0e,0x34,0xd5,0x9e,0x14,0x1e,0x00,0xe4,0xfc,0xcb,0xab,0x3a,0x86,0x72,0x9a,
        0x2d,0xc8,0xa8,0x3e,0x63,0x47,0x57,0x14,0xd7,0x1e,0x59,0x1e,0xe5,0x7d,0x95,0x6f,
        0x63,0xab,0x00,0x11,0x05,0xb3,0x30,0xf5,0xa7,0x6f,0x34,0xfe,0x01,0xdf,0x1f,0x0b,
        0xee,0x71,0x4c,0x38,0x0e,0xb3,0x10,0x3e,0x4b,0x42,0xd6,0xd0,0x42,0xf8,0x5a,0x54,
        0x32,0xd8,0xb7,0xbc,0x7a,0xe1,0x0b,0xa1,0x97,0x15,0x06,0x87,0x01,0x90,0x43,0xe6,
        0x70,0x54,0xf3,0x09,0xf6,0x53,0x10,0xe7,0xaf,0xae,0x74,0x07,0x26,0xdc,0xd5,0x61,
        0xb1,0x3c,0xe0,0x18,0x6c,0x57,0x04,0x8d,0x05,0x42,0x2d,0xb0,0x70,0xf2,0x37,0xf2,
        0x10,0x85,0x5f,0x32,0x4e,0x60,0x3a,0x8b,0xca,0xa1,0x44,0x02,0x41,0x89,0xaa,0xa3,
        0x16,0x2f,0xb1,0xe1,0x42,0xab,0x2e,0x58,0x03,0x62,0x62,0xa1,0xba,0xfc,0x46,0xea,
        0x0f,0x00,0x68,0x1c,0xdb,0x50,0x0b,0x2f,0xca,0xe2,0xf1,0xb5,0xd7,0xc8,0x7d,0x18,
        0xcf,0xf1,0xa9,0x4c,0x77,0xac,0xb9,0xab,0xbd,0x52,0xbb,0x7e,0x07,0x0c,0x9f,0x13,
        0xb4,0x6f,0xc0,0xf2,0x37,0x55,0xd4,0x26,0x4a,0xf4,0x56,0x81,0x6e,0x59,0xc0,0xdd,
        0xf9,0x1a,0x8f,0x07,0xed,0x48,0x19,0x77,0x68,0x8a,0x1e,0x46,0xc1,0x29,0xea,0x9b,
        0x3e,0x00,0x49,0x36,0xab,0x38,0x04,0xf9,0x17,0xe9,0xf3,0xf0,0xb7,0x1e,0x05,0xfe,
        0xc1,0x55,0x78,0xd8,0xd2,0x35,0x84,0x30,0xb2,0xb6,0x16,0x3a,0xdd,0x16,0xe5,0x50,
        0xf6,0x74,0xda,0x80,0x32,0xca,0x25,0xb2,0x05,0x17,0x9c,0xd5,0x98,0xee,0x1c,0x66,
        0x78,0x3f,0x71,0xe5,0xc4,0x0a,0x42,0xd3,0x1c,0xd7,0xb3,0x82,0x7f,0x6d,0x8a,0x1c,
        0x01,0x66,0x86,0xba,0x04,0x8f,0xce,0xd2,0x80,0xb0,0x8a,0x73,0xf9,0x04,0x33,0xfc,
        0xa9,0xce,0x5a,0x8d,0x9b,0x93,0x8b,0x34,0x22,0x66,0xe4,0xa2,0xac,0x42,0xdc,0x67,
        0xda,0xec,0xc5,0x8d,0xac,0x66,0x5d,0xe5,0x78,0xc7,0x40,0x79,0x13,0x22,0x32,0x1d,
        0x44,0x82,0x0b,0xb0,0xdb,0xfa,0xec,0xcf,0x77,0x36,0x90,0xa8,0x49,0xaf,0x98,0xe9,
        0x4e,0x37,0xb2,0x1c,0xe1,0xde,0x7c,0xde,0xb3,0x66,0x39,0x71,0xff,0xb4,0xbe,0x21,
        0xb6,0x74,0x7f,0xd1,0x3f,0xbe,0x57,0x2a,0x14,0x4f,0x98,0x03,0xa8,0x20,0x97,0xad,
        0x15,0xd4,0x78,0xac,0xf9,0x33,0x5b,0x3d,0xa2,0xec,0x04,0x37,0x18,0xcf,0x1e,0xe2,
        0xfc,0x4e,0x55,0xf9,0x09,0x28,0x1e,0x4a,0x7e,0x54,0x78,0x78,0x17,0x57,0xe4,0xb6,
        0x13,0x80,0xd7,0xc8,0x6e,0xf2,0x67,0x8c,0x08,0xe4,0x9a,0x30,0xe2,0x95,0xaa,0x43,
        0x18,0x5a,0x8c,0x29,0xb0,0x29,0x3f,0xf0,0xb8,0xb8,0xa5,0xc2,0x24,0xaf,0x11,0xa0,
        0x5d,0x94,0xa8,0x7c,0xcc,0x4f,0xd4,0x32,0x4b,0xc4,0xdc,0xdd,0x0a,0x8b,0x8e,0x09,
        0x0c,0xdf,0x46,0x80,0xe3,0xac,0x49,0x01,0xcd,0x12,0x0f,0xa0,0x03,0xcf,0xfc,0x1d,
        0x81,0xdd,0x25,0xaf,0x03,0x79,0xd7,0x3b,0xc8,0x87,0x4c,0xe0,0x90,0x91,0x97,0x43,
        0xd2,0x9e,0xd5,0x0f,0x4d,0x45,0x0a,0x8a,0x06,0x53,0x6d,0xda,0x2a,0x13,0x61,0xf9,
        0xc6,0x5f,0xa8,0x60,0x94,0x8f,0x0d,0x51,0xf8,0x2a,0x81,0x8a,0x27,0x7c,0xdc,0x19,
        0xce,0x69,0xa9,0x8e,0x47,0xa9,0x6b,0x46,0x67,0x51,0xa8,0xdd,0x0c,0xa3,0xda,0x56,
        0x39,0x0f,0xb6,0x72,0xc4,0x4d,0x41,0x3c,0xc3,0x9c,0x2f,0xb6,0xb1,0xf4,0xdb,0x2b,
        0xd6,0xa4,0x6e,0x38,0xab,0x12,0x5a,0xe4,0x16,0xa3,0xfc,0xc0,0xba,0xb6,0x7c,0x28,
        0xba,0xa0,0xdc,0x86,0xf5,0xc2,0x10,0x87,0xbd,0x01,0x01,0xcf,0x52,0xc6,0xd2,0xca,
        0xac,0x06,0xa3,0x4a,0x52,0xc6,0x53,0x30,0x2c,0x95,0x4b,0x50,0xb1,0x5e,0xd8,0x1c,
        0x93,0x40,0x39,0xd4,0x59,0x67,0x25,0x2d,0x21,0xed,0x7f,0x69,0x2e,0xc3,0x77,0x38,
        0x5c,0xdb,0xf9,0x30,0x4b,0x5f,0xb6,0x20,0x85,0x23,0xb4,0xdf,0xca,0xf8,0x76,0x13,
        0x0e,0x3f,0x74,0x97,0xf6,0xf1,0xa7,0x52,0x8a,0x2e,0x3a,0xbe,0x45,0x51,0x7f,0x78,
        0x06,0x38,0x50,0x82,0xcc,0xbb,0x54,0x5d,0x97,0xfd,0xa1,0x67,0xed,0x30,0x13,0xd7,
        0xc5,0x4a,0xfe,0x17,0x1b,0xac,0xc2,0x16,0x55,0xda,0x6e,0xbf,0xe5,0x3f,0x81,0xc5,
        0x3c,0xd4,0x8b,0xae,0x1d,0xdd,0x0b,0x7a,0xe5,0xcb,0xe2,0x72,0xb5,0xea,0x95,0xb7,
        0x63,0x4d,0x2d,0xd4,0x02,0xaa,0x77,0x66,0x69,0x3a,0xa3,0xf1,0x75,0x5b,0x54,0xa9,
        0x3b,0xe3,0x1d,0x4c,0x39,0xf1,0xfa,0xc4,0x2c,0x3c,0xcd,0x2f,0x2a,0x4a,0x32,0xa5,
        0xa0,0x62,0xe5,0x3f,0xb6,0x90,0xa8,0xab,0x4e,0xed,0x8e,0x62,0x50,0x36,0xdf,0x69,
        0xb1,0x12,0x56,0x5e,0x06,0x2e,0xc6,0x9d,0x61,0x99,0x02,0x90,0xbe,0x7f,0xb6,0xa2,
        0xed,0xaa,0xb0,0xce,0xf0,0xea,0x32,0xeb,0xab,0x76,0x62,0x30,0x96,0x9d,0xc7,0xaa,
        0x41,0xc0,0xf2,0xd1,0x79,0xde,0x88,0xef,0x1d,0xf5,0xc3,0x0a,0x13,0x39,0xcc,0x5b,
        0x0d,0x4b,0xb3,0x46,0xea,0xc9,0x08,0x1c,0x0b,0xfc,0x28,0x68,0xeb,0x3a,0x12,0x68,
        0x38,0xd2,0xfe,0x58,0xf0,0xb7,0xf8,0x07,0x3c,0x12,0x00,0xad,0x00,0x9e,0x20,0xdf,
        0x73,0x06,0x4d,0xd8,0x3f,0xbe,0x7b,0xad,0xa1,0x55,0x93,0x8c,0x97,0x7e,0x2a,0x56,
        0x42,0x3b,0xa6,0x91,0x43,0x08,0xba,0x34,0x4d,0xfd,0x02,0xd0,0x96,0x29,0xcb,0xd8,
        0xce,0x53,0x8b,0xb3,0x26,0x53,0x13,0x79,0x53,0xa5,0x1f,0x32,0xb5,0x5d,0xab,0x4e,
        0x41,0xd1,0x47,0x61,0x50,0x9c,0xbe,0xb2,0xdb,0x0e,0xb0,0x98,0x04,0xfc,0xdc,0x87,
        0xf4,0x01,0xd3,0xa7,0x83,0x6e,0xf5,0xdf,0xa9,0x33,0x7f,0xa4,0xb8,0xe5,0x9d,0x88,
        0x92,0x41,0x25,0x77,0x53,0xcf,0x77,0x24,0xcf,0xc9,0xef,0x0a,0xcf,0x30,0xa0,0x9e,
        0xa2,0x9d,0xc8,0x75,0x3c,0x95,0x96,0x07,0xc5,0xe3,0xec,0xee,0x56,0x10,0xb9,0xe6,
        0x52,0x8f,0x32,0x1f,0x63,0xf1,0x9d,0x97,0x51,0x29,0x78,0x04,0x13,0x11,0xa9,0x6e}, 
        /*TST_dataSize*/
        1536*sizeof(DxUint8_t),       
        CRYS_AES_CTR_mode
    },
    #endif
    #if TST_USE_AES_192_KEY
    #if TST_USE_AES_16BYTE_DATA
    { 
        {"Acceptance test - AES/CTR/192Key/16ByteData "},
        /*TST_Key*/     
        {0x2c,0xb6,0x54,0x77,0x07,0x9c,0x80,0x9e,0xd1,0xc1,0xc6,0xec,0xc9,0x7c,0xf3,0x8c,
         0xb7,0x7d,0xc8,0xc6,0x1b,0x5e,0x45,0x2f},
        CRYS_AES_Key192BitSize,
        /*Input Block-CTR*/
        {0x44,0x0e,0xb4,0x64,0x5d,0x89,0x2c,0x81,0xb8,0x9e,0xc0,0x8e,0x78,0xf0,0x55,0x6c},
        /*TST_input_data*/
        {0x2f,0xd6,0xec,0x7c,0x86,0xa4,0x49,0x52,0x7b,0xa3,0xf7,0x87,0x5f,0xac,0xfb,0x59},
        {0},
        /*TST_Expected_output_data for enc Input data for decrypt*/
        {0xbe,0x1a,0xfa,0xf6,0x71,0x01,0x7c,0x27,0x16,0x99,0x11,0x5a,0x47,0xcb,0x3e,0x18}, 
        /*TST_dataSize*/
        16*sizeof(DxUint8_t),       
        CRYS_AES_CTR_mode
    },
    #endif
    #if TST_USE_AES_32BYTE_DATA
    { 
        {"Acceptance test - AES/CTR/192Key/32ByteData "},
        /*TST_Key*/     
        {0xd6,0xf5,0x07,0xb0,0x88,0x32,0x91,0x90,0xb0,0xa5,0xb8,0xd4,0xf7,0xe0,0x1c,0xb1,
         0x86,0xf5,0xd1,0xf6,0xcc,0x2d,0x4d,0x54},
        CRYS_AES_Key192BitSize,
        /*Input Block-CTR*/
        {0x8a,0x3b,0x90,0x89,0x27,0x63,0x59,0xa5,0xab,0x8a,0x09,0x69,0x20,0x24,0x90,0x16},
        /*TST_input_data*/
        {0x3a,0xa9,0x13,0xa1,0xc4,0x64,0x17,0x3a,0x4d,0x0d,0x94,0x99,0xf3,0x16,0xc9,0x4d,
         0x14,0x38,0x16,0x8f,0x1b,0xff,0x69,0xdd,0x9a,0x88,0xfa,0xe4,0x9a,0x8a,0x38,0xa3},
        {0},
        /*TST_Expected_output_data for enc Input data for decrypt*/
        {0x8f,0xd4,0x5f,0x7c,0xeb,0x0d,0xc6,0x64,0x1e,0x59,0xbd,0x29,0x10,0x19,0xbf,0x2b,
         0x2b,0x11,0x3d,0x0f,0xf0,0x6e,0x2b,0xac,0xd6,0x66,0x10,0x03,0xc1,0xb2,0x9c,0x5a}, 
        /*TST_dataSize*/
        32*sizeof(DxUint8_t),       
        CRYS_AES_CTR_mode
    },
    #endif
    #if TST_USE_AES_512BYTE_DATA
    { 
        {"Acceptance test - AES/CTR/192Key/512ByteData "},
        /*TST_Key*/     
        {0x71,0xc5,0x31,0xe3,0x5d,0xed,0x39,0x8e,0x54,0x68,0xe8,0x63,0x72,0x73,0xd7,0xa3,
         0xca,0x65,0x53,0x78,0xaa,0xe2,0xbe,0xce},
        CRYS_AES_Key192BitSize,
        /*Input Block-CTR*/
        {0xb0,0x0c,0x11,0xe7,0x28,0xcb,0xa2,0x0b,0x78,0xe4,0x75,0x74,0xd2,0x55,0xe1,0x31},
        /*TST_input_data*/
        {0xc5,0x79,0xf3,0x38,0xff,0xda,0xe6,0x5b,0xe0,0x97,0xd3,0x69,0x75,0xd5,0x59,0x56,
         0x75,0xc7,0xef,0x8c,0x2c,0xd3,0x77,0x32,0xb9,0xf0,0x17,0xae,0x79,0x53,0x44,0x68,
         0xc3,0x4a,0x1f,0xd1,0xd6,0x68,0x05,0xa5,0x0f,0xe2,0x61,0x6d,0x60,0x39,0xc5,0x47,
         0xfd,0x19,0x3a,0xe9,0x58,0x82,0xd4,0xe4,0x50,0x25,0x89,0x26,0xa5,0x11,0x42,0xc3,
         0xb0,0x8e,0x33,0xf5,0x51,0x49,0x68,0x61,0x28,0xb2,0xa1,0x9b,0x08,0xa3,0x60,0xed,
         0xa8,0x42,0x40,0x54,0x9c,0x28,0x88,0xcc,0x84,0xc3,0x00,0xcd,0x84,0xf8,0x04,0x16,
         0xf4,0x0d,0xd6,0xa9,0x58,0xc7,0x39,0x17,0x92,0xcf,0x3b,0xfd,0x56,0x5a,0x52,0xcf,
         0xdf,0x09,0xaa,0xd4,0xe0,0x0e,0xbe,0x72,0xbe,0x91,0x26,0xac,0xfc,0x52,0xaf,0xe9,
         0xf7,0x8f,0xb1,0xf7,0xd3,0x28,0x9d,0x4f,0xb5,0x01,0xd6,0x9b,0x32,0xa8,0xc2,0x75,
         0x08,0x38,0x20,0x72,0x0c,0x7d,0x9c,0x5f,0x64,0x58,0xa0,0xca,0xf6,0x65,0x6e,0xc5,
         0x20,0xdc,0x6c,0xe6,0xaa,0xb5,0xbe,0x92,0xf9,0x10,0x1a,0x7b,0x85,0xd3,0xd8,0x68,
         0x8d,0x95,0x49,0x35,0x09,0xbb,0x4a,0x1a,0xe0,0xe0,0x19,0x30,0x5b,0x7b,0x67,0x30,
         0xd9,0xbb,0xae,0x7e,0xc5,0xb6,0xc4,0x67,0xc6,0xc3,0xb1,0xa7,0x35,0x24,0xbe,0x2f,
         0xd4,0xe9,0xce,0x25,0xbd,0x10,0xf1,0x2b,0x98,0xf1,0x37,0xe4,0x11,0xda,0xc2,0xb4,
         0x8a,0xf6,0x1f,0xc8,0x0c,0x73,0xd7,0x57,0x84,0xe3,0x40,0x27,0x2c,0xe3,0x99,0x52,
         0x47,0xfb,0x56,0x4a,0x11,0xc6,0xb9,0x1b,0xf6,0x53,0xa2,0xf0,0x02,0xca,0xa8,0xd9,
         0x99,0x53,0x68,0xcb,0x68,0x33,0x1d,0xe9,0x9b,0x38,0x72,0x01,0x50,0x58,0x94,0x5a,
         0x4c,0x95,0x8a,0xad,0xed,0x24,0xc9,0x71,0x60,0xcd,0x03,0x5b,0x14,0x95,0x41,0x26,
         0x6f,0x9b,0x31,0x90,0xbf,0x40,0xc1,0xa5,0x73,0x8a,0xec,0x3f,0x8b,0xcb,0xd4,0xce,
         0x4d,0x7d,0x12,0x55,0x3a,0x71,0x4a,0xb5,0x40,0x29,0x02,0x2e,0x31,0x82,0xb4,0x23,
         0x74,0x95,0x21,0x1d,0xfb,0xe0,0xe9,0x13,0x74,0xa1,0x59,0xe9,0xc4,0x83,0x84,0x36,
         0xb1,0x7c,0x95,0x4a,0xde,0xf6,0x63,0x70,0xfd,0x2d,0x46,0x70,0x40,0xd8,0x2a,0x58,
         0x10,0x0b,0xe1,0x7c,0x02,0x5c,0xbe,0xbc,0x07,0x45,0x5f,0x05,0xe3,0xc9,0xca,0x1b,
         0xe0,0x5a,0xbc,0x95,0xc3,0xfb,0x3d,0x29,0xff,0xa2,0x78,0x29,0x29,0xe0,0xca,0x4e,
         0xac,0xc3,0x19,0xb5,0xbe,0xfc,0x67,0x27,0x92,0x3d,0xa6,0x9d,0xcf,0xe5,0xce,0x03,
         0x42,0xdf,0x2e,0x3d,0xcf,0xc7,0xff,0x68,0xae,0x4f,0x3f,0x62,0xd4,0xe2,0xbd,0x8c,
         0xae,0x87,0x70,0xce,0x15,0x07,0x0c,0xdc,0x7f,0x52,0xd7,0xb8,0x72,0x1f,0xb9,0x79,
         0x3f,0xd3,0x93,0x4a,0xec,0xa4,0xd2,0xb5,0x72,0xfe,0x44,0x22,0x29,0x25,0x2a,0x9a,
         0x80,0x1d,0x8e,0xd1,0xf1,0xc7,0xd7,0x64,0x34,0x4c,0x9a,0x5f,0xb3,0xbe,0xb3,0x02,
         0x3f,0xfd,0x95,0xc5,0x01,0xd8,0xde,0x99,0xb3,0x75,0x2f,0x71,0x10,0xf3,0x3a,0x01,
         0x88,0x4d,0x1c,0xc5,0x39,0x82,0xee,0x46,0x1b,0xf3,0x96,0x99,0x7a,0x0c,0xe3,0x28,
         0xaa,0x26,0xda,0xb5,0xf6,0xac,0x4a,0x9b,0xd9,0x7d,0xa7,0x57,0x71,0x92,0x14,0x48},
        {0},
        /*TST_Expected_output_data for enc Input data for decrypt*/
        {0x2f,0x9e,0xcb,0x9d,0xde,0x63,0xd6,0x8b,0x9b,0x1e,0xef,0x28,0x65,0xd4,0x81,0xde,
         0xd6,0x3e,0x2a,0x6f,0xaf,0xcf,0x1f,0xc9,0x35,0xc4,0x2c,0x5f,0x6e,0x62,0x95,0xbf,
         0xdb,0x10,0x0c,0x3e,0xad,0xb3,0x8e,0xfb,0x72,0x0b,0xab,0x94,0xc5,0x26,0x30,0xac,
         0xd4,0xe7,0x62,0x2d,0xee,0xab,0x37,0x60,0xa8,0x07,0x59,0xbd,0xb3,0x03,0x7a,0x33,
         0x10,0x5f,0xff,0x8e,0xc6,0x46,0x9b,0x13,0xf1,0xc9,0xb9,0x1f,0x1d,0xd0,0xd0,0x6e,
         0x87,0xee,0xe6,0x86,0xc0,0x52,0xe6,0xd4,0x9f,0xc0,0xeb,0xf5,0x36,0xab,0x2d,0xf2,
         0x24,0xc4,0xe5,0x60,0x16,0x89,0x00,0x32,0x72,0xd0,0x0e,0xdd,0x15,0x24,0xb9,0xb0,
         0x1e,0x0e,0x72,0xd5,0xec,0x81,0xe1,0x1f,0x8c,0x14,0xe2,0x7a,0x21,0xca,0xb7,0xae,
         0x55,0xd4,0xa8,0xd6,0x24,0x9d,0x48,0xe2,0xb0,0x48,0x41,0xd8,0x30,0x11,0x39,0x6d,
         0x2e,0x53,0xf8,0x52,0xac,0xc2,0x9f,0xb1,0xe2,0xf6,0xa5,0x13,0x9e,0xe0,0x88,0xb7,
         0xce,0xde,0x07,0x66,0xa9,0x25,0xd9,0xdf,0xe0,0x03,0x08,0x27,0xe5,0x37,0xad,0x3c,
         0x6c,0x19,0x7f,0x77,0x58,0x6b,0x59,0xa5,0x41,0x50,0xbf,0xdf,0xe9,0x8b,0x57,0xcd,
         0x8c,0xb3,0xfd,0x97,0x3b,0x32,0x2e,0x42,0xbb,0xd4,0x0e,0xe9,0xee,0xe5,0x51,0x77,
         0x54,0xc5,0x57,0x40,0x89,0x42,0xb0,0xba,0xeb,0xf9,0x19,0x61,0x1e,0xc0,0x6d,0x7e,
         0xcf,0xaa,0xb8,0xd7,0xf6,0x86,0xbe,0x9d,0xda,0xba,0x22,0x96,0x4b,0xef,0xed,0x24,
         0x9d,0x67,0xe6,0x8e,0x29,0x4e,0x02,0x78,0x77,0x61,0x61,0x0d,0xd5,0xa7,0x6f,0x83,
         0x4f,0xe3,0xed,0x30,0x62,0xa4,0x47,0xa2,0xd1,0x2b,0x42,0x15,0xdc,0xe1,0x1e,0x68,
         0xd7,0x4b,0x9f,0x99,0xc4,0x0d,0x5c,0xfb,0xb9,0x86,0x8b,0x28,0x9f,0x35,0xee,0x9c,
         0xb3,0x3a,0x43,0x00,0xe5,0x3e,0x79,0x07,0x59,0x9b,0x58,0x28,0x6e,0xaf,0xf6,0x29,
         0x1d,0x72,0x86,0x98,0x93,0x8c,0xe4,0x87,0x00,0x23,0xa4,0x4f,0x1c,0x93,0xe2,0xcf,
         0x2e,0x16,0xb4,0xab,0x60,0x92,0x69,0x74,0x1f,0x3e,0x62,0xb9,0x53,0x78,0x61,0x05,
         0x12,0xf1,0xfb,0xcb,0x9a,0x9f,0xa2,0x8b,0xbd,0x0f,0x72,0xf1,0x6c,0x80,0xc9,0x74,
         0x60,0x8a,0xc4,0x72,0x19,0xa0,0x51,0x9e,0x2e,0x24,0xb8,0x00,0x15,0x6b,0x87,0x17,
         0xda,0x3c,0x5b,0xb9,0x77,0x94,0x7a,0xae,0xc4,0x2a,0xa2,0x52,0xeb,0xa4,0x0e,0x21,
         0x83,0x94,0x7e,0x56,0xa0,0xcf,0x5b,0x1a,0xf1,0x1a,0x1d,0x82,0xec,0x28,0x81,0x83,
         0x9c,0x31,0xf8,0x8c,0xe1,0x18,0x5f,0xe2,0xcf,0x16,0x92,0xf9,0xdf,0xf2,0x1f,0x19,
         0x9e,0xe9,0x94,0x9d,0xdc,0x63,0x5e,0x2d,0xd9,0xc6,0xd5,0x03,0x36,0x0d,0xe1,0x0d,
         0x79,0xf8,0x94,0xda,0x09,0x60,0xe9,0x84,0x93,0x0c,0x16,0xfd,0x75,0xa6,0x90,0x56,
         0x21,0x6e,0x9f,0x57,0x75,0xe3,0x7a,0x71,0x5e,0xe1,0x26,0xdc,0x96,0x5c,0x40,0xb3,
         0xd6,0xb1,0x9a,0x4b,0x3d,0x3f,0x9a,0xa5,0xae,0xab,0xc4,0x3b,0x87,0x0f,0xa6,0x39,
         0x14,0xa6,0x22,0xa9,0xb9,0x75,0xed,0xb2,0x9a,0x97,0x2d,0x88,0xd3,0x00,0x8a,0x5e,
         0x9f,0xf0,0x34,0x34,0x73,0x30,0x33,0x35,0xcc,0x1d,0x51,0x6f,0x2a,0xdc,0x25,0x3f}, 
        /*TST_dataSize*/
        512*sizeof(DxUint8_t),      
        CRYS_AES_CTR_mode
    },  
    #endif
    #if TST_USE_AES_1536BYTE_DATA
    { 
        {"Acceptance test - AES/CTR/192Key/1536ByteData "},
        /*TST_Key*/     
        {0x87,0x35,0xee,0x2c,0x22,0x5d,0xc8,0xe4,0x6a,0x7c,0xc6,0x16,0x92,0x06,0x5f,0xe8,
        0x7a,0x6f,0x01,0xa8,0x8c,0x88,0x0e,0xbb},
        CRYS_AES_Key192BitSize,
        /*Input Block-CTR*/
        {0xbd,0x6f,0x27,0x44,0x0f,0x78,0x4d,0x4f,0xb9,0x58,0x58,0x6d,0xdc,0xb8,0x1c,0xb7},
        /*TST_input_data*/
        {0x62,0x26,0x62,0x80,0x61,0xff,0x97,0xe6,0x65,0x9a,0x11,0xd5,0xbd,0x58,0xc0,0x4e,
        0x01,0xc5,0x0e,0xe4,0x01,0xc0,0x6f,0x08,0xfb,0xdd,0x3a,0x8a,0x11,0x07,0xb7,0x5d,
        0xf9,0x6a,0x79,0x9b,0xf7,0x90,0xee,0xc8,0x08,0xc9,0x34,0x5b,0x60,0xd1,0x2e,0x7a,
        0x17,0xad,0xd8,0x06,0x20,0xd6,0xd7,0xd7,0x7a,0x99,0x55,0x49,0xaa,0xbe,0x0b,0xf7,
        0x68,0x68,0x9f,0xc6,0x99,0x3c,0x31,0x26,0x7d,0xc5,0x31,0x94,0x2a,0x17,0x73,0x63,
        0x39,0xb3,0x85,0xbd,0xbf,0xab,0x40,0xe5,0x7f,0x07,0x9d,0xbe,0x5d,0x66,0xca,0x91,
        0x16,0xe9,0x7d,0x0b,0x2f,0x4c,0x89,0x85,0x2b,0x56,0xaf,0x89,0x01,0x74,0xb6,0x91,
        0xcd,0xa1,0xbd,0x11,0xc6,0x88,0xd1,0xb8,0x70,0xed,0xbb,0xf3,0x13,0x49,0x1b,0xb4,
        0x6b,0xb4,0xbb,0x71,0xa1,0x08,0x1d,0x6f,0x7a,0x44,0x56,0x40,0xcf,0x2e,0x1f,0x8b,
        0x3d,0x3d,0x2a,0x0b,0x1d,0xb5,0xb2,0xda,0xb6,0x14,0x56,0xf0,0xb2,0xad,0x27,0xe6,
        0xcf,0x93,0x00,0x00,0xd7,0xb8,0x16,0x6b,0xd2,0x56,0xcf,0xc3,0x7a,0x8e,0xd8,0xd9,
        0xef,0x50,0x72,0xb2,0xac,0x7a,0x0c,0xd3,0xba,0x44,0x17,0xbb,0x23,0xdb,0x16,0xb2,
        0xaa,0x4c,0xf4,0xc1,0xb9,0xa4,0x9b,0x02,0x9b,0x55,0xc2,0x1a,0xeb,0xdc,0x06,0x03,
        0x4d,0xa1,0x3d,0x0f,0x5c,0x1f,0x07,0x29,0xe3,0x44,0xa5,0x5e,0x4f,0x1b,0x0f,0x9d,
        0x64,0xa8,0x40,0xbb,0x30,0x14,0xd5,0xba,0x3d,0x0a,0xd6,0x4b,0x0b,0x60,0xd4,0x91,
        0xbd,0xfa,0x34,0x28,0x13,0xeb,0xca,0x66,0x98,0xde,0xaa,0xe1,0x1d,0xb5,0x3a,0x31,
        0x65,0x6f,0x8c,0xf7,0x22,0x4f,0xeb,0x1e,0x20,0x3a,0xb4,0x60,0xc1,0x62,0x68,0x0c,
        0xa9,0x21,0xfe,0x07,0xba,0x27,0x7e,0x11,0x43,0xd8,0xcb,0x4a,0x74,0xf0,0xc0,0xf5,
        0x16,0x69,0x7f,0x7b,0x79,0x9e,0x06,0xb3,0xad,0xb0,0x04,0x60,0xf4,0x29,0xea,0xfc,
        0x78,0xdf,0x44,0xb4,0x3a,0x1c,0x4a,0xb3,0x4b,0xfb,0xb2,0xa3,0x3e,0x15,0xc9,0x71,
        0xdd,0x5d,0xc2,0x51,0x1b,0x49,0x4e,0x03,0x4a,0x33,0x6d,0x54,0x8e,0xfe,0x83,0xe7,
        0x92,0xfc,0xae,0x35,0x79,0x0f,0x57,0xd3,0x18,0x0f,0x07,0xf4,0x62,0x6c,0x7c,0x2e,
        0x23,0x15,0xfd,0x81,0xf2,0x98,0xea,0x95,0x60,0x8a,0x97,0x43,0x76,0x29,0x5a,0x57,
        0x5f,0x40,0xe3,0x94,0x61,0x4b,0xcc,0xf9,0x12,0xdc,0x71,0x43,0xc8,0x3d,0x02,0xb3,
        0x51,0x57,0xd7,0x11,0xe4,0xd2,0x03,0xf1,0x58,0x7e,0x2b,0x35,0x94,0xf2,0x99,0xd3,
        0x47,0x73,0x8c,0xd9,0xd9,0x17,0xd2,0xae,0xa1,0x29,0x99,0x9a,0x58,0xd0,0x83,0x88,
        0xcd,0xec,0xf8,0x0b,0xdb,0x41,0xc0,0xa0,0x98,0xd7,0xd1,0x33,0xd0,0xa0,0x65,0xe4,
        0xb2,0x5c,0x50,0x0a,0xc8,0xba,0x91,0x78,0x2d,0xc0,0x27,0x00,0xfa,0x6c,0x26,0x36,
        0x01,0x9c,0x09,0x76,0xbe,0x2b,0x4a,0x29,0x8a,0x5d,0x30,0x43,0x12,0x7d,0xe9,0x10,
        0x08,0xc4,0xd8,0x31,0x18,0x7d,0x30,0xe2,0x1e,0x67,0xc2,0x7e,0x96,0x5b,0x13,0x44,
        0x53,0x2e,0xb2,0x5b,0x75,0xd9,0xc8,0x14,0x95,0xd7,0xf1,0x70,0x42,0xcf,0x4a,0xe2,
        0xb1,0x73,0xcc,0x55,0xb0,0xa8,0xd8,0x71,0xdc,0xe7,0x12,0x1a,0x14,0xe3,0x73,0x3a,
        0x2d,0x6c,0x9a,0xc1,0xe7,0x93,0x63,0xea,0x20,0x0f,0xbb,0xbf,0x48,0xdf,0xb3,0xdf,
        0x15,0x31,0xd3,0x7f,0x78,0x83,0xb0,0xaf,0xcf,0x08,0xc0,0xde,0x5c,0x4d,0x6e,0xa1,
        0xf6,0x1c,0x6a,0xb0,0xfe,0xa1,0x43,0x31,0x95,0xcb,0x37,0x3a,0x0c,0xf5,0x4a,0x91,
        0x9c,0xc6,0x95,0xb6,0x58,0x55,0xe1,0x23,0x5f,0x91,0x74,0xd2,0x56,0xe1,0x2b,0x00,
        0x16,0x07,0xc9,0x31,0xa1,0x4a,0x8f,0x74,0x5b,0xd4,0x0d,0xe8,0x77,0x59,0x37,0x7f,
        0xaf,0xf9,0xbb,0x02,0x38,0x68,0x92,0x55,0xf5,0x4c,0xd5,0xfd,0xeb,0xe6,0xd3,0xdf,
        0xf5,0xf5,0x60,0x4a,0xb8,0xd7,0x70,0x38,0xda,0xf2,0xe4,0xd1,0x6f,0x52,0xa3,0x31,
        0xb4,0x93,0xed,0x6b,0x00,0x02,0xec,0xce,0xf7,0xff,0x8c,0x67,0x01,0xa6,0x8d,0xc6,
        0xfb,0xae,0xd7,0x05,0x2c,0x90,0x0d,0x07,0x7a,0xec,0x64,0xfe,0xdd,0x29,0xb6,0x30,
        0x15,0x5d,0xd2,0xfa,0x98,0x6c,0x17,0x15,0xcf,0x73,0x41,0x18,0x81,0x67,0x82,0x3e,
        0x90,0xf9,0xd5,0x6a,0xe3,0xbd,0x8f,0x68,0xa3,0x8c,0x36,0x76,0xaa,0x27,0x97,0x03,
        0x38,0x1c,0x13,0xb6,0xe8,0xee,0x3a,0xb2,0xe3,0x70,0x9b,0x19,0x54,0x72,0xd9,0xce,
        0x1c,0x9f,0x02,0x80,0xc6,0xa6,0x1d,0xe4,0xbd,0x98,0x02,0x41,0xbc,0x91,0x6f,0x32,
        0x87,0x9b,0x57,0xa8,0xd9,0xcf,0x7d,0x2e,0x9d,0xbe,0x42,0x71,0x60,0x0f,0xbb,0xff,
        0x07,0x69,0x07,0x4f,0xbd,0x93,0xe0,0x02,0x30,0xd9,0x6f,0x68,0xfd,0xb2,0x65,0x46,
        0x68,0xa1,0x47,0xd6,0x51,0x59,0x09,0x10,0x64,0x24,0xdf,0x28,0x8f,0x85,0x50,0x58,
        0xb9,0x1c,0x8c,0xdf,0xb1,0xcb,0xff,0x4a,0x64,0x17,0x26,0xf2,0x54,0xd1,0xa2,0xc6,
        0x45,0xf5,0x8b,0x4a,0x39,0xd2,0x06,0xe0,0x9f,0x6b,0x1a,0x47,0xc8,0x1e,0xbf,0x61,
        0x9a,0x83,0x38,0x39,0x88,0x97,0xa3,0x44,0xc2,0x1a,0xcf,0xe7,0xa8,0x35,0x4d,0x3a,
        0x85,0x60,0xca,0x0c,0x7a,0x83,0x9c,0x27,0xb8,0x5b,0x9a,0xd4,0xf2,0x20,0x31,0xa2,
        0x13,0x65,0xb4,0x64,0x2c,0x3f,0xf4,0x79,0xb0,0xa9,0x11,0x50,0xe3,0x27,0x8f,0x2a,
        0x90,0xaa,0xac,0x22,0xfa,0xb4,0xf1,0x6b,0x16,0xbc,0x08,0xda,0xf7,0xd4,0xcd,0xa4,
        0x8a,0x89,0xa7,0x68,0x83,0x0b,0x19,0x70,0x97,0x8e,0x94,0x34,0xec,0xef,0x90,0x1f,
        0xce,0x9b,0xdb,0x96,0xa3,0xad,0x30,0x37,0x21,0x56,0x0b,0x5e,0xbe,0x82,0xbc,0xee,
        0x68,0xb8,0xba,0x4e,0x77,0x42,0x3b,0xb1,0xe0,0x8f,0x01,0x9b,0xab,0xd5,0x77,0xa1,
        0xa7,0xfa,0xfc,0x70,0x5c,0xb5,0x7f,0x10,0x41,0xf1,0x4c,0x6a,0x2f,0x72,0x25,0x08,
        0x16,0xba,0x95,0x1d,0xef,0x2e,0x81,0xc5,0xf1,0x75,0x00,0x8d,0x08,0x21,0x6d,0x36,
        0x83,0x91,0xba,0xb6,0x0c,0x15,0x06,0x80,0xde,0x54,0x72,0x05,0x32,0xeb,0x31,0x7b,
        0xfa,0x57,0xdf,0xdd,0xd2,0x15,0x14,0x33,0x34,0x07,0x38,0x13,0xeb,0x1a,0x99,0x68,
        0xca,0x26,0xba,0x72,0x9d,0x16,0xef,0x0e,0x60,0x48,0x26,0x38,0xaf,0x37,0x08,0xce,
        0x7e,0x57,0x41,0x96,0x0a,0x40,0x1b,0x83,0x0f,0x0f,0x52,0x34,0x3c,0x09,0x24,0xbe,
        0xe4,0x82,0xa7,0xab,0xf6,0xfe,0x5f,0x43,0x2f,0x95,0x10,0x0a,0x8e,0x9c,0xd1,0x89,
        0x09,0x81,0x62,0x51,0x7e,0xf7,0xbf,0x3e,0xec,0x53,0xf5,0xf9,0xe3,0x36,0x35,0xc0,
        0x39,0x6d,0x27,0x6a,0xff,0x15,0x80,0xa5,0xb3,0x03,0xd7,0x83,0xb7,0x63,0xb5,0x35,
        0x02,0x9e,0xeb,0x16,0x16,0x82,0x28,0xeb,0x32,0x9d,0xca,0x68,0xc8,0xe9,0xf5,0xf7,
        0x31,0xaf,0xe2,0xb6,0xa0,0xa5,0x7a,0xbe,0x55,0x59,0x24,0xab,0x13,0xd3,0xdb,0x59,
        0xd3,0x76,0x83,0xeb,0xba,0x28,0x7d,0x12,0x49,0xb3,0x79,0x8c,0xd4,0x6a,0x8b,0xea,
        0x35,0x0f,0x82,0x97,0xc1,0xf4,0x75,0x16,0x7b,0x61,0x9e,0x8b,0x88,0x36,0x6b,0x7d,
        0xe3,0xd1,0xd3,0xda,0x52,0x32,0xe7,0x3b,0x99,0x5d,0xa9,0x6a,0xed,0x00,0x20,0x22,
        0xab,0x56,0xac,0x15,0x4a,0x4b,0x98,0x33,0x8f,0xe1,0xee,0x2a,0xff,0xd2,0x8f,0x29,
        0x9a,0x77,0x82,0xea,0xc6,0xe8,0x8d,0xef,0x8a,0x65,0x02,0x0c,0xfc,0xf5,0xdc,0x25,
        0xfd,0x4c,0x0a,0x39,0x23,0xf2,0x0b,0x9f,0xf7,0xa2,0xbb,0x90,0x61,0xf1,0x6d,0xe6,
        0x60,0x30,0x39,0x23,0xfe,0x92,0x98,0xb5,0x84,0x92,0x2e,0x79,0xea,0x8f,0xe6,0x7d,
        0x91,0xb9,0x44,0x0a,0x35,0x31,0xf7,0xe2,0x1d,0x6c,0xae,0xc6,0x94,0xd9,0x2d,0x3b,
        0x9d,0xc3,0xa0,0x8e,0xe3,0x78,0x2f,0x16,0xef,0xab,0xd2,0xb9,0x9d,0x17,0x67,0xb1,
        0xd1,0x65,0x02,0x90,0x66,0x50,0x84,0x82,0x67,0x07,0x6f,0xd3,0x82,0xd2,0xf8,0xb1,
        0xb9,0xf9,0x5e,0x32,0x5b,0xe2,0x7b,0x99,0x33,0x79,0x99,0xd5,0xff,0xd4,0x86,0x4a,
        0x24,0x18,0xeb,0xd4,0x9f,0x96,0xd9,0x09,0x3f,0x3a,0xa5,0xbf,0x11,0x26,0xf6,0xcf,
        0x1c,0x9a,0x1c,0x18,0x4f,0x17,0xa3,0xc6,0xb8,0xc4,0x28,0xd4,0xf7,0x10,0x6c,0xcf,
        0xf1,0x99,0xa7,0xdd,0xc9,0x4d,0x1f,0xff,0x0c,0xce,0xf8,0x93,0x2b,0x1b,0x4e,0x1d,
        0x2f,0x6e,0x81,0x46,0xa8,0x60,0xd0,0x25,0xe6,0x53,0x2a,0xbe,0x6c,0x11,0x40,0xc8,
        0xa2,0xb1,0xdf,0xb4,0xca,0xbb,0x7d,0xea,0x35,0x8c,0x12,0x56,0xb7,0xfb,0x29,0x23,
        0x58,0x3c,0x36,0xc6,0x4c,0x05,0x2a,0x3f,0x26,0xf0,0x45,0x9b,0x48,0x21,0x2b,0xbe,
        0x9e,0x28,0x3b,0x5f,0x8c,0x28,0x1c,0x54,0x24,0x39,0x98,0x10,0x9d,0x0c,0xae,0x6a,
        0x00,0xce,0xe2,0xa0,0x25,0x4e,0xd8,0x9b,0xde,0x61,0x21,0x74,0x72,0x86,0x55,0x38,
        0x4d,0xc6,0x62,0xe8,0xf5,0xde,0x23,0xc4,0x40,0xa0,0x35,0xc9,0xc5,0x97,0x06,0x79,
        0x90,0xea,0x2e,0xda,0x1a,0x82,0x03,0xc1,0x78,0x6f,0x67,0x50,0xd2,0x88,0xe5,0xbe,
        0x17,0x52,0xfd,0x56,0xef,0x24,0xbb,0xc3,0xf1,0x88,0x8f,0x8a,0x17,0xe3,0x58,0xd8,
        0x6e,0x59,0xc2,0x7e,0x12,0xeb,0xd2,0x3a,0x5a,0xe2,0xbf,0x38,0x50,0x71,0x04,0xd8,
        0x64,0x96,0xb3,0xb2,0x61,0x41,0x0c,0xd8,0x9f,0xb8,0x4e,0x5a,0x7b,0x3a,0xcd,0x10,
        0x04,0xe2,0x45,0x93,0xf7,0xcf,0x6e,0x8d,0xee,0x82,0xd0,0x33,0xd4,0x87,0xd9,0x0f,
        0x9c,0x58,0x2d,0x03,0x32,0x7e,0x3d,0x8b,0xb2,0xf9,0x1b,0x42,0xd9,0xe2,0x8d,0xa8,
        0xb9,0x4f,0x60,0x22,0xb0,0x77,0xfe,0x42,0x9a,0x17,0x43,0x49,0x46,0x14,0x8d,0xea,
        0x27,0x61,0x12,0x51,0x4c,0x23,0x77,0x64,0x92,0x13,0x9e,0x49,0x19,0x24,0xbf,0x28},
        {0},
        /*TST_Expected_output_data for enc Input data for decrypt*/
        {0x81,0x68,0x90,0xd9,0xd9,0xea,0xd9,0xbf,0x65,0x53,0x3b,0x95,0xf1,0x30,0x15,0xe3,
        0x44,0x45,0xfa,0x40,0xf6,0x2a,0x37,0x1d,0xee,0xa8,0x0f,0xe8,0xcb,0xdd,0x0b,0xb7,
        0x2e,0xd8,0x35,0x4b,0xe5,0x3c,0x46,0x97,0xc9,0x2c,0xdc,0x22,0x17,0x3e,0xc7,0x7d,
        0xf6,0x50,0xa1,0x51,0x3f,0xaf,0x9e,0x59,0x64,0x8e,0x0b,0x28,0xd6,0x60,0x4b,0x7f,
        0x5e,0x2d,0xdf,0x0c,0x46,0x61,0x8a,0xff,0x6f,0x62,0xa0,0xab,0x8d,0xda,0xe9,0x5a,
        0x50,0x1b,0x81,0xdd,0xf0,0x30,0x81,0x6b,0xa8,0x7e,0x81,0x41,0xd8,0x88,0xa2,0x2e,
        0x40,0xe8,0x95,0x88,0xf2,0xaf,0xb5,0xd1,0xb9,0x11,0x82,0xdd,0x24,0x89,0x5e,0xbd,
        0x5e,0xa9,0x12,0x96,0x97,0xd8,0x46,0xdd,0x12,0x6b,0xc5,0xcd,0x16,0x72,0xba,0x95,
        0x05,0xa9,0x60,0x77,0x31,0xde,0x4c,0xd2,0xf9,0xaa,0x8d,0x4a,0x61,0x7f,0x2c,0xa4,
        0xdc,0xc9,0x4d,0x68,0xc1,0x47,0xe1,0xda,0x47,0x97,0x99,0x3e,0x12,0x20,0x41,0x7e,
        0xb4,0xea,0x15,0x8d,0xe1,0x96,0x82,0xed,0xe6,0xe8,0x17,0xd5,0x06,0xcd,0xab,0x33,
        0x04,0x73,0xd9,0xa0,0x56,0x34,0xf4,0x85,0x01,0xbd,0xde,0xec,0x6d,0xd2,0x0f,0xb9,
        0x02,0x8c,0x97,0x07,0x68,0xc4,0x0d,0x8a,0x42,0x08,0xdb,0xee,0x04,0x16,0x95,0xda,
        0x0e,0xec,0xc7,0xd8,0x07,0x4b,0xeb,0x8d,0x23,0x0e,0x7f,0x32,0x41,0x95,0x63,0xe7,
        0x22,0xc4,0x00,0x66,0x40,0x35,0x32,0x9d,0xff,0x52,0x1c,0x6e,0x14,0xf7,0xe9,0x8e,
        0x7f,0x0c,0xad,0x08,0x31,0x04,0x3f,0x28,0xe7,0x5a,0x9d,0xff,0xcf,0xe7,0xb6,0x4d,
        0x39,0x30,0xbf,0x6a,0x64,0x69,0xe9,0xba,0x66,0x2a,0x6c,0x0a,0x9d,0x56,0xb1,0xdf,
        0x97,0xa4,0xbd,0x55,0x54,0x72,0x90,0x5b,0x3b,0xe1,0xce,0xfb,0x45,0x3e,0x94,0xf3,
        0x2f,0xd2,0xb4,0x45,0xc6,0x48,0x7a,0x69,0xbb,0x41,0x2c,0x63,0xa1,0xcb,0xf9,0xce,
        0x65,0x52,0x47,0x15,0x27,0x25,0x87,0xb0,0xcb,0x6a,0xc5,0x9e,0x87,0x24,0xb3,0x28,
        0x7e,0xd1,0x71,0x88,0xab,0x64,0x41,0xb1,0x2e,0xdd,0x94,0x71,0x56,0x7d,0x97,0xf0,
        0x56,0xfa,0x3e,0x33,0x9e,0x2b,0x95,0xd0,0x68,0x25,0xb8,0xcf,0xa9,0x7b,0x53,0xb2,
        0x31,0x99,0xcd,0x15,0x2f,0x4c,0x9a,0x23,0x08,0x15,0x6b,0x8e,0x6a,0x39,0x34,0xcb,
        0xab,0x59,0xd8,0x41,0x85,0xf6,0xe5,0xb1,0x0e,0x9a,0x7a,0x30,0x96,0xad,0x45,0x55,
        0x42,0x8d,0x34,0x0b,0x68,0x3e,0x18,0xc5,0x48,0xd5,0xe9,0x75,0x8c,0x94,0xbd,0x77,
        0x41,0xd3,0x96,0xac,0x08,0x15,0x9b,0x0c,0xc1,0x6d,0x5b,0xd7,0xab,0x53,0x45,0xf8,
        0x90,0x9c,0x6c,0xcb,0x3e,0x15,0x69,0x58,0x79,0x25,0xe5,0x62,0x6c,0xd2,0xf2,0xc5,
        0x38,0xfb,0x32,0x17,0x7b,0x00,0xb1,0x20,0x60,0xa3,0xee,0xbb,0x3d,0x38,0xb4,0x1b,
        0xcd,0x9d,0xb9,0xe0,0x24,0x43,0x56,0x2b,0x4e,0x29,0x49,0x59,0x0c,0xcd,0x87,0x95,
        0xbb,0x71,0xf5,0x0a,0x67,0xe9,0x9e,0xba,0x48,0x66,0x36,0xa0,0xc3,0x8c,0x53,0x5c,
        0xf8,0x95,0x09,0x6a,0x56,0xf9,0xbd,0xbf,0x38,0x80,0x05,0xaf,0x6d,0x01,0x4f,0xed,
        0x27,0x86,0xec,0x06,0xfc,0x6a,0x63,0x96,0x7a,0x71,0xab,0x52,0x68,0xc1,0x62,0xb0,
        0x6c,0x61,0x0c,0x1b,0xc8,0x3f,0x13,0x0c,0x05,0x44,0x97,0xba,0xe0,0x72,0x4d,0xc5,
        0x38,0x3c,0xf8,0x1b,0xc0,0x8c,0x64,0x22,0xe8,0x66,0x78,0xb4,0x4a,0x04,0xde,0xf8,
        0x82,0x65,0x02,0x65,0x25,0xea,0xbd,0x9d,0x9f,0xf3,0xc8,0xad,0x58,0x62,0x56,0x9b,
        0x0d,0x33,0x9b,0x03,0x63,0x40,0x16,0x43,0x52,0xbe,0xcf,0x04,0xde,0x8d,0x99,0xee,
        0x05,0xd2,0x4e,0x26,0x9c,0x29,0x82,0x0a,0x8f,0xb3,0x3a,0xb7,0xc6,0x0c,0x66,0xcb,
        0x5a,0x4d,0x56,0xff,0x7a,0xfa,0x74,0x36,0xad,0xce,0xaf,0x99,0xcf,0xf7,0xb4,0x43,
        0x39,0x41,0x29,0xa1,0xb9,0xaf,0x63,0x0b,0x03,0xf2,0xff,0xe9,0x03,0xfc,0xe3,0x54,
        0xfb,0x03,0x48,0x50,0x64,0x3a,0x3a,0x3d,0xf3,0x4b,0x62,0xf2,0x34,0x94,0x7d,0xa6,
        0xf5,0xbb,0x3d,0x75,0xe5,0x84,0x75,0x20,0xea,0x1c,0x6f,0x83,0xd9,0x6a,0x9d,0xf4,
        0x62,0xb1,0x1d,0x6d,0xf4,0x4e,0x78,0x23,0x36,0x7d,0x65,0x38,0xf6,0xd0,0x94,0x27,
        0x05,0x1c,0x73,0xd6,0x63,0xd8,0x27,0x5a,0xc4,0x68,0xfe,0x28,0x78,0x9c,0xbc,0xda,
        0x50,0xba,0xd4,0x7e,0x6c,0x13,0x6a,0x0e,0x3c,0x21,0xf0,0x28,0xbf,0x9b,0xb3,0xc2,
        0xeb,0x1f,0xa3,0x4e,0x49,0x5a,0x3e,0x94,0x4b,0x8c,0xcc,0x37,0x33,0x9e,0x19,0xf3,
        0xea,0x86,0x48,0xee,0x38,0xbc,0x90,0x41,0x70,0x33,0xea,0x1a,0xfb,0x77,0xa1,0x68,
        0x42,0xaf,0x06,0x59,0x24,0xc9,0xad,0xf1,0xc1,0x51,0x88,0x97,0x1d,0xb7,0x82,0x00,
        0xec,0x07,0x8e,0x3a,0xbf,0x21,0x66,0xd7,0x08,0x3d,0x88,0xd1,0xad,0x24,0x56,0x38,
        0xb9,0xee,0xa4,0x2f,0xc8,0x25,0xef,0x7c,0x8e,0xf0,0x36,0x9c,0x86,0x0b,0x7d,0x1e,
        0x40,0x86,0xf6,0x1e,0x49,0x3c,0x94,0x59,0x64,0x41,0xc6,0x67,0x2b,0xff,0xa0,0x6f,
        0x5f,0x98,0xda,0xc5,0x80,0x4c,0xb5,0xa3,0xc4,0x91,0xc6,0x43,0xb3,0xd2,0xd3,0x1e,
        0x75,0xaa,0x53,0xa0,0xa9,0x99,0xb7,0x16,0x5e,0x96,0x73,0x3a,0x0c,0x61,0x1c,0x03,
        0xc6,0xb0,0xa7,0x06,0xf7,0x20,0x6e,0xb4,0xb7,0xc6,0xb9,0x25,0x10,0x8e,0x88,0x6a,
        0xd2,0x78,0x19,0x31,0xe7,0xae,0x20,0x2f,0x5b,0xf5,0x1e,0x8c,0x28,0x38,0x30,0x76,
        0x15,0x2a,0x18,0xb6,0xa7,0x8d,0x2e,0xc3,0xa5,0xb8,0x75,0xe5,0x24,0x32,0x6d,0xc0,
        0xf9,0x38,0xfa,0x39,0x88,0x24,0xad,0x4d,0x8a,0x0f,0x1a,0x4b,0xb0,0xac,0x6b,0x85,
        0xd4,0xe5,0xad,0x9f,0x81,0x80,0xd9,0x36,0xed,0xd8,0x6c,0x4e,0x65,0x45,0x26,0x23,
        0xaf,0xa5,0x63,0x5f,0xeb,0x8f,0x9a,0xa1,0xd3,0x14,0xf5,0xce,0x1a,0xa7,0xec,0xc3,
        0x83,0xf7,0x4e,0x89,0x74,0x1c,0xcb,0xca,0xa3,0xa1,0xc2,0x6e,0x7d,0xbf,0x88,0x2d,
        0xf9,0x91,0x16,0x9f,0xa3,0x60,0xc8,0xd8,0xc6,0xe4,0xd5,0x79,0xf0,0xc5,0x07,0xbf,
        0xdc,0xd1,0xde,0x03,0x8d,0xdf,0x38,0x55,0xfd,0xa5,0xe2,0x5d,0x3a,0xce,0x50,0x65,
        0x54,0xb2,0x86,0xb5,0xaa,0x31,0x4c,0x73,0x06,0x3a,0x02,0x0d,0xe8,0x15,0xa0,0xab,
        0x61,0xe0,0xab,0xbd,0xf3,0x04,0x12,0x00,0x34,0xc7,0x02,0x9b,0x7a,0xc2,0x7e,0x8a,
        0xbf,0x5e,0x51,0x56,0x0f,0xbf,0x63,0x5d,0x9e,0x2f,0x81,0x79,0xd6,0x2f,0x81,0x66,
        0x2e,0xeb,0xf8,0xc9,0x58,0x6d,0x39,0x55,0x30,0xee,0x76,0x52,0xee,0xdf,0xe3,0xdb,
        0xc8,0x96,0xaa,0x89,0xc5,0xcf,0x30,0x44,0x0a,0x35,0xba,0x39,0xae,0xc5,0x39,0x4d,
        0x40,0x4a,0x89,0x94,0x58,0xab,0xdc,0x13,0x18,0x5d,0xd4,0xcc,0x3f,0x13,0x85,0x58,
        0x87,0xdb,0x17,0xa9,0x48,0xf9,0x74,0xf1,0xd7,0xc7,0xcf,0x33,0xc8,0x95,0x75,0x93,
        0x7d,0x3f,0x0f,0xfe,0x9e,0x86,0xb9,0x68,0xe9,0x69,0xf7,0xf1,0xb1,0x52,0xa8,0xd5,
        0xef,0xda,0xa3,0xf9,0x6d,0x0d,0xce,0xbf,0xb2,0xc2,0x15,0x2c,0xa8,0xea,0xa1,0xcd,
        0x8c,0xc0,0xc1,0x1c,0xb4,0x6e,0x26,0x9d,0x4a,0xe7,0x50,0xc1,0x00,0x11,0xc2,0x37,
        0xda,0xe0,0x4a,0x09,0xb6,0x02,0xc9,0xd4,0xf0,0x86,0xf9,0x3c,0xab,0x13,0x97,0xc4,
        0xd2,0x57,0xa3,0x66,0x7c,0xcc,0x10,0xab,0x5f,0xe6,0x1d,0xa4,0x14,0x5b,0x51,0xc4,
        0x47,0xfb,0x36,0x06,0xad,0x47,0x8b,0x47,0x3b,0xe9,0xe7,0x33,0xda,0xed,0xeb,0x55,
        0xf3,0xbc,0x60,0x24,0x54,0xb9,0x2b,0xb1,0x15,0xae,0x02,0xf7,0x0d,0x51,0x24,0x74,
        0x5c,0x81,0x29,0xa4,0xe9,0x62,0x1d,0x2b,0x7f,0xd1,0xaf,0xbe,0x05,0x6c,0x36,0x7a,
        0x18,0xf6,0x9c,0xea,0x88,0xb1,0x0f,0x40,0x7d,0x61,0x8e,0x29,0x47,0x00,0x44,0x40,
        0x14,0xf1,0xe8,0x67,0x0f,0x89,0xe2,0x9b,0x4c,0x05,0x29,0xf6,0x89,0x5f,0x72,0xf8,
        0xbc,0x1b,0x08,0x32,0x86,0x0a,0xde,0xef,0x8b,0x5e,0x96,0x8f,0xee,0xa8,0x31,0x13,
        0xd3,0x7e,0xb9,0x84,0x48,0xc6,0xca,0x50,0x1b,0x86,0x81,0x21,0xc2,0xf6,0x2b,0xc9,
        0xb0,0x8b,0xed,0x78,0xba,0x4f,0xa8,0xa4,0xac,0x39,0x22,0x3e,0xa4,0x51,0x82,0x0e,
        0x07,0xf5,0xff,0x70,0x8f,0x3d,0x5a,0x4f,0x68,0x10,0xa9,0x12,0x7d,0xe8,0xa3,0x26,
        0x5d,0x7d,0xa7,0x13,0xa1,0xdb,0x17,0x8b,0xa6,0xb8,0x8f,0xd4,0x96,0x98,0x53,0xbc,
        0x95,0xbc,0x15,0x53,0x3a,0x45,0x46,0x04,0x9a,0x23,0xaf,0xd6,0xa3,0x2d,0x44,0xe8,
        0x0f,0x99,0x97,0xce,0xcd,0x43,0x4e,0x2c,0xd9,0x84,0x30,0xc1,0xc1,0xc4,0x45,0x34,
        0xa0,0xe1,0xe5,0x73,0x7e,0x38,0x43,0x00,0x8c,0x85,0xb3,0x43,0xdb,0x76,0xaf,0x9e,
        0x58,0xce,0x0b,0x35,0x07,0xb8,0x61,0x87,0x3b,0x8c,0xd3,0xf2,0xa2,0x6b,0x69,0x98,
        0xa5,0x14,0x45,0xb9,0x73,0x3f,0xbf,0x13,0x6d,0x20,0xb5,0x4d,0x9a,0xc1,0xba,0x79,
        0x1b,0x10,0xae,0xdb,0x06,0x81,0x32,0xde,0xd6,0xd6,0xb4,0x83,0x6a,0xa8,0xac,0x28,
        0x05,0x7d,0xae,0x3f,0x1a,0x6b,0xff,0x69,0x18,0xb1,0x86,0x23,0x3c,0x0a,0xb2,0xac,
        0xd0,0x30,0x2d,0x5e,0x14,0x21,0x7d,0x41,0x7b,0x2f,0x36,0x4b,0xe4,0xce,0xf9,0xf8,
        0x44,0x88,0x82,0x22,0xea,0x76,0x4c,0x38,0xa0,0x98,0xb7,0x1b,0xc1,0x2b,0x6a,0xc2,
        0x9f,0x88,0x88,0x0d,0x79,0x53,0x3f,0xc0,0xf6,0xfe,0xba,0x84,0x30,0x82,0xfa,0x30,
        0x75,0xe4,0x20,0xc1,0xdc,0xd0,0xcf,0x47,0xea,0xba,0x10,0xef,0x4a,0x0c,0x45,0x7a,
        0x56,0x2f,0x37,0x47,0x37,0xae,0x25,0x21,0x4d,0xe1,0xc6,0x79,0xbc,0xd1,0xc4,0x9a,
        0x71,0x8c,0x7e,0x12,0x25,0xe1,0x0d,0x25,0x68,0x84,0x02,0xc4,0x32,0x68,0x61,0x77}, 
        /*TST_dataSize*/
        1536*sizeof(DxUint8_t),       
        CRYS_AES_CTR_mode
    },
    #endif
    #endif
    #if TST_USE_AES_256_KEY
    #if TST_USE_AES_16BYTE_DATA
    { 
        {"Acceptance test - AES/CTR/256Key/16ByteData "},
        /*TST_Key*/     
        {0x33,0x58,0xdf,0xd9,0xf2,0x82,0x70,0x37,0xd8,0x04,0x84,0x69,0x3b,0x33,0x2f,0x00,
         0xf4,0xd1,0x3d,0x64,0x59,0x2e,0xc8,0x1b,0x6b,0x92,0x0a,0x48,0x50,0xdf,0x6f,0x72},
        CRYS_AES_Key256BitSize,
        /*Input Block-CTR*/
        {0x78,0x12,0x25,0x78,0x51,0xfe,0x3c,0xe1,0x45,0xce,0x08,0x08,0x6b,0xcd,0xf8,0xb2},
        /*TST_input_data*/
        {0xd8,0x37,0xca,0xae,0x1b,0xb5,0xb7,0xf4,0x62,0xd6,0xb1,0x28,0xa2,0xc9,0x01,0xff},
        {0},
        /*TST_Expected_output_data for enc Input data for decrypt*/
        {0x82,0xe6,0x4f,0x67,0x9c,0x9f,0xb0,0x70,0x43,0xf8,0x2c,0x28,0x0c,0xcf,0x73,0x11}, 
        /*TST_dataSize*/
        16*sizeof(DxUint8_t),       
        CRYS_AES_CTR_mode
    },
    #endif
    #if TST_USE_AES_32BYTE_DATA
    { 
        {"Acceptance test - AES/CTR/256Key/32ByteData "},
        /*TST_Key*/     
        {0xc4,0x63,0x7d,0xbb,0x10,0xd2,0x7c,0x1e,0x07,0xcf,0x1c,0xb7,0x11,0x76,0x1d,0x16,
         0x0b,0x7e,0x67,0x55,0x3c,0x60,0x9d,0x57,0x8a,0xbc,0xf4,0x4e,0xed,0xf9,0x46,0x80},
        CRYS_AES_Key256BitSize,
        /*Input Block-CTR*/
        {0x3f,0x33,0x40,0x13,0x9a,0x32,0x4f,0xfb,0xe2,0x99,0xa1,0xad,0x0e,0x8e,0x92,0xa9},
        /*TST_input_data*/
        {0x7c,0x93,0x67,0x13,0x4c,0xd8,0xbd,0xe1,0xaa,0xa2,0xf1,0xd0,0x7b,0x96,0x23,0x50,
         0xff,0x3f,0xc3,0xde,0x4c,0xb1,0xa5,0xcd,0xfb,0x6d,0x57,0x47,0x21,0x85,0xb2,0x8f},
        {0},
        /*TST_Expected_output_data for enc Input data for decrypt*/
        {0x3c,0x51,0x80,0xb9,0xe2,0x23,0x2e,0x4d,0x4a,0x60,0xaa,0xfb,0x3c,0x1b,0x46,0x73,
         0x6e,0xad,0x51,0xb2,0x5f,0x39,0xca,0xdd,0x68,0xd1,0xdf,0x80,0x92,0x6f,0x47,0x24}, 
        /*TST_dataSize*/
        32*sizeof(DxUint8_t),       
        CRYS_AES_CTR_mode
    },
    #endif
    #if TST_USE_AES_512BYTE_DATA
    { 
        {"Acceptance test - AES/CTR/256Key/512ByteData "},
        /*TST_Key*/     
        {0xc5,0x03,0xa3,0x68,0x1b,0x2a,0xf4,0x62,0xa6,0x61,0x10,0x11,0xd3,0x6c,0x77,0x84,
         0xc6,0xf1,0x08,0xab,0xfd,0x8a,0xc8,0x0e,0x30,0x19,0xdf,0xbe,0x7c,0x5c,0xe3,0x8c},
        CRYS_AES_Key256BitSize,
        /*Input Block-CTR*/
        {0xc4,0xfd,0x08,0xb3,0x81,0x19,0xf7,0x5d,0x5d,0x31,0xe7,0x25,0x7e,0xa7,0x42,0x1c},
        /*TST_input_data*/
        {0x90,0x60,0xf6,0x59,0x2e,0x5f,0xad,0x53,0x1b,0x48,0x27,0x86,0xe8,0xf2,0x30,0x94,
         0x7a,0x44,0x62,0xc7,0xc7,0xed,0x01,0x61,0xda,0x54,0x23,0x2d,0x1d,0xd2,0x14,0x5a,
         0xd7,0x20,0xf8,0x89,0xf4,0x0b,0xb2,0x25,0x05,0x6f,0x05,0xf3,0x87,0x62,0xf9,0xea,
         0x68,0xb0,0x81,0x44,0xc7,0x88,0x5a,0xd5,0xfc,0x74,0x36,0x9c,0xd8,0x8e,0x1a,0x98,
         0x2d,0xf2,0x05,0xdc,0x91,0x6f,0xd2,0xe6,0x60,0x82,0x5f,0x2d,0x00,0x84,0xef,0xf9,
         0x69,0x22,0xcd,0x77,0xe4,0x0e,0x33,0x0d,0x12,0xf4,0x69,0xeb,0x31,0xb0,0x31,0xe3,
         0x9b,0xbe,0x63,0x7a,0x8f,0xf1,0xd5,0x3f,0x34,0x68,0x7d,0x5b,0xdb,0xbf,0xda,0x6a,
         0x85,0x82,0x8f,0x89,0xa5,0xe7,0x52,0xb0,0x27,0xbc,0x04,0x43,0xb0,0x9e,0x21,0xe3,
         0x28,0x6c,0x5b,0x8a,0x76,0xfb,0x82,0xd7,0x8a,0x0b,0xa7,0xa6,0xa1,0x7a,0x81,0xe4,
         0xc4,0xb8,0x10,0xa2,0x92,0x7b,0x7f,0x67,0x40,0xb4,0x4f,0xcb,0xde,0xc1,0xb2,0x41,
         0xdc,0xe4,0x35,0x35,0xcc,0xf4,0xa2,0x57,0x69,0x52,0x25,0x36,0xd9,0x1f,0xad,0x10,
         0x2f,0xac,0x95,0xe8,0x34,0x32,0x84,0xda,0x67,0xc4,0x92,0xac,0x42,0x81,0xac,0xa5,
         0xbf,0x0e,0x39,0xa2,0x1b,0x44,0xfd,0x66,0xda,0x25,0x3e,0x32,0x0b,0x15,0x26,0x95,
         0xcd,0x47,0x69,0x86,0x12,0x75,0x28,0xb0,0xa3,0xd4,0x14,0x0d,0x65,0x47,0xd6,0xb6,
         0xda,0xd2,0xaf,0xfa,0xea,0x52,0x5b,0xad,0xe4,0x6c,0x3c,0xc2,0xc0,0xc4,0xb4,0x1d,
         0xa7,0x6f,0xd3,0xa2,0xb5,0xaa,0x32,0x92,0xfd,0xcc,0x1e,0x17,0xcd,0x79,0xf9,0x1d,
         0x34,0x19,0xde,0x64,0xc2,0x88,0x84,0xd3,0x8f,0x0f,0x65,0x10,0x7e,0x94,0x1f,0x4d,
         0xc3,0x0d,0x1a,0x65,0xa3,0x3b,0x6b,0x27,0x7b,0x94,0xf8,0xf1,0x04,0x81,0xdd,0x82,
         0xd5,0xc9,0x0f,0x09,0x2a,0x4d,0x3f,0x81,0xe3,0xf7,0x02,0x41,0xd0,0xed,0x2e,0xcf,
         0x2b,0x0a,0x87,0xf6,0x66,0x8e,0x9b,0x18,0x28,0x14,0xea,0xc5,0x92,0xc5,0x4a,0x8b,
         0xc6,0xcc,0x8a,0x10,0xaa,0x09,0x56,0x5f,0xe9,0x0a,0x5a,0x80,0x3b,0x37,0xab,0x4b,
         0xe7,0x4c,0x62,0x7d,0x86,0x0d,0x8a,0x0c,0x09,0x35,0x3c,0xb8,0xfd,0xaf,0x08,0xe3,
         0x0e,0x08,0x97,0xa2,0xca,0x25,0x8f,0x14,0xa8,0x31,0xb7,0xf3,0x49,0xda,0x5c,0x68,
         0xfd,0xbd,0xf3,0x24,0x89,0x1e,0xff,0xac,0x28,0xdd,0x35,0xf4,0xcf,0xa5,0xde,0x30,
         0xb5,0x67,0x7e,0xe7,0x13,0x07,0xb3,0x49,0x28,0x55,0x5f,0xc2,0x81,0x3e,0x09,0xcf,
         0x77,0x44,0x81,0x11,0xf9,0x2b,0xc3,0xa0,0x8c,0xf5,0x1e,0xa1,0x8f,0x11,0x96,0x1b,
         0xc4,0xd0,0x86,0x06,0x0c,0x18,0x8a,0xa5,0x72,0x5c,0x9b,0x16,0x6b,0xcb,0x7c,0x28,
         0x5c,0xc8,0x56,0x6c,0x5d,0x9b,0x9f,0x8f,0x3d,0x66,0x3f,0xe6,0xc6,0x5a,0xf6,0x4b,
         0x42,0x2a,0xf8,0x28,0x3e,0xc0,0xdb,0xd1,0x8d,0x30,0xb3,0x17,0x90,0xea,0x7c,0x1a,
         0xb5,0x33,0xb8,0x5e,0x3e,0xd6,0x58,0x21,0x44,0x16,0xe0,0xec,0xfb,0xe8,0xc7,0x69,
         0x37,0x5f,0x1c,0x74,0x2f,0x68,0x70,0x74,0x81,0xb7,0xef,0xec,0x77,0x01,0xd0,0x4d,
         0x89,0x6c,0xf0,0x0f,0x23,0x44,0xb9,0xff,0xa8,0xef,0x49,0xdb,0xb6,0x23,0xd0,0x1c},
        {0},
        /*TST_Expected_output_data for enc Input data for decrypt*/
        {0xe7,0x1d,0x4e,0x56,0xf4,0x69,0xf4,0x25,0x35,0x5c,0xd7,0x56,0x64,0x5c,0x9b,0x1c,
         0x4c,0xce,0x51,0x53,0x80,0x43,0xe0,0x55,0x0f,0x67,0x85,0xc4,0x39,0xee,0xcd,0x90,
         0xa7,0xdc,0x1b,0x3f,0x62,0xf1,0xa1,0x2d,0x81,0x9a,0xd0,0xa0,0x89,0x4a,0x76,0x17,
         0x44,0x42,0xd7,0xd8,0x5f,0x3e,0xba,0xca,0xbb,0x60,0x7c,0x78,0xdd,0x2c,0xa7,0x7f,
         0x4b,0x22,0x7f,0x2b,0x11,0xff,0x53,0xcf,0x23,0x08,0xb9,0xdb,0x34,0x16,0xa7,0xfa,
         0x08,0xb0,0x99,0xb6,0x62,0x24,0xa2,0xa9,0x60,0xdf,0x1b,0x51,0x79,0xbe,0x43,0x30,
         0x28,0x1f,0x34,0x2a,0x85,0x5b,0x9f,0x53,0x0f,0xb8,0x97,0x87,0x83,0x62,0x3c,0xda,
         0x66,0xfd,0x28,0x96,0xfc,0xed,0x3b,0xec,0x75,0x02,0xd5,0x64,0x28,0xf8,0x73,0x07,
         0xe0,0x56,0x3a,0x9b,0xe3,0x83,0xa9,0xfd,0xa2,0x88,0xde,0x7c,0x04,0x8f,0x07,0x1e,
         0x34,0xc5,0x61,0xcc,0x72,0xde,0x72,0x38,0x91,0xd0,0x10,0x05,0xdb,0x1a,0x8c,0x5f,
         0x5b,0x85,0x98,0x0c,0x05,0x59,0x46,0x8b,0xae,0x2e,0x95,0x09,0xea,0x5f,0x8d,0x01,
         0x28,0x3e,0xc5,0xac,0xcf,0xa6,0x1c,0xfb,0x29,0x00,0x98,0xf1,0x54,0x05,0xe5,0x15,
         0xc8,0x48,0x20,0x69,0xf9,0x2b,0x09,0x8d,0x5f,0x94,0x7f,0x75,0x48,0x5f,0x51,0x15,
         0xc0,0x38,0x8f,0x97,0x5a,0xc8,0xe8,0xf2,0xf1,0xf0,0xdd,0x19,0x1e,0x5e,0xfb,0xaa,
         0xdb,0xc5,0x35,0xc3,0xdf,0x6a,0xc8,0x91,0x35,0x01,0xf0,0x19,0x8a,0xc6,0x09,0x2f,
         0x6a,0x23,0x3c,0x87,0xb3,0x0f,0xf7,0xb8,0x74,0x14,0x9c,0x31,0xe1,0xe4,0xd3,0x9a,
         0xf3,0xc0,0xb5,0xea,0x46,0xbb,0x58,0x5a,0x85,0x25,0xab,0x1b,0x1a,0x6f,0xf2,0xc4,
         0xc1,0x22,0xbc,0x88,0x52,0x96,0x5e,0x18,0xb0,0xc9,0x82,0x89,0x4e,0x84,0x5a,0xd9,
         0x71,0x4d,0x9e,0x88,0xa2,0xe8,0x9a,0xc5,0xea,0xef,0x02,0x08,0x19,0x59,0x2c,0xc2,
         0xe1,0x62,0x0b,0xdc,0x5c,0xb5,0x7c,0xcf,0x45,0x5f,0x8f,0x2e,0x7c,0xd5,0x5b,0xef,
         0x9e,0x2f,0xe4,0x5a,0x9c,0x13,0xc6,0xfc,0x7d,0x91,0x90,0x95,0x1e,0xa8,0xca,0x0b,
         0xe3,0xa2,0x2d,0x2f,0xea,0x43,0x18,0x95,0x21,0x9b,0x53,0xad,0xdb,0x7c,0xaa,0xa1,
         0x10,0x55,0xa4,0xd7,0x08,0x11,0x49,0xaf,0x2e,0x53,0x75,0xa4,0x9e,0xb6,0x1c,0x77,
         0x60,0xf9,0xd2,0x3d,0xff,0x55,0x2f,0x2f,0x63,0x23,0xcd,0x19,0x6e,0xb9,0xc3,0xcc,
         0xf1,0xf3,0x63,0x61,0x06,0xc5,0x55,0xa1,0xe8,0x32,0x1a,0xb2,0xac,0x11,0x44,0x9d,
         0x09,0x7f,0xd0,0xfc,0xba,0x7e,0x75,0x1f,0x2b,0x05,0xd2,0x0f,0x4f,0xc8,0xe1,0x06,
         0x5e,0x0d,0x7f,0x69,0x2e,0x2f,0x69,0x60,0x16,0x1f,0x26,0x1d,0xb9,0x6f,0xa5,0xc9,
         0x02,0xda,0xa5,0x37,0x32,0xda,0xe8,0x91,0x71,0x36,0xd5,0x6b,0x31,0x89,0xb5,0x69,
         0xf2,0x13,0xaa,0x35,0xaa,0xd0,0xe0,0xd8,0xd4,0x52,0xf1,0x28,0x87,0x7f,0x87,0x2b,
         0xab,0x88,0xa2,0x46,0xd7,0x28,0x3c,0xe6,0x4f,0xa7,0xb8,0x93,0x55,0x96,0x60,0x23,
         0xec,0xd7,0x07,0xe1,0x0e,0xb8,0xee,0x00,0xf0,0xfb,0xee,0xf0,0x49,0x4a,0xfa,0x5b,
         0x4d,0x32,0x17,0x4e,0x06,0xff,0x61,0x47,0xb0,0x72,0xe0,0xaf,0x68,0xd4,0xac,0xde}, 
        /*TST_dataSize*/
        512*sizeof(DxUint8_t),      
        CRYS_AES_CTR_mode
    },
    #endif
    #if TST_USE_AES_1536BYTE_DATA
    { 
        {"Acceptance test - AES/CTR/256Key/1536ByteData "},
            /*TST_Key*/     
        {0x88,0x50,0xb0,0x58,0x33,0x99,0x35,0xe8,0x6f,0x6a,0x7a,0x36,0x69,0x06,0x3f,0x55,
        0x01,0xa4,0x77,0xbd,0xd9,0x2a,0xfa,0x36,0xac,0x38,0x7a,0xf8,0xe2,0x68,0xb8,0x10},
        CRYS_AES_Key256BitSize,
        /*Input Block-CTR*/
        {0x99,0x98,0x53,0x28,0x07,0x04,0x31,0x6d,0xe1,0xc0,0x60,0xfa,0x2a,0x54,0x96,0xbf},
        /*TST_input_data*/
        {0x0f,0x85,0x68,0x1f,0x44,0xa5,0x05,0x88,0x87,0xa0,0x07,0xf1,0x45,0xc2,0xd1,0x3d,
        0xa2,0x2a,0x5d,0x8f,0x05,0x35,0xdf,0x5f,0xd6,0x3a,0xa5,0xce,0x86,0x78,0x42,0x36,
        0xd0,0x4c,0xeb,0x06,0x3f,0xa8,0x21,0xcd,0xf1,0xc0,0x91,0x94,0x9a,0x06,0x38,0x71,
        0xcb,0x59,0xca,0x59,0x75,0x79,0x55,0x36,0xa9,0xbf,0x21,0x39,0xa1,0x0b,0xdc,0x72,
        0x04,0xfd,0xf3,0x9e,0x66,0x68,0x43,0x40,0x0e,0x03,0xf1,0xf3,0xfd,0x62,0x96,0xfe,
        0x2c,0x25,0xa0,0x29,0x14,0x70,0xf5,0xcf,0x73,0x9b,0xd9,0x35,0x4e,0x2a,0x11,0x1a,
        0x32,0xff,0x48,0x8f,0xc0,0xce,0xb3,0x09,0x69,0xd2,0xf1,0xb5,0x75,0xbe,0x35,0x0b,
        0x4a,0xf7,0xa6,0xa6,0xeb,0x00,0x06,0x53,0xbf,0x35,0x92,0x68,0x94,0xbd,0x2a,0x57,
        0xe3,0xba,0xb2,0x82,0x55,0xc2,0xb8,0x51,0x87,0x93,0x57,0x82,0x0a,0x02,0x5b,0xc1,
        0xaf,0x35,0xa5,0x79,0x01,0x12,0xd2,0xe9,0x12,0xf7,0x17,0x7a,0x7b,0xac,0x6f,0x50,
        0x9e,0x96,0xf9,0x1f,0x2e,0x2d,0x9b,0x40,0xf2,0xb0,0xec,0x04,0xc5,0x17,0x51,0x48,
        0xe2,0x49,0x66,0x49,0x5e,0x8f,0x9f,0xba,0xf6,0x48,0x2f,0x14,0x0b,0xdf,0x28,0x2e,
        0xeb,0xfb,0xe4,0x0d,0x52,0xf5,0xa5,0xfd,0x31,0x8f,0x78,0xe0,0xad,0xe3,0x5f,0xc7,
        0x6b,0x99,0xae,0xbf,0x0b,0x5d,0xb6,0xee,0xf2,0x90,0xa1,0xde,0x4d,0x3e,0x9d,0x18,
        0x52,0x51,0x3d,0xf5,0xc9,0x04,0x1b,0xb1,0xcc,0x9a,0xc3,0xc1,0xcb,0x4f,0xcc,0x66,
        0xd3,0x8f,0x48,0x83,0x0f,0x66,0x5f,0xac,0x8f,0x38,0x36,0x7f,0x48,0xb2,0x16,0x37,
        0x5c,0x00,0xca,0x7e,0x9c,0x40,0x48,0x83,0x4b,0x37,0x94,0x4d,0x25,0x43,0xe2,0x4f,
        0xa0,0x91,0xfb,0x3c,0x72,0x90,0xe1,0x1c,0x53,0xa6,0xb6,0xa0,0x04,0x21,0xda,0xb2,
        0x90,0x70,0x54,0x51,0xd2,0x93,0x73,0x9c,0x37,0xd0,0xb4,0x2c,0xc6,0xa8,0xe7,0xa7,
        0x5d,0x09,0x8e,0x92,0x3d,0xc5,0x86,0x67,0xc8,0x43,0xe9,0xe8,0x8a,0x75,0x32,0xb2,
        0x77,0x09,0xa2,0x15,0x73,0xe4,0xe3,0x23,0x18,0xcc,0xec,0x07,0xb3,0x64,0x24,0x99,
        0x8f,0x5e,0xca,0x2f,0x77,0xec,0x94,0xb5,0x76,0x77,0x96,0x00,0xe1,0x94,0x66,0x5f,
        0x97,0x34,0x7e,0x73,0x88,0x1a,0xe1,0x41,0x74,0x93,0x02,0x86,0xf5,0x61,0xe1,0x4a,
        0xc0,0xf8,0x77,0xb8,0x28,0xed,0x54,0x2d,0xe4,0xab,0x87,0x8f,0x11,0x68,0xbe,0xe0,
        0x7b,0x57,0xae,0x13,0x18,0x1f,0xb5,0x1e,0xd5,0x8d,0xbe,0x50,0x95,0x85,0x66,0xe5,
        0x77,0x3f,0x5d,0xd8,0x58,0xb0,0x0e,0xf8,0x9a,0x45,0x82,0x3e,0x23,0xd7,0x81,0x5e,
        0xa8,0xdc,0xfb,0x9c,0x2b,0xda,0xa7,0xe1,0xc2,0x22,0xea,0x0e,0x9b,0xba,0xfa,0x90,
        0x3d,0x9b,0x43,0x35,0x10,0x1c,0x0a,0x3d,0x20,0xaf,0x50,0xb5,0x1e,0xcb,0xf9,0x00,
        0xa8,0x29,0x2d,0xb7,0xc9,0x33,0xff,0xb3,0xc4,0xba,0x4c,0x67,0x0d,0xe7,0xe6,0x73,
        0x99,0x74,0xf2,0x77,0x57,0x1b,0x8f,0x25,0xff,0x4f,0xb9,0x9b,0x0a,0x2b,0x6c,0xef,
        0x01,0xa8,0x0c,0x0b,0xfb,0x12,0x04,0xbb,0x62,0xbd,0xae,0x04,0xf5,0xf4,0x73,0xb8,
        0x13,0x32,0x33,0x47,0x36,0x95,0xe6,0xd8,0xbe,0x8f,0x84,0x98,0xf0,0xdf,0x23,0x52,
        0x3e,0xbf,0x5f,0x41,0xc8,0x5f,0xff,0x22,0x24,0x93,0xd6,0x8c,0x5a,0xc8,0xe6,0x84,
        0x33,0x3d,0xcc,0x4d,0xb4,0x70,0x58,0x7d,0xe5,0xd6,0x7b,0x56,0xd7,0xce,0x66,0x52,
        0xe4,0xd8,0xf0,0x00,0x39,0x02,0x38,0x0f,0x92,0xa4,0x8c,0xa8,0x45,0x4d,0x8a,0x02,
        0x82,0xfd,0x85,0x30,0xd9,0x95,0x2b,0x3d,0xfc,0x8b,0x64,0x7a,0xc7,0xe2,0x7d,0x17,
        0x7d,0x5a,0x85,0xf1,0x55,0xe4,0xf7,0xab,0x35,0x58,0x9a,0x00,0xbd,0x6a,0xa6,0x57,
        0x87,0xdb,0x28,0x98,0xad,0xec,0xa7,0x3f,0x8c,0x18,0x08,0xaf,0xc8,0x02,0xaf,0xc8,
        0x91,0xad,0xe7,0xbb,0x24,0xeb,0x84,0x1d,0x94,0x18,0xc7,0x3b,0xca,0x07,0x81,0xae,
        0xca,0x3d,0x7b,0x2f,0x39,0x5d,0x16,0xac,0x1c,0xe4,0x2f,0x9b,0xe3,0x16,0x45,0x8e,
        0xa6,0x39,0xde,0x07,0xae,0x00,0x26,0x8e,0x37,0x4a,0xda,0x02,0x74,0x0d,0x64,0x2d,
        0xd4,0x8c,0x48,0x9a,0x84,0xd1,0xbe,0xab,0x35,0x57,0xa0,0xe6,0x1f,0x07,0x87,0x90,
        0x46,0x65,0x32,0x7d,0xfc,0x0c,0x27,0x26,0xa7,0x58,0x9c,0xfc,0xc4,0x62,0x97,0xfc,
        0x2c,0x31,0x55,0x84,0x96,0x2e,0xe9,0x65,0x5e,0xd9,0x25,0x39,0x85,0xbb,0xbd,0xf7,
        0xf8,0x9b,0xaa,0xc4,0x15,0xf5,0xcd,0x0c,0x6b,0xa8,0xd5,0xd2,0xc1,0xef,0x62,0x44,
        0x5a,0x92,0x6a,0x93,0x78,0x5e,0xdd,0x01,0x1f,0xd2,0x84,0x3c,0x1b,0x1b,0x2f,0xea,
        0x45,0x43,0x0f,0x85,0x01,0xa5,0x61,0x69,0x0b,0xa4,0x4c,0x2b,0x74,0x9c,0x0d,0x2d,
        0xe7,0x19,0x51,0x6f,0x31,0x47,0xe2,0xa8,0x00,0xaa,0x86,0x96,0xeb,0x0f,0x25,0x92,
        0xb3,0xc3,0x29,0x67,0xc9,0x02,0x2a,0x64,0x10,0xb2,0xcb,0xb0,0xe3,0x52,0xdf,0xde,
        0x5a,0x2d,0xd1,0xc1,0xc9,0xd3,0x42,0x82,0x8a,0xc9,0xf3,0xef,0xfd,0x80,0xe6,0x16,
        0xcc,0x84,0xc0,0x13,0x74,0xf6,0x72,0x26,0x01,0x3c,0x18,0x09,0x18,0xf7,0x21,0x80,
        0x3b,0x35,0xb1,0x31,0x49,0xe9,0x43,0xb6,0x44,0x98,0x93,0xf1,0x57,0x54,0xbb,0x9f,
        0x18,0xee,0x9c,0x30,0x0a,0x68,0x7f,0xd7,0x66,0xa9,0xfc,0xdd,0x1b,0x74,0x1c,0x3a,
        0x13,0x9b,0xba,0x66,0xb8,0x70,0x2f,0x6d,0xb7,0x7d,0x2e,0x42,0x03,0x75,0xec,0x55,
        0x1e,0x6a,0x84,0x67,0x94,0x3f,0x9b,0x9d,0xc8,0x61,0x3f,0xd4,0xf2,0xb2,0x15,0x35,
        0x69,0xc6,0xb4,0x09,0x1e,0x52,0x4c,0xce,0x69,0xe1,0x8b,0x8a,0x09,0xc9,0xc1,0x5f,
        0x66,0x5e,0x42,0x60,0x18,0x65,0x0c,0xa3,0xad,0xcc,0xa9,0x97,0xa7,0x98,0x57,0x98,
        0xc5,0x1e,0x67,0xc1,0x84,0x76,0xe3,0x02,0xe4,0x2d,0x73,0x72,0x6f,0x3a,0x81,0xe6,
        0x78,0x33,0x9c,0xc2,0xa1,0xc1,0x1a,0x0f,0xa0,0x52,0x02,0xce,0x42,0x0d,0x29,0x8c,
        0xaf,0x0b,0x9a,0x37,0xf1,0xc4,0x3b,0x30,0xb0,0xc7,0xae,0xa1,0x3f,0xaf,0x76,0x11,
        0xdd,0x52,0x5b,0x36,0x34,0x3b,0x0f,0x0a,0x26,0x5b,0x11,0x21,0xc9,0xfb,0xd2,0x39,
        0xb0,0xf5,0x17,0x13,0x6d,0x24,0x9e,0x81,0x53,0x19,0x04,0xc1,0x81,0x0f,0xe6,0x09,
        0x1c,0x21,0x47,0x63,0xdb,0xbb,0x31,0xbb,0xc9,0x4f,0x9f,0x36,0x46,0x49,0x9b,0xc6,
        0x4f,0x44,0xa4,0xfc,0x00,0x7e,0x52,0x1d,0x57,0x89,0x3d,0x77,0x3b,0x44,0x1a,0xf5,
        0xbd,0x0a,0x27,0xf2,0x9d,0x29,0xca,0x4b,0x10,0x96,0x74,0xb8,0xc0,0xdf,0xcc,0x5c,
        0x15,0x60,0x0a,0x9a,0xb3,0xba,0xa0,0x2b,0x44,0x81,0x20,0x6d,0x77,0x35,0x5a,0xfe,
        0x48,0x74,0xc4,0x8a,0x83,0x6d,0x20,0xe1,0x83,0x98,0x58,0x4d,0x40,0xa5,0xad,0x22,
        0x89,0xb2,0x10,0x96,0x8d,0xc0,0xd0,0xd3,0xa0,0x68,0x76,0x4b,0x3c,0xca,0xee,0x4c,
        0x46,0xc7,0xe7,0xd4,0x93,0x70,0x7b,0xa6,0xab,0xbd,0x13,0x9d,0xcd,0x83,0x85,0x41,
        0x33,0xa0,0x80,0x98,0x96,0x78,0x2a,0x3f,0xf5,0xa6,0x07,0xb8,0x93,0xeb,0x1d,0x06,
        0x3f,0x6a,0x56,0x77,0xd7,0x18,0x25,0xc2,0x0f,0x6e,0x6c,0x51,0x6f,0x61,0x9e,0xe0,
        0x9b,0x93,0x21,0x47,0xd7,0xcb,0xf6,0x94,0xca,0xa3,0x9b,0x5d,0x82,0x80,0x30,0x55,
        0xb9,0xc7,0xda,0x1c,0x57,0x4e,0x65,0x5c,0x38,0x11,0x2d,0x11,0x2e,0x27,0x3e,0x28,
        0x4a,0xf4,0xba,0x4c,0x57,0x9f,0x7b,0xfd,0xa8,0xc6,0xfa,0xe2,0x14,0x71,0x6f,0x60,
        0x3e,0x45,0x3a,0x6b,0x1a,0xfb,0x82,0x9c,0xac,0x10,0x1c,0x84,0x13,0xbd,0xae,0x41,
        0xc7,0x29,0x14,0x4e,0x1f,0xde,0x02,0xa0,0x16,0x79,0xeb,0xee,0x4e,0xa6,0x22,0x50,
        0x55,0x4c,0x40,0x0b,0x28,0x05,0xc5,0xab,0xf5,0xd1,0x02,0x53,0x25,0x0b,0x36,0x52,
        0x9a,0x9c,0xf7,0xf6,0x35,0x6e,0xd3,0xa5,0x9c,0x24,0x38,0x29,0x3a,0x08,0x91,0x4c,
        0x87,0x44,0xb2,0xa5,0x89,0x56,0x76,0xb1,0x9b,0xbe,0xa6,0x26,0x6d,0xf9,0x1d,0x83,
        0x4c,0xb3,0x2a,0xec,0xa3,0x39,0x36,0x35,0xc2,0x2d,0xa7,0x3d,0xdf,0x7d,0x04,0x7d,
        0x5a,0x95,0x59,0xe0,0x46,0xd4,0xdd,0xd5,0x24,0x3d,0xd2,0xa3,0xf1,0x70,0xad,0xfe,
        0x64,0xd8,0x77,0xd7,0x71,0x25,0x73,0x78,0x11,0xfd,0x01,0xcf,0x45,0xee,0xc2,0x0a,
        0x58,0xa8,0xfd,0x65,0x65,0x69,0x41,0x40,0x1a,0xb8,0x4c,0x75,0xbb,0x56,0x2c,0xe8,
        0x6a,0x72,0xa4,0x60,0xa5,0x1c,0xd1,0x95,0x10,0xfc,0x0d,0x8a,0x75,0x44,0x14,0x1c,
        0x09,0xe3,0x66,0xdb,0xf1,0xfc,0xec,0x1a,0x04,0x96,0xdd,0x42,0xd3,0x95,0xe3,0x6c,
        0xe6,0xe9,0x7a,0x2e,0x49,0x05,0x99,0xb4,0x48,0x92,0x95,0x13,0x76,0x65,0x42,0xdb,
        0xf4,0xaf,0x5b,0xeb,0xef,0x74,0x24,0x8a,0x6b,0x3f,0x4d,0xb3,0x3f,0x13,0x1a,0xaf,
        0x61,0xa4,0xc1,0xea,0x64,0xc7,0x14,0xff,0x3f,0x28,0x5f,0x15,0x50,0x3b,0x94,0x6e,
        0xa1,0x75,0xa5,0x3d,0x69,0xbb,0x32,0xb8,0xd6,0x1b,0x64,0x6f,0x09,0xba,0x19,0xdc,
        0x63,0x0d,0x41,0x3b,0xff,0x4c,0x87,0x9c,0x7f,0x24,0x35,0x36,0x0c,0xad,0x51,0xfe,
        0x98,0x9b,0x0c,0x78,0x66,0xb8,0x5e,0xcd,0xcd,0x92,0xea,0x1f,0x39,0x70,0x27,0x19,
        0x72,0x8b,0xc1,0xca,0x21,0x7b,0x3d,0xb3,0x90,0xf0,0xdd,0x1e,0xb1,0xa2,0xc3,0xb2,
        0x62,0x8b,0x58,0x45,0xef,0x53,0xef,0xf1,0xd8,0x0c,0xa6,0x6a,0xd5,0x1f,0x8d,0x8e,
        0x18,0x86,0x0b,0x3e,0xd2,0x3c,0x7d,0x6d,0xf8,0xf2,0x1f,0x76,0x47,0x04,0x30,0xb3,
        0x86,0xab,0x51,0x4b,0x0b,0x74,0x2f,0x4b,0x80,0xf1,0x61,0xf9,0xe7,0xae,0x94,0x65,
        0xdc,0x66,0xe5,0x40,0x1a,0x77,0x8e,0xf1,0x41,0x94,0xc5,0xe6,0xd7,0xba,0xe1,0x28},
        {0},
        /*TST_Expected_output_data for enc Input data for decrypt*/
        {0x09,0x9b,0xff,0xbe,0x94,0x1a,0x56,0x5d,0x36,0xff,0xe8,0xd5,0x89,0xc5,0x58,0xa8,
        0x44,0xb7,0x26,0xe7,0xdb,0x6f,0x69,0x65,0x08,0xcb,0xca,0xcb,0xf1,0xb9,0xa5,0xc1,
        0xb2,0x33,0x12,0x6f,0x58,0x6e,0xc6,0xa9,0x31,0x63,0x7e,0xca,0x6a,0xd3,0xc3,0xcf,
        0x07,0x9c,0xb4,0xe2,0x6c,0x14,0x66,0xab,0x27,0x98,0x13,0x08,0xa3,0xcf,0x1a,0xa9,
        0x75,0xd6,0x1c,0xff,0x5d,0x2b,0x53,0x1b,0x65,0xda,0x8d,0x91,0x38,0xe7,0x65,0x36,
        0x24,0xfc,0xf2,0x7b,0xc4,0x06,0xfd,0xa7,0x06,0xd7,0x90,0x5f,0x59,0xcc,0x14,0xa8,
        0x83,0xcc,0x21,0x86,0x3a,0x0f,0xe0,0xe8,0x99,0x64,0x1f,0xd2,0x85,0xd9,0x99,0xbc,
        0x1a,0xd1,0x24,0x94,0x53,0x80,0x63,0xd2,0x72,0xd0,0xf0,0xab,0xe6,0x11,0xf3,0x1d,
        0x2a,0xda,0x3a,0xb6,0x77,0x41,0xa9,0xb5,0xe4,0xe7,0x1d,0x8c,0xf3,0xde,0x2d,0xc9,
        0x28,0x57,0xa7,0xc5,0x58,0xba,0xe2,0xe0,0x9e,0xc2,0x99,0x99,0xdd,0xe6,0xaf,0x01,
        0x9e,0x82,0x15,0x57,0xd2,0x82,0xd5,0xd5,0x61,0x06,0x83,0xd5,0xff,0x81,0x2b,0xfc,
        0xa9,0x6d,0x42,0xcb,0x4b,0x70,0x11,0x64,0x92,0x36,0x8c,0x28,0xe6,0x9e,0x6c,0x6a,
        0x56,0x63,0x8c,0xda,0x7c,0xd7,0xb7,0x1e,0x57,0xd8,0x99,0x8d,0x88,0x55,0x18,0xc1,
        0xb7,0x1d,0x80,0xa5,0x81,0x42,0x67,0x44,0xf1,0xd0,0x55,0xfe,0x85,0xfe,0x0e,0x6a,
        0xf6,0x3a,0x4a,0x02,0x3b,0x01,0x3b,0x78,0x11,0x01,0x5c,0x89,0xdf,0xe4,0xa9,0x6f,
        0x8f,0x22,0xb9,0x24,0xe7,0x3e,0x2f,0xa1,0x6f,0x19,0x2b,0x3c,0x4b,0x56,0xb2,0x5d,
        0xd3,0x48,0x2d,0xd4,0x66,0xfb,0x84,0x6f,0x91,0x78,0x7b,0x64,0xb1,0x7f,0xa1,0x80,
        0x64,0x8a,0xcf,0x10,0xd1,0xa8,0xab,0xbd,0x3c,0x7c,0xed,0xba,0x80,0x85,0xae,0x95,
        0x44,0x14,0x35,0x58,0x14,0xae,0x51,0x32,0xb3,0x66,0x74,0x08,0xd1,0xb4,0x7c,0x62,
        0x54,0x47,0x12,0x08,0xee,0x5c,0x4a,0xd8,0xee,0x48,0x82,0x1c,0x37,0xba,0x29,0x93,
        0xf5,0xdc,0xbc,0x2f,0xdf,0xaa,0xa5,0xf9,0x1f,0xd7,0x3e,0x0d,0xd9,0xea,0x59,0x03,
        0xa6,0x46,0xce,0xea,0x17,0xaa,0x32,0x76,0x15,0x7f,0xd1,0x96,0x55,0xeb,0x63,0x79,
        0x33,0xdf,0x97,0xc7,0x60,0x2a,0xed,0x04,0xe3,0x24,0xfd,0xaf,0xbc,0x86,0x02,0x8f,
        0x95,0x25,0x13,0x04,0xcc,0x9d,0xeb,0xfe,0x1f,0x07,0x28,0xde,0x01,0x80,0x4c,0x58,
        0xf4,0x27,0x41,0xdd,0x07,0xe3,0xef,0x44,0xd9,0xc3,0x11,0x6b,0x83,0x66,0xbe,0x30,
        0x53,0x7b,0x1e,0x09,0x79,0xf0,0x8f,0x3b,0xd2,0xfe,0x97,0xae,0xf5,0x39,0x9a,0x76,
        0x3b,0x8f,0x74,0x98,0x1b,0x4f,0x18,0xb4,0xe0,0xc8,0x3a,0x1d,0x86,0x08,0x01,0x9d,
        0x07,0x35,0x8b,0x91,0x00,0xe9,0x4c,0x1a,0x55,0xae,0xe5,0xab,0x2c,0xbd,0xbb,0x7d,
        0xa8,0xd2,0x29,0x11,0x84,0xe4,0xbc,0x9c,0xf2,0x8f,0x20,0x87,0x75,0x87,0x78,0x0c,
        0x48,0x20,0xc2,0x4b,0xf1,0x53,0xb6,0x69,0xb7,0xe5,0xca,0x8b,0x7d,0x3e,0xb3,0x98,
        0x0a,0x51,0xc2,0x8d,0x60,0x9f,0xb1,0x8f,0x6e,0xd2,0x10,0xb2,0x24,0x44,0x3a,0xee,
        0x30,0x40,0x20,0x3f,0x70,0x21,0x0c,0xa1,0x44,0x1e,0x40,0xd3,0x71,0xb4,0x45,0x14,
        0x59,0x20,0xcd,0x96,0xeb,0x5f,0x91,0x5d,0x0d,0x27,0x68,0xa0,0xf7,0x31,0x63,0xd3,
        0xfb,0xfd,0x11,0xd5,0x99,0x61,0x3b,0x5a,0xc4,0x43,0x1d,0xcf,0x97,0x5d,0x4d,0xce,
        0x4c,0x01,0x6b,0x43,0x34,0xb5,0xb3,0xec,0x29,0x47,0x8b,0x47,0xff,0x36,0xc9,0xe6,
        0x1c,0xf8,0x39,0x92,0x4d,0x42,0xca,0xf4,0xfd,0x20,0x3f,0x28,0x85,0xd8,0xbc,0xc5,
        0x40,0xff,0xd6,0x9c,0xd1,0x0e,0x3d,0x1e,0xde,0xce,0xc7,0x1a,0x97,0x4a,0x7a,0x0f,
        0xab,0xf4,0x22,0xef,0x38,0x2a,0x28,0xf1,0xb6,0x13,0xbf,0x34,0xc3,0xae,0x6c,0x09,
        0x0d,0x0d,0xb9,0xf3,0x0e,0x93,0x7b,0x89,0xb5,0x91,0xbe,0xcb,0x4c,0x8b,0x92,0xea,
        0xfb,0xbb,0x56,0xba,0x7b,0x43,0x59,0x73,0x92,0xa2,0xd5,0x58,0x35,0x81,0x8e,0x87,
        0xe9,0xe2,0x4f,0xeb,0xca,0x8a,0x82,0x1a,0x89,0xb1,0xb7,0x9b,0xbb,0x08,0xcb,0xbc,
        0x44,0x7b,0x0e,0xb7,0x85,0xf4,0x95,0x70,0x71,0x4e,0x57,0x33,0x6b,0xd3,0xe1,0x8f,
        0x64,0xff,0x93,0xc3,0x31,0xf6,0x2e,0x4c,0xc6,0xf4,0x9c,0x96,0xff,0xbe,0xd1,0xcb,
        0x07,0x47,0x93,0x54,0xd1,0xac,0xf7,0x79,0xc3,0xb2,0xed,0xff,0x1f,0x68,0x7e,0xab,
        0x86,0xa9,0xde,0x20,0x49,0xe9,0x8e,0x44,0x8f,0x66,0x99,0x2f,0xe5,0x03,0x9b,0xd9,
        0x15,0x96,0x8f,0xa3,0x3f,0x14,0x6a,0xd3,0xb6,0x4c,0x0f,0x30,0x9f,0x14,0x6c,0x3a,
        0x2e,0xc2,0xc7,0x42,0xb9,0x5a,0x57,0xdf,0xed,0x27,0xb3,0x2e,0xe2,0x60,0xed,0x49,
        0xdf,0x85,0x1b,0x9a,0x86,0xf9,0x59,0xc3,0x4e,0xb1,0x4d,0x88,0x49,0x4a,0xe5,0xd8,
        0x90,0xfa,0x54,0xc2,0xef,0x1b,0xb2,0xdb,0xb9,0xf8,0x1e,0x48,0x70,0x9f,0xcf,0x48,
        0x18,0xec,0x59,0xd0,0x0b,0x62,0x57,0x12,0xdc,0xe4,0x70,0xe5,0x5c,0x7f,0x22,0x1f,
        0x88,0x0f,0x01,0x14,0x7c,0xfd,0x57,0xc7,0xaf,0xe1,0x99,0x90,0x6a,0x31,0x5b,0x4c,
        0xf6,0xa2,0x2b,0x0b,0x3c,0x41,0x8c,0x6a,0x32,0xe9,0x15,0x57,0x8e,0x79,0x7a,0x20,
        0x99,0x1a,0x9b,0x0c,0x48,0xf6,0xbd,0xc5,0xfa,0xe3,0xa8,0x44,0xbe,0x43,0x82,0xa0,
        0x6f,0x1e,0x95,0x13,0xe7,0x48,0x3f,0x97,0x8a,0x4a,0xf1,0x1a,0x38,0xb7,0x36,0x7b,
        0xd6,0x42,0xab,0x7b,0x67,0xa0,0x97,0x84,0xa2,0x1e,0x9f,0x24,0x4d,0x64,0x6b,0x5d,
        0xc9,0xd5,0x5c,0x34,0x65,0x48,0xa8,0xcb,0x66,0xde,0x86,0x27,0x22,0xb8,0x9c,0xb5,
        0xcc,0xc6,0x04,0x03,0xed,0x30,0x08,0x63,0xbc,0x78,0xcf,0x22,0xd8,0x7c,0xb5,0xa8,
        0x0c,0xf1,0xb0,0xcb,0x39,0x88,0xb5,0x02,0x93,0xcb,0x06,0x09,0xed,0x4d,0x6b,0xba,
        0xa5,0x8a,0xdc,0x74,0xc6,0xd1,0xf3,0x1a,0xd5,0x07,0x10,0x27,0xea,0xd8,0xd8,0xb1,
        0x6b,0xc8,0x4b,0x5a,0x7d,0xde,0x4c,0x8e,0xe1,0x7e,0x87,0x1e,0x0f,0xa6,0xf6,0x10,
        0x09,0xde,0x4a,0xeb,0x89,0xd5,0x4f,0x90,0x72,0x01,0x5e,0xb3,0x82,0x28,0x52,0xe5,
        0x17,0x4f,0xd2,0x91,0xce,0x62,0x9d,0xd8,0x27,0x78,0x56,0x3b,0x4d,0x82,0x5f,0x3e,
        0xbf,0xed,0xb2,0xe7,0x96,0x06,0xa8,0xdc,0xc3,0x16,0x12,0xff,0x8f,0x9c,0xec,0x4c,
        0x72,0x0e,0x8f,0x46,0x63,0xf7,0x01,0x59,0x8b,0x87,0xfd,0xbe,0x41,0x0c,0x84,0xca,
        0x9b,0xf1,0x44,0x5f,0x23,0x33,0xfb,0x91,0xa3,0xb0,0x19,0x24,0xa3,0xf3,0xb4,0xad,
        0x54,0xf2,0x6c,0xd3,0x13,0x23,0x98,0x9b,0x7c,0x21,0x56,0xf9,0xe9,0x56,0x78,0x33,
        0x8c,0x82,0x9b,0x6f,0x72,0x6d,0x38,0x08,0xb8,0x33,0x52,0x26,0xaf,0x9f,0xd2,0xe0,
        0x6c,0xbd,0x75,0xeb,0x19,0x80,0xf0,0x16,0x0e,0xdd,0x75,0xe1,0x36,0x1d,0xb3,0x76,
        0xc3,0xbe,0x31,0x48,0x8a,0x26,0x88,0x8b,0x31,0x3a,0x73,0x9c,0xa3,0xc6,0x7c,0x37,
        0x91,0xf8,0x38,0x47,0x3b,0x78,0xaa,0xff,0x44,0x30,0xc2,0x7e,0xdf,0x6e,0x61,0x65,
        0xa3,0x81,0x49,0x4c,0xef,0xc6,0x99,0xb8,0xff,0x79,0x9c,0xe9,0x21,0x70,0x81,0x9b,
        0xa7,0xbb,0x57,0xba,0xae,0x22,0x21,0x3e,0xf1,0xc3,0x84,0xf2,0xa7,0x19,0x8c,0x44,
        0xf0,0x85,0xea,0x0f,0x17,0xbd,0x06,0x07,0xb7,0x8a,0x0e,0xca,0xa7,0x72,0x6a,0x2c,
        0xad,0x2d,0xb3,0x96,0x9a,0x74,0xf0,0x9c,0xcd,0x44,0xe9,0x30,0x14,0xb3,0xad,0x48,
        0xdd,0xa8,0xf7,0x8f,0xdc,0x61,0x7e,0xe4,0xb5,0x11,0x79,0xe4,0x1a,0x37,0x35,0x16,
        0x5e,0xda,0x1d,0xd9,0x67,0x91,0x6a,0xd2,0xaf,0x84,0x67,0x4f,0x26,0x7b,0x75,0xcc,
        0x1b,0x6b,0xd4,0xfb,0x4f,0xde,0xb5,0x62,0x87,0xe8,0xb6,0xac,0xa6,0xb6,0x03,0xfe,
        0xab,0xbb,0xa9,0x21,0x9a,0x09,0xa3,0xbf,0xd4,0xe7,0x3e,0x33,0x77,0x4d,0x6a,0xa4,
        0x80,0x8c,0x68,0xa6,0x16,0x27,0x97,0x40,0x9e,0x97,0x46,0x73,0xba,0xb1,0x05,0x8b,
        0xd1,0x8c,0x8b,0xbd,0x24,0x6e,0x41,0x4d,0x80,0xc2,0xe7,0x25,0xa7,0xa9,0xf6,0x94,
        0x76,0x48,0xe1,0xca,0xce,0xbf,0x77,0x9f,0xd6,0x37,0xa6,0x20,0x20,0x5e,0xe5,0xb5,
        0x69,0xea,0x7f,0x06,0x64,0x18,0x40,0x8f,0x52,0x96,0x99,0xa5,0x3d,0x41,0xfc,0x28,
        0xd5,0x29,0x52,0x7f,0x3d,0xb8,0x53,0x4b,0x00,0x10,0x09,0xdf,0xb0,0xf6,0xb5,0x0e,
        0xb2,0x4a,0x5b,0x58,0x94,0xdb,0xbb,0x28,0x7e,0xce,0xbe,0x41,0x1b,0xcb,0x56,0x27,
        0x30,0xe0,0xc4,0x5a,0x96,0xd1,0x6a,0x58,0x01,0x50,0x6d,0x1e,0xd2,0xcf,0xeb,0x43,
        0x6b,0x21,0x7f,0xe0,0x47,0x80,0xa6,0x18,0xd4,0x16,0x4f,0x11,0x49,0xf6,0x3b,0x75,
        0x54,0xfe,0xf2,0x47,0x06,0xd7,0x0a,0x57,0xa4,0x8c,0xfc,0xda,0xe9,0x26,0xb0,0x6a,
        0xde,0xf2,0x7f,0x75,0x3f,0x16,0xbe,0x43,0xa4,0x63,0x34,0x11,0x59,0xe8,0xbd,0x74,
        0xea,0x8a,0xb0,0xdf,0xa6,0x75,0xf3,0xd0,0x50,0x51,0xbd,0x96,0xd1,0x08,0xc4,0xed,
        0x63,0x1a,0x5f,0x84,0xed,0x10,0xfa,0x10,0xfe,0xf1,0xf2,0x8b,0x63,0x9f,0x1d,0x04,
        0x48,0x05,0x75,0x84,0x76,0x12,0x0e,0x0f,0xe7,0xf5,0x73,0x00,0xba,0xb6,0xd2,0x1a,
        0xb2,0x46,0x12,0xc1,0x4e,0x12,0x44,0x7d,0x08,0xa6,0xcb,0xa1,0x3b,0x73,0x0a,0x82,
        0xc6,0xaf,0x62,0xb2,0xba,0x02,0x28,0x77,0xf2,0x38,0x7a,0x99,0xf2,0xd6,0xf3,0xfe,
        0xf7,0xcf,0x10,0xa5,0x38,0x89,0xdf,0x8c,0x95,0xcc,0x25,0x80,0x5f,0x83,0x12,0x10,
        0xbb,0xd6,0xe4,0x63,0xf7,0x02,0x80,0xf2,0x8d,0x59,0xc7,0xa1,0x33,0x15,0x17,0x30,
        0x7c,0xaf,0x3c,0x36,0x0b,0xc2,0x4a,0x89,0x38,0xe8,0x21,0x76,0x5f,0xd9,0xbe,0xd0}, 
        /*TST_dataSize*/
        1536*sizeof(DxUint8_t),       
        CRYS_AES_CTR_mode
    },
    #endif
    #endif
};

/***************************/
/************** CBC MAC Vectors     ********/
/***************************/
TST_AES_MAC_TestDataStruct TST_AES_MAC_Acceptance_TestData[] =
{
        /************/
        /*        AES CBC MAC vectors     */
        /************/
    #if TST_USE_AES_16BYTE_DATA
    { 
        {"Acceptance test - AES/MAC/128Key/16ByteData "},
        /*TST_Key*/     
        {0x2b,0x7e,0x15,0x16,0x28,0xae,0xd2,0xa6,0xab,0xf7,0x15,0x88,0x09,0xcf,0x4f,0x3c},
        CRYS_AES_Key128BitSize,
        /*TST_IvCounter*/
        {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f}, 
        /*TST_input_data*/
        {0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a},
        {0},
        /*TST_dataSize*/
        16*sizeof(DxUint8_t),
        /*TST_Expected_CBC_MAC*/
        {0x76,0x49,0xab,0xac,0x81,0x19,0xb2,0x46,0xce,0xe9,0x8e,0x9b,0x12,0xe9,0x19,0x7d}, 
        CRYS_AES_MAC_mode
    },
    #endif
    #if TST_USE_AES_32BYTE_DATA
	{ 
        {"Acceptance test - AES/MAC/128Key/32ByteData "},
        /*TST_Key*/     
        {0x2b,0x7e,0x15,0x16,0x28,0xae,0xd2,0xa6,0xab,0xf7,0x15,0x88,0x09,0xcf,0x4f,0x3c},
        CRYS_AES_Key128BitSize,
        /*TST_IvCounter*/
        {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f}, 
        /*TST_input_data*/
        {0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a,
         0x65,0xa2,0x32,0xd6,0xbc,0xd0,0xf9,0x39,0xed,0x1f,0xe1,0x28,0xc1,0x3b,0x0e,0x1b},
        {0},
        /*TST_dataSize*/
        32*sizeof(DxUint8_t),
        /*TST_Expected_CBC_MAC*/
        {0xe9,0x32,0x2e,0x95,0x30,0x6b,0x9d,0x25,0x83,0x24,0x2f,0x12,0x1a,0x57,0xb7,0xb6}, 
        CRYS_AES_MAC_mode
    },
    #endif
    #if TST_USE_AES_512BYTE_DATA
    { 
        {"Acceptance test - AES/MAC/128Key/512ByteData "},
        /*TST_Key*/     
        {0x2b,0x7e,0x15,0x16,0x28,0xae,0xd2,0xa6,0xab,0xf7,0x15,0x88,0x09,0xcf,0x4f,0x3c},
        CRYS_AES_Key128BitSize,
        /*TST_IvCounter*/
        {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f}, 
        /*TST_input_data*/
        {0xb6,0xed,0x21,0xb9,0x9c,0xa6,0xf4,0xf9,0xf1,0x53,0xe7,0xb1,0xbe,0xaf,0xed,0x1d,
         0xf3,0xee,0xd1,0xbd,0xb5,0xd2,0xa0,0x3c,0x06,0x4b,0x5a,0x7e,0x3d,0xb1,0x81,0xf8,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0x62,0xf8,0xa7,0x23,0x7b,0xbd,0xf8,0x4d,0x4e,0x1d,0xff,0xe8,0xb5,0x2a,0x02,0xc1,
         0x52,0xdb,0x14,0x2f,0xeb,0x21,0xf9,0x58,0xb8,0x80,0x28,0x68,0xe4,0x99,0x06,0x18,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0xb6,0xed,0x21,0xb9,0x9c,0xa6,0xf4,0xf9,0xf1,0x53,0xe7,0xb1,0xbe,0xaf,0xed,0x1d,
         0xf3,0xee,0xd1,0xbd,0xb5,0xd2,0xa0,0x3c,0x06,0x4b,0x5a,0x7e,0x3d,0xb1,0x81,0xf8,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0x62,0xf8,0xa7,0x23,0x7b,0xbd,0xf8,0x4d,0x4e,0x1d,0xff,0xe8,0xb5,0x2a,0x02,0xc1,
         0x52,0xdb,0x14,0x2f,0xeb,0x21,0xf9,0x58,0xb8,0x80,0x28,0x68,0xe4,0x99,0x06,0x18,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0xb6,0xed,0x21,0xb9,0x9c,0xa6,0xf4,0xf9,0xf1,0x53,0xe7,0xb1,0xbe,0xaf,0xed,0x1d,
         0xf3,0xee,0xd1,0xbd,0xb5,0xd2,0xa0,0x3c,0x06,0x4b,0x5a,0x7e,0x3d,0xb1,0x81,0xf8,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0x62,0xf8,0xa7,0x23,0x7b,0xbd,0xf8,0x4d,0x4e,0x1d,0xff,0xe8,0xb5,0x2a,0x02,0xc1,
         0x52,0xdb,0x14,0x2f,0xeb,0x21,0xf9,0x58,0xb8,0x80,0x28,0x68,0xe4,0x99,0x06,0x18,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0xb6,0xed,0x21,0xb9,0x9c,0xa6,0xf4,0xf9,0xf1,0x53,0xe7,0xb1,0xbe,0xaf,0xed,0x1d,
         0xf3,0xee,0xd1,0xbd,0xb5,0xd2,0xa0,0x3c,0x06,0x4b,0x5a,0x7e,0x3d,0xb1,0x81,0xf8,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0x62,0xf8,0xa7,0x23,0x7b,0xbd,0xf8,0x4d,0x4e,0x1d,0xff,0xe8,0xb5,0x2a,0x02,0xc1,
         0x52,0xdb,0x14,0x2f,0xeb,0x21,0xf9,0x58,0xb8,0x80,0x28,0x68,0xe4,0x99,0x06,0x18,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9},
        {0},
        /*TST_dataSize*/
        512*sizeof(DxUint8_t),
        /*TST_Expected_CBC_MAC*/
        {0x36,0xec,0x30,0xb4,0x31,0x63,0xe7,0x16,0x1c,0x11,0x19,0x7a,0x2a,0xa6,0xff,0x8c}, 
        CRYS_AES_MAC_mode
    },
    #endif
    #if TST_USE_AES_1536BYTE_DATA
    {
        {"Acceptance test - AES/MAC/128Key/1536ByteData "},
        /*TST_Key*/     
        { 0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f},
        CRYS_AES_Key128BitSize,
        /*TST_IvCounter*/
        {0x00}, 
        /*TST_input_data*/
        {0x12,0xa8,0xb2,0x61,0x5d,0x01,0x3b,0x47,0x65,0xf6,0x72,0xa3,0x97,0xd5,0xbc,0x50,
        0x2c,0x7e,0xc9,0x50,0xf2,0x17,0x77,0x1b,0x50,0x01,0xf4,0x37,0x84,0x0a,0x23,0x09,
        0x30,0xe4,0x42,0xeb,0x15,0xd6,0xc9,0x7f,0x1e,0xb1,0x95,0x42,0xa0,0x06,0x45,0x64,
        0xe0,0x96,0xe5,0xd7,0xd6,0x0a,0xca,0xa6,0x30,0xe4,0xbc,0x88,0x9a,0xb6,0x5b,0xb5,
        0x3d,0x91,0xbb,0xf8,0x85,0xc1,0x52,0x05,0x28,0xb7,0x14,0x0e,0x64,0x47,0xdc,0x91,
        0x88,0x14,0x0e,0x74,0xb5,0x48,0x7a,0x53,0xe6,0x88,0x84,0x19,0x2e,0x27,0x82,0xcd,
        0x41,0x99,0x66,0xaf,0x36,0x2b,0x9d,0x84,0x8b,0xf2,0x37,0x2e,0x6a,0x01,0x47,0x7f,
        0x2a,0xdf,0x8d,0x4f,0x19,0x39,0x52,0xcc,0x79,0xd3,0x94,0x12,0xc8,0xc4,0x63,0xfc,
        0x45,0xe3,0x8b,0x39,0xaf,0x7d,0x73,0xa2,0x50,0x49,0x45,0xca,0x3a,0x9d,0x4f,0xd7,
        0xd1,0xe1,0xaa,0x91,0x89,0x45,0x19,0xb9,0xf1,0xaf,0x33,0x9c,0xf1,0xf7,0xc5,0xe8,
        0x4f,0x57,0x72,0xbd,0x78,0x1d,0x9c,0x07,0x7e,0xa3,0x88,0x0c,0x5d,0x81,0xbc,0x41,
        0x82,0x01,0xac,0x62,0x8e,0xd4,0x96,0xc1,0x57,0x03,0xab,0xdf,0x2f,0x28,0x6f,0x39,
        0x6a,0xdd,0x62,0x64,0x1a,0x75,0xe0,0x5c,0x1d,0xea,0x46,0x1a,0x5a,0x17,0x56,0x64,
        0x47,0x27,0xdd,0xe9,0xaf,0x4e,0x92,0x8d,0xb2,0xb7,0x42,0x02,0x0d,0xbd,0x2a,0x98,
        0x9b,0x5d,0xa5,0x56,0x1c,0xeb,0x07,0x49,0x36,0x05,0xc8,0x1c,0xb9,0xc6,0xe5,0xe9,
        0x27,0x3b,0x83,0x4f,0x74,0x1b,0xd5,0xc5,0x0a,0xb2,0x41,0x2d,0x10,0x1f,0xbe,0xad,
        0xec,0xbf,0x81,0xba,0x06,0xe9,0xd8,0x75,0xcf,0xdc,0x56,0x3b,0x03,0xf5,0x30,0x77,
        0x2b,0x26,0xe7,0xbb,0x65,0xa3,0x27,0x10,0x67,0xde,0xf0,0x8a,0xc2,0xb6,0xf3,0x1f,
        0x64,0xeb,0x3f,0xb8,0x61,0xd6,0x1c,0x89,0xf3,0x57,0x37,0x9e,0xbf,0x0e,0x00,0xb7,
        0x59,0xce,0x51,0x56,0x0b,0x4e,0x50,0x16,0xd2,0x22,0x96,0x3e,0xaa,0xea,0x91,0x96,
        0x0b,0xca,0x26,0x7a,0xb4,0x1a,0x9b,0x2c,0xa7,0x5e,0xb5,0x6f,0x75,0x78,0x1d,0x51,
        0xbb,0x1c,0x08,0x48,0xed,0x85,0x17,0x80,0x52,0x66,0x7c,0x74,0x50,0x24,0x5f,0xbc,
        0xea,0x42,0x80,0x25,0x87,0x1d,0x1d,0x07,0xf5,0xd9,0x16,0xd3,0xad,0x9b,0x4f,0xec,
        0x59,0xf8,0x56,0xb8,0x93,0xae,0x46,0xf6,0xf0,0x92,0xeb,0x52,0x3d,0xca,0x26,0x36,
        0x08,0x3c,0x93,0xe4,0x63,0x46,0x6a,0xc2,0xe4,0xb0,0xa3,0xf4,0xf0,0xdf,0x5e,0x30,
        0x39,0x4b,0x81,0xce,0x86,0x33,0xa3,0x1f,0xb3,0x8f,0x29,0x00,0xf8,0x46,0xae,0xaf,
        0x6e,0xa1,0xa9,0xdd,0xce,0xff,0x49,0x04,0x7c,0xcb,0xa4,0xfa,0xc5,0xac,0x11,0xc7,
        0x65,0xfb,0xd2,0xb4,0x4d,0x7a,0xf7,0xa4,0xa3,0x43,0x7e,0xa7,0x09,0xfe,0xbf,0xcd,
        0x22,0x57,0x08,0x38,0x52,0xb0,0x84,0x75,0xc6,0x12,0x61,0x0d,0xb5,0x6a,0x31,0x56,
        0xe5,0xf2,0x91,0x8f,0x70,0xed,0x09,0x2c,0xc8,0x97,0x34,0x6f,0xf9,0x5c,0x21,0x38,
        0x2e,0x48,0xf8,0x1e,0x77,0xbf,0xe1,0xbe,0xc9,0x6e,0x21,0x53,0x47,0x81,0x86,0x88,
        0xbf,0x16,0x06,0x8a,0x78,0xf2,0xa3,0x60,0x2b,0x73,0x92,0x7f,0x4f,0xc6,0x9b,0x99,
        0x99,0x5a,0xc3,0xb7,0xc4,0x95,0x29,0x87,0x8e,0xc5,0x2e,0xf7,0x03,0x59,0xd8,0x02,
        0xfd,0x51,0x79,0xca,0xec,0xf3,0x8b,0xe8,0xd3,0xc0,0xdf,0x00,0x93,0xa6,0xf7,0x98,
        0x6c,0x77,0xb0,0x2a,0xc1,0x9a,0x23,0x77,0x1b,0x01,0xce,0x1f,0x71,0x5a,0xef,0x6f,
        0xa7,0x8a,0x31,0x7a,0x54,0x57,0x8a,0x6b,0xc8,0x64,0x64,0x19,0x4e,0x63,0xfb,0xdc,
        0xae,0x86,0x06,0xa0,0xf6,0x36,0x99,0x37,0x7a,0x08,0x4a,0xf4,0x1a,0xed,0x93,0x75,
        0xc3,0xa9,0x77,0xc0,0x39,0x86,0x68,0x92,0x13,0x49,0x69,0xf3,0x07,0x65,0x70,0x0e,
        0x67,0x6f,0x0e,0x40,0xec,0xd2,0x51,0x6f,0xb3,0xc4,0xea,0x9d,0x85,0x78,0x8b,0xbc,
        0x5b,0x95,0x93,0xc4,0x21,0xe8,0xed,0x04,0xbb,0x55,0x35,0xb5,0x46,0x14,0x1d,0xd5,
        0xa0,0x1a,0x10,0x33,0x2a,0xd4,0x15,0xc6,0xcc,0x1b,0xf5,0x42,0x3a,0x65,0xa0,0xed,
        0x76,0x38,0xcd,0xaf,0x97,0xe5,0xe1,0x69,0xc8,0x72,0x12,0x88,0x93,0xd8,0xcc,0xda,
        0x60,0x6f,0x53,0xa0,0x38,0xa6,0xab,0xe4,0xcf,0xf7,0xb5,0x0d,0xc2,0x1a,0x9a,0xb0,
        0x1d,0x79,0x6c,0xa9,0x20,0xe5,0x0b,0x6b,0x43,0x87,0x46,0x94,0x77,0x19,0x43,0xc5,
        0xaf,0x56,0x21,0xb0,0x9f,0xae,0xdb,0x72,0xc3,0x3f,0x70,0x24,0xa4,0x01,0x41,0xac,
        0x57,0x40,0xba,0xd9,0x46,0x50,0x34,0xb0,0x33,0x7c,0x1a,0x00,0x79,0x3f,0x4b,0x3d,
        0x95,0xb7,0xc0,0x8a,0xe6,0x56,0x6f,0x18,0xb1,0xdb,0x6f,0xaf,0x68,0x80,0x5c,0x8a,
        0x2c,0x75,0xfd,0x68,0x90,0x8e,0x24,0xe0,0xa0,0x39,0xd6,0xf5,0x22,0xb2,0xac,0xea,
        0x1b,0x7a,0x79,0x58,0x95,0x05,0x2d,0x7d,0xa0,0xb2,0xfa,0xd7,0x97,0x01,0xb5,0xf1,
        0xa4,0x01,0x7e,0x7e,0x86,0x07,0xa3,0xa4,0x92,0xa5,0xc2,0x9a,0xf8,0xda,0x2e,0x75,
        0x48,0x87,0x94,0x3f,0x35,0x22,0xdf,0x4a,0x98,0xae,0x58,0xc3,0xb8,0xeb,0x12,0x8a,
        0xc8,0xca,0x85,0x41,0xb1,0x23,0x79,0xa4,0x12,0xaa,0x26,0x18,0x85,0x20,0x99,0x86,
        0x25,0xc6,0x59,0x69,0x4d,0x17,0x4b,0x26,0xa2,0xb6,0xd3,0x9d,0x53,0xa6,0x3c,0xfd,
        0x9f,0xb9,0x5a,0xdc,0x98,0x4b,0x6d,0x87,0x27,0x2f,0x49,0x96,0x51,0xea,0xb4,0xc4,
        0xb8,0x1f,0x10,0xfe,0x65,0x4b,0x3a,0xba,0xc4,0xb3,0xb1,0x8a,0xf0,0x9a,0xfb,0xf1,
        0x31,0xb6,0x44,0x75,0xc4,0xe5,0x49,0xf5,0xda,0x1d,0x74,0x3d,0xe2,0xa1,0x48,0xd8,
        0x0b,0x7b,0x00,0x25,0x05,0x26,0x73,0xae,0x08,0x8b,0x3b,0xb4,0x18,0x2f,0x16,0x0f,
        0x87,0xaa,0x8c,0x35,0xbb,0x5b,0xd3,0x98,0x32,0x5a,0xef,0x35,0xc2,0xae,0x1d,0x69,
        0x26,0xc0,0x72,0x07,0xb6,0x10,0xc0,0xa9,0x76,0x27,0xb9,0x43,0x52,0xcd,0x57,0xfe,
        0xa8,0x7b,0x7b,0x43,0x07,0x13,0xd4,0x15,0x37,0xcf,0x02,0xa5,0x79,0x77,0xfb,0x20,
        0x0f,0xd8,0xae,0xcc,0xff,0x71,0xe7,0x53,0x15,0x6f,0x73,0x5f,0x27,0xdc,0x84,0x66,
        0x9c,0x13,0x57,0xc8,0x2f,0x77,0x13,0x17,0xf1,0x64,0xf5,0xb5,0x8d,0x66,0xaa,0xa5,
        0xd0,0xa9,0xfc,0x9b,0x69,0xb1,0xb1,0x55,0xed,0x4b,0xb0,0x2e,0x1e,0xc4,0x66,0xf1,
        0x6c,0x58,0x68,0xeb,0xbc,0xed,0x5a,0x44,0x69,0x02,0x0f,0x8f,0x88,0xe2,0xf1,0x9f,
        0x71,0x1d,0xa4,0x9c,0x7b,0x38,0xe6,0x57,0x06,0xa4,0xba,0xdb,0xbf,0xed,0xc5,0x45,
        0x1f,0x34,0xf8,0xd5,0x35,0xdf,0x6f,0x44,0xa6,0x8f,0x99,0x58,0xf2,0x52,0x9a,0xb7,
        0xf8,0x1b,0xed,0xf9,0xbd,0x6f,0x4e,0x00,0x69,0x60,0xd7,0x8c,0x92,0xbf,0x69,0x0a,
        0xbd,0x8e,0x4d,0xad,0x22,0xb4,0x1b,0xc0,0xb0,0xf4,0xdb,0x3b,0x51,0x20,0x6b,0x94,
        0x6f,0x8a,0x21,0xd7,0xb7,0xbc,0xb0,0xf9,0x1d,0x69,0x50,0x6a,0x20,0xa3,0x19,0xe9,
        0x4f,0x4d,0xb0,0x9c,0x0c,0xd4,0x26,0x60,0x90,0x1a,0x1d,0x5e,0x2f,0xb3,0x2d,0xdf,
        0xdd,0x54,0x86,0x61,0xf2,0x88,0xd6,0xe9,0x2a,0xa5,0x6d,0x9c,0xf0,0xff,0x9f,0x89,
        0xdc,0x5b,0x69,0xca,0x7a,0xa7,0x58,0xcb,0x4d,0xe8,0xa7,0xe9,0x13,0x73,0xa7,0x3f,
        0x4b,0x60,0x64,0xbc,0xf5,0x3c,0x86,0x79,0x99,0xfe,0x75,0x4a,0x8a,0x3c,0xc1,0x94,
        0x6c,0x9f,0xc0,0x5e,0xf4,0x95,0x79,0xaa,0xef,0x45,0xc0,0x05,0x86,0xc8,0xa3,0x5d,
        0xc0,0x96,0x05,0x13,0x48,0x3e,0x89,0x51,0x71,0x5b,0xb2,0x9e,0x77,0xc3,0x48,0xaf,
        0x08,0x01,0xfd,0x80,0x02,0x06,0x50,0xa4,0x7f,0x1b,0xb2,0xda,0x0f,0x1a,0xe7,0xe0,
        0x44,0xde,0xb0,0x8c,0x74,0xf8,0xa7,0x18,0xba,0xa3,0x6a,0xbe,0x3e,0xfb,0xfb,0x84,
        0xb6,0x69,0x67,0x5a,0x2d,0x62,0xa6,0x62,0x03,0x51,0xc3,0x8f,0x36,0xd1,0x3d,0x71,
        0xdf,0x20,0xac,0x4f,0x00,0xd0,0xa7,0x77,0x7c,0xc0,0xe6,0xd2,0x67,0x4b,0xa4,0xbb,
        0x80,0xbf,0x47,0x11,0xfc,0x11,0x43,0x8b,0x86,0xcf,0x3c,0x4c,0x83,0x55,0x6b,0xb8,
        0x9a,0x44,0x42,0x85,0x74,0x30,0x53,0x15,0xc0,0x99,0x6e,0x03,0x7b,0x1d,0x09,0xfc,
        0x6e,0xeb,0xe5,0xd0,0xf8,0x7b,0xef,0xc8,0x0d,0x7d,0x65,0x3b,0x7f,0x0f,0x39,0x5c,
        0x7c,0x32,0xba,0x56,0x59,0x7f,0x71,0x9b,0x8d,0x16,0x49,0x78,0x01,0xd8,0xf4,0xee,
        0x87,0xd6,0x89,0xbd,0xa7,0x08,0x72,0xc1,0xa2,0x43,0x85,0x81,0xb1,0x65,0x71,0x06,
        0x8e,0xd3,0x5c,0xe9,0x35,0x25,0xca,0xb0,0xec,0x1f,0xc1,0x5b,0x81,0xe3,0x2b,0x39,
        0xd3,0x66,0x7b,0x00,0x93,0x21,0x93,0x1d,0x4c,0x09,0xe5,0x49,0xa1,0xc0,0xd9,0x5d,
        0xd7,0x0d,0x6f,0x67,0x93,0x8a,0x26,0xfd,0xe4,0x9c,0x1c,0xd1,0x83,0xa8,0x76,0x86,
        0x5a,0x84,0x02,0xc2,0x44,0x2c,0x1b,0x85,0x14,0xb7,0xce,0xb9,0xd8,0x89,0x3b,0x0a,
        0x5f,0xc9,0x3d,0xf7,0xf8,0x16,0x4d,0x29,0x7d,0x75,0xa3,0x04,0x90,0x8e,0x9f,0x7d,
        0x25,0x19,0x68,0x2b,0x41,0x93,0xd3,0xa0,0x00,0x35,0x86,0xf9,0xdd,0x26,0x5d,0xb4,
        0x2e,0xf0,0x0c,0xc2,0xee,0x31,0x06,0xdd,0xbf,0x93,0x9e,0x1c,0x2f,0xfd,0x6c,0xc5,
        0x3b,0x0b,0xf3,0x62,0x12,0xbc,0x80,0x17,0x1b,0x6b,0x55,0x32,0x38,0x01,0x07,0x04,
        0x4d,0x68,0x25,0xf0,0xfc,0x43,0x1a,0xc1,0xb3,0xdc,0x55,0x40,0xe9,0x5d,0xa7,0x07,
        0xa4,0x44,0xec,0x90,0x3f,0x11,0xed,0x91,0x6a,0x41,0x85,0x8c,0x72,0x80,0x03,0xa1,
        0xc3,0x1b,0xd0,0xa8,0xab,0xb4,0x52,0x7c,0x60,0x39,0x0f,0x99,0x45,0x17,0x16,0xea,
        0x69,0xaa,0x9b,0xdc,0x50,0xf8,0xe1,0xb7,0xf7,0xa0,0x5d,0x2e,0x12,0x0d,0x18,0x35},
        {0},
        /*TST_dataSize*/
        1536*sizeof(DxUint8_t),
        /*TST_Expected_MAC*/
        {0xbf,0x98,0xdb,0xa3,0x4b,0x3d,0x51,0x13,0x57,0x4d,0x2b,0xcb,0x32,0x0c,0xdb,0x25},
        CRYS_AES_MAC_mode
    },
    #endif
    #if TST_USE_AES_192_KEY
    #if TST_USE_AES_16BYTE_DATA
    { 
        {"Acceptance test - AES/MAC/192Key/16ByteData "},
        /*TST_Key*/     
        {0x8e,0x73,0xb0,0xf7,0xda,0x0e,0x64,0x52,0xc8,0x10,0xf3,0x2b,0x80,0x90,0x79,0xe5,
         0x62,0xf8,0xea,0xd2,0x52,0x2c,0x6b,0x7b},
        CRYS_AES_Key192BitSize,
        /*TST_IvCounter*/
        {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f}, 
        /*TST_input_data*/
        {0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a},
        {0},
        /*TST_dataSize*/
        16*sizeof(DxUint8_t),
        /*TST_Expected_CBC_MAC*/
        {0x4f,0x02,0x1d,0xb2,0x43,0xbc,0x63,0x3d,0x71,0x78,0x18,0x3a,0x9f,0xa0,0x71,0xe8}, 
        CRYS_AES_MAC_mode
    },
    #endif
    #if TST_USE_AES_32BYTE_DATA
    { 
        {"Acceptance test - AES/MAC/192Key/32ByteData "},
        /*TST_Key*/     
        {0x8e,0x73,0xb0,0xf7,0xda,0x0e,0x64,0x52,0xc8,0x10,0xf3,0x2b,0x80,0x90,0x79,0xe5,
         0x62,0xf8,0xea,0xd2,0x52,0x2c,0x6b,0x7b},
        CRYS_AES_Key192BitSize,
        /*TST_IvCounter*/
        {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f}, 
        /*TST_input_data*/
        {0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a,
         0x65,0xa2,0x32,0xd6,0xbc,0xd0,0xf9,0x39,0xed,0x1f,0xe1,0x28,0xc1,0x3b,0x0e,0x1b},
        {0},
        /*TST_dataSize*/
        32*sizeof(DxUint8_t),
        /*TST_Expected_CBC_MAC*/
        {0xc5,0x1b,0x8e,0x34,0x07,0x3a,0x94,0x2e,0x27,0x5f,0xb8,0xcd,0x75,0x96,0x6b,0x7f},  
        CRYS_AES_MAC_mode
    },
    #endif
    #if TST_USE_AES_512BYTE_DATA
    { 
        {"Acceptance test - AES/MAC/192Key/512ByteData "},
        /*TST_Key*/     
        {0x8e,0x73,0xb0,0xf7,0xda,0x0e,0x64,0x52,0xc8,0x10,0xf3,0x2b,0x80,0x90,0x79,0xe5,
         0x62,0xf8,0xea,0xd2,0x52,0x2c,0x6b,0x7b},
        CRYS_AES_Key192BitSize,
        /*TST_IvCounter*/
        {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f}, 
        /*TST_input_data*/
        {0xb6,0xed,0x21,0xb9,0x9c,0xa6,0xf4,0xf9,0xf1,0x53,0xe7,0xb1,0xbe,0xaf,0xed,0x1d,
         0xf3,0xee,0xd1,0xbd,0xb5,0xd2,0xa0,0x3c,0x06,0x4b,0x5a,0x7e,0x3d,0xb1,0x81,0xf8,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0x62,0xf8,0xa7,0x23,0x7b,0xbd,0xf8,0x4d,0x4e,0x1d,0xff,0xe8,0xb5,0x2a,0x02,0xc1,
         0x52,0xdb,0x14,0x2f,0xeb,0x21,0xf9,0x58,0xb8,0x80,0x28,0x68,0xe4,0x99,0x06,0x18,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0xb6,0xed,0x21,0xb9,0x9c,0xa6,0xf4,0xf9,0xf1,0x53,0xe7,0xb1,0xbe,0xaf,0xed,0x1d,
         0xf3,0xee,0xd1,0xbd,0xb5,0xd2,0xa0,0x3c,0x06,0x4b,0x5a,0x7e,0x3d,0xb1,0x81,0xf8,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0x62,0xf8,0xa7,0x23,0x7b,0xbd,0xf8,0x4d,0x4e,0x1d,0xff,0xe8,0xb5,0x2a,0x02,0xc1,
         0x52,0xdb,0x14,0x2f,0xeb,0x21,0xf9,0x58,0xb8,0x80,0x28,0x68,0xe4,0x99,0x06,0x18,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0xb6,0xed,0x21,0xb9,0x9c,0xa6,0xf4,0xf9,0xf1,0x53,0xe7,0xb1,0xbe,0xaf,0xed,0x1d,
         0xf3,0xee,0xd1,0xbd,0xb5,0xd2,0xa0,0x3c,0x06,0x4b,0x5a,0x7e,0x3d,0xb1,0x81,0xf8,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0x62,0xf8,0xa7,0x23,0x7b,0xbd,0xf8,0x4d,0x4e,0x1d,0xff,0xe8,0xb5,0x2a,0x02,0xc1,
         0x52,0xdb,0x14,0x2f,0xeb,0x21,0xf9,0x58,0xb8,0x80,0x28,0x68,0xe4,0x99,0x06,0x18,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0xb6,0xed,0x21,0xb9,0x9c,0xa6,0xf4,0xf9,0xf1,0x53,0xe7,0xb1,0xbe,0xaf,0xed,0x1d,
         0xf3,0xee,0xd1,0xbd,0xb5,0xd2,0xa0,0x3c,0x06,0x4b,0x5a,0x7e,0x3d,0xb1,0x81,0xf8,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0x62,0xf8,0xa7,0x23,0x7b,0xbd,0xf8,0x4d,0x4e,0x1d,0xff,0xe8,0xb5,0x2a,0x02,0xc1,
         0x52,0xdb,0x14,0x2f,0xeb,0x21,0xf9,0x58,0xb8,0x80,0x28,0x68,0xe4,0x99,0x06,0x18,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9},
        {0},
        /*TST_dataSize*/
        512*sizeof(DxUint8_t),
        /*TST_Expected_CBC_MAC*/
        {0x5d,0x6b,0x13,0x08,0x77,0x29,0x26,0x84,0xe5,0x67,0xcd,0x12,0x33,0xce,0x65,0x9f},      
        CRYS_AES_MAC_mode
    },
    #endif
    #if TST_USE_AES_1536BYTE_DATA
    { 
        {"Acceptance test - AES/MAC/192Key/1536ByteData "},
        /*TST_Key*/     
        {0x8e,0x73,0xb0,0xf7,0xda,0x0e,0x64,0x52,0xc8,0x10,0xf3,0x2b,0x80,0x90,0x79,0xe5,
         0x62,0xf8,0xea,0xd2,0x52,0x2c,0x6b,0x7b},
        CRYS_AES_Key192BitSize,
        /*TST_IvCounter*/
        {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f}, 
        /*TST_input_data*/
        {0x17,0x7B,0xAD,0x5C,0x66,0xA5,0xDF,0x25,0x89,0xEC,0x5D,0xEB,0x40,0xA7,0xB7,0xDD,
        0x02,0x0E,0xBB,0xA8,0x3E,0x9C,0x21,0xB0,0xD7,0x9B,0x0A,0xD7,0xD7,0x2E,0x5D,0x3C,
        0xE1,0x21,0xAC,0xD2,0xA6,0x4B,0x33,0x54,0x1E,0x7E,0xAE,0xA9,0x19,0x55,0xD3,0xC2,
        0xEA,0xF2,0xC1,0xDD,0x28,0xB1,0x05,0x7B,0x5A,0xFC,0x85,0xCB,0x9B,0x08,0x4E,0x5B,
        0x8E,0x21,0x0A,0x1F,0xFA,0xE5,0x36,0xB7,0xDA,0x67,0x89,0xBF,0xED,0x77,0x97,0x81,
        0xC8,0x47,0xEC,0xE4,0x6D,0x80,0x13,0x30,0x1B,0x30,0x78,0xAA,0xC6,0x67,0xB8,0x16,
        0x30,0x53,0x1A,0xF7,0x4B,0xB4,0xC7,0x05,0xBB,0x09,0x02,0xC1,0x27,0x46,0x8D,0xE2,
        0x64,0x03,0x02,0x53,0x1B,0x69,0xEE,0x0E,0x0D,0xDA,0x03,0xCA,0x6C,0x8C,0xF0,0x72,
        0xAE,0x73,0x8E,0x9A,0x5C,0x9F,0x36,0x14,0x7F,0xE7,0x28,0x63,0x7D,0x51,0x08,0xD5,
        0xA2,0x96,0x45,0xC3,0x65,0x65,0xFB,0xC7,0x65,0x0C,0xEA,0x71,0xB0,0xFD,0x99,0x2F,
        0x18,0x8F,0x13,0xB4,0xB8,0xF3,0x85,0xC4,0xCD,0xEE,0xD3,0x34,0x40,0x8A,0x90,0xBC,
        0xD1,0x2E,0x27,0xD6,0x46,0x2D,0x0D,0x48,0x77,0xC6,0x35,0x50,0xB5,0xC4,0x63,0x82,
        0x4D,0xF9,0x4A,0xED,0x3D,0x54,0x1D,0xAF,0x10,0x81,0xF5,0x76,0x91,0xC7,0x86,0xDA,
        0x7B,0x2D,0x9F,0x82,0xD5,0xC3,0xE8,0xEA,0x81,0xCA,0x3C,0xF1,0xBD,0x35,0x0E,0x08,
        0x8B,0x51,0xE6,0x47,0x3F,0xA2,0x7E,0x7D,0x10,0x78,0xC5,0xC5,0x38,0x97,0xB7,0xB0,
        0x40,0x5B,0xD4,0x88,0x24,0xE1,0xAD,0x8A,0x10,0x5F,0x6C,0x72,0x17,0x2C,0xF1,0xDB,
        0x72,0xEC,0xEA,0x3F,0xE0,0x3E,0x9A,0xD8,0xAE,0x22,0x71,0x5C,0xFD,0x23,0xB2,0xEA,
        0x13,0x8B,0xB0,0x62,0x60,0x86,0xE3,0xA9,0xA4,0x5B,0x37,0xE0,0x36,0x0C,0x65,0xE4,
        0x86,0xEA,0x53,0x4B,0xAC,0x77,0xCF,0x02,0xC0,0xFC,0xD9,0x02,0x70,0x50,0x8D,0xED,
        0xAD,0x81,0x5F,0x8C,0x7B,0x8F,0x7A,0xEB,0x08,0x40,0x9B,0x85,0x06,0xBA,0xA1,0xA2,
        0xBD,0x8C,0xD5,0x12,0xCF,0x66,0x3D,0x9B,0xBB,0xAE,0xA1,0x64,0xAC,0xE1,0x39,0x53,
        0xCE,0x4A,0x32,0xB4,0xAC,0xD9,0x69,0xF7,0x6F,0x67,0x42,0x6C,0xDC,0x4A,0xFB,0x06,
        0x5A,0x37,0x44,0xE3,0x7A,0x7A,0x1D,0x46,0x44,0xC3,0xD0,0xCD,0xED,0x16,0x3F,0x27,
        0x06,0x47,0xB7,0xBC,0x87,0xED,0xF5,0xE4,0x23,0xDE,0xA2,0x68,0x24,0xD1,0xBF,0x71,
        0xB2,0x9B,0x09,0x75,0x9D,0x56,0xD9,0x53,0x2D,0xEC,0x70,0xE9,0x09,0x9B,0x09,0x59,
        0x28,0x1B,0x65,0x94,0x93,0x3F,0x7E,0x6D,0x41,0x5F,0xC0,0x9B,0xD7,0xB5,0x21,0x73,
        0x04,0x5F,0x1A,0x52,0x0D,0xC9,0x89,0xB0,0x6E,0x63,0x8E,0x9A,0x7C,0x0C,0xDB,0x87,
        0xD5,0x49,0x3F,0x08,0x6C,0x2A,0xDD,0x73,0x1C,0x9C,0x34,0x3D,0x96,0x3D,0x7B,0x78,
        0xCA,0xFC,0xE4,0xA9,0x81,0xB6,0x4B,0x5F,0x91,0xB4,0x26,0x2F,0xB0,0xE4,0xF0,0x35,
        0x84,0x38,0xC6,0x8D,0x75,0x19,0x07,0xDA,0x81,0xA6,0x36,0x70,0x95,0x4C,0x19,0x30,
        0xE7,0x16,0xD0,0x80,0x28,0x31,0x06,0x1E,0xFE,0xE0,0x76,0xB7,0x03,0xAD,0xC3,0x38,
        0xAC,0xFF,0xB8,0x5D,0x77,0xEE,0x02,0xB1,0xF5,0x0A,0x28,0xDA,0x7F,0xDB,0xCA,0x45,
        0x9A,0xF5,0x48,0x99,0x13,0x70,0x0C,0x53,0x32,0xA7,0x8F,0x95,0xA2,0x4F,0xD6,0xD3,
        0xE3,0xFE,0xC4,0x96,0x93,0xBC,0xB9,0xF9,0x13,0x1E,0x8A,0x1D,0x08,0x2B,0x9F,0x22,
        0x16,0x30,0x1C,0x0E,0x65,0x29,0x24,0x3C,0xF2,0x65,0x2B,0xCF,0x5E,0x6D,0x0E,0xA5,
        0x33,0x54,0xF7,0x81,0x16,0x33,0xB2,0xDE,0x3C,0x4E,0x85,0xF5,0xE5,0xEF,0x4A,0x06,
        0x08,0x6C,0x7E,0x71,0x33,0xC7,0x6E,0xB9,0xDA,0x88,0xA3,0x2D,0x90,0xE9,0x9A,0xA6,
        0x0F,0xE4,0xE9,0xB4,0x34,0x1D,0x0C,0xE2,0x7E,0x3D,0xD1,0x16,0xA3,0x2E,0x56,0x03,
        0x1B,0x25,0xC7,0xF1,0xEE,0x9D,0x72,0x6B,0xE6,0x3D,0xA7,0x8E,0x90,0x84,0x4E,0x52,
        0xB4,0xDF,0xE5,0x00,0x05,0x95,0xD2,0xEA,0x60,0x9C,0xF2,0xF5,0xF6,0x57,0x15,0xAB,
        0x31,0xA0,0x12,0x6A,0x22,0xA8,0xB7,0x72,0x72,0x7D,0xCD,0xF6,0x76,0x7E,0x52,0xF9,
        0xEF,0x7F,0x62,0xC4,0x49,0x56,0xFD,0x85,0x53,0xDC,0x91,0x52,0xAA,0x7D,0x75,0x8E,
        0x27,0xFC,0x5C,0xEF,0x72,0xE3,0x30,0x0B,0x27,0x73,0x8E,0x87,0xC7,0xDB,0x74,0xE2,
        0x49,0xF9,0x05,0x76,0xF5,0x51,0x62,0xDB,0xA2,0x8C,0x17,0x45,0x17,0x64,0xC7,0xF4,
        0x07,0x3F,0xCF,0x7A,0x22,0x62,0x87,0x0B,0x4E,0x57,0x9C,0xD5,0xC7,0x76,0xBD,0x77,
        0x68,0xAE,0x08,0xB1,0x78,0xFF,0x99,0xD6,0x9A,0x80,0x4C,0xE6,0xCB,0xEB,0xF3,0xC3,
        0xAB,0x99,0x7F,0x88,0x0B,0xFA,0xC0,0xE7,0x71,0xF9,0x27,0x9E,0xB4,0x8C,0x14,0x2C,
        0xCE,0x9F,0xDC,0x68,0x5C,0x16,0x7C,0x08,0xA6,0xF8,0xE0,0xA1,0x16,0xA0,0x3F,0x63,
        0x63,0xD9,0x29,0x2D,0xF7,0x35,0x6B,0x6E,0xEE,0x21,0x3F,0x7E,0xD7,0xFA,0x21,0x0D,
        0x6B,0x20,0x17,0x2C,0x0E,0x8A,0x67,0x95,0x1D,0x77,0xE2,0x13,0x1A,0x1E,0xD0,0xD0,
        0xBA,0xC3,0x3A,0xDA,0x62,0xE6,0x35,0x99,0x33,0x6E,0x7A,0x3A,0xD6,0xFE,0x30,0xAB,
        0xD6,0xD2,0x35,0xF5,0x89,0x13,0x54,0xD9,0x72,0x94,0x10,0x80,0x52,0x58,0x54,0xCF,
        0x50,0x6E,0xC4,0x13,0xC0,0x47,0xAA,0x85,0xEB,0x7E,0xF8,0xA0,0x0F,0x2C,0xBE,0x1E,
        0x46,0x37,0x3C,0x47,0xE8,0xDA,0x47,0xA6,0x6F,0x61,0x68,0xCE,0xD5,0xB5,0x46,0xDB,
        0x19,0xAA,0xE9,0x68,0x3A,0x1C,0xEB,0x8F,0x27,0xB0,0x0A,0x0B,0x1B,0xB4,0xC9,0x45,
        0xD5,0xF1,0x39,0x1B,0x1C,0x0C,0xE7,0x75,0x26,0x1D,0xA4,0x5E,0xDF,0xDC,0xAF,0x36,
        0x37,0x1D,0x86,0x65,0x43,0x56,0xE4,0x29,0x4B,0xAC,0x20,0x38,0xD0,0x3C,0x8A,0xBA,
        0x98,0x22,0xF9,0xE4,0x7B,0x2B,0xBE,0x0D,0xC3,0x73,0x41,0x1C,0x78,0x8C,0xB0,0x4B,
        0x00,0xD4,0xD3,0xFE,0x2D,0x64,0x02,0x7E,0x0C,0x10,0xCF,0x70,0xEC,0xAE,0xA5,0xEA,
        0x93,0xE9,0xC6,0xBD,0xE3,0xCB,0xBA,0x0B,0x5E,0x79,0xA1,0xD0,0x15,0xC8,0xB1,0xBF,
        0xFB,0xD5,0x38,0xFC,0x68,0x8C,0x8D,0x34,0x1F,0x7A,0xD7,0x6A,0x5B,0x4D,0x20,0x15,
        0xCD,0x56,0x89,0x8E,0xC5,0xF3,0x67,0x34,0x19,0xC8,0x9F,0xB4,0xC2,0x32,0x69,0x44,
        0x5F,0x10,0x74,0x17,0x76,0xA9,0x81,0x06,0x5C,0x92,0x9D,0x69,0xF4,0x50,0xB0,0x10,
        0x58,0x8C,0x02,0xBE,0x3F,0x22,0xF9,0x08,0x6D,0x03,0xE2,0xA0,0xED,0xD9,0x71,0xED,
        0x10,0x92,0x0B,0x4B,0xD9,0x09,0x9E,0x24,0xD4,0x82,0x31,0x33,0x56,0xFE,0x40,0xC9,
        0x17,0x8E,0x5B,0x36,0x2F,0xAB,0x05,0x3C,0x16,0x6C,0xAA,0x73,0xC6,0xE1,0x18,0x83,
        0x21,0xB0,0x58,0x61,0x44,0x64,0x37,0x4F,0xEE,0xDD,0xE9,0xBC,0xF1,0xC6,0xB1,0x6E,
        0xC3,0x19,0x88,0x5F,0x7D,0x3B,0xBD,0x64,0x8D,0xCF,0x35,0x6C,0x5F,0x2B,0x5E,0xF3,
        0x6A,0xAE,0x12,0xA6,0xA5,0xDE,0x85,0xB3,0x56,0x0C,0x47,0x51,0xC2,0x48,0x4A,0x4F,
        0xBA,0x3B,0xB0,0xAC,0x59,0xB9,0x05,0xE5,0xF2,0xF4,0xD3,0x74,0x2F,0xCB,0xEF,0xC2,
        0x7F,0xF6,0x52,0x43,0xB4,0x0B,0xC8,0xE4,0x94,0xD5,0x08,0x71,0xF3,0x6B,0xA2,0x45,
        0x84,0xE5,0xB2,0x24,0x7A,0xB1,0x9A,0xB0,0xA8,0x2C,0xB3,0xB1,0x0B,0x10,0x83,0x8B,
        0x1C,0x84,0xD2,0xCB,0xF6,0x07,0x9B,0xAE,0x72,0xCB,0x17,0x83,0xB1,0x94,0xF1,0x87,
        0x51,0x8E,0xEF,0x4A,0x19,0xCB,0x48,0xCE,0x5C,0xA2,0x9A,0x87,0x58,0x17,0xD9,0x84,
        0x51,0x7D,0x54,0x6E,0x99,0xD6,0x4E,0x7D,0x4A,0x03,0xB1,0xAE,0x99,0x16,0xFF,0x13,
        0x3A,0x2C,0x60,0x7C,0x20,0x39,0x72,0x51,0x3C,0x03,0x6F,0x54,0x6C,0x13,0x56,0x5B,
        0xF2,0x93,0x32,0x34,0x40,0x83,0xED,0x7A,0x3F,0x72,0x00,0x15,0x1A,0x99,0x34,0x45,
        0xA3,0x87,0x4D,0x2C,0xB6,0x5C,0x63,0x18,0x0A,0x03,0x31,0x95,0x67,0xFA,0x10,0x37,
        0xAC,0x56,0xBC,0x05,0xE4,0xCA,0xD3,0xB7,0x3E,0xE5,0x3D,0xAE,0x39,0x5C,0x37,0xA3,
        0xCE,0x29,0xB1,0xE5,0xC5,0x2A,0xA4,0x96,0x30,0x19,0x29,0x3C,0x51,0x58,0x13,0x45,
        0x61,0xC9,0x69,0xC3,0xDC,0x2E,0x61,0xD8,0xB3,0x96,0xED,0xD1,0x1F,0xB4,0xDF,0xAE,
        0xCC,0x8D,0xC6,0x3D,0x49,0x2B,0x71,0x81,0xB2,0x25,0xD5,0xCA,0xA1,0x96,0x65,0xE5,
        0xD2,0xF8,0x4C,0x70,0xF2,0x73,0xC6,0xA0,0xC8,0xD9,0x31,0x2F,0x3C,0xD2,0x77,0x7B,
        0x39,0x7B,0x70,0xC3,0x91,0xD6,0xFB,0x36,0x57,0xE7,0x11,0xB6,0x59,0x96,0x36,0x1D,
        0x30,0x07,0xFF,0x27,0x68,0x6F,0xBB,0x59,0xC7,0x26,0x75,0x70,0xFA,0x41,0x44,0xDF,
        0xAE,0x5A,0x90,0x25,0x26,0xA1,0x53,0xFB,0xFC,0x16,0x18,0x0A,0x61,0x0F,0x47,0x31,
        0xA2,0x13,0xFF,0x34,0xD3,0x50,0x13,0xCA,0xC0,0x17,0xFC,0x6B,0x61,0x8B,0x3B,0x16,
        0xA3,0x32,0x07,0xFE,0x05,0x10,0xF7,0x8E,0xB3,0x03,0x2A,0x51,0x57,0xB0,0xF7,0xB7,
        0xDF,0x43,0xCD,0xE6,0x42,0x0F,0x0B,0x5E,0x47,0xC6,0x65,0x0E,0xA5,0xE8,0x9A,0x70,
        0xDA,0x01,0x67,0x2E,0x07,0x48,0x2B,0x91,0x1C,0x70,0x81,0xD0,0x25,0xC1,0x73,0x0F,
        0x1F,0x45,0x8C,0x1D,0xBD,0x55,0xD3,0x93,0x27,0xA9,0xB7,0x3F,0xAB,0xE8,0xE9,0xCB,
        0x68,0xBA,0x76,0x55,0x48,0xC8,0xAF,0x96,0x18,0x3C,0xC9,0xD2,0x8E,0x3A,0x39,0x85,
        0x53,0x56,0xEF,0x5F,0x5C,0x7C,0xB2,0x85,0x2E,0xD4,0x07,0x5E,0x91,0xEB,0xE6,0x34,
        0x86,0xB5,0x67,0x6B,0x4B,0x1D,0xC7,0x56,0x96,0xF5,0x05,0x81,0x8B,0x01,0x04,0xEC,
        0x6F,0x31,0xEB,0x55,0xF8,0x8A,0x6F,0xEB,0x07,0xF0,0x27,0x74,0xC1,0x50,0x04,0x2C,
        0x56,0x95,0x4B,0xD9,0xD3,0xCE,0x3A,0x35,0x8E,0x98,0xC9,0x66,0x77,0x31,0xF9,0x2C},
        {0},
        /*TST_dataSize*/
        1536*sizeof(DxUint8_t),
        /*TST_Expected_CBC_MAC*/
        {0x81,0xdd,0xde,0x32,0xed,0x46,0xb9,0x5b,0xf7,0xd8,0x1f,0x94,0x91,0xce,0x87,0xa9},      
        CRYS_AES_MAC_mode
    },
    #endif
    #endif
    #if TST_USE_AES_256_KEY
    #if TST_USE_AES_16BYTE_DATA
    { 
        {"Acceptance test - AES/MAC/256Key/16ByteData "},
        /*TST_Key*/     
        {0x92,0x3D,0x31,0x59,0xDB,0x11,0xC2,0x42,0x69,0x32,0x5D,0xA6,0xD5,0x0C,0x43,0xF7,
        0x41,0x46,0xA1,0x59,0x5C,0xB8,0x78,0x59,0xD1,0x2A,0x29,0x7E,0xC5,0xE1,0x8D,0xC6},
        CRYS_AES_Key256BitSize,
        /*TST_IvCounter*/
        {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f}, 
        /*TST_input_data*/
        {0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a},
        {0},
        /*TST_dataSize*/
        16*sizeof(DxUint8_t),
        /*TST_Expected_CBC_MAC*/
        {0x1E,0xBF,0x4F,0x7F,0xE4,0xA5,0x8B,0x5A,0x19,0xF8,0x3B,0x5C,0xF3,0xDF,0x2B,0x5B}, 
        CRYS_AES_MAC_mode
    },
    #endif
    #if TST_USE_AES_32BYTE_DATA
    { 
        {"Acceptance test - AES/MAC/256Key/32ByteData "},
        /*TST_Key*/     
        {0x92,0x3D,0x31,0x59,0xDB,0x11,0xC2,0x42,0x69,0x32,0x5D,0xA6,0xD5,0x0C,0x43,0xF7,
        0x41,0x46,0xA1,0x59,0x5C,0xB8,0x78,0x59,0xD1,0x2A,0x29,0x7E,0xC5,0xE1,0x8D,0xC6},
        CRYS_AES_Key256BitSize,
        /*TST_IvCounter*/
        {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f}, 
        /*TST_input_data*/
        {0x13,0xBB,0x3A,0x45,0x1B,0x14,0x50,0xF8,0x32,0xDF,0x39,0x7E,0xEA,0x18,0xBB,0x19,
        0xD1,0xC6,0xF2,0x53,0x04,0x5C,0xEE,0x32,0x10,0xD0,0x25,0xEB,0xEE,0xC2,0x7E,0x1C},
        {0},
        /*TST_dataSize*/
        32*sizeof(DxUint8_t),
        /*TST_Expected_CBC_MAC*/
        {0x7D,0x86,0xEB,0x89,0xF0,0x9D,0xC7,0x16,0xBF,0x6B,0x46,0x41,0xE2,0x77,0xCE,0x29}, 
        CRYS_AES_MAC_mode
    },
    #endif
    #if TST_USE_AES_64BYTE_DATA
    { 
        {"Acceptance test - AES/MAC/256Key/64ByteData "},
        /*TST_Key*/     
        {0x60,0x3d,0xeb,0x10,0x15,0xca,0x71,0xbe,0x2b,0x73,0xae,0xf0,0x85,0x7d,0x77,0x81,
         0x1f,0x35,0x2c,0x07,0x3b,0x61,0x08,0xd7,0x2d,0x98,0x10,0xa3,0x09,0x14,0xdf,0xf4},
        CRYS_AES_Key256BitSize,
        /*TST_IvCounter*/
        {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f}, 
        /*TST_input_data*/
        {0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a,
         0xae,0x2d,0x8a,0x57,0x1e,0x03,0xac,0x9c,0x9e,0xb7,0x6f,0xac,0x45,0xaf,0x8e,0x51,
         0x30,0xc8,0x1c,0x46,0xa3,0x5c,0xe4,0x11,0xe5,0xfb,0xc1,0x19,0x1a,0x0a,0x52,0xef,
         0xf6,0x9f,0x24,0x45,0xdf,0x4f,0x9b,0x17,0xad,0x2b,0x41,0x7b,0xe6,0x6c,0x37,0x10},
        {0},
        /*TST_dataSize*/
        64*sizeof(DxUint8_t),
        /*TST_Expected_CBC_MAC*/
        {0xb2,0xeb,0x05,0xe2,0xc3,0x9b,0xe9,0xfc,0xda,0x6c,0x19,0x07,0x8c,0x6a,0x9d,0x1b},  
        CRYS_AES_MAC_mode
    },
    #endif
    #if TST_USE_AES_512BYTE_DATA
    { 
        {"Acceptance test - AES/MAC/256Key/512ByteData "},
        /*TST_Key*/     
        {0x60,0x3d,0xeb,0x10,0x15,0xca,0x71,0xbe,0x2b,0x73,0xae,0xf0,0x85,0x7d,0x77,0x81,
         0x1f,0x35,0x2c,0x07,0x3b,0x61,0x08,0xd7,0x2d,0x98,0x10,0xa3,0x09,0x14,0xdf,0xf4},
        CRYS_AES_Key256BitSize,
        /*TST_IvCounter*/
        {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f}, 
        /*TST_input_data*/
        {0x43,0x3F,0x21,0xFB,0xC6,0x84,0x03,0xBB,0x7F,0x37,0x5C,0xB9,0xE8,0x79,0xAF,0x73,
        0x93,0x73,0xE0,0x44,0xD8,0x3B,0xD7,0x88,0xB3,0xDC,0x36,0x34,0x01,0xEC,0x95,0x9C,
        0xE4,0x7E,0x25,0xAF,0x86,0x6D,0xB3,0xFD,0x65,0xBA,0xDE,0x37,0x32,0x03,0xC5,0x75,
        0x01,0xA1,0x2A,0xC9,0x2C,0xC0,0x01,0x07,0x67,0x99,0x47,0xEA,0x4D,0xCF,0xBA,0x92,
        0xA1,0xBF,0xD4,0x69,0x54,0x00,0xED,0x25,0xC0,0xE2,0xDF,0x1E,0x5D,0xA0,0x55,0xAF,
        0x17,0xC1,0x33,0x5F,0xC2,0xCB,0x70,0x23,0x7C,0x1D,0x47,0xEC,0x25,0xC9,0xAF,0x95,
        0xFF,0x4B,0x95,0x73,0x2F,0x5B,0x21,0x01,0xB4,0x04,0x09,0x49,0xE1,0xE3,0xAA,0xC7,
        0x43,0x97,0xD2,0x8C,0x9C,0x5A,0xD0,0xD5,0x4E,0xB1,0xED,0x36,0xB9,0x00,0xFF,0xF6,
        0x32,0x49,0x1E,0x12,0x0B,0xE1,0x80,0xBC,0xA0,0x31,0xAB,0xBD,0xC2,0x27,0x41,0x98,
        0x72,0x7F,0xA9,0x8E,0xF6,0x23,0xF9,0xA5,0x7A,0xC0,0x24,0x7D,0x6D,0xEA,0x47,0xB4,
        0x04,0x12,0x16,0x98,0xC5,0x98,0xBC,0x61,0x16,0x16,0xEC,0x6A,0xAF,0x13,0x13,0x27,
        0x6F,0x54,0xC4,0x39,0x57,0x71,0x00,0x0F,0x50,0x79,0x97,0x4A,0xBD,0x03,0x4E,0xB5,
        0xE9,0xF7,0xB8,0xAF,0x10,0xA9,0xD3,0xDA,0xC3,0x47,0x77,0xDF,0x37,0x8E,0xF5,0x67,
        0xAC,0xFC,0x0E,0x18,0x26,0x0E,0x5D,0x93,0x11,0x07,0x48,0x4C,0x01,0x71,0xA4,0x13,
        0xC8,0x36,0x80,0xB7,0x5A,0x63,0x17,0xC5,0x81,0xE9,0x75,0x0F,0xFA,0x21,0xD8,0xC1,
        0x83,0x2F,0x9D,0xC0,0xF4,0x35,0x8F,0xDB,0x9A,0x25,0x9D,0x09,0x61,0x86,0xD9,0x52,
        0xA3,0x63,0x17,0x00,0x0E,0x3D,0x0C,0x49,0xE5,0x48,0x97,0x3C,0x98,0x4D,0x98,0xF0,
        0x2E,0x86,0xC9,0xD1,0xD3,0xE3,0x1F,0x92,0xA7,0xA5,0x1D,0x34,0xC5,0x0D,0x64,0xFB,
        0x10,0x23,0x6C,0x97,0x0A,0xD7,0xB3,0x45,0x22,0x54,0xDB,0xAB,0x9E,0x52,0x42,0x4C,
        0x8D,0xAC,0xDA,0xDB,0xBD,0x08,0x7F,0xBF,0x43,0x84,0x59,0x68,0x20,0xD7,0x83,0xD8,
        0xE4,0x9C,0x2C,0x75,0xE0,0x00,0xE6,0x57,0xD2,0x83,0xAE,0x7E,0x08,0x73,0xF4,0x55,
        0x62,0xD0,0xA7,0x18,0x32,0x88,0x3D,0x07,0xA3,0xAD,0x53,0x85,0x7E,0x4A,0x25,0x4B,
        0xD0,0x03,0xC6,0x02,0x25,0xCC,0x6C,0x8C,0xC6,0x83,0x08,0x39,0x59,0x00,0xB7,0xD0,
        0x8F,0x04,0x06,0x4F,0x30,0x6A,0xA5,0x5B,0x5E,0x24,0xD2,0x33,0xAD,0x60,0xD9,0x88,
        0x5E,0x63,0xAD,0x05,0xAC,0xF2,0x2F,0x95,0x64,0x1B,0x52,0xAF,0x80,0x03,0xAE,0xA3,
        0xF5,0x83,0xF6,0x7A,0x44,0xD5,0x1A,0x65,0x5D,0x6A,0xA3,0x01,0xFA,0x38,0xDF,0x65,
        0xA9,0x80,0xDB,0xF6,0x52,0xB1,0x23,0x9D,0xD4,0x70,0xEA,0x15,0x18,0xF5,0xDB,0x5A,
        0x76,0x2E,0x3D,0x29,0x6A,0x5E,0x43,0x88,0x48,0x48,0xA7,0x41,0x4E,0x2E,0x9B,0x2C,
        0x3B,0xEC,0x05,0x00,0x28,0xB7,0x50,0x44,0x60,0x59,0xA5,0xD4,0xEA,0x05,0x4D,0x68,
        0x8F,0x48,0x8A,0xCB,0xFA,0xB6,0xFB,0x4B,0x3C,0x52,0xAE,0x0A,0x0A,0xE1,0x4E,0xA6,
        0xD4,0xBE,0xD9,0x2B,0xEF,0xDB,0x32,0xBE,0xDE,0xF9,0xC8,0x10,0xB9,0x6F,0x9E,0x42,
        0xFA,0x3F,0xB2,0x05,0xA3,0xCF,0x31,0x85,0xF0,0xBA,0xC3,0xD5,0x09,0x45,0x39,0x7F},
        {0},
        /*TST_dataSize*/
        512*sizeof(DxUint8_t),
        /*TST_Expected_CBC_MAC*/
        {0x5A,0x53,0xC9,0xDE,0x40,0x3E,0xEB,0x33,0xBB,0xE8,0xD1,0x20,0x0A,0xCE,0x97,0x7F},  
        CRYS_AES_MAC_mode
    },
    #endif
    #if TST_USE_AES_1536BYTE_DATA
    { 
        {"Acceptance test - AES/MAC/256Key/1356ByteData "},
        /*TST_Key*/     
        {0x60,0x3d,0xeb,0x10,0x15,0xca,0x71,0xbe,0x2b,0x73,0xae,0xf0,0x85,0x7d,0x77,0x81,
         0x1f,0x35,0x2c,0x07,0x3b,0x61,0x08,0xd7,0x2d,0x98,0x10,0xa3,0x09,0x14,0xdf,0xf4},
        CRYS_AES_Key256BitSize,
        /*TST_IvCounter*/
        {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f}, 
        /*TST_input_data*/
        {0xDD,0x2C,0x3D,0x7C,0x9C,0xD9,0xBA,0x82,0x98,0x18,0xE1,0xA2,0x13,0xA3,0x7E,0xCB,
        0x4C,0x80,0x75,0x97,0x70,0x41,0x56,0x6C,0x2C,0x52,0x56,0x56,0xC8,0xE7,0x51,0x90,
        0x2D,0xA2,0x2E,0x62,0xF9,0x71,0xDB,0xEB,0xCA,0xCD,0x89,0x8F,0x8C,0x19,0x66,0x63,
        0x15,0xE7,0x91,0xE3,0x47,0x25,0xD7,0x9C,0xD5,0xD1,0x50,0x4A,0x82,0x64,0xBA,0xB0,
        0xC7,0x50,0x75,0x71,0x74,0x1B,0xD2,0xDA,0xA4,0x8A,0xCD,0xA2,0xB8,0xC7,0xE0,0x12,
        0xEB,0xF3,0x40,0xE0,0x56,0x6E,0x49,0x08,0xCA,0x92,0x8D,0x28,0x20,0x91,0x69,0x66,
        0x13,0xD8,0xC8,0x3B,0xA4,0xF5,0xEE,0xF9,0x15,0xB6,0x3E,0xBD,0x57,0x34,0xE4,0x0D,
        0xF1,0x3D,0x5E,0x8F,0x23,0xD9,0x5A,0x58,0x06,0x6D,0xA7,0xE2,0x8D,0xAA,0xBA,0x13,
        0x20,0x67,0x8F,0xDF,0xFE,0xA4,0x6E,0xF5,0x04,0x47,0xCA,0xA0,0x30,0x8C,0xB0,0x95,
        0xAD,0x7F,0x36,0xE3,0x32,0xDA,0x43,0x3A,0x7D,0x6F,0x34,0x36,0x4E,0x0B,0x6C,0x6B,
        0xFC,0x2A,0x9C,0xF0,0xA5,0x04,0x0E,0x4D,0xCE,0x68,0x8A,0xDC,0x0E,0xBA,0x28,0x7A,
        0xBD,0x11,0x34,0x0D,0x73,0xD6,0xE1,0x46,0x24,0x55,0x62,0x8F,0x6F,0x38,0xA7,0xF9,
        0xDA,0x5F,0xA3,0x05,0xF0,0xC0,0xEF,0xA9,0x70,0xE9,0x14,0xC9,0x50,0x66,0x2B,0xC3,
        0x46,0xBA,0x79,0x3C,0xD7,0x5E,0xF8,0x25,0x49,0x55,0xCB,0x50,0xA2,0x7F,0xDD,0x96,
        0xC1,0x90,0x01,0xAF,0x16,0x23,0x8A,0xFC,0x22,0x8B,0x9C,0x89,0xC1,0x17,0xF6,0xBD,
        0x2A,0x9E,0x48,0xB5,0xBE,0x6A,0x22,0x7C,0x66,0x7D,0xBC,0x9A,0xF4,0x9E,0x07,0xF1,
        0x0C,0x7E,0x08,0xBF,0x65,0x7B,0xAC,0x23,0x2F,0x7C,0x1A,0x4B,0xC1,0x6E,0x63,0x32,
        0x5F,0x0E,0x26,0x03,0x37,0x28,0xD7,0x56,0x6E,0x85,0x49,0x98,0x66,0xF0,0x08,0x83,
        0x84,0xAB,0x7D,0x43,0x0E,0x37,0x57,0xAE,0xF2,0x24,0x85,0x42,0x50,0xD6,0xBA,0xF7,
        0x19,0x8A,0x3A,0xE5,0x78,0x03,0xBA,0xE4,0xA6,0xB2,0x50,0xE0,0x32,0x13,0xBD,0x3F,
        0x73,0x97,0xC7,0x16,0xF1,0x20,0x23,0x27,0xB6,0x77,0x11,0x12,0xA2,0x95,0x06,0x98,
        0xCB,0x51,0x7F,0xDC,0xB5,0x23,0x0A,0x80,0xF1,0x99,0x9D,0x5C,0xE7,0x77,0x7C,0xDE,
        0x67,0x46,0xCE,0xB9,0x0E,0xA3,0x06,0xF9,0x66,0x13,0x2E,0x00,0xF2,0xA7,0x41,0x10,
        0xAC,0xB7,0x14,0xE0,0x94,0xE0,0x8A,0x50,0x8C,0x47,0x25,0x58,0x82,0xC6,0x40,0x3F,
        0xFA,0x32,0xAB,0x5C,0xC7,0x4C,0x8A,0x27,0x4A,0x85,0x75,0xA2,0xF4,0x09,0x8D,0x49,
        0x57,0x8D,0xB0,0x30,0x62,0x9B,0x4A,0x86,0xBB,0x7D,0x2C,0xC7,0x7E,0xAE,0x76,0xA0,
        0xD2,0xEF,0x06,0xC0,0xFB,0xE5,0x48,0x5F,0x2D,0xED,0x96,0x0E,0x6A,0xE7,0x5B,0x82,
        0xB9,0xDB,0x01,0xF5,0x16,0x10,0xDC,0x5E,0xE7,0x25,0xA0,0x49,0x20,0xC3,0xA9,0x9C,
        0x0E,0xD5,0xCF,0x05,0x03,0xCD,0x4E,0x71,0x44,0x51,0x03,0x75,0x05,0x3B,0x1C,0xD4,
        0x21,0xA9,0x0D,0xA2,0xAC,0x81,0x89,0xC2,0x13,0xA7,0xD8,0xD6,0x45,0xFF,0x3E,0x69,
        0x44,0xF9,0x00,0x94,0x18,0x56,0x7E,0xEB,0x8C,0x8F,0xB1,0xC4,0x0D,0x66,0x59,0xAC,
        0x09,0xCC,0x27,0x76,0xB5,0x06,0xEF,0x8D,0x4B,0x0C,0xF2,0x5C,0xF5,0x78,0x2C,0x45,
        0x12,0x99,0x31,0x0C,0x3B,0x87,0xBB,0xCA,0x2B,0x22,0x16,0x1D,0xD0,0xC5,0xB5,0xAC,
        0x4D,0x2C,0xCD,0x78,0xD7,0xC8,0xB4,0x3D,0x09,0x73,0x48,0x0B,0x64,0x22,0xF6,0x14,
        0x62,0x6B,0xB2,0x74,0x35,0x4D,0x70,0x81,0x10,0x5D,0x4B,0x93,0xF0,0xD2,0xBC,0x86,
        0x57,0x45,0x0E,0xC8,0xAA,0xB3,0x6E,0x49,0xE4,0xF3,0x02,0xC8,0x3E,0xAF,0x66,0x08,
        0x2B,0x01,0xBA,0x64,0x13,0x41,0x76,0x00,0xBB,0x4B,0x68,0x7A,0x7D,0x21,0x4D,0x37,
        0xB6,0xC1,0xB3,0x1E,0x13,0x2E,0x69,0xAF,0xFD,0x68,0x8F,0x41,0x4B,0xA8,0x42,0x60,
        0xF6,0x42,0x67,0xEE,0x17,0x58,0x73,0x16,0xCF,0x0E,0x0C,0x5F,0x4B,0xF4,0xCC,0xC2,
        0xA5,0xCA,0x12,0x7C,0xFC,0x47,0xF5,0xFD,0x97,0x0B,0x66,0xAA,0xB1,0x34,0xB5,0x13,
        0x08,0x07,0x83,0x3B,0xB9,0x5E,0x20,0x5D,0x4E,0x9D,0x4F,0x05,0x21,0x0A,0x63,0x09,
        0x9C,0xCC,0x9C,0x80,0x96,0xC6,0x64,0xAF,0x4C,0x69,0x57,0x0B,0xF1,0xC9,0x64,0x9A,
        0x58,0xF8,0x56,0x43,0x70,0x90,0x08,0x46,0xAA,0xB4,0x2E,0x5E,0xF7,0xF0,0xDC,0x8C,
        0xA7,0x5D,0x0E,0xE4,0x98,0x34,0x7D,0x42,0xA2,0xD3,0xEE,0x50,0x07,0x14,0x6C,0x85,
        0x38,0xB4,0xAC,0x28,0xB4,0x1F,0x98,0x0B,0xC3,0x55,0xD6,0xE1,0x97,0x06,0xB7,0x5C,
        0x8D,0xCA,0x63,0x94,0xBA,0x7F,0x02,0x23,0x7B,0x13,0xA1,0x9D,0xA2,0xB8,0x3F,0x95,
        0x47,0xA9,0x26,0x43,0x44,0xB3,0xD7,0x88,0xC4,0x02,0x21,0x43,0x5E,0x9B,0xAB,0x9C,
        0x1B,0x92,0xC2,0x3D,0xB1,0xD8,0xCA,0xB8,0xB1,0x88,0xAD,0xA1,0x7E,0xFB,0x69,0x0A,
        0x16,0x40,0x99,0xEE,0xE0,0x74,0x17,0xDA,0xF2,0xDB,0xCF,0xB7,0x5E,0xBF,0xC5,0xDF,
        0x68,0x04,0x81,0x0F,0xF6,0x02,0xE4,0x6F,0xDF,0x6D,0x91,0xBC,0x06,0x36,0x09,0xC9,
        0x99,0x16,0x2D,0x1D,0x01,0xBC,0xBC,0xA6,0x7A,0xE7,0x4A,0xD5,0x08,0x12,0x59,0xF2,
        0xC2,0xCD,0x38,0x79,0x79,0x59,0x13,0x13,0x5C,0x2A,0x0E,0x72,0xE3,0x5B,0xD3,0xBC,
        0xD1,0x05,0x1E,0x48,0x92,0xA7,0xDD,0xAB,0x48,0xDB,0x95,0x0E,0xB8,0x0E,0x66,0xCC,
        0x13,0x9E,0xF9,0x39,0xFE,0x8F,0x50,0x40,0x02,0x19,0xC0,0xD7,0xAD,0x49,0xC3,0x1E,
        0x14,0x8D,0x04,0x03,0xF4,0x11,0x60,0x1A,0xEF,0x8C,0x31,0x9E,0xC4,0x05,0x5B,0x4E,
        0xC3,0x42,0x5E,0x44,0x62,0x9A,0xBE,0x41,0xB5,0xDD,0x45,0x79,0xE7,0x05,0xFD,0xFE,
        0x17,0x76,0xFA,0x2A,0x0A,0x63,0xD8,0x01,0x3E,0xDE,0x49,0x71,0x5E,0xB2,0x7B,0xFD,
        0xBD,0x72,0x14,0x6B,0xEB,0x7F,0xBC,0x7A,0xCF,0xC2,0x4D,0x16,0xCC,0xE6,0x33,0xE9,
        0x8F,0x32,0x86,0x4E,0x0A,0x31,0x44,0x5F,0x69,0x5C,0x05,0x83,0x50,0x4D,0xE3,0x02,
        0x62,0x47,0xBC,0x74,0xF0,0x92,0x13,0x97,0xB9,0x80,0x5A,0x48,0x15,0xC1,0x35,0x58,
        0xAA,0x5F,0xE1,0x2C,0x2B,0x2D,0xF2,0x8B,0x2E,0xB5,0x01,0x8E,0x7A,0x39,0x29,0x82,
        0xDF,0x4B,0xB4,0x84,0x2A,0xBE,0xF8,0xFD,0x1F,0xEF,0x94,0x8A,0xD7,0xFB,0x49,0xA8,
        0x27,0xAD,0xD8,0xF0,0x6B,0xB7,0xD6,0x34,0x54,0x30,0x46,0x3B,0x90,0x85,0x1D,0x80,
        0x57,0xD8,0x68,0xCA,0x0D,0xB0,0x2D,0xEB,0x66,0xE4,0x0C,0x3C,0x98,0x68,0xB4,0x32,
        0x6C,0x59,0x66,0xCD,0x60,0x38,0x17,0x28,0x74,0x7F,0x30,0xF9,0x78,0xBD,0x6C,0x99,
        0xD1,0x14,0x33,0xFF,0x93,0x7E,0x9B,0x76,0x7F,0xEC,0x8A,0x86,0xAA,0x9A,0x9C,0xEB,
        0x7C,0x14,0xCE,0x37,0x1E,0x50,0x1F,0x1E,0xC0,0x40,0x55,0x8D,0x80,0x33,0x73,0xA8,
        0x78,0x73,0x6A,0x83,0x35,0xB5,0x9F,0xED,0xBE,0xF0,0x4D,0x74,0xAE,0x91,0x7E,0xDA,
        0xE3,0x44,0x7D,0x64,0xEF,0x35,0x7B,0x81,0xF5,0x14,0x3E,0x52,0x28,0x0E,0xF5,0x4C,
        0x79,0xE1,0x0D,0x36,0x2F,0x18,0xB6,0xC7,0x74,0xE0,0x79,0x2E,0x02,0xAB,0x70,0x2F,
        0xC2,0x7B,0xA9,0x3C,0xB6,0x0E,0xB9,0x42,0xF7,0xE9,0x8E,0x21,0x76,0x4D,0xC4,0xAF,
        0xFA,0x01,0xFA,0xCC,0x83,0x47,0xAB,0xCA,0x8D,0xB5,0xEF,0x0E,0xBC,0x4D,0x7E,0x49,
        0xA3,0x0E,0x8F,0xAD,0x64,0xB9,0x95,0x6A,0x27,0xCB,0x3F,0x46,0x8A,0x95,0x50,0x27,
        0x1B,0xC9,0x33,0x01,0xB0,0xA3,0xAC,0x7B,0xD0,0xDE,0xAF,0x00,0x1E,0xAA,0x85,0xAA,
        0x6A,0x44,0x7D,0x67,0xBD,0x17,0x4B,0x41,0x6B,0x90,0xA4,0xB7,0x08,0x64,0x40,0xF8,
        0x65,0xC8,0xF2,0xF3,0x19,0x7D,0x99,0xFF,0x62,0x13,0xDD,0x86,0x09,0x95,0x4B,0x7C,
        0x45,0x94,0xDC,0x46,0x17,0xE8,0x69,0x04,0x7D,0xF2,0x95,0x20,0xFF,0xF4,0x73,0x6B,
        0x9E,0xB6,0x9A,0x56,0xB8,0x92,0x91,0xEC,0xAA,0x7D,0x05,0xAA,0x3A,0xC5,0x37,0xD6,
        0x44,0x28,0x72,0x73,0x88,0xFA,0xE0,0x7D,0x5E,0xEE,0x75,0x26,0xE7,0x79,0x00,0x6E,
        0xA0,0x71,0xE7,0x53,0xFA,0xF5,0xC4,0xB2,0x02,0xEF,0x9B,0x9A,0xE3,0xBF,0xCA,0xB8,
        0xBB,0xBF,0xDB,0xD6,0x81,0xFF,0xE3,0xA3,0xD6,0x1D,0xF7,0xC9,0x1D,0x6B,0x04,0x31,
        0x7D,0x97,0x0A,0xC8,0xDD,0xE4,0xDC,0x4F,0x63,0xBF,0x71,0x98,0x5F,0x46,0x9A,0x9F,
        0x24,0xBC,0x6B,0x28,0x9E,0x29,0xEC,0xA0,0x8E,0x44,0x7C,0xDC,0xFE,0xFA,0x95,0x97,
        0xEB,0x69,0x1C,0x4B,0xB5,0x01,0xDB,0xD7,0xE3,0x8B,0x73,0xC2,0x8E,0x4A,0x44,0x8F,
        0x83,0x57,0xA5,0x60,0xFF,0xDC,0x93,0x53,0xAA,0x69,0x3A,0x98,0x67,0xFF,0x51,0x68,
        0x29,0xD9,0xAD,0xF5,0x29,0x4E,0xEA,0x22,0xE1,0x94,0x45,0x12,0xB6,0x29,0x11,0x43,
        0x00,0xEC,0x59,0xA6,0x55,0x35,0x97,0x0E,0xD5,0xC9,0xA1,0x4B,0xC7,0x42,0x6F,0xE3,
        0x3A,0x0B,0x98,0xB4,0x9D,0x4E,0x66,0x35,0x6D,0x83,0x7F,0x6B,0x96,0x81,0x9D,0x80,
        0x57,0xF6,0x98,0x7A,0xA6,0xAB,0x13,0xF4,0x42,0x9E,0x1F,0x60,0xAC,0x9E,0x5A,0x9E,
        0x24,0x61,0xD7,0xAB,0x91,0x5D,0xA6,0xB2,0x86,0x23,0x38,0xD2,0xB5,0x2C,0x78,0x54,
        0x2C,0x20,0xF3,0xD1,0xA9,0xF4,0x3D,0x8F,0xF7,0xA3,0x72,0xFE,0x2E,0x06,0x88,0xCE,
        0x28,0xE0,0x46,0x34,0xAA,0xF2,0xEF,0xFA,0x4F,0xE6,0xF4,0x83,0x72,0x41,0x3F,0x15,
        0x26,0xCB,0x33,0x8C,0xAB,0x89,0xF4,0x2F,0x24,0x47,0xB3,0xED,0xEB,0xA8,0x83,0x80,
        0x9A,0x69,0xA9,0xD4,0xE5,0x43,0xAA,0x3A,0x31,0xF8,0x81,0xC3,0x00,0xBA,0x1C,0xB6,
        0x64,0x5C,0xD8,0x62,0xD2,0xFC,0x23,0x9E,0xEC,0x16,0x10,0x62,0x3E,0x01,0x0F,0xA7,
        0x62,0x73,0xE8,0x08,0x97,0x6A,0x30,0xE2,0x21,0xF9,0x5B,0xB2,0x07,0x31,0x2F,0x6A},
        {0},
        /*TST_dataSize*/
        1536*sizeof(DxUint8_t),
        /*TST_Expected_CBC_MAC*/
        {0x30,0xA4,0xD0,0x86,0xBE,0x3A,0x64,0x22,0x9B,0x8E,0xCD,0xC6,0x04,0x33,0x57,0x04},  
        CRYS_AES_MAC_mode
    },
    #endif
    #endif
};
/***************************/
/************** XCBC MAC Vectors    ********/
/***************************/		   
TST_AES_MAC_TestDataStruct TST_AES_XCBC_CMAC_Acceptance_TestData[] =
{
    /***********/
    /* AES XCBC\CMAC MAC vectors */
    /**********/
    #if TST_USE_AES_16BYTE_DATA
	{ 
        {"Acceptance test - AES/XCBC-MAC/128Key/16ByteData "},
        /*TST_Key*/     
        {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f},
        CRYS_AES_Key128BitSize,
        /*TST_IvCounter*/
        {0x00}, 
        /*TST_input_data*/
        {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f},
        {0},
        /*TST_dataSize*/
        16*sizeof(DxUint8_t),
        /*TST_Expected_XCBC_MAC*/
        {0xd2,0xa2,0x46,0xfa,0x34,0x9b,0x68,0xa7,0x99,0x98,0xa4,0x39,0x4f,0xf7,0xa2,0x63}, 
        CRYS_AES_XCBC_MAC_mode
    },
    #endif
    #if TST_USE_AES_32BYTE_DATA
	{ 
        {"Acceptance test - AES/XCBC-MAC/128Key/32ByteData "},
        /*TST_Key*/     
        {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f},
        CRYS_AES_Key128BitSize,
        /*TST_IvCounter*/
        {0x00}, 
        /*TST_input_data*/
        {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,
		0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f},
        {0},
        /*TST_dataSize*/
        32*sizeof(DxUint8_t),
        /*TST_Expected_XCBC_MAC*/
        {0xf5,0x4f,0x0e,0xc8,0xd2,0xb9,0xf3,0xd3,0x68,0x07,0x73,0x4b,0xd5,0x28,0x3f,0xd4}, 
        CRYS_AES_XCBC_MAC_mode
    },
    #endif
    #if TST_USE_AES_512BYTE_DATA
	{ 
        {"Acceptance test - AES/XCBC-MAC/128Key/512ByteData "},
        /*TST_Key*/     
        {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f},
        CRYS_AES_Key128BitSize,
        /*TST_IvCounter*/
        {0x00}, 
        /*TST_input_data*/
        {0xb6,0xed,0x21,0xb9,0x9c,0xa6,0xf4,0xf9,0xf1,0x53,0xe7,0xb1,0xbe,0xaf,0xed,0x1d,
         0xf3,0xee,0xd1,0xbd,0xb5,0xd2,0xa0,0x3c,0x06,0x4b,0x5a,0x7e,0x3d,0xb1,0x81,0xf8,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0x62,0xf8,0xa7,0x23,0x7b,0xbd,0xf8,0x4d,0x4e,0x1d,0xff,0xe8,0xb5,0x2a,0x02,0xc1,
         0x52,0xdb,0x14,0x2f,0xeb,0x21,0xf9,0x58,0xb8,0x80,0x28,0x68,0xe4,0x99,0x06,0x18,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0xb6,0xed,0x21,0xb9,0x9c,0xa6,0xf4,0xf9,0xf1,0x53,0xe7,0xb1,0xbe,0xaf,0xed,0x1d,
         0xf3,0xee,0xd1,0xbd,0xb5,0xd2,0xa0,0x3c,0x06,0x4b,0x5a,0x7e,0x3d,0xb1,0x81,0xf8,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0x62,0xf8,0xa7,0x23,0x7b,0xbd,0xf8,0x4d,0x4e,0x1d,0xff,0xe8,0xb5,0x2a,0x02,0xc1,
         0x52,0xdb,0x14,0x2f,0xeb,0x21,0xf9,0x58,0xb8,0x80,0x28,0x68,0xe4,0x99,0x06,0x18,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0xb6,0xed,0x21,0xb9,0x9c,0xa6,0xf4,0xf9,0xf1,0x53,0xe7,0xb1,0xbe,0xaf,0xed,0x1d,
         0xf3,0xee,0xd1,0xbd,0xb5,0xd2,0xa0,0x3c,0x06,0x4b,0x5a,0x7e,0x3d,0xb1,0x81,0xf8,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0x62,0xf8,0xa7,0x23,0x7b,0xbd,0xf8,0x4d,0x4e,0x1d,0xff,0xe8,0xb5,0x2a,0x02,0xc1,
         0x52,0xdb,0x14,0x2f,0xeb,0x21,0xf9,0x58,0xb8,0x80,0x28,0x68,0xe4,0x99,0x06,0x18,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0xb6,0xed,0x21,0xb9,0x9c,0xa6,0xf4,0xf9,0xf1,0x53,0xe7,0xb1,0xbe,0xaf,0xed,0x1d,
         0xf3,0xee,0xd1,0xbd,0xb5,0xd2,0xa0,0x3c,0x06,0x4b,0x5a,0x7e,0x3d,0xb1,0x81,0xf8,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0x62,0xf8,0xa7,0x23,0x7b,0xbd,0xf8,0x4d,0x4e,0x1d,0xff,0xe8,0xb5,0x2a,0x02,0xc1,
         0x52,0xdb,0x14,0x2f,0xeb,0x21,0xf9,0x58,0xb8,0x80,0x28,0x68,0xe4,0x99,0x06,0x18,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9},
        {0},
        /*TST_dataSize*/
        512*sizeof(DxUint8_t),
        /*TST_Expected_XCBC_MAC*/
        {0x76 ,0x1c ,0x62 ,0xa1 ,0xd6 ,0xfb ,0x5c ,0xc9 ,0x22 ,0x63 ,0x90 ,0x28 ,0x28 ,0xbe ,0x8d ,0xf8},
        CRYS_AES_XCBC_MAC_mode
	},
    #endif
    #if TST_USE_AES_1536BYTE_DATA
	{
		{"Acceptance test - AES/XCBC-MAC/128Key/1536ByteData "},
        /*TST_Key*/     
		{ 0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f},
		
        CRYS_AES_Key128BitSize,
        /*TST_IvCounter*/
        {0x00}, 
        /*TST_input_data*/
         {0x12,0xa8,0xb2,0x61,0x5d,0x01,0x3b,0x47,0x65,0xf6,0x72,0xa3,0x97,0xd5,0xbc,0x50,
         0x2c,0x7e,0xc9,0x50,0xf2,0x17,0x77,0x1b,0x50,0x01,0xf4,0x37,0x84,0x0a,0x23,0x09,
         0x30,0xe4,0x42,0xeb,0x15,0xd6,0xc9,0x7f,0x1e,0xb1,0x95,0x42,0xa0,0x06,0x45,0x64,
         0xe0,0x96,0xe5,0xd7,0xd6,0x0a,0xca,0xa6,0x30,0xe4,0xbc,0x88,0x9a,0xb6,0x5b,0xb5,
         0x3d,0x91,0xbb,0xf8,0x85,0xc1,0x52,0x05,0x28,0xb7,0x14,0x0e,0x64,0x47,0xdc,0x91,
         0x88,0x14,0x0e,0x74,0xb5,0x48,0x7a,0x53,0xe6,0x88,0x84,0x19,0x2e,0x27,0x82,0xcd,
         0x41,0x99,0x66,0xaf,0x36,0x2b,0x9d,0x84,0x8b,0xf2,0x37,0x2e,0x6a,0x01,0x47,0x7f,
         0x2a,0xdf,0x8d,0x4f,0x19,0x39,0x52,0xcc,0x79,0xd3,0x94,0x12,0xc8,0xc4,0x63,0xfc,
         0x45,0xe3,0x8b,0x39,0xaf,0x7d,0x73,0xa2,0x50,0x49,0x45,0xca,0x3a,0x9d,0x4f,0xd7,
         0xd1,0xe1,0xaa,0x91,0x89,0x45,0x19,0xb9,0xf1,0xaf,0x33,0x9c,0xf1,0xf7,0xc5,0xe8,
         0x4f,0x57,0x72,0xbd,0x78,0x1d,0x9c,0x07,0x7e,0xa3,0x88,0x0c,0x5d,0x81,0xbc,0x41,
         0x82,0x01,0xac,0x62,0x8e,0xd4,0x96,0xc1,0x57,0x03,0xab,0xdf,0x2f,0x28,0x6f,0x39,
         0x6a,0xdd,0x62,0x64,0x1a,0x75,0xe0,0x5c,0x1d,0xea,0x46,0x1a,0x5a,0x17,0x56,0x64,
         0x47,0x27,0xdd,0xe9,0xaf,0x4e,0x92,0x8d,0xb2,0xb7,0x42,0x02,0x0d,0xbd,0x2a,0x98,
         0x9b,0x5d,0xa5,0x56,0x1c,0xeb,0x07,0x49,0x36,0x05,0xc8,0x1c,0xb9,0xc6,0xe5,0xe9,
         0x27,0x3b,0x83,0x4f,0x74,0x1b,0xd5,0xc5,0x0a,0xb2,0x41,0x2d,0x10,0x1f,0xbe,0xad,
         0xec,0xbf,0x81,0xba,0x06,0xe9,0xd8,0x75,0xcf,0xdc,0x56,0x3b,0x03,0xf5,0x30,0x77,
         0x2b,0x26,0xe7,0xbb,0x65,0xa3,0x27,0x10,0x67,0xde,0xf0,0x8a,0xc2,0xb6,0xf3,0x1f,
         0x64,0xeb,0x3f,0xb8,0x61,0xd6,0x1c,0x89,0xf3,0x57,0x37,0x9e,0xbf,0x0e,0x00,0xb7,
         0x59,0xce,0x51,0x56,0x0b,0x4e,0x50,0x16,0xd2,0x22,0x96,0x3e,0xaa,0xea,0x91,0x96,
         0x0b,0xca,0x26,0x7a,0xb4,0x1a,0x9b,0x2c,0xa7,0x5e,0xb5,0x6f,0x75,0x78,0x1d,0x51,
         0xbb,0x1c,0x08,0x48,0xed,0x85,0x17,0x80,0x52,0x66,0x7c,0x74,0x50,0x24,0x5f,0xbc,
         0xea,0x42,0x80,0x25,0x87,0x1d,0x1d,0x07,0xf5,0xd9,0x16,0xd3,0xad,0x9b,0x4f,0xec,
         0x59,0xf8,0x56,0xb8,0x93,0xae,0x46,0xf6,0xf0,0x92,0xeb,0x52,0x3d,0xca,0x26,0x36,
         0x08,0x3c,0x93,0xe4,0x63,0x46,0x6a,0xc2,0xe4,0xb0,0xa3,0xf4,0xf0,0xdf,0x5e,0x30,
         0x39,0x4b,0x81,0xce,0x86,0x33,0xa3,0x1f,0xb3,0x8f,0x29,0x00,0xf8,0x46,0xae,0xaf,
         0x6e,0xa1,0xa9,0xdd,0xce,0xff,0x49,0x04,0x7c,0xcb,0xa4,0xfa,0xc5,0xac,0x11,0xc7,
         0x65,0xfb,0xd2,0xb4,0x4d,0x7a,0xf7,0xa4,0xa3,0x43,0x7e,0xa7,0x09,0xfe,0xbf,0xcd,
         0x22,0x57,0x08,0x38,0x52,0xb0,0x84,0x75,0xc6,0x12,0x61,0x0d,0xb5,0x6a,0x31,0x56,
         0xe5,0xf2,0x91,0x8f,0x70,0xed,0x09,0x2c,0xc8,0x97,0x34,0x6f,0xf9,0x5c,0x21,0x38,
         0x2e,0x48,0xf8,0x1e,0x77,0xbf,0xe1,0xbe,0xc9,0x6e,0x21,0x53,0x47,0x81,0x86,0x88,
         0xbf,0x16,0x06,0x8a,0x78,0xf2,0xa3,0x60,0x2b,0x73,0x92,0x7f,0x4f,0xc6,0x9b,0x99,
         0x99,0x5a,0xc3,0xb7,0xc4,0x95,0x29,0x87,0x8e,0xc5,0x2e,0xf7,0x03,0x59,0xd8,0x02,
         0xfd,0x51,0x79,0xca,0xec,0xf3,0x8b,0xe8,0xd3,0xc0,0xdf,0x00,0x93,0xa6,0xf7,0x98,
         0x6c,0x77,0xb0,0x2a,0xc1,0x9a,0x23,0x77,0x1b,0x01,0xce,0x1f,0x71,0x5a,0xef,0x6f,
         0xa7,0x8a,0x31,0x7a,0x54,0x57,0x8a,0x6b,0xc8,0x64,0x64,0x19,0x4e,0x63,0xfb,0xdc,
         0xae,0x86,0x06,0xa0,0xf6,0x36,0x99,0x37,0x7a,0x08,0x4a,0xf4,0x1a,0xed,0x93,0x75,
         0xc3,0xa9,0x77,0xc0,0x39,0x86,0x68,0x92,0x13,0x49,0x69,0xf3,0x07,0x65,0x70,0x0e,
         0x67,0x6f,0x0e,0x40,0xec,0xd2,0x51,0x6f,0xb3,0xc4,0xea,0x9d,0x85,0x78,0x8b,0xbc,
         0x5b,0x95,0x93,0xc4,0x21,0xe8,0xed,0x04,0xbb,0x55,0x35,0xb5,0x46,0x14,0x1d,0xd5,
         0xa0,0x1a,0x10,0x33,0x2a,0xd4,0x15,0xc6,0xcc,0x1b,0xf5,0x42,0x3a,0x65,0xa0,0xed,
         0x76,0x38,0xcd,0xaf,0x97,0xe5,0xe1,0x69,0xc8,0x72,0x12,0x88,0x93,0xd8,0xcc,0xda,
         0x60,0x6f,0x53,0xa0,0x38,0xa6,0xab,0xe4,0xcf,0xf7,0xb5,0x0d,0xc2,0x1a,0x9a,0xb0,
         0x1d,0x79,0x6c,0xa9,0x20,0xe5,0x0b,0x6b,0x43,0x87,0x46,0x94,0x77,0x19,0x43,0xc5,
         0xaf,0x56,0x21,0xb0,0x9f,0xae,0xdb,0x72,0xc3,0x3f,0x70,0x24,0xa4,0x01,0x41,0xac,
         0x57,0x40,0xba,0xd9,0x46,0x50,0x34,0xb0,0x33,0x7c,0x1a,0x00,0x79,0x3f,0x4b,0x3d,
         0x95,0xb7,0xc0,0x8a,0xe6,0x56,0x6f,0x18,0xb1,0xdb,0x6f,0xaf,0x68,0x80,0x5c,0x8a,
         0x2c,0x75,0xfd,0x68,0x90,0x8e,0x24,0xe0,0xa0,0x39,0xd6,0xf5,0x22,0xb2,0xac,0xea,
         0x1b,0x7a,0x79,0x58,0x95,0x05,0x2d,0x7d,0xa0,0xb2,0xfa,0xd7,0x97,0x01,0xb5,0xf1,
         0xa4,0x01,0x7e,0x7e,0x86,0x07,0xa3,0xa4,0x92,0xa5,0xc2,0x9a,0xf8,0xda,0x2e,0x75,
         0x48,0x87,0x94,0x3f,0x35,0x22,0xdf,0x4a,0x98,0xae,0x58,0xc3,0xb8,0xeb,0x12,0x8a,
         0xc8,0xca,0x85,0x41,0xb1,0x23,0x79,0xa4,0x12,0xaa,0x26,0x18,0x85,0x20,0x99,0x86,
         0x25,0xc6,0x59,0x69,0x4d,0x17,0x4b,0x26,0xa2,0xb6,0xd3,0x9d,0x53,0xa6,0x3c,0xfd,
         0x9f,0xb9,0x5a,0xdc,0x98,0x4b,0x6d,0x87,0x27,0x2f,0x49,0x96,0x51,0xea,0xb4,0xc4,
         0xb8,0x1f,0x10,0xfe,0x65,0x4b,0x3a,0xba,0xc4,0xb3,0xb1,0x8a,0xf0,0x9a,0xfb,0xf1,
         0x31,0xb6,0x44,0x75,0xc4,0xe5,0x49,0xf5,0xda,0x1d,0x74,0x3d,0xe2,0xa1,0x48,0xd8,
         0x0b,0x7b,0x00,0x25,0x05,0x26,0x73,0xae,0x08,0x8b,0x3b,0xb4,0x18,0x2f,0x16,0x0f,
         0x87,0xaa,0x8c,0x35,0xbb,0x5b,0xd3,0x98,0x32,0x5a,0xef,0x35,0xc2,0xae,0x1d,0x69,
         0x26,0xc0,0x72,0x07,0xb6,0x10,0xc0,0xa9,0x76,0x27,0xb9,0x43,0x52,0xcd,0x57,0xfe,
         0xa8,0x7b,0x7b,0x43,0x07,0x13,0xd4,0x15,0x37,0xcf,0x02,0xa5,0x79,0x77,0xfb,0x20,
         0x0f,0xd8,0xae,0xcc,0xff,0x71,0xe7,0x53,0x15,0x6f,0x73,0x5f,0x27,0xdc,0x84,0x66,
         0x9c,0x13,0x57,0xc8,0x2f,0x77,0x13,0x17,0xf1,0x64,0xf5,0xb5,0x8d,0x66,0xaa,0xa5,
         0xd0,0xa9,0xfc,0x9b,0x69,0xb1,0xb1,0x55,0xed,0x4b,0xb0,0x2e,0x1e,0xc4,0x66,0xf1,
         0x6c,0x58,0x68,0xeb,0xbc,0xed,0x5a,0x44,0x69,0x02,0x0f,0x8f,0x88,0xe2,0xf1,0x9f,
         0x71,0x1d,0xa4,0x9c,0x7b,0x38,0xe6,0x57,0x06,0xa4,0xba,0xdb,0xbf,0xed,0xc5,0x45,
         0x1f,0x34,0xf8,0xd5,0x35,0xdf,0x6f,0x44,0xa6,0x8f,0x99,0x58,0xf2,0x52,0x9a,0xb7,
         0xf8,0x1b,0xed,0xf9,0xbd,0x6f,0x4e,0x00,0x69,0x60,0xd7,0x8c,0x92,0xbf,0x69,0x0a,
         0xbd,0x8e,0x4d,0xad,0x22,0xb4,0x1b,0xc0,0xb0,0xf4,0xdb,0x3b,0x51,0x20,0x6b,0x94,
         0x6f,0x8a,0x21,0xd7,0xb7,0xbc,0xb0,0xf9,0x1d,0x69,0x50,0x6a,0x20,0xa3,0x19,0xe9,
         0x4f,0x4d,0xb0,0x9c,0x0c,0xd4,0x26,0x60,0x90,0x1a,0x1d,0x5e,0x2f,0xb3,0x2d,0xdf,
         0xdd,0x54,0x86,0x61,0xf2,0x88,0xd6,0xe9,0x2a,0xa5,0x6d,0x9c,0xf0,0xff,0x9f,0x89,
         0xdc,0x5b,0x69,0xca,0x7a,0xa7,0x58,0xcb,0x4d,0xe8,0xa7,0xe9,0x13,0x73,0xa7,0x3f,
         0x4b,0x60,0x64,0xbc,0xf5,0x3c,0x86,0x79,0x99,0xfe,0x75,0x4a,0x8a,0x3c,0xc1,0x94,
         0x6c,0x9f,0xc0,0x5e,0xf4,0x95,0x79,0xaa,0xef,0x45,0xc0,0x05,0x86,0xc8,0xa3,0x5d,
         0xc0,0x96,0x05,0x13,0x48,0x3e,0x89,0x51,0x71,0x5b,0xb2,0x9e,0x77,0xc3,0x48,0xaf,
         0x08,0x01,0xfd,0x80,0x02,0x06,0x50,0xa4,0x7f,0x1b,0xb2,0xda,0x0f,0x1a,0xe7,0xe0,
         0x44,0xde,0xb0,0x8c,0x74,0xf8,0xa7,0x18,0xba,0xa3,0x6a,0xbe,0x3e,0xfb,0xfb,0x84,
         0xb6,0x69,0x67,0x5a,0x2d,0x62,0xa6,0x62,0x03,0x51,0xc3,0x8f,0x36,0xd1,0x3d,0x71,
         0xdf,0x20,0xac,0x4f,0x00,0xd0,0xa7,0x77,0x7c,0xc0,0xe6,0xd2,0x67,0x4b,0xa4,0xbb,
         0x80,0xbf,0x47,0x11,0xfc,0x11,0x43,0x8b,0x86,0xcf,0x3c,0x4c,0x83,0x55,0x6b,0xb8,
         0x9a,0x44,0x42,0x85,0x74,0x30,0x53,0x15,0xc0,0x99,0x6e,0x03,0x7b,0x1d,0x09,0xfc,
         0x6e,0xeb,0xe5,0xd0,0xf8,0x7b,0xef,0xc8,0x0d,0x7d,0x65,0x3b,0x7f,0x0f,0x39,0x5c,
         0x7c,0x32,0xba,0x56,0x59,0x7f,0x71,0x9b,0x8d,0x16,0x49,0x78,0x01,0xd8,0xf4,0xee,
         0x87,0xd6,0x89,0xbd,0xa7,0x08,0x72,0xc1,0xa2,0x43,0x85,0x81,0xb1,0x65,0x71,0x06,
         0x8e,0xd3,0x5c,0xe9,0x35,0x25,0xca,0xb0,0xec,0x1f,0xc1,0x5b,0x81,0xe3,0x2b,0x39,
         0xd3,0x66,0x7b,0x00,0x93,0x21,0x93,0x1d,0x4c,0x09,0xe5,0x49,0xa1,0xc0,0xd9,0x5d,
         0xd7,0x0d,0x6f,0x67,0x93,0x8a,0x26,0xfd,0xe4,0x9c,0x1c,0xd1,0x83,0xa8,0x76,0x86,
         0x5a,0x84,0x02,0xc2,0x44,0x2c,0x1b,0x85,0x14,0xb7,0xce,0xb9,0xd8,0x89,0x3b,0x0a,
         0x5f,0xc9,0x3d,0xf7,0xf8,0x16,0x4d,0x29,0x7d,0x75,0xa3,0x04,0x90,0x8e,0x9f,0x7d,
         0x25,0x19,0x68,0x2b,0x41,0x93,0xd3,0xa0,0x00,0x35,0x86,0xf9,0xdd,0x26,0x5d,0xb4,
         0x2e,0xf0,0x0c,0xc2,0xee,0x31,0x06,0xdd,0xbf,0x93,0x9e,0x1c,0x2f,0xfd,0x6c,0xc5,
         0x3b,0x0b,0xf3,0x62,0x12,0xbc,0x80,0x17,0x1b,0x6b,0x55,0x32,0x38,0x01,0x07,0x04,
         0x4d,0x68,0x25,0xf0,0xfc,0x43,0x1a,0xc1,0xb3,0xdc,0x55,0x40,0xe9,0x5d,0xa7,0x07,
         0xa4,0x44,0xec,0x90,0x3f,0x11,0xed,0x91,0x6a,0x41,0x85,0x8c,0x72,0x80,0x03,0xa1,
         0xc3,0x1b,0xd0,0xa8,0xab,0xb4,0x52,0x7c,0x60,0x39,0x0f,0x99,0x45,0x17,0x16,0xea,
         0x69,0xaa,0x9b,0xdc,0x50,0xf8,0xe1,0xb7,0xf7,0xa0,0x5d,0x2e,0x12,0x0d,0x18,0x35},
        {0},
        /*TST_dataSize*/
        1536*sizeof(DxUint8_t),
        /*TST_Expected_XCBC_MAC*/
		{0x92,0x56,0x11,0x6e,0xa6,0xe3,0xa8,0xff,0x80,0xcf,0xb6,0x5f,0xaf,0x29,0x93,0x30},
        CRYS_AES_XCBC_MAC_mode
    },
    #endif
    #if TST_USE_AES_16BYTE_DATA
	{ 
        {"Acceptance test - AES/CMAC/128Key/16ByteData "},
        /*TST_Key*/     
        {0x2b,0x7e,0x15,0x16,0x28,0xae,0xd2,0xa6,0xab,0xf7,0x15,0x88,0x09,0xcf,0x4f,0x3c},
        CRYS_AES_Key128BitSize,
        /*TST_IvCounter*/
        {0x00}, 
        /*TST_input_data*/
        { 0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a},
        {0},
        /*TST_dataSize*/
        16*sizeof(DxUint8_t),
        /*TST_Expected_CMAC*/
        {0x07,0x0a,0x16,0xb4,0x6b,0x4d,0x41,0x44,0xf7,0x9b,0xdd,0x9d,0xd0,0x4a,0x28,0x7c}, 
        CRYS_AES_CMAC_mode
    },
    #endif
    #if TST_USE_AES_64BYTE_DATA
	{ 
        {"Acceptance test - AES/CMAC/128Key/32ByteData "},
        /*TST_Key*/     
        {0x2b,0x7e,0x15,0x16,0x28,0xae,0xd2,0xa6,0xab,0xf7,0x15,0x88,0x09,0xcf,0x4f,0x3c},
        CRYS_AES_Key128BitSize,
        /*TST_IvCounter*/
        {0x00}, 
        /*TST_input_data*/
        { 0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a,
		  0xae,0x2d,0x8a,0x57,0x1e,0x03,0xac,0x9c,0x9e,0xb7,0x6f,0xac,0x45,0xaf,0x8e,0x51},
        {0},
        /*TST_dataSize*/
        32*sizeof(DxUint8_t),
        /*TST_Expected_CMAC*/
        {0xCE,0x0C,0xBF,0x17,0x38,0xF4,0xDF,0x64,0x28,0xB1,0xD9,0x3B,0xF1,0x20,0x81,0xC9}, 
        CRYS_AES_CMAC_mode
    },
    #endif
    #if TST_USE_AES_512BYTE_DATA
	{ 
        {"Acceptance test - AES/CMAC/128Key/512ByteData "},
        /*TST_Key*/     
        {0x2b,0x7e,0x15,0x16,0x28,0xae,0xd2,0xa6,0xab,0xf7,0x15,0x88,0x09,0xcf,0x4f,0x3c},
        CRYS_AES_Key128BitSize,
        /*TST_IvCounter*/
        {0x00}, 
        /*TST_input_data*/
        { 0xb6,0xed,0x21,0xb9,0x9c,0xa6,0xf4,0xf9,0xf1,0x53,0xe7,0xb1,0xbe,0xaf,0xed,0x1d,
         0xf3,0xee,0xd1,0xbd,0xb5,0xd2,0xa0,0x3c,0x06,0x4b,0x5a,0x7e,0x3d,0xb1,0x81,0xf8,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0x62,0xf8,0xa7,0x23,0x7b,0xbd,0xf8,0x4d,0x4e,0x1d,0xff,0xe8,0xb5,0x2a,0x02,0xc1,
         0x52,0xdb,0x14,0x2f,0xeb,0x21,0xf9,0x58,0xb8,0x80,0x28,0x68,0xe4,0x99,0x06,0x18,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0xb6,0xed,0x21,0xb9,0x9c,0xa6,0xf4,0xf9,0xf1,0x53,0xe7,0xb1,0xbe,0xaf,0xed,0x1d,
         0xf3,0xee,0xd1,0xbd,0xb5,0xd2,0xa0,0x3c,0x06,0x4b,0x5a,0x7e,0x3d,0xb1,0x81,0xf8,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0x62,0xf8,0xa7,0x23,0x7b,0xbd,0xf8,0x4d,0x4e,0x1d,0xff,0xe8,0xb5,0x2a,0x02,0xc1,
         0x52,0xdb,0x14,0x2f,0xeb,0x21,0xf9,0x58,0xb8,0x80,0x28,0x68,0xe4,0x99,0x06,0x18,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0xb6,0xed,0x21,0xb9,0x9c,0xa6,0xf4,0xf9,0xf1,0x53,0xe7,0xb1,0xbe,0xaf,0xed,0x1d,
         0xf3,0xee,0xd1,0xbd,0xb5,0xd2,0xa0,0x3c,0x06,0x4b,0x5a,0x7e,0x3d,0xb1,0x81,0xf8,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0x62,0xf8,0xa7,0x23,0x7b,0xbd,0xf8,0x4d,0x4e,0x1d,0xff,0xe8,0xb5,0x2a,0x02,0xc1,
         0x52,0xdb,0x14,0x2f,0xeb,0x21,0xf9,0x58,0xb8,0x80,0x28,0x68,0xe4,0x99,0x06,0x18,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0xb6,0xed,0x21,0xb9,0x9c,0xa6,0xf4,0xf9,0xf1,0x53,0xe7,0xb1,0xbe,0xaf,0xed,0x1d,
         0xf3,0xee,0xd1,0xbd,0xb5,0xd2,0xa0,0x3c,0x06,0x4b,0x5a,0x7e,0x3d,0xb1,0x81,0xf8,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0x62,0xf8,0xa7,0x23,0x7b,0xbd,0xf8,0x4d,0x4e,0x1d,0xff,0xe8,0xb5,0x2a,0x02,0xc1,
         0x52,0xdb,0x14,0x2f,0xeb,0x21,0xf9,0x58,0xb8,0x80,0x28,0x68,0xe4,0x99,0x06,0x18,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9},
        {0},
        /*TST_dataSize*/
        512*sizeof(DxUint8_t),
        /*TST_Expected_CBC_MAC*/
		{0x09 ,0x5c ,0xf8 ,0xac ,0x37 ,0x82 ,0x75 ,0x71 ,0xc1 ,0x30 ,0xf0 ,0x2e ,0x37 ,0x90 ,0x3a ,0x89},
        CRYS_AES_CMAC_mode
    },
    #endif
    #if TST_USE_AES_1536BYTE_DATA
    { 
        {"Acceptance test - AES/CMAC/128Key/1536ByteData "},
        /*TST_Key*/     
        {0x2b,0x7e,0x15,0x16,0x28,0xae,0xd2,0xa6,0xab,0xf7,0x15,0x88,0x09,0xcf,0x4f,0x3c},
        CRYS_AES_Key128BitSize,
        /*TST_IvCounter*/
        {0x00}, 
        /*TST_input_data*/
         {0x12,0xa8,0xb2,0x61,0x5d,0x01,0x3b,0x47,0x65,0xf6,0x72,0xa3,0x97,0xd5,0xbc,0x50,
         0x2c,0x7e,0xc9,0x50,0xf2,0x17,0x77,0x1b,0x50,0x01,0xf4,0x37,0x84,0x0a,0x23,0x09,
         0x30,0xe4,0x42,0xeb,0x15,0xd6,0xc9,0x7f,0x1e,0xb1,0x95,0x42,0xa0,0x06,0x45,0x64,
         0xe0,0x96,0xe5,0xd7,0xd6,0x0a,0xca,0xa6,0x30,0xe4,0xbc,0x88,0x9a,0xb6,0x5b,0xb5,
         0x3d,0x91,0xbb,0xf8,0x85,0xc1,0x52,0x05,0x28,0xb7,0x14,0x0e,0x64,0x47,0xdc,0x91,
         0x88,0x14,0x0e,0x74,0xb5,0x48,0x7a,0x53,0xe6,0x88,0x84,0x19,0x2e,0x27,0x82,0xcd,
         0x41,0x99,0x66,0xaf,0x36,0x2b,0x9d,0x84,0x8b,0xf2,0x37,0x2e,0x6a,0x01,0x47,0x7f,
         0x2a,0xdf,0x8d,0x4f,0x19,0x39,0x52,0xcc,0x79,0xd3,0x94,0x12,0xc8,0xc4,0x63,0xfc,
         0x45,0xe3,0x8b,0x39,0xaf,0x7d,0x73,0xa2,0x50,0x49,0x45,0xca,0x3a,0x9d,0x4f,0xd7,
         0xd1,0xe1,0xaa,0x91,0x89,0x45,0x19,0xb9,0xf1,0xaf,0x33,0x9c,0xf1,0xf7,0xc5,0xe8,
         0x4f,0x57,0x72,0xbd,0x78,0x1d,0x9c,0x07,0x7e,0xa3,0x88,0x0c,0x5d,0x81,0xbc,0x41,
         0x82,0x01,0xac,0x62,0x8e,0xd4,0x96,0xc1,0x57,0x03,0xab,0xdf,0x2f,0x28,0x6f,0x39,
         0x6a,0xdd,0x62,0x64,0x1a,0x75,0xe0,0x5c,0x1d,0xea,0x46,0x1a,0x5a,0x17,0x56,0x64,
         0x47,0x27,0xdd,0xe9,0xaf,0x4e,0x92,0x8d,0xb2,0xb7,0x42,0x02,0x0d,0xbd,0x2a,0x98,
         0x9b,0x5d,0xa5,0x56,0x1c,0xeb,0x07,0x49,0x36,0x05,0xc8,0x1c,0xb9,0xc6,0xe5,0xe9,
         0x27,0x3b,0x83,0x4f,0x74,0x1b,0xd5,0xc5,0x0a,0xb2,0x41,0x2d,0x10,0x1f,0xbe,0xad,
         0xec,0xbf,0x81,0xba,0x06,0xe9,0xd8,0x75,0xcf,0xdc,0x56,0x3b,0x03,0xf5,0x30,0x77,
         0x2b,0x26,0xe7,0xbb,0x65,0xa3,0x27,0x10,0x67,0xde,0xf0,0x8a,0xc2,0xb6,0xf3,0x1f,
         0x64,0xeb,0x3f,0xb8,0x61,0xd6,0x1c,0x89,0xf3,0x57,0x37,0x9e,0xbf,0x0e,0x00,0xb7,
         0x59,0xce,0x51,0x56,0x0b,0x4e,0x50,0x16,0xd2,0x22,0x96,0x3e,0xaa,0xea,0x91,0x96,
         0x0b,0xca,0x26,0x7a,0xb4,0x1a,0x9b,0x2c,0xa7,0x5e,0xb5,0x6f,0x75,0x78,0x1d,0x51,
         0xbb,0x1c,0x08,0x48,0xed,0x85,0x17,0x80,0x52,0x66,0x7c,0x74,0x50,0x24,0x5f,0xbc,
         0xea,0x42,0x80,0x25,0x87,0x1d,0x1d,0x07,0xf5,0xd9,0x16,0xd3,0xad,0x9b,0x4f,0xec,
         0x59,0xf8,0x56,0xb8,0x93,0xae,0x46,0xf6,0xf0,0x92,0xeb,0x52,0x3d,0xca,0x26,0x36,
         0x08,0x3c,0x93,0xe4,0x63,0x46,0x6a,0xc2,0xe4,0xb0,0xa3,0xf4,0xf0,0xdf,0x5e,0x30,
         0x39,0x4b,0x81,0xce,0x86,0x33,0xa3,0x1f,0xb3,0x8f,0x29,0x00,0xf8,0x46,0xae,0xaf,
         0x6e,0xa1,0xa9,0xdd,0xce,0xff,0x49,0x04,0x7c,0xcb,0xa4,0xfa,0xc5,0xac,0x11,0xc7,
         0x65,0xfb,0xd2,0xb4,0x4d,0x7a,0xf7,0xa4,0xa3,0x43,0x7e,0xa7,0x09,0xfe,0xbf,0xcd,
         0x22,0x57,0x08,0x38,0x52,0xb0,0x84,0x75,0xc6,0x12,0x61,0x0d,0xb5,0x6a,0x31,0x56,
         0xe5,0xf2,0x91,0x8f,0x70,0xed,0x09,0x2c,0xc8,0x97,0x34,0x6f,0xf9,0x5c,0x21,0x38,
         0x2e,0x48,0xf8,0x1e,0x77,0xbf,0xe1,0xbe,0xc9,0x6e,0x21,0x53,0x47,0x81,0x86,0x88,
         0xbf,0x16,0x06,0x8a,0x78,0xf2,0xa3,0x60,0x2b,0x73,0x92,0x7f,0x4f,0xc6,0x9b,0x99,
         0x99,0x5a,0xc3,0xb7,0xc4,0x95,0x29,0x87,0x8e,0xc5,0x2e,0xf7,0x03,0x59,0xd8,0x02,
         0xfd,0x51,0x79,0xca,0xec,0xf3,0x8b,0xe8,0xd3,0xc0,0xdf,0x00,0x93,0xa6,0xf7,0x98,
         0x6c,0x77,0xb0,0x2a,0xc1,0x9a,0x23,0x77,0x1b,0x01,0xce,0x1f,0x71,0x5a,0xef,0x6f,
         0xa7,0x8a,0x31,0x7a,0x54,0x57,0x8a,0x6b,0xc8,0x64,0x64,0x19,0x4e,0x63,0xfb,0xdc,
         0xae,0x86,0x06,0xa0,0xf6,0x36,0x99,0x37,0x7a,0x08,0x4a,0xf4,0x1a,0xed,0x93,0x75,
         0xc3,0xa9,0x77,0xc0,0x39,0x86,0x68,0x92,0x13,0x49,0x69,0xf3,0x07,0x65,0x70,0x0e,
         0x67,0x6f,0x0e,0x40,0xec,0xd2,0x51,0x6f,0xb3,0xc4,0xea,0x9d,0x85,0x78,0x8b,0xbc,
         0x5b,0x95,0x93,0xc4,0x21,0xe8,0xed,0x04,0xbb,0x55,0x35,0xb5,0x46,0x14,0x1d,0xd5,
         0xa0,0x1a,0x10,0x33,0x2a,0xd4,0x15,0xc6,0xcc,0x1b,0xf5,0x42,0x3a,0x65,0xa0,0xed,
         0x76,0x38,0xcd,0xaf,0x97,0xe5,0xe1,0x69,0xc8,0x72,0x12,0x88,0x93,0xd8,0xcc,0xda,
         0x60,0x6f,0x53,0xa0,0x38,0xa6,0xab,0xe4,0xcf,0xf7,0xb5,0x0d,0xc2,0x1a,0x9a,0xb0,
         0x1d,0x79,0x6c,0xa9,0x20,0xe5,0x0b,0x6b,0x43,0x87,0x46,0x94,0x77,0x19,0x43,0xc5,
         0xaf,0x56,0x21,0xb0,0x9f,0xae,0xdb,0x72,0xc3,0x3f,0x70,0x24,0xa4,0x01,0x41,0xac,
         0x57,0x40,0xba,0xd9,0x46,0x50,0x34,0xb0,0x33,0x7c,0x1a,0x00,0x79,0x3f,0x4b,0x3d,
         0x95,0xb7,0xc0,0x8a,0xe6,0x56,0x6f,0x18,0xb1,0xdb,0x6f,0xaf,0x68,0x80,0x5c,0x8a,
         0x2c,0x75,0xfd,0x68,0x90,0x8e,0x24,0xe0,0xa0,0x39,0xd6,0xf5,0x22,0xb2,0xac,0xea,
         0x1b,0x7a,0x79,0x58,0x95,0x05,0x2d,0x7d,0xa0,0xb2,0xfa,0xd7,0x97,0x01,0xb5,0xf1,
         0xa4,0x01,0x7e,0x7e,0x86,0x07,0xa3,0xa4,0x92,0xa5,0xc2,0x9a,0xf8,0xda,0x2e,0x75,
         0x48,0x87,0x94,0x3f,0x35,0x22,0xdf,0x4a,0x98,0xae,0x58,0xc3,0xb8,0xeb,0x12,0x8a,
         0xc8,0xca,0x85,0x41,0xb1,0x23,0x79,0xa4,0x12,0xaa,0x26,0x18,0x85,0x20,0x99,0x86,
         0x25,0xc6,0x59,0x69,0x4d,0x17,0x4b,0x26,0xa2,0xb6,0xd3,0x9d,0x53,0xa6,0x3c,0xfd,
         0x9f,0xb9,0x5a,0xdc,0x98,0x4b,0x6d,0x87,0x27,0x2f,0x49,0x96,0x51,0xea,0xb4,0xc4,
         0xb8,0x1f,0x10,0xfe,0x65,0x4b,0x3a,0xba,0xc4,0xb3,0xb1,0x8a,0xf0,0x9a,0xfb,0xf1,
         0x31,0xb6,0x44,0x75,0xc4,0xe5,0x49,0xf5,0xda,0x1d,0x74,0x3d,0xe2,0xa1,0x48,0xd8,
         0x0b,0x7b,0x00,0x25,0x05,0x26,0x73,0xae,0x08,0x8b,0x3b,0xb4,0x18,0x2f,0x16,0x0f,
         0x87,0xaa,0x8c,0x35,0xbb,0x5b,0xd3,0x98,0x32,0x5a,0xef,0x35,0xc2,0xae,0x1d,0x69,
         0x26,0xc0,0x72,0x07,0xb6,0x10,0xc0,0xa9,0x76,0x27,0xb9,0x43,0x52,0xcd,0x57,0xfe,
         0xa8,0x7b,0x7b,0x43,0x07,0x13,0xd4,0x15,0x37,0xcf,0x02,0xa5,0x79,0x77,0xfb,0x20,
         0x0f,0xd8,0xae,0xcc,0xff,0x71,0xe7,0x53,0x15,0x6f,0x73,0x5f,0x27,0xdc,0x84,0x66,
         0x9c,0x13,0x57,0xc8,0x2f,0x77,0x13,0x17,0xf1,0x64,0xf5,0xb5,0x8d,0x66,0xaa,0xa5,
         0xd0,0xa9,0xfc,0x9b,0x69,0xb1,0xb1,0x55,0xed,0x4b,0xb0,0x2e,0x1e,0xc4,0x66,0xf1,
         0x6c,0x58,0x68,0xeb,0xbc,0xed,0x5a,0x44,0x69,0x02,0x0f,0x8f,0x88,0xe2,0xf1,0x9f,
         0x71,0x1d,0xa4,0x9c,0x7b,0x38,0xe6,0x57,0x06,0xa4,0xba,0xdb,0xbf,0xed,0xc5,0x45,
         0x1f,0x34,0xf8,0xd5,0x35,0xdf,0x6f,0x44,0xa6,0x8f,0x99,0x58,0xf2,0x52,0x9a,0xb7,
         0xf8,0x1b,0xed,0xf9,0xbd,0x6f,0x4e,0x00,0x69,0x60,0xd7,0x8c,0x92,0xbf,0x69,0x0a,
         0xbd,0x8e,0x4d,0xad,0x22,0xb4,0x1b,0xc0,0xb0,0xf4,0xdb,0x3b,0x51,0x20,0x6b,0x94,
         0x6f,0x8a,0x21,0xd7,0xb7,0xbc,0xb0,0xf9,0x1d,0x69,0x50,0x6a,0x20,0xa3,0x19,0xe9,
         0x4f,0x4d,0xb0,0x9c,0x0c,0xd4,0x26,0x60,0x90,0x1a,0x1d,0x5e,0x2f,0xb3,0x2d,0xdf,
         0xdd,0x54,0x86,0x61,0xf2,0x88,0xd6,0xe9,0x2a,0xa5,0x6d,0x9c,0xf0,0xff,0x9f,0x89,
         0xdc,0x5b,0x69,0xca,0x7a,0xa7,0x58,0xcb,0x4d,0xe8,0xa7,0xe9,0x13,0x73,0xa7,0x3f,
         0x4b,0x60,0x64,0xbc,0xf5,0x3c,0x86,0x79,0x99,0xfe,0x75,0x4a,0x8a,0x3c,0xc1,0x94,
         0x6c,0x9f,0xc0,0x5e,0xf4,0x95,0x79,0xaa,0xef,0x45,0xc0,0x05,0x86,0xc8,0xa3,0x5d,
         0xc0,0x96,0x05,0x13,0x48,0x3e,0x89,0x51,0x71,0x5b,0xb2,0x9e,0x77,0xc3,0x48,0xaf,
         0x08,0x01,0xfd,0x80,0x02,0x06,0x50,0xa4,0x7f,0x1b,0xb2,0xda,0x0f,0x1a,0xe7,0xe0,
         0x44,0xde,0xb0,0x8c,0x74,0xf8,0xa7,0x18,0xba,0xa3,0x6a,0xbe,0x3e,0xfb,0xfb,0x84,
         0xb6,0x69,0x67,0x5a,0x2d,0x62,0xa6,0x62,0x03,0x51,0xc3,0x8f,0x36,0xd1,0x3d,0x71,
         0xdf,0x20,0xac,0x4f,0x00,0xd0,0xa7,0x77,0x7c,0xc0,0xe6,0xd2,0x67,0x4b,0xa4,0xbb,
         0x80,0xbf,0x47,0x11,0xfc,0x11,0x43,0x8b,0x86,0xcf,0x3c,0x4c,0x83,0x55,0x6b,0xb8,
         0x9a,0x44,0x42,0x85,0x74,0x30,0x53,0x15,0xc0,0x99,0x6e,0x03,0x7b,0x1d,0x09,0xfc,
         0x6e,0xeb,0xe5,0xd0,0xf8,0x7b,0xef,0xc8,0x0d,0x7d,0x65,0x3b,0x7f,0x0f,0x39,0x5c,
         0x7c,0x32,0xba,0x56,0x59,0x7f,0x71,0x9b,0x8d,0x16,0x49,0x78,0x01,0xd8,0xf4,0xee,
         0x87,0xd6,0x89,0xbd,0xa7,0x08,0x72,0xc1,0xa2,0x43,0x85,0x81,0xb1,0x65,0x71,0x06,
         0x8e,0xd3,0x5c,0xe9,0x35,0x25,0xca,0xb0,0xec,0x1f,0xc1,0x5b,0x81,0xe3,0x2b,0x39,
         0xd3,0x66,0x7b,0x00,0x93,0x21,0x93,0x1d,0x4c,0x09,0xe5,0x49,0xa1,0xc0,0xd9,0x5d,
         0xd7,0x0d,0x6f,0x67,0x93,0x8a,0x26,0xfd,0xe4,0x9c,0x1c,0xd1,0x83,0xa8,0x76,0x86,
         0x5a,0x84,0x02,0xc2,0x44,0x2c,0x1b,0x85,0x14,0xb7,0xce,0xb9,0xd8,0x89,0x3b,0x0a,
         0x5f,0xc9,0x3d,0xf7,0xf8,0x16,0x4d,0x29,0x7d,0x75,0xa3,0x04,0x90,0x8e,0x9f,0x7d,
         0x25,0x19,0x68,0x2b,0x41,0x93,0xd3,0xa0,0x00,0x35,0x86,0xf9,0xdd,0x26,0x5d,0xb4,
         0x2e,0xf0,0x0c,0xc2,0xee,0x31,0x06,0xdd,0xbf,0x93,0x9e,0x1c,0x2f,0xfd,0x6c,0xc5,
         0x3b,0x0b,0xf3,0x62,0x12,0xbc,0x80,0x17,0x1b,0x6b,0x55,0x32,0x38,0x01,0x07,0x04,
         0x4d,0x68,0x25,0xf0,0xfc,0x43,0x1a,0xc1,0xb3,0xdc,0x55,0x40,0xe9,0x5d,0xa7,0x07,
         0xa4,0x44,0xec,0x90,0x3f,0x11,0xed,0x91,0x6a,0x41,0x85,0x8c,0x72,0x80,0x03,0xa1,
         0xc3,0x1b,0xd0,0xa8,0xab,0xb4,0x52,0x7c,0x60,0x39,0x0f,0x99,0x45,0x17,0x16,0xea,
         0x69,0xaa,0x9b,0xdc,0x50,0xf8,0xe1,0xb7,0xf7,0xa0,0x5d,0x2e,0x12,0x0d,0x18,0x35},
        {0},
        /*TST_dataSize*/
        1536*sizeof(DxUint8_t),
        /*TST_Expected_CMAC*/
		{0x53,0xa6,0x6c,0x30,0xaf,0x43,0x0d,0x0b,0x4d,0x10,0xb8,0xf0,0x8d,0x3d,0xac,0xf4},
        CRYS_AES_CMAC_mode
    },
    #endif
    #if TST_USE_AES_192_KEY
    #if TST_USE_AES_16BYTE_DATA
	{ 
        {"Acceptance test - AES/CMAC/192Key/16ByteData "},
        /*TST_Key*/     
        {0x3D,0x62,0x62,0xD8,0xB0,0x06,0xFD,0xD5,0x4D,0x6D,0x81,0x8E,0x7B,0x6C,0xFC,0x71
        ,0x6D,0x0C,0x9C,0x93,0x87,0xF2,0xA6,0x70},
        CRYS_AES_Key192BitSize,
        /*TST_IvCounter*/
        {0x00}, 
        /*TST_input_data*/
        { 0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a},
        {0},
        /*TST_dataSize*/
        16*sizeof(DxUint8_t),
        /*TST_Expected_CMAC*/
        {0x5B,0xC1,0x63,0x9F,0x1B,0x58,0x7E,0xA7,0x14,0xE2,0x73,0x1B,0x27,0x11,0xA6,0x79}, 
        CRYS_AES_CMAC_mode
    },
    #endif
    #if TST_USE_AES_32BYTE_DATA
	{ 
        {"Acceptance test - AES/CMAC/192Key/32ByteData "},
        /*TST_Key*/     
        {0x3D,0x62,0x62,0xD8,0xB0,0x06,0xFD,0xD5,0x4D,0x6D,0x81,0x8E,0x7B,0x6C,0xFC,0x71
        ,0x6D,0x0C,0x9C,0x93,0x87,0xF2,0xA6,0x70},
        CRYS_AES_Key192BitSize,
        /*TST_IvCounter*/
        {0x00}, 
        /*TST_input_data*/
        { 0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a,
          0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a},
        {0},
        /*TST_dataSize*/
        32*sizeof(DxUint8_t),
        /*TST_Expected_CMAC*/
        {0xD8,0xC3,0x0C,0x5B,0xC3,0x39,0x05,0x7E,0x21,0x7B,0x2D,0x82,0xA8,0xA8,0x38,0x3F}, 
        CRYS_AES_CMAC_mode
    },
    #endif
    #if TST_USE_AES_512BYTE_DATA
	{ 
        {"Acceptance test - AES/CMAC/192Key/512ByteData "},
        /*TST_Key*/     
        {0x3D,0x62,0x62,0xD8,0xB0,0x06,0xFD,0xD5,0x4D,0x6D,0x81,0x8E,0x7B,0x6C,0xFC,0x71
        ,0x6D,0x0C,0x9C,0x93,0x87,0xF2,0xA6,0x70},
        CRYS_AES_Key192BitSize,
        /*TST_IvCounter*/
        {0x00}, 
        /*TST_input_data*/
        {0x74,0xFE,0xFD,0x82,0x3D,0xB7,0x75,0x57,0x65,0x62,0x8B,0xC2,0x76,0xAC,0x3D,0x4E,
        0x67,0xA6,0x3F,0x52,0xAC,0x08,0xF7,0xCB,0x8D,0xC5,0xCB,0x2D,0xDF,0xA5,0x4E,0x93,
        0x96,0x18,0xD5,0x2A,0x06,0xB6,0xD0,0x1B,0x18,0xB0,0x64,0x19,0xCE,0x1E,0x35,0xDF,
        0xCC,0xCA,0x49,0x0D,0xEB,0xA3,0x4B,0x6B,0x07,0x32,0xF5,0x78,0xEB,0x47,0x77,0xBF,
        0x14,0xF7,0x2C,0x5E,0xD7,0x13,0x48,0xB0,0xD6,0x23,0x39,0xFB,0xA4,0xDD,0xFD,0x6E,
        0x8F,0xEC,0x61,0x15,0x5C,0x40,0xA8,0xF2,0xCC,0x69,0x22,0xD4,0xC1,0x57,0x2F,0xD1,
        0x38,0xA4,0x04,0xD6,0xF2,0xD7,0x07,0xB9,0x82,0x98,0x37,0xC8,0x6A,0x4F,0xC7,0x29,
        0x35,0x86,0xE8,0xFF,0xE6,0x62,0x63,0xD3,0x4F,0x39,0x91,0x6D,0xF0,0x73,0xEF,0x7E,
        0xF3,0x68,0xC3,0xFF,0xD8,0x26,0x7B,0xB8,0xE4,0xA7,0x92,0xC3,0x09,0xDF,0x87,0x7C,
        0xA2,0xF8,0x9F,0x3A,0x6E,0x30,0xEA,0xD5,0x40,0x31,0x87,0xB8,0x45,0x9A,0xC9,0x0E,
        0xA9,0xB9,0xD4,0x02,0x8B,0xC7,0x50,0x0F,0x0B,0x30,0x1B,0x3F,0xD0,0xA0,0xCA,0x6F,
        0xB1,0x14,0xCB,0xF7,0xD4,0xB4,0x0F,0xC3,0x7E,0xEE,0xBE,0xA7,0x9E,0xC3,0x73,0x49,
        0xDE,0x84,0x19,0x4F,0x0B,0x85,0xF0,0xDB,0xA7,0x90,0x2F,0x3E,0x14,0xAA,0x05,0xA0,
        0x66,0x17,0x06,0x30,0xCF,0xD1,0x39,0xF5,0xA9,0x10,0x84,0x9D,0x08,0xA9,0x70,0x48,
        0xBC,0xD1,0x60,0x4B,0x87,0x7A,0x63,0x2C,0x24,0xF0,0x4F,0x44,0x85,0xD0,0xAF,0xD3,
        0xE9,0x1E,0x40,0x87,0xBC,0x42,0x7A,0x0C,0x4A,0x23,0xA5,0xFB,0x01,0x53,0xD2,0xFE,
        0x1F,0xE7,0x81,0x42,0x4A,0xB9,0x18,0xEC,0xB3,0xDA,0x0C,0xDE,0x82,0xF4,0x70,0xD9,
        0x60,0xB0,0xB4,0xEA,0x69,0xE9,0x8B,0x79,0x56,0x53,0x01,0x63,0xD4,0x68,0x2A,0xD0,
        0x1D,0x51,0x25,0x9D,0x4E,0x6D,0x88,0x2F,0x05,0x54,0xD3,0xE1,0x36,0x9C,0x8A,0x55,
        0xB3,0xCC,0x9B,0x50,0x9E,0xE7,0x95,0x36,0x5B,0x08,0xEB,0xF6,0xB7,0xB5,0x17,0x4B,
        0xAF,0x3B,0xC0,0x30,0xCF,0xD2,0x8A,0xF3,0x27,0x84,0xE5,0x14,0x16,0xA9,0x43,0xBA,
        0xC8,0xAB,0xAF,0x08,0xCD,0xD9,0x31,0x36,0xBB,0xEE,0x41,0x46,0x81,0x92,0x77,0x4F,
        0x3C,0x87,0x31,0xFB,0xDB,0x5A,0x85,0xE0,0x42,0xA7,0x29,0x1A,0x02,0x80,0x20,0xB1,
        0xC4,0x30,0x2D,0x0C,0x05,0x0F,0x7E,0xD6,0x09,0x8A,0x75,0xE1,0x90,0x43,0x71,0x95,
        0x0C,0x95,0xD7,0x8E,0x77,0x47,0xDF,0x6E,0x25,0xCF,0xC5,0x25,0xB0,0x17,0x33,0x3B,
        0xCE,0x8F,0x82,0x50,0x64,0x6B,0x4A,0x2D,0x08,0x5B,0xF1,0x50,0xE5,0xA4,0x4F,0xFF,
        0x36,0x93,0x0D,0x6D,0xA8,0x91,0x39,0x7C,0x50,0xBF,0xE6,0x36,0x49,0x59,0x25,0xF1,
        0x56,0x39,0x12,0x01,0xC1,0x20,0x31,0xA1,0x4A,0xA9,0x86,0x1C,0x56,0x8F,0x89,0x81,
        0x7F,0xC6,0xEF,0x1D,0x0A,0xC6,0x92,0x3C,0x55,0x05,0xFF,0xA5,0x85,0x13,0xE4,0xAF,
        0x35,0x00,0xF9,0xAB,0x92,0x4E,0x3D,0x15,0x62,0x6B,0x22,0xFF,0x0B,0x1D,0x26,0xC1,
        0x35,0x65,0xB7,0x82,0x6A,0x08,0xE6,0x90,0xA7,0xD5,0xAB,0xBC,0x20,0x8B,0x1B,0x37,
        0xC5,0xD6,0xE6,0x56,0x96,0xDE,0xEE,0x30,0x89,0xD9,0xBA,0x9E,0xA3,0x93,0x31,0x38},
        {0},
        /*TST_dataSize*/
        512*sizeof(DxUint8_t),
        /*TST_Expected_CMAC*/
		{0x46,0x30,0x0E,0xEE,0x82,0xBE,0x84,0xF8,0x53,0x06,0x8C,0xC9,0x9B,0xFD,0xFF,0xE8,},
        CRYS_AES_CMAC_mode
    },
    #endif
    #if TST_USE_AES_1536BYTE_DATA
    { 
        {"Acceptance test - AES/CMAC/192Key/1536ByteData "},
        /*TST_Key*/     
        {0x3D,0x62,0x62,0xD8,0xB0,0x06,0xFD,0xD5,0x4D,0x6D,0x81,0x8E,0x7B,0x6C,0xFC,0x71
        ,0x6D,0x0C,0x9C,0x93,0x87,0xF2,0xA6,0x70},
        CRYS_AES_Key192BitSize,
        /*TST_IvCounter*/
        {0x00}, 
        /*TST_input_data*/
        {0x97,0xFA,0x87,0x45,0x20,0x76,0xEB,0x05,0x12,0xAD,0x04,0x41,0xE0,0xD0,0xAF,0xC1,
        0x91,0x7C,0x96,0xE6,0x66,0x78,0x62,0x57,0x67,0x2F,0xBF,0x42,0x06,0x1D,0xAC,0xB0,
        0x4E,0x43,0xC1,0x95,0xC0,0x7A,0xF8,0xEB,0x77,0x6C,0xFF,0x16,0x7F,0xB9,0x4E,0x6B,
        0xB0,0x55,0x80,0x86,0x9B,0x58,0xF2,0x1E,0x98,0x30,0xDD,0xF0,0xB7,0xA9,0xFF,0xF5,
        0x01,0x54,0xF2,0x9C,0x0F,0x1A,0x00,0x16,0x83,0xAA,0x6F,0xF9,0x79,0x4B,0xD8,0xAD,
        0xE1,0x54,0x92,0xB0,0x9C,0x26,0x14,0xF6,0x50,0xA2,0xFD,0x90,0x9D,0x08,0x34,0xCD,
        0x6D,0x0A,0x15,0x2B,0xC7,0xB2,0x5C,0x95,0x55,0x69,0x03,0xF1,0xE9,0xF9,0xA5,0x4C,
        0x57,0x2F,0x0F,0x62,0x16,0x4E,0x58,0xDA,0x3F,0xFB,0x4B,0x6C,0x1D,0x6F,0x79,0x7B,
        0x76,0xA1,0x8B,0x6E,0x36,0xAD,0xE6,0x2F,0xF8,0xFD,0x5B,0x32,0x22,0x23,0x0D,0x56,
        0xFD,0xB0,0x38,0x6D,0xF8,0xD1,0xB6,0x1F,0xB1,0x3A,0xEC,0xCB,0x66,0xEF,0x77,0xE5,
        0xF0,0x88,0x7A,0x47,0x6E,0x36,0x15,0xAA,0x49,0xE0,0x6A,0x19,0xF2,0x25,0xB7,0x1B,
        0xEE,0xF4,0x6E,0x6C,0x36,0x0C,0x82,0xA4,0xEA,0x6C,0xBD,0xFB,0xC1,0x1B,0xC8,0x08,
        0x85,0x76,0x42,0x9A,0xA8,0xC5,0xE8,0xC7,0x9B,0x8E,0x23,0x17,0x66,0x9C,0x2D,0x8C,
        0x83,0xD0,0xDD,0x71,0x81,0x0B,0xAE,0xE4,0x05,0xD6,0x5D,0x02,0x79,0x1A,0xE9,0x2E,
        0x17,0x62,0x94,0x7B,0xE3,0x1C,0x72,0x28,0x0B,0xA7,0xD1,0xA8,0xE8,0x6A,0x3D,0x4D,
        0x3F,0x30,0x78,0xF0,0x3D,0x56,0x87,0x7A,0xC8,0x5D,0x95,0xD2,0x68,0xE6,0x4E,0x81,
        0xA5,0xF5,0x00,0x04,0x08,0xB1,0xA9,0x66,0x5E,0xB4,0x65,0xD9,0x39,0x06,0xFC,0x9A,
        0x98,0x0F,0xC3,0x48,0xA1,0xF8,0xF0,0xC0,0xDB,0x1A,0xB3,0x85,0x87,0x9F,0xBF,0x25,
        0x58,0x50,0x03,0xF2,0x6A,0x39,0x45,0x8D,0x87,0x12,0x92,0x88,0xF1,0xAD,0x40,0xC2,
        0x61,0xFA,0x3A,0x58,0x23,0x05,0xDF,0xAC,0x04,0x3F,0x29,0xED,0xFD,0x23,0xDE,0xBE,
        0xF5,0x40,0x81,0xE9,0x02,0x09,0x2F,0x5E,0xCA,0x35,0xC1,0x8F,0x66,0x68,0xCF,0x2D,
        0xDA,0xF1,0x24,0x8C,0x65,0x67,0x01,0x52,0x70,0x57,0xEE,0x2B,0x10,0x58,0x90,0x63,
        0x33,0xD3,0x93,0xB0,0x2C,0x56,0xBF,0x58,0xCB,0xDB,0x8E,0xEE,0x44,0x50,0x45,0x9C,
        0x6F,0xFB,0x12,0x0B,0xFF,0x52,0x59,0x8E,0x3E,0x2E,0x79,0xAB,0x1A,0x04,0x4E,0x71,
        0xA4,0x5D,0x5B,0x93,0xD4,0x1E,0x01,0x83,0x32,0xCC,0xC1,0x89,0xD8,0x13,0x0D,0x20,
        0x11,0x51,0xBB,0x15,0x45,0x84,0x64,0xE0,0x7A,0x05,0x71,0xFD,0xDD,0x13,0x3D,0xC6,
        0x8D,0x1C,0x49,0xE7,0xF4,0xB2,0xC8,0x50,0xF9,0x8F,0xD9,0x33,0x91,0xD0,0xB5,0x2B,
        0x20,0x59,0x99,0xC9,0x49,0x39,0x2C,0x20,0xF9,0x7A,0x19,0xCE,0xAC,0x03,0xA6,0x1E,
        0x8F,0xFA,0xFB,0xBB,0xC9,0x26,0x2B,0x5F,0x89,0x6A,0x1B,0xB6,0xAB,0x30,0x4F,0xA9,
        0x4F,0x46,0xDD,0x84,0x79,0x74,0x7D,0x54,0xEF,0x29,0xEE,0x7A,0x99,0xF9,0xA3,0xF6,
        0xE9,0xBA,0xA4,0x96,0xD4,0xF9,0x61,0xF9,0x2D,0x3A,0x3F,0xDE,0x1D,0x76,0x75,0xC8,
        0x2B,0x6F,0x7F,0x66,0x26,0x21,0xA4,0x1B,0x7D,0xA7,0xCB,0xA0,0x38,0xB0,0xC6,0x90,
        0xC6,0x25,0xCC,0xF0,0x8C,0xB9,0xD5,0x56,0xE4,0xE3,0x56,0x3F,0x34,0x9F,0x36,0x79,
        0xB3,0x26,0x4F,0x29,0x7A,0x3D,0xD0,0xC7,0x15,0x89,0x18,0x2C,0x2E,0xC0,0xC1,0x7C,
        0x74,0xAE,0x17,0xF8,0xA9,0x84,0x3B,0x71,0x99,0x29,0x81,0x42,0xCA,0x65,0xE6,0xDE,
        0x71,0x52,0xEC,0x12,0x61,0x9C,0x16,0x89,0x55,0x04,0xDA,0x03,0xA0,0xA8,0x27,0x23,
        0x22,0xD9,0xCB,0x85,0x87,0x3D,0xCF,0x2F,0xEA,0xDD,0x90,0x51,0xBB,0x8D,0xFD,0xB0,
        0xA2,0x3A,0xBB,0xDB,0xD4,0xAF,0x1B,0xD7,0x98,0x8D,0xA3,0xA4,0xAA,0x38,0xD1,0xF1,
        0x01,0x5D,0x20,0xF0,0x9A,0x60,0x56,0x33,0x83,0xBD,0x27,0x84,0x0C,0xC5,0xCD,0xC7,
        0x07,0x2A,0x60,0x65,0xEC,0x4C,0x4F,0x72,0xBE,0xF3,0xED,0xF9,0x99,0x2A,0x84,0xB2,
        0x0B,0x9F,0x50,0x5E,0x6D,0x0C,0x15,0x42,0xE4,0x88,0x57,0x16,0x87,0x96,0xCB,0xD3,
        0xC0,0xDC,0x9D,0x7F,0xD7,0x6C,0x04,0xB4,0x0E,0xAD,0x31,0xA7,0x73,0x5C,0x9A,0x59,
        0x38,0x74,0x79,0x6D,0x75,0x6F,0x5A,0xFA,0x15,0x1D,0x81,0x64,0xF4,0x38,0xEA,0x28,
        0x27,0x1A,0x39,0xBD,0x8D,0x05,0xDA,0x9F,0x9A,0x9B,0x50,0xBF,0xDB,0x6E,0xCF,0x88,
        0xEE,0xFE,0xDE,0x12,0x1D,0x5E,0x5E,0x51,0x82,0xA2,0x6A,0xB9,0xEB,0xA0,0xBF,0xD5,
        0xC2,0x09,0x7F,0x58,0x22,0xDD,0xCB,0x33,0x9A,0xD9,0xD2,0xD9,0x1E,0x9A,0x1F,0xA6,
        0x4E,0xF9,0x76,0xF5,0x5A,0xD7,0x0A,0xC9,0xBC,0xE7,0x3A,0xEA,0x9A,0x21,0xB4,0xFA,
        0xDC,0x7B,0xFC,0xD1,0xEF,0x76,0x65,0x11,0x32,0xAA,0x78,0x43,0x8C,0x84,0x32,0xE8,
        0x82,0xC3,0x6B,0xF2,0x2A,0xC9,0x7A,0xEA,0xFE,0xB5,0x9C,0x3B,0xA2,0xE1,0x99,0x79,
        0x25,0xD8,0xFD,0xA3,0x9D,0x4E,0xB7,0xD7,0x93,0x65,0xC2,0xB0,0x5F,0xC6,0x3D,0x37,
        0xB4,0x52,0x67,0xD6,0xB5,0xC2,0xD0,0x12,0x00,0x11,0xD2,0x39,0xDA,0x29,0x6E,0x51,
        0x11,0xFF,0x1E,0xB3,0x87,0x8F,0x4A,0x34,0x0C,0x93,0x5E,0xC5,0x06,0xCA,0x8B,0x37,
        0x78,0x65,0x86,0x4F,0x79,0xC2,0xC3,0x63,0x07,0xEB,0xA2,0x8B,0x7B,0x7E,0xFD,0x69,
        0xF6,0x71,0x9E,0x5F,0xA8,0x89,0xB0,0x25,0x07,0x33,0xCA,0x22,0x63,0x0B,0x0B,0x36,
        0x86,0x9A,0xC0,0x74,0xA3,0x1E,0xD7,0x4F,0x3C,0xBB,0xAB,0x9C,0xEC,0xBF,0xB8,0x8D,
        0x95,0xF4,0xCE,0x95,0x2B,0x2C,0x8F,0xEF,0xB4,0x60,0x48,0x46,0xF7,0xA0,0xFF,0xFC,
        0xDF,0x6C,0x05,0xE0,0xBD,0x88,0xC6,0xD7,0x99,0x4F,0x22,0xED,0xDD,0x13,0x38,0x48,
        0x7A,0x3C,0x8D,0x6F,0x3C,0x76,0x0B,0x59,0x0B,0xD1,0xBF,0x43,0xD6,0x91,0x57,0x9B,
        0xBC,0xAF,0xBC,0x80,0xB9,0xD8,0xCF,0x0C,0x2D,0xF7,0xFB,0xDB,0x09,0xA2,0x12,0xA1,
        0x27,0xFF,0xCC,0xBB,0x13,0x8F,0xC0,0x69,0x61,0xAB,0xD5,0xEC,0xC8,0x83,0x00,0x08,
        0xF8,0x87,0x31,0x2E,0x57,0xB8,0x8E,0xA2,0x6C,0x80,0x41,0x45,0x7A,0x2F,0x50,0x69,
        0xBE,0x1E,0x1B,0xD7,0xC5,0x9C,0x88,0x2C,0xEE,0x53,0x1F,0x0E,0x03,0xE2,0x43,0xAA,
        0xF6,0xF2,0xE3,0x82,0x71,0xE3,0x4A,0x6F,0x70,0x2A,0x4E,0x92,0x4D,0x7B,0xEE,0x31,
        0x5B,0x6B,0x2D,0xAA,0x67,0x29,0x43,0x5C,0xFE,0x04,0x3F,0x03,0x98,0x80,0x9E,0x8A,
        0x3D,0x96,0x4E,0x88,0x4B,0xCE,0xF7,0xDB,0xD4,0xAB,0x66,0x9B,0x4E,0xF5,0xDF,0x73,
        0x64,0xED,0xB3,0x97,0xB4,0x99,0x43,0xCC,0xAF,0x87,0x83,0x6D,0xA4,0x46,0xD6,0xF0,
        0x8B,0xC4,0x55,0xB6,0x2C,0x66,0xE6,0x8C,0x74,0x52,0xD5,0xBC,0xC3,0xA8,0x0E,0x09,
        0x25,0xCC,0x9F,0xAA,0xCC,0x07,0xD5,0xA3,0x53,0x82,0xD8,0xC3,0x4A,0x8A,0x37,0x8E,
        0xD4,0x76,0x0F,0x89,0x9F,0x28,0x46,0xFD,0x07,0x26,0x23,0x62,0xC4,0x86,0x09,0x06,
        0x79,0x7A,0x47,0xD7,0xA6,0x2B,0x23,0x83,0xEF,0xB2,0x62,0xAA,0x8D,0x22,0x42,0xE9,
        0x1B,0x46,0xE7,0x4D,0x98,0x84,0x69,0xFC,0x85,0xA1,0xA3,0xA6,0xE4,0x72,0xDF,0xCC,
        0x78,0xD2,0x4A,0xCF,0x43,0x5F,0xE8,0xA8,0x52,0x8B,0x9A,0xED,0xC5,0x9C,0x70,0xE5,
        0xE3,0x3A,0x46,0x7D,0x9F,0xBC,0x6E,0xF5,0x11,0x4B,0x51,0x04,0x88,0x7D,0x9F,0x7C,
        0xD2,0x96,0x31,0xBB,0xD8,0x72,0xA6,0xBC,0x5E,0x3E,0xFA,0x0C,0xE9,0x7B,0x37,0xE9,
        0x31,0xBE,0xC2,0xA9,0x2C,0x62,0x2D,0xBC,0x64,0x54,0xBE,0xF7,0x0D,0xE3,0x20,0xD5,
        0xEC,0x1E,0x1A,0x2F,0x6A,0xB4,0x0C,0x71,0x93,0x89,0x1E,0x60,0xC1,0x61,0x0C,0x95,
        0x13,0x68,0xD3,0xCA,0xBA,0xF5,0x4F,0x70,0x68,0x75,0x57,0x83,0xB4,0xAE,0xAF,0x7B,
        0x1E,0x25,0x20,0xCA,0x61,0x07,0x7F,0x7C,0xB1,0x51,0x16,0xA2,0x43,0xCC,0xFA,0x02,
        0x48,0x29,0xE4,0xA5,0x0F,0x56,0x1A,0xF6,0xCF,0xAA,0xC6,0xF4,0x5D,0x89,0xBC,0xE5,
        0xDA,0xA3,0x42,0x9C,0x41,0x41,0x34,0x0C,0xE8,0x56,0x18,0x69,0xDF,0xAC,0x2C,0x9C,
        0x7A,0x54,0x3A,0x8A,0xCA,0x0A,0x6B,0xC8,0x0A,0x29,0xFB,0xB6,0x41,0x8A,0x1F,0x27,
        0x94,0x30,0xC8,0xA0,0x8A,0x5E,0xC1,0x07,0xF4,0xD8,0xBC,0xB9,0x3D,0xB1,0x16,0x22,
        0x7D,0x2A,0x7A,0x08,0x4E,0x31,0x1B,0xD0,0x37,0x79,0x92,0x17,0x45,0x7D,0xCA,0x5E,
        0x37,0xF0,0xD4,0xAF,0xE4,0x8C,0x11,0x1B,0x93,0x33,0x95,0xF2,0x4D,0xB2,0x8B,0x58,
        0x13,0xD9,0x38,0x17,0x10,0x16,0xD9,0x62,0x14,0xF7,0x69,0x10,0xCC,0xAA,0xC1,0x77,
        0x0D,0x5E,0x81,0x4C,0xDD,0x67,0x3E,0xF1,0x18,0x5E,0x75,0x1B,0x9B,0x29,0x82,0x85,
        0xEE,0x39,0x03,0x6C,0x44,0xB3,0x4D,0x20,0x17,0x71,0x9A,0xEC,0x22,0x00,0x4F,0xE8,
        0x71,0x1E,0xE4,0xEF,0x30,0x3E,0x7A,0xAB,0x9A,0x47,0xFF,0xB1,0xA0,0xBD,0xC6,0xEA,
        0x74,0xE4,0x22,0x92,0xA6,0x55,0x32,0x5A,0x10,0x61,0x34,0x6B,0xCC,0x51,0xCE,0x17,
        0x0E,0x8D,0xAA,0x7D,0x44,0x93,0x54,0xAF,0xBE,0x57,0xD1,0xFD,0xB4,0x9C,0x80,0x5A,
        0xAA,0xAF,0x77,0x3E,0xDE,0xBC,0x41,0x1B,0xEC,0x8A,0xDF,0xCF,0x09,0x0E,0xDF,0x49,
        0x78,0xE7,0xA2,0x13,0x13,0x49,0xA5,0xE1,0x8F,0x73,0xD4,0x4E,0x83,0x34,0xA5,0x74,
        0xE0,0xDA,0xC1,0x1C,0xD9,0x90,0x39,0x52,0x4B,0x8E,0x91,0xBA,0xB4,0x85,0xA5,0xAF,
        0x78,0x88,0x85,0xCC,0xF9,0x6C,0x47,0x61,0x09,0x96,0xAF,0x6B,0xE8,0xF3,0x98,0xB7,
        0xE4,0x6B,0xEE,0x2F,0x4D,0xC3,0x6F,0xE7,0xAE,0x50,0xC8,0x84,0xB8,0xEB,0x2D,0x0A,
        0xCD,0x24,0xD6,0xFB,0xAF,0xD9,0x7A,0x74,0x93,0x5F,0x12,0x43,0xE1,0xCD,0x69,0x57},
        {0},
        /*TST_dataSize*/
        1536*sizeof(DxUint8_t),
        /*TST_Expected_CMAC*/
		{0x4B,0xCD,0xEA,0xA9,0x90,0x3E,0x91,0x6E,0xD9,0xEA,0x0A,0xF3,0x76,0xE9,0x38,0xD4},
        CRYS_AES_CMAC_mode
    },
    #endif
    #endif
    #if  TST_USE_AES_256_KEY
    #if TST_USE_AES_16BYTE_DATA
	{ 
        {"Acceptance test - AES/CMAC/256Key/16ByteData "},
        /*TST_Key*/     
        {0x3D,0x62,0x62,0xD8,0xB0,0x06,0xFD,0xD5,0x4D,0x6D,0x81,0x8E,0x7B,0x6C,0xFC,0x71
        ,0x6D,0x0C,0x9C,0x93,0x87,0xF2,0xA6,0x70,0x4D,0x6D,0x81,0x8E,0x7B,0x6C,0xFC,0x71},
        CRYS_AES_Key256BitSize,
        /*TST_IvCounter*/
        {0x00}, 
        /*TST_input_data*/
        { 0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a},
        {0},
        /*TST_dataSize*/
        16*sizeof(DxUint8_t),
        /*TST_Expected_CMAC*/
        {0x10,0x2D,0x0C,0xB4,0xF3,0x23,0xFD,0x3E,0xB1,0x96,0xDB,0xA9,0x9A,0x80,0xF3,0x5C}, 
        CRYS_AES_CMAC_mode
    },
    #endif
    #if TST_USE_AES_32BYTE_DATA
	{ 
        {"Acceptance test - AES/CMAC/256Key/32ByteData "},
        /*TST_Key*/     
        {0x3D,0x62,0x62,0xD8,0xB0,0x06,0xFD,0xD5,0x4D,0x6D,0x81,0x8E,0x7B,0x6C,0xFC,0x71
        ,0x6D,0x0C,0x9C,0x93,0x87,0xF2,0xA6,0x70,0x4D,0x6D,0x81,0x8E,0x7B,0x6C,0xFC,0x71},
        CRYS_AES_Key256BitSize,
        /*TST_IvCounter*/
        {0x00}, 
        /*TST_input_data*/
        { 0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a,
          0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a},
        {0},
        /*TST_dataSize*/
        32*sizeof(DxUint8_t),
        /*TST_Expected_CMAC*/
        {0xA7,0x3B,0x72,0xA9,0xCC,0x47,0x46,0x44,0x4D,0xB3,0x14,0x23,0xA0,0xA5,0x59,0xEE}, 
        CRYS_AES_CMAC_mode
    },
    #endif
    #if TST_USE_AES_512BYTE_DATA
	{ 
        {"Acceptance test - AES/CMAC/256Key/512ByteData "},
        /*TST_Key*/     
        {0x3D,0x62,0x62,0xD8,0xB0,0x06,0xFD,0xD5,0x4D,0x6D,0x81,0x8E,0x7B,0x6C,0xFC,0x71
        ,0x6D,0x0C,0x9C,0x93,0x87,0xF2,0xA6,0x70,0x4D,0x6D,0x81,0x8E,0x7B,0x6C,0xFC,0x71},
        CRYS_AES_Key256BitSize,
        /*TST_IvCounter*/
        {0x00}, 
        /*TST_input_data*/
        {0x74,0xFE,0xFD,0x82,0x3D,0xB7,0x75,0x57,0x65,0x62,0x8B,0xC2,0x76,0xAC,0x3D,0x4E,
        0x67,0xA6,0x3F,0x52,0xAC,0x08,0xF7,0xCB,0x8D,0xC5,0xCB,0x2D,0xDF,0xA5,0x4E,0x93,
        0x96,0x18,0xD5,0x2A,0x06,0xB6,0xD0,0x1B,0x18,0xB0,0x64,0x19,0xCE,0x1E,0x35,0xDF,
        0xCC,0xCA,0x49,0x0D,0xEB,0xA3,0x4B,0x6B,0x07,0x32,0xF5,0x78,0xEB,0x47,0x77,0xBF,
        0x14,0xF7,0x2C,0x5E,0xD7,0x13,0x48,0xB0,0xD6,0x23,0x39,0xFB,0xA4,0xDD,0xFD,0x6E,
        0x8F,0xEC,0x61,0x15,0x5C,0x40,0xA8,0xF2,0xCC,0x69,0x22,0xD4,0xC1,0x57,0x2F,0xD1,
        0x38,0xA4,0x04,0xD6,0xF2,0xD7,0x07,0xB9,0x82,0x98,0x37,0xC8,0x6A,0x4F,0xC7,0x29,
        0x35,0x86,0xE8,0xFF,0xE6,0x62,0x63,0xD3,0x4F,0x39,0x91,0x6D,0xF0,0x73,0xEF,0x7E,
        0xF3,0x68,0xC3,0xFF,0xD8,0x26,0x7B,0xB8,0xE4,0xA7,0x92,0xC3,0x09,0xDF,0x87,0x7C,
        0xA2,0xF8,0x9F,0x3A,0x6E,0x30,0xEA,0xD5,0x40,0x31,0x87,0xB8,0x45,0x9A,0xC9,0x0E,
        0xA9,0xB9,0xD4,0x02,0x8B,0xC7,0x50,0x0F,0x0B,0x30,0x1B,0x3F,0xD0,0xA0,0xCA,0x6F,
        0xB1,0x14,0xCB,0xF7,0xD4,0xB4,0x0F,0xC3,0x7E,0xEE,0xBE,0xA7,0x9E,0xC3,0x73,0x49,
        0xDE,0x84,0x19,0x4F,0x0B,0x85,0xF0,0xDB,0xA7,0x90,0x2F,0x3E,0x14,0xAA,0x05,0xA0,
        0x66,0x17,0x06,0x30,0xCF,0xD1,0x39,0xF5,0xA9,0x10,0x84,0x9D,0x08,0xA9,0x70,0x48,
        0xBC,0xD1,0x60,0x4B,0x87,0x7A,0x63,0x2C,0x24,0xF0,0x4F,0x44,0x85,0xD0,0xAF,0xD3,
        0xE9,0x1E,0x40,0x87,0xBC,0x42,0x7A,0x0C,0x4A,0x23,0xA5,0xFB,0x01,0x53,0xD2,0xFE,
        0x1F,0xE7,0x81,0x42,0x4A,0xB9,0x18,0xEC,0xB3,0xDA,0x0C,0xDE,0x82,0xF4,0x70,0xD9,
        0x60,0xB0,0xB4,0xEA,0x69,0xE9,0x8B,0x79,0x56,0x53,0x01,0x63,0xD4,0x68,0x2A,0xD0,
        0x1D,0x51,0x25,0x9D,0x4E,0x6D,0x88,0x2F,0x05,0x54,0xD3,0xE1,0x36,0x9C,0x8A,0x55,
        0xB3,0xCC,0x9B,0x50,0x9E,0xE7,0x95,0x36,0x5B,0x08,0xEB,0xF6,0xB7,0xB5,0x17,0x4B,
        0xAF,0x3B,0xC0,0x30,0xCF,0xD2,0x8A,0xF3,0x27,0x84,0xE5,0x14,0x16,0xA9,0x43,0xBA,
        0xC8,0xAB,0xAF,0x08,0xCD,0xD9,0x31,0x36,0xBB,0xEE,0x41,0x46,0x81,0x92,0x77,0x4F,
        0x3C,0x87,0x31,0xFB,0xDB,0x5A,0x85,0xE0,0x42,0xA7,0x29,0x1A,0x02,0x80,0x20,0xB1,
        0xC4,0x30,0x2D,0x0C,0x05,0x0F,0x7E,0xD6,0x09,0x8A,0x75,0xE1,0x90,0x43,0x71,0x95,
        0x0C,0x95,0xD7,0x8E,0x77,0x47,0xDF,0x6E,0x25,0xCF,0xC5,0x25,0xB0,0x17,0x33,0x3B,
        0xCE,0x8F,0x82,0x50,0x64,0x6B,0x4A,0x2D,0x08,0x5B,0xF1,0x50,0xE5,0xA4,0x4F,0xFF,
        0x36,0x93,0x0D,0x6D,0xA8,0x91,0x39,0x7C,0x50,0xBF,0xE6,0x36,0x49,0x59,0x25,0xF1,
        0x56,0x39,0x12,0x01,0xC1,0x20,0x31,0xA1,0x4A,0xA9,0x86,0x1C,0x56,0x8F,0x89,0x81,
        0x7F,0xC6,0xEF,0x1D,0x0A,0xC6,0x92,0x3C,0x55,0x05,0xFF,0xA5,0x85,0x13,0xE4,0xAF,
        0x35,0x00,0xF9,0xAB,0x92,0x4E,0x3D,0x15,0x62,0x6B,0x22,0xFF,0x0B,0x1D,0x26,0xC1,
        0x35,0x65,0xB7,0x82,0x6A,0x08,0xE6,0x90,0xA7,0xD5,0xAB,0xBC,0x20,0x8B,0x1B,0x37,
        0xC5,0xD6,0xE6,0x56,0x96,0xDE,0xEE,0x30,0x89,0xD9,0xBA,0x9E,0xA3,0x93,0x31,0x38},
        {0},
        /*TST_dataSize*/
        512*sizeof(DxUint8_t),
        /*TST_Expected_CMAC*/
		{0x48,0x59,0xB2,0xC3,0x70,0xC4,0xD8,0x8A,0x16,0x7A,0xFB,0xB1,0x35,0xB3,0xE6,0x75},
        CRYS_AES_CMAC_mode
    },
    #endif
    #if TST_USE_AES_1536BYTE_DATA
    { 
        {"Acceptance test - AES/CMAC/256Key/1536ByteData "},
        /*TST_Key*/     
        {0x3D,0x62,0x62,0xD8,0xB0,0x06,0xFD,0xD5,0x4D,0x6D,0x81,0x8E,0x7B,0x6C,0xFC,0x71
        ,0x6D,0x0C,0x9C,0x93,0x87,0xF2,0xA6,0x70,0x4D,0x6D,0x81,0x8E,0x7B,0x6C,0xFC,0x71},
        CRYS_AES_Key256BitSize,
        /*TST_IvCounter*/
        {0x00}, 
        /*TST_input_data*/
        {0x97,0xFA,0x87,0x45,0x20,0x76,0xEB,0x05,0x12,0xAD,0x04,0x41,0xE0,0xD0,0xAF,0xC1,
        0x91,0x7C,0x96,0xE6,0x66,0x78,0x62,0x57,0x67,0x2F,0xBF,0x42,0x06,0x1D,0xAC,0xB0,
        0x4E,0x43,0xC1,0x95,0xC0,0x7A,0xF8,0xEB,0x77,0x6C,0xFF,0x16,0x7F,0xB9,0x4E,0x6B,
        0xB0,0x55,0x80,0x86,0x9B,0x58,0xF2,0x1E,0x98,0x30,0xDD,0xF0,0xB7,0xA9,0xFF,0xF5,
        0x01,0x54,0xF2,0x9C,0x0F,0x1A,0x00,0x16,0x83,0xAA,0x6F,0xF9,0x79,0x4B,0xD8,0xAD,
        0xE1,0x54,0x92,0xB0,0x9C,0x26,0x14,0xF6,0x50,0xA2,0xFD,0x90,0x9D,0x08,0x34,0xCD,
        0x6D,0x0A,0x15,0x2B,0xC7,0xB2,0x5C,0x95,0x55,0x69,0x03,0xF1,0xE9,0xF9,0xA5,0x4C,
        0x57,0x2F,0x0F,0x62,0x16,0x4E,0x58,0xDA,0x3F,0xFB,0x4B,0x6C,0x1D,0x6F,0x79,0x7B,
        0x76,0xA1,0x8B,0x6E,0x36,0xAD,0xE6,0x2F,0xF8,0xFD,0x5B,0x32,0x22,0x23,0x0D,0x56,
        0xFD,0xB0,0x38,0x6D,0xF8,0xD1,0xB6,0x1F,0xB1,0x3A,0xEC,0xCB,0x66,0xEF,0x77,0xE5,
        0xF0,0x88,0x7A,0x47,0x6E,0x36,0x15,0xAA,0x49,0xE0,0x6A,0x19,0xF2,0x25,0xB7,0x1B,
        0xEE,0xF4,0x6E,0x6C,0x36,0x0C,0x82,0xA4,0xEA,0x6C,0xBD,0xFB,0xC1,0x1B,0xC8,0x08,
        0x85,0x76,0x42,0x9A,0xA8,0xC5,0xE8,0xC7,0x9B,0x8E,0x23,0x17,0x66,0x9C,0x2D,0x8C,
        0x83,0xD0,0xDD,0x71,0x81,0x0B,0xAE,0xE4,0x05,0xD6,0x5D,0x02,0x79,0x1A,0xE9,0x2E,
        0x17,0x62,0x94,0x7B,0xE3,0x1C,0x72,0x28,0x0B,0xA7,0xD1,0xA8,0xE8,0x6A,0x3D,0x4D,
        0x3F,0x30,0x78,0xF0,0x3D,0x56,0x87,0x7A,0xC8,0x5D,0x95,0xD2,0x68,0xE6,0x4E,0x81,
        0xA5,0xF5,0x00,0x04,0x08,0xB1,0xA9,0x66,0x5E,0xB4,0x65,0xD9,0x39,0x06,0xFC,0x9A,
        0x98,0x0F,0xC3,0x48,0xA1,0xF8,0xF0,0xC0,0xDB,0x1A,0xB3,0x85,0x87,0x9F,0xBF,0x25,
        0x58,0x50,0x03,0xF2,0x6A,0x39,0x45,0x8D,0x87,0x12,0x92,0x88,0xF1,0xAD,0x40,0xC2,
        0x61,0xFA,0x3A,0x58,0x23,0x05,0xDF,0xAC,0x04,0x3F,0x29,0xED,0xFD,0x23,0xDE,0xBE,
        0xF5,0x40,0x81,0xE9,0x02,0x09,0x2F,0x5E,0xCA,0x35,0xC1,0x8F,0x66,0x68,0xCF,0x2D,
        0xDA,0xF1,0x24,0x8C,0x65,0x67,0x01,0x52,0x70,0x57,0xEE,0x2B,0x10,0x58,0x90,0x63,
        0x33,0xD3,0x93,0xB0,0x2C,0x56,0xBF,0x58,0xCB,0xDB,0x8E,0xEE,0x44,0x50,0x45,0x9C,
        0x6F,0xFB,0x12,0x0B,0xFF,0x52,0x59,0x8E,0x3E,0x2E,0x79,0xAB,0x1A,0x04,0x4E,0x71,
        0xA4,0x5D,0x5B,0x93,0xD4,0x1E,0x01,0x83,0x32,0xCC,0xC1,0x89,0xD8,0x13,0x0D,0x20,
        0x11,0x51,0xBB,0x15,0x45,0x84,0x64,0xE0,0x7A,0x05,0x71,0xFD,0xDD,0x13,0x3D,0xC6,
        0x8D,0x1C,0x49,0xE7,0xF4,0xB2,0xC8,0x50,0xF9,0x8F,0xD9,0x33,0x91,0xD0,0xB5,0x2B,
        0x20,0x59,0x99,0xC9,0x49,0x39,0x2C,0x20,0xF9,0x7A,0x19,0xCE,0xAC,0x03,0xA6,0x1E,
        0x8F,0xFA,0xFB,0xBB,0xC9,0x26,0x2B,0x5F,0x89,0x6A,0x1B,0xB6,0xAB,0x30,0x4F,0xA9,
        0x4F,0x46,0xDD,0x84,0x79,0x74,0x7D,0x54,0xEF,0x29,0xEE,0x7A,0x99,0xF9,0xA3,0xF6,
        0xE9,0xBA,0xA4,0x96,0xD4,0xF9,0x61,0xF9,0x2D,0x3A,0x3F,0xDE,0x1D,0x76,0x75,0xC8,
        0x2B,0x6F,0x7F,0x66,0x26,0x21,0xA4,0x1B,0x7D,0xA7,0xCB,0xA0,0x38,0xB0,0xC6,0x90,
        0xC6,0x25,0xCC,0xF0,0x8C,0xB9,0xD5,0x56,0xE4,0xE3,0x56,0x3F,0x34,0x9F,0x36,0x79,
        0xB3,0x26,0x4F,0x29,0x7A,0x3D,0xD0,0xC7,0x15,0x89,0x18,0x2C,0x2E,0xC0,0xC1,0x7C,
        0x74,0xAE,0x17,0xF8,0xA9,0x84,0x3B,0x71,0x99,0x29,0x81,0x42,0xCA,0x65,0xE6,0xDE,
        0x71,0x52,0xEC,0x12,0x61,0x9C,0x16,0x89,0x55,0x04,0xDA,0x03,0xA0,0xA8,0x27,0x23,
        0x22,0xD9,0xCB,0x85,0x87,0x3D,0xCF,0x2F,0xEA,0xDD,0x90,0x51,0xBB,0x8D,0xFD,0xB0,
        0xA2,0x3A,0xBB,0xDB,0xD4,0xAF,0x1B,0xD7,0x98,0x8D,0xA3,0xA4,0xAA,0x38,0xD1,0xF1,
        0x01,0x5D,0x20,0xF0,0x9A,0x60,0x56,0x33,0x83,0xBD,0x27,0x84,0x0C,0xC5,0xCD,0xC7,
        0x07,0x2A,0x60,0x65,0xEC,0x4C,0x4F,0x72,0xBE,0xF3,0xED,0xF9,0x99,0x2A,0x84,0xB2,
        0x0B,0x9F,0x50,0x5E,0x6D,0x0C,0x15,0x42,0xE4,0x88,0x57,0x16,0x87,0x96,0xCB,0xD3,
        0xC0,0xDC,0x9D,0x7F,0xD7,0x6C,0x04,0xB4,0x0E,0xAD,0x31,0xA7,0x73,0x5C,0x9A,0x59,
        0x38,0x74,0x79,0x6D,0x75,0x6F,0x5A,0xFA,0x15,0x1D,0x81,0x64,0xF4,0x38,0xEA,0x28,
        0x27,0x1A,0x39,0xBD,0x8D,0x05,0xDA,0x9F,0x9A,0x9B,0x50,0xBF,0xDB,0x6E,0xCF,0x88,
        0xEE,0xFE,0xDE,0x12,0x1D,0x5E,0x5E,0x51,0x82,0xA2,0x6A,0xB9,0xEB,0xA0,0xBF,0xD5,
        0xC2,0x09,0x7F,0x58,0x22,0xDD,0xCB,0x33,0x9A,0xD9,0xD2,0xD9,0x1E,0x9A,0x1F,0xA6,
        0x4E,0xF9,0x76,0xF5,0x5A,0xD7,0x0A,0xC9,0xBC,0xE7,0x3A,0xEA,0x9A,0x21,0xB4,0xFA,
        0xDC,0x7B,0xFC,0xD1,0xEF,0x76,0x65,0x11,0x32,0xAA,0x78,0x43,0x8C,0x84,0x32,0xE8,
        0x82,0xC3,0x6B,0xF2,0x2A,0xC9,0x7A,0xEA,0xFE,0xB5,0x9C,0x3B,0xA2,0xE1,0x99,0x79,
        0x25,0xD8,0xFD,0xA3,0x9D,0x4E,0xB7,0xD7,0x93,0x65,0xC2,0xB0,0x5F,0xC6,0x3D,0x37,
        0xB4,0x52,0x67,0xD6,0xB5,0xC2,0xD0,0x12,0x00,0x11,0xD2,0x39,0xDA,0x29,0x6E,0x51,
        0x11,0xFF,0x1E,0xB3,0x87,0x8F,0x4A,0x34,0x0C,0x93,0x5E,0xC5,0x06,0xCA,0x8B,0x37,
        0x78,0x65,0x86,0x4F,0x79,0xC2,0xC3,0x63,0x07,0xEB,0xA2,0x8B,0x7B,0x7E,0xFD,0x69,
        0xF6,0x71,0x9E,0x5F,0xA8,0x89,0xB0,0x25,0x07,0x33,0xCA,0x22,0x63,0x0B,0x0B,0x36,
        0x86,0x9A,0xC0,0x74,0xA3,0x1E,0xD7,0x4F,0x3C,0xBB,0xAB,0x9C,0xEC,0xBF,0xB8,0x8D,
        0x95,0xF4,0xCE,0x95,0x2B,0x2C,0x8F,0xEF,0xB4,0x60,0x48,0x46,0xF7,0xA0,0xFF,0xFC,
        0xDF,0x6C,0x05,0xE0,0xBD,0x88,0xC6,0xD7,0x99,0x4F,0x22,0xED,0xDD,0x13,0x38,0x48,
        0x7A,0x3C,0x8D,0x6F,0x3C,0x76,0x0B,0x59,0x0B,0xD1,0xBF,0x43,0xD6,0x91,0x57,0x9B,
        0xBC,0xAF,0xBC,0x80,0xB9,0xD8,0xCF,0x0C,0x2D,0xF7,0xFB,0xDB,0x09,0xA2,0x12,0xA1,
        0x27,0xFF,0xCC,0xBB,0x13,0x8F,0xC0,0x69,0x61,0xAB,0xD5,0xEC,0xC8,0x83,0x00,0x08,
        0xF8,0x87,0x31,0x2E,0x57,0xB8,0x8E,0xA2,0x6C,0x80,0x41,0x45,0x7A,0x2F,0x50,0x69,
        0xBE,0x1E,0x1B,0xD7,0xC5,0x9C,0x88,0x2C,0xEE,0x53,0x1F,0x0E,0x03,0xE2,0x43,0xAA,
        0xF6,0xF2,0xE3,0x82,0x71,0xE3,0x4A,0x6F,0x70,0x2A,0x4E,0x92,0x4D,0x7B,0xEE,0x31,
        0x5B,0x6B,0x2D,0xAA,0x67,0x29,0x43,0x5C,0xFE,0x04,0x3F,0x03,0x98,0x80,0x9E,0x8A,
        0x3D,0x96,0x4E,0x88,0x4B,0xCE,0xF7,0xDB,0xD4,0xAB,0x66,0x9B,0x4E,0xF5,0xDF,0x73,
        0x64,0xED,0xB3,0x97,0xB4,0x99,0x43,0xCC,0xAF,0x87,0x83,0x6D,0xA4,0x46,0xD6,0xF0,
        0x8B,0xC4,0x55,0xB6,0x2C,0x66,0xE6,0x8C,0x74,0x52,0xD5,0xBC,0xC3,0xA8,0x0E,0x09,
        0x25,0xCC,0x9F,0xAA,0xCC,0x07,0xD5,0xA3,0x53,0x82,0xD8,0xC3,0x4A,0x8A,0x37,0x8E,
        0xD4,0x76,0x0F,0x89,0x9F,0x28,0x46,0xFD,0x07,0x26,0x23,0x62,0xC4,0x86,0x09,0x06,
        0x79,0x7A,0x47,0xD7,0xA6,0x2B,0x23,0x83,0xEF,0xB2,0x62,0xAA,0x8D,0x22,0x42,0xE9,
        0x1B,0x46,0xE7,0x4D,0x98,0x84,0x69,0xFC,0x85,0xA1,0xA3,0xA6,0xE4,0x72,0xDF,0xCC,
        0x78,0xD2,0x4A,0xCF,0x43,0x5F,0xE8,0xA8,0x52,0x8B,0x9A,0xED,0xC5,0x9C,0x70,0xE5,
        0xE3,0x3A,0x46,0x7D,0x9F,0xBC,0x6E,0xF5,0x11,0x4B,0x51,0x04,0x88,0x7D,0x9F,0x7C,
        0xD2,0x96,0x31,0xBB,0xD8,0x72,0xA6,0xBC,0x5E,0x3E,0xFA,0x0C,0xE9,0x7B,0x37,0xE9,
        0x31,0xBE,0xC2,0xA9,0x2C,0x62,0x2D,0xBC,0x64,0x54,0xBE,0xF7,0x0D,0xE3,0x20,0xD5,
        0xEC,0x1E,0x1A,0x2F,0x6A,0xB4,0x0C,0x71,0x93,0x89,0x1E,0x60,0xC1,0x61,0x0C,0x95,
        0x13,0x68,0xD3,0xCA,0xBA,0xF5,0x4F,0x70,0x68,0x75,0x57,0x83,0xB4,0xAE,0xAF,0x7B,
        0x1E,0x25,0x20,0xCA,0x61,0x07,0x7F,0x7C,0xB1,0x51,0x16,0xA2,0x43,0xCC,0xFA,0x02,
        0x48,0x29,0xE4,0xA5,0x0F,0x56,0x1A,0xF6,0xCF,0xAA,0xC6,0xF4,0x5D,0x89,0xBC,0xE5,
        0xDA,0xA3,0x42,0x9C,0x41,0x41,0x34,0x0C,0xE8,0x56,0x18,0x69,0xDF,0xAC,0x2C,0x9C,
        0x7A,0x54,0x3A,0x8A,0xCA,0x0A,0x6B,0xC8,0x0A,0x29,0xFB,0xB6,0x41,0x8A,0x1F,0x27,
        0x94,0x30,0xC8,0xA0,0x8A,0x5E,0xC1,0x07,0xF4,0xD8,0xBC,0xB9,0x3D,0xB1,0x16,0x22,
        0x7D,0x2A,0x7A,0x08,0x4E,0x31,0x1B,0xD0,0x37,0x79,0x92,0x17,0x45,0x7D,0xCA,0x5E,
        0x37,0xF0,0xD4,0xAF,0xE4,0x8C,0x11,0x1B,0x93,0x33,0x95,0xF2,0x4D,0xB2,0x8B,0x58,
        0x13,0xD9,0x38,0x17,0x10,0x16,0xD9,0x62,0x14,0xF7,0x69,0x10,0xCC,0xAA,0xC1,0x77,
        0x0D,0x5E,0x81,0x4C,0xDD,0x67,0x3E,0xF1,0x18,0x5E,0x75,0x1B,0x9B,0x29,0x82,0x85,
        0xEE,0x39,0x03,0x6C,0x44,0xB3,0x4D,0x20,0x17,0x71,0x9A,0xEC,0x22,0x00,0x4F,0xE8,
        0x71,0x1E,0xE4,0xEF,0x30,0x3E,0x7A,0xAB,0x9A,0x47,0xFF,0xB1,0xA0,0xBD,0xC6,0xEA,
        0x74,0xE4,0x22,0x92,0xA6,0x55,0x32,0x5A,0x10,0x61,0x34,0x6B,0xCC,0x51,0xCE,0x17,
        0x0E,0x8D,0xAA,0x7D,0x44,0x93,0x54,0xAF,0xBE,0x57,0xD1,0xFD,0xB4,0x9C,0x80,0x5A,
        0xAA,0xAF,0x77,0x3E,0xDE,0xBC,0x41,0x1B,0xEC,0x8A,0xDF,0xCF,0x09,0x0E,0xDF,0x49,
        0x78,0xE7,0xA2,0x13,0x13,0x49,0xA5,0xE1,0x8F,0x73,0xD4,0x4E,0x83,0x34,0xA5,0x74,
        0xE0,0xDA,0xC1,0x1C,0xD9,0x90,0x39,0x52,0x4B,0x8E,0x91,0xBA,0xB4,0x85,0xA5,0xAF,
        0x78,0x88,0x85,0xCC,0xF9,0x6C,0x47,0x61,0x09,0x96,0xAF,0x6B,0xE8,0xF3,0x98,0xB7,
        0xE4,0x6B,0xEE,0x2F,0x4D,0xC3,0x6F,0xE7,0xAE,0x50,0xC8,0x84,0xB8,0xEB,0x2D,0x0A,
        0xCD,0x24,0xD6,0xFB,0xAF,0xD9,0x7A,0x74,0x93,0x5F,0x12,0x43,0xE1,0xCD,0x69,0x57},
        {0},
        /*TST_dataSize*/
        1536*sizeof(DxUint8_t),
        /*TST_Expected_CMAC*/
		{0xF6,0x95,0x6A,0x14,0xE4,0x19,0x18,0x6B,0x88,0x03,0x9F,0xE6,0x76,0x4B,0x8D,0x5A},
        CRYS_AES_CMAC_mode
    },
    #endif
    #endif
};


#if TST_USE_PREDEFINED_SECRETKEY_TESTS
/***************************/
/************** Secret Key Vectors  ********/
/***************************/

/* Based on fixed secret key - DO NOT CHANGE    
HW -
---- 
AES_KEY_0, 32'h16157e2b
AES_KEY_1, 32'ha6d2ae28
AES_KEY_2, 32'h8815f7ab
AES_KEY_3, 32'h3c4fcf09

SW - 
----
0x2b,0x7e,0x15,0x16,0x28,0xae,0xd2,0xa6,0xab,0xf7,0x15,0x88,0x09,0xcf,0x4f,0x3c */
#if !(TST_USE_AES_16BYTE_DATA|TST_USE_AES_32BYTE_DATA|TST_USE_AES_512BYTE_DATA)
TST_AES_SecreteKeyTestDataStruct TST_AES_Acceptance_SK_TestData[] = {0};
#else
TST_AES_SecreteKeyTestDataStruct TST_AES_Acceptance_SK_TestData[] =
{
        /************/
        /*        AES ECB vectors         */
        /************/
    #if TST_USE_AES_16BYTE_DATA
    { 
        {"Acceptance test - AES/ECB/SecretKey/16ByteData "},
        /*TST_IvCounter*/
        {0},
        /*TST_input_data*/
        {0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a},
        {0},
        /*TST_Expected_output_data for enc Input data for decrypt*/
        {0x3a,0xd7,0x7b,0xb4,0x0d,0x7a,0x36,0x60,0xa8,0x9e,0xca,0xf3,0x24,0x66,0xef,0x97}, 
        /*TST_dataSize*/
        16*sizeof(DxUint8_t),       
        CRYS_AES_ECB_mode
    },
    #endif
    #if TST_USE_AES_32BYTE_DATA
    { 
        {"Acceptance test - AES/ECB/SecretKey/32ByteData/Encrypt"},
        /*TST_IvCounter*/       
        {0},
        /*TST_input_data*/
        {0x30,0xc8,0x1c,0x46,0xa3,0x5c,0xe4,0x11,0xe5,0xfb,0xc1,0x19,0x1a,0x0a,0x52,0xef,
         0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a},
        {0},
        /*TST_Expected_output_data for enc Input data for decrypt*/
        {0x43,0xb1,0xcd,0x7f,0x59,0x8e,0xce,0x23,0x88,0x1b,0x00,0xe3,0xed,0x03,0x06,0x88,
         0x3a,0xd7,0x7b,0xb4,0x0d,0x7a,0x36,0x60,0xa8,0x9e,0xca,0xf3,0x24,0x66,0xef,0x97}, 
        /*TST_dataSize*/
        32*sizeof(DxUint8_t),
        CRYS_AES_ECB_mode
    },
    #endif
    #if TST_USE_AES_512BYTE_DATA
    {
        {"Acceptance test - AES/ECB/SecretKey/512ByteData/Encrypt"},
        /*TST_IvCounter*/       
        {0},
        /*TST_input_data*/
        {0x30,0xc8,0x1c,0x46,0xa3,0x5c,0xe4,0x11,0xe5,0xfb,0xc1,0x19,0x1a,0x0a,0x52,0xef,
         0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a,
         0x3a,0xd7,0x7b,0xb4,0x0d,0x7a,0x36,0x60,0xa8,0x9e,0xca,0xf3,0x24,0x66,0xef,0x97,
         0xf5,0xd3,0xd5,0x85,0x03,0xb9,0x69,0x9d,0xe7,0x85,0x89,0x5a,0x96,0xfd,0xba,0xaf,
         0x43,0xb1,0xcd,0x7f,0x59,0x8e,0xce,0x23,0x88,0x1b,0x00,0xe3,0xed,0x03,0x06,0x88,
         0x7b,0x0c,0x78,0x5e,0x27,0xe8,0xad,0x3f,0x82,0x23,0x20,0x71,0x04,0x72,0x5d,0xd4,
         0x3a,0xd7,0x7b,0xb4,0x0d,0x7a,0x36,0x60,0xa8,0x9e,0xca,0xf3,0x24,0x66,0xef,0x97,
         0xf5,0xd3,0xd5,0x85,0x03,0xb9,0x69,0x9d,0xe7,0x85,0x89,0x5a,0x96,0xfd,0xba,0xaf,
         0x30,0xc8,0x1c,0x46,0xa3,0x5c,0xe4,0x11,0xe5,0xfb,0xc1,0x19,0x1a,0x0a,0x52,0xef,
         0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a,
         0x3a,0xd7,0x7b,0xb4,0x0d,0x7a,0x36,0x60,0xa8,0x9e,0xca,0xf3,0x24,0x66,0xef,0x97,
         0xf5,0xd3,0xd5,0x85,0x03,0xb9,0x69,0x9d,0xe7,0x85,0x89,0x5a,0x96,0xfd,0xba,0xaf,
         0x43,0xb1,0xcd,0x7f,0x59,0x8e,0xce,0x23,0x88,0x1b,0x00,0xe3,0xed,0x03,0x06,0x88,
         0x7b,0x0c,0x78,0x5e,0x27,0xe8,0xad,0x3f,0x82,0x23,0x20,0x71,0x04,0x72,0x5d,0xd4,
         0x3a,0xd7,0x7b,0xb4,0x0d,0x7a,0x36,0x60,0xa8,0x9e,0xca,0xf3,0x24,0x66,0xef,0x97,
         0xf5,0xd3,0xd5,0x85,0x03,0xb9,0x69,0x9d,0xe7,0x85,0x89,0x5a,0x96,0xfd,0xba,0xaf,
         0x30,0xc8,0x1c,0x46,0xa3,0x5c,0xe4,0x11,0xe5,0xfb,0xc1,0x19,0x1a,0x0a,0x52,0xef,
         0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a,
         0x3a,0xd7,0x7b,0xb4,0x0d,0x7a,0x36,0x60,0xa8,0x9e,0xca,0xf3,0x24,0x66,0xef,0x97,
         0xf5,0xd3,0xd5,0x85,0x03,0xb9,0x69,0x9d,0xe7,0x85,0x89,0x5a,0x96,0xfd,0xba,0xaf,
         0x43,0xb1,0xcd,0x7f,0x59,0x8e,0xce,0x23,0x88,0x1b,0x00,0xe3,0xed,0x03,0x06,0x88,
         0x7b,0x0c,0x78,0x5e,0x27,0xe8,0xad,0x3f,0x82,0x23,0x20,0x71,0x04,0x72,0x5d,0xd4,
         0x3a,0xd7,0x7b,0xb4,0x0d,0x7a,0x36,0x60,0xa8,0x9e,0xca,0xf3,0x24,0x66,0xef,0x97,
         0xf5,0xd3,0xd5,0x85,0x03,0xb9,0x69,0x9d,0xe7,0x85,0x89,0x5a,0x96,0xfd,0xba,0xaf,
         0x30,0xc8,0x1c,0x46,0xa3,0x5c,0xe4,0x11,0xe5,0xfb,0xc1,0x19,0x1a,0x0a,0x52,0xef,
         0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a,
         0x3a,0xd7,0x7b,0xb4,0x0d,0x7a,0x36,0x60,0xa8,0x9e,0xca,0xf3,0x24,0x66,0xef,0x97,
         0xf5,0xd3,0xd5,0x85,0x03,0xb9,0x69,0x9d,0xe7,0x85,0x89,0x5a,0x96,0xfd,0xba,0xaf,
         0x43,0xb1,0xcd,0x7f,0x59,0x8e,0xce,0x23,0x88,0x1b,0x00,0xe3,0xed,0x03,0x06,0x88,
         0x7b,0x0c,0x78,0x5e,0x27,0xe8,0xad,0x3f,0x82,0x23,0x20,0x71,0x04,0x72,0x5d,0xd4,
         0x3a,0xd7,0x7b,0xb4,0x0d,0x7a,0x36,0x60,0xa8,0x9e,0xca,0xf3,0x24,0x66,0xef,0x97,
         0xf5,0xd3,0xd5,0x85,0x03,0xb9,0x69,0x9d,0xe7,0x85,0x89,0x5a,0x96,0xfd,0xba,0xaf},
        {0},
        /*TST_Expected_output_data for enc Input data for decrypt*/
        {0x43,0xb1,0xcd,0x7f,0x59,0x8e,0xce,0x23,0x88,0x1b,0x00,0xe3,0xed,0x03,0x06,0x88,
         0x3a,0xd7,0x7b,0xb4,0x0d,0x7a,0x36,0x60,0xa8,0x9e,0xca,0xf3,0x24,0x66,0xef,0x97,
         0x22,0x49,0xa2,0x63,0x8c,0x6f,0x1c,0x75,0x5a,0x84,0xf9,0x68,0x1a,0x9f,0x08,0xc1,
         0x49,0xcd,0x73,0x53,0x79,0x3e,0x29,0xb7,0x80,0xd8,0x08,0xa6,0x47,0x0c,0xe4,0xc9,
         0xa4,0x48,0x71,0x4d,0x43,0x81,0xdb,0x0f,0xbe,0x95,0x33,0xba,0x7e,0x56,0x7e,0xed,
         0xa0,0x31,0xd3,0x9b,0xcf,0x99,0x16,0xfc,0x6a,0x3f,0x93,0xc7,0x21,0xbf,0xee,0x26,
         0x22,0x49,0xa2,0x63,0x8c,0x6f,0x1c,0x75,0x5a,0x84,0xf9,0x68,0x1a,0x9f,0x08,0xc1,
         0x49,0xcd,0x73,0x53,0x79,0x3e,0x29,0xb7,0x80,0xd8,0x08,0xa6,0x47,0x0c,0xe4,0xc9,
         0x43,0xb1,0xcd,0x7f,0x59,0x8e,0xce,0x23,0x88,0x1b,0x00,0xe3,0xed,0x03,0x06,0x88,
         0x3a,0xd7,0x7b,0xb4,0x0d,0x7a,0x36,0x60,0xa8,0x9e,0xca,0xf3,0x24,0x66,0xef,0x97,
         0x22,0x49,0xa2,0x63,0x8c,0x6f,0x1c,0x75,0x5a,0x84,0xf9,0x68,0x1a,0x9f,0x08,0xc1,
         0x49,0xcd,0x73,0x53,0x79,0x3e,0x29,0xb7,0x80,0xd8,0x08,0xa6,0x47,0x0c,0xe4,0xc9,
         0xa4,0x48,0x71,0x4d,0x43,0x81,0xdb,0x0f,0xbe,0x95,0x33,0xba,0x7e,0x56,0x7e,0xed,
         0xa0,0x31,0xd3,0x9b,0xcf,0x99,0x16,0xfc,0x6a,0x3f,0x93,0xc7,0x21,0xbf,0xee,0x26,
         0x22,0x49,0xa2,0x63,0x8c,0x6f,0x1c,0x75,0x5a,0x84,0xf9,0x68,0x1a,0x9f,0x08,0xc1,
         0x49,0xcd,0x73,0x53,0x79,0x3e,0x29,0xb7,0x80,0xd8,0x08,0xa6,0x47,0x0c,0xe4,0xc9,
         0x43,0xb1,0xcd,0x7f,0x59,0x8e,0xce,0x23,0x88,0x1b,0x00,0xe3,0xed,0x03,0x06,0x88,
         0x3a,0xd7,0x7b,0xb4,0x0d,0x7a,0x36,0x60,0xa8,0x9e,0xca,0xf3,0x24,0x66,0xef,0x97,
         0x22,0x49,0xa2,0x63,0x8c,0x6f,0x1c,0x75,0x5a,0x84,0xf9,0x68,0x1a,0x9f,0x08,0xc1,
         0x49,0xcd,0x73,0x53,0x79,0x3e,0x29,0xb7,0x80,0xd8,0x08,0xa6,0x47,0x0c,0xe4,0xc9,
         0xa4,0x48,0x71,0x4d,0x43,0x81,0xdb,0x0f,0xbe,0x95,0x33,0xba,0x7e,0x56,0x7e,0xed,
         0xa0,0x31,0xd3,0x9b,0xcf,0x99,0x16,0xfc,0x6a,0x3f,0x93,0xc7,0x21,0xbf,0xee,0x26,
         0x22,0x49,0xa2,0x63,0x8c,0x6f,0x1c,0x75,0x5a,0x84,0xf9,0x68,0x1a,0x9f,0x08,0xc1,
         0x49,0xcd,0x73,0x53,0x79,0x3e,0x29,0xb7,0x80,0xd8,0x08,0xa6,0x47,0x0c,0xe4,0xc9,
         0x43,0xb1,0xcd,0x7f,0x59,0x8e,0xce,0x23,0x88,0x1b,0x00,0xe3,0xed,0x03,0x06,0x88,
         0x3a,0xd7,0x7b,0xb4,0x0d,0x7a,0x36,0x60,0xa8,0x9e,0xca,0xf3,0x24,0x66,0xef,0x97,
         0x22,0x49,0xa2,0x63,0x8c,0x6f,0x1c,0x75,0x5a,0x84,0xf9,0x68,0x1a,0x9f,0x08,0xc1,
         0x49,0xcd,0x73,0x53,0x79,0x3e,0x29,0xb7,0x80,0xd8,0x08,0xa6,0x47,0x0c,0xe4,0xc9,
         0xa4,0x48,0x71,0x4d,0x43,0x81,0xdb,0x0f,0xbe,0x95,0x33,0xba,0x7e,0x56,0x7e,0xed,
         0xa0,0x31,0xd3,0x9b,0xcf,0x99,0x16,0xfc,0x6a,0x3f,0x93,0xc7,0x21,0xbf,0xee,0x26,
         0x22,0x49,0xa2,0x63,0x8c,0x6f,0x1c,0x75,0x5a,0x84,0xf9,0x68,0x1a,0x9f,0x08,0xc1,
         0x49,0xcd,0x73,0x53,0x79,0x3e,0x29,0xb7,0x80,0xd8,0x08,0xa6,0x47,0x0c,0xe4,0xc9}, 
        /*TST_dataSize*/
        512*sizeof(DxUint8_t),
        CRYS_AES_ECB_mode
    },
    #endif
    #if TST_USE_AES_1536BYTE_DATA
    { 
        {"Acceptance test - AES/ECB/SecretKey/1536ByteData/Encrypt"},
        /*TST_IvCounter*/       
        {0},
        /*TST_input_data*/
        {0x67,0xCF,0x90,0xD1,0x29,0xF7,0xAF,0x76,0x74,0x93,0xBE,0x2D,0xF2,0x36,0x1C,0x81,
        0x0B,0x64,0xAB,0xF5,0x1C,0x6A,0x49,0x8C,0xE2,0x2A,0x9B,0x95,0x51,0xFF,0x5E,0x17,
        0xDD,0xA8,0x79,0x4F,0x0C,0xBB,0x9E,0x65,0xF0,0x69,0x00,0x0F,0x57,0xE8,0x5D,0x77,
        0xE1,0x4F,0x32,0x64,0x9B,0x68,0x9D,0xFC,0x86,0x03,0xEE,0xFF,0x5C,0x19,0x25,0x75,
        0x35,0xA6,0x50,0x49,0xBD,0xCD,0x75,0x4F,0xC5,0x46,0x05,0xB2,0x6A,0x3A,0x35,0xFA,
        0xCC,0x23,0xB4,0x02,0xCC,0xFA,0x7C,0x75,0x0A,0x7C,0xC9,0x09,0xCC,0x9F,0x08,0xD7,
        0x44,0x8A,0xD9,0xB0,0x98,0x13,0xBA,0x13,0xD9,0xE2,0x9E,0x55,0x63,0xEA,0x92,0x4B,
        0xCE,0xF4,0x32,0x39,0x64,0x22,0xA8,0x3A,0x2A,0xDB,0x3E,0x40,0x04,0x6C,0x83,0x26,
        0x3D,0x2D,0x6E,0xDF,0x60,0x84,0x61,0xB8,0x69,0xA1,0x28,0xEA,0x5B,0x26,0x12,0x20,
        0xEA,0x7D,0x3B,0xD7,0x6C,0xCF,0x72,0x22,0xE2,0x9F,0x86,0xBD,0xD4,0x7A,0x0F,0x6D,
        0x5F,0x78,0x18,0x35,0x7C,0xB2,0xEB,0x49,0x93,0x79,0xCF,0xC3,0xF9,0xBE,0xDE,0x03,
        0xC9,0x1E,0x55,0x87,0x31,0xAB,0xB9,0x6D,0xBB,0x4B,0xFD,0xC1,0xFE,0xA4,0xE3,0xEE,
        0x91,0xBB,0x8A,0xE3,0x0E,0xDD,0xA3,0x38,0x91,0xF1,0x44,0xF2,0xFF,0xAF,0x28,0x23,
        0xC0,0x82,0xF3,0xB5,0x24,0x87,0x3C,0xB3,0xBF,0xAA,0x7A,0x30,0xB4,0x2A,0x4B,0xEE,
        0x96,0xE1,0x31,0x3E,0x33,0xFB,0xF5,0xEC,0x7B,0x1D,0xF5,0x3F,0x67,0xC6,0x6D,0x0B,
        0x23,0xDA,0x01,0x7B,0xB0,0x2E,0xC9,0x0A,0x7F,0xD6,0x24,0x64,0x62,0x72,0x83,0x67,
        0xA5,0x56,0x5C,0x1E,0x7D,0xEA,0xF0,0xC4,0x8C,0x07,0x3A,0x07,0x91,0xFC,0x4C,0xF8,
        0x3C,0x6E,0x0D,0xDA,0x28,0xCF,0x3D,0x68,0x17,0x27,0xBE,0x5C,0xD7,0x91,0x89,0x09,
        0x99,0x8E,0x9A,0x10,0x69,0x4F,0x8E,0x38,0xEA,0x3C,0xEE,0xA8,0xF3,0xC2,0x78,0x83,
        0x8A,0x2B,0x27,0xF4,0x64,0xA8,0x3E,0xD6,0x18,0xF4,0x07,0x56,0x2B,0x93,0xED,0xFB,
        0x7E,0x31,0x6D,0x03,0x62,0x3B,0x8E,0xED,0xE0,0xD4,0xF0,0xEC,0xE0,0x95,0x74,0x54,
        0xAE,0x3B,0xD2,0xAB,0x6A,0x94,0xA4,0xF0,0x4F,0xC3,0xF8,0x75,0x47,0x37,0x0C,0x56,
        0x4E,0xF3,0x29,0xC2,0x54,0x74,0x21,0x4E,0x9D,0x39,0x14,0x8F,0xB8,0x52,0xF5,0x83,
        0x80,0xB2,0xA7,0xF0,0xC0,0x42,0x91,0xEA,0x8C,0x7C,0xB4,0x9E,0x43,0x19,0xA5,0xA8,
        0xC7,0x99,0x9D,0xED,0x6B,0xB1,0x00,0x3A,0x19,0x84,0x0D,0x30,0x7F,0x14,0x38,0xFD,
        0xCE,0x75,0xF4,0x95,0x90,0x1B,0x95,0x0C,0x61,0x3F,0x36,0xD7,0xBF,0x83,0x0A,0x83,
        0x93,0x6C,0xC7,0x1F,0xB4,0x08,0x18,0xCE,0xB2,0x6D,0xD7,0x3C,0x34,0x61,0x6A,0x77,
        0x44,0xB7,0xD0,0xCE,0x24,0x10,0x18,0xAC,0x03,0x91,0x8B,0x2B,0x7B,0x28,0x7A,0x96,
        0x79,0x8A,0x9C,0x13,0x4C,0x19,0x48,0xC5,0x5C,0x25,0xE3,0x22,0x44,0x59,0xD7,0x00,
        0xD5,0xBE,0x93,0x08,0xB3,0x3C,0x5E,0x83,0x53,0x1B,0x1B,0x23,0x7C,0xEC,0x53,0x8A,
        0xF2,0x40,0xC3,0xAA,0xC4,0x56,0x2B,0x2B,0x6E,0x0A,0x71,0xFE,0x2D,0xF5,0x67,0xAA,
        0xB9,0x8A,0x56,0xBD,0x94,0x71,0xE3,0x3C,0x2B,0x19,0xC0,0x30,0xFD,0x25,0x48,0x70,
        0xD2,0x59,0x30,0x03,0x95,0x2D,0x3C,0x7E,0x92,0x68,0x9A,0xA8,0xCB,0x5F,0x56,0x5D,
        0xB4,0x70,0x6A,0xF2,0x96,0x95,0xF5,0x80,0x5D,0x86,0x7E,0xAB,0x95,0xFA,0x2D,0x49,
        0xC1,0x01,0x2C,0xD4,0xC5,0x63,0x14,0x8B,0x4E,0xD7,0x2A,0x2C,0xD7,0x3A,0x71,0xCB,
        0xC2,0x62,0x7C,0x8C,0xBA,0x56,0xD9,0x3C,0x63,0xAF,0xA6,0x0E,0xAE,0x90,0xE8,0x98,
        0x3A,0x51,0xE7,0xCA,0x33,0x82,0x98,0x50,0x5C,0xDE,0xA3,0xBE,0x6B,0xC8,0xA9,0x22,
        0x15,0xB3,0xE8,0x33,0x7E,0xA0,0x8E,0x6A,0x27,0xEF,0x70,0x16,0xBD,0x05,0xDC,0xBE,
        0xEF,0x92,0xF2,0x86,0x53,0xA6,0x97,0x40,0xCA,0x2B,0x30,0xDC,0xB3,0x1B,0xD1,0x9B,
        0x05,0x83,0xF9,0xFB,0xA8,0xB5,0x1A,0x9A,0xC2,0x7C,0xA3,0x44,0x12,0x82,0x93,0x56,
        0x01,0xE4,0xCF,0xD8,0xD6,0x23,0xCF,0x6E,0x1B,0xA7,0x69,0x52,0x6F,0xB1,0xB7,0x0B,
        0x1D,0xD4,0x10,0x3A,0x0C,0xE1,0x16,0x39,0x78,0x57,0xC3,0xD6,0x03,0x53,0x2E,0x48,
        0x98,0xDA,0xDA,0xCE,0x4C,0xF8,0xC5,0xE2,0xB3,0x8A,0xE0,0x00,0x4C,0xC7,0x2A,0x11,
        0xC5,0x97,0x26,0x3D,0x71,0x59,0x4A,0x20,0xCE,0x95,0x60,0x7E,0x60,0xF8,0x6A,0xC7,
        0x79,0x20,0xBA,0x95,0xD6,0xE8,0xBF,0x25,0x0F,0x2E,0x86,0x81,0x01,0x15,0xED,0xB0,
        0x2D,0xB2,0x11,0x6C,0x2C,0xF1,0xD6,0x3E,0x8F,0xBA,0xFF,0xB6,0x97,0x46,0x81,0xBB,
        0x1F,0x18,0x87,0x2B,0x0C,0x94,0x3A,0xDC,0xD7,0x01,0x2E,0x42,0xD3,0xC8,0x1E,0xB9,
        0xA8,0xAF,0x51,0xAE,0xE6,0xFE,0x9A,0x88,0x49,0x7B,0x06,0x1C,0xE9,0x09,0x8D,0xC9,
        0xAC,0xCB,0x61,0xE8,0x8E,0xC1,0xA3,0x98,0x77,0x35,0x94,0x2B,0xC2,0x93,0x6B,0xC6,
        0x9B,0x46,0x0D,0xE8,0xF5,0xD3,0xD4,0x21,0x7D,0xFF,0xE1,0x91,0x8E,0x1D,0xF3,0xCE,
        0x74,0x64,0x96,0x08,0x66,0x35,0x2A,0xE6,0x0B,0xB8,0x36,0xB1,0x69,0x6F,0xC5,0xB5,
        0x0F,0x3F,0x80,0xA2,0xFB,0xA5,0xD3,0xD8,0xF6,0x40,0x6B,0x8F,0xE0,0x12,0x0A,0x59,
        0x42,0xC6,0xB7,0x5E,0xFD,0x63,0x5F,0x65,0x1B,0x27,0xDC,0x3C,0x9D,0x22,0xB7,0x0E,
        0x3A,0x2B,0x81,0x4F,0x9D,0x50,0xD2,0xCF,0x91,0xBD,0x11,0x26,0xCA,0x9B,0x06,0xF9,
        0xAD,0xDC,0x6F,0xA3,0xB7,0x67,0xB8,0xAC,0xDF,0x1A,0x86,0xD4,0xC9,0x96,0x3B,0xD4,
        0x88,0x5C,0x54,0xB4,0x91,0xBA,0xBC,0xF1,0xF3,0xE8,0xCC,0x40,0x52,0x39,0x9B,0x7F,
        0x20,0xE2,0x8F,0xC0,0xB2,0x14,0x56,0xD3,0x73,0xD4,0x70,0x82,0xC9,0xFE,0x05,0xFA,
        0x82,0x3D,0x9E,0x6D,0x47,0x51,0x67,0xF2,0x20,0x7E,0xB0,0xCF,0x9A,0x78,0x5A,0xA6,
        0x7F,0x07,0xB4,0xE6,0x07,0x7A,0x21,0x74,0x06,0x81,0x41,0xBC,0x4A,0x39,0x27,0xF5,
        0xE2,0xD2,0xBE,0x15,0x9B,0x2D,0x38,0xCE,0x7A,0x9C,0xA0,0x34,0x63,0x86,0x39,0xFB,
        0x7A,0xCA,0x03,0xC2,0x49,0x1F,0xF2,0x07,0x1B,0x29,0x67,0xC5,0x10,0xAB,0xA8,0xE6,
        0x56,0xBA,0xED,0xC7,0xBA,0x44,0x0B,0x52,0xCE,0xE5,0x6B,0x6B,0xDA,0xEC,0x10,0x7F,
        0x48,0x46,0x41,0x80,0x35,0x65,0xAB,0xC2,0xE0,0xB6,0xF9,0x71,0xC5,0x73,0xBE,0xCF,
        0xF3,0xB9,0xDE,0xA9,0x99,0x71,0x41,0x36,0xBF,0xB1,0xF4,0x64,0xB4,0x86,0x2D,0x2F,
        0x19,0xE7,0x7D,0xCA,0x6A,0x27,0xB1,0xF0,0x0F,0x2A,0xE7,0x03,0x4B,0x99,0x8C,0x5A,
        0x26,0x9C,0x77,0x20,0x0D,0x67,0xE6,0xD6,0x05,0x0B,0xC1,0x84,0x70,0x46,0x0E,0x59,
        0x89,0xCA,0x58,0xDE,0xF6,0xF4,0x65,0xCC,0x08,0xED,0x99,0x6E,0x8A,0x3D,0xEA,0x25,
        0x24,0x99,0x3D,0x18,0x0F,0x0C,0x21,0xB1,0x01,0xA6,0xC5,0x5E,0x65,0x2C,0x80,0xC8,
        0x1C,0x8D,0x7A,0x81,0x41,0xAE,0x64,0x32,0x36,0xAB,0x17,0x20,0xCD,0x78,0x4C,0xC7,
        0x20,0x9C,0x5F,0xD7,0x08,0xF5,0x4A,0x7C,0xA8,0xA6,0xDD,0x4F,0x2E,0x06,0x67,0xDC,
        0x6D,0xD0,0x51,0xFC,0xC3,0x69,0xE3,0x76,0x35,0x0A,0xE1,0x63,0xF5,0x00,0xE4,0x89,
        0x5A,0xFD,0x3D,0xC9,0xCC,0xA8,0xC0,0x26,0x43,0xFD,0xD8,0x9B,0xD0,0x14,0x04,0x30,
        0x44,0x3B,0xB2,0xFC,0x26,0x4F,0x03,0xB7,0xB8,0xE8,0xA2,0xFD,0x14,0xE6,0x87,0xA8,
        0xC2,0x54,0xF5,0x30,0xC8,0x9D,0x0F,0xC4,0x10,0x2A,0xB8,0xC6,0x91,0x48,0xA5,0x20,
        0x06,0xB1,0x1F,0xB9,0x4D,0xE7,0x62,0x0A,0xFA,0x86,0x10,0xE3,0x06,0xC2,0x12,0x5D,
        0x76,0x30,0xD9,0x7C,0x1F,0xD3,0x67,0xA6,0x2B,0xEE,0xEB,0xFB,0x96,0x3D,0x26,0x70,
        0x43,0x82,0xF6,0x63,0xC6,0xCD,0x5A,0xDB,0xF1,0xEB,0x36,0x41,0x8D,0x2B,0xBE,0x4E,
        0x18,0x5B,0x4F,0x60,0x6E,0x28,0x00,0x33,0x49,0x79,0x8D,0x5F,0xFB,0x67,0x73,0xBC,
        0x60,0x9F,0xA0,0x84,0xCB,0xAE,0x96,0xA8,0xD6,0xFE,0x8B,0x34,0x9C,0x25,0x19,0x00,
        0x2F,0x9D,0xE2,0x3B,0xED,0xC5,0x01,0x1A,0x81,0xC3,0x19,0x4C,0x40,0xFA,0xDF,0x8A,
        0x77,0x7A,0xE1,0xED,0x8B,0x39,0x83,0x69,0xC4,0xA7,0x8A,0x70,0x9D,0xCC,0x96,0x23,
        0x60,0x8D,0x2F,0x5D,0x84,0x38,0xCE,0x9B,0x9E,0x86,0x03,0x07,0x95,0x4A,0x68,0xDB,
        0x1E,0x01,0xBC,0x22,0x44,0x2C,0x75,0xF6,0x1A,0x79,0x76,0x46,0x3A,0x91,0x7C,0xB4,
        0x2C,0xF6,0xEC,0xB2,0xCA,0x81,0x05,0x3F,0xAB,0x45,0x4E,0x04,0x36,0x7B,0xD4,0x7A,
        0x3F,0xAF,0x52,0x9C,0x0F,0x74,0xDF,0x34,0x18,0x39,0x43,0x0B,0xC1,0x88,0x61,0x0D,
        0x0A,0x4E,0xDB,0x9F,0x5D,0xB5,0x11,0x9C,0xFB,0x7D,0x77,0xFE,0xDD,0x70,0xBF,0x9E,
        0xA4,0xFB,0x07,0x8A,0x3F,0xDF,0xA4,0xB8,0x16,0xB7,0x9A,0x90,0x3E,0xFA,0x7D,0x22,
        0xE4,0x41,0xFA,0xE7,0xA0,0x35,0x1C,0x89,0x9E,0xB5,0xA1,0x92,0xFC,0xE0,0x57,0xA7,
        0x7A,0xA5,0x66,0xC5,0x81,0xD6,0xCE,0x2A,0xAA,0x22,0x88,0xA5,0x1A,0x80,0x5E,0x00,
        0xFF,0x54,0x1A,0x9B,0x76,0xD8,0xFE,0x6F,0xDE,0x7D,0xEC,0x89,0x3E,0x11,0xBC,0x36,
        0x60,0xF3,0x16,0x98,0x93,0xB8,0xA1,0x0D,0x73,0xCF,0x3D,0x7D,0xAD,0x77,0x6E,0x1D,
        0x57,0xA1,0x93,0xA7,0xC5,0xBC,0x30,0xA2,0xA6,0xF7,0xE6,0x03,0xEA,0x44,0xEC,0x98,
        0x66,0x51,0x45,0x27,0x6A,0xC5,0x6C,0x46,0xB2,0x0D,0x27,0xA7,0x9A,0x80,0xC2,0x67,
        0x0E,0xCE,0x32,0x9C,0x7E,0x14,0x71,0xA4,0xC2,0x74,0xF1,0x9C,0xD1,0x9E,0x23,0x2F,
        0xE3,0xA4,0x17,0x5B,0x31,0x47,0xB3,0x91,0x34,0x4C,0xF5,0xB7,0x94,0x89,0x07,0x26,
        0x35,0x7E,0xF4,0x1B,0x12,0x4F,0x1A,0x52,0xE0,0xA0,0x65,0xF6,0xD3,0xCF,0x75,0x14},
        {0},
        /*TST_Expected_output_data for enc Input data for decrypt*/
        {0x32,0x11,0x1A,0x07,0xEF,0x9A,0x93,0x1E,0xE0,0x17,0x10,0x83,0x24,0xDD,0xCA,0x5F,
        0xAF,0x4A,0x97,0x54,0x4A,0x0B,0xF5,0xFF,0xDB,0x13,0x0F,0x23,0x57,0xE7,0xE6,0x2E,
        0x92,0xBE,0xB0,0x31,0x3F,0x37,0x9F,0xD7,0x3C,0x7E,0x36,0xF1,0x3B,0xD7,0xC9,0x91,
        0xBD,0xC8,0x51,0xD9,0x03,0xB3,0x78,0x27,0x60,0x9C,0xD5,0x96,0xCB,0x9A,0x24,0xCE,
        0x66,0x0D,0x9B,0xE7,0x54,0xBB,0xE4,0xEF,0xE0,0x41,0x1A,0x87,0x5C,0xB0,0x2F,0x54,
        0x2D,0x9F,0x7A,0x13,0x51,0x0D,0x7A,0xD9,0x54,0xBC,0x2D,0x1E,0x88,0x1E,0xFA,0x98,
        0x9A,0x6F,0x05,0x28,0xC3,0xA4,0x6E,0xDB,0x5D,0x5A,0xB9,0xB9,0x2C,0x8A,0x6A,0x7A,
        0xB6,0x3B,0x4E,0xB2,0xE8,0x19,0x10,0x13,0x39,0x8D,0xB2,0x8E,0x0E,0x7D,0xA0,0xF0,
        0x94,0x75,0x2C,0x29,0x77,0x16,0x27,0x38,0x3A,0x50,0x84,0xEC,0x54,0x54,0x8A,0x5C,
        0x2D,0xA9,0x8E,0x0E,0x2B,0x93,0x09,0x4D,0x91,0x41,0x93,0xA9,0x2C,0x5F,0xBA,0x57,
        0xCA,0x6B,0xC5,0x35,0x99,0xC8,0xF2,0x93,0x14,0xE6,0x32,0xCD,0x50,0xAC,0xBC,0x95,
        0x25,0x34,0x0A,0x1D,0xAC,0xBA,0x27,0x2C,0x34,0x75,0x6B,0x14,0xF5,0x89,0x65,0x22,
        0xF2,0x47,0xFA,0x83,0xF4,0x08,0xAB,0xAF,0xD6,0x54,0x41,0xE1,0xA5,0x8E,0x6B,0x16,
        0xA5,0x7F,0xF0,0x33,0x42,0xD9,0xDA,0x21,0xEC,0xB8,0x92,0x84,0x16,0xE9,0x07,0xCA,
        0x0A,0x3C,0x51,0xE1,0x9B,0x75,0x26,0x6E,0x24,0x46,0x4C,0x6D,0xDA,0xDE,0xDD,0x99,
        0x3B,0x02,0xB3,0x60,0x8C,0x74,0x83,0x6E,0x1B,0x23,0x54,0xFD,0xBB,0x1C,0xCD,0x39,
        0x21,0xE2,0x99,0x60,0x5D,0xA7,0x4B,0x57,0x02,0xD2,0x86,0x9F,0x80,0xBD,0xFC,0x58,
        0x1C,0x75,0xDD,0xF3,0x00,0x18,0x1E,0xC8,0x2D,0xF7,0xE1,0x36,0x9A,0x6A,0x83,0xE8,
        0x3F,0x00,0x7F,0xC2,0x82,0xA9,0xAC,0x37,0x8D,0xDE,0x70,0x0E,0xDA,0xA4,0xB1,0x54,
        0xEA,0x3D,0x2D,0xF5,0x57,0x5B,0x7C,0x70,0xBF,0x98,0x7B,0xAF,0x9D,0x1D,0x92,0xA3,
        0x53,0x46,0xCF,0x8C,0xAC,0x82,0x59,0xF5,0x86,0xC1,0x01,0xD7,0xA4,0x2B,0x77,0xB0,
        0x6E,0x1C,0x5D,0x9B,0x13,0x7B,0xDC,0x47,0xA6,0x46,0x4B,0x9E,0x32,0xE0,0x86,0x34,
        0xF8,0xE2,0xC6,0x9C,0x52,0xC2,0xC8,0x85,0x45,0x67,0xBC,0x45,0xF7,0x48,0x36,0x93,
        0x80,0x90,0x4E,0x60,0x44,0x4C,0x16,0xC4,0x41,0x1E,0x81,0x0F,0x63,0x79,0xE9,0xFB,
        0x70,0x3B,0x49,0xDF,0x07,0xF1,0x1B,0x68,0xBD,0x14,0x3B,0x90,0x63,0x5A,0x90,0xA1,
        0x2D,0x55,0x83,0x2B,0x09,0x8C,0x99,0x49,0x60,0xD1,0xD5,0xAC,0x79,0x99,0x3B,0x3C,
        0x37,0xA2,0x1A,0x9B,0xD9,0xE7,0xDE,0x3C,0x0C,0x93,0xD0,0x61,0x27,0x50,0x89,0xA0,
        0xAF,0x1C,0x30,0x7A,0x23,0x30,0x32,0x3C,0x95,0x94,0xF8,0xE5,0xAE,0xCE,0xD9,0xC2,
        0x21,0x18,0xA2,0x79,0x4A,0x98,0x4D,0x02,0x2A,0x17,0xBA,0x7B,0xDF,0x26,0x97,0xFD,
        0xE1,0xAA,0x0A,0xEA,0xCB,0xF2,0x2A,0x21,0xF0,0x9D,0xAA,0xB3,0x1F,0xC9,0x33,0xD8,
        0x2F,0x2B,0x2D,0xFF,0x73,0x4C,0x25,0x2F,0xC3,0xF2,0x17,0x73,0x64,0x88,0x1D,0x77,
        0xFC,0x39,0xC1,0x7C,0x65,0x87,0xAE,0x5E,0x99,0x78,0x3C,0x1E,0x35,0x4B,0x7C,0x55,
        0xBA,0x52,0xE5,0xB2,0xE3,0xD1,0xC9,0x53,0x30,0x9C,0x0E,0x93,0x17,0xBB,0x34,0x61,
        0x6F,0x8C,0xCA,0x6C,0x24,0x47,0x93,0x4C,0x11,0x97,0x8E,0xB8,0xC3,0x33,0xA5,0xAB,
        0xE4,0x8F,0x7C,0xE8,0x78,0x80,0xD0,0xEF,0xBA,0x89,0x22,0xDD,0x19,0x6A,0xCD,0x73,
        0x13,0x55,0x05,0x86,0x3B,0x58,0xF5,0x05,0x3A,0x60,0xFC,0xCE,0x08,0xA2,0xEF,0x51,
        0xD7,0xEE,0xC9,0xCE,0x9F,0x79,0x1D,0xEB,0xEA,0xAC,0x77,0x45,0x98,0xAA,0x20,0x05,
        0x5B,0x1E,0x3A,0xB8,0x1D,0xB2,0xE9,0x75,0x66,0x34,0x13,0x4C,0x0D,0xE0,0x79,0x98,
        0x83,0xE7,0xF3,0x27,0xEB,0x71,0x1C,0xFB,0xA6,0x41,0x94,0xC4,0xB8,0x0C,0xD6,0x63,
        0x0D,0xB3,0x36,0x1E,0xB5,0x07,0x42,0x3C,0x3A,0x54,0x8E,0xB5,0x5A,0xEA,0xA1,0x4F,
        0x1E,0x62,0xA3,0xDF,0x56,0x8D,0xDA,0x1E,0x45,0xE8,0x41,0x27,0xCA,0x17,0x68,0x11,
        0x7E,0xCB,0x47,0x25,0x81,0x5C,0x7C,0xBC,0x11,0x6A,0x87,0xE3,0x42,0xC5,0x76,0xFF,
        0xF7,0xAD,0xA3,0x89,0x96,0x64,0x84,0x5B,0x58,0x13,0xD4,0x22,0x86,0xDB,0xD2,0x78,
        0x46,0xB8,0x20,0xE4,0x6E,0xC2,0x50,0x75,0x0B,0x8C,0xF6,0x16,0x6B,0x44,0xBA,0x32,
        0x6D,0xDA,0x66,0xEC,0x02,0xDB,0x80,0x62,0xC4,0xF7,0xBD,0x3F,0xF1,0x0F,0xC1,0x16,
        0x20,0xAB,0x98,0xC1,0xE8,0x52,0x79,0x1C,0x4D,0x33,0xC6,0xDF,0x2B,0x4D,0x42,0x39,
        0x9A,0xA0,0x00,0x62,0x73,0x29,0x7A,0xD0,0x76,0xD7,0x12,0x22,0xA4,0xC8,0x22,0x74,
        0x39,0xB3,0x7D,0xEC,0xB9,0xC6,0x9E,0xF8,0x8F,0xAA,0x01,0xFD,0xD0,0xB1,0xEB,0xC3,
        0x64,0xD2,0x98,0x3E,0xD9,0x26,0x5E,0x8B,0x36,0x76,0x27,0x74,0xBE,0x1F,0x4F,0xC7,
        0x83,0x51,0x9B,0xA1,0x6B,0xF8,0xE1,0x71,0xAB,0x92,0x03,0xD0,0x12,0x8C,0xB0,0x03,
        0xFC,0xFA,0xD0,0xA8,0x1E,0x11,0xE3,0x5C,0x48,0xFD,0x86,0x7C,0x28,0x71,0x89,0x2E,
        0xCD,0x39,0xD3,0x3F,0x7B,0x52,0xD1,0x91,0x77,0x9F,0xC2,0xB6,0x2E,0x0F,0x79,0xA6,
        0x5D,0xE0,0x5F,0xDD,0xA7,0xC2,0x32,0xC2,0xA9,0x63,0xB7,0x80,0xEC,0xF9,0xDB,0x83,
        0x44,0x3C,0x3A,0x21,0x4A,0x0A,0x75,0x23,0xBF,0xFB,0x6B,0x9A,0xC9,0xDF,0x33,0xAD,
        0xAA,0xCD,0x94,0x51,0x25,0xF5,0x43,0xF2,0x30,0x77,0x18,0x8D,0xF2,0xD5,0x01,0x18,
        0x1D,0x4A,0x79,0x45,0x14,0x40,0x1D,0x28,0x6D,0x7A,0x69,0x31,0x6F,0xE6,0x46,0x06,
        0x54,0xB2,0xE8,0xB4,0x1F,0x9D,0x38,0x09,0xE7,0x79,0xC9,0x87,0x99,0x4A,0xFD,0xF4,
        0xC9,0x34,0x53,0x2A,0x84,0x4A,0x99,0x0D,0xA8,0x2C,0xB3,0x52,0xB7,0x2B,0x55,0x38,
        0xAB,0x77,0x49,0x0A,0xD6,0x0E,0xCE,0x81,0x7C,0x9A,0xD0,0x1F,0x5F,0xEC,0x18,0xF0,
        0xC4,0xFE,0xF6,0x0A,0x5C,0x98,0xCD,0x4A,0x96,0x3F,0x74,0xB3,0xBC,0xAC,0x7B,0x55,
        0x6F,0xD6,0x61,0x38,0x36,0xDE,0x69,0x2A,0xA3,0x2E,0xA3,0xED,0x39,0x15,0x73,0xFD,
        0x8F,0x79,0xE1,0x07,0x94,0x64,0xF1,0xD9,0x72,0xCB,0x93,0x2C,0x3B,0xFE,0x7C,0xA0,
        0xD8,0xEA,0x10,0xD7,0x25,0x1B,0xE6,0xE9,0x47,0x50,0xDF,0x62,0x52,0x5E,0x7A,0x74,
        0xCC,0x32,0x32,0x45,0x98,0x65,0xE2,0x9D,0xA0,0xE3,0xAC,0x44,0x22,0x70,0xB8,0x02,
        0xF6,0x1B,0x5F,0xE5,0xF0,0x68,0xA2,0x41,0xB2,0xB6,0xF5,0x4E,0xE7,0x88,0x09,0x16,
        0xD6,0x8B,0xA8,0x0C,0xD4,0x45,0xC9,0xDE,0x92,0x54,0x0A,0x7E,0x92,0xB4,0xF1,0x60,
        0xDB,0x99,0xA9,0x21,0x64,0x53,0xC1,0x55,0xC3,0xF9,0x26,0x80,0x9F,0x4C,0x7B,0xA4,
        0x24,0x04,0xCD,0xCA,0x73,0xC1,0x27,0x28,0xE2,0x08,0x4C,0xBF,0xF7,0x57,0x17,0xD1,
        0xB7,0x10,0xE5,0xD0,0xD7,0x32,0x71,0x58,0x4C,0x92,0x68,0xB6,0xA5,0xC0,0xFF,0xE7,
        0x75,0x11,0x2C,0xE1,0xA4,0x84,0xB5,0x13,0xFF,0x59,0x2E,0xD0,0xCB,0x87,0x98,0xAC,
        0x20,0xA2,0x07,0xEB,0xDD,0xC0,0x14,0xFF,0xAA,0x8B,0x89,0x8E,0xD9,0xAF,0xDC,0x9B,
        0x96,0x3D,0x8A,0x0C,0x6B,0x63,0xFC,0xE5,0x35,0xF7,0x88,0x00,0x96,0x1C,0xA3,0x9B,
        0x47,0x87,0xFB,0x65,0x09,0x52,0x7D,0x55,0xF6,0x2C,0xD7,0x7F,0x9D,0x31,0x9A,0x37,
        0x0F,0x87,0x25,0x0D,0x42,0x25,0x44,0xB5,0x4E,0x1E,0xAF,0x6F,0x68,0x7A,0x3F,0xD0,
        0xDD,0xBC,0x0D,0xB3,0x4D,0x01,0x29,0xED,0x6D,0x3E,0x5A,0x02,0x4A,0xB7,0xB4,0xA0,
        0xE5,0xB5,0x7A,0x10,0x18,0x63,0xA0,0x5D,0x1F,0xCE,0xFC,0x9A,0xAC,0xAC,0x35,0xD4,
        0xE1,0x1B,0x9B,0x49,0xBD,0x97,0xFC,0xD1,0xB9,0xD0,0xE9,0x29,0xFA,0xCF,0x59,0xFA,
        0x42,0x2D,0xA7,0xEE,0x35,0xFD,0x78,0x80,0x4B,0x28,0x6A,0x8C,0x90,0x0A,0xCB,0x03,
        0x3A,0x93,0x96,0x99,0xF1,0x50,0x87,0xBE,0xBC,0xF6,0x72,0x4D,0xBE,0x68,0xD1,0x8D,
        0x8F,0xDC,0x9F,0xA3,0x15,0x99,0x39,0x36,0x58,0x1D,0xB9,0xD7,0x99,0xBC,0x94,0xDB,
        0x10,0x81,0x16,0x46,0xE4,0x91,0x58,0x41,0xB8,0xA7,0x47,0xAD,0x76,0xB9,0x38,0x46,
        0x81,0xE9,0xBD,0xB6,0x31,0x76,0xF1,0xB4,0x90,0x51,0x02,0x22,0xAD,0xF3,0xF8,0xA7,
        0xA2,0x2A,0x5F,0x97,0x09,0x91,0xE2,0x3F,0x17,0x1E,0xC4,0x52,0x2B,0x65,0x53,0xAA,
        0x2D,0xC0,0xE2,0xAF,0x75,0x0C,0xD0,0x3D,0xB4,0xBB,0xA9,0x33,0xF7,0x59,0x07,0xE3,
        0xE4,0x68,0xE4,0x3E,0x15,0x3D,0x49,0x5C,0x17,0x29,0x30,0x16,0xD5,0x7A,0x22,0x37,
        0xF1,0xC4,0xAB,0x90,0xC2,0xDD,0xA3,0xA1,0x6B,0x12,0xF2,0x00,0xC2,0xD0,0xF5,0x15,
        0xFF,0x5E,0x09,0xF4,0x0C,0x7A,0xBF,0x8F,0x0D,0xE5,0x28,0x1C,0x02,0x04,0x3A,0x0B,
        0x86,0x17,0xD4,0xC3,0x44,0x4C,0x26,0xE7,0x83,0x75,0x51,0x9A,0x92,0xB3,0x11,0x79,
        0x3C,0x3D,0x31,0x4B,0xD8,0x58,0xF2,0xC7,0xB6,0xC1,0x50,0xE1,0x00,0x87,0x32,0xC7,
        0x00,0xDD,0x52,0x8E,0x8A,0x3A,0x8F,0x2F,0x39,0x6E,0xFE,0x7E,0xD2,0xE9,0x84,0xCD,
        0xB1,0x3D,0xC2,0x24,0x65,0xFA,0xD6,0x49,0x95,0x8D,0x98,0xFA,0x30,0x92,0x23,0x72,
        0xD8,0x5F,0xA3,0xCE,0x0D,0xD7,0x6D,0xE6,0x2A,0xE4,0xDC,0x74,0xE4,0x6D,0x35,0x14,
        0x7D,0xF7,0x00,0xA8,0xA4,0x84,0xEB,0x20,0xC4,0x30,0xC4,0x2A,0xBF,0x1E,0xEF,0x4F,
        0x54,0x0C,0x9C,0x13,0x7E,0x7E,0xC4,0x8D,0x1F,0x14,0xAF,0x19,0xD2,0x53,0xFD,0xB9,
        0x55,0x97,0x4E,0xD3,0x43,0xE6,0x3D,0x33,0xCC,0xAA,0xEE,0x0D,0x6E,0xC4,0x9E,0xDF,
        0x3D,0x81,0xB8,0xEF,0x3B,0x37,0x44,0xD8,0x2D,0x1B,0x9B,0x82,0xAE,0x55,0x5C,0x34}, 
        /*TST_dataSize*/
        1536*sizeof(DxUint8_t),
        CRYS_AES_ECB_mode
    },
    #endif
        /************/
        /*        AES CBC vectors         */
        /************/    
    #if TST_USE_AES_16BYTE_DATA
    { 
        {"Acceptance test - AES/CBC/SecretKey/16ByteData "},
        /*TST_IvCounter*/
        {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f}, 
        /*TST_input_data*/
        {0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a},
        {0},
        /*TST_Expected_output_data for enc Input data for decrypt*/
        {0x76,0x49,0xab,0xac,0x81,0x19,0xb2,0x46,0xce,0xe9,0x8e,0x9b,0x12,0xe9,0x19,0x7d}, 
        /*TST_dataSize*/
        16*sizeof(DxUint8_t),       
        CRYS_AES_CBC_mode
    },
    #endif
    #if TST_USE_AES_32BYTE_DATA
    { 
        {"Acceptance test - AES/CBC/SecretKey/32ByteData "},
        /*TST_IvCounter*/
        {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f}, 
        /*TST_input_data*/
        {0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a,
         0x65,0xa2,0x32,0xd6,0xbc,0xd0,0xf9,0x39,0xed,0x1f,0xe1,0x28,0xc1,0x3b,0x0e,0x1b},
        {0},
        /*TST_Expected_output_data for enc Input data for decrypt*/
        {0x76,0x49,0xab,0xac,0x81,0x19,0xb2,0x46,0xce,0xe9,0x8e,0x9b,0x12,0xe9,0x19,0x7d,
         0xe9,0x32,0x2e,0x95,0x30,0x6b,0x9d,0x25,0x83,0x24,0x2f,0x12,0x1a,0x57,0xb7,0xb6}, 
        /*TST_dataSize*/
        32*sizeof(DxUint8_t),     
        CRYS_AES_CBC_mode
    },
    #endif
    #if TST_USE_AES_512BYTE_DATA
    { 
        {"Acceptance test - AES/CBC/SecretKey/512ByteData "},

        /*TST_IvCounter*/
        {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f}, 
        /*TST_input_data*/
        {0xb6,0xed,0x21,0xb9,0x9c,0xa6,0xf4,0xf9,0xf1,0x53,0xe7,0xb1,0xbe,0xaf,0xed,0x1d,
         0xf3,0xee,0xd1,0xbd,0xb5,0xd2,0xa0,0x3c,0x06,0x4b,0x5a,0x7e,0x3d,0xb1,0x81,0xf8,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0x62,0xf8,0xa7,0x23,0x7b,0xbd,0xf8,0x4d,0x4e,0x1d,0xff,0xe8,0xb5,0x2a,0x02,0xc1,
         0x52,0xdb,0x14,0x2f,0xeb,0x21,0xf9,0x58,0xb8,0x80,0x28,0x68,0xe4,0x99,0x06,0x18,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0xb6,0xed,0x21,0xb9,0x9c,0xa6,0xf4,0xf9,0xf1,0x53,0xe7,0xb1,0xbe,0xaf,0xed,0x1d,
         0xf3,0xee,0xd1,0xbd,0xb5,0xd2,0xa0,0x3c,0x06,0x4b,0x5a,0x7e,0x3d,0xb1,0x81,0xf8,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0x62,0xf8,0xa7,0x23,0x7b,0xbd,0xf8,0x4d,0x4e,0x1d,0xff,0xe8,0xb5,0x2a,0x02,0xc1,
         0x52,0xdb,0x14,0x2f,0xeb,0x21,0xf9,0x58,0xb8,0x80,0x28,0x68,0xe4,0x99,0x06,0x18,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0xb6,0xed,0x21,0xb9,0x9c,0xa6,0xf4,0xf9,0xf1,0x53,0xe7,0xb1,0xbe,0xaf,0xed,0x1d,
         0xf3,0xee,0xd1,0xbd,0xb5,0xd2,0xa0,0x3c,0x06,0x4b,0x5a,0x7e,0x3d,0xb1,0x81,0xf8,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0x62,0xf8,0xa7,0x23,0x7b,0xbd,0xf8,0x4d,0x4e,0x1d,0xff,0xe8,0xb5,0x2a,0x02,0xc1,
         0x52,0xdb,0x14,0x2f,0xeb,0x21,0xf9,0x58,0xb8,0x80,0x28,0x68,0xe4,0x99,0x06,0x18,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0xb6,0xed,0x21,0xb9,0x9c,0xa6,0xf4,0xf9,0xf1,0x53,0xe7,0xb1,0xbe,0xaf,0xed,0x1d,
         0xf3,0xee,0xd1,0xbd,0xb5,0xd2,0xa0,0x3c,0x06,0x4b,0x5a,0x7e,0x3d,0xb1,0x81,0xf8,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0x62,0xf8,0xa7,0x23,0x7b,0xbd,0xf8,0x4d,0x4e,0x1d,0xff,0xe8,0xb5,0x2a,0x02,0xc1,
         0x52,0xdb,0x14,0x2f,0xeb,0x21,0xf9,0x58,0xb8,0x80,0x28,0x68,0xe4,0x99,0x06,0x18,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9},
        {0},
        /*TST_Expected_output_data for enc Input data for decrypt*/
        {0x5e,0xad,0x05,0x44,0x74,0xb8,0x94,0x78,0x5a,0x54,0x8c,0x6c,0x4d,0x92,0x82,0xb3,
         0xe4,0x07,0xd6,0x3c,0x25,0xb4,0x5e,0xc1,0xce,0x30,0x46,0x54,0x84,0xef,0x31,0x87,
         0x1e,0x12,0xca,0x47,0x43,0x58,0x0e,0x16,0x80,0x6b,0x20,0x10,0x80,0x8e,0x69,0xb0,
         0x02,0x13,0x3e,0x62,0x52,0xa8,0x32,0x0a,0x8f,0x6a,0xd0,0xd9,0x39,0xd3,0x87,0x7e,
         0xae,0x51,0x37,0xd9,0xd8,0x8a,0x65,0x2b,0x77,0x4d,0x40,0x1d,0xaa,0xb0,0x56,0xa4,
         0x18,0x56,0x52,0x58,0xd4,0xa8,0x37,0x77,0x0c,0xf2,0xbf,0x00,0x2b,0x97,0xa3,0x4a,
         0x2f,0x48,0x3d,0x13,0x00,0x95,0xb8,0x4b,0xbb,0x77,0x29,0x0b,0x7c,0xb6,0x78,0x9b,
         0xf7,0x9f,0x26,0x65,0xc9,0x99,0x78,0x0c,0x03,0x49,0x0c,0x22,0x49,0x55,0x24,0x43,
         0x26,0xcd,0x8b,0x6f,0x25,0x6c,0xaa,0xff,0xf4,0x5a,0xa2,0x2d,0x01,0x14,0x5e,0x5b,
         0x1d,0x5b,0x54,0x6c,0x27,0x2d,0xa9,0xbe,0x1b,0x2f,0x90,0x25,0x60,0x26,0x8e,0xa2,
         0x7f,0x44,0x69,0x70,0xb7,0x87,0x21,0x45,0x11,0x79,0xfd,0xa7,0x61,0x8c,0x27,0xdd,
         0xfa,0x84,0x3b,0x05,0x46,0x07,0x73,0x2a,0x4c,0xfd,0xc0,0xae,0xc9,0x87,0x2f,0xd1,
         0xe9,0x72,0xf3,0x9e,0x1c,0x0d,0x99,0xdf,0x92,0x83,0x58,0x40,0xd7,0xc1,0x06,0x2f,
         0x73,0xa3,0x26,0xfd,0x4e,0x4b,0xb4,0xb9,0x96,0xb4,0x82,0xb5,0xcc,0xb8,0x0a,0x88,
         0x11,0xe7,0x70,0x8a,0xaa,0x96,0xaf,0x09,0x12,0x05,0x11,0xa7,0x9b,0x78,0xb7,0x30,
         0xd7,0x72,0x22,0x02,0xa8,0x57,0xd9,0x49,0x0b,0x4c,0x59,0x20,0xb8,0xe6,0xe9,0x34,
         0x49,0x81,0x4a,0x3e,0x27,0xec,0xee,0x5b,0xca,0xed,0x3b,0x64,0xd4,0xdb,0x9f,0xd3,
         0x96,0x3a,0x9e,0xb2,0x34,0xbe,0x4c,0x2f,0xad,0x36,0x3c,0x5f,0x32,0xae,0xab,0x7b,
         0xc2,0x93,0xd2,0x5b,0x6f,0xf9,0x88,0xa6,0xad,0x2a,0x6b,0xd9,0x3f,0x29,0x04,0xf6,
         0x9d,0x92,0x8a,0xf0,0x9a,0x5e,0xc1,0xf3,0x65,0xe0,0x1c,0xa1,0xf7,0x88,0x58,0x94,
         0x67,0x57,0xe2,0x16,0x6b,0xcd,0xe0,0x01,0x8b,0xe2,0x58,0x5f,0x6a,0x77,0x0f,0x13,
         0xf1,0xa1,0xad,0x11,0xe7,0x3d,0xad,0x02,0x77,0x7c,0xb9,0xce,0xe0,0xf6,0x9a,0xd6,
         0x50,0xb8,0xf6,0x17,0xa5,0x43,0x3d,0x43,0x7e,0x7e,0xf9,0x57,0xf2,0xd5,0x7c,0xbc,
         0x33,0x0d,0x87,0x15,0x6c,0x03,0x73,0xcc,0x77,0x44,0x5d,0x92,0x72,0x64,0xf0,0xcd,
         0xd9,0x0e,0xf8,0x6b,0x80,0x38,0x84,0xd7,0x97,0xe1,0x4e,0x9e,0xdd,0xd5,0xc4,0xcc,
         0xad,0x3e,0x62,0xf6,0x76,0x07,0xa8,0x8f,0xb0,0x39,0xbc,0xc1,0xe8,0x64,0xfe,0x42,
         0x7d,0x91,0x23,0xae,0x8d,0x13,0xf2,0x02,0x8f,0xef,0xec,0xf0,0x59,0xfa,0xe4,0x83,
         0x5d,0x3d,0xdc,0xf5,0x25,0xee,0x92,0x51,0x49,0xd2,0x64,0xb5,0x00,0xe7,0x35,0x97,
         0xd8,0xf8,0x33,0x42,0xbb,0x37,0xe2,0x94,0xf7,0xcf,0xe8,0xe2,0xb9,0xf2,0xb0,0x4c,
         0x71,0xc9,0x74,0xc4,0xc9,0xa3,0x62,0xb5,0x83,0x36,0xd0,0x02,0x49,0x94,0x45,0x05,
         0xd2,0x12,0x0e,0x54,0x0d,0x44,0xf9,0xf0,0x29,0xa4,0xb9,0x4f,0x39,0x9e,0x34,0x80,
         0x36,0xec,0x30,0xb4,0x31,0x63,0xe7,0x16,0x1c,0x11,0x19,0x7a,0x2a,0xa6,0xff,0x8c}, 
        /*TST_dataSize*/
        512*sizeof(DxUint8_t),        
        CRYS_AES_CBC_mode
    },
    #endif
    #if TST_USE_AES_1536BYTE_DATA
    { 
        {"Acceptance test - AES/CBC/SecretKey/1536ByteData "},
        /*TST_IvCounter*/
        {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f}, 
        /*TST_input_data*/
        {0x67,0xCF,0x90,0xD1,0x29,0xF7,0xAF,0x76,0x74,0x93,0xBE,0x2D,0xF2,0x36,0x1C,0x81,
        0x0B,0x64,0xAB,0xF5,0x1C,0x6A,0x49,0x8C,0xE2,0x2A,0x9B,0x95,0x51,0xFF,0x5E,0x17,
        0xDD,0xA8,0x79,0x4F,0x0C,0xBB,0x9E,0x65,0xF0,0x69,0x00,0x0F,0x57,0xE8,0x5D,0x77,
        0xE1,0x4F,0x32,0x64,0x9B,0x68,0x9D,0xFC,0x86,0x03,0xEE,0xFF,0x5C,0x19,0x25,0x75,
        0x35,0xA6,0x50,0x49,0xBD,0xCD,0x75,0x4F,0xC5,0x46,0x05,0xB2,0x6A,0x3A,0x35,0xFA,
        0xCC,0x23,0xB4,0x02,0xCC,0xFA,0x7C,0x75,0x0A,0x7C,0xC9,0x09,0xCC,0x9F,0x08,0xD7,
        0x44,0x8A,0xD9,0xB0,0x98,0x13,0xBA,0x13,0xD9,0xE2,0x9E,0x55,0x63,0xEA,0x92,0x4B,
        0xCE,0xF4,0x32,0x39,0x64,0x22,0xA8,0x3A,0x2A,0xDB,0x3E,0x40,0x04,0x6C,0x83,0x26,
        0x3D,0x2D,0x6E,0xDF,0x60,0x84,0x61,0xB8,0x69,0xA1,0x28,0xEA,0x5B,0x26,0x12,0x20,
        0xEA,0x7D,0x3B,0xD7,0x6C,0xCF,0x72,0x22,0xE2,0x9F,0x86,0xBD,0xD4,0x7A,0x0F,0x6D,
        0x5F,0x78,0x18,0x35,0x7C,0xB2,0xEB,0x49,0x93,0x79,0xCF,0xC3,0xF9,0xBE,0xDE,0x03,
        0xC9,0x1E,0x55,0x87,0x31,0xAB,0xB9,0x6D,0xBB,0x4B,0xFD,0xC1,0xFE,0xA4,0xE3,0xEE,
        0x91,0xBB,0x8A,0xE3,0x0E,0xDD,0xA3,0x38,0x91,0xF1,0x44,0xF2,0xFF,0xAF,0x28,0x23,
        0xC0,0x82,0xF3,0xB5,0x24,0x87,0x3C,0xB3,0xBF,0xAA,0x7A,0x30,0xB4,0x2A,0x4B,0xEE,
        0x96,0xE1,0x31,0x3E,0x33,0xFB,0xF5,0xEC,0x7B,0x1D,0xF5,0x3F,0x67,0xC6,0x6D,0x0B,
        0x23,0xDA,0x01,0x7B,0xB0,0x2E,0xC9,0x0A,0x7F,0xD6,0x24,0x64,0x62,0x72,0x83,0x67,
        0xA5,0x56,0x5C,0x1E,0x7D,0xEA,0xF0,0xC4,0x8C,0x07,0x3A,0x07,0x91,0xFC,0x4C,0xF8,
        0x3C,0x6E,0x0D,0xDA,0x28,0xCF,0x3D,0x68,0x17,0x27,0xBE,0x5C,0xD7,0x91,0x89,0x09,
        0x99,0x8E,0x9A,0x10,0x69,0x4F,0x8E,0x38,0xEA,0x3C,0xEE,0xA8,0xF3,0xC2,0x78,0x83,
        0x8A,0x2B,0x27,0xF4,0x64,0xA8,0x3E,0xD6,0x18,0xF4,0x07,0x56,0x2B,0x93,0xED,0xFB,
        0x7E,0x31,0x6D,0x03,0x62,0x3B,0x8E,0xED,0xE0,0xD4,0xF0,0xEC,0xE0,0x95,0x74,0x54,
        0xAE,0x3B,0xD2,0xAB,0x6A,0x94,0xA4,0xF0,0x4F,0xC3,0xF8,0x75,0x47,0x37,0x0C,0x56,
        0x4E,0xF3,0x29,0xC2,0x54,0x74,0x21,0x4E,0x9D,0x39,0x14,0x8F,0xB8,0x52,0xF5,0x83,
        0x80,0xB2,0xA7,0xF0,0xC0,0x42,0x91,0xEA,0x8C,0x7C,0xB4,0x9E,0x43,0x19,0xA5,0xA8,
        0xC7,0x99,0x9D,0xED,0x6B,0xB1,0x00,0x3A,0x19,0x84,0x0D,0x30,0x7F,0x14,0x38,0xFD,
        0xCE,0x75,0xF4,0x95,0x90,0x1B,0x95,0x0C,0x61,0x3F,0x36,0xD7,0xBF,0x83,0x0A,0x83,
        0x93,0x6C,0xC7,0x1F,0xB4,0x08,0x18,0xCE,0xB2,0x6D,0xD7,0x3C,0x34,0x61,0x6A,0x77,
        0x44,0xB7,0xD0,0xCE,0x24,0x10,0x18,0xAC,0x03,0x91,0x8B,0x2B,0x7B,0x28,0x7A,0x96,
        0x79,0x8A,0x9C,0x13,0x4C,0x19,0x48,0xC5,0x5C,0x25,0xE3,0x22,0x44,0x59,0xD7,0x00,
        0xD5,0xBE,0x93,0x08,0xB3,0x3C,0x5E,0x83,0x53,0x1B,0x1B,0x23,0x7C,0xEC,0x53,0x8A,
        0xF2,0x40,0xC3,0xAA,0xC4,0x56,0x2B,0x2B,0x6E,0x0A,0x71,0xFE,0x2D,0xF5,0x67,0xAA,
        0xB9,0x8A,0x56,0xBD,0x94,0x71,0xE3,0x3C,0x2B,0x19,0xC0,0x30,0xFD,0x25,0x48,0x70,
        0xD2,0x59,0x30,0x03,0x95,0x2D,0x3C,0x7E,0x92,0x68,0x9A,0xA8,0xCB,0x5F,0x56,0x5D,
        0xB4,0x70,0x6A,0xF2,0x96,0x95,0xF5,0x80,0x5D,0x86,0x7E,0xAB,0x95,0xFA,0x2D,0x49,
        0xC1,0x01,0x2C,0xD4,0xC5,0x63,0x14,0x8B,0x4E,0xD7,0x2A,0x2C,0xD7,0x3A,0x71,0xCB,
        0xC2,0x62,0x7C,0x8C,0xBA,0x56,0xD9,0x3C,0x63,0xAF,0xA6,0x0E,0xAE,0x90,0xE8,0x98,
        0x3A,0x51,0xE7,0xCA,0x33,0x82,0x98,0x50,0x5C,0xDE,0xA3,0xBE,0x6B,0xC8,0xA9,0x22,
        0x15,0xB3,0xE8,0x33,0x7E,0xA0,0x8E,0x6A,0x27,0xEF,0x70,0x16,0xBD,0x05,0xDC,0xBE,
        0xEF,0x92,0xF2,0x86,0x53,0xA6,0x97,0x40,0xCA,0x2B,0x30,0xDC,0xB3,0x1B,0xD1,0x9B,
        0x05,0x83,0xF9,0xFB,0xA8,0xB5,0x1A,0x9A,0xC2,0x7C,0xA3,0x44,0x12,0x82,0x93,0x56,
        0x01,0xE4,0xCF,0xD8,0xD6,0x23,0xCF,0x6E,0x1B,0xA7,0x69,0x52,0x6F,0xB1,0xB7,0x0B,
        0x1D,0xD4,0x10,0x3A,0x0C,0xE1,0x16,0x39,0x78,0x57,0xC3,0xD6,0x03,0x53,0x2E,0x48,
        0x98,0xDA,0xDA,0xCE,0x4C,0xF8,0xC5,0xE2,0xB3,0x8A,0xE0,0x00,0x4C,0xC7,0x2A,0x11,
        0xC5,0x97,0x26,0x3D,0x71,0x59,0x4A,0x20,0xCE,0x95,0x60,0x7E,0x60,0xF8,0x6A,0xC7,
        0x79,0x20,0xBA,0x95,0xD6,0xE8,0xBF,0x25,0x0F,0x2E,0x86,0x81,0x01,0x15,0xED,0xB0,
        0x2D,0xB2,0x11,0x6C,0x2C,0xF1,0xD6,0x3E,0x8F,0xBA,0xFF,0xB6,0x97,0x46,0x81,0xBB,
        0x1F,0x18,0x87,0x2B,0x0C,0x94,0x3A,0xDC,0xD7,0x01,0x2E,0x42,0xD3,0xC8,0x1E,0xB9,
        0xA8,0xAF,0x51,0xAE,0xE6,0xFE,0x9A,0x88,0x49,0x7B,0x06,0x1C,0xE9,0x09,0x8D,0xC9,
        0xAC,0xCB,0x61,0xE8,0x8E,0xC1,0xA3,0x98,0x77,0x35,0x94,0x2B,0xC2,0x93,0x6B,0xC6,
        0x9B,0x46,0x0D,0xE8,0xF5,0xD3,0xD4,0x21,0x7D,0xFF,0xE1,0x91,0x8E,0x1D,0xF3,0xCE,
        0x74,0x64,0x96,0x08,0x66,0x35,0x2A,0xE6,0x0B,0xB8,0x36,0xB1,0x69,0x6F,0xC5,0xB5,
        0x0F,0x3F,0x80,0xA2,0xFB,0xA5,0xD3,0xD8,0xF6,0x40,0x6B,0x8F,0xE0,0x12,0x0A,0x59,
        0x42,0xC6,0xB7,0x5E,0xFD,0x63,0x5F,0x65,0x1B,0x27,0xDC,0x3C,0x9D,0x22,0xB7,0x0E,
        0x3A,0x2B,0x81,0x4F,0x9D,0x50,0xD2,0xCF,0x91,0xBD,0x11,0x26,0xCA,0x9B,0x06,0xF9,
        0xAD,0xDC,0x6F,0xA3,0xB7,0x67,0xB8,0xAC,0xDF,0x1A,0x86,0xD4,0xC9,0x96,0x3B,0xD4,
        0x88,0x5C,0x54,0xB4,0x91,0xBA,0xBC,0xF1,0xF3,0xE8,0xCC,0x40,0x52,0x39,0x9B,0x7F,
        0x20,0xE2,0x8F,0xC0,0xB2,0x14,0x56,0xD3,0x73,0xD4,0x70,0x82,0xC9,0xFE,0x05,0xFA,
        0x82,0x3D,0x9E,0x6D,0x47,0x51,0x67,0xF2,0x20,0x7E,0xB0,0xCF,0x9A,0x78,0x5A,0xA6,
        0x7F,0x07,0xB4,0xE6,0x07,0x7A,0x21,0x74,0x06,0x81,0x41,0xBC,0x4A,0x39,0x27,0xF5,
        0xE2,0xD2,0xBE,0x15,0x9B,0x2D,0x38,0xCE,0x7A,0x9C,0xA0,0x34,0x63,0x86,0x39,0xFB,
        0x7A,0xCA,0x03,0xC2,0x49,0x1F,0xF2,0x07,0x1B,0x29,0x67,0xC5,0x10,0xAB,0xA8,0xE6,
        0x56,0xBA,0xED,0xC7,0xBA,0x44,0x0B,0x52,0xCE,0xE5,0x6B,0x6B,0xDA,0xEC,0x10,0x7F,
        0x48,0x46,0x41,0x80,0x35,0x65,0xAB,0xC2,0xE0,0xB6,0xF9,0x71,0xC5,0x73,0xBE,0xCF,
        0xF3,0xB9,0xDE,0xA9,0x99,0x71,0x41,0x36,0xBF,0xB1,0xF4,0x64,0xB4,0x86,0x2D,0x2F,
        0x19,0xE7,0x7D,0xCA,0x6A,0x27,0xB1,0xF0,0x0F,0x2A,0xE7,0x03,0x4B,0x99,0x8C,0x5A,
        0x26,0x9C,0x77,0x20,0x0D,0x67,0xE6,0xD6,0x05,0x0B,0xC1,0x84,0x70,0x46,0x0E,0x59,
        0x89,0xCA,0x58,0xDE,0xF6,0xF4,0x65,0xCC,0x08,0xED,0x99,0x6E,0x8A,0x3D,0xEA,0x25,
        0x24,0x99,0x3D,0x18,0x0F,0x0C,0x21,0xB1,0x01,0xA6,0xC5,0x5E,0x65,0x2C,0x80,0xC8,
        0x1C,0x8D,0x7A,0x81,0x41,0xAE,0x64,0x32,0x36,0xAB,0x17,0x20,0xCD,0x78,0x4C,0xC7,
        0x20,0x9C,0x5F,0xD7,0x08,0xF5,0x4A,0x7C,0xA8,0xA6,0xDD,0x4F,0x2E,0x06,0x67,0xDC,
        0x6D,0xD0,0x51,0xFC,0xC3,0x69,0xE3,0x76,0x35,0x0A,0xE1,0x63,0xF5,0x00,0xE4,0x89,
        0x5A,0xFD,0x3D,0xC9,0xCC,0xA8,0xC0,0x26,0x43,0xFD,0xD8,0x9B,0xD0,0x14,0x04,0x30,
        0x44,0x3B,0xB2,0xFC,0x26,0x4F,0x03,0xB7,0xB8,0xE8,0xA2,0xFD,0x14,0xE6,0x87,0xA8,
        0xC2,0x54,0xF5,0x30,0xC8,0x9D,0x0F,0xC4,0x10,0x2A,0xB8,0xC6,0x91,0x48,0xA5,0x20,
        0x06,0xB1,0x1F,0xB9,0x4D,0xE7,0x62,0x0A,0xFA,0x86,0x10,0xE3,0x06,0xC2,0x12,0x5D,
        0x76,0x30,0xD9,0x7C,0x1F,0xD3,0x67,0xA6,0x2B,0xEE,0xEB,0xFB,0x96,0x3D,0x26,0x70,
        0x43,0x82,0xF6,0x63,0xC6,0xCD,0x5A,0xDB,0xF1,0xEB,0x36,0x41,0x8D,0x2B,0xBE,0x4E,
        0x18,0x5B,0x4F,0x60,0x6E,0x28,0x00,0x33,0x49,0x79,0x8D,0x5F,0xFB,0x67,0x73,0xBC,
        0x60,0x9F,0xA0,0x84,0xCB,0xAE,0x96,0xA8,0xD6,0xFE,0x8B,0x34,0x9C,0x25,0x19,0x00,
        0x2F,0x9D,0xE2,0x3B,0xED,0xC5,0x01,0x1A,0x81,0xC3,0x19,0x4C,0x40,0xFA,0xDF,0x8A,
        0x77,0x7A,0xE1,0xED,0x8B,0x39,0x83,0x69,0xC4,0xA7,0x8A,0x70,0x9D,0xCC,0x96,0x23,
        0x60,0x8D,0x2F,0x5D,0x84,0x38,0xCE,0x9B,0x9E,0x86,0x03,0x07,0x95,0x4A,0x68,0xDB,
        0x1E,0x01,0xBC,0x22,0x44,0x2C,0x75,0xF6,0x1A,0x79,0x76,0x46,0x3A,0x91,0x7C,0xB4,
        0x2C,0xF6,0xEC,0xB2,0xCA,0x81,0x05,0x3F,0xAB,0x45,0x4E,0x04,0x36,0x7B,0xD4,0x7A,
        0x3F,0xAF,0x52,0x9C,0x0F,0x74,0xDF,0x34,0x18,0x39,0x43,0x0B,0xC1,0x88,0x61,0x0D,
        0x0A,0x4E,0xDB,0x9F,0x5D,0xB5,0x11,0x9C,0xFB,0x7D,0x77,0xFE,0xDD,0x70,0xBF,0x9E,
        0xA4,0xFB,0x07,0x8A,0x3F,0xDF,0xA4,0xB8,0x16,0xB7,0x9A,0x90,0x3E,0xFA,0x7D,0x22,
        0xE4,0x41,0xFA,0xE7,0xA0,0x35,0x1C,0x89,0x9E,0xB5,0xA1,0x92,0xFC,0xE0,0x57,0xA7,
        0x7A,0xA5,0x66,0xC5,0x81,0xD6,0xCE,0x2A,0xAA,0x22,0x88,0xA5,0x1A,0x80,0x5E,0x00,
        0xFF,0x54,0x1A,0x9B,0x76,0xD8,0xFE,0x6F,0xDE,0x7D,0xEC,0x89,0x3E,0x11,0xBC,0x36,
        0x60,0xF3,0x16,0x98,0x93,0xB8,0xA1,0x0D,0x73,0xCF,0x3D,0x7D,0xAD,0x77,0x6E,0x1D,
        0x57,0xA1,0x93,0xA7,0xC5,0xBC,0x30,0xA2,0xA6,0xF7,0xE6,0x03,0xEA,0x44,0xEC,0x98,
        0x66,0x51,0x45,0x27,0x6A,0xC5,0x6C,0x46,0xB2,0x0D,0x27,0xA7,0x9A,0x80,0xC2,0x67,
        0x0E,0xCE,0x32,0x9C,0x7E,0x14,0x71,0xA4,0xC2,0x74,0xF1,0x9C,0xD1,0x9E,0x23,0x2F,
        0xE3,0xA4,0x17,0x5B,0x31,0x47,0xB3,0x91,0x34,0x4C,0xF5,0xB7,0x94,0x89,0x07,0x26,
        0x35,0x7E,0xF4,0x1B,0x12,0x4F,0x1A,0x52,0xE0,0xA0,0x65,0xF6,0xD3,0xCF,0x75,0x14},
        {0},
        /*TST_Expected_output_data for enc Input data for decrypt*/
        {0xC2,0xF1,0xAF,0xED,0x6E,0xA6,0x51,0x97,0x0D,0xB7,0x75,0xC8,0xB8,0xFB,0xE1,0x78,
        0x5A,0xDB,0xD1,0xA6,0x14,0x7C,0x04,0x15,0x66,0x78,0x62,0xCC,0xEA,0xEE,0xB9,0x99,
        0x0E,0x8F,0xBC,0x17,0xCA,0x4F,0xC3,0x92,0x5B,0x3E,0xB1,0x3D,0xC6,0x3F,0xA4,0xA7,
        0xD4,0x60,0xB0,0x96,0x53,0xC4,0xBD,0x11,0x6A,0xBD,0x5E,0x04,0x62,0xFD,0x63,0x62,
        0xBD,0xBF,0x6B,0x81,0x7D,0x84,0x94,0x45,0x19,0x07,0x67,0x08,0x49,0x52,0x6E,0x6D,
        0x2B,0xEB,0x9B,0x4B,0xAA,0xF1,0x9A,0x79,0xE9,0xB2,0xBC,0xC5,0xE4,0xE0,0x28,0x15,
        0xAA,0x78,0xB6,0x25,0x58,0x1D,0x06,0x31,0x12,0x8E,0x5C,0x1A,0x1C,0xF2,0xB4,0x98,
        0xA4,0xB4,0x0F,0xCD,0x50,0xA2,0x29,0x30,0xE2,0xB4,0x7C,0x7A,0xEC,0x4B,0x4B,0x80,
        0x81,0xDB,0x5C,0xA2,0x0C,0x47,0x1F,0x17,0x93,0xFA,0x78,0xD4,0xFC,0x29,0xF0,0x6D,
        0xA1,0x7D,0x4E,0x87,0x9D,0xD1,0xED,0xE7,0x9A,0xAD,0x73,0xDB,0xFC,0x01,0x4E,0x64,
        0x55,0x12,0x87,0xD2,0xEF,0xF5,0xAC,0x3B,0x1C,0x80,0x0F,0xE9,0x0D,0x95,0x80,0x27,
        0x74,0x83,0xBF,0x58,0x20,0xE5,0x12,0xAD,0x60,0xA4,0xC8,0x39,0xC2,0x5D,0x2C,0xB2,
        0x84,0x52,0xBF,0x47,0xE2,0xBF,0xD7,0xCA,0xBD,0xC2,0xEA,0x4B,0xC9,0xB3,0xEF,0x71,
        0x93,0xD4,0xA3,0xDD,0xC1,0x30,0x17,0x32,0x7A,0xA8,0xFB,0xA2,0x7F,0xF1,0xA2,0x65,
        0x82,0x47,0x3F,0x6A,0xB3,0xF0,0xCE,0x5B,0x6E,0x94,0x1D,0x6F,0x31,0x83,0xED,0x66,
        0x23,0x20,0x80,0x1C,0x27,0x8D,0xA0,0x43,0x5C,0xF6,0xA7,0x48,0x09,0xD5,0x49,0x58,
        0x1C,0x4A,0x09,0x7D,0x0E,0x63,0x2D,0x24,0x85,0x58,0x09,0x29,0x15,0xD9,0x64,0xA8,
        0xB3,0xFF,0xC2,0x0F,0x1A,0x37,0xCE,0x61,0xEC,0x71,0x95,0xDE,0xF5,0x3E,0x47,0x8C,
        0x7B,0x07,0xD1,0x19,0x82,0x70,0x79,0x5D,0x8B,0xCE,0xCF,0x43,0x50,0x7A,0x9A,0xB8,
        0x9F,0xBC,0xEA,0x6D,0xB4,0xFB,0x1D,0xAA,0xBF,0x91,0x2A,0x57,0x40,0xA0,0x1E,0xDB,
        0x91,0xDD,0x3E,0xB5,0x2A,0x44,0x68,0x72,0x91,0xFF,0x71,0x20,0xD6,0x7C,0xE4,0x2B,
        0x97,0x53,0xBA,0xC7,0xFB,0xF6,0x80,0xE0,0xB8,0x5B,0x57,0x7A,0x3A,0xC6,0x57,0xD5,
        0xA0,0x9B,0x13,0xBF,0x3C,0x77,0xB4,0xF7,0x34,0xC3,0x42,0x8B,0x4F,0x84,0x6E,0x7D,
        0xB4,0xA0,0x04,0x11,0x60,0x82,0x24,0xCE,0xF6,0xCC,0x34,0x17,0x23,0x81,0xF0,0xCA,
        0xE3,0x8D,0xFE,0xE6,0x0C,0xCB,0xD6,0xD6,0x25,0x16,0x4D,0x10,0x30,0xA6,0x5D,0xC1,
        0x84,0x2E,0x6C,0x82,0x98,0xAA,0x55,0xC6,0xD3,0x4D,0x37,0x8B,0x84,0xD8,0xA7,0x39,
        0xC0,0x6F,0xAB,0xD1,0x99,0x58,0xE5,0x9F,0x60,0xEE,0x3C,0x51,0xC7,0x78,0x84,0xCA,
        0xD9,0x5A,0xC1,0xFA,0x84,0xF0,0x1B,0x76,0x10,0x00,0x56,0xE1,0xB1,0x91,0xB4,0x34,
        0xA1,0x03,0x1C,0x94,0x99,0x39,0xD1,0xD8,0xF5,0x6D,0xB5,0xC8,0x59,0xDC,0x0A,0x5D,
        0x88,0xAA,0x5B,0x8E,0x5A,0x04,0x53,0x08,0x20,0x1A,0x01,0x68,0xCF,0x1E,0xE8,0xC2,
        0x6D,0xAC,0x5A,0x7A,0xA9,0x0D,0x79,0xFA,0x6C,0xB0,0xF1,0xAA,0xBF,0xE2,0xE8,0xFF,
        0x26,0xC7,0x6A,0xE9,0xA4,0xF5,0xF4,0x71,0xEC,0xF0,0xBB,0x12,0x29,0xF9,0xDB,0x00,
        0xF5,0x6A,0xF8,0x86,0x01,0xE0,0x5D,0x21,0xFE,0x95,0x38,0x50,0xFF,0xF1,0x08,0xD8,
        0xA2,0x7E,0x15,0xDB,0x16,0x90,0xCC,0x77,0x7D,0x69,0x13,0x2C,0x57,0x8B,0xA4,0xD2,
        0xF9,0x35,0x8B,0x2C,0xC0,0x44,0x87,0xF8,0xF1,0xF3,0x8A,0xD6,0xA3,0xCC,0xCA,0xE5,
        0x61,0x4B,0x67,0xC8,0xD4,0x43,0x67,0x89,0x8F,0xE8,0x0B,0x14,0x11,0xB0,0x8B,0x99,
        0x68,0xE8,0xDC,0x81,0x38,0x60,0xF2,0x6F,0xBB,0x0A,0x2C,0x89,0x35,0x59,0x84,0x15,
        0x77,0xE5,0x32,0xC6,0xA9,0x96,0x2C,0xD1,0xB8,0xBD,0xA1,0x2F,0xE9,0x34,0xE2,0xC8,
        0xB7,0x17,0x23,0x0A,0xAD,0x08,0xD4,0x36,0x32,0x75,0x95,0x7D,0xD0,0x9F,0xAF,0xCC,
        0x5E,0x82,0xBA,0x3C,0xE6,0x4B,0xAE,0x2A,0x3E,0xFF,0x49,0x0F,0xE1,0x39,0x4E,0x67,
        0x1D,0x82,0xB4,0x23,0xC9,0x17,0xBC,0x7E,0x4F,0xE5,0xC6,0x53,0x7E,0xFE,0xDF,0x5C,
        0xFC,0xB6,0xE3,0xA2,0xF9,0x5B,0xCF,0xC9,0xFF,0xCB,0x4F,0xF1,0x25,0x27,0x91,0x97,
        0x3A,0x0B,0xC4,0x41,0xE3,0x91,0x28,0x87,0x4A,0x19,0xAC,0x8B,0x6B,0x9D,0x97,0xC8,
        0x6A,0xF3,0x61,0x85,0x8C,0x80,0x74,0xEB,0x9A,0x00,0xCA,0x2F,0x2D,0xCC,0x45,0xCD,
        0xA0,0x1E,0xA1,0xF5,0x9C,0x20,0xA8,0xF4,0x55,0x70,0xDE,0x68,0x92,0xAA,0xCD,0x4D,
        0x55,0x48,0x2D,0x28,0x2F,0x55,0x8B,0x77,0x76,0x91,0x75,0xA4,0x7D,0x44,0x7F,0x65,
        0xE9,0xC4,0xA1,0x90,0x0B,0x0C,0x5D,0x13,0xDD,0x62,0x35,0x4C,0xEF,0xB5,0x23,0xF0,
        0xFD,0xB8,0xA4,0xD5,0x72,0x7F,0x80,0x58,0x6A,0xF8,0x4F,0x3C,0xE5,0xD3,0x4B,0x00,
        0xD7,0xF7,0x0D,0xF1,0xE0,0xD8,0x09,0x24,0x33,0x13,0xD1,0xBA,0xDF,0x2A,0x3A,0x3F,
        0x91,0xDB,0x11,0xA3,0x70,0x41,0xF3,0xDA,0xB4,0x9E,0x5F,0x4C,0x8E,0x37,0x92,0xFB,
        0x0D,0x28,0x41,0x4F,0x30,0x5A,0x77,0x78,0x9C,0x4A,0xF1,0xBA,0x29,0xDF,0xF2,0x9F,
        0x87,0x81,0x29,0x57,0xB0,0x29,0xBD,0xA1,0x02,0x31,0x7C,0xA6,0xE1,0xAE,0xA6,0x5A,
        0xEC,0x16,0xF6,0x3A,0xB2,0x73,0xDF,0x5D,0x25,0x9F,0x9A,0x78,0x07,0x4D,0xEC,0xB4,
        0xD5,0xBF,0x7C,0xA9,0xB5,0x42,0xE8,0x8D,0x63,0x57,0x17,0x70,0x6B,0xFC,0xD8,0x99,
        0x4C,0x67,0xC6,0x82,0xB9,0xF3,0xE7,0x37,0x85,0xFB,0xCF,0x8F,0x45,0x2E,0x99,0x38,
        0xC0,0xEF,0xA5,0xEF,0x78,0xEA,0x36,0x0A,0xED,0x95,0xE5,0xE8,0x77,0xCA,0x1A,0x2E,
        0x84,0x15,0xD6,0x05,0x17,0x75,0x49,0x01,0x9B,0x18,0xED,0x1C,0xDC,0x42,0x22,0xA6,
        0x41,0xAB,0x36,0xC7,0x66,0xA8,0x41,0x29,0x07,0xDC,0x27,0x19,0x6D,0xB6,0xFA,0x15,
        0x6B,0xEB,0x7B,0xC6,0x27,0x80,0xCE,0xC3,0x8B,0x3B,0x9F,0x91,0x3B,0xE9,0x40,0x67,
        0xE2,0xC5,0x29,0xDB,0xA4,0x27,0xAD,0x3F,0x00,0x30,0x53,0x17,0xA9,0x73,0x5B,0xE4,
        0x0C,0x9B,0x39,0x81,0xC8,0x84,0x37,0x62,0x94,0x4D,0x85,0x6C,0xC0,0x4E,0xEE,0xE0,
        0x35,0x3C,0x09,0xC2,0x0A,0xC5,0xFB,0xA7,0x0E,0xBF,0x04,0x54,0xC6,0x63,0x2F,0xA9,
        0x6B,0x12,0xE1,0x2D,0x92,0x50,0xE1,0x94,0xBF,0x19,0x44,0x0B,0x5D,0x9F,0xB1,0x9E,
        0xCB,0xF3,0x5C,0x07,0xA3,0x91,0xA8,0x3C,0x4F,0x54,0xDD,0x21,0xDB,0x40,0xC4,0xC8,
        0xB8,0xA4,0xE5,0xA1,0xEE,0xB2,0x80,0x4F,0xE9,0x22,0xF3,0x98,0x40,0xA4,0x17,0x7E,
        0xB5,0x23,0x24,0xE6,0x94,0x5A,0xCC,0xD5,0x0B,0x5F,0x52,0x19,0x14,0xA8,0x9E,0x0C,
        0x39,0x9A,0xAA,0x59,0x3C,0xC0,0xA1,0xC6,0x1D,0x70,0xAF,0xE5,0x3F,0x45,0x7F,0xC0,
        0x49,0x7A,0x84,0x48,0x94,0xD0,0x66,0x95,0x4F,0x3C,0x50,0x44,0x57,0xFC,0x7A,0x25,
        0x82,0xCE,0x26,0xAD,0xF1,0x35,0xF9,0x41,0x67,0x83,0x15,0x18,0x15,0x96,0x0B,0xD0,
        0xC7,0x47,0x3F,0x23,0x95,0x28,0xE6,0xF1,0x0D,0x20,0x85,0x07,0x5B,0x9B,0x36,0x3D,
        0x7F,0x7C,0x44,0x40,0x8F,0xA2,0x80,0xAF,0x9E,0x2D,0x34,0x7E,0xD4,0x8B,0x8E,0xEF,
        0xF8,0xFA,0xAA,0x74,0xB6,0x01,0xF7,0xFB,0x02,0x03,0xEE,0x28,0xEF,0x0A,0x51,0x83,
        0x5F,0xA3,0x0A,0x17,0xBF,0x0D,0x7D,0xE9,0x4D,0x42,0x5D,0x68,0xD9,0x7D,0xB2,0x98,
        0xDB,0xC8,0xD6,0x01,0xBC,0xEA,0x35,0xE4,0x14,0x5A,0xE8,0x24,0x31,0x3A,0x75,0x57,
        0xE0,0x16,0x49,0x48,0x5D,0x60,0x48,0x8A,0x69,0x9E,0xE7,0x20,0x2A,0x0B,0x84,0x6F,
        0xD8,0x1E,0x4B,0x4F,0x0F,0x19,0xC0,0xD3,0xCE,0xA2,0xEC,0x1B,0x8B,0x76,0x5D,0xD6,
        0x9B,0x29,0xF7,0xC9,0x3B,0x0D,0xA6,0xF7,0x55,0x08,0x63,0xA4,0xEC,0x7E,0x41,0x08,
        0x91,0x95,0xE7,0xA9,0xC1,0xB9,0xA4,0xC5,0xB5,0x2E,0xC9,0xF1,0x96,0x20,0xC0,0x7A,
        0x95,0x25,0x35,0xD2,0x74,0xCA,0x04,0xFE,0xAB,0x75,0xC3,0xEB,0x61,0xD8,0x21,0xAD,
        0x8D,0x49,0x20,0xE0,0x5A,0x9E,0x51,0x98,0x1B,0xC6,0x59,0x7B,0x62,0x83,0xA1,0x1C,
        0xCB,0xDD,0xAF,0x6E,0x18,0xDA,0x0B,0x21,0xC1,0x95,0x20,0x10,0x71,0xA6,0xBC,0x4F,
        0x42,0xF4,0x69,0x78,0x75,0x3D,0x2D,0x11,0x30,0x90,0x39,0x90,0x3F,0x25,0x6C,0x30,
        0xF4,0xEB,0x04,0x01,0x5F,0x97,0xDE,0x90,0xE8,0xA1,0xE3,0xB5,0xC5,0xA1,0x41,0x86,
        0xCB,0x7E,0x3C,0x95,0x40,0x2B,0xBB,0x9D,0xAA,0xF2,0x2A,0x8F,0x7B,0x87,0x80,0x93,
        0xF1,0xAF,0x48,0x30,0x0C,0x26,0x70,0xA8,0x8B,0x19,0x09,0x1D,0xF2,0x12,0x0C,0xC4,
        0xB2,0x42,0xD6,0x2C,0xD5,0x33,0x68,0x99,0x7F,0x07,0xAE,0xB0,0xB9,0xB7,0x34,0xD1,
        0xE7,0x2E,0xE2,0x2B,0xA8,0xC0,0xA2,0x8E,0x87,0xC2,0xA9,0x4C,0x2D,0xFF,0xB7,0x74,
        0xF6,0x1E,0x38,0x8C,0x9C,0x1E,0x26,0x50,0xE6,0x9F,0x73,0xB3,0xDF,0x9E,0x21,0x72,
        0xBD,0xAC,0x36,0x12,0x9C,0x54,0xFD,0x3D,0x0D,0x19,0x32,0xF9,0xE1,0xDC,0x2B,0x7F,
        0x5C,0xE3,0xA9,0x54,0x60,0x9D,0x3E,0xE7,0x2A,0x71,0x42,0x57,0x46,0x20,0x7C,0xEF,
        0xFD,0x9A,0xFC,0x0F,0x9F,0xC3,0x7B,0x87,0xC6,0x70,0x15,0x99,0xB2,0xD2,0x96,0x8A,
        0x00,0x57,0xC5,0x6A,0x29,0x1C,0x9A,0x25,0x75,0x28,0x14,0x29,0xC1,0xDB,0x58,0x47,
        0xE9,0x8E,0x40,0x03,0x32,0x8F,0xF2,0xA2,0x44,0xAC,0xB7,0xC1,0x2F,0x3D,0x7C,0x26,
        0x4A,0xE5,0x4C,0xA4,0xFA,0x9C,0x5F,0x89,0x1A,0xD9,0xAB,0xFA,0xA3,0xEC,0x6A,0x9D,
        0x39,0xDC,0x7B,0x47,0xFD,0x1E,0xC2,0x9F,0xFC,0x4C,0x44,0xCF,0xC2,0x51,0xD7,0xE6,
        0x9D,0xBF,0x65,0x29,0xA8,0x20,0xAE,0x69,0x5D,0xB2,0x41,0x99,0x90,0xE2,0xA8,0x94}, 
        /*TST_dataSize*/
        32*sizeof(DxUint8_t),     
        CRYS_AES_CBC_mode
    },
    #endif
};
#endif

#endif /*TST_USE_PREDEFINED_SECRETKEY_TESTS*/
/*************************/
/****** Key Wrap data **************/\
/*************************/

#if !(TST_USE_AES_16BYTE_DATA|TST_USE_AES_32BYTE_DATA|TST_USE_AES_512BYTE_DATA)
TST_AES_KeyWrap_TestDataStruct TST_ARS_KeyWrap_Acceptance_TestData[] = {0};
#else
TST_AES_KeyWrap_TestDataStruct TST_ARS_KeyWrap_Acceptance_TestData[] =
{
    #if TST_USE_AES_16BYTE_DATA
    { 
        {"Acceptance test - AES/KeyWrap/128Key/16ByteData "},
        /*TST_Key*/
        {0xbf,0x58,0xa6,0x1e,0x7a,0x49,0xa7,0xdd,0x3f,0x3c,0x4e,0xad,0xc0,0x26,0x86,0x5d},
        CRYS_AES_Key128BitSize,
        /*TST_input_data*/
        {0xf7,0xe6,0xf3,0x72,0x74,0xa1,0x72,0x24,0x0b,0x0f,0xc9,0x7e,0x25,0x8b,0x37,0xce},
        /*TST_InputDataSize*/
        16*sizeof(DxUint8_t),
        /*TST_WrapdData*/
        {0},
        /*TST_WrapdDataSize*/
        (16+TST_KEYWRAP_IV_SIZE_IN_BYTES)*sizeof(DxUint8_t),
        /*TST_Expected_output_data for enc Input data for decrypt*/
        {0x10,0x2a,0xba,0x74,0x38,0xcf,0xea,0x6d,0x5f,0x1b,0x4d,0xb4,0xb1,0xa5,0xaa,0x1b,
         0x21,0x5f,0x9d,0x89,0x91,0x39,0x1c,0x11},  
    },
    #endif
    #if TST_USE_AES_32BYTE_DATA
    { 
        {"Acceptance test - AES/KeyWrap/128Key/32ByteData "},
        /*TST_Key*/
        {0xbf,0x58,0xa6,0x1e,0x7a,0x49,0xa7,0xdd,0x3f,0x3c,0x4e,0xad,0xc0,0x26,0x86,0x5d},
        CRYS_AES_Key128BitSize,
        /*TST_input_data*/
        {0xe2,0x3d,0x78,0xd6,0xbd,0x71,0xcf,0x38,0xa3,0xdb,0x79,0xbf,0xb6,0xe8,0xbf,0xe9,
         0x8f,0x9e,0x1e,0x83,0xd2,0xdd,0x88,0x12,0x05,0xe5,0xcc,0x72,0xa2,0x19,0x52,0xbd},
        /*TST_InputDataSize*/
        32*sizeof(DxUint8_t),
        /*TST_WrapdData*/
        {0},
        /*TST_WrapdDataSize*/
        (32+TST_KEYWRAP_IV_SIZE_IN_BYTES)*sizeof(DxUint8_t),
        /*TST_Expected_output_data for enc Input data for decrypt*/
        {0x5d,0x3b,0xb0,0x21,0x73,0x25,0x0d,0xba,0x0d,0x74,0x5e,0x89,0xfc,0xab,0x41,0xf9,
         0x08,0xe8,0x57,0xa4,0x1c,0x3d,0x79,0x22,0x0d,0x33,0xbe,0xe5,0x2e,0xd6,0xf7,0x17,
         0x80,0xf1,0xea,0x6c,0x5c,0xe2,0x42,0x84},   
    },
    #endif
    #if TST_USE_AES_512BYTE_DATA
    { 
        {"Acceptance test - AES/KeyWrap/128Key/512ByteData "},
        /*TST_Key*/
        {0xbf,0x58,0xa6,0x1e,0x7a,0x49,0xa7,0xdd,0x3f,0x3c,0x4e,0xad,0xc0,0x26,0x86,0x5d},
        CRYS_AES_Key128BitSize,
        /*TST_input_data*/
        {0x8a,0xd5,0x4c,0x91,0xb7,0x94,0x7c,0xfc,0xc4,0xc2,0x38,0x37,0x02,0x79,0x01,0x53,
        0x90,0x6d,0x8c,0xba,0x7e,0x7c,0x0e,0x64,0x32,0x87,0xb7,0x4d,0x0b,0x81,0x7c,0x26,
        0x45,0xc5,0x1a,0x4a,0x1d,0xad,0x58,0xf5,0x35,0x60,0x8c,0xb0,0x39,0xeb,0x60,0x10,
        0xc3,0x94,0xd6,0xa0,0x7c,0x6a,0x8a,0x1c,0x85,0x21,0x38,0xe0,0x15,0x1d,0x7d,0x9f,
        0x63,0xcd,0xe2,0x58,0xc6,0x3a,0x16,0x86,0x1a,0xe0,0x7b,0x98,0x67,0xbc,0xe4,0xa0,
        0xbd,0xa6,0x9e,0x4f,0x62,0xe1,0xad,0x21,0x30,0xf1,0x57,0xd5,0x38,0xac,0xe7,0x20,
        0xab,0x94,0xab,0xa2,0xfb,0x64,0x3f,0x19,0x3d,0xe9,0x0d,0xd5,0xd2,0x13,0x15,0x6c,
        0x46,0x4c,0xea,0xae,0x78,0x08,0xfd,0xdb,0xfb,0x9e,0x1e,0x14,0xbd,0x56,0x40,0x10,
        0xe6,0xc3,0x7d,0x10,0x03,0x53,0x5a,0x15,0x64,0x24,0x4b,0x50,0xc2,0x19,0x7a,0xda,
        0x26,0x2e,0xc4,0xa5,0x05,0x08,0x04,0xb3,0xb0,0xd1,0x95,0x85,0xec,0x42,0x12,0xd7,
        0xdc,0x01,0x60,0x8a,0x28,0x2e,0xef,0xe2,0x58,0x38,0x3c,0xf1,0x81,0xf6,0x9b,0x53,
        0x24,0xf3,0x33,0x1c,0x53,0x09,0x4a,0x0f,0x15,0x31,0xc3,0x11,0x0c,0x99,0xe4,0xdd,
        0x55,0xf7,0x5d,0xf8,0xb0,0x1e,0x86,0xe8,0xe1,0xce,0xe9,0xa1,0x56,0xd1,0x00,0x40,
        0x09,0x43,0x40,0xfb,0xa8,0x32,0x56,0x58,0xf4,0x67,0xb0,0x9e,0x67,0x82,0x3f,0x89,
        0x19,0x4d,0x7b,0x42,0xe4,0x4a,0xa8,0x8e,0xc6,0x8e,0x58,0x46,0x88,0xd2,0x32,0x07,
        0x9d,0xc8,0xf1,0x2a,0x4d,0xab,0xb0,0xf7,0x13,0x1a,0x64,0x15,0x43,0x26,0xaa,0x45,
        0xef,0xaa,0xc3,0x51,0x0c,0xdb,0xdc,0x3e,0xd1,0x1f,0x93,0xc9,0x60,0x23,0xb8,0x12,
        0xa8,0x27,0x50,0x92,0x8a,0x9d,0xe0,0x52,0x3a,0xf3,0xe8,0x5f,0xe9,0xad,0xad,0x79,
        0xa1,0xb6,0x3b,0x0b,0x70,0xf8,0xab,0x60,0xc8,0x2a,0xa2,0x13,0x26,0xe9,0x1a,0xc7,
        0xf2,0x0b,0x65,0x19,0xa6,0x30,0x6e,0xd3,0x33,0x99,0x43,0x62,0xa1,0x3e,0xd0,0x8b,
        0xf5,0x1a,0xed,0x59,0x57,0xca,0x9c,0x5a,0x74,0x56,0x8b,0x0b,0x22,0x4f,0xe1,0x90,
        0x42,0x1a,0x37,0xa8,0xeb,0x8b,0xe3,0xe1,0xc5,0xb6,0x7d,0x08,0xb2,0x01,0x9c,0xe4,
        0xb4,0x7e,0xe1,0x24,0x0b,0x78,0x37,0x95,0x9d,0x4c,0x58,0x98,0x9b,0x7a,0x94,0xd4,
        0x62,0xfc,0xce,0x28,0x9f,0xd7,0xc7,0xe3,0xb7,0xef,0x9f,0x38,0x66,0x1f,0x98,0xec,
        0xa6,0x89,0x1e,0x52,0xd2,0x2b,0x04,0x79,0x0b,0xb4,0x11,0xa4,0xdb,0x95,0xbb,0xfa,
        0x18,0x5a,0x32,0x7f,0x0b,0x3b,0xa0,0x43,0xd2,0xee,0xaf,0xda,0x03,0xc0,0x4d,0x0b,
        0x92,0xe4,0xac,0xcc,0xf5,0x0b,0x8c,0x6f,0x85,0x35,0xbc,0x16,0x28,0xc6,0xde,0x6c,
        0x2d,0xdc,0x6c,0x97,0x77,0xe0,0xf8,0x68,0xde,0x5b,0xb8,0xd5,0xd2,0x0b,0x41,0xaa,
        0x41,0x37,0x93,0x7b,0xbb,0x3f,0x56,0xdd,0xd5,0x77,0x63,0xd6,0xcb,0x35,0x86,0x91,
        0x69,0x29,0x82,0x56,0x2b,0xed,0x56,0xba,0xa3,0xdd,0xbf,0x13,0x1b,0x29,0xfe,0x2f,
        0x7c,0x29,0xdb,0x46,0x6e,0xf0,0xea,0x2c,0xc1,0x23,0x0d,0xcb,0x0c,0x0c,0x3a,0xd1,
        0x93,0xea,0x7f,0xa6,0x6e,0x8b,0x43,0xa1,0xe8,0x1d,0xce,0x7b,0x26,0x42,0x0c,0x04},
        /*TST_InputDataSize*/
        512*sizeof(DxUint8_t),
        /*TST_WrapdData*/
        {0},
        /*TST_WrapdDataSize*/
        (512+TST_KEYWRAP_IV_SIZE_IN_BYTES)*sizeof(DxUint8_t),
        /*TST_Expected_output_data for enc Input data for decrypt*/
        {0xb9,0x5f,0x3e,0x08,0xc9,0x7a,0xd5,0x82,0x60,0xd1,0xc9,0xe0,0xab,0x06,0x54,0xcf,
        0x57,0x63,0x8d,0x43,0xeb,0x20,0x72,0xff,0x1f,0x1c,0x85,0x13,0x86,0x87,0x79,0x39,
        0x46,0x75,0xc0,0xbc,0x18,0xd8,0x1c,0x27,0x92,0x0c,0x6e,0xde,0xd7,0x56,0x7b,0x59,
        0x50,0xa0,0x5b,0x90,0x18,0x6e,0xaf,0xb4,0x31,0xf4,0x23,0xe3,0x28,0xbb,0xa5,0xf4,
        0xc7,0x56,0x63,0xd0,0xe2,0xce,0xe8,0x7d,0x10,0xe5,0x96,0xcb,0x23,0xab,0x73,0xb0,
        0x21,0xb1,0x08,0xda,0x8a,0x66,0x97,0xdc,0xa2,0x3f,0xe0,0x36,0x57,0x99,0xfa,0x33,
        0xf4,0x67,0xad,0xd9,0xf0,0x46,0xc1,0xbd,0x4d,0x84,0x0b,0x35,0xf3,0xdd,0x0f,0x36,
        0xda,0x37,0xc2,0x4c,0x40,0x6d,0xb6,0xb7,0x84,0xc7,0xa3,0x3e,0x8e,0x73,0xc7,0x35,
        0xe0,0xc6,0x53,0x22,0xdf,0x3c,0x42,0xf3,0x62,0xfe,0x83,0x1c,0x77,0x60,0xba,0x57,
        0x05,0x55,0x4f,0x77,0xc6,0x58,0xb4,0xfb,0x05,0x7d,0xef,0x68,0xfb,0xf0,0x02,0x35,
        0x44,0x7e,0x95,0xd0,0x2c,0x34,0x03,0x73,0x8d,0xb9,0x71,0xa8,0xa8,0x0c,0x3d,0x26,
        0xcf,0x4c,0xcd,0xeb,0x78,0xe2,0x16,0x8a,0x2c,0xb4,0x12,0x86,0x95,0xbd,0xd6,0x77,
        0xc1,0x1d,0x45,0x6f,0x4d,0xac,0xb7,0xe8,0x62,0x37,0x65,0x48,0xd1,0xbf,0x94,0x29,
        0x03,0xfc,0x02,0xbb,0x74,0xfb,0x47,0x25,0x47,0x54,0x34,0x58,0x30,0xce,0x08,0x63,
        0x8b,0x56,0x7e,0x58,0x30,0x8b,0x8c,0xe1,0xe1,0x53,0xdd,0xe6,0xab,0xa2,0x86,0x43,
        0x8e,0xd9,0x36,0xd7,0xd4,0x46,0xf2,0x32,0xd1,0x09,0x33,0xd5,0x7f,0x69,0x26,0xe4,
        0xb6,0xf0,0xbc,0x16,0x7c,0xe7,0xe3,0x7c,0xe5,0x65,0x35,0xbd,0x22,0x2d,0xc2,0x0f,
        0x46,0x9e,0xad,0x47,0x47,0xff,0x96,0x94,0xa8,0xdf,0xaf,0x28,0x75,0x28,0x35,0xf9,
        0x64,0x8e,0xb0,0x38,0xfd,0xe9,0x0e,0xd9,0x9c,0x7e,0xff,0xf3,0x10,0x88,0x7f,0xe4,
        0x5c,0xf6,0x8b,0xb2,0xcf,0x71,0xb0,0x0a,0xc3,0xc3,0xbc,0xf0,0x96,0xf5,0x7d,0x8f,
        0x25,0x21,0xd9,0x97,0xae,0x52,0xb3,0x1f,0x26,0x4c,0x3d,0xe5,0x0d,0xfb,0x1a,0xde,
        0x70,0xd4,0x1f,0x4d,0x30,0x3b,0xb2,0xd6,0x8f,0xed,0xf8,0xb7,0x1d,0xb5,0x5d,0x3f,
        0x96,0xc2,0x29,0x1f,0x3e,0x53,0x9d,0x3d,0xd8,0x8b,0x97,0xeb,0xd8,0x44,0x16,0xe2,
        0x7c,0x07,0x6a,0xc0,0x4b,0x57,0xad,0xd5,0x44,0xf8,0x47,0xd9,0xb8,0x0c,0x86,0xfd,
        0x53,0x02,0x0f,0x58,0xae,0x8a,0xd2,0x80,0x43,0x18,0xbd,0x77,0x3e,0x29,0x15,0x1e,
        0x2a,0x7a,0x4f,0xbd,0x68,0xe4,0x87,0x78,0x6e,0x7a,0xec,0x4d,0x67,0x2e,0x9f,0x30,
        0xeb,0xd5,0x0e,0x0d,0xca,0x1d,0x1f,0x8e,0x8b,0x0e,0x81,0x19,0xd1,0x91,0xd1,0x4c,
        0x3f,0x1b,0xe0,0xb0,0xbe,0x78,0x8b,0x29,0xcc,0xf3,0xf7,0x13,0xa2,0xbb,0x9b,0x3e,
        0xdb,0xd9,0x81,0xf7,0x39,0xba,0x3c,0xb2,0x79,0xd0,0x51,0xd9,0x81,0x8b,0x27,0x9d,
        0x8b,0x2d,0x8d,0xf5,0x7a,0xf1,0xc4,0x8a,0xce,0x4e,0x95,0x3b,0x66,0x66,0xd6,0xe2,
        0x1a,0x5f,0x7d,0x31,0x00,0x4f,0xfa,0xc8,0x0c,0x67,0x7e,0xb2,0x4a,0xbf,0x6e,0x39,
        0xd3,0xcb,0xd2,0x3f,0x52,0x99,0x14,0xd9,0xc9,0xdd,0x5f,0x6d,0xf3,0x25,0x3d,0x1f,
        0xcb,0xca,0xf0,0x6c,0x39,0x38,0x45,0x2d},     
    },
    #endif
    #if TST_USE_AES_192_KEY
    #if TST_USE_AES_16BYTE_DATA
    { 
        {"Acceptance test - AES/KeyWrap/192Key/16ByteData "},
        /*TST_Key*/
        {0xc6,0x01,0x6a,0x95,0xcf,0x1f,0xa7,0x52,0x7d,0xa9,0x8c,0x5d,0x71,0xce,0x58,0x86,
         0x8c,0xfb,0x98,0xba,0x56,0xab,0xa5,0x7a},
        CRYS_AES_Key192BitSize,
        /*TST_input_data*/
        {0xf7,0xe6,0xf3,0x72,0x74,0xa1,0x72,0x24,0x0b,0x0f,0xc9,0x7e,0x25,0x8b,0x37,0xce},
        /*TST_InputDataSize*/
        16*sizeof(DxUint8_t),
        /*TST_WrapdData*/
        {0},
        /*TST_WrapdDataSize*/
        (16+TST_KEYWRAP_IV_SIZE_IN_BYTES)*sizeof(DxUint8_t),
        /*TST_Expected_output_data for enc Input data for decrypt*/
        {0xfd,0xaf,0xff,0x84,0x5c,0x48,0x65,0x38,0x60,0xb1,0x9a,0x0b,0xc3,0x56,0x98,0x17,
         0x43,0xc8,0x89,0x8c,0xad,0x1b,0x5e,0x23}, 
        /*TST_dataSize*/       
    },
    #endif
    #if TST_USE_AES_32BYTE_DATA
    { 
        {"Acceptance test - AES/KeyWrap/192Key/32ByteData "},
        /*TST_Key*/
        {0xc6,0x01,0x6a,0x95,0xcf,0x1f,0xa7,0x52,0x7d,0xa9,0x8c,0x5d,0x71,0xce,0x58,0x86,
         0x8c,0xfb,0x98,0xba,0x56,0xab,0xa5,0x7a},
        CRYS_AES_Key192BitSize,
        /*TST_input_data*/
        {0xe2,0x3d,0x78,0xd6,0xbd,0x71,0xcf,0x38,0xa3,0xdb,0x79,0xbf,0xb6,0xe8,0xbf,0xe9,
         0x8f,0x9e,0x1e,0x83,0xd2,0xdd,0x88,0x12,0x05,0xe5,0xcc,0x72,0xa2,0x19,0x52,0xbd},
        /*TST_InputDataSize*/
        32*sizeof(DxUint8_t),
        /*TST_WrapdData*/
        {0},
        /*TST_WrapdDataSize*/
        (32+TST_KEYWRAP_IV_SIZE_IN_BYTES)*sizeof(DxUint8_t),
        /*TST_Expected_output_data for enc Input data for decrypt*/
        {0x72,0xa3,0x2d,0x6a,0x88,0x21,0x56,0x71,0x3c,0x33,0x96,0x77,0x48,0xd1,0xd8,0xa6,
         0xf6,0xf9,0xa2,0x28,0xe8,0x6a,0xdf,0x3a,0xcd,0x17,0x29,0xcf,0x4f,0xbb,0xeb,0xdd,
         0x4f,0x05,0x98,0x3e,0x8c,0x87,0x9b,0x76},  
    },
    #endif
    #if TST_USE_AES_512BYTE_DATA
    { 
        {"Acceptance test - AES/KeyWrap/192Key/512ByteData "},
        /*TST_Key*/
        {0xc6,0x01,0x6a,0x95,0xcf,0x1f,0xa7,0x52,0x7d,0xa9,0x8c,0x5d,0x71,0xce,0x58,0x86,
         0x8c,0xfb,0x98,0xba,0x56,0xab,0xa5,0x7a},
        CRYS_AES_Key192BitSize,
        /*TST_input_data*/
        {0x8a,0xd5,0x4c,0x91,0xb7,0x94,0x7c,0xfc,0xc4,0xc2,0x38,0x37,0x02,0x79,0x01,0x53,
        0x90,0x6d,0x8c,0xba,0x7e,0x7c,0x0e,0x64,0x32,0x87,0xb7,0x4d,0x0b,0x81,0x7c,0x26,
        0x45,0xc5,0x1a,0x4a,0x1d,0xad,0x58,0xf5,0x35,0x60,0x8c,0xb0,0x39,0xeb,0x60,0x10,
        0xc3,0x94,0xd6,0xa0,0x7c,0x6a,0x8a,0x1c,0x85,0x21,0x38,0xe0,0x15,0x1d,0x7d,0x9f,
        0x63,0xcd,0xe2,0x58,0xc6,0x3a,0x16,0x86,0x1a,0xe0,0x7b,0x98,0x67,0xbc,0xe4,0xa0,
        0xbd,0xa6,0x9e,0x4f,0x62,0xe1,0xad,0x21,0x30,0xf1,0x57,0xd5,0x38,0xac,0xe7,0x20,
        0xab,0x94,0xab,0xa2,0xfb,0x64,0x3f,0x19,0x3d,0xe9,0x0d,0xd5,0xd2,0x13,0x15,0x6c,
        0x46,0x4c,0xea,0xae,0x78,0x08,0xfd,0xdb,0xfb,0x9e,0x1e,0x14,0xbd,0x56,0x40,0x10,
        0xe6,0xc3,0x7d,0x10,0x03,0x53,0x5a,0x15,0x64,0x24,0x4b,0x50,0xc2,0x19,0x7a,0xda,
        0x26,0x2e,0xc4,0xa5,0x05,0x08,0x04,0xb3,0xb0,0xd1,0x95,0x85,0xec,0x42,0x12,0xd7,
        0xdc,0x01,0x60,0x8a,0x28,0x2e,0xef,0xe2,0x58,0x38,0x3c,0xf1,0x81,0xf6,0x9b,0x53,
        0x24,0xf3,0x33,0x1c,0x53,0x09,0x4a,0x0f,0x15,0x31,0xc3,0x11,0x0c,0x99,0xe4,0xdd,
        0x55,0xf7,0x5d,0xf8,0xb0,0x1e,0x86,0xe8,0xe1,0xce,0xe9,0xa1,0x56,0xd1,0x00,0x40,
        0x09,0x43,0x40,0xfb,0xa8,0x32,0x56,0x58,0xf4,0x67,0xb0,0x9e,0x67,0x82,0x3f,0x89,
        0x19,0x4d,0x7b,0x42,0xe4,0x4a,0xa8,0x8e,0xc6,0x8e,0x58,0x46,0x88,0xd2,0x32,0x07,
        0x9d,0xc8,0xf1,0x2a,0x4d,0xab,0xb0,0xf7,0x13,0x1a,0x64,0x15,0x43,0x26,0xaa,0x45,
        0xef,0xaa,0xc3,0x51,0x0c,0xdb,0xdc,0x3e,0xd1,0x1f,0x93,0xc9,0x60,0x23,0xb8,0x12,
        0xa8,0x27,0x50,0x92,0x8a,0x9d,0xe0,0x52,0x3a,0xf3,0xe8,0x5f,0xe9,0xad,0xad,0x79,
        0xa1,0xb6,0x3b,0x0b,0x70,0xf8,0xab,0x60,0xc8,0x2a,0xa2,0x13,0x26,0xe9,0x1a,0xc7,
        0xf2,0x0b,0x65,0x19,0xa6,0x30,0x6e,0xd3,0x33,0x99,0x43,0x62,0xa1,0x3e,0xd0,0x8b,
        0xf5,0x1a,0xed,0x59,0x57,0xca,0x9c,0x5a,0x74,0x56,0x8b,0x0b,0x22,0x4f,0xe1,0x90,
        0x42,0x1a,0x37,0xa8,0xeb,0x8b,0xe3,0xe1,0xc5,0xb6,0x7d,0x08,0xb2,0x01,0x9c,0xe4,
        0xb4,0x7e,0xe1,0x24,0x0b,0x78,0x37,0x95,0x9d,0x4c,0x58,0x98,0x9b,0x7a,0x94,0xd4,
        0x62,0xfc,0xce,0x28,0x9f,0xd7,0xc7,0xe3,0xb7,0xef,0x9f,0x38,0x66,0x1f,0x98,0xec,
        0xa6,0x89,0x1e,0x52,0xd2,0x2b,0x04,0x79,0x0b,0xb4,0x11,0xa4,0xdb,0x95,0xbb,0xfa,
        0x18,0x5a,0x32,0x7f,0x0b,0x3b,0xa0,0x43,0xd2,0xee,0xaf,0xda,0x03,0xc0,0x4d,0x0b,
        0x92,0xe4,0xac,0xcc,0xf5,0x0b,0x8c,0x6f,0x85,0x35,0xbc,0x16,0x28,0xc6,0xde,0x6c,
        0x2d,0xdc,0x6c,0x97,0x77,0xe0,0xf8,0x68,0xde,0x5b,0xb8,0xd5,0xd2,0x0b,0x41,0xaa,
        0x41,0x37,0x93,0x7b,0xbb,0x3f,0x56,0xdd,0xd5,0x77,0x63,0xd6,0xcb,0x35,0x86,0x91,
        0x69,0x29,0x82,0x56,0x2b,0xed,0x56,0xba,0xa3,0xdd,0xbf,0x13,0x1b,0x29,0xfe,0x2f,
        0x7c,0x29,0xdb,0x46,0x6e,0xf0,0xea,0x2c,0xc1,0x23,0x0d,0xcb,0x0c,0x0c,0x3a,0xd1,
        0x93,0xea,0x7f,0xa6,0x6e,0x8b,0x43,0xa1,0xe8,0x1d,0xce,0x7b,0x26,0x42,0x0c,0x04},
        /*TST_InputDataSize*/
        512*sizeof(DxUint8_t),
        /*TST_WrapdData*/
        {0},
        /*TST_WrapdDataSize*/
        512*sizeof(DxUint8_t)+TST_KEYWRAP_IV_SIZE_IN_BYTES,
        /*TST_Expected_output_data for enc Input data for decrypt*/
        {0x7a,0x2f,0x97,0xb3,0xa0,0x42,0xfb,0x8c,0xf8,0x8f,0xe7,0x41,0x21,0xc1,0x75,0x36,
        0x66,0xbe,0x11,0x98,0x69,0xeb,0x7e,0x5b,0x58,0x56,0x54,0x67,0xdf,0x58,0x61,0xa8,
        0x90,0xb0,0xe0,0xf8,0xcf,0x6d,0xa0,0xf0,0x6c,0xde,0xf6,0xde,0xbf,0xd4,0xae,0x60,
        0xe7,0xdd,0x5a,0x78,0x90,0x18,0x4d,0x2b,0x1c,0xd7,0x7f,0x66,0x6e,0xe9,0x31,0x91,
        0x74,0x84,0x02,0xff,0x75,0x71,0xb3,0x5f,0xfb,0x4a,0x17,0x32,0x1a,0xa9,0x68,0xa2,
        0x2e,0x37,0xa4,0xf3,0xd3,0x58,0x8c,0x24,0x72,0xdd,0xd5,0x64,0xff,0x27,0x56,0xd5,
        0xa8,0x04,0xff,0x42,0xa8,0x0e,0xf5,0xec,0x81,0x30,0xc3,0x25,0xf3,0x39,0x7b,0x1f,
        0x6d,0xaa,0xcf,0xa0,0x18,0x8e,0x96,0x66,0x65,0x14,0xc5,0xc5,0x4f,0x3c,0x6f,0xe7,
        0x91,0x09,0x56,0x1a,0xec,0x4c,0xc5,0x7e,0x66,0x44,0x14,0x8e,0xf3,0x6d,0x74,0x02,
        0x5c,0x2e,0xfa,0x53,0x10,0x55,0x10,0x66,0x4d,0x05,0xfe,0x34,0x35,0x45,0x0b,0x37,
        0xa1,0x28,0xe7,0xd6,0xd9,0xdf,0xc8,0x22,0xde,0x8a,0x52,0xe2,0x0c,0xf8,0xf3,0xf9,
        0x6d,0x79,0xb9,0xcb,0xb3,0xc7,0x63,0x77,0x07,0xe4,0x5c,0xd0,0xe6,0x6d,0xdc,0xe1,
        0x50,0x68,0x97,0xd6,0xd1,0x11,0x00,0x44,0x3a,0x4b,0x58,0x55,0x74,0x85,0xa9,0x4c,
        0x61,0x22,0x7c,0x95,0x1b,0x4f,0x04,0x66,0x00,0x0f,0x68,0x4f,0x3c,0x8d,0x00,0xb5,
        0x46,0x66,0xd9,0x2d,0xfd,0xf2,0x7b,0xbb,0xad,0xb0,0x78,0xf1,0x75,0x5d,0x9c,0xc3,
        0xc1,0x14,0x8d,0x16,0x58,0xf8,0xd0,0x94,0x1d,0x94,0x3c,0xb0,0xa1,0x16,0x70,0xad,
        0xbc,0x88,0xa7,0xf6,0xd9,0xb2,0xa0,0x02,0x6e,0x95,0xd5,0x1e,0x6a,0x40,0xea,0xac,
        0xfb,0xaf,0xe3,0x65,0xba,0x88,0x1f,0x36,0xb5,0xcb,0x30,0x33,0x72,0xe1,0x53,0xda,
        0x7f,0x7b,0x47,0x09,0xa0,0xf4,0x56,0x42,0x75,0x3a,0x50,0x8d,0x25,0x87,0x7c,0xd5,
        0xea,0x99,0x8c,0x9d,0x8f,0xcb,0x56,0x24,0x27,0x65,0x2f,0xa8,0x6e,0x92,0xf8,0x06,
        0xd6,0x35,0x77,0x16,0x04,0xd9,0xbb,0x9d,0x20,0xf2,0x2d,0xd3,0xdd,0xd3,0x40,0xe3,
        0x57,0x6b,0x8f,0xcb,0x5d,0x71,0x6f,0x89,0xcf,0x2f,0x03,0x9a,0xcf,0x57,0x6d,0x4d,
        0xc0,0x31,0x07,0xa2,0xb0,0x3a,0x78,0x73,0xe5,0x34,0x75,0xf5,0x66,0x5f,0x09,0xf9,
        0x04,0x17,0x83,0x30,0xac,0x86,0x6c,0x4e,0x6f,0x1f,0xda,0xbd,0x24,0x56,0x60,0x1b,
        0xe6,0x4d,0x29,0x1b,0xa3,0x59,0x65,0xc6,0x1c,0xfe,0xe1,0x8f,0x48,0x32,0xa3,0x22,
        0x9d,0x0b,0x64,0xe5,0xe5,0xda,0x71,0x9e,0x91,0x80,0xfd,0x72,0xd6,0x8c,0xae,0xe3,
        0xac,0x2e,0xe4,0x01,0xb4,0x06,0x2e,0x9f,0xd5,0x5f,0x3d,0x61,0xea,0x89,0xa8,0x3b,
        0xea,0x03,0x22,0x88,0x86,0xd3,0x22,0x4e,0xfc,0x95,0xda,0x52,0xba,0x8c,0xe8,0xe5,
        0xa0,0xd6,0xbe,0xd6,0x06,0x15,0xf0,0x04,0x04,0xfa,0x89,0xd8,0x8f,0xd6,0xc0,0x21,
        0xce,0x0e,0x47,0x8f,0x6c,0x55,0xf1,0xdb,0x6a,0x87,0x18,0x6a,0x76,0x63,0x79,0x5a,
        0x16,0xe0,0x74,0x44,0x1e,0x53,0x5f,0xc0,0xe2,0x9d,0x69,0x87,0x48,0xea,0x63,0x35,
        0xf3,0xa8,0x36,0xba,0xa1,0x11,0xf7,0x8f,0x6b,0x5d,0x0d,0x31,0x91,0xd9,0x47,0xfe,
        0xe4,0xf1,0x2a,0x2d,0x02,0xe7,0xe6,0xc6},       
    },
    #endif
    #endif
    #if TST_USE_AES_256_KEY
    #if TST_USE_AES_16BYTE_DATA
    { 
        {"Acceptance test - AES/KeyWrap/256Key/16ByteData "},
        /*TST_Key*/
        {0x87,0x8d,0x60,0xe6,0x46,0x83,0x22,0xee,0x7b,0x32,0x63,0x83,0xff,0x26,0x50,0xa6,
         0x18,0x94,0x14,0x68,0xe5,0x36,0x59,0x5c,0xfc,0x55,0x0c,0x4c,0x51,0x28,0x61,0x2b},
        CRYS_AES_Key256BitSize,
        /*TST_input_data*/
        {0xf7,0xe6,0xf3,0x72,0x74,0xa1,0x72,0x24,0x0b,0x0f,0xc9,0x7e,0x25,0x8b,0x37,0xce},
        /*TST_InputDataSize*/
        16*sizeof(DxUint8_t),
        /*TST_WrapdData*/
        {0},
        /*TST_WrapdDataSize*/
        (16+TST_KEYWRAP_IV_SIZE_IN_BYTES)*sizeof(DxUint8_t),
        /*TST_Expected_output_data for enc Input data for decrypt*/
        {0x02,0x87,0x75,0x9b,0xe4,0x33,0x91,0x61,0x4f,0xca,0xf7,0xa6,0x84,0x49,0xb7,0x42,
         0x83,0x0c,0x2b,0x34,0x80,0xd7,0x1b,0x23},       
    },
    #endif
    #if TST_USE_AES_32BYTE_DATA
    { 
        {"Acceptance test - AES/KeyWrap/256Key/32ByteData "},
        /*TST_Key*/
        {0x87,0x8d,0x60,0xe6,0x46,0x83,0x22,0xee,0x7b,0x32,0x63,0x83,0xff,0x26,0x50,0xa6,
         0x18,0x94,0x14,0x68,0xe5,0x36,0x59,0x5c,0xfc,0x55,0x0c,0x4c,0x51,0x28,0x61,0x2b},
        CRYS_AES_Key256BitSize,
        /*TST_input_data*/
        {0xe2,0x3d,0x78,0xd6,0xbd,0x71,0xcf,0x38,0xa3,0xdb,0x79,0xbf,0xb6,0xe8,0xbf,0xe9,
         0x8f,0x9e,0x1e,0x83,0xd2,0xdd,0x88,0x12,0x05,0xe5,0xcc,0x72,0xa2,0x19,0x52,0xbd},
        /*TST_InputDataSize*/
        32*sizeof(DxUint8_t),
        /*TST_WrapdData*/
        {0},
        /*TST_WrapdDataSize*/
        (32+TST_KEYWRAP_IV_SIZE_IN_BYTES)*sizeof(DxUint8_t),
        /*TST_Expected_output_data for enc Input data for decrypt*/
        {0x1b,0x37,0xdd,0x33,0xff,0xf2,0x66,0x17,0x03,0x53,0x9a,0x78,0x7f,0xfc,0x21,0xae,
         0xde,0x2c,0x23,0x6e,0x7e,0x3c,0xa3,0x66,0xa8,0x8d,0x0e,0x4c,0x4e,0x4f,0x63,0x7e,
         0xb2,0x09,0x67,0xc8,0x28,0x81,0x08,0x57},      
    },
    #endif
    #if TST_USE_AES_512BYTE_DATA
    { 
        {"Acceptance test - AES/KeyWrap/256Key/512ByteData "},
        /*TST_Key*/
        {0x87,0x8d,0x60,0xe6,0x46,0x83,0x22,0xee,0x7b,0x32,0x63,0x83,0xff,0x26,0x50,0xa6,
         0x18,0x94,0x14,0x68,0xe5,0x36,0x59,0x5c,0xfc,0x55,0x0c,0x4c,0x51,0x28,0x61,0x2b},
        CRYS_AES_Key256BitSize,
        /*TST_input_data*/
        {0x8a,0xd5,0x4c,0x91,0xb7,0x94,0x7c,0xfc,0xc4,0xc2,0x38,0x37,0x02,0x79,0x01,0x53,
        0x90,0x6d,0x8c,0xba,0x7e,0x7c,0x0e,0x64,0x32,0x87,0xb7,0x4d,0x0b,0x81,0x7c,0x26,
        0x45,0xc5,0x1a,0x4a,0x1d,0xad,0x58,0xf5,0x35,0x60,0x8c,0xb0,0x39,0xeb,0x60,0x10,
        0xc3,0x94,0xd6,0xa0,0x7c,0x6a,0x8a,0x1c,0x85,0x21,0x38,0xe0,0x15,0x1d,0x7d,0x9f,
        0x63,0xcd,0xe2,0x58,0xc6,0x3a,0x16,0x86,0x1a,0xe0,0x7b,0x98,0x67,0xbc,0xe4,0xa0,
        0xbd,0xa6,0x9e,0x4f,0x62,0xe1,0xad,0x21,0x30,0xf1,0x57,0xd5,0x38,0xac,0xe7,0x20,
        0xab,0x94,0xab,0xa2,0xfb,0x64,0x3f,0x19,0x3d,0xe9,0x0d,0xd5,0xd2,0x13,0x15,0x6c,
        0x46,0x4c,0xea,0xae,0x78,0x08,0xfd,0xdb,0xfb,0x9e,0x1e,0x14,0xbd,0x56,0x40,0x10,
        0xe6,0xc3,0x7d,0x10,0x03,0x53,0x5a,0x15,0x64,0x24,0x4b,0x50,0xc2,0x19,0x7a,0xda,
        0x26,0x2e,0xc4,0xa5,0x05,0x08,0x04,0xb3,0xb0,0xd1,0x95,0x85,0xec,0x42,0x12,0xd7,
        0xdc,0x01,0x60,0x8a,0x28,0x2e,0xef,0xe2,0x58,0x38,0x3c,0xf1,0x81,0xf6,0x9b,0x53,
        0x24,0xf3,0x33,0x1c,0x53,0x09,0x4a,0x0f,0x15,0x31,0xc3,0x11,0x0c,0x99,0xe4,0xdd,
        0x55,0xf7,0x5d,0xf8,0xb0,0x1e,0x86,0xe8,0xe1,0xce,0xe9,0xa1,0x56,0xd1,0x00,0x40,
        0x09,0x43,0x40,0xfb,0xa8,0x32,0x56,0x58,0xf4,0x67,0xb0,0x9e,0x67,0x82,0x3f,0x89,
        0x19,0x4d,0x7b,0x42,0xe4,0x4a,0xa8,0x8e,0xc6,0x8e,0x58,0x46,0x88,0xd2,0x32,0x07,
        0x9d,0xc8,0xf1,0x2a,0x4d,0xab,0xb0,0xf7,0x13,0x1a,0x64,0x15,0x43,0x26,0xaa,0x45,
        0xef,0xaa,0xc3,0x51,0x0c,0xdb,0xdc,0x3e,0xd1,0x1f,0x93,0xc9,0x60,0x23,0xb8,0x12,
        0xa8,0x27,0x50,0x92,0x8a,0x9d,0xe0,0x52,0x3a,0xf3,0xe8,0x5f,0xe9,0xad,0xad,0x79,
        0xa1,0xb6,0x3b,0x0b,0x70,0xf8,0xab,0x60,0xc8,0x2a,0xa2,0x13,0x26,0xe9,0x1a,0xc7,
        0xf2,0x0b,0x65,0x19,0xa6,0x30,0x6e,0xd3,0x33,0x99,0x43,0x62,0xa1,0x3e,0xd0,0x8b,
        0xf5,0x1a,0xed,0x59,0x57,0xca,0x9c,0x5a,0x74,0x56,0x8b,0x0b,0x22,0x4f,0xe1,0x90,
        0x42,0x1a,0x37,0xa8,0xeb,0x8b,0xe3,0xe1,0xc5,0xb6,0x7d,0x08,0xb2,0x01,0x9c,0xe4,
        0xb4,0x7e,0xe1,0x24,0x0b,0x78,0x37,0x95,0x9d,0x4c,0x58,0x98,0x9b,0x7a,0x94,0xd4,
        0x62,0xfc,0xce,0x28,0x9f,0xd7,0xc7,0xe3,0xb7,0xef,0x9f,0x38,0x66,0x1f,0x98,0xec,
        0xa6,0x89,0x1e,0x52,0xd2,0x2b,0x04,0x79,0x0b,0xb4,0x11,0xa4,0xdb,0x95,0xbb,0xfa,
        0x18,0x5a,0x32,0x7f,0x0b,0x3b,0xa0,0x43,0xd2,0xee,0xaf,0xda,0x03,0xc0,0x4d,0x0b,
        0x92,0xe4,0xac,0xcc,0xf5,0x0b,0x8c,0x6f,0x85,0x35,0xbc,0x16,0x28,0xc6,0xde,0x6c,
        0x2d,0xdc,0x6c,0x97,0x77,0xe0,0xf8,0x68,0xde,0x5b,0xb8,0xd5,0xd2,0x0b,0x41,0xaa,
        0x41,0x37,0x93,0x7b,0xbb,0x3f,0x56,0xdd,0xd5,0x77,0x63,0xd6,0xcb,0x35,0x86,0x91,
        0x69,0x29,0x82,0x56,0x2b,0xed,0x56,0xba,0xa3,0xdd,0xbf,0x13,0x1b,0x29,0xfe,0x2f,
        0x7c,0x29,0xdb,0x46,0x6e,0xf0,0xea,0x2c,0xc1,0x23,0x0d,0xcb,0x0c,0x0c,0x3a,0xd1,
        0x93,0xea,0x7f,0xa6,0x6e,0x8b,0x43,0xa1,0xe8,0x1d,0xce,0x7b,0x26,0x42,0x0c,0x04},
        /*TST_InputDataSize*/
        512*sizeof(DxUint8_t),
        /*TST_WrapdData*/
        {0},
        /*TST_WrapdDataSize*/
        (512+TST_KEYWRAP_IV_SIZE_IN_BYTES)*sizeof(DxUint8_t),
        /*TST_Expected_output_data for enc Input data for decrypt*/
        {0xbc,0x6d,0x33,0xdf,0x51,0x7a,0x40,0x91,0x06,0xfd,0x02,0x56,0xf1,0xca,0x31,0x72,
         0x6c,0xf8,0x4d,0x98,0x2c,0xf5,0xef,0xef,0xa2,0xa6,0x64,0x4e,0x34,0xc9,0x02,0x23,
         0xc1,0x88,0x75,0xd1,0xe0,0x15,0x73,0xc3,0xb3,0x78,0x0b,0x97,0xc1,0x01,0xe4,0xac,
         0x99,0x5d,0xca,0x8a,0x32,0xa8,0xef,0x17,0x41,0x38,0x82,0xa0,0x77,0xfb,0xa4,0x77,
         0x06,0x88,0xd2,0xc1,0x31,0x4a,0xd5,0xed,0xcf,0x0f,0x13,0x05,0x93,0xa8,0x94,0xbf,
         0xb7,0x34,0xeb,0x84,0x18,0xe4,0x41,0xb1,0x6e,0x79,0x14,0x5d,0xe6,0x73,0x29,0x6b,
         0x6e,0xe9,0x5d,0x08,0x27,0x98,0xd6,0x4f,0x73,0x43,0x65,0xa7,0x74,0xc5,0x82,0x60,
         0x3d,0x11,0xbe,0x22,0x8b,0xa2,0x5a,0xe9,0x2c,0x83,0xc0,0x1c,0x18,0x0f,0x2d,0x13,
         0x34,0x88,0xd3,0x25,0xae,0xc7,0x02,0x9e,0x2d,0xc7,0xe6,0xc7,0x99,0x51,0xe9,0x78,
         0x2e,0x0b,0x46,0xe1,0x3a,0xeb,0x98,0x64,0x12,0x17,0xf3,0x4c,0x5c,0xf2,0xac,0x40,
         0x7a,0x57,0xe0,0x3d,0x04,0x37,0x4d,0xa5,0x3c,0x5e,0x37,0x2c,0xbb,0x2a,0x05,0x3a,
         0x33,0x73,0x1c,0x01,0x84,0x01,0xb8,0xc2,0x5e,0xc1,0xd2,0xc0,0x6b,0x8d,0x44,0xd5,
         0xf8,0x6f,0xc2,0xf5,0x63,0x67,0xad,0x6f,0x98,0x71,0xa2,0x61,0x1b,0x62,0xdd,0xf8,
         0x9d,0x55,0x54,0xc6,0x43,0xd7,0x26,0xc5,0xb8,0x65,0x79,0xf9,0xef,0xe4,0x9f,0xa2,
         0x4c,0xbc,0xf3,0x63,0x08,0x36,0xba,0x9a,0x13,0x97,0x6b,0xd0,0xe0,0xfd,0x9a,0xfc,
         0x88,0x83,0x56,0x6b,0xcc,0xf4,0x69,0x73,0x1b,0x78,0x87,0x2a,0x40,0xc2,0x90,0x67,
         0xed,0xf6,0x1d,0x66,0xf4,0xed,0xe0,0xb1,0xc6,0x47,0xd3,0x5f,0x1b,0xd2,0x53,0x47,
         0x2d,0x92,0xbc,0xb2,0x95,0x39,0xe3,0x8b,0x68,0x99,0x90,0x29,0x24,0x08,0xc7,0xb4,
         0x26,0x12,0x46,0xe9,0x6a,0x84,0xcc,0x4e,0x7c,0xb1,0x41,0x45,0xb9,0x5d,0x88,0x66,
         0xd4,0x01,0x0f,0x7d,0xdf,0xa7,0x4a,0x9f,0x90,0x57,0x7b,0x6a,0x82,0x29,0x89,0x2e,
         0x5b,0xa2,0xab,0xfc,0xdc,0xa5,0xba,0x72,0x32,0x03,0xa0,0xef,0xce,0x03,0x37,0x7a,
         0x20,0x3f,0x2d,0x11,0xf1,0x9a,0x24,0x9d,0x23,0x2f,0x09,0xe4,0x3b,0xe9,0x85,0xdb,
         0x89,0xb2,0x09,0x63,0x27,0xa2,0xd7,0x19,0xe3,0x60,0x8f,0xd8,0xf5,0xb3,0x22,0x4b,
         0x4f,0x57,0x05,0x0f,0x8e,0x36,0xff,0x63,0x0f,0x0a,0xfe,0x7a,0x16,0xfa,0x95,0x31,
         0x47,0xcb,0xad,0xcc,0x1c,0x51,0xba,0x1f,0x7d,0x48,0xe4,0xb8,0xf7,0x8e,0x49,0x0c,
         0x90,0x48,0x50,0xf9,0xb8,0xb4,0xe5,0xc0,0xb3,0x84,0xde,0x8b,0xb4,0x97,0x4f,0xeb,
         0x1a,0x89,0x1e,0xc8,0xc0,0x94,0x7d,0x01,0xcf,0x0c,0x2c,0x61,0x05,0x10,0x42,0xcb,
         0x29,0x1e,0x1c,0xc3,0x63,0xc3,0xe7,0x1b,0x12,0xf5,0xb5,0xfd,0xbf,0x7a,0xe6,0xa0,
         0x35,0xa4,0xa5,0x51,0x1f,0xb5,0x78,0x00,0x9e,0xa7,0x4e,0x5a,0x15,0xa0,0x57,0x5c,
         0x69,0x2c,0x0d,0x1a,0xf2,0x7c,0x88,0x9a,0x60,0xc1,0x61,0x8e,0x26,0xed,0x8d,0x6d,
         0x7e,0x4b,0x28,0x6e,0xd2,0x58,0xcf,0x32,0x26,0x56,0xbb,0xfa,0x8a,0x86,0x16,0x1d,
         0x33,0xbc,0xff,0xef,0x1d,0xe1,0xd9,0x2f,0x6d,0x85,0xe0,0x07,0x2b,0xd6,0xf4,0x03,
         0xc1,0x05,0x80,0x56,0xa4,0xba,0x18,0x25},       
    },
    #endif 
    #endif
};
#endif

/***********************************************************************/
/**************** AES XTS data *****************************************/
/***********************************************************************/
TST_AES_XTS_TestDataStruct TST_AES_XTS_Acceptance_TestData[] =
{
	/**********************************/
	/*        AES XTS vectors         */
	/**********************************/
#if TST_USE_AES_256_KEY
#if TST_USE_AES_16BYTE_DATA
	{ 
		{"Acceptance test - AES/XTS/256Key/16ByteData "},
		/*TST_Key*/     
		{0x60,0x3d,0xeb,0x10,0x15,0xca,0x71,0xbe,0x2b,0x73,0xae,0xf0,0x85,0x7d,0x77,0x81, 
		0x1f,0x35,0x2c,0x07,0x3b,0x61,0x08,0xd7,0x2d,0x98,0x10,0xa3,0x09,0x14,0xdf,0xf4},
		CRYS_AES_Key256BitSize,
		/*TST_Tweak*/       
		{0},
		/*TST_input_data*/
		{0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a},
		/*TST_output_data*/
		{0},
		/*TST_Expected_output_data for enc Input data for decrypt*/
		{0x9b,0xd4,0xf6,0x26,0x1c,0x7f,0xf1,0x73,0x42,0x42,0x16,0xb2,0x72,0x5e,0x50,0x8f}, 
		/*TST_dataSize*/
		16*sizeof(DxUint8_t),       
		/*TST_FinishInputData*/
		{0},
		/*TST_FinishOutputData*/
		{0},
		/*TST_FinishExpectedOutputData*/
		{0},
		/*TST_FinishInputDataSize*/
		0
	},
#endif 
#if TST_USE_AES_32BYTE_DATA
	{ 
		{"Acceptance test - AES/XTS/256Key/32ByteData "},
		/*TST_Key*/     
		{0x60,0x3d,0xeb,0x10,0x15,0xca,0x71,0xbe,0x2b,0x73,0xae,0xf0,0x85,0x7d,0x77,0x81,
		0x1f,0x35,0x2c,0x07,0x3b,0x61,0x08,0xd7,0x2d,0x98,0x10,0xa3,0x09,0x14,0xdf,0xf4},
		CRYS_AES_Key256BitSize,
		/*TST_Tweak*/       
		{0xd2,0x27,0x1d,0x06,0xdf,0xc9,0x15,0xc7,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
		/*TST_input_data*/
		{0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a,
		0xf3,0xee,0xd1,0xbd,0xb5,0xd2,0xa0,0x3c,0x06,0x4b,0x5a,0x7e,0x3d,0xb1,0x81,0xf8},
		/*TST_output_data*/
		{0},
		/*TST_Expected_output_data for enc Input data for decrypt*/
		{0x2c,0x62,0x70,0xc9,0x27,0xde,0x57,0x47,0xde,0x8d,0x5f,0x65,0xbb,0x79,0xe5,0xa1,
		0x4a,0x2e,0xdd,0x88,0x8f,0x53,0xd6,0x7c,0x50,0x32,0xf2,0xe8,0xda,0x85,0xb3,0x09}, 
		/*TST_dataSize*/
		32*sizeof(DxUint8_t),
		/*TST_FinishInputData*/
		{0},
		/*TST_FinishOutputData*/
		{0},
		/*TST_FinishExpectedOutputData*/
		{0},
		/*TST_FinishInputDataSize*/
		0
	},
#endif
#if TST_USE_AES_64BYTE_DATA
	{ 
		{"Acceptance test - AES/XTS/256Key/64ByteData "},
		/*TST_Key*/     
		{0x60,0x3d,0xeb,0x10,0x15,0xca,0x71,0xbe,0x2b,0x73,0xae,0xf0,0x85,0x7d,0x77,0x81,
		0x1f,0x35,0x2c,0x07,0x3b,0x61,0x08,0xd7,0x2d,0x98,0x10,0xa3,0x09,0x14,0xdf,0xf4},
		CRYS_AES_Key256BitSize,
		/*TST_Tweak*/       
		{0xd2,0x27,0x1d,0x06,0xdf,0xc9,0x15,0xc7,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
		/*TST_input_data*/
		{0x45,0xd3,0x84,0x15,0x6b,0x7c,0x7d,0x90,0x08,0xbc,0xb8,0x2a,0x98,0x2f,0x35,0x71,
		0xc2,0xf2,0x69,0x9a,0x38,0xfe,0x3f,0x73,0xdf,0xb4,0x5d,0x99,0x30,0xb8,0xa8,0xeb,
		0xde,0x03,0x0a,0x3e,0xb8,0x34,0x73,0x53,0xd2,0x27,0x1d,0x06,0xdf,0xc9,0x15,0xc7,
		0xe2,0x2b,0xf7,0x4e,0x06,0xd5,0xf8,0x8b,0xc9,0x5c,0x2a,0xdc,0x60,0x37,0xfc,0x83},
		/*TST_output_data*/
		{0},
		/*TST_Expected_output_data for enc Input data for decrypt*/
		{0x2e,0xd0,0x59,0x6e,0x5a,0x34,0xd0,0xb9,0x30,0x86,0x6d,0x31,0xa0,0xdd,0xda,0xae,
		0xc0,0x5c,0xe8,0xde,0x49,0x0d,0x9e,0x0b,0xff,0x6a,0xf2,0x84,0x1d,0x87,0x5c,0x30,
		0xe4,0xa1,0x8b,0xb7,0x8d,0xc6,0xb0,0x9b,0x6e,0x33,0x74,0x60,0xda,0xbc,0x45,0x9b,
		0x81,0xcd,0x57,0xbd,0x63,0x3f,0x17,0x19,0xfa,0x35,0xb2,0x6f,0xc9,0x87,0x49,0x1c}, 
		/*TST_dataSize*/
		64*sizeof(DxUint8_t), 
		/*TST_FinishInputData*/
		{0xf3,0xee,0xd1,0xbd,0xb5,0xd2,0xa0,0x3c,0x06,0x4b,0x5a,0x7e,0x3d,0xb1,0x81,0xf8,
		0xef,0x15},
		/*TST_FinishOutputData*/
		{0},
		/*TST_FinishExpectedOutputData*/
		{0xcd,0xe1,0x07,0x23,0x77,0xe5,0x20,0x61,0x80,0xe1,0xdf,0xbc,0xe8,0x70,0x68,0xf4,
		0x97,0x77},
		/*TST_FinishInputDataSize*/
		18			
	},
#endif
#if TST_USE_AES_512BYTE_DATA
	{
		{"Acceptance test - AES/XTS/256Key/512ByteData"},
		/*TST_Key*/     
		{0x60,0x3d,0xeb,0x10,0x15,0xca,0x71,0xbe,0x2b,0x73,0xae,0xf0,0x85,0x7d,0x77,0x81,
		0x1f,0x35,0x2c,0x07,0x3b,0x61,0x08,0xd7,0x2d,0x98,0x10,0xa3,0x09,0x14,0xdf,0xf4},                                                                                          
		CRYS_AES_Key256BitSize,
		/*TST_Tweak*/       
		{0xd2,0x27,0x1d,0x06,0xdf,0xc9,0x15,0xc7,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
		/*TST_input_data*/
		{0x30,0xc8,0x1c,0x46,0xa3,0x5c,0xe4,0x11,0xe5,0xfb,0xc1,0x19,0x1a,0x0a,0x52,0xef,
		0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a,
		0x3a,0xd7,0x7b,0xb4,0x0d,0x7a,0x36,0x60,0xa8,0x9e,0xca,0xf3,0x24,0x66,0xef,0x97,
		0xf5,0xd3,0xd5,0x85,0x03,0xb9,0x69,0x9d,0xe7,0x85,0x89,0x5a,0x96,0xfd,0xba,0xaf,
		0x43,0xb1,0xcd,0x7f,0x59,0x8e,0xce,0x23,0x88,0x1b,0x00,0xe3,0xed,0x03,0x06,0x88,
		0x7b,0x0c,0x78,0x5e,0x27,0xe8,0xad,0x3f,0x82,0x23,0x20,0x71,0x04,0x72,0x5d,0xd4,
		0x3a,0xd7,0x7b,0xb4,0x0d,0x7a,0x36,0x60,0xa8,0x9e,0xca,0xf3,0x24,0x66,0xef,0x97,
		0xf5,0xd3,0xd5,0x85,0x03,0xb9,0x69,0x9d,0xe7,0x85,0x89,0x5a,0x96,0xfd,0xba,0xaf,
		0x30,0xc8,0x1c,0x46,0xa3,0x5c,0xe4,0x11,0xe5,0xfb,0xc1,0x19,0x1a,0x0a,0x52,0xef,
		0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a,
		0x3a,0xd7,0x7b,0xb4,0x0d,0x7a,0x36,0x60,0xa8,0x9e,0xca,0xf3,0x24,0x66,0xef,0x97,
		0xf5,0xd3,0xd5,0x85,0x03,0xb9,0x69,0x9d,0xe7,0x85,0x89,0x5a,0x96,0xfd,0xba,0xaf,
		0x43,0xb1,0xcd,0x7f,0x59,0x8e,0xce,0x23,0x88,0x1b,0x00,0xe3,0xed,0x03,0x06,0x88,
		0x7b,0x0c,0x78,0x5e,0x27,0xe8,0xad,0x3f,0x82,0x23,0x20,0x71,0x04,0x72,0x5d,0xd4,
		0x3a,0xd7,0x7b,0xb4,0x0d,0x7a,0x36,0x60,0xa8,0x9e,0xca,0xf3,0x24,0x66,0xef,0x97,
		0xf5,0xd3,0xd5,0x85,0x03,0xb9,0x69,0x9d,0xe7,0x85,0x89,0x5a,0x96,0xfd,0xba,0xaf,
		0x30,0xc8,0x1c,0x46,0xa3,0x5c,0xe4,0x11,0xe5,0xfb,0xc1,0x19,0x1a,0x0a,0x52,0xef,
		0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a,
		0x3a,0xd7,0x7b,0xb4,0x0d,0x7a,0x36,0x60,0xa8,0x9e,0xca,0xf3,0x24,0x66,0xef,0x97,
		0xf5,0xd3,0xd5,0x85,0x03,0xb9,0x69,0x9d,0xe7,0x85,0x89,0x5a,0x96,0xfd,0xba,0xaf,
		0x43,0xb1,0xcd,0x7f,0x59,0x8e,0xce,0x23,0x88,0x1b,0x00,0xe3,0xed,0x03,0x06,0x88,
		0x7b,0x0c,0x78,0x5e,0x27,0xe8,0xad,0x3f,0x82,0x23,0x20,0x71,0x04,0x72,0x5d,0xd4,
		0x3a,0xd7,0x7b,0xb4,0x0d,0x7a,0x36,0x60,0xa8,0x9e,0xca,0xf3,0x24,0x66,0xef,0x97,
		0xf5,0xd3,0xd5,0x85,0x03,0xb9,0x69,0x9d,0xe7,0x85,0x89,0x5a,0x96,0xfd,0xba,0xaf,
		0x30,0xc8,0x1c,0x46,0xa3,0x5c,0xe4,0x11,0xe5,0xfb,0xc1,0x19,0x1a,0x0a,0x52,0xef,
		0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a,
		0x3a,0xd7,0x7b,0xb4,0x0d,0x7a,0x36,0x60,0xa8,0x9e,0xca,0xf3,0x24,0x66,0xef,0x97,
		0xf5,0xd3,0xd5,0x85,0x03,0xb9,0x69,0x9d,0xe7,0x85,0x89,0x5a,0x96,0xfd,0xba,0xaf,
		0x43,0xb1,0xcd,0x7f,0x59,0x8e,0xce,0x23,0x88,0x1b,0x00,0xe3,0xed,0x03,0x06,0x88,
		0x7b,0x0c,0x78,0x5e,0x27,0xe8,0xad,0x3f,0x82,0x23,0x20,0x71,0x04,0x72,0x5d,0xd4,
		0x3a,0xd7,0x7b,0xb4,0x0d,0x7a,0x36,0x60,0xa8,0x9e,0xca,0xf3,0x24,0x66,0xef,0x97,
		0xf5,0xd3,0xd5,0x85,0x03,0xb9,0x69,0x9d,0xe7,0x85,0x89,0x5a,0x96,0xfd,0xba,0xaf},
		/*TST_output_data*/
		{0},
		/*TST_Expected_output_data for enc Input data for decrypt*/
		{0xdf,0xb1,0x8c,0x34,0x0d,0x4c,0x35,0x91,0xce,0x3e,0x0d,0xb2,0xe2,0x53,0xbf,0x9b,
		0xdb,0xa7,0xdb,0x6b,0x04,0x70,0x03,0x5f,0x43,0xa5,0xf9,0x27,0x33,0xe5,0xca,0xbe,
		0x18,0x3d,0x4f,0x42,0x42,0xfc,0x73,0x5c,0xeb,0x17,0x13,0x11,0xd1,0x94,0xc1,0x10,
		0x83,0x86,0xc9,0x1b,0xf8,0xac,0xe3,0xc9,0x84,0x42,0x8f,0x8d,0x5d,0xf6,0x95,0x9f,
		0x59,0x11,0x93,0x16,0x27,0x19,0x8a,0xbe,0x50,0x04,0x50,0x16,0x95,0x81,0xc8,0x9d,
		0x52,0xcf,0x6e,0xd5,0xb2,0x1d,0x01,0x5d,0xce,0x63,0xee,0x41,0xb0,0x4b,0x75,0x9e,
		0x09,0xbe,0xa5,0xe2,0xbe,0x59,0x86,0xbe,0xd3,0xf1,0x96,0xb9,0x62,0x92,0xaf,0x13,
		0x66,0x34,0x49,0xbc,0x62,0xaa,0x3f,0xde,0x3b,0xb0,0xd1,0x4a,0xed,0xf7,0x25,0xc9,
		0xa1,0x55,0xd4,0xeb,0x28,0xab,0x5a,0x93,0xe8,0x68,0x9e,0xb8,0x14,0xb9,0x5d,0xcd,
		0xfb,0xbb,0x73,0x08,0x35,0xde,0xc1,0xfe,0x68,0xe3,0xf3,0x9d,0x8a,0x12,0x4e,0x71,
		0xbe,0xba,0xf3,0x41,0xe7,0xb3,0x22,0xa6,0x1a,0xc2,0x58,0x72,0x0f,0xfa,0xaf,0x72,
		0x2e,0x2f,0x41,0x8a,0x80,0xe6,0x1b,0x92,0xfe,0xec,0x74,0x7e,0xaf,0x81,0xdd,0xc5,
		0xb9,0x6c,0x3d,0x5f,0x85,0xbe,0x41,0x92,0x0c,0xa0,0xc7,0x02,0x50,0x39,0x4f,0xcc,
		0xf1,0xb1,0x98,0x35,0x8e,0x97,0x31,0xa0,0xb1,0x5a,0x4a,0x49,0x0d,0x72,0x62,0x67,
		0x93,0x8a,0x76,0x79,0x8d,0x97,0x40,0x45,0x73,0x58,0x8f,0x50,0x8d,0x13,0x29,0x80,
		0xe4,0x40,0xaf,0xe4,0x15,0x91,0xd4,0x21,0x12,0xd0,0xce,0x96,0x16,0xc6,0xa3,0x31,
		0x29,0xa0,0x43,0xb9,0xe9,0xfb,0x40,0x79,0xb7,0xc8,0xb1,0x72,0x3a,0x34,0x11,0x8e,
		0xdd,0x66,0x25,0x4f,0x45,0x9b,0x5f,0x28,0x2d,0x62,0x3a,0x44,0x5d,0x0e,0xcd,0x12,
		0xa2,0x1c,0xad,0xb6,0x7c,0x05,0x72,0xde,0xc9,0x47,0x8f,0x30,0x6c,0x70,0x2e,0x50,
		0x08,0xe2,0x62,0x56,0x30,0x80,0x36,0xbf,0x26,0x02,0x2a,0x10,0x98,0x8a,0xf9,0xe1,
		0x64,0x9f,0xeb,0xc8,0x91,0x7b,0x31,0x93,0x7b,0x41,0x51,0xab,0x8b,0x01,0x08,0xf2,
		0xbf,0x22,0x12,0x8a,0x8a,0xf7,0xa2,0xab,0x86,0xa5,0x08,0x70,0x0f,0x12,0x63,0xb1,
		0xfa,0x50,0x28,0x4d,0xe1,0x15,0x20,0xa3,0x01,0x6e,0x7d,0xa1,0x9d,0x1f,0x36,0x39,
		0x35,0x25,0x78,0xb5,0xea,0x89,0x51,0x9a,0x0e,0x8e,0x66,0x92,0x5c,0x26,0xc1,0x17,
		0xd5,0x5e,0x16,0x87,0xa6,0x64,0x98,0x3e,0xe7,0x3c,0x93,0x74,0x7a,0xc9,0x29,0xa8,
		0x1c,0xe5,0x76,0x16,0xb8,0x72,0x71,0x51,0x2d,0x2c,0x75,0xc2,0x0a,0x78,0x5e,0x31,
		0x87,0xc9,0x06,0xae,0x9b,0x45,0xd0,0x0d,0xce,0x98,0x6c,0x1b,0x21,0x1e,0xf8,0xd0,
		0xf2,0x23,0x0a,0x15,0x23,0x66,0xc2,0xc0,0x22,0x1f,0xe7,0x8c,0x8b,0xd3,0x5e,0xee,
		0x14,0x91,0x75,0xc6,0xa0,0x98,0x72,0xeb,0x7b,0x15,0xa6,0x7e,0x74,0x00,0x94,0x0d,
		0x27,0xa2,0xf0,0xe0,0x0c,0xb5,0x1e,0xd9,0x72,0xcc,0xfa,0xf9,0xb0,0xd5,0x8e,0xeb,
		0x20,0x78,0xa3,0x35,0x44,0x8f,0x1d,0x00,0xb8,0x64,0x67,0xe2,0x5a,0x1d,0xc1,0x8f,
		0x9a,0xeb,0x96,0x14,0x36,0x8a,0x6c,0x5d,0xe7,0x8a,0xf3,0xf0,0xda,0xf6,0xe5,0x3a}, 
		/*TST_dataSize*/
		512*sizeof(DxUint8_t),
		/*TST_FinishInputData*/
		{0xf3,0xee,0xd1,0xbd,0xb5,0xd2,0xa0,0x3c,0x06,0x4b,0x5a,0x7e,0x3d,0xb1,0x81,0xf8,
		0xef,0x15,0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1},
		/*TST_FinishOutputData*/
		{0},
		/*TST_FinishExpectedOutputData*/
		{0xc0,0xb3,0xd4,0x46,0x86,0x02,0x64,0x3b,0x06,0x5b,0x88,0x9d,0x3f,0x53,0x77,0x83,
		0x16,0x87,0x5f,0x1e,0x7d,0x75,0xb8,0xd5,0xfb,0x1d},
		/*TST_FinishInputDataSize*/
		26			
	},
#endif
#if TST_USE_AES_1536BYTE_DATA
	{ 
		{"Acceptance test - AES/XTS/256Key/1536ByteData "},
		/*TST_Key*/     
		{0x60,0x3d,0xeb,0x10,0x15,0xca,0x71,0xbe,0x2b,0x73,0xae,0xf0,0x85,0x7d,0x77,0x81,
		0x1f,0x35,0x2c,0x07,0x3b,0x61,0x08,0xd7,0x2d,0x98,0x10,0xa3,0x09,0x14,0xdf,0xf4},
		CRYS_AES_Key256BitSize,
		/*TST_Tweak*/       
		{0xd2,0x27,0x1d,0x06,0xdf,0xc9,0x15,0xc7,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
		/*TST_input_data*/
		{0x47,0x16,0xe6,0x72,0xc8,0x03,0x08,0x89,0x4a,0x6e,0x3c,0xcf,0x0d,0x9e,0x79,0xf1,
		0x5f,0xc1,0x08,0xa1,0x79,0x3a,0x8b,0x8b,0xa4,0x3c,0x3d,0x8b,0xa0,0x98,0x7b,0x1d,
		0x45,0xd3,0x84,0x15,0x6b,0x7c,0x7d,0x90,0x08,0xbc,0xb8,0x2a,0x98,0x2f,0x35,0x71,
		0xc2,0xf2,0x69,0x9a,0x38,0xfe,0x3f,0x73,0xdf,0xb4,0x5d,0x99,0x30,0xb8,0xa8,0xeb,
		0xde,0x03,0x0a,0x3e,0xb8,0x34,0x73,0x53,0xd2,0x27,0x1d,0x06,0xdf,0xc9,0x15,0xc7,
		0xe2,0x2b,0xf7,0x4e,0x06,0xd5,0xf8,0x8b,0xc9,0x5c,0x2a,0xdc,0x60,0x37,0xfc,0x83,
		0x57,0xce,0x00,0x57,0x79,0xd4,0xf2,0xb9,0xef,0xd7,0xf5,0xca,0xac,0x15,0x1f,0xdc,
		0x08,0x92,0x38,0x26,0xaa,0x67,0xbf,0xbb,0xac,0x5d,0x2e,0xbd,0xfa,0xba,0x80,0xcd,
		0xfb,0x5b,0xef,0xc7,0x74,0x03,0x02,0xac,0xa9,0xf3,0xc7,0xe0,0xc5,0xbb,0x5d,0x96,
		0x7b,0x4f,0xb6,0x88,0xee,0x5d,0x9b,0xeb,0xce,0xde,0xf1,0xa2,0xc4,0xec,0x3a,0xb2,
		0x11,0xd3,0x5f,0xf6,0x72,0x6a,0xac,0x14,0x46,0xa4,0x1c,0xaf,0xf2,0x62,0xd7,0xde,
		0x85,0x8b,0xf9,0xdd,0x98,0x5f,0x95,0x03,0x79,0x08,0xfa,0xf4,0x88,0x72,0x34,0x18,
		0xe0,0x5d,0xd6,0x4c,0x3a,0xb1,0xf7,0xd7,0x0f,0x11,0x7b,0x9f,0xfd,0xb2,0x94,0x9d,
		0x6c,0x6e,0x87,0x8e,0x71,0x14,0xb4,0xeb,0xf3,0x03,0xd1,0x1c,0x0c,0xf7,0x76,0xe9,
		0xb1,0x22,0xde,0x31,0x96,0x7f,0xec,0xde,0x4c,0x63,0x6c,0x18,0xac,0x55,0x9c,0xb9,
		0x79,0x1f,0xea,0x01,0x41,0x25,0x00,0x8c,0x84,0xf6,0xfe,0x80,0x19,0x21,0x06,0x0b,
		0xcc,0x4a,0xfe,0x0d,0x4c,0x7c,0x91,0x11,0x45,0xc1,0x77,0x82,0xc9,0xf0,0xf7,0x1c,
		0xf4,0xc7,0xaa,0xa0,0xd0,0x39,0x81,0xcc,0x76,0x09,0x09,0x8a,0x76,0x98,0xee,0x68,
		0x79,0xfc,0xbf,0x48,0x25,0x51,0xf0,0x58,0x41,0x54,0x25,0x45,0x1a,0x2e,0xae,0xac,
		0x25,0x8d,0x4d,0xd2,0xe5,0xf9,0x40,0x94,0x0f,0x66,0x7b,0xa1,0xed,0x05,0x36,0xe6,
		0x00,0x60,0xa7,0x4a,0xe9,0xa6,0x11,0x9c,0x8a,0x43,0xfd,0xc9,0x68,0xb4,0xc7,0x53,
		0x53,0x9a,0x5d,0xfe,0x4a,0x0d,0x44,0xcd,0x99,0x32,0xdc,0x2c,0x44,0x10,0xe4,0x6f,
		0xa8,0x9f,0x40,0x7b,0x60,0x22,0xfa,0xc3,0x66,0xb7,0x88,0x77,0x7a,0x2d,0x4d,0xf7,
		0xc8,0x15,0x62,0x8e,0xc5,0x1c,0x95,0x5d,0x5a,0x98,0xb2,0x95,0x44,0x60,0x02,0xea,
		0xbb,0xe1,0x12,0x44,0x51,0x6e,0xb5,0xb7,0x1e,0xd8,0x4c,0xb5,0x1a,0x3f,0x45,0x82,
		0xca,0x27,0xe2,0xe9,0x1f,0xce,0x3c,0x2e,0x9b,0xbe,0x87,0x43,0xb5,0x9e,0x97,0x3e,
		0x7f,0x4d,0xa3,0x0b,0x86,0x32,0x4a,0x5e,0xf9,0xcd,0xd3,0xec,0x0e,0x92,0xb9,0xdb,
		0xa2,0xf8,0x67,0x77,0x20,0xcd,0x40,0x26,0xa3,0xcc,0xe2,0x9e,0x5f,0x71,0xac,0x55,
		0x3d,0x0c,0x7e,0x39,0xc5,0x15,0xbf,0xa2,0x41,0xbf,0xa5,0x85,0x1f,0xcf,0xb0,0xea,
		0x98,0xaf,0x78,0xa0,0x8f,0xbe,0xa9,0x2f,0xbc,0xeb,0x4c,0x0e,0x09,0x82,0x48,0x16,
		0x3c,0x45,0x28,0x37,0xd7,0xbf,0x1e,0x6a,0x3c,0xd5,0x48,0xe6,0x15,0x9e,0x33,0x97,
		0xf3,0x75,0x9e,0xcc,0x35,0x4c,0x80,0x30,0x2c,0x43,0x4c,0xfb,0x7d,0x79,0x73,0x69,
		0xc6,0x21,0x2a,0x6c,0x84,0xd9,0x6f,0x9d,0x34,0x38,0x46,0x79,0xb8,0xa6,0x49,0xca,
		0xfd,0x71,0x5f,0x63,0xdb,0x1d,0xcc,0x10,0x3c,0xfb,0x6a,0xcd,0x81,0xfd,0x35,0x36,
		0x21,0xc8,0x0d,0x3f,0x93,0x0b,0xb8,0x25,0x6f,0x0f,0x27,0xa5,0xd0,0x90,0xfa,0x6b,
		0xfc,0xcc,0x46,0xcd,0x47,0xd9,0x95,0xb9,0x34,0x3b,0x2e,0xec,0xde,0xb6,0x97,0x65,
		0x96,0x61,0x59,0x1a,0xce,0xfc,0x03,0xe9,0x36,0x83,0x71,0xd1,0x24,0x03,0x4e,0x62,
		0x39,0xad,0xd8,0x72,0x42,0x29,0xe3,0x12,0x5c,0x2d,0x21,0xc1,0x5c,0x4d,0xa0,0xdf,
		0x6d,0x15,0x94,0x64,0xfb,0x55,0x57,0xd1,0xd0,0xbc,0xae,0x67,0x7d,0xa8,0x4e,0x97,
		0xfc,0x3d,0x9f,0xbb,0x93,0xb5,0xbf,0x03,0xfb,0xf6,0xca,0xb2,0xc2,0x6a,0x59,0x8a,
		0xee,0x0b,0x48,0x84,0xe3,0xbd,0xbd,0xc5,0x87,0xe1,0x65,0xce,0xa3,0x27,0x01,0xf3,
		0x8d,0xa3,0x22,0x0e,0x04,0x24,0x30,0x74,0x5b,0xc1,0xb1,0x28,0xda,0xb4,0xc8,0x4f,
		0x61,0x6c,0xfc,0xe4,0x4e,0xdd,0x3b,0xad,0xa1,0x1b,0x1f,0x6e,0x5e,0x27,0x70,0x5c,
		0x33,0x08,0xe9,0xd4,0x5b,0x1e,0x3f,0x4d,0xc2,0xb4,0x5f,0x8c,0x6a,0xd4,0xf7,0x17,
		0x0d,0x5f,0x39,0xeb,0x04,0x5d,0xdc,0x71,0x67,0x91,0x63,0xaf,0x76,0x50,0xa1,0xbb,
		0x37,0x94,0x7d,0x76,0x61,0x4d,0xf3,0x76,0x79,0xf7,0x5b,0x44,0x3b,0x71,0xee,0xc8,
		0x3b,0x0d,0x86,0x01,0xcc,0xe4,0xa5,0xfa,0x21,0x6c,0xb9,0xf9,0xb2,0x4c,0x9e,0xf9,
		0xe1,0x6e,0x65,0x5a,0xde,0x56,0x54,0xd8,0xc8,0xb3,0x2d,0xba,0x15,0x34,0xb4,0x4b,
		0x33,0x9d,0x6b,0x8e,0x6f,0x1a,0xa0,0x2e,0x17,0xd3,0xa9,0xb4,0xdb,0xc0,0x6f,0xfc,
		0x79,0xbf,0x29,0xea,0x9a,0xe4,0x6a,0x59,0xf6,0x10,0x5e,0x54,0xbf,0xc5,0x50,0x89,
		0x3d,0x38,0x70,0xfa,0xb6,0xa8,0xd4,0xf6,0x90,0xef,0xbc,0x48,0xb9,0x57,0x1a,0xae,
		0x47,0xae,0x52,0x8d,0x5c,0x9d,0x3e,0xe2,0x4d,0x35,0x75,0x7c,0x03,0xcb,0xcd,0x69,
		0xa1,0x06,0x1e,0xae,0x66,0x36,0x49,0x3b,0xd6,0xe7,0x79,0x1d,0x14,0xb7,0xa9,0xf6,
		0x93,0x64,0x67,0xaa,0xed,0x29,0xd7,0x5c,0x13,0x4b,0xfa,0x99,0xa7,0xef,0x30,0xd2,
		0xa6,0x2e,0xfc,0x10,0x4a,0x6b,0x08,0xe3,0x2f,0xe4,0x69,0x9b,0xb4,0x88,0x23,0xbb,
		0xa4,0x09,0xf0,0xab,0x16,0x31,0x3d,0xad,0x91,0x79,0x76,0x12,0x74,0xd8,0x83,0xae,
		0x95,0xd9,0x93,0x89,0x29,0xf0,0x18,0xd7,0xe4,0x0e,0x12,0x2b,0x61,0x73,0x91,0xe7,
		0xc3,0xc4,0x75,0xf7,0x9d,0x5d,0x79,0xbf,0x0f,0xe8,0x70,0x51,0x32,0x2e,0xce,0xe4,
		0xb6,0x2e,0x69,0x82,0xca,0x6c,0x81,0x00,0x3c,0x8c,0xfe,0x33,0xe2,0x1f,0xfa,0x61,
		0x38,0xbd,0x7f,0xf6,0x4a,0x54,0x92,0x78,0xd5,0xbf,0x70,0xbd,0xa9,0x9b,0x17,0x5c,
		0x51,0x56,0x08,0x61,0xf6,0x88,0x4c,0x45,0x81,0x87,0xb5,0x1d,0x00,0x36,0x66,0x11,
		0x4b,0x1d,0x95,0x10,0xe7,0xbf,0x90,0xc2,0x2a,0x27,0xfe,0xbe,0xa0,0xc5,0x68,0xfe,
		0xae,0x78,0xf8,0x8f,0x75,0xec,0x80,0x8d,0xf9,0x26,0xbd,0x4f,0x83,0x5d,0xde,0xdf,
		0x44,0x0c,0x40,0xad,0x3a,0x45,0x7c,0x84,0x58,0x48,0xa3,0xbc,0xe1,0x54,0xc8,0xb2,
		0x15,0xbd,0xbf,0x75,0x0f,0x3f,0x25,0xc2,0xee,0x92,0xa0,0x33,0x33,0x3e,0x68,0xb3,
		0x6a,0xb1,0x07,0x35,0x0d,0x8f,0x5d,0xa6,0xa5,0x49,0xe6,0x1f,0x32,0xf1,0x40,0x60,
		0xcd,0x4d,0xe7,0x7a,0x8c,0x2a,0x44,0xcb,0xa6,0xf2,0xe6,0x2f,0xd7,0x81,0x0f,0x75,
		0x06,0x35,0x72,0x10,0x26,0x44,0x3b,0x0f,0x5a,0x53,0x50,0x50,0x5c,0x44,0xd6,0xf0,
		0x1f,0x4f,0xf8,0x05,0xb3,0x54,0xe3,0x90,0x6a,0x6f,0x15,0xad,0x39,0xce,0xd8,0x0d,
		0x60,0xbf,0x09,0xa6,0x4d,0x0d,0x1e,0xa9,0xbe,0x8d,0x68,0xb5,0x27,0xf4,0x94,0x4a,
		0x53,0xeb,0x78,0x80,0x4d,0x66,0x0d,0xf9,0x81,0x31,0xb7,0x14,0x1f,0xcb,0xcd,0x63,
		0xc0,0x78,0x55,0x60,0x4c,0x92,0x0f,0x5b,0x1b,0x20,0xb6,0xb7,0x5a,0xaa,0x82,0x56,
		0xb1,0x4b,0xf1,0x52,0x22,0x07,0xc7,0xee,0x35,0x5f,0x53,0xcc,0x52,0x23,0xf5,0x60,
		0x6e,0x88,0xdd,0xa4,0xea,0x7a,0x15,0x0d,0xb7,0x33,0xc2,0xbe,0xbf,0x0d,0xa7,0xfd,
		0x80,0x94,0xea,0xe3,0xfa,0xe0,0x1b,0x57,0xcc,0x22,0x72,0x3d,0x9a,0x7c,0x58,0xea,
		0xb1,0x16,0x29,0xdb,0xee,0x6e,0x39,0xa7,0xdc,0xef,0x15,0x33,0x1c,0xc6,0x0b,0x25,
		0x0a,0xf1,0xec,0x9b,0x9d,0x98,0x10,0x1c,0x8f,0xa1,0x9b,0xcf,0xbe,0x7f,0xff,0xea,
		0xd3,0x4a,0xc2,0x6e,0x21,0x15,0x82,0x12,0xd0,0x7c,0x36,0x7c,0x3a,0x7c,0xb6,0xb7,
		0x95,0x88,0x7e,0xe2,0xd3,0xd8,0xae,0x25,0xc6,0x05,0x56,0xea,0x88,0xd3,0xf1,0x49,
		0x1a,0x4d,0x2f,0xc3,0x4b,0x18,0xf8,0x34,0xdb,0x01,0xad,0x03,0xe1,0xd8,0xb1,0x9c,
		0x6a,0x81,0x28,0x20,0x63,0x48,0xfe,0x5a,0xb9,0x75,0x2b,0xf6,0xbe,0x20,0x36,0xed,
		0xcf,0x47,0xf8,0x44,0x34,0x1e,0xa3,0xf6,0x47,0xa6,0x03,0x2f,0xd8,0x81,0x03,0xba,
		0xd1,0x05,0x72,0xbd,0x16,0x8f,0x07,0xa4,0xaf,0x1a,0xa3,0x5b,0x29,0x10,0xd7,0xc0,
		0x39,0x5f,0xa6,0x58,0xa3,0xd0,0x8c,0x40,0x5a,0x95,0xbf,0x67,0xe9,0x20,0xb4,0xfb,
		0x11,0x3c,0xe5,0x21,0xb4,0x56,0xd2,0xe9,0xf2,0x1b,0x45,0x81,0x91,0x49,0xdb,0xa9,
		0xa2,0xbe,0xc0,0x66,0x61,0xd6,0xba,0xfb,0x5e,0xf3,0x69,0x15,0xda,0x5d,0xcd,0x46,
		0x74,0x4d,0x08,0xb4,0x05,0x44,0x65,0x13,0xc8,0xa1,0x9a,0xd0,0xbe,0x73,0x4a,0x8f,
		0x50,0x8c,0xce,0xd8,0x37,0xd7,0x35,0x0d,0x99,0xeb,0x89,0xa0,0x74,0xdf,0x54,0x82,
		0x40,0x60,0x63,0xdf,0xd0,0x02,0xca,0x08,0x7a,0xd4,0x29,0xb1,0x77,0x37,0x2d,0x5c,
		0x8c,0xf0,0x59,0x15,0xea,0x7b,0x06,0x60,0x54,0xa2,0xa8,0x70,0x7f,0x4f,0x54,0x99,
		0xbe,0x9f,0x7f,0x08,0xdf,0x37,0x09,0xb2,0x4f,0xdb,0x7a,0x8a,0x85,0x3d,0x8b,0xf7,
		0x9e,0x12,0xe8,0x85,0x45,0x6b,0x34,0xdb,0xd6,0x43,0x4d,0xed,0xc3,0x54,0xd2,0x72,
		0x36,0x30,0xe3,0x99,0xf8,0x8c,0x28,0xf7,0x91,0xdf,0x15,0xc4,0xb1,0x2c,0x6c,0x48,
		0xce,0x1b,0x03,0x90,0x0f,0x4f,0xc7,0x65,0x69,0xf4,0x01,0x7f,0x08,0x97,0xd8,0xf5,
		0xf0,0x3b,0x17,0xf8,0xe4,0xa9,0x31,0xc1,0x86,0x07,0x83,0xc8,0xc1,0xac,0xd8,0x37,
		0x64,0x33,0x32,0x9e,0x0f,0xce,0xc8,0xe8,0x53,0xdd,0x4b,0x8e,0x15,0xc0,0x6d,0x0a},
		/*TST_output_data*/
		{0},
		/*TST_Expected_output_data for enc Input data for decrypt*/
		{0x8a,0x57,0x37,0xf3,0xdd,0x59,0xd6,0xac,0x76,0xe2,0x07,0xa2,0x0d,0xae,0xf8,0x91,
		0xbd,0x30,0x66,0x40,0x5f,0x8a,0x8c,0x6e,0x87,0x87,0xbf,0xd8,0x69,0xe0,0x44,0xaf,
		0x5f,0xb8,0xd1,0x3a,0xc9,0x3a,0xd4,0xb6,0x61,0x13,0xc5,0x72,0x28,0xaa,0x3e,0x4b,
		0x00,0x5c,0x53,0x66,0x72,0x3a,0xf9,0x45,0xec,0x6a,0xd3,0x41,0x20,0xb2,0x41,0x9c,
		0x92,0xd2,0x6b,0xcc,0x2e,0xb7,0x81,0xba,0x47,0x40,0x28,0x73,0x43,0xd1,0xc3,0x30,
		0x5b,0x99,0x05,0x50,0x56,0x6a,0xc5,0x35,0xdf,0x5a,0xa9,0xfb,0xb7,0x9a,0xf4,0xab,
		0x78,0x44,0x43,0x4a,0x56,0x1d,0x8e,0xfe,0x6a,0xb5,0x10,0x4d,0x5b,0x72,0xcb,0x15,
		0xfd,0x16,0xa5,0x10,0xa2,0x55,0xb3,0x8d,0x1a,0x32,0x2a,0x62,0x03,0xf7,0xfb,0x9e,
		0x8f,0xf2,0x49,0x53,0x07,0xbb,0xe0,0xbe,0xcc,0x4f,0x75,0x0b,0xc4,0x07,0x6e,0xb7,
		0xf2,0xe8,0x10,0xbb,0x9e,0xf2,0xfd,0xf5,0x47,0x0e,0xc8,0xbe,0x64,0x5a,0xbc,0x54,
		0x5d,0x09,0xd8,0x07,0x9e,0x10,0xc2,0xff,0x26,0x31,0x87,0x46,0x39,0xc7,0xe5,0x66,
		0x24,0xdc,0xf9,0x25,0xe3,0x0e,0x42,0x63,0xb8,0x93,0x17,0xff,0xed,0x43,0x18,0x7c,
		0xce,0x3b,0x25,0xa9,0x00,0xcd,0x6c,0x51,0x35,0x3f,0x25,0xa3,0xeb,0x0f,0x9c,0xbb,
		0xb3,0xb7,0x99,0x07,0x6a,0x04,0x49,0x8a,0x62,0x7a,0x5d,0xe8,0x6c,0x5d,0xaf,0xe8,
		0x9f,0x89,0x10,0xd8,0xab,0xb1,0x7d,0x93,0x45,0x97,0xbb,0x82,0x8d,0x3c,0x04,0x14,
		0xc7,0xa4,0x4e,0x46,0xf5,0x55,0x14,0x26,0x15,0xdd,0xae,0x42,0x0a,0x5c,0xa0,0x6d,
		0x18,0x26,0x2d,0x3d,0x64,0x3d,0x0c,0xd5,0x74,0xa8,0x7e,0x3c,0xe7,0x5f,0x70,0xad,
		0x17,0xd8,0x87,0xae,0xe2,0xbf,0xdf,0x74,0x91,0xd9,0x69,0xed,0x9a,0xbb,0x04,0xc4,
		0xe6,0x77,0x2e,0x84,0xd4,0xa4,0xb1,0x83,0x72,0xcc,0x94,0x97,0x9f,0x96,0x2b,0xc5,
		0xf5,0x28,0xff,0x3b,0xe3,0x48,0x07,0xfb,0x67,0x56,0x4b,0xee,0xe1,0xa8,0xa9,0x14,
		0x8e,0x7a,0x6b,0xc9,0xcc,0x01,0xcc,0x04,0xc0,0xf3,0x35,0x6f,0x2e,0x5a,0x32,0x91,
		0xb2,0x30,0xa3,0x90,0x00,0x85,0x8a,0xa3,0xc8,0xcf,0xb1,0xc5,0xd9,0x2c,0x3e,0xa5,
		0x28,0x3e,0x87,0xba,0xa8,0xca,0x2a,0xc4,0xe9,0x64,0x01,0xa5,0x3e,0x2d,0x38,0x12,
		0xc0,0x0b,0x3c,0x14,0x87,0xe7,0xb5,0x7c,0x68,0x2c,0x27,0x96,0x98,0xda,0x3f,0xa6,
		0xdf,0x57,0x6a,0x88,0x09,0xa0,0x50,0x2c,0x19,0x73,0x7f,0x2e,0x42,0xba,0xd3,0x97,
		0x23,0x25,0x57,0xd1,0xe0,0x16,0x2f,0xcc,0xe7,0x2a,0x05,0x29,0xd2,0xb2,0xce,0x69,
		0x4c,0x94,0x11,0x52,0xbd,0x43,0x33,0xa7,0x3f,0xb9,0xf6,0x45,0x6c,0xad,0xfe,0x95,
		0x97,0x13,0x5e,0x93,0x08,0x36,0xe1,0xd9,0x42,0x44,0x5a,0x7b,0x89,0x6a,0xa7,0xf5,
		0x80,0x65,0xdd,0xfc,0x08,0x66,0x7a,0xbc,0x99,0x4f,0xb0,0x22,0x53,0xa6,0x65,0x98,
		0x5a,0x23,0xe7,0xd9,0xbd,0x41,0x51,0x91,0x21,0x48,0x75,0x92,0x83,0xa2,0x2a,0x0e,
		0x41,0x1a,0x78,0x7d,0x84,0xf3,0x1a,0xdc,0xe6,0xe9,0x3e,0xe5,0x21,0xae,0xaa,0xbd,
		0x3f,0x42,0x34,0xe3,0x7d,0x9c,0xae,0x3d,0xf4,0x5a,0xd4,0x03,0xf8,0x51,0xfd,0xea,
		0x3b,0xb2,0xf5,0xd5,0xb1,0xb6,0xdf,0x17,0x91,0x83,0x7f,0xd0,0xfa,0x37,0xbd,0x13,
		0xb9,0xa2,0x0c,0x93,0xa8,0x17,0x38,0x83,0xd7,0xb5,0x17,0xdd,0x9f,0x91,0x03,0x87,
		0x8f,0x4d,0x5e,0x45,0x4d,0x9a,0x01,0x69,0x41,0x74,0x2b,0xc7,0x9d,0x76,0x59,0x64,
		0x26,0xcf,0x0c,0x8b,0x54,0x02,0x1d,0xbc,0x1f,0xae,0x42,0xc7,0x54,0xcb,0x92,0x86,
		0x81,0xdb,0xed,0xb6,0xe6,0x8f,0xce,0xef,0xee,0x6c,0x3b,0x18,0xaa,0x94,0x5a,0xe7,
		0x07,0x3f,0xaf,0x36,0xd7,0x79,0x68,0x29,0xde,0xda,0x23,0xd5,0x61,0x0b,0xbd,0x40,
		0x6c,0x0c,0x00,0x49,0x04,0x70,0xe6,0xfe,0xde,0x4e,0x91,0x4d,0xdd,0xe8,0x57,0x08,
		0xb9,0x6e,0xbd,0x0e,0x2b,0x6d,0x44,0xe0,0x30,0x16,0x1b,0x49,0x5e,0x78,0x18,0xfa,
		0xec,0x03,0x70,0x93,0xe6,0x02,0x60,0x0f,0x1e,0x1a,0xe7,0xee,0x6a,0xf6,0x5b,0xce,
		0xee,0xc2,0xa1,0x54,0xb9,0x81,0x72,0x79,0xc3,0x9a,0x6d,0xf9,0x4d,0x1e,0xcc,0x23,
		0x94,0x97,0x37,0x0d,0x86,0xea,0x96,0x2d,0xf4,0xb3,0x99,0x66,0x39,0xb9,0x22,0xfb,
		0xfc,0xa9,0xf1,0xfe,0x79,0x9c,0x55,0x4a,0x73,0x41,0x3c,0xc4,0x26,0x05,0xa1,0xff,
		0xd1,0x60,0x8b,0xbb,0xb2,0x61,0xa3,0xe3,0x54,0x77,0x0f,0x18,0xdc,0x89,0xaf,0xd4,
		0x02,0xf2,0x4a,0x36,0xd9,0x3e,0x2d,0xbb,0xbb,0x47,0xa7,0xc7,0x97,0x0d,0xf7,0x5c,
		0x7d,0x8f,0xa1,0x85,0x69,0x02,0x9d,0xd8,0xf2,0xa8,0x82,0x43,0x76,0x4c,0x9c,0xbd,
		0xe0,0xe4,0xd0,0xe8,0xef,0xc8,0xaf,0x5b,0xc2,0x88,0xd5,0x56,0xce,0x5d,0x34,0x97,
		0x2f,0x72,0xd2,0xeb,0xac,0x30,0xa7,0x49,0xa2,0xd6,0x0b,0x40,0x6f,0xb5,0xfd,0x8b,
		0x81,0x61,0x11,0x0c,0x16,0xce,0xfb,0x6a,0x6b,0x9f,0x73,0x73,0x86,0x8f,0x04,0xd4,
		0xd9,0x8e,0x15,0xb6,0x8c,0x84,0x40,0xce,0xd0,0xde,0x0e,0x83,0xc7,0x78,0xed,0x0e,
		0x4e,0x5c,0x2e,0x8a,0x66,0x79,0x81,0x82,0xd4,0xfe,0xe7,0x13,0x00,0x98,0x0e,0x7c,
		0xf5,0x86,0x26,0x81,0x58,0xac,0x66,0xb1,0xb2,0x10,0xa0,0x8e,0xe5,0x25,0x39,0x9b,
		0xe2,0xeb,0x74,0xef,0x3d,0x4a,0xc6,0xd9,0x84,0x75,0xde,0xe9,0x7a,0xa2,0xad,0x93,
		0x76,0xce,0x37,0x4d,0x39,0xcb,0x53,0xd3,0xbb,0xef,0x49,0x51,0xb5,0x0e,0xe8,0xd3,
		0xa0,0xd6,0xff,0x0d,0x86,0x59,0xd6,0x93,0x24,0x88,0xce,0xef,0xa7,0xf6,0x98,0xa4,
		0x1e,0x2e,0x9b,0x29,0x9e,0x2d,0x55,0xc1,0xc5,0x60,0x29,0xc4,0x43,0xa4,0x2b,0xaf,
		0xaf,0x99,0x5d,0x6f,0x6f,0xfb,0x99,0x84,0xda,0x8b,0x4c,0x5c,0x60,0x1c,0xf9,0x10,
		0xbc,0x54,0x93,0x1e,0x51,0x1a,0xda,0xb9,0x6c,0x84,0x75,0xae,0x9b,0xc9,0x46,0x49,
		0x26,0x9c,0x63,0xee,0x2c,0x94,0xaf,0x05,0x41,0x26,0x3b,0xa5,0xcd,0x78,0x44,0xf7,
		0x68,0xde,0x39,0x9d,0xdc,0xd9,0xa5,0x41,0x1e,0xe8,0xd8,0xfe,0x9d,0x9f,0xb6,0x82,
		0x65,0x7c,0xa5,0xad,0x96,0x15,0x91,0x58,0x34,0x17,0xdd,0x49,0x8b,0xc6,0xbe,0xf7,
		0x16,0xc0,0xb3,0x8e,0x00,0x3b,0xb8,0xe1,0xb0,0x2f,0xa9,0x3b,0x45,0xda,0x97,0x9d,
		0xb9,0x84,0xbc,0xda,0x4d,0x02,0xdd,0xa8,0xa6,0x75,0xf3,0x99,0x8f,0xf5,0x1b,0xa0,
		0x76,0xf4,0x6f,0x5b,0xcb,0xa4,0xe6,0xa0,0x39,0x7f,0xaa,0xf6,0x61,0xc6,0x57,0x42,
		0xdd,0xca,0xe0,0x20,0xca,0x50,0x6a,0xc0,0xd2,0x35,0xe0,0x06,0xfe,0x2e,0x0a,0xe5,
		0x34,0x97,0x93,0x45,0x85,0x7d,0xa0,0xa4,0x4e,0x31,0xcd,0x91,0x68,0x29,0xa7,0xfa,
		0x5f,0xec,0xc3,0x7c,0xdc,0xbd,0xf6,0xb8,0x31,0xc1,0xb0,0x34,0x82,0x50,0xf4,0xc8,
		0xb2,0xb3,0xe5,0x28,0x8d,0xd5,0x7d,0xe7,0xae,0x66,0x8b,0x5b,0xac,0xb8,0x0f,0xbd,
		0xca,0xb8,0xbe,0x45,0x51,0x8a,0x1a,0xa4,0xc1,0x40,0x36,0xc5,0x04,0x5d,0x33,0x49,
		0x2c,0xc4,0x3e,0x14,0x2d,0xe3,0x79,0xf0,0xf5,0x38,0x51,0x4a,0x53,0x82,0xaa,0x23,
		0x6a,0x27,0xe0,0xaf,0x9f,0x56,0x01,0xbe,0x84,0xc5,0x55,0x12,0x72,0x6b,0xb1,0x58,
		0xa9,0x16,0x74,0x83,0x42,0x63,0xee,0x1d,0x36,0xd4,0xab,0x3b,0xf3,0x82,0x97,0x47,
		0xe4,0x2d,0x71,0xbe,0x8a,0x89,0x5c,0xa2,0x23,0xae,0x29,0x8b,0xc5,0xde,0xb8,0xf9,
		0x53,0x84,0x98,0xac,0xb3,0xfd,0x17,0x6e,0x33,0xb2,0x41,0xac,0x64,0x6c,0x04,0xc7,
		0xe7,0xea,0xf4,0x2e,0x62,0xde,0xbb,0xc6,0x81,0x44,0x4f,0x9b,0xd4,0x6d,0xdf,0x8b,
		0x6c,0x58,0x74,0xef,0x1e,0x9b,0x18,0x73,0xae,0xe7,0x18,0x69,0xeb,0x8e,0xca,0x69,
		0x62,0x0a,0xe7,0x43,0x70,0x20,0x14,0xa5,0xce,0xb0,0xeb,0x34,0x25,0x20,0x33,0xed,
		0x61,0x55,0x9b,0x3a,0x9d,0x02,0xd2,0xea,0x46,0x1a,0x1c,0x4b,0xd4,0xdd,0xc7,0xad,
		0x32,0x44,0x72,0xec,0xe8,0x1c,0x36,0x59,0x35,0x29,0x15,0x8d,0x46,0xac,0x4e,0xa6,
		0xd4,0x5f,0x79,0x4a,0x13,0x73,0x92,0x18,0xbb,0x94,0xc3,0x2c,0xc1,0xae,0x6f,0x48,
		0xf9,0x0d,0x7f,0xe6,0xfb,0x68,0x47,0x50,0x85,0xf8,0x5e,0xc3,0x0c,0x55,0x1f,0xcd,
		0xa2,0x57,0x92,0x07,0x11,0xc5,0x11,0xbf,0x6a,0xb8,0x67,0x3e,0x35,0x20,0x70,0xf7,
		0x20,0xea,0xb3,0x13,0x78,0x96,0x6e,0xe1,0x4d,0xfb,0x7e,0xeb,0x65,0x0a,0x4b,0x21,
		0x83,0xb2,0x0d,0x6a,0x47,0x7d,0x89,0xc6,0xad,0x30,0x48,0xb3,0x28,0xb8,0x7a,0x80,
		0xd3,0x50,0x72,0x68,0x3b,0x20,0x86,0xe6,0x98,0x06,0x87,0xef,0xe6,0x35,0x70,0x1a,
		0xc9,0x53,0x41,0xa9,0xdf,0xe8,0x1a,0xaa,0x77,0xcf,0x84,0x18,0x33,0xf2,0x50,0x4b,
		0xc9,0x94,0xd7,0xcf,0x26,0x34,0xbf,0x2d,0xdf,0x03,0xb6,0xd2,0xa1,0x52,0xc3,0xb5,
		0xa8,0x10,0x6e,0x47,0x25,0xe1,0x52,0x8d,0x89,0x58,0x79,0x1c,0xcc,0xbc,0xdd,0xc8,
		0xdc,0xbc,0x32,0x56,0xa1,0x9f,0x9f,0x2b,0xb9,0xbc,0xe7,0x7a,0xba,0xd3,0xae,0xa8,
		0x7e,0x35,0xdf,0xc2,0xf6,0x11,0x15,0x8d,0x23,0x97,0x07,0x5e,0x18,0x08,0x27,0x78,
		0x2b,0x1e,0x45,0xf3,0x46,0x81,0x40,0x3b,0x84,0xfd,0xfe,0x2f,0x02,0x07,0x0b,0x73,
		0xcf,0x4d,0xbb,0xee,0x7e,0x71,0xfc,0xff,0xad,0x54,0xa7,0x26,0xeb,0xe5,0xa6,0x39,
		0x6d,0xc8,0x4e,0x5b,0x7f,0x13,0x75,0xac,0x73,0xd0,0x56,0xe5,0x0f,0x63,0xad,0xc0,
		0x37,0x40,0x73,0x68,0x32,0xd4,0xce,0xd0,0xb7,0xcd,0xbf,0x39,0x1c,0x32,0xfa,0x1a,
		0x8b,0xcb,0x55,0xc3,0xc2,0xbc,0x8e,0xa5,0x48,0x3c,0xf7,0x0d,0xda,0x64,0x2b,0x6d}, 
		/*TST_dataSize*/
		1536*sizeof(DxUint8_t),
		/*TST_FinishInputData*/
		{0xf3,0xee,0xd1,0xbd,0xb5,0xd2,0xa0,0x3c,0x06,0x4b,0x5a,0x7e,0x3d,0xb1,0x81,0xf8,
		0xef,0x15,0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0xbd,0xb5,0xd2,0xa0,0x3c},
		/*TST_FinishOutputData*/
		{0},
		/*TST_FinishExpectedOutputData*/
		{0x9a,0x27,0x79,0x0c,0x7f,0x6c,0x1a,0xa4,0xda,0x21,0xf4,0x3d,0x1d,0xb2,0x7f,0xaa,
		0xb5,0x1f,0x75,0x44,0xeb,0x36,0x2c,0x9f,0x43,0x21,0xd7,0xd4,0x29,0xeb,0x4e},
		/*TST_FinishInputDataSize*/
		31			
	},
#endif
#endif
#if TST_USE_AES_16BYTE_DATA
	{ 
		{"Acceptance test - AES/XTS/512Key/16ByteData "},
		/*TST_Key*/     
		{0x60,0x3d,0xeb,0x10,0x15,0xca,0x71,0xbe,0x2b,0x73,0xae,0xf0,0x85,0x7d,0x77,0x81, 
		0x1f,0x35,0x2c,0x07,0x3b,0x61,0x08,0xd7,0x2d,0x98,0x10,0xa3,0x09,0x14,0xdf,0xf4,
		0xd4,0x5f,0x79,0x4a,0x13,0x73,0x92,0x18,0xbb,0x94,0xc3,0x2c,0xc1,0xae,0x6f,0x48,
		0xf9,0x0d,0x7f,0xe6,0xfb,0x68,0x47,0x50,0x85,0xf8,0x5e,0xc3,0x0c,0x55,0x1f,0xcd},
		CRYS_AES_Key512BitSize,
		/*TST_Tweak*/       
		{0},
		/*TST_input_data*/
		{0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a},
		/*TST_output_data*/
		{0},
		/*TST_Expected_output_data for enc Input data for decrypt*/
		{0xd6,0x16,0xbe,0x29,0xb4,0x75,0x1c,0x85,0xfa,0x22,0xe0,0x88,0x8f,0xb0,0x59,0xc7}, 
		/*TST_dataSize*/
		16*sizeof(DxUint8_t),       
		/*TST_FinishInputData*/
		{0},
		/*TST_FinishOutputData*/
		{0},
		/*TST_FinishExpectedOutputData*/
		{0},
		/*TST_FinishInputDataSize*/
		0
	},
#endif 
#if TST_USE_AES_32BYTE_DATA
	{ 
		{"Acceptance test - AES/XTS/512Key/32ByteData "},
		/*TST_Key*/     
		{0x60,0x3d,0xeb,0x10,0x15,0xca,0x71,0xbe,0x2b,0x73,0xae,0xf0,0x85,0x7d,0x77,0x81, 
		0x1f,0x35,0x2c,0x07,0x3b,0x61,0x08,0xd7,0x2d,0x98,0x10,0xa3,0x09,0x14,0xdf,0xf4,
		0xd4,0x5f,0x79,0x4a,0x13,0x73,0x92,0x18,0xbb,0x94,0xc3,0x2c,0xc1,0xae,0x6f,0x48,
		0xf9,0x0d,0x7f,0xe6,0xfb,0x68,0x47,0x50,0x85,0xf8,0x5e,0xc3,0x0c,0x55,0x1f,0xcd},
		CRYS_AES_Key512BitSize,
		/*TST_Tweak*/       
		{0xd2,0x27,0x1d,0x06,0xdf,0xc9,0x15,0xc7,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
		/*TST_input_data*/
		{0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a,
		0xf3,0xee,0xd1,0xbd,0xb5,0xd2,0xa0,0x3c,0x06,0x4b,0x5a,0x7e,0x3d,0xb1,0x81,0xf8},
		/*TST_output_data*/
		{0},
		/*TST_Expected_output_data for enc Input data for decrypt*/
		{0x29,0x67,0x41,0xf5,0x4d,0x07,0x26,0xbb,0xff,0x5e,0x08,0x09,0xb8,0xcf,0xc1,0x95,
		0xe5,0xb3,0x89,0x73,0x2a,0xde,0xa1,0xa8,0x62,0x06,0xf8,0xf5,0x3c,0xa2,0x6f,0x4b}, 
		/*TST_dataSize*/
		32*sizeof(DxUint8_t),
		/*TST_FinishInputData*/
		{0},
		/*TST_FinishOutputData*/
		{0},
		/*TST_FinishExpectedOutputData*/
		{0},
		/*TST_FinishInputDataSize*/
		0
	},
#endif
#if TST_USE_AES_64BYTE_DATA
	{ 
		{"Acceptance test - AES/XTS/512Key/64ByteData "},
		/*TST_Key*/     
		{0x60,0x3d,0xeb,0x10,0x15,0xca,0x71,0xbe,0x2b,0x73,0xae,0xf0,0x85,0x7d,0x77,0x81, 
		0x1f,0x35,0x2c,0x07,0x3b,0x61,0x08,0xd7,0x2d,0x98,0x10,0xa3,0x09,0x14,0xdf,0xf4,
		0xd4,0x5f,0x79,0x4a,0x13,0x73,0x92,0x18,0xbb,0x94,0xc3,0x2c,0xc1,0xae,0x6f,0x48,
		0xf9,0x0d,0x7f,0xe6,0xfb,0x68,0x47,0x50,0x85,0xf8,0x5e,0xc3,0x0c,0x55,0x1f,0xcd},
		CRYS_AES_Key512BitSize,
		/*TST_Tweak*/       
		{0xd2,0x27,0x1d,0x06,0xdf,0xc9,0x15,0xc7,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
		/*TST_input_data*/
		{0x45,0xd3,0x84,0x15,0x6b,0x7c,0x7d,0x90,0x08,0xbc,0xb8,0x2a,0x98,0x2f,0x35,0x71,
		0xc2,0xf2,0x69,0x9a,0x38,0xfe,0x3f,0x73,0xdf,0xb4,0x5d,0x99,0x30,0xb8,0xa8,0xeb,
		0xde,0x03,0x0a,0x3e,0xb8,0x34,0x73,0x53,0xd2,0x27,0x1d,0x06,0xdf,0xc9,0x15,0xc7,
		0xe2,0x2b,0xf7,0x4e,0x06,0xd5,0xf8,0x8b,0xc9,0x5c,0x2a,0xdc,0x60,0x37,0xfc,0x83},
		/*TST_output_data*/
		{0},
		/*TST_Expected_output_data for enc Input data for decrypt*/
		{0xd8,0x31,0xc7,0x56,0x08,0x3f,0xaa,0x36,0xbf,0x1c,0x1f,0x14,0xfc,0x65,0x6c,0x3e,
		0x17,0xb5,0xba,0x59,0x82,0x3b,0xfb,0x8e,0xcf,0x43,0xf2,0x7b,0xa9,0x7a,0x92,0xa0,
		0xb7,0xbf,0x15,0x25,0xc8,0x8f,0x8a,0x15,0x3e,0x03,0xd4,0x16,0x43,0x54,0x8f,0x76,
		0x70,0x37,0x7e,0x20,0xa3,0x37,0x23,0x49,0xc2,0xde,0xb8,0x08,0x56,0xaf,0x3c,0xaa}, 
		/*TST_dataSize*/
		64*sizeof(DxUint8_t), 
		/*TST_FinishInputData*/
		{0xf3,0xee,0xd1,0xbd,0xb5,0xd2,0xa0,0x3c,0x06,0x4b,0x5a,0x7e,0x3d,0xb1,0x81,0xf8,
		0xef,0x15},
		/*TST_FinishOutputData*/
		{0},
		/*TST_FinishExpectedOutputData*/
		{0xb6,0x54,0x6b,0x4d,0xc8,0x99,0x8a,0xe6,0x89,0x6e,0x7c,0xa3,0x38,0xf9,0xa8,0x8f,
		0xd2,0xa6},
		/*TST_FinishInputDataSize*/
		18			
	},
#endif
#if TST_USE_AES_512BYTE_DATA
	{
		{"Acceptance test - AES/XTS/512Key/512ByteData"},
		/*TST_Key*/     
		{0x60,0x3d,0xeb,0x10,0x15,0xca,0x71,0xbe,0x2b,0x73,0xae,0xf0,0x85,0x7d,0x77,0x81, 
		0x1f,0x35,0x2c,0x07,0x3b,0x61,0x08,0xd7,0x2d,0x98,0x10,0xa3,0x09,0x14,0xdf,0xf4,
		0xd4,0x5f,0x79,0x4a,0x13,0x73,0x92,0x18,0xbb,0x94,0xc3,0x2c,0xc1,0xae,0x6f,0x48,
		0xf9,0x0d,0x7f,0xe6,0xfb,0x68,0x47,0x50,0x85,0xf8,0x5e,0xc3,0x0c,0x55,0x1f,0xcd},                                                                                          
		CRYS_AES_Key512BitSize,
		/*TST_Tweak*/       
		{0xd2,0x27,0x1d,0x06,0xdf,0xc9,0x15,0xc7,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
		/*TST_input_data*/
		{0x30,0xc8,0x1c,0x46,0xa3,0x5c,0xe4,0x11,0xe5,0xfb,0xc1,0x19,0x1a,0x0a,0x52,0xef,
		0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a,
		0x3a,0xd7,0x7b,0xb4,0x0d,0x7a,0x36,0x60,0xa8,0x9e,0xca,0xf3,0x24,0x66,0xef,0x97,
		0xf5,0xd3,0xd5,0x85,0x03,0xb9,0x69,0x9d,0xe7,0x85,0x89,0x5a,0x96,0xfd,0xba,0xaf,
		0x43,0xb1,0xcd,0x7f,0x59,0x8e,0xce,0x23,0x88,0x1b,0x00,0xe3,0xed,0x03,0x06,0x88,
		0x7b,0x0c,0x78,0x5e,0x27,0xe8,0xad,0x3f,0x82,0x23,0x20,0x71,0x04,0x72,0x5d,0xd4,
		0x3a,0xd7,0x7b,0xb4,0x0d,0x7a,0x36,0x60,0xa8,0x9e,0xca,0xf3,0x24,0x66,0xef,0x97,
		0xf5,0xd3,0xd5,0x85,0x03,0xb9,0x69,0x9d,0xe7,0x85,0x89,0x5a,0x96,0xfd,0xba,0xaf,
		0x30,0xc8,0x1c,0x46,0xa3,0x5c,0xe4,0x11,0xe5,0xfb,0xc1,0x19,0x1a,0x0a,0x52,0xef,
		0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a,
		0x3a,0xd7,0x7b,0xb4,0x0d,0x7a,0x36,0x60,0xa8,0x9e,0xca,0xf3,0x24,0x66,0xef,0x97,
		0xf5,0xd3,0xd5,0x85,0x03,0xb9,0x69,0x9d,0xe7,0x85,0x89,0x5a,0x96,0xfd,0xba,0xaf,
		0x43,0xb1,0xcd,0x7f,0x59,0x8e,0xce,0x23,0x88,0x1b,0x00,0xe3,0xed,0x03,0x06,0x88,
		0x7b,0x0c,0x78,0x5e,0x27,0xe8,0xad,0x3f,0x82,0x23,0x20,0x71,0x04,0x72,0x5d,0xd4,
		0x3a,0xd7,0x7b,0xb4,0x0d,0x7a,0x36,0x60,0xa8,0x9e,0xca,0xf3,0x24,0x66,0xef,0x97,
		0xf5,0xd3,0xd5,0x85,0x03,0xb9,0x69,0x9d,0xe7,0x85,0x89,0x5a,0x96,0xfd,0xba,0xaf,
		0x30,0xc8,0x1c,0x46,0xa3,0x5c,0xe4,0x11,0xe5,0xfb,0xc1,0x19,0x1a,0x0a,0x52,0xef,
		0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a,
		0x3a,0xd7,0x7b,0xb4,0x0d,0x7a,0x36,0x60,0xa8,0x9e,0xca,0xf3,0x24,0x66,0xef,0x97,
		0xf5,0xd3,0xd5,0x85,0x03,0xb9,0x69,0x9d,0xe7,0x85,0x89,0x5a,0x96,0xfd,0xba,0xaf,
		0x43,0xb1,0xcd,0x7f,0x59,0x8e,0xce,0x23,0x88,0x1b,0x00,0xe3,0xed,0x03,0x06,0x88,
		0x7b,0x0c,0x78,0x5e,0x27,0xe8,0xad,0x3f,0x82,0x23,0x20,0x71,0x04,0x72,0x5d,0xd4,
		0x3a,0xd7,0x7b,0xb4,0x0d,0x7a,0x36,0x60,0xa8,0x9e,0xca,0xf3,0x24,0x66,0xef,0x97,
		0xf5,0xd3,0xd5,0x85,0x03,0xb9,0x69,0x9d,0xe7,0x85,0x89,0x5a,0x96,0xfd,0xba,0xaf,
		0x30,0xc8,0x1c,0x46,0xa3,0x5c,0xe4,0x11,0xe5,0xfb,0xc1,0x19,0x1a,0x0a,0x52,0xef,
		0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a,
		0x3a,0xd7,0x7b,0xb4,0x0d,0x7a,0x36,0x60,0xa8,0x9e,0xca,0xf3,0x24,0x66,0xef,0x97,
		0xf5,0xd3,0xd5,0x85,0x03,0xb9,0x69,0x9d,0xe7,0x85,0x89,0x5a,0x96,0xfd,0xba,0xaf,
		0x43,0xb1,0xcd,0x7f,0x59,0x8e,0xce,0x23,0x88,0x1b,0x00,0xe3,0xed,0x03,0x06,0x88,
		0x7b,0x0c,0x78,0x5e,0x27,0xe8,0xad,0x3f,0x82,0x23,0x20,0x71,0x04,0x72,0x5d,0xd4,
		0x3a,0xd7,0x7b,0xb4,0x0d,0x7a,0x36,0x60,0xa8,0x9e,0xca,0xf3,0x24,0x66,0xef,0x97,
		0xf5,0xd3,0xd5,0x85,0x03,0xb9,0x69,0x9d,0xe7,0x85,0x89,0x5a,0x96,0xfd,0xba,0xaf},
		/*TST_output_data*/
		{0},
		/*TST_Expected_output_data for enc Input data for decrypt*/
		{0x93,0xd2,0x29,0xfa,0x0c,0x09,0x97,0x45,0x0f,0xb8,0x9d,0xdf,0x11,0x4b,0xd7,0x47,
		0x9d,0x72,0x13,0x99,0xe9,0x7f,0x78,0x9b,0x63,0x5d,0x28,0x35,0x11,0xc2,0x75,0x26,
		0x4e,0x0b,0x50,0x88,0x96,0x9f,0x1e,0xd0,0x47,0xd1,0xbe,0xc6,0x5e,0xaf,0xca,0xe2,
		0x80,0x64,0x9a,0xa8,0xc3,0x5b,0x1a,0x68,0x42,0x5d,0x6a,0x2c,0x9f,0x21,0xfe,0x46,
		0xb1,0x2e,0x51,0x41,0x91,0x47,0x71,0x3c,0x46,0xe3,0x75,0x6c,0xd2,0xa8,0xe2,0x2e,
		0x2f,0x58,0x15,0xd3,0x03,0x2a,0x75,0x3f,0xff,0xaf,0x11,0x79,0xc9,0x49,0x2a,0x18,
		0xe9,0xbe,0x18,0x38,0xfc,0x09,0xf4,0x7e,0xcb,0x49,0x35,0xef,0x01,0x52,0xd4,0x1b,
		0x9a,0xd6,0xc4,0x39,0x0f,0x79,0x5d,0x2e,0x61,0x1e,0x9b,0xe7,0x2b,0xca,0xd5,0x3e,
		0x5d,0xa8,0xf6,0x40,0x7c,0x86,0x83,0x0c,0xa2,0x06,0x87,0xd4,0x40,0x91,0x77,0x7b,
		0xa8,0x1d,0x26,0xb0,0x55,0x1a,0xa6,0x05,0xb2,0x26,0x49,0x84,0xa9,0x9b,0x10,0x4e,
		0x26,0x72,0x52,0xd1,0x85,0x97,0x10,0xad,0x91,0x85,0x8c,0x79,0x18,0x6d,0x4b,0x75,
		0xfd,0xbd,0xc2,0xd1,0xf2,0x17,0xb3,0xea,0x73,0x31,0x75,0x09,0x0a,0x36,0xa5,0x41,
		0xaa,0x23,0x3b,0xf6,0x97,0xcb,0xff,0x43,0xd7,0x45,0xbd,0xcd,0x3f,0x7d,0x2d,0xf5,
		0xa4,0xe0,0xf8,0x23,0x1c,0x77,0xef,0x78,0x67,0x98,0xa7,0x0c,0x51,0xb0,0x3b,0x65,
		0xb5,0x78,0x3f,0xa8,0x7f,0x54,0xb6,0xc1,0x9c,0x97,0x74,0x1c,0x6c,0x84,0x0b,0xd9,
		0xe2,0x66,0x76,0x96,0xe4,0x3a,0x26,0x66,0xbf,0xb0,0xa0,0xba,0x93,0xa9,0xa5,0x57,
		0x34,0x5e,0x75,0x3a,0xd5,0xf4,0x82,0xb1,0x93,0x49,0xad,0x2c,0x1e,0x3b,0xfe,0x92,
		0x6a,0xda,0x5e,0x2e,0xfb,0x32,0x8b,0xc6,0x75,0x5f,0x96,0x75,0x7b,0xd2,0xde,0x8c,
		0x95,0x80,0x94,0x0c,0x36,0x9d,0xeb,0x6c,0xe8,0xee,0x49,0x16,0xd0,0x8e,0x41,0x4c,
		0x31,0xe6,0x99,0x8d,0x5e,0xdd,0x89,0x9f,0xf5,0xc5,0xe6,0x5e,0x89,0x57,0x27,0x48,
		0x58,0x54,0x29,0x49,0xa7,0x76,0xa9,0x0f,0xfb,0xd3,0x31,0x39,0x3a,0xff,0xdc,0xc7,
		0xe0,0x8c,0x3c,0x6b,0x79,0xaa,0xe9,0x23,0x70,0x7b,0x52,0x85,0x82,0x3e,0x50,0x78,
		0x1b,0xbd,0x39,0x83,0xdb,0x79,0x7e,0x52,0x02,0xbf,0xa1,0xe2,0x17,0x8d,0x99,0x9f,
		0xd4,0x03,0x7f,0x45,0x90,0x01,0xd5,0x95,0x9e,0x81,0x47,0x4e,0x45,0x4d,0x7e,0xb5,
		0x32,0xd2,0x7e,0x42,0x28,0xef,0x9e,0x8e,0x81,0x25,0x1b,0x1c,0x84,0xcb,0x58,0xe2,
		0x44,0x4a,0xae,0xe7,0x00,0xa5,0xfa,0x53,0x10,0x05,0xf0,0xb8,0x4e,0x70,0xa4,0xca,
		0xb8,0x09,0x01,0x1e,0x7f,0xd9,0x2d,0x15,0x56,0x3e,0x9a,0x36,0x79,0xc0,0xc2,0x98,
		0xb8,0x3c,0x5d,0x7e,0x59,0x2e,0x16,0x49,0xd3,0xe4,0xaa,0x0a,0x28,0x58,0xa4,0xeb,
		0x9c,0x5f,0xcd,0x8b,0x86,0x24,0x57,0xb8,0x52,0x3f,0x8f,0x88,0xb5,0xfa,0x1f,0xdd,
		0xac,0xeb,0x2a,0x22,0x1f,0x22,0x69,0x68,0x2a,0x14,0x20,0xb3,0xf0,0x85,0x16,0x44,
		0xb6,0x47,0xbc,0x9f,0xde,0x7a,0xf6,0x79,0x48,0xca,0x2e,0x3b,0x2c,0x30,0x4b,0x79,
		0x6a,0xfd,0x60,0x52,0x16,0xb2,0x4f,0x95,0x0f,0x08,0x98,0x59,0xc5,0xa8,0x76,0xed}, 
		/*TST_dataSize*/
		512*sizeof(DxUint8_t),
		/*TST_FinishInputData*/
		{0xf3,0xee,0xd1,0xbd,0xb5,0xd2,0xa0,0x3c,0x06,0x4b,0x5a,0x7e,0x3d,0xb1,0x81,0xf8,
		0xef,0x15,0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1},
		/*TST_FinishOutputData*/
		{0},
		/*TST_FinishExpectedOutputData*/
		{0x21,0x6d,0x64,0x65,0x9b,0xcb,0xff,0x96,0xd6,0x59,0xeb,0x33,0xa3,0x7b,0x88,0x70,
		0x32,0x00,0x09,0x2e,0x37,0xb3,0x61,0xd3,0x75,0xfe},
		/*TST_FinishInputDataSize*/
		26			
	},
#endif
#if TST_USE_AES_1536BYTE_DATA
		{ 
			{"Acceptance test - AES/XTS/512Key/1536ByteData "},			
			/*TST_Key*/     
			{0x60,0x3d,0xeb,0x10,0x15,0xca,0x71,0xbe,0x2b,0x73,0xae,0xf0,0x85,0x7d,0x77,0x81, 
			0x1f,0x35,0x2c,0x07,0x3b,0x61,0x08,0xd7,0x2d,0x98,0x10,0xa3,0x09,0x14,0xdf,0xf4,
			0xd4,0x5f,0x79,0x4a,0x13,0x73,0x92,0x18,0xbb,0x94,0xc3,0x2c,0xc1,0xae,0x6f,0x48,
			0xf9,0x0d,0x7f,0xe6,0xfb,0x68,0x47,0x50,0x85,0xf8,0x5e,0xc3,0x0c,0x55,0x1f,0xcd},                                                                                          
			CRYS_AES_Key512BitSize,
			/*TST_Tweak*/       
			{0xd2,0x27,0x1d,0x06,0xdf,0xc9,0x15,0xc7,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
			/*TST_input_data*/
			{0x47,0x16,0xe6,0x72,0xc8,0x03,0x08,0x89,0x4a,0x6e,0x3c,0xcf,0x0d,0x9e,0x79,0xf1,
			0x5f,0xc1,0x08,0xa1,0x79,0x3a,0x8b,0x8b,0xa4,0x3c,0x3d,0x8b,0xa0,0x98,0x7b,0x1d,
			0x45,0xd3,0x84,0x15,0x6b,0x7c,0x7d,0x90,0x08,0xbc,0xb8,0x2a,0x98,0x2f,0x35,0x71,
			0xc2,0xf2,0x69,0x9a,0x38,0xfe,0x3f,0x73,0xdf,0xb4,0x5d,0x99,0x30,0xb8,0xa8,0xeb,
			0xde,0x03,0x0a,0x3e,0xb8,0x34,0x73,0x53,0xd2,0x27,0x1d,0x06,0xdf,0xc9,0x15,0xc7,
			0xe2,0x2b,0xf7,0x4e,0x06,0xd5,0xf8,0x8b,0xc9,0x5c,0x2a,0xdc,0x60,0x37,0xfc,0x83,
			0x57,0xce,0x00,0x57,0x79,0xd4,0xf2,0xb9,0xef,0xd7,0xf5,0xca,0xac,0x15,0x1f,0xdc,
			0x08,0x92,0x38,0x26,0xaa,0x67,0xbf,0xbb,0xac,0x5d,0x2e,0xbd,0xfa,0xba,0x80,0xcd,
			0xfb,0x5b,0xef,0xc7,0x74,0x03,0x02,0xac,0xa9,0xf3,0xc7,0xe0,0xc5,0xbb,0x5d,0x96,
			0x7b,0x4f,0xb6,0x88,0xee,0x5d,0x9b,0xeb,0xce,0xde,0xf1,0xa2,0xc4,0xec,0x3a,0xb2,
			0x11,0xd3,0x5f,0xf6,0x72,0x6a,0xac,0x14,0x46,0xa4,0x1c,0xaf,0xf2,0x62,0xd7,0xde,
			0x85,0x8b,0xf9,0xdd,0x98,0x5f,0x95,0x03,0x79,0x08,0xfa,0xf4,0x88,0x72,0x34,0x18,
			0xe0,0x5d,0xd6,0x4c,0x3a,0xb1,0xf7,0xd7,0x0f,0x11,0x7b,0x9f,0xfd,0xb2,0x94,0x9d,
			0x6c,0x6e,0x87,0x8e,0x71,0x14,0xb4,0xeb,0xf3,0x03,0xd1,0x1c,0x0c,0xf7,0x76,0xe9,
			0xb1,0x22,0xde,0x31,0x96,0x7f,0xec,0xde,0x4c,0x63,0x6c,0x18,0xac,0x55,0x9c,0xb9,
			0x79,0x1f,0xea,0x01,0x41,0x25,0x00,0x8c,0x84,0xf6,0xfe,0x80,0x19,0x21,0x06,0x0b,
			0xcc,0x4a,0xfe,0x0d,0x4c,0x7c,0x91,0x11,0x45,0xc1,0x77,0x82,0xc9,0xf0,0xf7,0x1c,
			0xf4,0xc7,0xaa,0xa0,0xd0,0x39,0x81,0xcc,0x76,0x09,0x09,0x8a,0x76,0x98,0xee,0x68,
			0x79,0xfc,0xbf,0x48,0x25,0x51,0xf0,0x58,0x41,0x54,0x25,0x45,0x1a,0x2e,0xae,0xac,
			0x25,0x8d,0x4d,0xd2,0xe5,0xf9,0x40,0x94,0x0f,0x66,0x7b,0xa1,0xed,0x05,0x36,0xe6,
			0x00,0x60,0xa7,0x4a,0xe9,0xa6,0x11,0x9c,0x8a,0x43,0xfd,0xc9,0x68,0xb4,0xc7,0x53,
			0x53,0x9a,0x5d,0xfe,0x4a,0x0d,0x44,0xcd,0x99,0x32,0xdc,0x2c,0x44,0x10,0xe4,0x6f,
			0xa8,0x9f,0x40,0x7b,0x60,0x22,0xfa,0xc3,0x66,0xb7,0x88,0x77,0x7a,0x2d,0x4d,0xf7,
			0xc8,0x15,0x62,0x8e,0xc5,0x1c,0x95,0x5d,0x5a,0x98,0xb2,0x95,0x44,0x60,0x02,0xea,
			0xbb,0xe1,0x12,0x44,0x51,0x6e,0xb5,0xb7,0x1e,0xd8,0x4c,0xb5,0x1a,0x3f,0x45,0x82,
			0xca,0x27,0xe2,0xe9,0x1f,0xce,0x3c,0x2e,0x9b,0xbe,0x87,0x43,0xb5,0x9e,0x97,0x3e,
			0x7f,0x4d,0xa3,0x0b,0x86,0x32,0x4a,0x5e,0xf9,0xcd,0xd3,0xec,0x0e,0x92,0xb9,0xdb,
			0xa2,0xf8,0x67,0x77,0x20,0xcd,0x40,0x26,0xa3,0xcc,0xe2,0x9e,0x5f,0x71,0xac,0x55,
			0x3d,0x0c,0x7e,0x39,0xc5,0x15,0xbf,0xa2,0x41,0xbf,0xa5,0x85,0x1f,0xcf,0xb0,0xea,
			0x98,0xaf,0x78,0xa0,0x8f,0xbe,0xa9,0x2f,0xbc,0xeb,0x4c,0x0e,0x09,0x82,0x48,0x16,
			0x3c,0x45,0x28,0x37,0xd7,0xbf,0x1e,0x6a,0x3c,0xd5,0x48,0xe6,0x15,0x9e,0x33,0x97,
			0xf3,0x75,0x9e,0xcc,0x35,0x4c,0x80,0x30,0x2c,0x43,0x4c,0xfb,0x7d,0x79,0x73,0x69,
			0xc6,0x21,0x2a,0x6c,0x84,0xd9,0x6f,0x9d,0x34,0x38,0x46,0x79,0xb8,0xa6,0x49,0xca,
			0xfd,0x71,0x5f,0x63,0xdb,0x1d,0xcc,0x10,0x3c,0xfb,0x6a,0xcd,0x81,0xfd,0x35,0x36,
			0x21,0xc8,0x0d,0x3f,0x93,0x0b,0xb8,0x25,0x6f,0x0f,0x27,0xa5,0xd0,0x90,0xfa,0x6b,
			0xfc,0xcc,0x46,0xcd,0x47,0xd9,0x95,0xb9,0x34,0x3b,0x2e,0xec,0xde,0xb6,0x97,0x65,
			0x96,0x61,0x59,0x1a,0xce,0xfc,0x03,0xe9,0x36,0x83,0x71,0xd1,0x24,0x03,0x4e,0x62,
			0x39,0xad,0xd8,0x72,0x42,0x29,0xe3,0x12,0x5c,0x2d,0x21,0xc1,0x5c,0x4d,0xa0,0xdf,
			0x6d,0x15,0x94,0x64,0xfb,0x55,0x57,0xd1,0xd0,0xbc,0xae,0x67,0x7d,0xa8,0x4e,0x97,
			0xfc,0x3d,0x9f,0xbb,0x93,0xb5,0xbf,0x03,0xfb,0xf6,0xca,0xb2,0xc2,0x6a,0x59,0x8a,
			0xee,0x0b,0x48,0x84,0xe3,0xbd,0xbd,0xc5,0x87,0xe1,0x65,0xce,0xa3,0x27,0x01,0xf3,
			0x8d,0xa3,0x22,0x0e,0x04,0x24,0x30,0x74,0x5b,0xc1,0xb1,0x28,0xda,0xb4,0xc8,0x4f,
			0x61,0x6c,0xfc,0xe4,0x4e,0xdd,0x3b,0xad,0xa1,0x1b,0x1f,0x6e,0x5e,0x27,0x70,0x5c,
			0x33,0x08,0xe9,0xd4,0x5b,0x1e,0x3f,0x4d,0xc2,0xb4,0x5f,0x8c,0x6a,0xd4,0xf7,0x17,
			0x0d,0x5f,0x39,0xeb,0x04,0x5d,0xdc,0x71,0x67,0x91,0x63,0xaf,0x76,0x50,0xa1,0xbb,
			0x37,0x94,0x7d,0x76,0x61,0x4d,0xf3,0x76,0x79,0xf7,0x5b,0x44,0x3b,0x71,0xee,0xc8,
			0x3b,0x0d,0x86,0x01,0xcc,0xe4,0xa5,0xfa,0x21,0x6c,0xb9,0xf9,0xb2,0x4c,0x9e,0xf9,
			0xe1,0x6e,0x65,0x5a,0xde,0x56,0x54,0xd8,0xc8,0xb3,0x2d,0xba,0x15,0x34,0xb4,0x4b,
			0x33,0x9d,0x6b,0x8e,0x6f,0x1a,0xa0,0x2e,0x17,0xd3,0xa9,0xb4,0xdb,0xc0,0x6f,0xfc,
			0x79,0xbf,0x29,0xea,0x9a,0xe4,0x6a,0x59,0xf6,0x10,0x5e,0x54,0xbf,0xc5,0x50,0x89,
			0x3d,0x38,0x70,0xfa,0xb6,0xa8,0xd4,0xf6,0x90,0xef,0xbc,0x48,0xb9,0x57,0x1a,0xae,
			0x47,0xae,0x52,0x8d,0x5c,0x9d,0x3e,0xe2,0x4d,0x35,0x75,0x7c,0x03,0xcb,0xcd,0x69,
			0xa1,0x06,0x1e,0xae,0x66,0x36,0x49,0x3b,0xd6,0xe7,0x79,0x1d,0x14,0xb7,0xa9,0xf6,
			0x93,0x64,0x67,0xaa,0xed,0x29,0xd7,0x5c,0x13,0x4b,0xfa,0x99,0xa7,0xef,0x30,0xd2,
			0xa6,0x2e,0xfc,0x10,0x4a,0x6b,0x08,0xe3,0x2f,0xe4,0x69,0x9b,0xb4,0x88,0x23,0xbb,
			0xa4,0x09,0xf0,0xab,0x16,0x31,0x3d,0xad,0x91,0x79,0x76,0x12,0x74,0xd8,0x83,0xae,
			0x95,0xd9,0x93,0x89,0x29,0xf0,0x18,0xd7,0xe4,0x0e,0x12,0x2b,0x61,0x73,0x91,0xe7,
			0xc3,0xc4,0x75,0xf7,0x9d,0x5d,0x79,0xbf,0x0f,0xe8,0x70,0x51,0x32,0x2e,0xce,0xe4,
			0xb6,0x2e,0x69,0x82,0xca,0x6c,0x81,0x00,0x3c,0x8c,0xfe,0x33,0xe2,0x1f,0xfa,0x61,
			0x38,0xbd,0x7f,0xf6,0x4a,0x54,0x92,0x78,0xd5,0xbf,0x70,0xbd,0xa9,0x9b,0x17,0x5c,
			0x51,0x56,0x08,0x61,0xf6,0x88,0x4c,0x45,0x81,0x87,0xb5,0x1d,0x00,0x36,0x66,0x11,
			0x4b,0x1d,0x95,0x10,0xe7,0xbf,0x90,0xc2,0x2a,0x27,0xfe,0xbe,0xa0,0xc5,0x68,0xfe,
			0xae,0x78,0xf8,0x8f,0x75,0xec,0x80,0x8d,0xf9,0x26,0xbd,0x4f,0x83,0x5d,0xde,0xdf,
			0x44,0x0c,0x40,0xad,0x3a,0x45,0x7c,0x84,0x58,0x48,0xa3,0xbc,0xe1,0x54,0xc8,0xb2,
			0x15,0xbd,0xbf,0x75,0x0f,0x3f,0x25,0xc2,0xee,0x92,0xa0,0x33,0x33,0x3e,0x68,0xb3,
			0x6a,0xb1,0x07,0x35,0x0d,0x8f,0x5d,0xa6,0xa5,0x49,0xe6,0x1f,0x32,0xf1,0x40,0x60,
			0xcd,0x4d,0xe7,0x7a,0x8c,0x2a,0x44,0xcb,0xa6,0xf2,0xe6,0x2f,0xd7,0x81,0x0f,0x75,
			0x06,0x35,0x72,0x10,0x26,0x44,0x3b,0x0f,0x5a,0x53,0x50,0x50,0x5c,0x44,0xd6,0xf0,
			0x1f,0x4f,0xf8,0x05,0xb3,0x54,0xe3,0x90,0x6a,0x6f,0x15,0xad,0x39,0xce,0xd8,0x0d,
			0x60,0xbf,0x09,0xa6,0x4d,0x0d,0x1e,0xa9,0xbe,0x8d,0x68,0xb5,0x27,0xf4,0x94,0x4a,
			0x53,0xeb,0x78,0x80,0x4d,0x66,0x0d,0xf9,0x81,0x31,0xb7,0x14,0x1f,0xcb,0xcd,0x63,
			0xc0,0x78,0x55,0x60,0x4c,0x92,0x0f,0x5b,0x1b,0x20,0xb6,0xb7,0x5a,0xaa,0x82,0x56,
			0xb1,0x4b,0xf1,0x52,0x22,0x07,0xc7,0xee,0x35,0x5f,0x53,0xcc,0x52,0x23,0xf5,0x60,
			0x6e,0x88,0xdd,0xa4,0xea,0x7a,0x15,0x0d,0xb7,0x33,0xc2,0xbe,0xbf,0x0d,0xa7,0xfd,
			0x80,0x94,0xea,0xe3,0xfa,0xe0,0x1b,0x57,0xcc,0x22,0x72,0x3d,0x9a,0x7c,0x58,0xea,
			0xb1,0x16,0x29,0xdb,0xee,0x6e,0x39,0xa7,0xdc,0xef,0x15,0x33,0x1c,0xc6,0x0b,0x25,
			0x0a,0xf1,0xec,0x9b,0x9d,0x98,0x10,0x1c,0x8f,0xa1,0x9b,0xcf,0xbe,0x7f,0xff,0xea,
			0xd3,0x4a,0xc2,0x6e,0x21,0x15,0x82,0x12,0xd0,0x7c,0x36,0x7c,0x3a,0x7c,0xb6,0xb7,
			0x95,0x88,0x7e,0xe2,0xd3,0xd8,0xae,0x25,0xc6,0x05,0x56,0xea,0x88,0xd3,0xf1,0x49,
			0x1a,0x4d,0x2f,0xc3,0x4b,0x18,0xf8,0x34,0xdb,0x01,0xad,0x03,0xe1,0xd8,0xb1,0x9c,
			0x6a,0x81,0x28,0x20,0x63,0x48,0xfe,0x5a,0xb9,0x75,0x2b,0xf6,0xbe,0x20,0x36,0xed,
			0xcf,0x47,0xf8,0x44,0x34,0x1e,0xa3,0xf6,0x47,0xa6,0x03,0x2f,0xd8,0x81,0x03,0xba,
			0xd1,0x05,0x72,0xbd,0x16,0x8f,0x07,0xa4,0xaf,0x1a,0xa3,0x5b,0x29,0x10,0xd7,0xc0,
			0x39,0x5f,0xa6,0x58,0xa3,0xd0,0x8c,0x40,0x5a,0x95,0xbf,0x67,0xe9,0x20,0xb4,0xfb,
			0x11,0x3c,0xe5,0x21,0xb4,0x56,0xd2,0xe9,0xf2,0x1b,0x45,0x81,0x91,0x49,0xdb,0xa9,
			0xa2,0xbe,0xc0,0x66,0x61,0xd6,0xba,0xfb,0x5e,0xf3,0x69,0x15,0xda,0x5d,0xcd,0x46,
			0x74,0x4d,0x08,0xb4,0x05,0x44,0x65,0x13,0xc8,0xa1,0x9a,0xd0,0xbe,0x73,0x4a,0x8f,
			0x50,0x8c,0xce,0xd8,0x37,0xd7,0x35,0x0d,0x99,0xeb,0x89,0xa0,0x74,0xdf,0x54,0x82,
			0x40,0x60,0x63,0xdf,0xd0,0x02,0xca,0x08,0x7a,0xd4,0x29,0xb1,0x77,0x37,0x2d,0x5c,
			0x8c,0xf0,0x59,0x15,0xea,0x7b,0x06,0x60,0x54,0xa2,0xa8,0x70,0x7f,0x4f,0x54,0x99,
			0xbe,0x9f,0x7f,0x08,0xdf,0x37,0x09,0xb2,0x4f,0xdb,0x7a,0x8a,0x85,0x3d,0x8b,0xf7,
			0x9e,0x12,0xe8,0x85,0x45,0x6b,0x34,0xdb,0xd6,0x43,0x4d,0xed,0xc3,0x54,0xd2,0x72,
			0x36,0x30,0xe3,0x99,0xf8,0x8c,0x28,0xf7,0x91,0xdf,0x15,0xc4,0xb1,0x2c,0x6c,0x48,
			0xce,0x1b,0x03,0x90,0x0f,0x4f,0xc7,0x65,0x69,0xf4,0x01,0x7f,0x08,0x97,0xd8,0xf5,
			0xf0,0x3b,0x17,0xf8,0xe4,0xa9,0x31,0xc1,0x86,0x07,0x83,0xc8,0xc1,0xac,0xd8,0x37,
			0x64,0x33,0x32,0x9e,0x0f,0xce,0xc8,0xe8,0x53,0xdd,0x4b,0x8e,0x15,0xc0,0x6d,0x0a},
			/*TST_output_data*/
			{0},
			/*TST_Expected_output_data for enc Input data for decrypt*/
			{0x65,0x13,0x9c,0x14,0x3c,0xf9,0x05,0xa2,0xa3,0xb0,0x58,0xf3,0x61,0xbb,0x4b,0xd8,
			0x6a,0x71,0x8a,0x79,0x4d,0x90,0xd7,0xe7,0x0c,0x4b,0x83,0x79,0x8c,0x7e,0x64,0x2c,
			0xde,0x29,0x93,0x5e,0x1d,0x5e,0x8b,0xeb,0xfe,0xa6,0x18,0xb7,0x29,0xe7,0x38,0x3e,
			0x8d,0x70,0x7c,0xfa,0xfe,0x6a,0x42,0x90,0x1d,0xc6,0x4a,0x82,0x40,0x26,0x76,0xbf,
			0x31,0x64,0xe6,0x97,0x81,0x1e,0xae,0x71,0xc5,0x8e,0x94,0x79,0xe5,0x2c,0x9e,0x79,
			0x06,0xb3,0x26,0x81,0x89,0x5d,0x7f,0x0c,0x8d,0x7a,0xaa,0xce,0xdb,0x8c,0x91,0x79,
			0x5d,0x70,0x19,0x90,0x9d,0xcb,0x96,0xd9,0xd3,0x44,0x33,0xd7,0xa6,0xd8,0x91,0xbc,
			0x28,0x4b,0x3a,0x43,0xfd,0xc7,0x93,0xd8,0x16,0x5c,0x6f,0x8c,0xac,0x9a,0xec,0x6a,
			0x3c,0x19,0x35,0x24,0x83,0xea,0x0f,0x78,0xe6,0xa9,0x06,0x6f,0xb6,0x59,0x21,0x22,
			0xea,0x61,0x54,0xbc,0x6a,0x7c,0xe4,0x24,0x51,0x65,0x03,0x52,0xda,0x46,0x3e,0x77,
			0x4c,0x0e,0x9b,0xcd,0x0f,0x12,0xa3,0x6c,0x28,0xa6,0xae,0x8e,0x6d,0xe6,0x3c,0xea,
			0xbf,0xd4,0x77,0x17,0x06,0x59,0xe1,0xf2,0x27,0xdb,0x6d,0x51,0x2b,0x33,0x41,0x21,
			0x1f,0x58,0x21,0xaa,0x00,0xe9,0x76,0x24,0xde,0xe8,0xc5,0xf9,0xe3,0xad,0x59,0xd6,
			0x89,0xd7,0x9e,0x43,0xb9,0xae,0xda,0x01,0x92,0x58,0x9d,0x82,0x27,0xba,0xce,0x1b,
			0x5e,0x36,0xaf,0x23,0xbb,0x92,0xaa,0x6e,0xc5,0x53,0x74,0x5d,0x84,0x24,0x23,0x4c,
			0x65,0x1e,0xfb,0xbf,0x57,0x7e,0x8f,0x1d,0xef,0x18,0xc5,0x02,0xe2,0xfd,0x19,0xe9,
			0x9b,0x69,0xf2,0x87,0x10,0xd7,0x5b,0x57,0x04,0xf7,0x32,0x6f,0xeb,0x93,0x92,0xec,
			0x3d,0xb4,0x69,0x0a,0x54,0x45,0x38,0x00,0x71,0x12,0x98,0x85,0x94,0x1c,0x8c,0x4d,
			0x45,0xfc,0x10,0x01,0xf0,0x2b,0xa2,0xca,0x94,0x3d,0xba,0x2a,0x4e,0x50,0x0f,0xd4,
			0xbc,0x17,0x9f,0xe0,0x3d,0x62,0xb3,0x7a,0x9b,0xc3,0x2b,0xf6,0xc5,0x60,0xb3,0x86,
			0x50,0xb2,0x76,0xcf,0x19,0x7b,0x8b,0x88,0x18,0x7e,0x27,0xf4,0xbf,0x47,0x55,0x76,
			0xf7,0xd5,0x05,0x5d,0x80,0x14,0xd1,0xf1,0x72,0x78,0xf3,0xfb,0xb4,0x7b,0x55,0x90,
			0x77,0x18,0xcf,0x7f,0x9f,0x46,0xe1,0x40,0x98,0xf0,0x82,0xd7,0x23,0xd7,0xd4,0x84,
			0xf9,0x5d,0x7e,0x9b,0xea,0x68,0x7e,0x0f,0xa9,0x9a,0x38,0x94,0x61,0xc2,0x93,0x87,
			0x3f,0x45,0xf4,0x99,0xb8,0x4b,0x85,0x9f,0x79,0x43,0x6c,0x6d,0xdc,0x52,0x71,0xa6,
			0x76,0x75,0x54,0xc4,0x6b,0xf0,0xbd,0x0d,0x1f,0xc9,0x9b,0xb5,0xeb,0x6e,0xe1,0x17,
			0x93,0x6f,0x6e,0x4e,0x25,0x39,0xa6,0x81,0x84,0x88,0x0a,0xef,0x7e,0x61,0x00,0x3c,
			0x34,0x70,0xae,0x3a,0xd8,0x74,0x84,0xb9,0x02,0x57,0x4b,0x84,0xe1,0x46,0x64,0x7b,
			0x32,0xb7,0x75,0x13,0xa4,0xc9,0xa8,0x1e,0x11,0xb4,0x9c,0x6a,0x5b,0x22,0xe3,0xf4,
			0x59,0x70,0xf6,0x32,0x93,0x93,0xae,0xe3,0xe4,0xbc,0x62,0x19,0xf1,0x43,0xb5,0xd8,
			0xd9,0x70,0x74,0xc7,0xee,0xd2,0x04,0xbb,0x38,0xb6,0xc6,0x0f,0x7c,0x14,0xa1,0x83,
			0x44,0x12,0x6b,0x45,0xe6,0x42,0x1c,0xb1,0x54,0xff,0x13,0x18,0x8e,0x08,0x30,0x16,
			0xf9,0x84,0xe7,0x5f,0x30,0x43,0x9b,0xe0,0x23,0xbb,0x9f,0x92,0x4e,0xef,0xd1,0xe4,
			0x4a,0xbf,0xee,0x44,0x11,0xbf,0x58,0x63,0xbc,0x76,0xb1,0x84,0xca,0x7c,0xbd,0x10,
			0xc3,0x35,0x43,0x7e,0xa1,0x17,0xe6,0xe5,0xce,0x5a,0x38,0x9d,0xfc,0xaa,0x89,0xcc,
			0x3f,0xd5,0xd3,0x12,0x36,0x6e,0x3f,0x7f,0xb4,0x08,0x7a,0x70,0x9e,0x04,0x64,0xb8,
			0x65,0x84,0x41,0x86,0x3f,0x05,0xd3,0xb1,0xdc,0x78,0x11,0xd6,0xa2,0x27,0xca,0x72,
			0x46,0xe9,0xa8,0x09,0x47,0xca,0x65,0x71,0x00,0xfb,0x72,0x89,0x0d,0xba,0x3e,0xb0,
			0x00,0x83,0xd1,0xfc,0x99,0x35,0x9b,0x49,0x70,0xd4,0x4b,0xc3,0x67,0x78,0xcf,0x4b,
			0x92,0xd7,0xfb,0x97,0x5f,0xc9,0x8d,0x66,0x47,0xf5,0x65,0xec,0xe6,0x11,0x08,0x39,
			0x25,0x87,0xc6,0xfc,0x37,0xeb,0x9d,0x42,0x41,0x18,0xd2,0xc6,0x29,0x9a,0x72,0x94,
			0x68,0x59,0xbe,0x48,0x82,0x74,0xc5,0xfd,0x2b,0x1a,0x62,0xbe,0xdd,0x33,0x39,0x4a,
			0x88,0x00,0x91,0x05,0x16,0x75,0xe1,0x0e,0xd8,0x02,0x83,0x87,0xd7,0xa5,0x83,0xaa,
			0x98,0x80,0x76,0xf4,0x07,0xaa,0xc6,0xda,0xd2,0x10,0x62,0xaa,0x1e,0xd7,0xd9,0x9e,
			0x13,0x94,0x89,0xfe,0xb1,0x3f,0x00,0xe7,0x6f,0xd5,0x85,0x0b,0xd4,0xae,0xdf,0xc6,
			0x36,0x3e,0x01,0x33,0x0f,0xee,0x32,0xa3,0xb6,0x70,0xb1,0x53,0x68,0x0c,0x9b,0x30,
			0x4b,0x9f,0xdf,0xd9,0x81,0x1b,0x1e,0xd9,0xc7,0x5b,0xb9,0xeb,0xc2,0x59,0xdc,0xde,
			0xc4,0x59,0x71,0x55,0xd0,0x67,0x9b,0x65,0x16,0x1c,0x5e,0xce,0x4a,0x3d,0xea,0x80,
			0x13,0x70,0xed,0x72,0x9b,0xf0,0x6b,0x44,0x3a,0x5d,0xdf,0x4c,0xd8,0xd2,0x24,0xcc,
			0x30,0x42,0x20,0x4a,0xde,0x4c,0x98,0xc2,0x76,0x20,0x18,0x39,0x42,0x29,0x5c,0x9b,
			0x72,0x92,0xf6,0x4d,0xcc,0x9b,0x5d,0x7a,0x20,0xb1,0x60,0xbd,0x3a,0xfc,0x92,0x87,
			0x20,0x7f,0x21,0xdb,0x39,0x55,0xa8,0xba,0xb7,0xdf,0x36,0x70,0x81,0xa1,0x3c,0x4c,
			0x1d,0xb0,0x34,0x93,0xd1,0x21,0x67,0x84,0x93,0x31,0x37,0x65,0x5c,0x33,0x8f,0xe7,
			0x55,0x4d,0x5c,0x09,0x3a,0xc7,0xbd,0xb8,0x32,0xde,0xd6,0x87,0x72,0x72,0x4e,0x9f,
			0xc8,0xd5,0xc1,0x69,0xba,0xfe,0x39,0x51,0x31,0x1c,0x51,0xcc,0x0b,0x8c,0x3c,0xb1,
			0xf9,0xd9,0x05,0xa8,0xb1,0xb1,0x19,0xe2,0xb7,0xb2,0x8c,0x14,0x19,0xbc,0xba,0x0c,
			0xb2,0xb1,0xc8,0xbb,0xd2,0x51,0x93,0xe2,0x41,0x81,0xc1,0x16,0xba,0x98,0xbf,0x20,
			0x12,0x30,0x49,0xd3,0xb0,0x7c,0x2a,0x0a,0x04,0xd7,0xb9,0x0a,0x19,0x92,0x82,0x0f,
			0x8a,0x0b,0x09,0x9d,0x77,0x6e,0x75,0xee,0x1b,0x32,0xb9,0xc4,0x74,0xe2,0xb3,0x9e,
			0x2e,0xa5,0xe8,0x14,0xb2,0xa4,0x2c,0x7c,0xe5,0x88,0xb2,0xfd,0xc6,0x19,0x6f,0x51,
			0xe4,0x3d,0x31,0xd4,0xd9,0xa4,0xac,0xe4,0x7b,0x48,0xe2,0xc3,0x96,0xe7,0x5f,0xe7,
			0x0d,0xa4,0x15,0x4b,0x53,0xae,0x66,0xdc,0x67,0x54,0xaa,0x90,0xfa,0x8c,0x94,0xcb,
			0x48,0x15,0x21,0xe2,0x1e,0x61,0x8c,0xb1,0x3a,0xa3,0xa4,0x43,0x88,0x8d,0x26,0xe7,
			0x14,0x22,0xeb,0xc6,0x49,0x96,0xa3,0xe2,0x69,0x61,0x41,0x3a,0x44,0x45,0x0e,0x48,
			0x0b,0xcc,0x78,0x70,0x2d,0x0c,0x3d,0x14,0xf3,0x95,0x37,0x19,0xdf,0xdf,0x01,0x24,
			0x1d,0x9c,0x15,0x06,0x17,0xcc,0x47,0x1d,0xbd,0xa7,0xa9,0xc3,0xb1,0x5c,0x22,0x44,
			0xa9,0xf1,0x9b,0x6f,0x46,0x8d,0xee,0x7a,0x48,0xcb,0x71,0xd5,0xe3,0xf3,0x41,0x05,
			0x9d,0x77,0xd1,0xf5,0xd6,0xcf,0x72,0x03,0xb3,0x12,0x37,0x98,0xd3,0xc8,0x0c,0x36,
			0xce,0xac,0x29,0xa0,0x58,0x14,0xab,0xbc,0xb5,0x7a,0x0d,0xcf,0x94,0x5d,0x5d,0x15,
			0x3b,0x26,0x13,0x0e,0x14,0x71,0x90,0xae,0x31,0x27,0x77,0x0f,0x0e,0x6e,0x40,0x2d,
			0x75,0x37,0x9c,0x81,0x29,0xab,0x94,0x75,0x24,0xef,0xad,0x10,0xa6,0x1f,0x54,0x6f,
			0xd6,0xe9,0x6e,0xd7,0xcf,0xf7,0x63,0x9a,0x4e,0x2a,0x5f,0xe1,0xb1,0xf7,0x3d,0x8a,
			0x68,0xbf,0x09,0x7a,0xf4,0x8b,0xfc,0xf2,0x3f,0x50,0x21,0x5b,0x2b,0x99,0x39,0x25,
			0xba,0x26,0xae,0xab,0xa5,0xee,0x97,0xbc,0x85,0xf1,0x9b,0xb9,0xc8,0xa7,0xec,0xb2,
			0xba,0x02,0x4b,0x9f,0xab,0x68,0xb7,0x11,0x38,0x08,0xbb,0xd9,0x95,0xaa,0x7e,0xeb,
			0xd8,0x02,0x56,0x17,0x8b,0x74,0xf5,0xc5,0x9e,0x48,0x53,0x08,0xc1,0x44,0x37,0xeb,
			0x6a,0x1b,0xb2,0x6a,0xb6,0xaf,0x01,0x18,0xf1,0xa9,0xc2,0xad,0xc4,0x12,0x16,0x83,
			0x5b,0xde,0x91,0xce,0xa5,0xb1,0x1e,0x1a,0x13,0x1e,0x11,0x84,0x51,0x95,0x84,0x85,
			0x71,0xa4,0x0b,0x65,0xd0,0xad,0x61,0x4f,0xc1,0xd9,0x69,0xda,0x98,0x02,0x5a,0x37,
			0x6f,0x11,0x72,0x94,0x35,0x4f,0x6b,0xe5,0x52,0x74,0xe7,0xde,0x87,0x4e,0x1e,0x0c,
			0xbe,0xbc,0xad,0x22,0x4d,0xf6,0xc1,0xd7,0xfa,0x22,0x34,0xb9,0x1e,0x9e,0xe7,0xae,
			0xb7,0x9d,0x8c,0x0c,0x57,0x61,0x10,0x89,0x0c,0xe8,0x7e,0x50,0xb1,0x64,0x1c,0x98,
			0x7b,0xd7,0xc0,0x5c,0xa0,0xfe,0xbf,0x3a,0x2b,0x4b,0xc0,0x22,0x44,0x08,0x22,0x22,
			0x93,0x98,0x85,0xbe,0x25,0xdc,0xcf,0x6b,0xf5,0x2f,0xb0,0x3a,0x50,0xfc,0xe6,0xa4,
			0x1e,0x21,0x8b,0x1c,0x14,0x63,0x5d,0x3f,0x74,0xc0,0xc3,0x6b,0x3a,0x95,0xcc,0xd0,
			0x44,0xd2,0xac,0x0f,0xfb,0x63,0x8b,0x95,0xbc,0x88,0x65,0x06,0xf5,0x7e,0x10,0x01,
			0x84,0x3b,0xc9,0xaf,0x10,0xaf,0x23,0xcf,0x5c,0x35,0xc3,0xd0,0xc3,0xa8,0xc5,0x13,
			0x29,0x8c,0xb6,0xc4,0x95,0x1a,0x37,0x50,0x3f,0x50,0x1b,0x30,0xe6,0x9d,0x26,0xfe,
			0xe5,0xc6,0x65,0x42,0xfe,0x3b,0x62,0xa1,0xf8,0xc9,0xa2,0xba,0x47,0xac,0x8e,0x3d,
			0x0d,0x1e,0x74,0x75,0x99,0x85,0x44,0xfa,0x5e,0x88,0x94,0x4d,0x21,0x86,0x76,0xf7,
			0x1f,0x9c,0x7f,0xd0,0x78,0x27,0x19,0x0a,0x99,0xbe,0xe2,0xd3,0xc5,0xbf,0x7e,0x44,
			0xd6,0x45,0x73,0xb6,0x89,0x72,0x50,0x8c,0xc5,0xd7,0x87,0x5c,0xfb,0x77,0x67,0x8c,
			0x1b,0x02,0x00,0x7c,0x7a,0x1f,0x83,0x63,0xa4,0xee,0x67,0x86,0xd5,0xa7,0x15,0xb7,
			0x5d,0xa8,0x2d,0x28,0x34,0x88,0xb1,0x3c,0x92,0xb6,0x40,0x3b,0xed,0x6c,0x96,0x7c,
			0x8b,0x15,0xd1,0xcc,0x88,0x5c,0x97,0x93,0xa4,0x94,0x26,0x6d,0x5b,0xa2,0xe0,0x2f,
			0x2e,0x48,0xc6,0x6f,0x38,0xea,0xde,0x87,0xeb,0x4a,0xaf,0x0a,0x94,0x05,0xa2,0xf1}, 
			/*TST_dataSize*/
			1536*sizeof(DxUint8_t),
			/*TST_FinishInputData*/
			{0xf3,0xee,0xd1,0xbd,0xb5,0xd2,0xa0,0x3c,0x06,0x4b,0x5a,0x7e,0x3d,0xb1,0x81,0xf8,
			0xef,0x15,0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0xbd,0xb5,0xd2,0xa0,0x3c},
			/*TST_FinishOutputData*/
			{0},
			/*TST_FinishExpectedOutputData*/
			{0x73,0xca,0x86,0x83,0x1b,0x5e,0x4d,0xd4,0x52,0x9d,0xdf,0xc7,0xb4,0x92,0x97,0x6d,
			0x06,0x9e,0x8c,0x82,0x17,0xe1,0xae,0x6a,0x5d,0x99,0xbf,0x76,0xb9,0x90,0xb7},
			/*TST_FinishInputDataSize*/
			31			
		},
#endif


};
#ifndef CRYS_NO_AESCCM_SUPPORT
TST_AES_CCM_TestDataStruct    TST_AES_CCM_Acceptance_TestData[]=
{
{
  {"Acceptance test - AES/CCM/2ByteQ/4ByteMac/7ByteNonce/16ByteAdata/16ByteTextData/128Key"},
  /*AESCCM key*/
  {0xC6,0xBB,0x2D,0x94,0x90,0xB9,0x65,0x23,0x98,0xED,0x83,0x3F,0x9B,0x9D,0x02,0xCC},
  /*additional data*/
  {0x06,0x55,0xAD,0xA9,0x1B,0xFC,0x6D,0xD2,0x88,0x27,0xB7,0x4A,0x76,0x9B,0xDB,0xD6},
  /*full size of additional data*/
  {16},
  /*text data*/
  {0xF7,0x44,0x6E,0xB2,0x73,0xED,0x03,0xE8,0x1D,0x24,0x14,0xFA,0xB8,0x7D,0xC6,0xCB},
  /*data input size*/
  {16},
  /*size of Q field in control block*/
  {8},
  /*Nonce*/
  {0x14,0xD7,0xF6,0xC9,0x3D,0x1F,0x53},
  /*size of N buffer*/
  {7},
  /*size of CCM-MAC (T) */
  {4},
  /* output data*/
  {0},
  /* output data size*/
  {20},
  /*expected data */
  {0x29,0xFC,0x76,0xC8,0x92,0x89,0x65,0x58,0xE5,0x99,0x8B,0xBA,0x89,0x02,0xC3,0xDF,
   0xFD,0xAF,0x7E,0xF2},
  {0},
  
},
//#if 0


{
  {"Acceptance test - AES/CCM/3ByteQ/6ByteMac/12ByteNonce/16ByteAdata/500ByteTextData/128Key"},
  /*AESCCM key*/
  {0xD6,0x06,0xA6,0xE4,0x23,0x89,0xD2,0xED,0x0C,0xEA,0x61,0x72,0x82,0x77,0x81,0xB8},
  /*additional data*/
  {0x8C,0x3E,0x55,0x05,0x6D,0x75,0xAD,0x3D,0x8A,0x14,0x48,0xF3,0xE4,0x92,0xEB,0x3A},
  /*full size of additional data*/
  {16},
  /*text data*/
  {0x92,0xA6,0x04,0xAE,0xE8,0xF6,0xF6,0x0F,0x1C,0x07,0x26,0x49,0xC3,0xBF,0x09,0x53,
  0x43,0xB7,0x82,0x66,0x4E,0xAA,0xDC,0x80,0xAC,0x3B,0x05,0xD9,0x4C,0x09,0x87,0x81,
  0x2F,0x83,0x35,0x81,0x8B,0x3A,0x79,0xD2,0xFE,0xCE,0xEA,0xE0,0x50,0x70,0x88,0x2F,
  0xD5,0x58,0xEE,0x15,0xF2,0x9D,0x2B,0xE8,0xC9,0x84,0x02,0xAD,0xF0,0x1D,0xC2,0x13,
  0x7F,0xA4,0x1A,0x3F,0x89,0x87,0xC8,0x08,0x3D,0xB0,0x68,0x7F,0xC0,0xFC,0x2F,0x3C,
  0xB3,0xD5,0x04,0xF3,0x1B,0x72,0x8E,0x92,0x57,0x4D,0xB8,0x06,0x37,0xCC,0xE1,0xE1,
  0x0B,0xD6,0x60,0xAC,0x56,0x48,0xA6,0x4E,0x8F,0xE5,0xD8,0x42,0x34,0xAC,0x28,0xCC,
  0x55,0xC6,0xFA,0x1B,0x19,0xCE,0xF8,0x0D,0x15,0x87,0xE7,0x3C,0xCE,0xC1,0xD1,0x70,
  0xCE,0x87,0x73,0xE9,0x9B,0x83,0xE5,0x6A,0x2F,0xB6,0x63,0x36,0x99,0x4C,0x5D,0xAB,
  0x24,0xEB,0xB1,0x71,0xD2,0xC6,0xC7,0x3D,0xDE,0x52,0x96,0xCE,0x61,0x6A,0x7F,0xCE,
  0x14,0x67,0x74,0xAD,0x38,0x3E,0x30,0xD2,0xE0,0x8F,0xEB,0x63,0x6B,0xC1,0x73,0xC9,
  0x29,0x3C,0x17,0xE2,0x10,0x5F,0x9E,0x08,0xBF,0x36,0x0B,0x49,0xEC,0x17,0x09,0xC5,
  0x36,0x95,0x21,0x32,0xD8,0xB0,0x72,0xE6,0xBB,0xDF,0x90,0x42,0xDA,0x64,0xD2,0x1C,
  0xDE,0xCD,0xA5,0x24,0x52,0x9C,0xBE,0xB4,0xC9,0x6B,0xEE,0x01,0x33,0xE7,0xE5,0xC9,
  0x86,0x26,0x2C,0xD5,0xA0,0x41,0xF0,0x79,0xC9,0x31,0x27,0x30,0xCE,0x5B,0x2D,0x5A,
  0x64,0xEE,0x6A,0x1E,0x71,0xE4,0x72,0x99,0xD7,0x6D,0x69,0x6C,0xC2,0x71,0xB2,0xD3,
  0xF9,0xC7,0xBC,0xB4,0x38,0xFC,0x7C,0x9D,0xDC,0x2B,0x5B,0x21,0x75,0x8D,0xE6,0x6D,
  0x3E,0x93,0x9D,0x45,0x7C,0xC7,0x57,0xA1,0xB3,0x93,0xFE,0x33,0xD7,0x84,0xB6,0x58,
  0x7E,0x54,0x37,0x07,0x9E,0x78,0x22,0x68,0x72,0xCD,0x41,0x46,0x89,0x50,0x24,0x49,
  0x86,0xFB,0x2D,0x2E,0xD3,0x6D,0x56,0x32,0x6F,0x1B,0x00,0xA4,0xFE,0x49,0xC5,0x58,
  0x75,0x03,0xA3,0x20,0x56,0xDF,0xCF,0xC6,0x71,0x35,0xD2,0xAF,0x85,0x11,0x18,0x62,
  0x6F,0xB4,0xAC,0xDC,0x56,0x88,0x84,0x10,0xFD,0x05,0x97,0x82,0x77,0x7D,0x69,0x28,
  0x07,0xE9,0xD0,0x85,0xAD,0x03,0xF3,0xA7,0x2B,0x67,0xBD,0x9E,0x9A,0xA7,0xAC,0x5E,
  0x03,0x9D,0x35,0x4A,0x9C,0xE8,0x01,0xEC,0x7E,0x92,0x23,0x51,0x48,0x4C,0x4E,0xF4,
  0xCB,0xAA,0xA7,0x9B,0x40,0x92,0xB5,0x6B,0xC0,0x04,0xB0,0xEF,0xCB,0xE6,0x76,0x56,
  0x58,0x38,0x7F,0xD9,0x47,0x1F,0x8B,0x1E,0xE8,0xE3,0x06,0x1B,0xDF,0xA2,0x5F,0xDF,
  0x18,0xC8,0xD2,0xF0,0xFF,0x11,0x1D,0x70,0xE8,0xC9,0x89,0x98,0x38,0x11,0x21,0x98,
  0x1B,0xCC,0xF8,0x0F,0xCC,0x75,0xAC,0xAC,0x1E,0x88,0xB3,0x5C,0x8B,0x9A,0x8C,0x1E,
  0xA5,0xD1,0xD6,0x02,0x13,0x85,0x57,0x47,0x1B,0x0F,0xF1,0x7D,0x96,0xF3,0xE6,0xD6,
  0xC2,0x6E,0xFF,0x13,0xA9,0x50,0x12,0xA3,0x1C,0x26,0xD2,0x76,0x5E,0xC0,0xE4,0x4E,
  0x3D,0x6A,0xF3,0x67,0x3A,0x1F,0x84,0x95,0x75,0xB1,0xF3,0xBD,0x83,0x2E,0x15,0x2A,
  0xA2,0xDC,0x9A,0x1D},
  /*data input size*/
  {500},
  /*size of Q field in control block*/
  {3},
  /*Nonce*/
  {0xA8,0x08,0xCE,0xB9,0xA9,0x8D,0xE4,0xAF,0x70,0x0A,0x5B,0x85},
  /*size of N buffer*/
  {12},
  /*size of CCM-MAC (T) */
  {6},
  /* output data*/
  {0},
  /* output data size*/
  {506},
  /*expected data */
  {0xB3,0xA0,0x32,0x76,0x4F,0x59,0x7A,0x11,0x9F,0xBD,0x9F,0xD4,0x96,0x93,0xA7,0x8D,
  0xFB,0x93,0x2B,0x1B,0x1D,0x95,0xAB,0xC5,0xB6,0x79,0x5D,0x3A,0x25,0xB3,0x11,0xAF,
  0x6B,0x0E,0x00,0x2B,0xF6,0x43,0xCF,0x00,0x28,0x9C,0xB1,0x9D,0x18,0x3C,0xE8,0x9D,
  0x7C,0x46,0xD4,0xC8,0xE4,0x6B,0x73,0xDA,0x59,0x53,0x31,0x48,0x7A,0x06,0x80,0xFB,
  0x49,0x02,0x9E,0x4F,0x5F,0x41,0x08,0xED,0x98,0x5F,0xA1,0x63,0x93,0xC3,0x8B,0xD0,
  0xBF,0xB2,0x80,0x32,0x33,0x1D,0x56,0xBC,0xFD,0x09,0x79,0x75,0x1B,0x8B,0xF3,0x92,
  0x1D,0xE3,0x2F,0x84,0xAD,0xEC,0xDF,0xBC,0xDB,0xE8,0x27,0x85,0x21,0x79,0x4B,0x3E,
  0xBD,0x2E,0xB3,0x49,0x92,0x1D,0xA9,0x5B,0xA6,0x72,0xBE,0xDC,0xB9,0x35,0x09,0xBA,
  0xD7,0xF8,0x8D,0x6E,0x90,0x90,0x56,0xB4,0xC9,0x36,0x1E,0xD2,0x82,0x78,0x15,0x3A,
  0x4D,0x54,0x9D,0xAC,0xDB,0x04,0x2F,0xF4,0x48,0xC8,0x37,0x72,0xCF,0x58,0x73,0x8F,
  0xD5,0x13,0x6B,0xB5,0x45,0x73,0x09,0xAD,0x13,0xD8,0x51,0x8A,0xDF,0x8E,0x86,0x19,
  0xA4,0x0B,0x6C,0x4F,0xCE,0x0F,0x2B,0x68,0xE6,0xB6,0xA0,0xD2,0x51,0xC6,0xDE,0x1F,
  0x41,0x67,0x92,0x7F,0xAB,0xF0,0x69,0x30,0x30,0xB4,0xBF,0x9A,0x33,0xBF,0x70,0x6B,
  0xD5,0x87,0x63,0x8D,0xAC,0xF1,0xA4,0x11,0x99,0x13,0xAC,0x2F,0xD9,0xF2,0x29,0xC6,
  0x72,0x48,0x68,0x14,0x84,0x17,0xC9,0x4A,0x05,0xC0,0x83,0x52,0xDD,0x2F,0xCD,0xBC,
  0x12,0x94,0xB3,0x98,0xEF,0x5D,0x61,0xA8,0x36,0xA6,0x84,0x0C,0x5C,0x59,0xF1,0xA7,
  0x78,0x39,0x01,0xE5,0x05,0x75,0xB3,0xC9,0x04,0xF1,0x93,0xD1,0x1D,0x24,0xC6,0x32,
  0x4C,0x29,0x2D,0x29,0xAE,0x95,0x2B,0x6C,0x50,0xC5,0xDA,0xA4,0x7B,0x6E,0xDA,0xB1,
  0xDC,0xCE,0x77,0x57,0x2A,0x78,0x13,0x08,0xF0,0xB8,0x05,0x6B,0x77,0x32,0xD3,0x9C,
  0xCF,0xB1,0xBB,0xBB,0xA2,0xAD,0x81,0xF8,0x28,0xC8,0xCE,0x01,0x6A,0x73,0x21,0xC9,
  0xFA,0xA7,0x75,0x82,0x3D,0x38,0x32,0xEB,0xC4,0x02,0x08,0x75,0x18,0x80,0x11,0x83,
  0x23,0xAF,0x47,0xA4,0x3C,0x49,0x2D,0x42,0xF7,0x57,0xA7,0xC2,0x21,0x85,0x82,0xFA,
  0x6C,0x38,0xE2,0xDA,0x21,0x55,0xD2,0x5F,0x59,0xAB,0x3A,0xF8,0xC0,0xF4,0x1E,0x3E,
  0x88,0x17,0x58,0x31,0x51,0x66,0x5E,0xE6,0x33,0x81,0x8B,0x69,0x9C,0x5E,0xE4,0x5F,
  0x68,0xD2,0xC8,0xAA,0xD2,0x00,0xA1,0xAF,0x28,0xD0,0x26,0x67,0x58,0xB8,0x99,0x11,
  0xDF,0x05,0xE8,0xD9,0x36,0xF7,0x3D,0x8D,0x5E,0x83,0x68,0x3F,0xEB,0xAB,0x8E,0x41,
  0x49,0xDB,0x7C,0x03,0x6D,0xC4,0x7E,0x6A,0xEA,0x70,0x8F,0xCD,0x6C,0x9D,0x4B,0xA0,
  0x67,0x42,0x79,0x34,0xFF,0xD1,0x65,0x28,0x7A,0x9E,0x4B,0xBD,0x4C,0x06,0x55,0x69,
  0xE2,0x8E,0xCB,0xC5,0xE1,0x02,0x32,0x33,0xB7,0x3F,0xAE,0xFA,0xE7,0x81,0x16,0xFE,
  0x82,0x4C,0x44,0xD8,0xFF,0x03,0x34,0xAC,0x57,0x14,0xE0,0xEF,0x3F,0x78,0x3C,0x48,
  0x13,0x5E,0x2E,0x7A,0x56,0xE7,0x84,0x27,0xC9,0xBA,0x8F,0xE6,0xA8,0x0D,0xF8,0xE5,
  0x4E,0x80,0x62,0x95,0x2E,0x1A,0xD9,0x76,0xAE,0x45},
  },

  {
  {"Acceptance test - AES/CCM/8ByteQ/8ByteMac/7ByteNonce/16ByteAdata/1024ByteTextData/128Key"},
  /*AESCCM key*/
  {0xDC,0x41,0xD8,0xB1,0x62,0x77,0x32,0x81,0xB7,0xEB,0xDC,0xF2,0x72,0xE6,0xE0,0xB9},
  /*additional data*/
  {0x69,0x23,0x64,0xA6,0x65,0x8B,0x45,0xD3,0x5C,0x47,0xFE,0x13,0xC5,0x60,0xB9,0x8A},
  /*full size of additional data*/
  {16},
  /*text data*/
  {0xCC,0x09,0x72,0x4A,0x73,0xB9,0xBC,0xA7,0x34,0xC0,0xCD,0x1D,0xDE,0xFC,0x2E,0xB3,
  0x52,0x10,0xB1,0x97,0x00,0x51,0xE0,0xDF,0x60,0xA1,0x05,0xC6,0xC0,0x2B,0x69,0xA2,
  0x2C,0x1D,0xF5,0xDE,0x92,0x6C,0x84,0x20,0x28,0xF7,0x8B,0xF8,0x7A,0xB3,0xF5,0x2A,
  0xCB,0x04,0xBD,0x68,0x52,0x78,0xB1,0x7A,0x29,0x92,0xE9,0xD2,0xB4,0xF6,0xE7,0x09,
  0x56,0x2B,0xF0,0xC0,0x06,0x4F,0x20,0xE5,0x8C,0x91,0x6E,0x08,0xC6,0xE8,0x64,0xAD,
  0xAB,0xDB,0xFA,0xBC,0x6D,0x01,0x50,0xB4,0x6C,0x7B,0xB5,0xFF,0x82,0xB2,0x6C,0x32,
  0x10,0x81,0xA2,0x4F,0xC3,0x35,0x24,0x7B,0xE3,0xD8,0xDC,0xC1,0x09,0xA8,0xB4,0x40,
  0x2D,0x3C,0x26,0xD8,0xFB,0x2A,0x9B,0x54,0xDA,0x3B,0x53,0x8B,0x9A,0x21,0x62,0xD9,
  0x24,0x3C,0xF8,0x44,0x46,0x15,0xEA,0x76,0xB7,0x7F,0xD8,0x95,0x25,0x8F,0xAA,0xC4,
  0xC7,0x74,0xD1,0x46,0x8B,0x93,0x36,0xE5,0xE6,0x4D,0x75,0x87,0xE1,0x98,0xE1,0xC2,
  0x75,0x02,0x9C,0xCD,0xB0,0x6F,0xFA,0x18,0x52,0xAF,0x21,0x7C,0x52,0x05,0x2F,0x4A,
  0x91,0x8F,0xC4,0x25,0x4F,0x1C,0x4D,0x91,0x06,0x13,0x5E,0xF8,0xA0,0x62,0x95,0x1E,
  0x9E,0x15,0x20,0x22,0xF3,0xDD,0x14,0x57,0x7A,0xB9,0xF3,0xDC,0x71,0xB9,0x93,0xE0,
  0x1E,0x2A,0xF6,0x51,0xD4,0xBC,0x73,0x58,0xB4,0x0B,0xC6,0x9D,0x10,0x01,0x78,0xEF,
  0x1A,0x03,0xDE,0x3C,0xE5,0x0C,0x57,0xB3,0x7B,0x6C,0xAA,0x95,0x29,0x71,0x1F,0x4C,
  0x7F,0x7D,0xDA,0x75,0x6C,0x43,0x49,0xE1,0xA2,0xC7,0x6E,0xE7,0x16,0x76,0x47,0x78,
  0x40,0x03,0xC2,0x6E,0xDB,0x57,0xFA,0x12,0xD2,0x42,0xD6,0x68,0x11,0xDD,0x2F,0x43,
  0xEB,0x79,0x1D,0x92,0x27,0x02,0x83,0xD6,0xB9,0xFC,0x99,0x1E,0x9E,0x6F,0x9D,0x04,
  0x25,0x32,0x55,0x25,0xAF,0xB1,0x71,0x28,0x83,0xC8,0xA3,0x29,0x6D,0xE1,0xD0,0xC4,
  0x97,0x2A,0xFC,0x9C,0x59,0xB4,0x50,0x3D,0x7F,0xEB,0xB4,0xDF,0xBD,0xDC,0x74,0x62,
  0xA5,0xD1,0x43,0xDF,0x88,0x0A,0x94,0x39,0x08,0xF4,0x0F,0x5F,0x5F,0x59,0x69,0xD8,
  0x2B,0xD5,0x86,0x73,0x73,0x00,0xAB,0x70,0xE1,0x17,0xA5,0xC4,0xFD,0x91,0x6B,0xA6,
  0x53,0x41,0x84,0x9B,0x9E,0xF1,0x3C,0x8D,0x96,0xC2,0x93,0x64,0xA4,0xF1,0xDE,0x26,
  0x81,0xDC,0xB3,0xE8,0x56,0x00,0xEF,0xA5,0x26,0xD2,0xFD,0x70,0x64,0xCF,0x3C,0x77,
  0x89,0x69,0x0B,0x1E,0xD4,0xCD,0x39,0x3A,0x98,0xF8,0xDC,0xB0,0x6C,0x46,0xCB,0xF0,
  0x39,0x7F,0x42,0x21,0xDE,0x83,0x50,0x53,0x52,0xDF,0x75,0xCB,0xF3,0xCB,0x29,0xC7,
  0x86,0x1C,0xDB,0x3B,0xE5,0xC0,0x51,0xB3,0xA2,0x79,0x4F,0x5D,0x24,0x3E,0x38,0xE0,
  0x06,0x0D,0x37,0xE5,0x8D,0x1B,0x98,0x06,0x18,0xB8,0xCC,0xF5,0x58,0x6E,0x46,0xCD,
  0xCF,0x15,0x29,0x4F,0x6A,0x90,0x0A,0x78,0x2E,0x8F,0x7E,0x65,0x33,0xF2,0x2E,0x13,
  0xA6,0x95,0xC5,0xE6,0x93,0x44,0x3A,0x6B,0x84,0xD5,0x22,0x2C,0xF4,0x5C,0x5B,0x34,
  0x32,0x81,0x8D,0x0F,0x14,0xE9,0x75,0x76,0x02,0xBF,0xB7,0xFD,0x9C,0x33,0xD2,0x25,
  0x8A,0xB8,0x4E,0xC2,0xA8,0x5F,0x3A,0x8B,0xDB,0xBE,0xCB,0x95,0x6D,0xDE,0x84,0xD1,
  0x33,0x4A,0x32,0xB2,0x65,0x1E,0xFE,0xBD,0x20,0x4E,0xE4,0xD4,0x8D,0x3C,0xCE,0x50,
  0x02,0xFD,0xA2,0x3B,0x0D,0x99,0x8B,0xD3,0x47,0x02,0x34,0x56,0x1D,0xDF,0x09,0x24,
  0x3A,0xE5,0xCA,0x51,0x01,0x20,0xC0,0x6B,0xBA,0x90,0xA2,0x5A,0x7B,0x65,0xFE,0x9E,
  0xEF,0x7A,0x93,0x70,0x3C,0x49,0xC3,0x9A,0xBF,0x5F,0x6A,0x62,0xEA,0xA8,0x9F,0x41,
  0x45,0xC0,0x9A,0xA8,0x71,0x7D,0x4F,0xE1,0x3C,0x36,0x81,0x7D,0xF6,0x30,0x57,0xE1,
  0x04,0x95,0x66,0xA2,0x4B,0x99,0xE7,0xF0,0x21,0x2F,0x91,0xA2,0xB6,0x5D,0x81,0x12,
  0xF0,0x60,0x15,0xBB,0xCB,0x56,0x2D,0x72,0x2B,0xB1,0x33,0x05,0xC8,0x46,0xA3,0x8E,
  0x07,0x88,0x5E,0x54,0x41,0xFC,0xF5,0xAB,0xD8,0xA9,0x86,0x42,0xEB,0xAD,0x2B,0xDE,
  0xB4,0x6F,0x8C,0x96,0x1B,0x9C,0x16,0xAE,0x68,0xF4,0x77,0x9A,0x65,0xE1,0x28,0xDA,
  0x8C,0x02,0x9A,0x2D,0xFF,0x2D,0xD0,0xF3,0x6B,0x69,0xE2,0x22,0xCF,0xEB,0x86,0x7E,
  0x85,0x54,0x51,0x59,0xB9,0x0D,0x73,0x6A,0x72,0xAF,0xEC,0x4D,0x85,0x5A,0x45,0xF6,
  0x80,0xAB,0xB6,0xE8,0x12,0xFE,0xDF,0x87,0x9E,0x99,0x2A,0xB2,0xB9,0xF3,0xDF,0x7D,
  0x6D,0xF9,0x14,0x10,0x90,0xCF,0x21,0x7E,0x8F,0x2F,0xBA,0x4F,0x40,0x83,0x6E,0x10,
  0x23,0xEC,0xA1,0x23,0x35,0x9E,0x6B,0x87,0x75,0xC9,0xBA,0x20,0xE3,0xC1,0xB1,0x7E,
  0xD0,0x6F,0xE0,0x8C,0x46,0x34,0x66,0xB1,0x8A,0x37,0x59,0xE2,0x43,0x8F,0x46,0x1B,
  0x2A,0x19,0x8E,0xCD,0x52,0xBB,0x48,0xCF,0x8D,0x8D,0x9B,0xC6,0x15,0x01,0x9B,0xCD,
  0x7E,0x3C,0x7E,0xD1,0xA3,0xE2,0xCA,0xEE,0x86,0xF0,0x98,0xFD,0x44,0x89,0x43,0xE6,
  0x82,0x9E,0xF5,0xC9,0x32,0xE4,0x2C,0x15,0x26,0x10,0xFE,0xB8,0x99,0x9F,0x9B,0x89,
  0x9C,0x8B,0x64,0x07,0x10,0x75,0x78,0x48,0x4F,0x9F,0x47,0x61,0x22,0x4A,0x8A,0x04,
  0x49,0xB4,0x43,0x76,0x0B,0xD1,0x9B,0x9A,0x10,0x69,0xAA,0x92,0xE3,0x11,0x54,0xE6,
  0x54,0x0F,0x61,0xB9,0x25,0x3C,0xD5,0x0D,0x26,0xAC,0x79,0x92,0x9C,0xCA,0xF2,0xDC,
  0x86,0xFA,0x6E,0xE4,0x5B,0x25,0x7D,0xCA,0xF0,0xC9,0xF6,0xA6,0xCA,0xE6,0x65,0x3D,
  0x4A,0x60,0x0D,0x13,0xE9,0xD1,0xDF,0x0D,0xDF,0x35,0x50,0x5F,0x57,0x08,0xFD,0x46,
  0x77,0xCE,0x0B,0xE8,0xA2,0x70,0x8A,0x2E,0x92,0x96,0xC9,0x5B,0x45,0x2E,0x43,0x3F,
  0x46,0x3C,0x47,0x3C,0xBC,0xDF,0xF2,0xB5,0x1B,0x61,0x05,0x25,0xD5,0x1E,0x72,0xE8,
  0xCC,0xB0,0x2F,0xFC,0xDA,0x7D,0x9B,0xDA,0xD6,0xDE,0x80,0x52,0x08,0x83,0xC8,0xB0,
  0xF2,0x10,0x18,0x1B,0xC0,0xC1,0x89,0x98,0xDB,0x56,0xCC,0x41,0x6A,0x64,0x59,0x73,
  0x24,0xE0,0x8E,0x94,0xFF,0x46,0x65,0xC9,0xA0,0x6C,0x65,0xDE,0x5E,0x9F,0xAD,0x97,
  0x99,0x55,0x33,0xC5,0x05,0x56,0x27,0x0A,0x27,0x97,0x20,0x83,0xB0,0x5A,0x70,0x71,
  0x84,0x0C,0x2E,0x27,0xF5,0x33,0xB1,0xAB,0xAA,0x4E,0x7B,0x53,0x5B,0xAA,0x39,0x3B,
  0xA9,0x35,0xA7,0x15,0x31,0x94,0x6E,0xCD,0xB9,0x83,0x6C,0x68,0x26,0xE1,0x19,0x46,
  0xFC,0xF3,0x59,0x51,0x71,0x85,0xA2,0x65,0xA4,0x87,0x1A,0xB6,0xDB,0xD4,0xAF,0x7D},
  /*data input size*/
  {1024},
  /*size of Q field in control block*/
  {8},
  /*Nonce*/
  {0x4D,0x79,0x65,0xF7,0x9B,0x54,0x52},
  /*size of N buffer*/
  {7},
  /*size of CCM-MAC (T) */
  {8},
  /* output data*/
  {0},
  /* output data size*/
  {1032},
  /*expected data */
  {0x75,0xD0,0x76,0xC1,0x97,0x99,0xB6,0x5A,0xA9,0xF4,0xB3,0x83,0x1A,0xFE,0x95,0x40,
  0xDD,0x32,0x76,0x23,0x8B,0xB1,0xB7,0x82,0x25,0x21,0x27,0xC9,0xA1,0xE5,0x93,0x5C,
  0x74,0xD5,0xB1,0x2A,0x7C,0xD5,0xE5,0x31,0x42,0x9D,0xBE,0x75,0xF1,0x2E,0x3F,0x45,
  0xEE,0x67,0x26,0xD7,0xF6,0xD3,0xF5,0xBF,0x17,0xD5,0xC0,0x0E,0x76,0x4A,0x45,0x33,
  0x3F,0x41,0xEE,0x4A,0xDD,0x8A,0x78,0x92,0xB7,0xE2,0xC6,0x3B,0x1F,0x93,0xC4,0xC9,
  0xF9,0x96,0x03,0xD3,0xA6,0x72,0x8C,0x4D,0x7B,0x23,0x36,0xE8,0xD6,0xE0,0x02,0x5D,
  0x32,0x7E,0xBB,0xBE,0x5C,0xA7,0xA7,0xEC,0xF4,0x53,0x1F,0xED,0xB7,0x02,0x45,0xF4,
  0x2F,0x44,0x81,0x59,0xE0,0x7B,0xD4,0x5A,0x9A,0x6F,0x4A,0x88,0x26,0xCD,0xDD,0xE0,
  0xD4,0x4E,0x7D,0xFA,0xBC,0x78,0x77,0x9D,0xED,0x31,0x27,0xD2,0x4E,0x50,0xE2,0xB5,
  0xB9,0x7C,0xE7,0xD6,0x5E,0x42,0x5D,0x24,0x29,0x92,0x50,0xD7,0xB7,0x74,0xFA,0xA6,
  0x20,0xD9,0xB3,0xFE,0xF9,0x87,0xDA,0xDB,0x56,0xB6,0xE9,0x9C,0x4C,0x6A,0x39,0x48,
  0xAF,0x05,0xEE,0x83,0x54,0x17,0xBC,0x42,0x8D,0x79,0xDD,0x07,0xA3,0x1D,0x48,0x32,
  0x4C,0xE3,0xB6,0x89,0x02,0x8E,0xB1,0x89,0x42,0x7C,0x92,0x3C,0x01,0x90,0xEE,0x43,
  0xBA,0xEE,0x01,0xB8,0x32,0x1A,0x36,0x2D,0xC1,0x15,0xB2,0x12,0xB5,0x1B,0x01,0xE0,
  0x8B,0x3C,0xCA,0x2E,0xCC,0x5D,0x52,0x52,0x91,0x9D,0x73,0xC8,0x28,0xDF,0xCA,0x20,
  0xF1,0xF9,0x2D,0x99,0x55,0x6D,0xF4,0x4B,0xBF,0x01,0x30,0x70,0x54,0x7F,0xC3,0xF9,
  0x6C,0xEF,0xED,0x03,0x4A,0x0F,0xBE,0x09,0xE3,0xBE,0xB1,0x6F,0xFE,0xEF,0x18,0xE1,
  0x7F,0x73,0x60,0x85,0x3C,0x5A,0xDC,0x52,0xA3,0x8F,0x8D,0x93,0xBA,0xDE,0x77,0xA7,
  0xA9,0xFA,0xE5,0x8E,0xFB,0xD8,0xDC,0x01,0xCC,0x42,0x09,0xEB,0x2F,0x31,0x1A,0xA2,
  0xF3,0x15,0x8B,0xAA,0xFC,0xA8,0x30,0xE5,0x8C,0x3C,0x0F,0x3D,0x40,0x92,0x07,0x66,
  0xFB,0xBB,0x40,0xB3,0xBE,0x67,0x53,0xAA,0x27,0x49,0xB1,0x5A,0xAA,0x61,0xFD,0xD3,
  0xB8,0xE8,0x43,0x4B,0xC7,0x17,0x62,0x95,0xC6,0xDF,0xD2,0x72,0x57,0x94,0x85,0x12,
  0x5F,0x68,0x6E,0x91,0xD1,0xD7,0xA7,0x9B,0x70,0xD0,0xDF,0x92,0x9A,0x3E,0x35,0xCA,
  0x2B,0xDA,0x19,0xFF,0x6F,0x2E,0x72,0x8A,0xA1,0x83,0xB3,0xAE,0x52,0xD0,0xC9,0xBA,
  0xC5,0xE9,0x24,0x13,0xAF,0x37,0x70,0xE1,0x19,0x8A,0x5A,0x85,0x1D,0xEC,0x22,0xA3,
  0x13,0xEC,0x1D,0xCB,0xAF,0x0A,0xA3,0xAE,0xEA,0xC0,0xE7,0x80,0x48,0xDA,0x20,0x40,
  0xC9,0x3C,0x02,0x18,0xE0,0x85,0xE2,0x6D,0x62,0xCE,0x17,0xB8,0x6F,0x98,0x42,0xDE,
  0x9E,0x86,0x34,0x3D,0x28,0xCD,0xB0,0x4C,0x1F,0x73,0x96,0x3D,0x22,0xB0,0x7C,0xF8,
  0x8B,0xE5,0xB7,0x3E,0x2C,0x52,0x4F,0x6B,0x71,0x77,0xBC,0x04,0x9C,0xDB,0x59,0x5F,
  0xE1,0xAC,0x3D,0x9C,0x2E,0x0A,0x96,0xA1,0xF2,0x73,0xA8,0x53,0xB3,0x04,0x86,0x0A,
  0xF1,0xF6,0xCF,0x78,0xBC,0x49,0x13,0x2F,0x16,0x47,0xB3,0x59,0x97,0x60,0xCA,0xBE,
  0x8D,0xAA,0xF0,0x5F,0x1E,0x64,0xA0,0x7E,0xDA,0x55,0x40,0xC2,0xCE,0x0C,0x70,0xA6,
  0x64,0x5F,0x06,0x78,0x92,0x64,0x84,0xC1,0xF1,0x8E,0x71,0xA9,0x98,0xDF,0xEB,0xBD,
  0xEB,0xE0,0x73,0x3A,0x75,0x68,0xFA,0x9C,0x2A,0xD8,0xC3,0x54,0x6D,0x24,0x53,0x66,
  0x66,0xFC,0x2E,0x83,0x6D,0xEF,0x0D,0xE8,0xEF,0x6F,0x19,0x0A,0x73,0xE8,0xD0,0x78,
  0x9E,0xC5,0x20,0x25,0xF2,0x40,0x30,0x9D,0xEC,0xC1,0x3A,0x5A,0xAD,0xB0,0xBC,0x60,
  0x2A,0xD3,0xE2,0xF1,0xBE,0x99,0x9E,0xE1,0xE6,0x34,0xD4,0x71,0x60,0xA4,0x1D,0x70,
  0xEC,0x36,0xE0,0x4A,0xC5,0x06,0xF0,0xE0,0xB1,0x50,0x03,0x15,0xDD,0x37,0xA5,0x61,
  0xC9,0x23,0x52,0x5F,0xBA,0x26,0x70,0x2E,0xA8,0xF7,0x34,0x53,0x4E,0x87,0x58,0x36,
  0x8E,0x95,0xDF,0x24,0x37,0xEF,0xD0,0x14,0xB2,0xE8,0x28,0x4B,0xDE,0x41,0x1D,0x9A,
  0xAD,0x5A,0x1A,0x52,0x2B,0x77,0xC5,0x62,0x38,0xB8,0xBA,0xAF,0x5E,0x80,0xC3,0x8C,
  0x87,0xB0,0x18,0x7F,0xCE,0x02,0x25,0x62,0x0A,0xEA,0x9E,0xCF,0xF1,0x49,0xC6,0x5B,
  0xEF,0x1B,0x7B,0x56,0x74,0xFB,0xD2,0xC5,0x09,0xB4,0x71,0x1F,0xB8,0x9E,0x4A,0x3C,
  0x2F,0xBA,0x57,0x51,0xBC,0xC0,0x37,0xA5,0x31,0x7C,0xD8,0x8E,0xE9,0x3B,0x60,0x9B,
  0x0D,0x13,0xEB,0x8F,0x1B,0x55,0xC8,0x42,0xA0,0x85,0x2D,0x36,0x96,0x22,0x94,0xD3,
  0x20,0x3F,0x8B,0x28,0x08,0x0D,0x9A,0xA9,0x53,0xF5,0xAD,0xEA,0xD0,0xD7,0x42,0x8A,
  0xCC,0x5D,0x0F,0x5C,0x8C,0x7D,0x3A,0x0B,0x44,0x85,0x64,0x59,0xF0,0xF1,0x06,0xB9,
  0x7D,0x78,0x69,0xFD,0xBA,0xD7,0xC3,0xD5,0xC7,0xD4,0x6C,0x70,0x97,0xD5,0x89,0x4F,
  0x26,0x30,0x98,0x1D,0xAE,0x62,0x0B,0x66,0x4C,0x9B,0x6A,0xFE,0x12,0x57,0xBC,0xB7,
  0x14,0x8E,0xA7,0x36,0x2A,0x03,0x47,0x09,0x38,0x67,0xDF,0xAA,0x74,0x50,0x74,0xC2,
  0x3D,0x8E,0x97,0xF8,0x6E,0x5A,0x6C,0x27,0x96,0xCB,0x87,0x76,0x72,0xB5,0x20,0x2B,
  0x9D,0x4C,0xFE,0x1C,0x6C,0xB5,0xD9,0x82,0x85,0x10,0x93,0x26,0xE9,0x83,0xDA,0xBC,
  0xCC,0x38,0xE9,0x89,0xAA,0x19,0x11,0x14,0xFB,0xFD,0xAF,0x00,0x31,0xBC,0x57,0xC4,
  0x27,0x55,0xEE,0x50,0x50,0xF6,0x12,0xB9,0xC7,0xD1,0x17,0xA1,0x8D,0x9A,0xB4,0x19,
  0xF1,0x24,0x30,0xBD,0x1B,0x0D,0x4F,0xF1,0x44,0x81,0x2A,0xB7,0x71,0x11,0xAE,0x28,
  0x11,0x91,0x85,0x77,0x96,0x6B,0x13,0x89,0x84,0xEF,0x92,0xB6,0x05,0xFD,0xCE,0xE9,
  0xDE,0x2D,0xBD,0x00,0x01,0x17,0x01,0xC2,0xF2,0xA1,0x3D,0xC2,0xA1,0x39,0xEC,0x4C,
  0x52,0xBB,0x4A,0x58,0x58,0x59,0xC6,0x67,0xF4,0x6A,0xF6,0x48,0xF0,0x22,0x20,0x38,
  0x80,0xE8,0x9A,0xAB,0x0D,0xEA,0x23,0x0E,0x9A,0x85,0x30,0x66,0xBC,0x29,0x80,0x39,
  0x6A,0x4D,0x62,0x87,0xA0,0x47,0x1D,0x9D,0x16,0xE4,0x95,0x06,0xEF,0xD3,0x57,0xC3,
  0xFB,0xA4,0x81,0x40,0x2A,0x18,0x0A,0x19,0xE9,0xDA,0x70,0x48,0xD4,0x72,0x55,0xC3,
  0xFF,0x17,0x9F,0xD4,0x12,0x6E,0xEA,0xA3,0x64,0xD8,0x65,0x0B,0xF7,0x00,0xE2,0xAB,
  0xE9,0x72,0xF2,0xD6,0x03,0x61,0x6D,0xDE,0xF7,0xCE,0xF7,0x19,0x01,0x28,0xFC,0xA0,
  0x5F,0x47,0x12,0x14,0xE9,0x54,0x0E,0x7A,0xAB,0xE4,0x56,0x83,0x1F,0x39,0x69,0x03,
  0x79,0x0E,0x57,0xBF,0x6B,0x6E,0x5D,0x82},
  {0},
},

{
  {"Acceptance test - AES/CCM/2ByteQ/6ByteMac/13ByteNonce/500ByteAdata/16ByteTextData/128Key"},
  /*AESCCM key*/
  {0x41,0x93,0x43,0x0F,0x33,0xE8,0xCC,0x4E,0x73,0x47,0xAF,0xFD,0xF3,0x5C,0x13,0xAB},
  /*additional data*/
  {0x23,0xE3,0x6F,0xEC,0x9D,0xC8,0x04,0x2D,0x3D,0xD2,0x2E,0x1D,0x17,0xD6,0x57,0xF4,
  0xE9,0x01,0xC0,0xD7,0xC5,0x2C,0x66,0x22,0x13,0x97,0x76,0xF2,0x5F,0x7E,0x44,0x5B,
  0xBC,0xC0,0x3F,0x42,0xD8,0x5D,0xC7,0xA6,0x50,0x81,0xF6,0x1B,0x74,0x0C,0xDF,0x3C,
  0xF6,0xB1,0x77,0x7D,0x1E,0xB4,0xAD,0xF6,0x7D,0x4C,0xD9,0x06,0x52,0x12,0xCE,0xBF,
  0x8D,0xD2,0x60,0x57,0x97,0x14,0x1B,0x8B,0x3A,0x19,0x87,0x44,0x36,0x4B,0xAD,0x06,
  0xB8,0x39,0xFC,0xAE,0x06,0xC6,0x3D,0x07,0x13,0x48,0xC4,0x8B,0x84,0xC0,0x53,0x3D,
  0xB3,0x37,0x8D,0xA1,0xAB,0x88,0xA5,0xE1,0x96,0xEB,0x43,0x04,0x2D,0x68,0xBF,0x32,
  0x9F,0xD2,0x4D,0x19,0x16,0x1F,0xB8,0xC6,0x95,0x59,0x43,0x4E,0x4F,0x8F,0x07,0x79,
  0xC5,0x49,0x90,0xFF,0xBD,0x0C,0x5A,0x30,0x94,0x1A,0x17,0x1B,0x83,0x39,0xDA,0xAA,
  0x88,0x92,0xEC,0xB1,0x73,0x3A,0x27,0x93,0x7E,0xC7,0x0C,0x52,0x44,0x56,0x92,0x07,
  0xE3,0xCA,0x3F,0xE3,0xD7,0xC0,0x75,0x92,0x77,0x1D,0x85,0xFC,0x08,0x9C,0x43,0x5B,
  0x7E,0x99,0xC5,0xBD,0xA2,0x55,0x05,0x8A,0x22,0xFD,0x80,0xF6,0xFF,0x08,0xEC,0x3D,
  0x88,0x10,0x37,0xB8,0xF9,0xF7,0xD2,0xC8,0x1D,0x5A,0x3A,0x56,0xB5,0x2A,0x8B,0xE2,
  0x83,0xB1,0xD4,0xAB,0x90,0xD5,0x65,0x8E,0xC4,0xB4,0xC0,0xDA,0x40,0x7F,0x93,0x6F,
  0x30,0x47,0x73,0xF8,0x65,0x8A,0x62,0x87,0xC6,0xFD,0xA0,0x48,0x1B,0xAF,0xD5,0xF7,
  0x72,0x9E,0x72,0x4E,0x34,0x40,0xAD,0xB2,0xAB,0xA9,0xF3,0x45,0x36,0xF8,0x88,0x9E,
  0xC6,0xCA,0x25,0x6D,0xB6,0x93,0x7D,0xF8,0x4E,0x4C,0xE4,0x93,0x35,0x1D,0x73,0x15,
  0xDF,0xC9,0x68,0xA1,0x0C,0x45,0x3B,0xEF,0x9A,0xC1,0x4C,0xBB,0x97,0x1C,0x51,0xCE,
  0x75,0x02,0x81,0x50,0x89,0x67,0x40,0xDE,0x21,0x79,0xFF,0xE7,0x5C,0x1A,0x7D,0x8E,
  0x35,0xDE,0x66,0x6D,0x8F,0xE6,0x91,0x80,0x8F,0x35,0xD3,0xF5,0x46,0xC1,0x61,0x31,
  0xFB,0x16,0x1D,0x33,0x9B,0x22,0x8B,0x77,0x88,0x89,0x80,0x92,0x46,0x53,0x93,0x80,
  0x43,0xBE,0x86,0xB8,0xB6,0xE3,0x3E,0x8E,0x70,0x01,0xC0,0x54,0x94,0x4A,0x98,0x5F,
  0x17,0xCD,0xEC,0x45,0xFC,0x4A,0xF2,0x13,0x52,0xEF,0xE5,0x06,0x65,0xFE,0x3A,0x3C,
  0xA1,0x52,0xB2,0x87,0x3B,0xA8,0x7B,0x17,0xD8,0x8E,0xC2,0x99,0x61,0x37,0xE2,0x3D,
  0xF0,0x21,0x7B,0x78,0x67,0x4E,0x84,0xF8,0xCC,0x72,0x66,0xC7,0xFE,0x37,0x29,0x72,
  0xC7,0x84,0xB2,0x42,0x98,0x11,0x24,0x6F,0x52,0xD4,0x6C,0x6D,0x88,0x59,0xB1,0x1B,
  0x0C,0xA7,0x15,0x44,0x83,0xC1,0xD4,0x53,0xCE,0xBA,0xBB,0xC8,0x42,0xB3,0x18,0xA1,
  0x65,0x50,0xD2,0xDD,0x84,0x9F,0xA5,0xDF,0xFC,0x0B,0x26,0x93,0xE1,0x17,0x6F,0x72,
  0xC1,0x4A,0xBB,0x57,0x21,0xE5,0xEE,0x05,0xB0,0x5F,0x74,0xDD,0x56,0x5C,0x2C,0x9F,
  0xBB,0xCB,0x07,0x38,0x86,0xD3,0x96,0x6C,0x02,0x36,0x47,0x77,0x9A,0x41,0x71,0xB7,
  0x4A,0x48,0x06,0xF8,0xF8,0xC1,0x7F,0x7F,0x61,0xCD,0x2D,0x25,0x2B,0xC7,0x88,0x9F,
  0xDF,0x87,0xD7,0x16},
  /*full size of additional data*/
  {500},
  /*text data*/
  {0x2A,0x7C,0xAF,0xBF,0x44,0xC2,0x2B,0xC8,0x4D,0x6E,0x63,0xC5,0x10,0x11,0x2D,0x05},
  /*data input size*/
  {16},
  /*size of Q field in control block*/
  {2},
  /*Nonce*/
  {0xE2,0x89,0x2F,0x81,0x97,0x25,0x3B,0x1C,0xE9,0x2D,0xC2,0x46,0xAE},
  /*size of N buffer*/
  {13},
  /*size of CCM-MAC (T) */
  {6},
  /* output data*/
  {0},
  /* output data size*/
  {22},
  /*expected data */
  {0x6A,0x0A,0x22,0xC4,0xC4,0xF9,0x34,0xAA,0x37,0xEC,0x70,0x09,0x22,0xA7,0xC3,0x47,
  0xF1,0x9B,0xA1,0x0B,0x8B,0xE1},
  {0},
},

{
  {"Acceptance test - AES/CCM/8ByteQ/12ByteMac/7ByteNonce/500ByteAdata/500ByteTextData/128Key"},
  /*AESCCM key*/
  {0x0F,0x30,0x09,0xD5,0xFB,0x48,0xB5,0xC3,0xF7,0x5E,0xF8,0xF6,0x07,0x2A,0x35,0x1F},
  /*additional data*/
  {0x70,0x77,0xE4,0x73,0xD4,0xD8,0x02,0x29,0x7C,0xE0,0xC7,0x6A,0x54,0xD2,0xC1,0x88,
  0x55,0xEA,0xBF,0xB0,0xCC,0x05,0x78,0xA0,0xED,0x9F,0x18,0x9D,0x58,0xA2,0x12,0xD9,
  0x03,0x07,0xD2,0x88,0xA1,0x81,0x14,0x7B,0x9D,0xD7,0xC1,0x25,0x24,0xA0,0x41,0x39,
  0x2D,0xE3,0x4E,0x9B,0xD5,0x5B,0xFF,0x6A,0xFE,0x43,0x86,0x35,0xBF,0x65,0xD0,0xDA,
  0xCD,0xED,0x66,0x4D,0x00,0x38,0xE7,0xD3,0xD5,0x43,0x13,0xF4,0x44,0x53,0x7B,0x4C,
  0x5D,0xDF,0x6F,0x75,0x54,0x76,0x04,0xA7,0x08,0x67,0x89,0x5E,0xFB,0xDE,0xBB,0x37,
  0x07,0xE6,0x57,0x37,0x3A,0xF4,0x39,0xF4,0xFC,0x7A,0xC5,0x91,0x48,0x0A,0x26,0xAB,
  0xC8,0x39,0xD8,0xE0,0xF6,0x5A,0x86,0x57,0xE9,0xBE,0x45,0x98,0xAE,0x88,0xD8,0xF7,
  0x88,0xDC,0xED,0x5E,0xFC,0x44,0x12,0x68,0xA5,0x7A,0x78,0xD9,0xB0,0x72,0x5F,0xFD,
  0x41,0xDE,0x96,0xC1,0x05,0xDB,0x40,0xAC,0x60,0x00,0x4D,0x7B,0xAF,0xA1,0x46,0x73,
  0xA2,0xCE,0x09,0x6B,0x1C,0xC8,0xAE,0x83,0x27,0x6F,0x3A,0x7B,0xE1,0xAC,0xA6,0x77,
  0x5E,0x47,0x57,0xCF,0xF2,0x16,0xF1,0xAC,0x9B,0x40,0xFD,0xFC,0xF6,0x96,0xB9,0x04,
  0x34,0x05,0x37,0xE2,0x68,0xF4,0xE1,0x79,0x30,0x12,0x9A,0x96,0xA1,0xC4,0xCA,0xB3,
  0x5A,0xD6,0x1C,0x67,0x4A,0x76,0x80,0x8B,0xDC,0x5D,0xCF,0xDC,0xCA,0xB2,0x8C,0x90,
  0xB5,0x36,0x47,0xDC,0x75,0xC3,0x0E,0x6A,0x66,0xDD,0x9F,0xE0,0x7C,0x5B,0x0B,0xD6,
  0x75,0x4A,0xA1,0x20,0x79,0x51,0xBA,0xBE,0x84,0xAB,0x06,0x0B,0x25,0x05,0xAE,0x7D,
  0x85,0x09,0xE0,0x6A,0x7D,0xEE,0x3D,0x97,0xC8,0xB2,0x01,0x6C,0xD6,0xA0,0x0F,0x80,
  0x51,0xF8,0x66,0x7F,0x10,0x6C,0x16,0x63,0x7B,0x89,0x57,0xC9,0xBC,0x02,0x45,0x61,
  0x2F,0x21,0x5A,0x72,0x7B,0xA0,0x59,0x87,0x0D,0x0A,0x58,0xC7,0x50,0x4D,0xE7,0xE4,
  0x9C,0x85,0xB9,0x2C,0x9E,0x2F,0x6D,0x19,0xF3,0x7C,0xEE,0xF4,0x96,0x73,0xDA,0xC5,
  0x6D,0xA0,0x3D,0xB5,0x45,0x9C,0x05,0xB1,0x9F,0xDE,0x72,0x05,0x14,0x4F,0x13,0x2E,
  0xA1,0x73,0x2D,0x37,0x48,0x18,0xC2,0xFF,0xB4,0x41,0x7F,0xFE,0xB1,0x64,0xF1,0x99,
  0x30,0x93,0x59,0xB0,0x10,0x32,0x9E,0xFF,0x7F,0x08,0x8D,0xC0,0xBD,0x67,0x04,0xA4,
  0x68,0xC0,0x53,0x22,0x46,0xA3,0x7C,0x54,0xDE,0x3D,0x00,0x03,0x1D,0x07,0xFF,0x3A,
  0xED,0xD8,0xD5,0x81,0xF5,0x63,0x1D,0x6E,0xD4,0x2D,0xB7,0x40,0x8B,0x01,0x42,0x4C,
  0x3C,0xDB,0x95,0xF0,0x11,0xCE,0x53,0x8C,0x16,0x05,0xD1,0xD2,0x31,0x9A,0xE2,0x78,
  0x09,0x53,0xD3,0xE4,0x91,0x83,0xAE,0x05,0xA3,0xE4,0x4D,0x18,0xEC,0x3B,0xC9,0xDC,
  0xFA,0xB4,0xC7,0x41,0x71,0x0E,0x28,0x1E,0x85,0x48,0x6A,0xF0,0x91,0x4A,0x3C,0x39,
  0x4A,0x3F,0x37,0x37,0x2E,0x5E,0xBA,0xB8,0x2C,0x90,0x4D,0x2D,0x80,0x3A,0xA0,0xDA,
  0x3B,0xF5,0xD8,0x7D,0xD3,0xA0,0x06,0xFA,0x2A,0xB4,0x5E,0x48,0x19,0xBE,0x73,0x58,
  0xA7,0x13,0xCE,0xAD,0x04,0x91,0xAD,0x9C,0xF9,0x0E,0x15,0xE1,0xC1,0xFB,0x9D,0x4A,
  0xA8,0x8F,0xB4,0x9B},
  /*full size of additional data*/
  {500},
  /*text data*/
  {0x65,0x23,0xEB,0x39,0x62,0x57,0xD9,0x38,0xD4,0x1A,0x76,0x70,0xBB,0x20,0x66,0x1A,
  0xCF,0xD4,0xE3,0xA1,0xFB,0x02,0xC1,0xB3,0x26,0x33,0x50,0x59,0xD7,0x38,0x7F,0x64,
  0x36,0xF1,0xF0,0x02,0xF0,0x9A,0xFC,0x35,0x31,0x21,0x51,0x93,0x02,0x22,0x0C,0x67,
  0x07,0x1F,0x19,0xFB,0xBB,0x20,0xA0,0x63,0x61,0x38,0x13,0x2E,0x07,0x7F,0x61,0x9B,
  0x9B,0x11,0x3A,0xC9,0x2F,0x63,0x29,0x35,0xD8,0xAD,0x70,0xD9,0xB0,0x2E,0xB1,0x03,
  0x27,0xE8,0x52,0xB7,0x1E,0x83,0xA9,0x15,0x51,0x8D,0xA1,0xB8,0x86,0xCD,0x2E,0xB2,
  0xBF,0xB6,0xF8,0xF0,0xE8,0x42,0x37,0xA4,0xF6,0xE4,0x23,0x0E,0xAF,0xC6,0xB2,0x33,
  0x86,0x10,0x06,0x1E,0x2C,0xAA,0x7C,0x17,0x68,0x24,0x78,0xA1,0xC2,0x70,0xAE,0x0A,
  0x7E,0xBE,0x1A,0xFA,0x36,0xC0,0x1A,0xE5,0xB0,0xAE,0xC0,0x3A,0x5F,0x9B,0x66,0x8B,
  0xDB,0x6E,0x32,0x76,0xC7,0x0F,0x85,0x15,0x39,0xE0,0x88,0xC4,0xC9,0x96,0xE1,0x85,
  0x36,0x19,0x8F,0xF1,0xAB,0xB8,0xFC,0xC6,0xF5,0x21,0x6D,0x7E,0xE9,0x42,0xB8,0xCD,
  0xBE,0xEC,0xC6,0x53,0x3E,0x37,0x43,0x6F,0x39,0x04,0xC0,0x56,0x38,0x56,0x1B,0x1A,
  0xCC,0x3A,0x04,0x46,0x0C,0x74,0xDF,0x22,0x71,0x6B,0x81,0xA5,0xA1,0x06,0x2C,0xF7,
  0x28,0xBB,0x05,0xDC,0xCF,0x8E,0x47,0xFE,0xD5,0x1F,0xB8,0xA7,0xF7,0xA6,0x8D,0x9E,
  0x05,0x53,0xB2,0xAE,0x3D,0x71,0xC0,0x49,0x0D,0xA3,0xE2,0xD2,0xB5,0x9D,0xCD,0x32,
  0xD8,0xC9,0x2D,0x7D,0x50,0x3E,0x4B,0x3E,0xF3,0x05,0x71,0xEC,0xBC,0x38,0x2B,0xCA,
  0xDE,0xE3,0x9F,0x4E,0x54,0x7E,0xB9,0xB7,0xFA,0xBC,0xCF,0x2B,0xAB,0x75,0x49,0x37,
  0x52,0x86,0xCE,0x2D,0x78,0x10,0x4D,0xC6,0x08,0x73,0xBA,0x38,0xFF,0xD4,0x8D,0xD4,
  0x78,0x17,0xF4,0xD2,0xFD,0x7E,0xDD,0x59,0x10,0x76,0x83,0x94,0x6F,0x1F,0x92,0x7E,
  0xBC,0x39,0x9A,0x36,0x69,0xFE,0x51,0xCE,0x96,0xD9,0x46,0xE0,0xC3,0x81,0xB7,0x25,
  0x2E,0xFA,0xB3,0x94,0x81,0x77,0x39,0xD3,0xA8,0x75,0x1D,0x01,0x8C,0xB8,0x57,0xE9,
  0xE1,0x3C,0x7B,0xC6,0x3A,0x57,0x6A,0x79,0xC5,0x25,0x3C,0x24,0x38,0xFC,0x96,0x8E,
  0xBF,0x5D,0x65,0x74,0x6B,0xFE,0xFD,0x45,0xFF,0xC6,0x8D,0xF4,0xE0,0x4F,0x41,0xDD,
  0x81,0x5D,0xFF,0x86,0x05,0xF1,0xEB,0xD7,0x8F,0x39,0xCE,0x5B,0x3B,0x15,0x9B,0xAB,
  0xDE,0x8E,0x42,0x2F,0x52,0xE2,0x7D,0xE2,0x3F,0x36,0xC6,0x73,0xC9,0x76,0x99,0x75,
  0xE4,0x5E,0xA3,0xDA,0xFD,0x0F,0x89,0xCE,0x71,0x8E,0xE5,0x31,0x30,0xA1,0x0A,0xEA,
  0x2B,0xE2,0x15,0x52,0x0D,0x11,0x8A,0x9F,0xDF,0x1D,0x47,0xCE,0x2A,0x78,0x0E,0x19,
  0xA0,0x58,0x76,0xDC,0x72,0xC0,0xAE,0xCF,0x04,0x73,0xBE,0xC4,0xFD,0x4C,0xB2,0x9D,
  0x2C,0xDC,0x47,0xE7,0x60,0x46,0x68,0xD2,0xD4,0x03,0xFA,0xE0,0xC7,0xBA,0xA4,0xF8,
  0x80,0xCB,0x90,0xD8,0x2B,0x2E,0x78,0x6A,0x34,0x46,0x4D,0x99,0x53,0xC5,0xA1,0x93,
  0x6B,0xAA,0xA2,0x4E,0x30,0x26,0xB8,0x59,0xEF,0xA4,0x07,0x6E,0xC5,0xCD,0x07,0x4A,
  0xCF,0xC5,0x44,0x31},
  /*data input size*/
  {500},
  /*size of Q field in control block*/
  {8},
  /*Nonce*/
  {0xBD,0x2F,0xF8,0x7C,0xC9,0xBD,0x8A},
  /*size of N buffer*/
  {7},
  /*size of CCM-MAC (T) */
  {12},
  /* output data*/
  {0},
  /* output data size*/
  {512},
  /*expected data */
  {0xBD,0x69,0x75,0x49,0x41,0x33,0x38,0xD5,0x0D,0xCC,0xF4,0x9E,0x6F,0xA8,0x46,0x4B,
  0xF7,0x12,0x4C,0x3B,0xE6,0xB9,0x9B,0x88,0xBD,0xB8,0x86,0xA2,0xDC,0x72,0x2A,0xD0,
  0x04,0xC5,0xBE,0xF2,0xB8,0x90,0x82,0x10,0x5A,0x05,0xBD,0xBC,0xB5,0x09,0x5A,0xFA,
  0x3E,0x53,0x87,0x08,0x35,0x2B,0x39,0x0C,0xD2,0xBA,0xC1,0x5B,0x93,0x59,0x4E,0xF9,
  0xF7,0x55,0x26,0x77,0xD6,0x7A,0x73,0x1A,0x9C,0x40,0xD6,0xCE,0x05,0x04,0xC3,0x96,
  0x5F,0xD0,0xA3,0x78,0xFD,0x5F,0x6D,0x98,0x10,0xF8,0xDA,0x1C,0x49,0xD8,0x5F,0x72,
  0x64,0x67,0x17,0xEC,0x96,0x8D,0x8E,0xC8,0x1D,0xD3,0xB9,0x50,0xCC,0x58,0xDB,0xB3,
  0x89,0x83,0xC6,0xDF,0x33,0x80,0x97,0xE7,0xF2,0x1F,0x1A,0xC2,0x2A,0x7C,0x97,0x10,
  0x78,0x50,0x79,0xE0,0xF6,0xCC,0x4B,0x9F,0x2F,0x65,0x6F,0xF5,0xAA,0x7F,0xC4,0x01,
  0xD2,0x3B,0x51,0x02,0xE2,0x62,0x71,0x2B,0x60,0x3F,0xAB,0xF8,0x27,0x71,0xF5,0x0B,
  0xE1,0x0D,0x6E,0x1C,0x04,0xEA,0xE6,0x8E,0xFC,0xC2,0xE8,0xAD,0x13,0xF3,0x34,0xF5,
  0x05,0x37,0x4D,0x79,0x98,0x6D,0x5A,0x70,0x01,0xF6,0xFA,0xFD,0x31,0x40,0x99,0x52,
  0xCB,0x22,0x10,0xA4,0x2D,0x89,0xDE,0xB2,0x64,0xF4,0xB3,0x45,0xF5,0x8A,0xC6,0x8B,
  0x1D,0x86,0xAD,0x95,0x99,0xEF,0x9B,0x58,0x6F,0xF7,0x95,0x52,0xC5,0xE2,0x3D,0x4D,
  0x5A,0x17,0x2C,0xAA,0xFA,0xF1,0xFA,0x42,0x66,0x93,0x58,0x9A,0xBE,0x91,0xA0,0xEC,
  0x47,0x6C,0x56,0xD2,0x7C,0xE4,0x5C,0x76,0x96,0xE6,0x1D,0x33,0xDB,0x6C,0x01,0x42,
  0x64,0x7B,0xC3,0xEF,0x54,0xAA,0x9B,0xED,0x9B,0x0A,0x25,0x44,0x4F,0xDD,0x0F,0x7D,
  0xE2,0x3E,0x57,0xFA,0xD9,0x2A,0x9E,0xD4,0x58,0x9C,0x4C,0x09,0x70,0x46,0x6D,0x27,
  0xD5,0x5C,0x54,0x28,0x3B,0x14,0x87,0x2A,0x2C,0x67,0xC5,0x59,0xDE,0x0D,0x91,0x87,
  0x38,0xAE,0xAB,0xAA,0x3F,0xF2,0x38,0x69,0xB2,0xF2,0xB6,0x0D,0xD9,0x48,0xD6,0x1F,
  0xB0,0x5D,0x18,0x79,0x26,0x43,0xDF,0xD7,0xFD,0x36,0x6B,0x85,0xC1,0xA3,0xDD,0x38,
  0xCD,0xFC,0xE7,0xCE,0x5D,0x4C,0x79,0x4E,0xEC,0xE5,0x71,0xA3,0x65,0xE9,0x0F,0x3D,
  0x66,0x39,0x4C,0xD4,0xC9,0x64,0xBA,0x15,0x34,0x19,0x20,0x2D,0x09,0xAC,0xC1,0x25,
  0x9C,0x36,0x77,0x7B,0x66,0x7F,0x08,0x63,0x11,0xD7,0xE8,0x49,0xC2,0xFC,0xF4,0x4D,
  0xAF,0x44,0xD4,0xC3,0x61,0x4E,0xE2,0xBA,0x39,0xBE,0x10,0x46,0x90,0x25,0xEE,0xFA,
  0x2A,0x3D,0xD9,0xED,0xD8,0x22,0xA7,0x8E,0xC5,0x21,0x2D,0x2F,0xFC,0x0E,0x68,0x18,
  0xB3,0xBC,0x0A,0x8C,0xF3,0x8A,0x75,0xD7,0x43,0xCC,0x91,0x89,0xE3,0x2A,0x22,0xE7,
  0x5F,0xF1,0x90,0xF8,0xE7,0xAC,0xD9,0x39,0xCC,0x05,0x40,0x77,0x09,0x5A,0x49,0x4A,
  0x9A,0x5B,0x04,0xA9,0x98,0xDF,0x04,0xE5,0xA4,0x13,0x35,0xFB,0x5B,0xF0,0x01,0x87,
  0x52,0x85,0x27,0xC6,0x12,0x53,0xA9,0x4D,0x42,0xD5,0xDC,0x97,0x98,0xA5,0x32,0x07,
  0x43,0x3A,0x72,0x06,0xB8,0xB5,0x4B,0xCF,0x66,0xEA,0xE4,0x1C,0x98,0x79,0xA2,0xC8,
  0x84,0x3B,0xCB,0x34,0x5C,0xDC,0x46,0x65,0x09,0xA9,0x8D,0x9B,0xF7,0x1A,0xFC,0xDB},
  {0},
},

{
  {"Acceptance test - AES/CCM/8ByteQ/14ByteMac/7ByteNonce/500ByteAdata/1024ByteTextData/128Key"},
  /*AESCCM key*/
  {0x21,0xBB,0xF0,0xF8,0xAB,0xB4,0x97,0xBD,0x7F,0xB0,0xA9,0x78,0x2A,0xDA,0xD3,0x1D},
  /*additional data*/
  {0xEA,0xB6,0x35,0x1E,0x81,0x99,0x34,0x3F,0xFE,0xE5,0xC4,0x9F,0xDE,0x3A,0xC8,0xCD,
  0xBC,0xED,0x03,0x86,0x07,0x02,0x0F,0xEB,0x6B,0xFC,0x1E,0xC2,0xF8,0x63,0xDD,0xFB,
  0xCC,0x1C,0xEA,0xBE,0x9A,0x45,0x76,0x96,0xB0,0x72,0x87,0x37,0x2C,0xC8,0xF5,0xC0,
  0x9E,0xA0,0xB4,0xAB,0x93,0xE2,0xC3,0xE8,0xA6,0x49,0xB3,0x85,0x7A,0x72,0x47,0x9A,
  0x07,0xC9,0xD2,0xC2,0x4F,0x0A,0x33,0x76,0x76,0x6D,0xD5,0x94,0x7B,0xD8,0xBF,0xA2,
  0x06,0x5E,0x23,0x57,0xAF,0x31,0x67,0xE9,0x58,0x02,0x17,0x50,0x92,0xF1,0x1B,0x3E,
  0x2B,0xEC,0x2F,0x62,0xF5,0x33,0x71,0x94,0x6D,0x3E,0x35,0x26,0x0C,0x2F,0x6C,0xCD,
  0x8A,0x10,0x7E,0x1C,0x4E,0xEF,0xEB,0xD5,0x61,0xE9,0x6A,0x4C,0xF2,0xE3,0xE4,0x84,
  0x51,0x97,0x69,0x8F,0xA9,0x5C,0xAD,0xD2,0xEC,0x8E,0xEA,0x71,0xFC,0x40,0xDC,0x29,
  0x96,0x4A,0xC5,0x81,0x72,0xFF,0xEF,0x3C,0x01,0x59,0x00,0x0C,0xC8,0x24,0xA2,0x89,
  0x59,0xB0,0xD5,0x75,0xC5,0xDD,0x24,0x2E,0x63,0xAC,0x2F,0xBF,0x04,0x7A,0xD9,0x21,
  0x0C,0x41,0xB6,0xA7,0x1E,0x62,0x11,0x51,0xA7,0x2C,0x8D,0x50,0x5B,0xA1,0x0A,0xC7,
  0xEC,0x60,0x17,0x4B,0x6B,0x67,0x63,0xB9,0x26,0x96,0x1E,0xC6,0xCF,0x2F,0x37,0x87,
  0x7F,0xDF,0x00,0x87,0x6E,0xFA,0x6B,0xF7,0x9F,0x83,0xCD,0x98,0x4F,0xD4,0xD3,0xC1,
  0xA1,0x67,0xD3,0xA3,0x63,0x8E,0xB6,0xA4,0xDE,0xFC,0x81,0x87,0x43,0x4A,0x82,0x77,
  0xF5,0x06,0xD0,0x7B,0xA1,0x82,0x58,0xF2,0xF5,0x1F,0xAC,0xE7,0x99,0xCA,0x69,0x51,
  0xC3,0x5C,0x24,0x67,0x5C,0x93,0x24,0xF1,0x29,0x5B,0xA8,0x71,0x78,0xE4,0xB3,0x54,
  0x01,0x55,0xA3,0x49,0x03,0x57,0x20,0x1E,0x0F,0xE0,0xAE,0x43,0xE1,0xCE,0x0A,0x14,
  0x93,0x2F,0xC3,0xE6,0x26,0x1A,0x1B,0x61,0xE2,0xDE,0x52,0x45,0xDA,0xE6,0x79,0x10,
  0x6C,0x57,0xE6,0x43,0x26,0x20,0x4E,0x6C,0x3C,0x06,0x58,0x7B,0xE5,0xE0,0x0F,0x5A,
  0x50,0x94,0xDE,0x48,0x20,0xCC,0x2E,0xE7,0x3A,0x42,0x66,0x25,0x05,0xDB,0x44,0x28,
  0x66,0x9E,0xD7,0x89,0xE8,0xC6,0xED,0x72,0xE1,0x57,0xAA,0x1F,0xC1,0x9F,0x7C,0x01,
  0xCE,0xF7,0xF4,0x45,0x08,0x31,0xF0,0x9F,0x29,0xFE,0x09,0xE4,0xB9,0x28,0x67,0x61,
  0xC1,0x30,0x14,0x47,0x09,0x85,0x72,0x8A,0xA7,0x6B,0x66,0xC9,0x22,0x0E,0x25,0x9A,
  0xC5,0x65,0x56,0x0D,0xE6,0xFF,0x20,0x35,0xAD,0x37,0x60,0xE9,0xBD,0x09,0xB9,0xB9,
  0xF0,0x49,0x5E,0x91,0x8A,0x35,0xF7,0x48,0x85,0x6A,0x9D,0x9C,0xCA,0x26,0x7D,0x1B,
  0xD9,0x6E,0x1E,0x54,0xD1,0x59,0x7A,0xC1,0x10,0xDF,0x99,0xD1,0x25,0x88,0xCC,0x9E,
  0xB2,0xAD,0xD8,0xD8,0xAF,0x93,0x10,0x90,0x6D,0x0E,0x88,0x7C,0x61,0x83,0x6B,0x87,
  0xBA,0x44,0x10,0x4E,0xEA,0x65,0xE7,0x96,0xCE,0x9C,0x81,0xAB,0x9C,0x25,0x22,0xFC,
  0x9D,0xFF,0xE9,0x1C,0x4E,0xA4,0x6B,0x45,0x5E,0x8E,0xE6,0xC3,0xD1,0xFE,0x5F,0x8C,
  0x73,0x12,0x17,0xE0,0x78,0x7E,0xB3,0x4D,0xC6,0x42,0x09,0x12,0x12,0x64,0xF3,0x48,
  0xEB,0x8B,0xDE,0x62},
  /*full size of additional data*/
  {500},
  /*text data*/
  {0x99,0x6B,0x09,0xB8,0x4E,0xAE,0x37,0x0A,0xE4,0x3B,0x87,0xB1,0xBC,0x23,0x0D,0x97,
  0xBB,0xB9,0x43,0x5D,0x5F,0xFB,0x83,0xE0,0x08,0xAA,0xBD,0x6C,0xAB,0xF8,0x07,0xEE,
  0x07,0x52,0xB1,0x2D,0x91,0xAD,0x78,0x6B,0x87,0x21,0x5A,0x90,0x41,0xA4,0x62,0x01,
  0x16,0xA8,0x25,0x9B,0x58,0x5A,0xCB,0x9D,0xE8,0x28,0xB0,0xA4,0xF0,0xCB,0x5F,0xEC,
  0x34,0x99,0xAA,0x6A,0x72,0xDF,0x06,0x0E,0x40,0xD8,0xD6,0x3E,0xA1,0xF2,0x9F,0x64,
  0x47,0xBB,0x55,0x03,0xD2,0x6B,0x96,0xAD,0x87,0x13,0x45,0x68,0xFD,0xD4,0x7A,0xBC,
  0xC1,0x6E,0x5C,0xA7,0xFA,0xF8,0x8F,0x37,0xA1,0x17,0x5A,0x7F,0x83,0x8D,0xFC,0xF6,
  0x89,0x4B,0x5C,0x35,0x75,0x5C,0x19,0xC9,0x03,0xFC,0xE3,0x5E,0x9A,0x9D,0x10,0x6C,
  0x5D,0x1A,0x7C,0x32,0x96,0xF7,0x69,0x4F,0x2C,0x1E,0x61,0xBB,0x10,0x16,0x29,0xFA,
  0x16,0x4E,0xDF,0xB1,0x77,0x45,0x46,0x65,0x55,0x92,0xA4,0xFE,0x14,0x30,0x9C,0x03,
  0x06,0xEE,0x22,0x69,0x10,0xCA,0x5F,0x91,0xE2,0x0D,0x09,0x57,0xFA,0x5E,0xB8,0xED,
  0xD2,0xE9,0x48,0x4B,0xBE,0x5E,0xF4,0x18,0xD3,0x16,0xDD,0x03,0x53,0x6B,0x3A,0xFB,
  0x81,0x5D,0xB4,0x21,0xF4,0xC0,0xE9,0x4C,0xEF,0x4D,0xCF,0x6A,0x3B,0xEE,0x6A,0xF7,
  0xD9,0xB7,0x2B,0x2B,0xE8,0x51,0x45,0xA7,0xF9,0x09,0x96,0xFA,0xED,0x5B,0x3E,0x76,
  0xD2,0x0D,0xD6,0x9D,0xA9,0x97,0xF8,0x12,0x00,0xFB,0x5B,0x70,0x8F,0x89,0xDC,0xE4,
  0xAC,0xE5,0x29,0x9C,0x40,0x0E,0x13,0x2F,0x18,0x0C,0x27,0xEA,0x29,0xEF,0x5E,0x93,
  0x0F,0x58,0x98,0x2E,0x18,0xCD,0x4D,0x42,0xBE,0x18,0x2B,0xEC,0xF5,0xD5,0x18,0x70,
  0x2C,0xB1,0x4D,0x07,0x31,0xA2,0x36,0xC3,0xFA,0xA6,0x85,0x9C,0x6F,0x0E,0xE8,0x10,
  0x9C,0xC7,0x60,0x37,0xF1,0xAE,0xCC,0xDE,0x97,0xE7,0xDE,0x27,0xE3,0x26,0x3A,0x42,
  0xF4,0xB7,0xBD,0x78,0xA1,0x57,0x62,0x6D,0x21,0xD4,0x34,0x71,0x48,0xB1,0xD3,0xAF,
  0x30,0x1A,0x4F,0x2D,0x74,0xE0,0x7E,0x7E,0xE5,0x6F,0x6F,0x4A,0xC4,0x0F,0xE0,0xD3,
  0x6C,0x42,0xA7,0xB7,0x50,0x70,0x6F,0x45,0x65,0xF3,0x15,0x1C,0x7A,0x5A,0x95,0xE6,
  0x13,0x2E,0xF6,0xC8,0xD6,0x0C,0xCD,0x14,0x38,0x3F,0x92,0x31,0xE7,0x17,0xA9,0x12,
  0xF4,0x60,0x04,0x06,0x0A,0x1B,0x5F,0xBF,0xAB,0x09,0xC8,0x81,0xCB,0x62,0x04,0x8A,
  0xD9,0x89,0x36,0x95,0x18,0x17,0xFC,0x60,0x74,0x93,0x7E,0x10,0xDD,0x3D,0x5E,0x4D,
  0x4A,0x03,0x28,0x19,0x56,0x8F,0xDC,0xF7,0xCE,0x37,0x1D,0xCC,0x44,0x4C,0x48,0xD6,
  0x3B,0x08,0x58,0x5E,0xE1,0x13,0xF9,0xDC,0x63,0xA4,0x91,0x76,0x9C,0x4E,0xE2,0x6D,
  0xAB,0x7A,0x37,0xC8,0x39,0xEA,0x34,0x49,0xAC,0x3E,0xC6,0xE1,0xFA,0x30,0x1C,0x28,
  0x4A,0xA8,0xD5,0xD5,0xE5,0xFF,0x6C,0x36,0x09,0x4B,0xB5,0xB1,0xFE,0x65,0x5B,0x80,
  0x54,0xB0,0x21,0xC9,0x15,0x80,0x9C,0x50,0xD4,0x0E,0xB1,0xA2,0x4C,0x17,0xE2,0x33,
  0x87,0x69,0x2B,0xF4,0x78,0x0C,0x87,0xAB,0x0E,0x00,0xBE,0xEE,0x35,0x82,0x4B,0x46,
  0xE3,0x46,0x8C,0x4A,0x0E,0x52,0x13,0xCA,0x0B,0x85,0x01,0xD6,0x4E,0xCA,0xE9,0xF2,
  0x68,0x82,0x2A,0x94,0x3A,0x66,0x08,0x47,0x28,0x75,0xBB,0x14,0xC2,0xAE,0x1B,0x51,
  0xC3,0x6A,0xBE,0x06,0x8B,0x98,0x24,0x35,0x56,0x61,0xE9,0xF2,0x0B,0xB1,0x5D,0x44,
  0x17,0xCC,0x85,0xB2,0x58,0xB6,0x0C,0x7D,0x3E,0x44,0x21,0x99,0x97,0xFF,0x08,0x5D,
  0x6A,0xAF,0x13,0xE3,0x0B,0xE2,0x66,0xD0,0x5D,0xF5,0x3E,0xD8,0x7D,0x15,0x3C,0x77,
  0x17,0x77,0xFC,0xF6,0x28,0x68,0xF9,0x0C,0x5E,0x41,0xC8,0x46,0x76,0x8A,0x9D,0x57,
  0x59,0x8B,0x88,0x5C,0x9D,0x7A,0x38,0x34,0x65,0xB5,0x55,0x63,0x78,0x34,0xFF,0x28,
  0x08,0xAA,0x82,0x20,0x02,0x11,0x34,0x02,0xB5,0x06,0x85,0xCA,0x1A,0x20,0x59,0xD2,
  0x57,0xE7,0x7F,0xF1,0x8D,0xDF,0xD9,0x9C,0x3E,0xC8,0x90,0x73,0x12,0x96,0x94,0x29,
  0x41,0x9F,0x3D,0xCB,0x08,0x7D,0x54,0x47,0x56,0x85,0xA6,0x97,0xF5,0x6E,0x19,0x44,
  0x5B,0x83,0x0B,0x91,0xB4,0x0E,0x9B,0x28,0xD1,0xE5,0xE1,0x3A,0x81,0xC1,0xEF,0x1F,
  0x71,0x5B,0x89,0x7A,0xE2,0x8E,0xC9,0xDA,0x92,0x37,0x9A,0x07,0x39,0x42,0xA7,0xD0,
  0xAE,0x4B,0x17,0x8F,0x8A,0x03,0x75,0x32,0x03,0x14,0xFA,0x23,0x9B,0x1A,0xC6,0x95,
  0x96,0x86,0x25,0x9A,0xE5,0x9F,0x62,0xCD,0xB9,0x31,0xFE,0x7D,0x73,0x94,0xEF,0x8F,
  0x3E,0x11,0x8B,0x35,0xA9,0x60,0x94,0x6E,0xE6,0x56,0x76,0xCD,0x93,0xA6,0x3F,0x77,
  0x71,0x05,0x71,0xB2,0x1C,0x0D,0xEA,0x0F,0xE9,0x4A,0xD6,0x59,0x04,0xF7,0xBF,0x6F,
  0x25,0x6B,0xE4,0x89,0x8F,0x91,0xEB,0x35,0xF1,0xB6,0xB3,0x8E,0x28,0x94,0x39,0x12,
  0xF2,0x87,0x0B,0x6E,0x23,0x3D,0x72,0x30,0x26,0x7C,0x4C,0x5F,0x89,0x3B,0x6A,0xEE,
  0x97,0x07,0xA8,0x28,0xC1,0xB5,0xE8,0xE0,0x19,0x3B,0xC0,0x65,0x59,0x5C,0xE6,0x54,
  0x10,0xC3,0x67,0x7C,0xEC,0x50,0x4B,0xE8,0xF8,0xB4,0x62,0x12,0x44,0x8C,0xAB,0xB6,
  0x4C,0xC5,0xF7,0x20,0xEC,0x11,0x50,0x3C,0x9F,0x2B,0x54,0xE7,0x7C,0x0C,0xD6,0xCA,
  0x95,0xF7,0x4E,0xC5,0xD4,0xED,0x02,0x46,0xBB,0xC0,0x2F,0x0D,0x53,0xD5,0x9B,0x8D,
  0x8F,0x0A,0x19,0x94,0x64,0xC5,0x67,0xFF,0x73,0x2B,0xDD,0xC0,0xFC,0x64,0x6B,0xEC,
  0xDD,0x97,0x7C,0x4D,0x3D,0xE5,0xE2,0x5F,0xC3,0xB0,0x65,0x2C,0xE2,0x43,0xE8,0xCA,
  0x8F,0xC6,0x58,0x72,0xF3,0x42,0x65,0xD0,0x90,0x4F,0x52,0xA9,0x0F,0x41,0x4A,0x57,
  0x54,0x43,0x30,0xBB,0x58,0x4E,0x50,0xA9,0x28,0xB9,0xD0,0xB4,0x60,0x3A,0x1D,0x30,
  0x42,0x13,0x30,0x35,0x0B,0xF9,0xF8,0x9A,0x31,0xAC,0xBC,0xED,0x93,0x38,0x4F,0x82,
  0x65,0x0D,0xD8,0x9E,0x13,0x2C,0x71,0x41,0x76,0xAF,0x49,0x39,0x72,0xB1,0x6F,0x55,
  0x32,0x22,0x66,0xFC,0x10,0x15,0x4B,0x5A,0x4A,0x95,0x89,0xAB,0x91,0x62,0x16,0xEF,
  0x69,0x4E,0x4E,0x52,0x62,0x7E,0x1D,0x15,0xA1,0xEF,0xBE,0x5C,0xAF,0xBE,0x28,0x80,
  0x3C,0x67,0xBB,0x70,0xD2,0x53,0x71,0x50,0xC2,0x7D,0x53,0x7D,0xA3,0xC6,0xB0,0x14,
  0x99,0x5A,0xD0,0x23,0x63,0x1D,0xF3,0xB3,0x05,0x51,0x5B,0x21,0x56,0xEF,0xAB,0x8C,
  0x6C,0x09,0x6F,0x2A,0xA6,0xA5,0x1D,0x16,0xDC,0xFD,0x90,0xE4,0x2A,0x9F,0x72,0xDB},
  /*data input size*/
  {1024},
  /*size of Q field in control block*/
  {8},
  /*Nonce*/
  {0xC1,0x21,0xE5,0x93,0x8B,0x05,0x82},
  /*size of N buffer*/
  {7},
  /*size of CCM-MAC (T) */
  {14},
  /* output data*/
  {0},
  /* output data size*/
  {1038},
  /*expected data */
  {0x0E,0x8E,0x5D,0x57,0x9B,0xC3,0x3B,0xE7,0xB8,0xCD,0x77,0xCD,0xE3,0x96,0x85,0xE7,
  0x17,0x50,0xB6,0xBF,0x4A,0x66,0x94,0xAA,0xC6,0x4E,0xB7,0xFC,0x2B,0x20,0x81,0x1F,
  0x9C,0x1C,0x59,0xEE,0x99,0xF9,0x78,0xA8,0x97,0xAE,0x24,0xA2,0xA3,0x55,0x09,0xB6,
  0x5F,0x30,0x82,0x0D,0xC9,0x57,0xDE,0x98,0x8B,0xCA,0xFD,0x87,0xE9,0x2C,0x82,0x22,
  0x97,0x5B,0x10,0xB5,0x9F,0x13,0xA8,0x57,0x70,0x8C,0xC2,0x1C,0x0C,0xC5,0x23,0x58,
  0xC6,0xAA,0x75,0xB3,0xA5,0x7C,0x29,0xFD,0xB1,0xC7,0x4A,0xD9,0x52,0x65,0xEC,0xCD,
  0x71,0xFC,0x04,0x8A,0x74,0xAC,0x96,0x8A,0xFF,0x31,0x70,0xED,0xE3,0x9B,0xE1,0x82,
  0x1A,0x5E,0x8E,0xD8,0x99,0xE8,0x49,0x15,0x6F,0x46,0x6A,0x92,0x73,0x60,0x31,0x1C,
  0x32,0xF2,0x89,0x85,0x2F,0xB4,0xF6,0x4F,0x2A,0x60,0xE2,0xF0,0xF8,0xE3,0xCE,0x66,
  0x4F,0xF8,0x97,0x18,0x3D,0x1B,0x18,0xDF,0xE8,0xC4,0xC7,0x5E,0x78,0x98,0x11,0xB2,
  0x42,0xC2,0x8A,0xCE,0x97,0x1A,0xC9,0x01,0xEB,0xA2,0xE5,0x9C,0xD9,0x7D,0x5B,0xBD,
  0x26,0xBE,0xBC,0x15,0x56,0xFF,0x14,0xF7,0x22,0xD8,0x61,0x80,0x49,0x90,0x59,0xB9,
  0x03,0x1B,0x65,0xEA,0x93,0xAD,0x63,0x82,0xEC,0xB5,0xE4,0x1E,0x99,0x8B,0x86,0xDD,
  0xF8,0x2B,0xD7,0xC2,0xBE,0x18,0xCB,0xB9,0x8F,0xFE,0x47,0xB3,0x04,0x2E,0xCA,0xC6,
  0x3C,0x2B,0xC9,0x63,0x5B,0x82,0xEF,0x3C,0x9C,0xC7,0x78,0x9D,0xB7,0xE2,0x1D,0x86,
  0x2C,0x01,0x30,0xE9,0x33,0x9B,0x48,0xC7,0x33,0xC2,0xA1,0x3F,0x99,0xF7,0xE5,0xDF,
  0x41,0x77,0xCB,0x8C,0xFB,0x4B,0x8F,0xAD,0x32,0xB0,0x5B,0x32,0x71,0xED,0x0D,0xC5,
  0xAF,0xF8,0x61,0x2B,0xFA,0x3C,0xBD,0x08,0x97,0x8A,0x66,0x3F,0x8C,0x7F,0xF8,0xEA,
  0xE1,0xCD,0xFF,0x81,0x2A,0x52,0x66,0xB5,0x13,0xD7,0x06,0x68,0x83,0x4E,0xB5,0xC2,
  0x6E,0xB3,0x54,0x16,0x4A,0x72,0xDC,0xEE,0x48,0x7A,0xB3,0x7C,0xBB,0x1F,0x2C,0x09,
  0x5A,0x25,0xCE,0x5E,0xE1,0x77,0x94,0x0C,0x9D,0xBF,0x2A,0x70,0xC3,0x35,0x3B,0x0C,
  0x42,0xFD,0xA3,0x22,0x30,0xF2,0x8A,0x58,0xC3,0x4E,0x0F,0xF6,0xE7,0xA9,0xD9,0x47,
  0x99,0x64,0xD4,0xF0,0x22,0x98,0xE0,0xAC,0x1E,0x57,0xC8,0x35,0x30,0xC5,0x14,0x24,
  0xDA,0x53,0xEE,0xE4,0x79,0x6B,0xF8,0xB4,0x66,0xA7,0x7D,0x2E,0x7A,0x80,0x06,0x4F,
  0x90,0xF6,0xBC,0x2E,0xEF,0x5D,0x18,0x76,0xF7,0x7D,0x82,0xC0,0x31,0x29,0xFC,0xB1,
  0xAF,0x69,0x30,0x38,0x9F,0xEB,0x50,0xD0,0xB3,0x8D,0x57,0x4C,0xF8,0x5B,0xA8,0x40,
  0x9A,0xBC,0x56,0xD6,0x0E,0xBA,0x63,0x03,0x47,0xBA,0x54,0xF0,0xF0,0x15,0x6E,0xEA,
  0xE9,0x2F,0xFA,0x35,0x78,0xFD,0xD3,0xB9,0x0A,0xAF,0xA0,0xBF,0xD7,0xE1,0x27,0x63,
  0xB5,0x18,0x49,0xE0,0x8B,0x6B,0xA4,0xAF,0xD9,0xB1,0xF8,0x50,0xF0,0x12,0x06,0xA1,
  0xA4,0xDE,0x4F,0x75,0xCC,0x56,0x17,0xAF,0xE9,0x58,0x61,0x39,0x2B,0xC6,0xE7,0x61,
  0x45,0x80,0x2B,0x8C,0x2C,0x62,0x1A,0x02,0xA3,0x0A,0xA7,0x06,0x19,0x05,0x59,0x2F,
  0x1F,0xEF,0xF4,0x79,0xCD,0x0B,0x26,0x5D,0x00,0x37,0x54,0xC6,0x50,0x1A,0x2B,0x8C,
  0xB8,0xA3,0x4D,0x31,0x2A,0x43,0xD1,0xCD,0xF5,0x9B,0x24,0x49,0xDC,0x77,0x98,0x7B,
  0x01,0x2E,0xA1,0x95,0x97,0x4F,0x7A,0x07,0x28,0xC2,0x9F,0x39,0xB7,0xC4,0xC6,0xA9,
  0x24,0x0D,0xA0,0xD1,0xD2,0xB5,0x4B,0xFC,0x96,0x7E,0x93,0xAD,0x74,0x91,0xA7,0x31,
  0x99,0x50,0xAC,0xAD,0x0A,0xCF,0x8F,0x63,0xB4,0x14,0x41,0x34,0x2A,0x43,0x77,0x25,
  0x15,0x8B,0x5B,0x3B,0xFB,0x2E,0x2A,0x42,0x17,0x67,0x73,0x19,0xD9,0x46,0xE8,0xF7,
  0x03,0x62,0x1D,0x62,0x93,0xC9,0x3B,0x29,0x65,0x48,0xBC,0xAE,0x7E,0x8B,0xC6,0x6D,
  0x22,0x8C,0x1B,0xAA,0xAA,0x8F,0x28,0x8A,0x64,0x56,0x45,0x94,0x94,0x3B,0xF4,0xA7,
  0xCA,0x31,0x60,0xDA,0xBB,0x42,0x8C,0xDB,0x7D,0x72,0x60,0x2C,0xF8,0x65,0x09,0x0D,
  0xF6,0xA3,0x56,0xEF,0x32,0xEB,0x33,0x49,0xF5,0x48,0xFB,0xD3,0x0A,0x5D,0x18,0x9B,
  0xDE,0x80,0x7D,0xC2,0x55,0xF2,0xDA,0xB1,0xB3,0x9A,0xFE,0x28,0xC0,0x9A,0x00,0x75,
  0x7D,0x41,0x0E,0xE0,0x6C,0x9D,0x2B,0xAA,0x9E,0xBE,0x58,0x13,0x0E,0xF8,0xE3,0x8B,
  0x0E,0x16,0x11,0xE5,0x50,0xB0,0xD4,0x77,0x34,0x30,0xC0,0xCB,0x5E,0x90,0x41,0x1A,
  0x7E,0xD5,0x68,0xAE,0x49,0x96,0xB1,0x0A,0x7C,0xAF,0xB0,0x86,0xB8,0x7B,0x8B,0x09,
  0xA1,0x3C,0xD1,0x78,0xF7,0x8C,0x3E,0x24,0x5F,0x7A,0x43,0x60,0x15,0x09,0x62,0x88,
  0x1D,0xC0,0x68,0xB6,0x1E,0xA9,0x9E,0xF4,0xB3,0xA5,0x9A,0x59,0xFC,0x7D,0xFF,0x6F,
  0x37,0xD2,0x7B,0xEC,0x40,0xF2,0x77,0x5F,0xB0,0x06,0xBE,0x09,0x38,0x53,0xA0,0x2F,
  0x34,0x81,0x71,0x90,0xE3,0x30,0x39,0x5B,0x72,0x49,0xE5,0xEA,0xB2,0x1C,0xA3,0x76,
  0x6D,0x9E,0xC4,0xCE,0x12,0x96,0x58,0x0F,0xB2,0xAA,0x16,0xC2,0xFA,0xD6,0x60,0xD0,
  0x5E,0x95,0xDD,0x00,0x33,0x04,0xF7,0xF5,0x56,0x44,0xE8,0xD6,0x4A,0x53,0x88,0xD7,
  0xC5,0x45,0xA3,0x72,0xEE,0xC5,0x39,0x2E,0x40,0xF2,0x5B,0xBE,0x92,0x96,0x2C,0x66,
  0x52,0x24,0x1D,0x5F,0x71,0xB4,0xE5,0x7F,0xB9,0x18,0xAF,0xA2,0xCA,0xBB,0x47,0x48,
  0x95,0x2A,0xF7,0x58,0x42,0xC4,0x55,0x63,0xF8,0x31,0xDA,0x10,0x49,0x17,0x1A,0xEC,
  0x62,0x53,0x52,0x8E,0x7B,0x93,0x15,0x6D,0x57,0x3F,0xC1,0xC4,0xE6,0x93,0x15,0xC2,
  0x7D,0x22,0x0D,0x0E,0x23,0x4A,0xC7,0xF5,0x00,0xC6,0x56,0x73,0x0C,0x20,0xCF,0x6F,
  0x3F,0xE3,0x7C,0x90,0xE4,0x94,0x26,0xE8,0x52,0xAE,0xD2,0x39,0x16,0xF9,0x72,0x36,
  0x4F,0xEB,0xF8,0x55,0xD7,0x49,0x54,0x25,0x09,0xF4,0xAF,0x0D,0xE7,0xF0,0xCE,0x18,
  0x1B,0x8E,0x47,0x08,0x8C,0x69,0x11,0x81,0x95,0x64,0x38,0x47,0xB0,0xA8,0xC2,0x79,
  0x36,0x87,0x43,0x5E,0x07,0x4E,0x4D,0x40,0xB2,0xCF,0x1A,0x59,0xAC,0x60,0x0C,0xBD,
  0x8D,0x51,0x76,0xEE,0x80,0x8A,0x85,0xCD,0x03,0x4C,0x2D,0xA4,0xE9,0x54,0xDE,0x2D,
  0x95,0xCE,0x57,0xDC,0xBD,0x56,0xB8,0x35,0xAA,0x54,0xD6,0x97,0xF4,0xEE,0x68,0x76,
  0x73,0x6C,0x1C,0xBF,0x25,0x70,0xEC,0xD8,0xC8,0x26,0xD7,0xBB,0xA9,0x0B,0x1F,0x97,
  0xB9,0xEB,0x5E,0x16,0x27,0xA7,0x1D,0x90,0xE8,0x79,0x3B,0xBF,0x13,0x8C,0x87,0x07,
  0xA0,0xB4,0x73,0x63,0x43,0x9E,0xA7,0x57,0x12,0x42,0x07,0x74,0x89,0x1C},
  {0},
},

{
  {"Acceptance test - AES/CCM/8ByteQ/16ByteMac/7ByteNonce/500ByteAdata/1024ByteTextData/128Key"},
  /*AESCCM key*/
  {0xB7,0x4A,0x6C,0x20,0x6E,0x16,0x3D,0x27,0xA1,0xCD,0xC7,0x06,0xC2,0xB7,0x46,0xA0},
  /*additional data*/
  {0xDC,0x43,0xC9,0xEA,0xAA,0xE2,0xE6,0x14,0x08,0x28,0xCA,0x45,0x52,0xFB,0xF2,0xD8,
  0xE1,0xA2,0x1C,0x18,0x28,0x24,0x91,0x05,0xE6,0x7D,0x56,0x3C,0x92,0xC7,0xFF,0x35,
  0x7A,0xD1,0xE8,0x83,0x42,0x69,0x34,0x90,0xB0,0x0F,0x34,0x2C,0x71,0xA8,0x23,0x08,
  0x6C,0xCE,0x2D,0xE0,0xAB,0x08,0x55,0xB7,0xB1,0xC3,0x03,0x2D,0x8C,0xA9,0x82,0x41,
  0x28,0x95,0xCB,0x80,0x12,0x6E,0x96,0x77,0x6E,0x8B,0x68,0x18,0xF0,0x65,0x94,0x3E,
  0x59,0x4D,0xD0,0xC4,0x99,0x1F,0x89,0x71,0x7C,0x30,0xD1,0x7E,0x65,0x07,0x04,0x07,
  0x8C,0xF2,0x03,0xDC,0xDD,0xA2,0xF5,0xFD,0x37,0xB5,0x72,0x1F,0xA0,0x3C,0xC7,0x4C,
  0x2F,0xC5,0xD3,0x3E,0xD8,0xBE,0xA7,0x09,0x0B,0x59,0x04,0xE1,0x9D,0x17,0x11,0x67,
  0x87,0x60,0x8C,0xFD,0x61,0xB8,0x61,0xB7,0x58,0xD3,0x8C,0xE3,0xAD,0x69,0xD1,0x3F,
  0x69,0x84,0x4F,0xA0,0x33,0xC5,0x2E,0xCE,0x4B,0xFA,0xD0,0x83,0x9D,0x13,0x5F,0x20,
  0xA4,0x0B,0x98,0x3F,0xB0,0xCA,0xEB,0x77,0x63,0x1C,0xE6,0x04,0x32,0xC3,0x5B,0xA2,
  0x87,0xC5,0x78,0x18,0xC8,0x71,0x33,0xC2,0x31,0xBD,0xB1,0x66,0xE7,0xDD,0x19,0x44,
  0x74,0x6B,0x3F,0xA2,0xD1,0x91,0x8F,0x9E,0x99,0xD7,0x3C,0x16,0xDE,0x2A,0x9C,0x87,
  0x9F,0x2E,0xFB,0xD8,0x9B,0x46,0x58,0x32,0xD7,0xD5,0x0E,0xF2,0x18,0x84,0x8F,0x86,
  0x02,0xA1,0x90,0xC6,0x83,0xB8,0xD0,0xF6,0x35,0xDA,0x7F,0xF0,0x34,0x1C,0xE3,0x07,
  0x20,0x2A,0xC7,0xB9,0xE1,0x40,0xA9,0x2D,0x13,0x0D,0xCB,0xFB,0x83,0x9C,0x85,0x14,
  0x48,0xB6,0x14,0x3C,0x99,0xD6,0x03,0xE6,0x5D,0x05,0xA2,0xC1,0xC6,0x67,0xFE,0xBA,
  0xF1,0x06,0xD2,0xEE,0xBD,0xD5,0xA4,0xC1,0xF8,0x63,0xB3,0x76,0xED,0xD5,0x72,0x99,
  0x54,0x6B,0xA8,0x7E,0x08,0xA6,0x6E,0x4A,0x26,0xE1,0x5C,0xDB,0x9E,0xE8,0x66,0xAB,
  0x0F,0x10,0x09,0x7D,0xCA,0x97,0x57,0x72,0x11,0x52,0x44,0x36,0x22,0x8C,0xF8,0x87,
  0x93,0x09,0x6C,0x5B,0xBF,0x7F,0xB1,0x4B,0x97,0x87,0xC7,0xDB,0x78,0xC8,0x23,0x10,
  0xFC,0x07,0x67,0xDC,0xCB,0xF5,0xCE,0xBC,0x14,0x36,0x6D,0xB6,0x62,0x38,0x27,0x99,
  0xE8,0xD4,0x48,0x94,0x7B,0x0B,0xEC,0x8F,0x5F,0xBE,0xE5,0x43,0xCF,0x7B,0xF9,0x48,
  0x2E,0x33,0x39,0x1B,0x24,0x1C,0xBC,0x9D,0x3B,0xAF,0x46,0x89,0x12,0xFA,0xE8,0x5F,
  0x5F,0x2E,0xF3,0xA3,0x80,0x8F,0x95,0xF0,0x1B,0xD8,0x7D,0x0C,0x0F,0x8B,0xED,0x98,
  0x3C,0x24,0x88,0x2F,0xFE,0x0C,0x74,0xCC,0x18,0xAA,0x58,0xCB,0xC4,0x63,0x7D,0x64,
  0xD6,0x85,0xE3,0xA1,0x88,0x55,0xC8,0x9E,0x9E,0x49,0x00,0x4C,0x9E,0xB0,0x8E,0xAF,
  0xC2,0xAE,0x4C,0xED,0x72,0xB9,0x61,0x53,0xB9,0x26,0x8B,0xD5,0x36,0xC9,0x2C,0xB8,
  0x5B,0x19,0x35,0x89,0xA7,0x4C,0x10,0xE6,0x5C,0xEA,0x90,0xB5,0x0C,0x28,0x2D,0x68,
  0x1C,0xA8,0x08,0x16,0x16,0x8F,0xF1,0x1D,0x24,0x90,0xE7,0x61,0xCA,0xF2,0x67,0xD4,
  0x1D,0x47,0xF1,0x85,0x7A,0x04,0x08,0x76,0x9D,0x66,0x91,0x88,0x28,0xAC,0x46,0x91,
  0xF8,0x23,0xB8,0x8E},
  /*full size of additional data*/
  {500},
  /*text data*/
  {0xE9,0x2D,0xE0,0x71,0x0A,0x43,0x44,0x0E,0x5C,0x03,0x01,0x0F,0x39,0x4D,0x69,0xE9,
  0x46,0xDF,0xE2,0xE3,0x80,0x4E,0x0E,0xB3,0xF8,0x17,0x9B,0x2F,0x70,0x1D,0x11,0xEC,
  0xDE,0xCC,0x49,0x1B,0x95,0x19,0x9E,0xAD,0xB3,0xB3,0x23,0x2F,0x2D,0x17,0x07,0x5C,
  0x33,0x8F,0xC3,0xC5,0x37,0x1C,0x7E,0x9B,0x1F,0x2D,0x79,0xF2,0xA7,0x15,0x9D,0x3F,
  0xF2,0x15,0x30,0x6D,0x03,0x4D,0x53,0x2D,0x41,0x35,0x30,0xCC,0x2B,0xDE,0x86,0xE0,
  0x10,0x3E,0xFC,0xE1,0x59,0x4B,0xB4,0xC2,0x4D,0xAE,0xFB,0x68,0xA0,0xAB,0x05,0x9E,
  0x16,0xE3,0x3D,0x17,0xE7,0x99,0x58,0xE5,0x3B,0x96,0x83,0x02,0xEC,0xB2,0x6F,0x41,
  0xA7,0x98,0xE2,0x68,0x18,0xBB,0xE5,0xA6,0x60,0x6E,0x1F,0x55,0x52,0xEB,0x8D,0x96,
  0x30,0x91,0xB6,0x47,0xA1,0x6E,0xF9,0x76,0xE6,0x17,0xA6,0xC3,0xC7,0xB2,0xD5,0x9B,
  0x3E,0xBA,0xC1,0x07,0xC8,0x9C,0x86,0x5A,0xFE,0x96,0xB7,0x78,0x79,0x03,0x93,0x4F,
  0x09,0xED,0xD2,0x5A,0xFB,0x28,0xA0,0x38,0x9F,0x6B,0x82,0x00,0x15,0x21,0xDF,0xAE,
  0x98,0x84,0x16,0x97,0x2A,0x85,0xCD,0x93,0x0B,0x5B,0x48,0x0A,0xB6,0x80,0xFD,0xE2,
  0x84,0x56,0xBA,0xD9,0xE0,0x7A,0x9F,0x15,0x1A,0x88,0x68,0x5D,0x19,0x85,0x45,0xDC,
  0xB6,0x09,0xE0,0xF5,0xED,0xFB,0x25,0x83,0x20,0x3E,0x4F,0xA0,0xE0,0x95,0x81,0x1E,
  0x6E,0xA0,0x7C,0xBE,0x67,0x05,0xCE,0x1E,0xE5,0x00,0x7D,0xA2,0x1C,0x70,0x7A,0x86,
  0x16,0x6B,0x54,0xAD,0xA0,0x08,0xF5,0x88,0x31,0x36,0xB9,0xA1,0x2B,0xFF,0x35,0x85,
  0x06,0x49,0xEF,0x78,0x08,0x86,0x75,0xB1,0x3A,0xC2,0x10,0xEC,0x7E,0x83,0x67,0xB0,
  0xC3,0xC8,0x89,0x74,0x41,0xD4,0x7E,0x66,0xAB,0xF4,0x8D,0x30,0x4B,0x2C,0xF2,0xE5,
  0xCA,0xF7,0x9B,0xD3,0x80,0x01,0x7E,0x90,0xF5,0xA2,0x72,0xDE,0xF7,0x08,0x0A,0xAE,
  0xCF,0x09,0xDD,0x62,0x75,0xC1,0x44,0x32,0xCB,0x89,0xCD,0x14,0xF9,0x44,0x65,0x0E,
  0xCF,0x2A,0x22,0x86,0xE7,0x94,0x2F,0xC2,0x4A,0xF9,0x7E,0x9E,0x61,0xA0,0x6E,0xA2,
  0xEA,0xDF,0x61,0x42,0x4F,0x8F,0x6F,0x09,0xB3,0x69,0x07,0xF7,0x33,0x69,0x96,0xB1,
  0x3D,0x64,0x0E,0xCD,0xE6,0x83,0xC6,0x3B,0xDA,0x1B,0x17,0x7C,0x42,0xA6,0xD0,0x2B,
  0x1A,0x2A,0x2A,0x1A,0xE2,0x23,0xBF,0x3F,0xBA,0x18,0xD3,0x7E,0x8C,0x37,0x8E,0xE0,
  0x62,0xCD,0x60,0xFC,0x91,0xA1,0xBC,0x66,0x18,0x26,0x67,0x33,0x78,0xF3,0xC6,0x0D,
  0x98,0xDC,0xDD,0x09,0x3F,0x7C,0xCE,0x1A,0xA5,0xCF,0x12,0xCD,0xB0,0x48,0xAE,0xA2,
  0x8C,0x36,0x1A,0x75,0x45,0xD4,0x99,0x79,0x6E,0xC3,0x01,0xBC,0xBB,0x8B,0xC7,0xC7,
  0x51,0xC5,0xE5,0xAF,0x5A,0x85,0xA1,0xE5,0xFE,0x45,0x56,0xC1,0x8E,0xEE,0xB5,0xD0,
  0x77,0xC4,0xA7,0x41,0xD9,0x51,0xC7,0xC4,0x42,0x63,0x9A,0x7B,0x7B,0x11,0x5E,0x1A,
  0x08,0x4B,0x7B,0xEA,0x62,0xFF,0x48,0x07,0x95,0x34,0x76,0x00,0x7D,0xD7,0xEB,0x7F,
  0x0D,0x31,0x44,0xF6,0xE4,0x86,0xEE,0x00,0xFE,0x21,0x6C,0xF7,0xEA,0x25,0x6A,0xEC,
  0xE6,0x3B,0xB9,0x42,0x73,0xCB,0x6D,0x78,0x7C,0x9F,0xAB,0xA4,0xDA,0xC7,0x46,0x6B,
  0x78,0x1B,0x6E,0x49,0xCD,0x68,0x36,0x81,0x5D,0x7B,0xEC,0x41,0x92,0x51,0x1C,0x70,
  0xC9,0x89,0x19,0x41,0x1D,0xA8,0x0C,0x42,0xC3,0xCC,0x7A,0x44,0xDA,0x49,0x25,0x37,
  0xDA,0x01,0x7E,0xCF,0xB7,0x20,0x1F,0x7E,0x05,0x38,0xE5,0xF8,0xDF,0x2B,0xE6,0x2A,
  0x83,0x3B,0xDA,0x51,0xAE,0x04,0x4D,0xCF,0x0F,0x2B,0x85,0x01,0xED,0xF2,0xA7,0x13,
  0x55,0xB5,0x66,0x90,0xD2,0x4D,0xB9,0xA9,0x69,0x9A,0x3C,0xE5,0xC3,0x13,0x63,0x98,
  0xE5,0x50,0xC1,0x9F,0x6E,0xD4,0x88,0xD6,0xB4,0xAF,0xBF,0x8B,0x9A,0x1E,0x91,0x13,
  0x90,0xD1,0xA2,0x2A,0xC5,0x56,0x58,0x35,0x81,0x31,0xE7,0x13,0xC7,0x67,0x0C,0xFB,
  0xC8,0xED,0x1B,0x9C,0x30,0x07,0xA4,0x80,0x2C,0x90,0xDB,0x23,0x8D,0x2D,0x0E,0x4A,
  0x08,0x29,0x54,0xF1,0x70,0x38,0xD3,0x8F,0xF8,0x8B,0x1D,0x3D,0xED,0x74,0x0E,0x4D,
  0xA3,0xC4,0xC2,0xAC,0x03,0xF4,0xE2,0x89,0x2C,0x22,0xFD,0x34,0x7A,0x34,0xA7,0x54,
  0x23,0x9C,0x0B,0x9E,0x12,0x1A,0x8A,0x8F,0x1A,0x8C,0xA4,0xA5,0xE9,0x67,0x93,0xB7,
  0x81,0x8E,0x80,0xC9,0x6B,0x61,0x47,0x13,0x46,0xCB,0xC5,0x4E,0x3A,0x9E,0x14,0xC3,
  0xE4,0xC9,0x1A,0x50,0x69,0x6F,0x3A,0x88,0x39,0x32,0x92,0x77,0x50,0x3D,0x9F,0xC4,
  0x8F,0x46,0xB3,0xEC,0xB4,0xDD,0xE9,0xC1,0x55,0xF7,0x58,0x47,0x55,0x3C,0x54,0x7C,
  0x77,0xE1,0xC1,0x20,0x4D,0x42,0x4D,0x11,0x53,0xF7,0x8F,0x38,0xCF,0xD0,0xC3,0x09,
  0x2B,0x00,0xBF,0xF4,0xEA,0x28,0x0E,0x06,0xE0,0x58,0xFB,0x72,0x17,0xF3,0x33,0xFD,
  0xDD,0x15,0xFF,0x6E,0x7C,0x7F,0x77,0x4C,0xF8,0xA2,0x98,0xBD,0x4E,0xB0,0xF2,0x84,
  0x33,0x4E,0x1B,0x54,0x7C,0x60,0x92,0x4E,0xD2,0xBA,0x3F,0xF5,0x47,0xDB,0xF9,0x5F,
  0xC3,0x91,0x5A,0xB9,0xD0,0x54,0x8D,0xAB,0x89,0x72,0xFB,0x48,0x90,0x51,0xB8,0x2F,
  0x66,0x76,0x3E,0xC9,0xD8,0xDE,0x81,0x7D,0x83,0xB0,0x9C,0xC1,0x40,0x82,0x04,0x1D,
  0xA8,0x38,0xF9,0xBC,0x56,0x38,0xB3,0xDE,0xC1,0x70,0xCB,0x09,0x64,0x49,0xBE,0x81,
  0x02,0x0F,0x8F,0xD0,0x9D,0x30,0x87,0xE4,0x10,0xDC,0x36,0x20,0xB8,0xCC,0x6B,0x06,
  0x6E,0xDE,0xA0,0x57,0x58,0xFB,0xD9,0x2D,0xC2,0x5F,0x08,0x67,0x13,0x77,0x18,0x39,
  0xF1,0x1B,0xBE,0x30,0xF3,0x34,0x7F,0x77,0xB0,0x14,0xAB,0x79,0x02,0x93,0x26,0xF4,
  0x05,0xC4,0x9B,0x86,0xA9,0x67,0x29,0x07,0x35,0x61,0x0D,0x3D,0x28,0x20,0xD1,0x99,
  0xC4,0xFC,0x2E,0x9D,0x0E,0x3A,0x13,0x3A,0x5E,0x28,0xA6,0x43,0x50,0x60,0x2A,0x2F,
  0x39,0x13,0x62,0x4E,0xDB,0x92,0x90,0x8A,0xF2,0xB7,0xFA,0x91,0x26,0x42,0x4E,0x90,
  0x42,0x11,0xB5,0x06,0x65,0x88,0xE6,0xCB,0xB1,0x61,0x27,0x80,0xC1,0xE5,0xB6,0xD5,
  0x37,0xDE,0x04,0x15,0xBD,0x83,0xBD,0x32,0x6B,0xA3,0xAB,0x56,0x3F,0x82,0x13,0x1C,
  0xDA,0x15,0x00,0x3E,0xAA,0x24,0xC9,0xB0,0x2C,0x97,0x9D,0x79,0x6A,0x10,0xC9,0x0C,
  0x00,0x25,0x5A,0x47,0x3D,0x39,0xD3,0xBF,0x53,0x83,0x9B,0xC1,0xDD,0x8F,0x8B,0x2E,
  0x4D,0x0B,0xA6,0xAB,0xE5,0x78,0x2A,0x12,0x14,0x54,0xE8,0x25,0xE5,0x44,0xC7,0x5B},
  /*data input size*/
  {1024},
  /*size of Q field in control block*/
  {8},
  /*Nonce*/
  {0xB6,0x4C,0xD3,0x6E,0xE0,0x05,0x6C},
  /*size of N buffer*/
  {7},
  /*size of CCM-MAC (T) */
  {16},
  /* output data*/
  {0},
  /* output data size*/
  {1040},
  /*expected data */
  {0x1A,0xD1,0x39,0x4E,0xAD,0x99,0xA7,0x88,0x45,0xE4,0x58,0x6A,0x44,0x38,0x85,0x2B,
  0x55,0xD6,0x59,0x54,0x4D,0xE6,0x61,0xA1,0xC4,0x82,0xD9,0x17,0xA3,0x24,0x24,0x42,
  0xE5,0xBA,0xB2,0x86,0xA4,0x9A,0x43,0x70,0x1A,0xC1,0xF8,0x95,0x65,0x3F,0x4B,0x09,
  0xA8,0xCA,0x94,0xDC,0xE1,0x77,0x06,0xFE,0xCE,0x9B,0x37,0x70,0x3A,0xF0,0x6A,0x11,
  0x66,0x16,0xF0,0x9A,0x31,0x3C,0x06,0x12,0xA8,0x43,0x8E,0x0B,0xEB,0xF6,0x0E,0x23,
  0xF9,0xC1,0x40,0xA6,0x17,0x7A,0x8D,0xA7,0x7E,0x50,0x0C,0x88,0x50,0xB8,0xE7,0x09,
  0xB9,0x4F,0x64,0x59,0xF7,0xEF,0x52,0x03,0x1C,0x72,0x0D,0xF4,0x95,0xE6,0x9D,0x66,
  0xED,0x04,0xBC,0xE2,0x8E,0x12,0x8B,0x38,0x2B,0x07,0x0A,0xFA,0x1E,0x52,0x91,0xFD,
  0x6B,0x2A,0x9C,0x48,0x06,0xB4,0x73,0x96,0x8D,0x79,0x87,0xA4,0xCA,0xB8,0x32,0x5D,
  0x9D,0x33,0xBC,0xDC,0xEB,0x5C,0x4B,0xBF,0xB8,0x45,0xF7,0x0A,0x1C,0xA6,0x0C,0xF4,
  0x39,0xA2,0xB6,0x85,0x62,0x36,0xBC,0x93,0x08,0x15,0x2D,0x87,0xD3,0x74,0x30,0x74,
  0xE8,0xB8,0x34,0xAE,0xBB,0x74,0xB5,0x16,0xA1,0xDB,0x47,0x60,0x42,0x9F,0xC5,0xFE,
  0xD6,0x09,0xCD,0xCD,0x97,0x9C,0x9A,0xFA,0x5B,0xEC,0x87,0xB2,0xD2,0xA9,0x2E,0xE7,
  0x02,0x62,0x98,0x68,0x37,0xF3,0x72,0x0B,0xDF,0x59,0xED,0x6A,0x54,0x7B,0x78,0xB6,
  0x80,0x9E,0x25,0xD3,0x89,0xAF,0x77,0x19,0xE9,0xED,0xCA,0x8C,0xE4,0x59,0xA9,0xE3,
  0x2E,0xAA,0x94,0x0D,0x24,0x56,0xDF,0x52,0xBB,0x99,0x98,0xE7,0xF0,0xDD,0xC3,0x0F,
  0x18,0x6C,0x27,0xB4,0x39,0x43,0x08,0x62,0x99,0x39,0x2C,0x13,0x5F,0x47,0xA7,0xAB,
  0xA1,0x47,0x16,0x66,0x8C,0xA4,0xC7,0xAB,0x94,0x70,0x7D,0xB7,0xE2,0x52,0x0F,0x90,
  0x21,0xB6,0xFE,0x1E,0xB9,0x07,0xE8,0xE0,0xD3,0x13,0x92,0xB0,0x99,0x6C,0x47,0xCB,
  0x50,0xD5,0xA2,0x1D,0xC1,0xC7,0xDA,0x27,0xBA,0x3A,0x55,0xAC,0xCF,0x32,0x4C,0xA6,
  0x90,0x0A,0xFB,0x13,0x68,0xD6,0x4E,0xA0,0x79,0x98,0x2F,0x48,0x46,0x2A,0x3E,0x62,
  0x15,0xDA,0x43,0x24,0x67,0x71,0x4A,0x6A,0x77,0xFC,0x18,0x2E,0x20,0x56,0xFA,0x69,
  0x51,0x6D,0x21,0xF9,0xBD,0xB9,0x33,0xF1,0x69,0xAC,0x0D,0xFB,0xDA,0x29,0x97,0xE5,
  0xD1,0x5C,0xD4,0xCB,0xD1,0xA4,0xF9,0x5E,0x55,0x83,0x46,0xD2,0x31,0x8B,0xEC,0xEA,
  0xA3,0x54,0x84,0xAA,0xAC,0x0F,0x3B,0x22,0x11,0x72,0xFC,0x13,0xC3,0xE7,0x50,0xE4,
  0x7C,0x66,0x25,0xD7,0x45,0x0F,0x97,0x21,0xD0,0xE2,0xBC,0x03,0x22,0x41,0xFB,0xB7,
  0x1D,0x47,0x78,0xB1,0x63,0xEE,0xD5,0x40,0x03,0x60,0xCB,0xF8,0xEC,0x58,0xE9,0x43,
  0x7A,0x1E,0xE0,0xDB,0x07,0xC0,0xC1,0x48,0x7A,0xCE,0x54,0x50,0x59,0x9E,0x17,0x88,
  0x0D,0x63,0xFD,0xA2,0xFA,0x34,0x08,0x9B,0x52,0xC0,0x96,0x94,0x04,0x3E,0x65,0xE5,
  0x97,0x02,0xB6,0x06,0xED,0x5A,0x9A,0x9D,0x5F,0xE1,0x33,0x83,0x89,0x00,0x4A,0x2C,
  0xDA,0x97,0xDF,0xBB,0xF0,0x6C,0x31,0xE5,0x1A,0x6F,0xCA,0xEA,0xD6,0xFC,0xC1,0xBD,
  0x0A,0x42,0xBB,0x7E,0xD0,0x10,0xDC,0xD3,0x2F,0xA9,0xBC,0x1B,0x76,0xA1,0x6B,0x9E,
  0x41,0xD0,0xC9,0x10,0x81,0xDA,0x19,0x30,0xA0,0x8F,0xDB,0x0F,0x0D,0x32,0xA0,0x11,
  0x19,0x45,0x10,0xB5,0xD8,0x5F,0x9A,0xF6,0x2C,0x82,0xBE,0x07,0x34,0x4A,0x0A,0xF7,
  0x0E,0x79,0x84,0x16,0xA6,0x30,0x2F,0xE5,0x8B,0x2C,0xFE,0xE1,0xFD,0xE4,0xE2,0x05,
  0xD9,0x95,0x66,0xF3,0x51,0xEF,0xB3,0x6C,0xD3,0x7F,0x1C,0xA3,0x9B,0x18,0xC4,0x8A,
  0x12,0x75,0x65,0xBF,0xB2,0xF1,0x76,0xE6,0x12,0x9B,0xED,0x92,0xE6,0x3D,0x15,0xB1,
  0xBD,0xCF,0x7B,0x13,0x70,0x3D,0x62,0x5B,0x9B,0xF6,0x29,0x86,0xEE,0x8F,0xB5,0x7E,
  0xD5,0x82,0x89,0x80,0xC5,0x93,0x8F,0x0B,0x20,0x61,0x49,0x46,0xF1,0x9E,0x5F,0x2A,
  0xE1,0xD3,0xD2,0x09,0x66,0x29,0x38,0x1B,0x02,0xA5,0x4C,0x8B,0xFF,0xF6,0x5F,0x47,
  0x9A,0x41,0x4A,0x97,0xA1,0x38,0xF0,0xF6,0x96,0x8A,0x62,0x02,0x88,0xCB,0x53,0x51,
  0xBB,0x87,0xBC,0x3B,0xE5,0xF8,0xE1,0xE3,0xDC,0x75,0xCC,0xD9,0xCE,0xA9,0xE9,0x93,
  0xE2,0x5A,0x5B,0x9E,0x3E,0x9D,0x36,0x13,0xAC,0xE8,0xC0,0x84,0x07,0x91,0x53,0x8C,
  0x47,0xBA,0x55,0x70,0xB1,0x60,0x63,0x6B,0x05,0xBF,0xFD,0x69,0x7E,0x81,0xD2,0x9C,
  0x18,0x98,0x46,0x82,0xDE,0x2D,0x6F,0x28,0x58,0xDB,0xE4,0x4B,0xB1,0x5C,0x0A,0x8A,
  0x70,0xF8,0xDF,0x37,0xF1,0xC2,0x11,0x34,0x06,0x60,0x95,0x1E,0xAF,0x99,0x0E,0x99,
  0x00,0xCE,0x3C,0x95,0xA1,0xBF,0x36,0xCC,0xCB,0xC6,0x02,0x0D,0xEE,0xD5,0xAF,0xFF,
  0x92,0x3B,0x85,0xE5,0x33,0xF3,0xD4,0x26,0xD4,0x65,0x3E,0x70,0x3C,0xA1,0xC0,0xBB,
  0x51,0x7C,0x4C,0xF0,0x64,0xB0,0x6F,0xC1,0xED,0xFE,0xAC,0xD5,0xD8,0x17,0x3D,0xAF,
  0xEA,0xE9,0xC4,0x25,0xD9,0x02,0x9C,0x04,0x02,0xD6,0xAE,0x62,0x07,0x93,0xCE,0x06,
  0x62,0xAB,0x6F,0x3A,0x31,0x39,0xD2,0xE1,0x1D,0x07,0xC6,0x7F,0x56,0x77,0xF3,0x19,
  0x09,0xD9,0x3B,0x09,0x38,0x40,0x96,0x0A,0x05,0xE3,0x96,0xBF,0x84,0x06,0x9E,0xCD,
  0x17,0x5E,0xAF,0xE9,0xAE,0xB8,0x12,0x3F,0xB5,0x3F,0x3E,0x03,0x2A,0x6A,0x06,0xEB,
  0x35,0x8F,0x8C,0xA0,0xCB,0xE2,0x48,0x49,0x05,0x22,0x02,0xFF,0x10,0x59,0x6D,0xF6,
  0x56,0x74,0x1B,0xCA,0xFB,0x83,0x2C,0x1A,0x45,0x6A,0x41,0x4D,0x47,0x43,0x70,0xD2,
  0xEF,0xF8,0xC8,0x50,0xA7,0x59,0x5D,0x36,0xCB,0xEC,0x56,0x92,0x77,0xB0,0x21,0x1A,
  0xDA,0x1F,0x38,0x97,0x97,0x58,0xFD,0x25,0x3D,0xB3,0xA9,0x71,0x7B,0x41,0xB7,0x24,
  0xE6,0x42,0x0B,0x86,0x6A,0x0C,0xA7,0x37,0x66,0xF0,0xC9,0xDA,0xFB,0xA5,0x13,0xEC,
  0xD5,0x64,0x7D,0x47,0xC1,0x47,0xFF,0x15,0xDD,0xF3,0xEE,0x9F,0x76,0xFD,0x52,0x42,
  0xBB,0x34,0x7D,0x3E,0xF2,0x45,0xCB,0x15,0x5A,0x94,0x05,0x79,0x85,0xB3,0xEE,0x25,
  0x3B,0x81,0xBE,0x80,0x4F,0xDF,0xD7,0x8D,0xB1,0x60,0x02,0xD2,0x7F,0x97,0xD1,0xDD,
  0x0C,0x49,0x79,0xFA,0x1B,0x6B,0x4D,0xE9,0x6F,0xC8,0x4F,0x70,0xB7,0x08,0x61,0x93,
  0x3E,0x9C,0xBD,0xCD,0x9C,0xB3,0x47,0x0E,0x67,0xB9,0x05,0x9B,0x50,0xC3,0x85,0x68,
  0x8F,0x17,0x2C,0x46,0x62,0x07,0x26,0x19,0x19,0x39,0xB6,0x79,0xDA,0x49,0xF0,0x9F,
  0x53,0xF9,0xA6,0xB3,0x0B,0xD6,0x76,0x72,0x39,0x22,0xCC,0x11,0x44,0xE3,0x6D,0xEB},
  {0},
},

};
#endif /*CRYS_NO_AESCCM_SUPPORT*/



const int TST_NumberOf_AES_AcceptanceTests      = sizeof(TST_AES_Acceptance_TestData)/sizeof(TST_AES_Acceptance_TestData[0]);
const int TST_NumberOfMACAcceptanceTests        = sizeof(TST_AES_MAC_Acceptance_TestData)/sizeof(TST_AES_MAC_Acceptance_TestData[0]);
const int TST_NumberOfXCBCMACAcceptanceTests    = sizeof(TST_AES_XCBC_CMAC_Acceptance_TestData)/sizeof(TST_AES_XCBC_CMAC_Acceptance_TestData[0]);
const int TST_NumberOfKeyWrapAcceptanceTests    = sizeof(TST_ARS_KeyWrap_Acceptance_TestData)/sizeof(TST_ARS_KeyWrap_Acceptance_TestData[0]);
const int TST_NumberOf_AES_XTS_AcceptanceTests  = sizeof(TST_AES_XTS_Acceptance_TestData)/sizeof(TST_AES_XTS_Acceptance_TestData[0]);
#ifndef CRYS_NO_AESCCM_SUPPORT
const int TST_NumberOfAESCCMAcceptanceTests     = sizeof(TST_AES_CCM_Acceptance_TestData)/sizeof(TST_AES_CCM_Acceptance_TestData[0]);
#endif /*CRYS_NO_AESCCM_SUPPORT*/

#if TST_USE_PREDEFINED_SECRETKEY_TESTS
const int TST_NumberOf_AES_AcceptanceTestsSK    = sizeof(TST_AES_Acceptance_SK_TestData)/sizeof(TST_AES_Acceptance_SK_TestData[0]);
#endif

#endif

